/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.IDebugProcessWithId;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentSessionId", "Lcom/jetbrains/rd/util/reactive/ISource;", "Lcom/jetbrains/rider/debugger/IDebugProcessWithId;", "getCurrentSessionId", "()Lcom/jetbrains/rd/util/reactive/ISource;", "dotNetDebugProcessSet", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "dotNetDebugProcesses", "Lcom/jetbrains/rd/util/reactive/IViewableSet;", "getDotNetDebugProcesses", "()Lcom/jetbrains/rd/util/reactive/IViewableSet;", "hasActiveDotNetDebugSessions", "", "getHasActiveDotNetDebugSessions", "()Z", "myCurrentSessionId", "Lcom/jetbrains/rd/util/reactive/Property;", "j", "", "j", "newSession", "Lcom/intellij/xdebugger/XDebugSession;", "j", "debugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "N", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderDebugActiveDotNetSessionsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebugActiveDotNetSessionsTracker.kt\ncom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,93:1\n13309#2,2:94\n*S KotlinDebug\n*F\n+ 1 RiderDebugActiveDotNetSessionsTracker.kt\ncom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker\n*L\n38#1:94,2\n*E\n"})
public final class RiderDebugActiveDotNetSessionsTracker
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewableSet<DotNetDebugProcess> dotNetDebugProcessSet;
    @NotNull
    private final Property<IDebugProcessWithId> myCurrentSessionId;

    public RiderDebugActiveDotNetSessionsTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.dotNetDebugProcessSet = new ViewableSet(null, 1, null);
        this.myCurrentSessionId = new Property(null);
        this.j(project);
    }

    @NotNull
    public final IViewableSet<DotNetDebugProcess> getDotNetDebugProcesses() {
        return (IViewableSet)this.dotNetDebugProcessSet;
    }

    public final boolean getHasActiveDotNetDebugSessions() {
        return CollectionsKt.any((Iterable)((Iterable)this.getDotNetDebugProcesses()));
    }

    @NotNull
    public final ISource<IDebugProcessWithId> getCurrentSessionId() {
        return (ISource)this.myCurrentSessionId;
    }

    private final void j(Project project) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)project).getDebugSessions();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
        Object[] objectArray = xDebugSessionArray;
        boolean bl = false;
        for (Object object : objectArray) {
            XDebugSession xDebugSession = (XDebugSession)object;
            boolean bl2 = false;
            XDebugProcess xDebugProcess = xDebugSession.getDebugProcess();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugProcess, (String)"getDebugProcess(...)");
            this.j(xDebugProcess);
        }
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new XDebuggerManagerListener(this){
            final /* synthetic */ RiderDebugActiveDotNetSessionsTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void processStarted(@NotNull XDebugProcess debugProcess) {
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                RiderDebugActiveDotNetSessionsTracker.access$onDebugProcessStarted(this.this$0, debugProcess);
            }

            public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
                RiderDebugActiveDotNetSessionsTracker.access$onCurrentSessionChanged(this.this$0, currentSession);
            }

            public void processStopped(@NotNull XDebugProcess debugProcess) {
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                RiderDebugActiveDotNetSessionsTracker.access$onDebugProcessTerminated(this.this$0, debugProcess);
            }
        });
        MessageBusConnection messageBusConnection2 = project.getMessageBus().connect((Disposable)project);
        Topic topic2 = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)new AnActionListener(this){
            final /* synthetic */ RiderDebugActiveDotNetSessionsTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = ActionManager.getInstance().getId(action2);
                if (Intrinsics.areEqual((Object)string, (Object)"Stop")) {
                    Project project = event.getProject();
                    if (project == null) {
                        return;
                    }
                    Project project2 = project;
                    XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
                    if (xDebugSession != null) {
                        XDebugProcess xDebugProcess = xDebugSession.getDebugProcess();
                        Intrinsics.checkNotNullExpressionValue((Object)xDebugProcess, (String)"getDebugProcess(...)");
                        RiderDebugActiveDotNetSessionsTracker.access$onDebugProcessTerminated(this.this$0, xDebugProcess);
                    }
                }
            }
        });
    }

    private final void j(XDebugProcess xDebugProcess) {
        if (!(xDebugProcess instanceof DotNetDebugProcess)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> RiderDebugActiveDotNetSessionsTracker.N(this, xDebugProcess));
    }

    private final void j(XDebugSession xDebugSession) {
        XDebugSession xDebugSession2 = xDebugSession;
        XDebugProcess xDebugProcess = xDebugSession2 != null ? xDebugSession2.getDebugProcess() : null;
        IDebugProcessWithId iDebugProcessWithId = xDebugProcess instanceof IDebugProcessWithId ? (IDebugProcessWithId)xDebugProcess : null;
        UIUtil.invokeLaterIfNeeded(() -> RiderDebugActiveDotNetSessionsTracker.j(this, iDebugProcessWithId));
    }

    private final void N(XDebugProcess xDebugProcess) {
        if (!(xDebugProcess instanceof DotNetDebugProcess)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> RiderDebugActiveDotNetSessionsTracker.j(this, xDebugProcess));
    }

    private static final void N(RiderDebugActiveDotNetSessionsTracker riderDebugActiveDotNetSessionsTracker, XDebugProcess xDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderDebugActiveDotNetSessionsTracker), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)xDebugProcess, (String)"$debugProcess");
        CollectionExKt.addUnique((Collection)((Collection)riderDebugActiveDotNetSessionsTracker.dotNetDebugProcessSet), (Lifetime)((DotNetDebugProcess)xDebugProcess).getSessionLifetime(), (Object)xDebugProcess);
    }

    private static final void j(RiderDebugActiveDotNetSessionsTracker riderDebugActiveDotNetSessionsTracker, IDebugProcessWithId iDebugProcessWithId) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderDebugActiveDotNetSessionsTracker), (String)"this$0");
        riderDebugActiveDotNetSessionsTracker.myCurrentSessionId.set((Object)iDebugProcessWithId);
    }

    private static final void j(RiderDebugActiveDotNetSessionsTracker riderDebugActiveDotNetSessionsTracker, XDebugProcess xDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderDebugActiveDotNetSessionsTracker), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)xDebugProcess, (String)"$debugProcess");
        riderDebugActiveDotNetSessionsTracker.dotNetDebugProcessSet.remove((Object)xDebugProcess);
    }

    public static final /* synthetic */ void access$onDebugProcessStarted(RiderDebugActiveDotNetSessionsTracker $this, XDebugProcess debugProcess) {
        $this.j(debugProcess);
    }

    public static final /* synthetic */ void access$onCurrentSessionChanged(RiderDebugActiveDotNetSessionsTracker $this, XDebugSession newSession2) {
        $this.j(newSession2);
    }

    public static final /* synthetic */ void access$onDebugProcessTerminated(RiderDebugActiveDotNetSessionsTracker $this, XDebugProcess debugProcess) {
        $this.N(debugProcess);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderDebugActiveDotNetSessionsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebugActiveDotNetSessionsTracker.kt\ncom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,93:1\n17#2,2:94\n*S KotlinDebug\n*F\n+ 1 RiderDebugActiveDotNetSessionsTracker.kt\ncom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker$Companion\n*L\n24#1:94,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderDebugActiveDotNetSessionsTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Object object = componentManager.getService(RiderDebugActiveDotNetSessionsTracker.class);
            if (object == null) {
                throw new IllegalStateException("Service " + RiderDebugActiveDotNetSessionsTracker.class + " not found in container " + componentManager);
            }
            return (RiderDebugActiveDotNetSessionsTracker)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

