/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.debugger.Builder;
import com.jetbrains.rider.debugger.ContentTypeConverter;
import com.jetbrains.rider.debugger.statistics.VisualizerContentType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/debugger/JsonBuilder;", "Lcom/jetbrains/rider/debugger/Builder;", "project", "Lcom/intellij/openapi/project/Project;", "value", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "key", "getKey", "()Ljava/lang/String;", "prettified", "getPrettified", "prettyTabName", "getPrettyTabName", "visualizerContentType", "Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "getVisualizerContentType", "()Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "intellij.rider"})
final class JsonBuilder
extends Builder {
    @NotNull
    private final VisualizerContentType visualizerContentType;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final String prettyTabName;
    @NotNull
    private final String prettified;

    public JsonBuilder(@NotNull Project project, @NlsSafe @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(project, value);
        this.visualizerContentType = VisualizerContentType.JSON;
        JsonFileType jsonFileType = JsonFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)jsonFileType, (String)"INSTANCE");
        this.fileType = (FileType)jsonFileType;
        this.prettyTabName = "JSON";
        this.prettified = new ContentTypeConverter().prettifyJson(value);
    }

    @Override
    @NotNull
    public VisualizerContentType getVisualizerContentType() {
        return this.visualizerContentType;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    @NotNull
    public String getPrettyTabName() {
        return this.prettyTabName;
    }

    @Override
    @NotNull
    public String getKey() {
        return "Rider.Visualizers.JsonBuilder";
    }

    @Override
    @NotNull
    public String getPrettified() {
        return this.prettified;
    }
}

