/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.platform.util.ComponentsKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0019\u0010\u0005\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/JCTDebuggerTempProjectCleaner;", "", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "(Lcom/intellij/util/messages/MessageBus;)V", "openedProjectPaths", "", "", "Lorg/jetbrains/annotations/SystemIndependent;", "addProject", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nJCTDebuggerTempProjectCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JCTDebuggerTempProjectCleaner.kt\ncom/jetbrains/rider/debugger/JCTDebuggerTempProjectCleaner\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n13#2:65\n13#3:66\n*S KotlinDebug\n*F\n+ 1 JCTDebuggerTempProjectCleaner.kt\ncom/jetbrains/rider/debugger/JCTDebuggerTempProjectCleaner\n*L\n48#1:65\n48#1:66\n*E\n"})
public final class JCTDebuggerTempProjectCleaner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> openedProjectPaths;
    @NotNull
    private static final Logger logger;

    public JCTDebuggerTempProjectCleaner(@NotNull MessageBus messageBus) {
        Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
        this.openedProjectPaths = new LinkedHashSet();
        MessageBusConnection messageBusConnection = messageBus.connect();
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                for (String string : openedProjectPaths) {
                    Companion.j(string);
                }
                String string = Companion.j(project);
                if (openedProjectPaths.contains(string)) {
                    Companion.getLogger().info("Closing jit debugger project: \"" + (String)string + "\"");
                    openedProjectPaths.remove(string);
                }
            }
        });
        ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)ApplicationKt.getApplication())).onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                for (String string : openedProjectPaths) {
                    Companion.j(string);
                }
            }
        });
    }

    public final void addProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = JCTDebuggerTempProjectCleaner.Companion.j(project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getProjectPath(...)");
        this.openedProjectPaths.add(string);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(JCTDebuggerTempProjectCleaner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u000b\u0010\u0011\u001a\u00070\b\u00a2\u0006\u0002\b\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/JCTDebuggerTempProjectCleaner$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "projectPath", "", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/project/Project;", "j", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/String;", "getInstance", "Lcom/jetbrains/rider/debugger/JCTDebuggerTempProjectCleaner;", "j", "", "path", "Lorg/jetbrains/annotations/SystemIndependent;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nJCTDebuggerTempProjectCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JCTDebuggerTempProjectCleaner.kt\ncom/jetbrains/rider/debugger/JCTDebuggerTempProjectCleaner$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,64:1\n40#2,3:65\n*S KotlinDebug\n*F\n+ 1 JCTDebuggerTempProjectCleaner.kt\ncom/jetbrains/rider/debugger/JCTDebuggerTempProjectCleaner$Companion\n*L\n50#1:65,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final JCTDebuggerTempProjectCleaner getInstance() {
            boolean bl = false;
            Class<JCTDebuggerTempProjectCleaner> clazz = JCTDebuggerTempProjectCleaner.class;
            Object object = ApplicationManager.getApplication().getService(clazz);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JCTDebuggerTempProjectCleaner)object;
        }

        private final String j(Project project) {
            return PathUtil.toSystemIndependentName((String)project.getPresentableUrl());
        }

        private final void j(String string) {
            RecentProjectsManager recentProjectsManager = RecentProjectsManager.Companion.getInstance();
            boolean bl = false;
            if (recentProjectsManager.hasPath(string)) {
                Companion.getLogger().info("Jit debugger project is removing from recent projects: \"" + string + "\"");
                recentProjectsManager.removePath(string);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

