/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBScrollPane;
import com.jetbrains.rider.debugger.Builder;
import com.jetbrains.rider.debugger.statistics.VisualizerContentType;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/debugger/HtmlBuilder;", "Lcom/jetbrains/rider/debugger/Builder;", "project", "Lcom/intellij/openapi/project/Project;", "value", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "key", "getKey", "()Ljava/lang/String;", "prettyTabName", "getPrettyTabName", "visualizerContentType", "Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "getVisualizerContentType", "()Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "browser", "Ljavax/swing/JComponent;", "prettyView", "intellij.rider"})
final class HtmlBuilder
extends Builder {
    @NotNull
    private final VisualizerContentType visualizerContentType;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final String prettyTabName;

    public HtmlBuilder(@NotNull Project project, @NlsSafe @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(project, value);
        this.visualizerContentType = VisualizerContentType.HTML;
        HtmlFileType htmlFileType = HtmlFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)htmlFileType, (String)"INSTANCE");
        this.fileType = (FileType)htmlFileType;
        this.prettyTabName = "HTML";
    }

    @Override
    @NotNull
    public VisualizerContentType getVisualizerContentType() {
        return this.visualizerContentType;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    @NotNull
    public String getPrettyTabName() {
        return this.prettyTabName;
    }

    @Override
    @NotNull
    public String getKey() {
        return "Rider.Visualizers.HTMLBuilder";
    }

    @Override
    @NotNull
    public JComponent prettyView() {
        return this.browser();
    }

    @NotNull
    public final JComponent browser() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(this.getValue());
        return (JComponent)new JBScrollPane((Component)jEditorPane);
    }
}

