/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.parallelStacks.threads.StackFramesCalculator;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J&\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/DotNetStackFramesCalculator;", "Lcom/intellij/xdebugger/impl/parallelStacks/threads/StackFramesCalculator;", "()V", "getStackFramesAsync", "Lorg/jetbrains/concurrency/Promise;", "", "Lcom/intellij/xdebugger/frame/XStackFrame;", "stack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getThreadsAsync", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "intellij.rider"})
public final class DotNetStackFramesCalculator
extends StackFramesCalculator {
    @NotNull
    public static final DotNetStackFramesCalculator INSTANCE = new DotNetStackFramesCalculator();

    private DotNetStackFramesCalculator() {
    }

    @NotNull
    protected Promise<List<XExecutionStack>> getThreadsAsync(@NotNull XSuspendContext suspendContext, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        AsyncPromise asyncPromise = new AsyncPromise();
        DotnetDebuggerExtKt.getAsDotNetOrThrow(suspendContext).getExecutionStacksAsync().processed((Promise)asyncPromise);
        return (Promise)asyncPromise;
    }

    @NotNull
    protected Promise<List<XStackFrame>> getStackFramesAsync(@NotNull XExecutionStack stack, @Nullable ProgressIndicator indicator) {
        Promise promise2;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack instanceof DotNetExecutionStack) {
            AsyncPromise asyncPromise = new AsyncPromise();
            ((DotNetExecutionStack)stack).getFramesAsync().processed((Promise)asyncPromise);
            promise2 = (Promise)asyncPromise;
        } else {
            promise2 = super.getStackFramesAsync(stack, indicator);
        }
        return promise2;
    }
}

