/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/debugger/DotNetSourcePositionWrapper;", "Lcom/intellij/xdebugger/XSourcePositionWrapper;", "Lcom/intellij/xdebugger/impl/ui/ExecutionPointHighlighter$HighlighterProvider;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "positionProxy", "Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "(Lcom/intellij/xdebugger/XSourcePosition;Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;)V", "endOffset", "", "getEndOffset", "()I", "location", "", "getLocation", "()Ljava/lang/String;", "getPositionProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "document", "Lcom/intellij/openapi/editor/Document;", "startOffset", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetSourcePositionWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetSourcePositionWrapper.kt\ncom/jetbrains/rider/debugger/DotNetSourcePositionWrapper\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n13#2:110\n13#3:111\n*S KotlinDebug\n*F\n+ 1 DotNetSourcePositionWrapper.kt\ncom/jetbrains/rider/debugger/DotNetSourcePositionWrapper\n*L\n24#1:110\n24#1:111\n*E\n"})
public final class DotNetSourcePositionWrapper
extends XSourcePositionWrapper
implements ExecutionPointHighlighter.HighlighterProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SourcePositionProxy positionProxy;
    @Nullable
    private final XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint;
    @NotNull
    private static final Logger logger;

    public DotNetSourcePositionWrapper(@NotNull XSourcePosition position, @NotNull SourcePositionProxy positionProxy, @Nullable XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)positionProxy, (String)"positionProxy");
        super(position);
        this.positionProxy = positionProxy;
        this.breakpoint = breakpoint;
    }

    public /* synthetic */ DotNetSourcePositionWrapper(XSourcePosition xSourcePosition, SourcePositionProxy sourcePositionProxy, XLineBreakpoint xLineBreakpoint, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            xLineBreakpoint = null;
        }
        this(xSourcePosition, sourcePositionProxy, (XLineBreakpoint<DotNetLineBreakpointProperties>)xLineBreakpoint);
    }

    @NotNull
    public final SourcePositionProxy getPositionProxy() {
        return this.positionProxy;
    }

    @NotNull
    public final String getLocation() {
        return this.positionProxy.getFilename();
    }

    public final int getEndOffset() {
        Document document2 = FileDocumentManager.getInstance().getDocument(this.getFile());
        if (document2 == null) {
            return -1;
        }
        Document document3 = document2;
        if (this.positionProxy.getEndLine() < 0 || this.positionProxy.getEndColumn() < 0) {
            return -1;
        }
        int n = Math.min(document3.getLineStartOffset(this.positionProxy.getEndLine()) + this.positionProxy.getEndColumn(), document3.getLineEndOffset(this.positionProxy.getEndLine()));
        if (n >= document3.getTextLength()) {
            return -1;
        }
        return n;
    }

    @Nullable
    public TextRange getHighlightRange() {
        if (this.positionProxy.getLine() < 0 || this.positionProxy.getColumn() < 0) {
            logger.debug("Source position is incomplete or invalid to create range: " + IPrintableKt.printToString((Object)this.positionProxy));
            return null;
        }
        return (TextRange)ApplicationKt.getApplication().runReadAction(() -> DotNetSourcePositionWrapper.j(this));
    }

    private final int j(Document document2, int n) {
        int n2;
        int n3 = this.positionProxy.getEndLine() >= 0 && this.positionProxy.getEndColumn() >= 0 ? Math.min(document2.getLineStartOffset(this.positionProxy.getEndLine()) + this.positionProxy.getEndColumn(), document2.getLineEndOffset(this.positionProxy.getEndLine())) : (n2 = document2.getLineCount() - 1 <= this.positionProxy.getLine() ? document2.getTextLength() - 1 : document2.getLineStartOffset(this.positionProxy.getLine() + 1) - 1);
        if (n2 < n) {
            n2 = n;
        }
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        while (n2 > n && n2 < string2.length() && CharsKt.isWhitespace((char)string2.charAt(n2 - 1))) {
            --n2;
        }
        return n2;
    }

    private static final TextRange j(DotNetSourcePositionWrapper dotNetSourcePositionWrapper) {
        Intrinsics.checkNotNullParameter((Object)((Object)dotNetSourcePositionWrapper), (String)"this$0");
        if (dotNetSourcePositionWrapper.getFile() instanceof LightVirtualFile || dotNetSourcePositionWrapper.getFile() instanceof HttpVirtualFile) {
            return null;
        }
        if (!dotNetSourcePositionWrapper.getFile().isValid()) {
            return null;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(dotNetSourcePositionWrapper.getFile());
        if (document2 == null) {
            return null;
        }
        Document document3 = document2;
        if (dotNetSourcePositionWrapper.positionProxy.getLine() >= document3.getLineCount()) {
            logger.error("Start line " + dotNetSourcePositionWrapper.positionProxy.getLine() + " is out of document lines " + document3.getLineCount());
            return null;
        }
        int n = document3.getLineStartOffset(dotNetSourcePositionWrapper.positionProxy.getLine()) + dotNetSourcePositionWrapper.positionProxy.getColumn();
        if (n >= document3.getTextLength()) {
            logger.error("Resulting start offset " + n + " is out of document length " + document3.getTextLength());
            return null;
        }
        if (dotNetSourcePositionWrapper.positionProxy.getEndLine() >= document3.getLineCount()) {
            logger.error("End line " + dotNetSourcePositionWrapper.positionProxy.getEndLine() + " is out of document lines " + document3.getLineCount());
            return null;
        }
        int n2 = dotNetSourcePositionWrapper.j(document3, n);
        if (n2 > document3.getTextLength()) {
            logger.error("Resulting end offset " + n2 + " is out of document length " + document3.getTextLength());
            return null;
        }
        TextRange textRange = new TextRange(n, n2);
        Object object = dotNetSourcePositionWrapper.breakpoint;
        TextRange textRange2 = object != null && (object = (DotNetLineBreakpointProperties)object.getProperties()) != null ? ((DotNetLineBreakpointProperties)((Object)object)).getTextRange() : null;
        return textRange2 != null && !Intrinsics.areEqual((Object)textRange2, (Object)textRange) ? null : textRange;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetSourcePositionWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/debugger/DotNetSourcePositionWrapper$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

