/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.parallelStacks.base.view.FullRowContentProvider;
import com.intellij.xdebugger.impl.parallelStacks.threads.FrameInfo;
import com.jetbrains.rider.debugger.DotNetFramePresenter;
import icons.RiderIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0018H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/debugger/DotNetFrameInfo;", "Lcom/intellij/xdebugger/impl/parallelStacks/threads/FrameInfo;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "stack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "threadId", "", "methodName", "", "typeName", "isNonUserCode", "", "isTopFrame", "(Lcom/intellij/xdebugger/frame/XStackFrame;Lcom/intellij/xdebugger/frame/XExecutionStack;JLjava/lang/String;Ljava/lang/String;ZZ)V", "()Z", "getMethodName", "()Ljava/lang/String;", "getTypeName", "customizePresentation", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/FullRowContentProvider;", "container", "Lcom/intellij/ui/ColoredTextContainer;", "maxCharsNonCropped", "", "equals", "other", "", "getIcon", "Ljavax/swing/Icon;", "isActiveThread", "getPriorityWeight", "", "hashCode", "intellij.rider"})
public final class DotNetFrameInfo
extends FrameInfo {
    @NotNull
    private final String methodName;
    @NotNull
    private final String typeName;
    private final boolean isNonUserCode;

    public DotNetFrameInfo(@NotNull XStackFrame frame, @NotNull XExecutionStack stack, long threadId, @NotNull String methodName, @NotNull String typeName2, boolean isNonUserCode, boolean isTopFrame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        super(frame, stack, threadId, isTopFrame);
        this.methodName = methodName;
        this.typeName = typeName2;
        this.isNonUserCode = isNonUserCode;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final String getTypeName() {
        return this.typeName;
    }

    public final boolean isNonUserCode() {
        return this.isNonUserCode;
    }

    @Nullable
    public FullRowContentProvider customizePresentation(@NotNull ColoredTextContainer container, int maxCharsNonCropped) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return DotNetFramePresenter.INSTANCE.customizePresentation(this.methodName, this.typeName, this.isNonUserCode, maxCharsNonCropped, container);
    }

    @Nullable
    public Icon getIcon(boolean isActiveThread) {
        if (!this.isTopFrame()) {
            return null;
        }
        return isActiveThread ? AllIcons.Debugger.ThreadCurrent : RiderIcons.Debugger.SingleThread;
    }

    public double getPriorityWeight() {
        return super.getPriorityWeight() * (this.isNonUserCode ? 0.5 : 1.0);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.rider.debugger.DotNetFrameInfo");
        DotNetFrameInfo cfr_ignored_0 = (DotNetFrameInfo)((Object)other);
        if (!Intrinsics.areEqual((Object)this.methodName, (Object)((DotNetFrameInfo)((Object)other)).methodName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.typeName, (Object)((DotNetFrameInfo)((Object)other)).typeName);
    }

    public int hashCode() {
        return 31 * this.methodName.hashCode() + this.typeName.hashCode();
    }
}

