/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.client.ClientIdPropagation;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.ComputeFramesArg;
import com.jetbrains.rd.ide.model.StackFrameModelBase;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.GutterMarkWeightKt;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.MergableGutterIconRenderer;
import com.jetbrains.rider.debugger.DotNetCompoundFrame;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetExecutionStackExKt;
import com.jetbrains.rider.debugger.DotNetMethodsTracker;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.StackFramesWithFoldingStateCache;
import com.jetbrains.rider.debugger.actions.RiderJumpToStatementAction;
import com.jetbrains.rider.debugger.modulesView.actions.DotnetDebuggerSymbolsLoadedListener;
import com.jetbrains.rider.debugger.util.DebuggerWorkerModelUtilKt;
import com.jetbrains.rider.debugger.util.DotNetDebugProcessUtilKt;
import com.jetbrains.rider.debugger.util.JumpToStatementUtilKt;
import com.jetbrains.rider.debugger.util.XDebugSessionUtilKt;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.ModuleId;
import com.jetbrains.rider.model.debuggerWorker.StackFrameProxy;
import com.jetbrains.rider.model.debuggerWorker.TextRangeProxy;
import com.jetbrains.rider.model.debuggerWorker.ThreadProxy;
import icons.RiderIcons;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00017B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000/0.J\n\u00101\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u00102\u001a\u00020$H\u0016J\u0014\u00103\u001a\u00020\u001c*\u0002042\u0006\u00105\u001a\u000206H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00068"}, d2={"Lcom/jetbrains/rider/debugger/DotNetExecutionStack;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "context", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "threadProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ThreadProxy;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "sessionId", "", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;Lcom/jetbrains/rider/model/debuggerWorker/ThreadProxy;Lcom/jetbrains/rd/util/lifetime/Lifetime;J)V", "getContext", "()Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "currentFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getSessionId", "()J", "stackFramesCache", "Lcom/jetbrains/rider/debugger/StackFramesWithFoldingStateCache;", "getThreadProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/ThreadProxy;", "topFrame", "Lcom/jetbrains/rider/debugger/DotNetStackFrame;", "topFrameMethodRange", "Lcom/jetbrains/rider/model/debuggerWorker/TextRangeProxy;", "getTopFrameMethodRange", "()Lcom/jetbrains/rider/model/debuggerWorker/TextRangeProxy;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "equals", "", "other", "", "getExecutionLineIconRenderer", "Lcom/jetbrains/rider/debugger/DotNetExecutionStack$DotNetExecutionLineGutterRenderer;", "getFramesAsync", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "Lcom/jetbrains/rider/debugger/DotNetCompoundFrame;", "getTopFrame", "hashCode", "j", "Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;", "methodsTracker", "Lcom/jetbrains/rider/debugger/DotNetMethodsTracker;", "DotNetExecutionLineGutterRenderer", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetExecutionStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetExecutionStack.kt\ncom/jetbrains/rider/debugger/DotNetExecutionStack\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n13#2:250\n13#3:251\n65#3,4:252\n1#4:256\n*S KotlinDebug\n*F\n+ 1 DotNetExecutionStack.kt\ncom/jetbrains/rider/debugger/DotNetExecutionStack\n*L\n72#1:250\n72#1:251\n72#1:252,4\n*E\n"})
public final class DotNetExecutionStack
extends XExecutionStack {
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final ExecutionContextProxy context;
    @NotNull
    private final ThreadProxy threadProxy;
    @NotNull
    private final Lifetime lifetime;
    private final long sessionId;
    @NotNull
    private final StackFramesWithFoldingStateCache stackFramesCache;
    @Nullable
    private XStackFrame currentFrame;
    @Nullable
    private final DotNetStackFrame topFrame;
    @Nullable
    private final TextRangeProxy topFrameMethodRange;

    public DotNetExecutionStack(@NotNull XDebugSession session, @NotNull ExecutionContextProxy context, @NotNull ThreadProxy threadProxy, @NotNull Lifetime lifetime2, long sessionId) {
        DotNetStackFrame dotNetStackFrame;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)threadProxy, (String)"threadProxy");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        super(threadProxy.getDisplayName() + " @" + threadProxy.getThreadId(), RiderIcons.Debugger.SingleThread);
        this.session = session;
        this.context = context;
        this.threadProxy = threadProxy;
        this.lifetime = lifetime2;
        this.sessionId = sessionId;
        this.stackFramesCache = new StackFramesWithFoldingStateCache();
        if (this.threadProxy.getTopFrame() == null) {
            dotNetStackFrame = null;
        } else {
            StackFrameModelBase stackFrameModelBase = this.threadProxy.getTopFrame();
            Intrinsics.checkNotNull((Object)stackFrameModelBase, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.debuggerWorker.StackFrameProxy");
            dotNetStackFrame = new DotNetStackFrame(this.session, this.context, (StackFrameProxy)stackFrameModelBase, this, this.lifetime, null, this.sessionId, 32, null);
        }
        this.topFrame = dotNetStackFrame;
        this.topFrameMethodRange = this.threadProxy.getAdditionalThreadProperties().getTopFrameMethodRange();
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetExecutionStack.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        Logger logger3 = logger2;
        bl2 = false;
        if (logger3.isTraceEnabled()) {
            Logger logger4 = logger3;
            boolean bl3 = false;
            DotNetStackFrame dotNetStackFrame2 = this.topFrame;
            logger4.trace("topFrame=" + this.topFrame + ", sourcePosition=" + (XSourcePosition)(dotNetStackFrame2 != null ? dotNetStackFrame2.getSourcePosition() : null));
        }
        XDebugSessionUtilKt.adviseOnFrameChanged((XDebugSession)this.session, (Lifetime)this.lifetime, (Function2)((Function2)new Function2<XExecutionStack, XStackFrame, Unit>(){

            public final void invoke(@NotNull XExecutionStack stack, @NotNull XStackFrame frame) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                if (!(stack instanceof DotNetExecutionStack)) {
                    return;
                }
                if (((DotNetExecutionStack)stack).getThreadProxy().getId() != this.getThreadProxy().getId()) {
                    return;
                }
                currentFrame = frame;
            }
        }));
        ApplicationKt.getApplication().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null)).subscribe(DotnetDebuggerSymbolsLoadedListener.Companion.getTOPIC(), (Object)new DotnetDebuggerSymbolsLoadedListener(){

            @Override
            public void onSymbolsLoaded(@NotNull DotNetDebugProcess debugProcess, @NotNull ModuleId module) {
                Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                if (!stackFramesCache.getHasValue()) {
                    return;
                }
                List<DotNetCompoundFrame> list2 = stackFramesCache.getValue();
                RdCoroutinesUtilKt.launchBackground$default((Lifetime)this.getLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, list2, module, null){
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ DotNetExecutionStack this$0;
                    final /* synthetic */ List<DotNetCompoundFrame> $frames;
                    final /* synthetic */ ModuleId $module;
                    {
                        this.this$0 = $receiver;
                        this.$frames = $frames;
                        this.$module = $module;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = (CoroutineScope)this.L$0;
                                var3_4 = DotNetExecutionStack.access$getCurrentFrame$p(this.this$0);
                                var4_5 = var3_4 instanceof DotNetCompoundFrame != false ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)var3_4), (Iterable)this.$frames) : CollectionsKt.emptyList();
                                var5_6 = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)var4_5));
                                var6_7 = this.$module;
                                var7_8 = false;
                                var8_9 = var5_6.iterator();
lbl12:
                                // 3 sources

                                while (var8_9.hasNext()) {
                                    var9_10 = var8_9.next();
                                    var10_11 = (DotNetStackFrame)var9_10;
                                    var11_12 = false;
                                    if (!Intrinsics.areEqual((Object)var10_11.getFrameProxy().getModuleId(), (Object)var6_7)) continue;
                                    var13_14 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)Logger.getInstance(CoroutineScope.class), (String)"getInstance(...)");
                                    var13_14 = false;
                                    var14_15 = var12_13;
                                    var16_17 = false;
                                    var17_19 = false;
                                    this.L$0 = var2_3;
                                    this.L$1 = var6_7;
                                    this.L$2 = var8_9;
                                    this.L$3 = var12_13;
                                    this.label = 1;
                                    v0 = var10_11.refreshSuspending(false, (Continuation<? super Unit>)this);
                                    ** if (v0 != var18_2) goto lbl34
lbl33:
                                    // 1 sources

                                    return var18_2;
lbl34:
                                    // 1 sources

                                    ** GOTO lbl50
                                }
                                break;
                            }
                            case 1: {
                                var7_8 = false;
                                var11_12 = false;
                                var13_14 = false;
                                var16_17 = false;
                                var17_19 = false;
                                var12_13 = (Logger)this.L$3;
                                var8_9 = (Iterator)this.L$2;
                                var6_7 = (ModuleId)this.L$1;
                                var2_3 = (CoroutineScope)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl50:
                                    // 2 sources

                                    var15_16 = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable var16_18) {
                                    var15_16 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var16_18));
                                }
                                LoggerKt.getOrLogException((Object)var15_16, (Logger)var12_13);
                                ** GOTO lbl12
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final ExecutionContextProxy getContext() {
        return this.context;
    }

    @NotNull
    public final ThreadProxy getThreadProxy() {
        return this.threadProxy;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public final TextRangeProxy getTopFrameMethodRange() {
        return this.topFrameMethodRange;
    }

    @Nullable
    public DotNetStackFrame getTopFrame() {
        return this.topFrame;
    }

    @NotNull
    public final AsyncPromise<List<DotNetCompoundFrame>> getFramesAsync() {
        DotNetStackFrame dotNetStackFrame;
        AsyncPromise asyncPromise = RdTaskUtilKt.createNestedAsyncPromise$default((Lifetime)this.lifetime, (boolean)false, (int)1, null);
        if (this.topFrame == null) {
            InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)this.context)).getScheduler().invokeOrQueue((Function0)new Function0<Unit>((AsyncPromise<List<DotNetCompoundFrame>>)asyncPromise){
                final /* synthetic */ AsyncPromise<List<DotNetCompoundFrame>> $promise;
                {
                    this.$promise = $promise;
                    super(0);
                }

                public final void invoke() {
                    this.$promise.setResult((Object)CollectionsKt.emptyList());
                }
            });
            return asyncPromise;
        }
        DotNetMethodsTracker dotNetMethodsTracker = new DotNetMethodsTracker();
        ArrayList<DotNetStackFrame> arrayList = new ArrayList<DotNetStackFrame>();
        DotNetStackFrame dotNetStackFrame2 = dotNetStackFrame = this.topFrame;
        boolean bl = false;
        dotNetStackFrame2.setMethodOccurrence(dotNetMethodsTracker.getMethodOccurrence(dotNetStackFrame2.getFrameProxy().getId(), dotNetStackFrame2.getFrameProxy()));
        DotNetStackFrame dotNetStackFrame3 = dotNetStackFrame;
        arrayList.add(dotNetStackFrame3);
        dotNetStackFrame = ClientId.Companion.getCurrentOrNull();
        InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)this.context)).getScheduler().invokeOrQueue((Function0)new Function0<Unit>(this, (ClientId)dotNetStackFrame, (AsyncPromise<List<DotNetCompoundFrame>>)asyncPromise, arrayList, dotNetMethodsTracker){
            final /* synthetic */ DotNetExecutionStack this$0;
            final /* synthetic */ ClientId $clientId;
            final /* synthetic */ AsyncPromise<List<DotNetCompoundFrame>> $promise;
            final /* synthetic */ ArrayList<DotNetStackFrame> $stackFrames;
            final /* synthetic */ DotNetMethodsTracker $methodsTracker;
            {
                this.this$0 = $receiver;
                this.$clientId = $clientId;
                this.$promise = $promise;
                this.$stackFrames = $stackFrames;
                this.$methodsTracker = $methodsTracker;
                super(0);
            }

            public final void invoke() {
                DebuggerWorkerModelUtilKt.getCachedCall((KProperty)new PropertyReference0Impl(this.this$0.getThreadProxy()){

                    @Nullable
                    public Object get() {
                        return ((ThreadProxy)this.receiver).getComputeFrames();
                    }
                }, this.this$0.getLifetime()).call(new ComputeFramesArg(1), (Function1)new Function1<RdTaskResult<? extends List<? extends StackFrameModelBase>>, Unit>(this.$clientId, this.this$0, this.$promise, this.$stackFrames, this.$methodsTracker){
                    final /* synthetic */ ClientId $clientId;
                    final /* synthetic */ DotNetExecutionStack this$0;
                    final /* synthetic */ AsyncPromise<List<DotNetCompoundFrame>> $promise;
                    final /* synthetic */ ArrayList<DotNetStackFrame> $stackFrames;
                    final /* synthetic */ DotNetMethodsTracker $methodsTracker;
                    {
                        this.$clientId = $clientId;
                        this.this$0 = $receiver;
                        this.$promise = $promise;
                        this.$stackFrames = $stackFrames;
                        this.$methodsTracker = $methodsTracker;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull RdTaskResult<? extends List<? extends StackFrameModelBase>> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        ClientId.Companion companion = ClientId.Companion;
                        ClientId clientId = this.$clientId;
                        DotNetExecutionStack dotNetExecutionStack = this.this$0;
                        AsyncPromise<List<DotNetCompoundFrame>> asyncPromise = this.$promise;
                        ArrayList<DotNetStackFrame> arrayList = this.$stackFrames;
                        DotNetMethodsTracker dotNetMethodsTracker = this.$methodsTracker;
                        boolean bl = false;
                        ClientSessionsManager clientSessionsManager = companion.getCachedService();
                        if (clientSessionsManager == null) {
                            boolean bl2 = false;
                            if (RLifetimeKt.isNotAlive((Lifetime)dotNetExecutionStack.getLifetime())) {
                                return;
                            }
                            if (DotNetExecutionStack.access$getStackFramesCache$p(dotNetExecutionStack).getHasValue()) {
                                asyncPromise.setResult(DotNetExecutionStack.access$getStackFramesCache$p(dotNetExecutionStack).getValue());
                                return;
                            }
                            RdTaskResult<? extends List<? extends StackFrameModelBase>> rdTaskResult = it;
                            if (rdTaskResult instanceof RdTaskResult.Success) {
                                Iterable iterable = (Iterable)((RdTaskResult.Success)it).getValue();
                                boolean bl3 = false;
                                Iterable iterable2 = iterable;
                                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                                boolean bl4 = false;
                                for (T t : iterable2) {
                                    StackFrameModelBase stackFrameModelBase = (StackFrameModelBase)t;
                                    Collection collection2 = collection;
                                    boolean bl5 = false;
                                    Intrinsics.checkNotNull((Object)stackFrameModelBase, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.debuggerWorker.StackFrameProxy");
                                    collection2.add(DotNetExecutionStack.access$toDotNetStackFrame(dotNetExecutionStack, (StackFrameProxy)stackFrameModelBase, dotNetMethodsTracker));
                                }
                                List list2 = (List)collection;
                                arrayList.addAll(list2);
                                DotNetExecutionStack.access$getStackFramesCache$p(dotNetExecutionStack).setValue((List<DotNetStackFrame>)arrayList);
                                Iterable iterable3 = iterable = DotNetExecutionStack.access$getTopFrame$p(dotNetExecutionStack);
                                boolean bl6 = false;
                                ((DotNetStackFrame)iterable3).setMethodOccurrence(dotNetMethodsTracker.getMethodOccurrence(((DotNetStackFrame)iterable3).getFrameProxy().getId(), ((DotNetStackFrame)iterable3).getFrameProxy()));
                                asyncPromise.setResult(DotNetExecutionStack.access$getStackFramesCache$p(dotNetExecutionStack).getValue());
                            } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                                String string = ((RdTaskResult.Fault)it).getError().getMessage();
                                Intrinsics.checkNotNull((Object)string);
                                asyncPromise.setError(string);
                            } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                                asyncPromise.setError("Evaluation of frames was cancelled");
                            }
                        } else {
                            Object object;
                            String string;
                            ClientSessionsManager clientSessionsManager2 = clientSessionsManager;
                            if (clientId == null || clientSessionsManager2.isValid(clientId)) {
                                if (clientId != null && companion.isFakeLocalId(clientId)) {
                                    string = companion.getLocalId().getValue();
                                } else {
                                    ClientId clientId2 = clientId;
                                    string = clientId2 != null ? clientId2.getValue() : null;
                                }
                            } else {
                                object = companion.getClientIdLogger();
                                boolean bl7 = false;
                                if (object.isTraceEnabled()) {
                                    Object object2 = object;
                                    boolean bl8 = false;
                                    object2.trace("Invalid ClientId " + clientId + " replaced with null at " + new Throwable().fillInStackTrace());
                                }
                                string = null;
                            }
                            String string2 = string;
                            object = ClientIdPropagation.getCurrentClientIdString();
                            try {
                                ClientIdPropagation.setCurrentClientIdString((String)string2);
                                boolean bl9 = false;
                                if (RLifetimeKt.isNotAlive((Lifetime)dotNetExecutionStack.getLifetime())) {
                                    return;
                                }
                                if (DotNetExecutionStack.access$getStackFramesCache$p(dotNetExecutionStack).getHasValue()) {
                                    asyncPromise.setResult(DotNetExecutionStack.access$getStackFramesCache$p(dotNetExecutionStack).getValue());
                                    return;
                                }
                                RdTaskResult<? extends List<? extends StackFrameModelBase>> rdTaskResult = it;
                                if (rdTaskResult instanceof RdTaskResult.Success) {
                                    Iterable iterable = (Iterable)((RdTaskResult.Success)it).getValue();
                                    boolean bl10 = false;
                                    Iterable iterable4 = iterable;
                                    Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                                    boolean bl11 = false;
                                    for (T t : iterable4) {
                                        StackFrameModelBase stackFrameModelBase = (StackFrameModelBase)t;
                                        Collection collection3 = collection;
                                        boolean bl12 = false;
                                        Intrinsics.checkNotNull((Object)stackFrameModelBase, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.debuggerWorker.StackFrameProxy");
                                        collection3.add(DotNetExecutionStack.access$toDotNetStackFrame(dotNetExecutionStack, (StackFrameProxy)stackFrameModelBase, dotNetMethodsTracker));
                                    }
                                    List list3 = (List)collection;
                                    arrayList.addAll(list3);
                                    DotNetExecutionStack.access$getStackFramesCache$p(dotNetExecutionStack).setValue((List<DotNetStackFrame>)arrayList);
                                    Iterable iterable5 = iterable = DotNetExecutionStack.access$getTopFrame$p(dotNetExecutionStack);
                                    boolean bl13 = false;
                                    ((DotNetStackFrame)iterable5).setMethodOccurrence(dotNetMethodsTracker.getMethodOccurrence(((DotNetStackFrame)iterable5).getFrameProxy().getId(), ((DotNetStackFrame)iterable5).getFrameProxy()));
                                    asyncPromise.setResult(DotNetExecutionStack.access$getStackFramesCache$p(dotNetExecutionStack).getValue());
                                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                                    String string3 = ((RdTaskResult.Fault)it).getError().getMessage();
                                    Intrinsics.checkNotNull((Object)string3);
                                    asyncPromise.setError(string3);
                                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                                    asyncPromise.setError("Evaluation of frames was cancelled");
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            finally {
                                ClientIdPropagation.setCurrentClientIdString((String)object);
                            }
                        }
                    }
                });
            }
        });
        return asyncPromise;
    }

    private final DotNetStackFrame j(StackFrameProxy stackFrameProxy, DotNetMethodsTracker dotNetMethodsTracker) {
        return new DotNetStackFrame(this.session, this.context, stackFrameProxy, this, this.lifetime, dotNetMethodsTracker.getMethodOccurrence(stackFrameProxy.getId(), stackFrameProxy), this.sessionId);
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
            container.errorOccurred(RiderDebuggerBundle.Companion.message("DotNetExecutionStack.dialog.message.stack.not.valid", new Object[0]));
            return;
        }
        this.getFramesAsync().onSuccess(arg_0 -> DotNetExecutionStack.N((Function1)new Function1<List<? extends DotNetCompoundFrame>, Unit>(container, firstFrameIndex, this){
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container;
            final /* synthetic */ int $firstFrameIndex;
            final /* synthetic */ DotNetExecutionStack this$0;
            {
                this.$container = $container;
                this.$firstFrameIndex = $firstFrameIndex;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<? extends DotNetCompoundFrame> frames) {
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                if (this.$container instanceof XStackFrameContainerEx) {
                    ((XStackFrameContainerEx)this.$container).addStackFrames(DotNetExecutionStackExKt.getSublist(frames, this.$firstFrameIndex), DotNetExecutionStackExKt.getToSelectFrame(frames, DotNetExecutionStack.access$getCurrentFrame$p(this.this$0)), true);
                } else {
                    this.$container.addStackFrames(DotNetExecutionStackExKt.getSublist(frames, this.$firstFrameIndex), true);
                }
            }
        }, arg_0)).onError(arg_0 -> DotNetExecutionStack.j((Function1)new Function1<Throwable, Unit>(container){
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container;
            {
                this.$container = $container;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getMessage();
                Intrinsics.checkNotNull((Object)string);
                this.$container.errorOccurred(string);
            }
        }, arg_0));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(object != null ? object.getClass() : null, ((Object)((Object)this)).getClass())) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.rider.debugger.DotNetExecutionStack");
        DotNetExecutionStack cfr_ignored_0 = (DotNetExecutionStack)((Object)other);
        if (!Intrinsics.areEqual((Object)this.session, (Object)((DotNetExecutionStack)((Object)other)).session)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.context, (Object)((DotNetExecutionStack)((Object)other)).context)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.threadProxy, (Object)((DotNetExecutionStack)((Object)other)).threadProxy);
    }

    @NotNull
    public DotNetExecutionLineGutterRenderer getExecutionLineIconRenderer() {
        return new DotNetExecutionLineGutterRenderer(this.session, this.threadProxy, this);
    }

    public int hashCode() {
        int n = this.session.hashCode();
        n = 31 * n + this.context.hashCode();
        n = 31 * n + this.threadProxy.hashCode();
        return n;
    }

    private static final void N(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    public static final /* synthetic */ DotNetStackFrame access$toDotNetStackFrame(DotNetExecutionStack $this, StackFrameProxy $receiver, DotNetMethodsTracker methodsTracker) {
        return $this.j($receiver, methodsTracker);
    }

    public static final /* synthetic */ DotNetStackFrame access$getTopFrame$p(DotNetExecutionStack $this) {
        return $this.topFrame;
    }

    public static final /* synthetic */ XStackFrame access$getCurrentFrame$p(DotNetExecutionStack $this) {
        return $this.currentFrame;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0013\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/debugger/DotNetExecutionStack$DotNetExecutionLineGutterRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/MergableGutterIconRenderer;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "stackProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ThreadProxy;", "dotNetExecutionStack", "Lcom/jetbrains/rider/debugger/DotNetExecutionStack;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/model/debuggerWorker/ThreadProxy;Lcom/jetbrains/rider/debugger/DotNetExecutionStack;)V", "debugProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "j", "", "line", "", "equals", "other", "", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getDraggableObject", "Lcom/intellij/openapi/editor/markup/GutterDraggableObject;", "getIcon", "Ljavax/swing/Icon;", "getTooltipText", "", "getWeight", "hashCode", "isNavigateAction", "Companion", "intellij.rider"})
    public static final class DotNetExecutionLineGutterRenderer
    extends GutterIconRenderer
    implements MergableGutterIconRenderer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final XDebugSession session;
        @NotNull
        private final ThreadProxy stackProxy;
        @NotNull
        private final DotNetExecutionStack dotNetExecutionStack;
        @Nullable
        private final DotNetDebugProcess debugProcess;
        private static final int weight = IntentionGroup.ERROR.getPriority() + GutterMarkWeightKt.getPriorityWeight((PriorityAction.Priority)PriorityAction.Priority.HIGH) + 2;

        public DotNetExecutionLineGutterRenderer(@NotNull XDebugSession session, @NotNull ThreadProxy stackProxy, @NotNull DotNetExecutionStack dotNetExecutionStack) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)stackProxy, (String)"stackProxy");
            Intrinsics.checkNotNullParameter((Object)((Object)dotNetExecutionStack), (String)"dotNetExecutionStack");
            this.session = session;
            this.stackProxy = stackProxy;
            this.dotNetExecutionStack = dotNetExecutionStack;
            XDebugProcess xDebugProcess = this.session.getDebugProcess();
            this.debugProcess = xDebugProcess instanceof DotNetDebugProcess ? (DotNetDebugProcess)xDebugProcess : null;
        }

        public int getWeight() {
            return weight;
        }

        public int hashCode() {
            return this.stackProxy.hashCode();
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = RiderIcons.Debugger.NextStatement;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"NextStatement");
            return icon2;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof DotNetExecutionLineGutterRenderer && Intrinsics.areEqual((Object)((DotNetExecutionLineGutterRenderer)((Object)other)).stackProxy, (Object)this.stackProxy);
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            return GutterIconRenderer.Alignment.LEFT;
        }

        @Nullable
        public GutterDraggableObject getDraggableObject() {
            DotNetDebugProcess dotNetDebugProcess = this.debugProcess;
            return (dotNetDebugProcess != null ? DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess) : false) ? (GutterDraggableObject)new GutterDraggableObject(this){
                final /* synthetic */ DotNetExecutionLineGutterRenderer this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean copy(int line, @Nullable VirtualFile file2, int actionId) {
                    if (!DotNetExecutionLineGutterRenderer.access$canSet(this.this$0, line)) {
                        return false;
                    }
                    if (file2 == null) {
                        return false;
                    }
                    Project project = DotNetExecutionLineGutterRenderer.access$getSession$p(this.this$0).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    return RiderJumpToStatementAction.Companion.executeWithLineNumber(file2, project, "ICON_NAVIGATION", line);
                }

                @NotNull
                public Cursor getCursor(int line, @Nullable VirtualFile file2, int actionId) {
                    Cursor cursor;
                    if (DotNetExecutionLineGutterRenderer.access$canSet(this.this$0, line)) {
                        Cursor cursor2 = DragSource.DefaultMoveDrop;
                        cursor = cursor2;
                        Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"DefaultMoveDrop");
                    } else {
                        Cursor cursor3 = DragSource.DefaultMoveNoDrop;
                        cursor = cursor3;
                        Intrinsics.checkNotNullExpressionValue((Object)cursor3, (String)"DefaultMoveNoDrop");
                    }
                    return cursor;
                }
            } : null;
        }

        public boolean isNavigateAction() {
            DotNetDebugProcess dotNetDebugProcess = this.debugProcess;
            return dotNetDebugProcess != null ? DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess) : false;
        }

        @NotNull
        public String getTooltipText() {
            DotNetDebugProcess dotNetDebugProcess = this.debugProcess;
            return (dotNetDebugProcess != null ? DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess) : false) ? RiderDebuggerBundle.Companion.message("DotNetExecutionStack.tooltip.drag.to.skip.code", new Object[0]) : "";
        }

        private final boolean j(int n) {
            return JumpToStatementUtilKt.canJumpToStatement(n, this.dotNetExecutionStack);
        }

        public static final /* synthetic */ boolean access$canSet(DotNetExecutionLineGutterRenderer $this, int line) {
            return $this.j(line);
        }

        public static final /* synthetic */ XDebugSession access$getSession$p(DotNetExecutionLineGutterRenderer $this) {
            return $this.session;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/debugger/DotNetExecutionStack$DotNetExecutionLineGutterRenderer$Companion;", "", "()V", "weight", "", "getWeight", "()I", "intellij.rider"})
        public static final class Companion {
            private Companion() {
            }

            public final int getWeight() {
                return weight;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

