/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.debugger.Builder;
import com.jetbrains.rider.debugger.ContentTypeDetector;
import com.jetbrains.rider.debugger.IDotNetValue;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerPresenterTab;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"STRING_RAW_VIEW_KEY", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createDebuggerVisualizer", "", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerPresenterTab;", "project", "Lcom/intellij/openapi/project/Project;", "value", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetDebuggerVisualizers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetDebuggerVisualizers.kt\ncom/jetbrains/rider/debugger/DotNetDebuggerVisualizersKt\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,264:1\n13#2:265\n13#3:266\n*S KotlinDebug\n*F\n+ 1 DotNetDebuggerVisualizers.kt\ncom/jetbrains/rider/debugger/DotNetDebuggerVisualizersKt\n*L\n32#1:265\n32#1:266\n*E\n"})
public final class DotNetDebuggerVisualizersKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String STRING_RAW_VIEW_KEY = "STRING_RAW_VIEW";

    @Nullable
    public static final List<RiderDebuggerPresenterTab> createDebuggerVisualizer(@NotNull Project project, @NlsSafe @Nullable String value) {
        List<RiderDebuggerPresenterTab> list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            if (value != null) {
                String string = StringsKt.replace$default((String)value, (String)"\r", (String)"", (boolean)false, (int)4, null);
                Builder builder2 = (Builder)new ContentTypeDetector().detect(string).invoke((Object)project, (Object)string);
                return builder2.getTabs();
            }
            list2 = null;
        }
        catch (Throwable throwable) {
            logger.error(throwable);
            list2 = null;
        }
        return list2;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(IDotNetValue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }
}

