/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.debugger.DotNetParallelsStack;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.memoryView.RiderClassesHeapView;
import com.jetbrains.rider.debugger.modulesView.DotNetModulesView;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerTabsStatisticsCollector;
import com.jetbrains.rider.debugger.tasksView.TasksView;
import com.jetbrains.rider.debugger.util.RunnerLayoutUiUtilKt;
import icons.RiderIcons;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\t\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\u001c\u0010\u000f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0012\u0010\u0012\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a8\u0006\u0016"}, d2={"getRunnerContentUi", "Lcom/intellij/execution/ui/layout/impl/RunnerContentUi;", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "registerDebugOutputTab", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "registerMemoryViewPanel", "classesFilteredView", "Lcom/jetbrains/rider/debugger/memoryView/RiderClassesHeapView;", "registerModulesViewTab", "modulesView", "Lcom/jetbrains/rider/debugger/modulesView/DotNetModulesView;", "registerParallelStacksTab", "parallelStacksDebugView", "Lcom/jetbrains/rider/debugger/DotNetParallelsStack;", "registerStatisticsCollector", "registerTasksViewTab", "tasksView", "Lcom/jetbrains/rider/debugger/tasksView/TasksView;", "intellij.rider"})
public final class DotNetDebugTabsRegistatorKt {
    public static final void registerParallelStacksTab(@NotNull RunnerLayoutUi $this$registerParallelStacksTab, @NotNull Lifetime lifetime2, @NotNull DotNetParallelsStack parallelStacksDebugView) {
        Intrinsics.checkNotNullParameter((Object)$this$registerParallelStacksTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)parallelStacksDebugView), (String)"parallelStacksDebugView");
        Content content2 = $this$registerParallelStacksTab.createContent("ParallelStacks", (JComponent)parallelStacksDebugView.getMainComponent(), RiderDebuggerBundle.Companion.message("tab.display.name.parallel.stacks", new Object[0]), RiderIcons.Debugger.ParallelStacks, null);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        content3.setCloseable(false);
        $this$registerParallelStacksTab.addListener(new ContentManagerListener(lifetime2, content3, parallelStacksDebugView){
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ Content $parallelStacksContent;
            final /* synthetic */ DotNetParallelsStack $parallelStacksDebugView;
            {
                this.$lifetime = $lifetime;
                this.$parallelStacksContent = $parallelStacksContent;
                this.$parallelStacksDebugView = $parallelStacksDebugView;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (RLifetimeKt.isNotAlive((Lifetime)this.$lifetime)) {
                    return;
                }
                Content content2 = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
                Content content3 = content2;
                if (content3 == this.$parallelStacksContent && content3.isSelected()) {
                    this.$parallelStacksDebugView.updateView(false);
                }
            }
        }, (Disposable)content3);
        $this$registerParallelStacksTab.addContent(content3, 3, PlaceInGrid.center, false);
    }

    public static final void registerDebugOutputTab(@NotNull RunnerLayoutUi $this$registerDebugOutputTab, @NotNull Lifetime lifetime2, @NotNull ConsoleViewImpl console2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerDebugOutputTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
        Content content2 = $this$registerDebugOutputTab.createContent("DebuggerOutput", console2.getComponent(), RiderDebuggerBundle.Companion.message("tab.display.name.debug.output", new Object[0]), AllIcons.Debugger.Console, console2.getPreferredFocusableComponent());
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        content3.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions((ExecutionConsole)((ExecutionConsole)console2), (Content)content3);
        $this$registerDebugOutputTab.addContent(content3, 2, PlaceInGrid.center, false);
        console2.addChangeListener(new ObservableConsoleView.ChangeListener(content3){
            final /* synthetic */ Content $debuggerOutputConsoleContent;
            {
                this.$debuggerOutputConsoleContent = $debuggerOutputConsoleContent;
            }

            public void contentAdded(@NotNull Collection<? extends ConsoleViewContentType> types) {
                Intrinsics.checkNotNullParameter(types, (String)"types");
                if (CollectionsKt.contains((Iterable)types, (Object)ConsoleViewContentType.NORMAL_OUTPUT) || CollectionsKt.contains((Iterable)types, (Object)ConsoleViewContentType.ERROR_OUTPUT)) {
                    this.$debuggerOutputConsoleContent.fireAlert();
                }
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime2, null, (int)1, null));
    }

    public static final void registerMemoryViewPanel(@NotNull RunnerLayoutUi $this$registerMemoryViewPanel, @NotNull Lifetime lifetime2, @NotNull RiderClassesHeapView classesFilteredView) {
        Content content2;
        Intrinsics.checkNotNullParameter((Object)$this$registerMemoryViewPanel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)classesFilteredView), (String)"classesFilteredView");
        Content content3 = content2 = $this$registerMemoryViewPanel.createContent("MemoryView", (JComponent)((Object)classesFilteredView), RiderDebuggerBundle.Companion.message("display.name.memory", new Object[0]), RiderIcons.Debugger.MemoryView, null);
        boolean bl = false;
        content3.setCloseable(false);
        content3.setShouldDisposeContent(true);
        Content content4 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"apply(...)");
        Content content5 = content4;
        $this$registerMemoryViewPanel.addContent(content5, 4, PlaceInGrid.center, false);
        RunnerLayoutUiUtilKt.adviseOnSelectionChange($this$registerMemoryViewPanel, lifetime2, content5, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(classesFilteredView){
            final /* synthetic */ RiderClassesHeapView $classesFilteredView;
            {
                this.$classesFilteredView = $classesFilteredView;
                super(1);
            }

            public final void invoke(boolean isSelected) {
                this.$classesFilteredView.setActive(isSelected);
            }
        }));
    }

    public static final void registerModulesViewTab(@NotNull RunnerLayoutUi $this$registerModulesViewTab, @NotNull DotNetModulesView modulesView) {
        Intrinsics.checkNotNullParameter((Object)$this$registerModulesViewTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modulesView, (String)"modulesView");
        Content content2 = $this$registerModulesViewTab.createContent("ModulesView", (JComponent)modulesView.getMainComponent(), RiderDebuggerBundle.Companion.message("tab.display.name.modules", new Object[0]), RiderIcons.Debugger.ModulesView, null);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        content3.setCloseable(false);
        $this$registerModulesViewTab.addContent(content3, 5, PlaceInGrid.center, false);
    }

    public static final void registerTasksViewTab(@NotNull RunnerLayoutUi $this$registerTasksViewTab, @NotNull Lifetime lifetime2, @NotNull TasksView tasksView) {
        Intrinsics.checkNotNullParameter((Object)$this$registerTasksViewTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)tasksView), (String)"tasksView");
        Content content2 = $this$registerTasksViewTab.createContent("TasksView", tasksView.getMainComponent(), RiderDebuggerBundle.Companion.message("tab.display.name.tasks", new Object[0]), RiderIcons.Debugger.Tasks, null);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        content3.setCloseable(false);
        $this$registerTasksViewTab.addContent(content3, 6, PlaceInGrid.center, false);
        RunnerLayoutUiUtilKt.adviseOnSelectionChange($this$registerTasksViewTab, lifetime2, content3, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(tasksView){
            final /* synthetic */ TasksView $tasksView;
            {
                this.$tasksView = $tasksView;
                super(1);
            }

            public final void invoke(boolean isSelected) {
                if (isSelected) {
                    this.$tasksView.activate();
                } else {
                    this.$tasksView.deactivate();
                }
            }
        }));
    }

    public static final void registerStatisticsCollector(@NotNull RunnerLayoutUi $this$registerStatisticsCollector, @NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerStatisticsCollector, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        $this$registerStatisticsCollector.addListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                    return;
                }
                String string = (String)event.getContent().getUserData(ViewImpl.ID);
                if (string == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    Logger logger2 = Logger.getInstance(RiderDebuggerTabsStatisticsCollector.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.error("Missing View Id for content " + event.getContent().getTabName());
                    string = "UnknownTab";
                }
                RiderDebuggerTabsStatisticsCollector.INSTANCE.debuggerTabSelected(string);
            }
        }, LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime2, (String)"Session lifetime nested disposable for tabs statistics"));
    }

    @Nullable
    public static final RunnerContentUi getRunnerContentUi(@NotNull RunnerLayoutUi $this$getRunnerContentUi) {
        Intrinsics.checkNotNullParameter((Object)$this$getRunnerContentUi, (String)"<this>");
        return (RunnerContentUi)RunnerContentUi.KEY.getData((DataProvider)((RunnerLayoutUiImpl)$this$getRunnerContentUi));
    }
}

