/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetValueUtilsKt;
import com.jetbrains.rider.debugger.breakpoint.DotNetBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetExceptionBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetMethodBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.IDotNetVerifiableBreakpointType;
import com.jetbrains.rider.debugger.evaluation.RiderExpressionUtilKt;
import com.jetbrains.rider.debugger.util.DebuggerWorkerModelUtilKt;
import com.jetbrains.rider.model.debuggerWorker.BreakpointAdditionalDataModel;
import com.jetbrains.rider.model.debuggerWorker.BreakpointElement;
import com.jetbrains.rider.model.debuggerWorker.BreakpointHitCountModeModel;
import com.jetbrains.rider.model.debuggerWorker.BreakpointId;
import com.jetbrains.rider.model.debuggerWorker.BreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.BreakpointStatus;
import com.jetbrains.rider.model.debuggerWorker.BreakpointStatusKind;
import com.jetbrains.rider.model.debuggerWorker.BreakpointWithExpressionAdditionalDataModel;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.model.debuggerWorker.ExceptionBreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.LineBreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.MethodBreakpointModel;
import com.jetbrains.rider.projectView.utils.ProjectModelViewUtilKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u001a\u001a\u00020\u0015J\u001c\u0010\u001b\u001a\u00020\u00132\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0014\u0010\u001d\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000bJ\u0012\u0010\u001f\u001a\u00020\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030 J\u0014\u0010!\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\"0\u000bJ\u0014\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\fJ\u0014\u0010%\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000bJ\u0012\u0010&\u001a\u00020\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030 J\u0014\u0010'\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\"0\u000bR\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/debugger/DotNetBreakpointsManager;", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "sessionProxy", "Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/framework/IProtocol;Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;)V", "breakpointMap", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointId;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getSessionProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "j", "", "breakPointModel", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointModel;", "status", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointStatus;", "registerBreakpointAndModel", "breakpoint", "breakpointModel", "j", "xBreakpoint", "registerExceptionBreakpoint", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetExceptionBreakpointProperties;", "registerLineBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "registerMethodBreakpoint", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetMethodBreakpointProperties;", "tryGetBreakpoint", "breakpointId", "unregisterExceptionBreakpoint", "unregisterLineBreakpoint", "unregisterMethodBreakpoint", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetBreakpointsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetBreakpointsManager.kt\ncom/jetbrains/rider/debugger/DotNetBreakpointsManager\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,208:1\n13#2:209\n13#3:210\n*S KotlinDebug\n*F\n+ 1 DotNetBreakpointsManager.kt\ncom/jetbrains/rider/debugger/DotNetBreakpointsManager\n*L\n34#1:209\n34#1:210\n*E\n"})
public final class DotNetBreakpointsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final IProtocol protocol;
    @NotNull
    private final DotNetDebuggerSessionModel sessionProxy;
    @NotNull
    private final Project project;
    @NotNull
    private final BidirectionalMap<XBreakpoint<?>, BreakpointId> breakpointMap;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<ArrayList<BreakpointAdditionalDataModel>> breakpointAdditionalDataKey;

    public DotNetBreakpointsManager(@NotNull XDebugSession session, @NotNull IProtocol protocol, @NotNull DotNetDebuggerSessionModel sessionProxy) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)sessionProxy, (String)"sessionProxy");
        this.session = session;
        this.protocol = protocol;
        this.sessionProxy = sessionProxy;
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.breakpointMap = new BidirectionalMap();
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)this.sessionProxy.getNotifyDisabledBreakpointHit(), null, null, (Function1)((Function1)new Function1<BreakpointId, Unit>(){

            public final void invoke(@NotNull BreakpointId breakpointId) {
                Logger logger2;
                Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
                Logger logger3 = Companion.getLogger();
                boolean bl = false;
                if (logger3.isTraceEnabled()) {
                    logger2 = logger3;
                    boolean bl2 = false;
                    logger2.trace("Get signal about disabled breakpoint hit, breakpointId = " + RdId.toString-impl((long)breakpointId.getId-yyTGXKE()));
                }
                List list2 = breakpointMap.getKeysByValue((Object)breakpointId);
                if (list2 != null) {
                    Iterable iterable = list2;
                    DotNetBreakpointsManager dotNetBreakpointsManager = this;
                    boolean bl3 = false;
                    for (Object t : iterable) {
                        boolean bl4;
                        Logger logger4;
                        XBreakpoint xBreakpoint = (XBreakpoint)t;
                        boolean bl5 = false;
                        Logger logger5 = Companion.getLogger();
                        boolean bl6 = false;
                        if (logger5.isTraceEnabled()) {
                            logger4 = logger5;
                            bl4 = false;
                            logger4.trace("Get matching breakpoint " + xBreakpoint);
                        }
                        XDebugSession xDebugSession = dotNetBreakpointsManager.session;
                        Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
                        ((XDebugSessionImpl)xDebugSession).processDependencies(xBreakpoint);
                        if (xBreakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)xBreakpoint).isTemporary()) {
                            XDebuggerUtil.getInstance().removeBreakpoint(dotNetBreakpointsManager.project, xBreakpoint);
                        }
                        logger5 = Companion.getLogger();
                        bl6 = false;
                        if (!logger5.isTraceEnabled()) continue;
                        logger4 = logger5;
                        bl4 = false;
                        logger4.trace("Finished processing breakpoint " + xBreakpoint);
                    }
                }
                logger3 = Companion.getLogger();
                boolean bl7 = false;
                if (logger3.isTraceEnabled()) {
                    logger2 = logger3;
                    boolean bl8 = false;
                    logger2.trace("Finished processing signal");
                }
            }
        }), (int)3, null);
    }

    @NotNull
    public final DotNetDebuggerSessionModel getSessionProxy() {
        return this.sessionProxy;
    }

    public final void registerLineBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        RunProfile runProfile2 = this.session.getRunProfile();
        logger.info("Registering line breakpoint " + breakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        Object object4 = this.session.getDebugProcess();
        DotNetDebugProcess dotNetDebugProcess = object4 instanceof DotNetDebugProcess ? (DotNetDebugProcess)((Object)object4) : null;
        if (dotNetDebugProcess == null) {
            return;
        }
        DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
        BreakpointId breakpointId = new BreakpointId(this.protocol.getIdentity().next-rSJKwng(RdId.Companion.getNull-yyTGXKE()), null);
        XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
        object4 = xBreakpointProperties instanceof DotNetLineBreakpointProperties ? (DotNetLineBreakpointProperties)xBreakpointProperties : null;
        xBreakpointProperties = BreakpointHitCountModeModel.None;
        long l = -1L;
        int n = 0;
        if (object4 != null) {
            xBreakpointProperties = DebuggerWorkerModelUtilKt.toHitCountModeModel((DotNetBreakpointProperties)((Object)object4));
            Long l2 = ((DotNetLineBreakpointProperties)((Object)object4)).getDebugProcessToThreadIdToStopMap().get((Object)dotNetDebugProcess2);
            l = l2 != null ? l2 : -1L;
            n = ((DotNetBreakpointProperties)((Object)object4)).getHitCount();
        }
        if ((object3 = object4) == null || (object3 = ((DotNetLineBreakpointProperties)((Object)object3)).getBreakpointElements(breakpoint)) == null) {
            String string = breakpoint.getPresentableFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableFilePath(...)");
            object3 = object2 = CollectionsKt.listOf((Object)new BreakpointElement(string, breakpoint.getLine(), 0, true));
        }
        if ((object = object4) == null || (object = ((DotNetLineBreakpointProperties)((Object)object)).getFilename()) == null) {
            object = breakpoint.getPresentableFilePath();
        }
        File file2 = new File((String)object);
        boolean bl = ProjectModelViewUtilKt.isSolutionFile(file2, this.project, false);
        ArrayList arrayList = (ArrayList)breakpoint.getUserData(breakpointAdditionalDataKey);
        List list2 = CollectionsKt.toMutableList((Collection)(arrayList == null ? CollectionsKt.emptyList() : (List)arrayList));
        if (breakpoint.getConditionExpression() != null || breakpoint.getLogExpressionObject() != null) {
            ((Collection)list2).add(new BreakpointWithExpressionAdditionalDataModel(DotNetValueUtilsKt.getNameAliases(this.session)));
        }
        LineBreakpointModel lineBreakpointModel = new LineBreakpointModel((List)object2, bl, l, list2, breakpointId, RiderExpressionUtilKt.toExpressionModel(breakpoint.getConditionExpression(), this.session), breakpoint.getSuspendPolicy() != SuspendPolicy.NONE, RiderExpressionUtilKt.toExpressionModel(breakpoint.getLogExpressionObject(), this.session), breakpoint.isLogMessage(), breakpoint.isLogStack(), n, (BreakpointHitCountModeModel)xBreakpointProperties);
        this.registerBreakpointAndModel((XBreakpoint)breakpoint, (BreakpointModel)lineBreakpointModel);
    }

    public final void registerExceptionBreakpoint(@NotNull XBreakpoint<DotNetExceptionBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        RunProfile runProfile2 = this.session.getRunProfile();
        logger.info("Registering exception breakpoint " + breakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = new BreakpointId(this.protocol.getIdentity().next-rSJKwng(RdId.Companion.getNull-yyTGXKE()), null);
        DotNetExceptionBreakpointProperties dotNetExceptionBreakpointProperties = (DotNetExceptionBreakpointProperties)breakpoint.getProperties();
        Intrinsics.checkNotNull((Object)((Object)dotNetExceptionBreakpointProperties));
        BreakpointHitCountModeModel breakpointHitCountModeModel = DebuggerWorkerModelUtilKt.toHitCountModeModel(dotNetExceptionBreakpointProperties);
        ExceptionBreakpointModel exceptionBreakpointModel = new ExceptionBreakpointModel(dotNetExceptionBreakpointProperties.getException(), dotNetExceptionBreakpointProperties.getJustMyCode(), breakpointId, RiderExpressionUtilKt.toExpressionModel(breakpoint.getConditionExpression(), this.session), breakpoint.getSuspendPolicy() != SuspendPolicy.NONE, RiderExpressionUtilKt.toExpressionModel(breakpoint.getLogExpressionObject(), this.session), breakpoint.isLogMessage(), breakpoint.isLogStack(), dotNetExceptionBreakpointProperties.getHitCount(), breakpointHitCountModeModel);
        this.registerBreakpointAndModel(breakpoint, (BreakpointModel)exceptionBreakpointModel);
    }

    public final void registerMethodBreakpoint(@NotNull XBreakpoint<DotNetMethodBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        RunProfile runProfile2 = this.session.getRunProfile();
        logger.info("Registering method breakpoint " + breakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = new BreakpointId(this.protocol.getIdentity().next-rSJKwng(RdId.Companion.getNull-yyTGXKE()), null);
        DotNetMethodBreakpointProperties dotNetMethodBreakpointProperties = (DotNetMethodBreakpointProperties)breakpoint.getProperties();
        Intrinsics.checkNotNull((Object)((Object)dotNetMethodBreakpointProperties));
        BreakpointHitCountModeModel breakpointHitCountModeModel = DebuggerWorkerModelUtilKt.toHitCountModeModel(dotNetMethodBreakpointProperties);
        MethodBreakpointModel methodBreakpointModel = new MethodBreakpointModel(dotNetMethodBreakpointProperties.getClrTypeName(), dotNetMethodBreakpointProperties.getMethodName(), breakpointId, RiderExpressionUtilKt.toExpressionModel(breakpoint.getConditionExpression(), this.session), breakpoint.getSuspendPolicy() != SuspendPolicy.NONE, RiderExpressionUtilKt.toExpressionModel(breakpoint.getLogExpressionObject(), this.session), breakpoint.isLogMessage(), breakpoint.isLogStack(), dotNetMethodBreakpointProperties.getHitCount(), breakpointHitCountModeModel);
        this.registerBreakpointAndModel(breakpoint, (BreakpointModel)methodBreakpointModel);
    }

    public final void registerBreakpointAndModel(@NotNull XBreakpoint<?> breakpoint, @NotNull BreakpointModel breakpointModel) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)breakpointModel, (String)"breakpointModel");
        UIUtil.invokeLaterIfNeeded(() -> DotNetBreakpointsManager.j(breakpoint, this, breakpointModel));
    }

    private final void j(XBreakpoint<?> xBreakpoint, BreakpointModel breakpointModel) {
        breakpointModel.getStatusChanged().advise(Lifetime.Companion.getEternal(), (Function1)new Function1<BreakpointStatus, Unit>(this, breakpointModel){
            final /* synthetic */ DotNetBreakpointsManager this$0;
            final /* synthetic */ BreakpointModel $breakpointModel;
            {
                this.this$0 = $receiver;
                this.$breakpointModel = $breakpointModel;
                super(1);
            }

            public final void invoke(@NotNull BreakpointStatus it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DotNetBreakpointsManager.access$breakpointStatusChanged(this.this$0, this.$breakpointModel, it);
            }
        });
        breakpointModel.getShouldNotifyHitWhenDisabled().set((Object)(xBreakpoint.getSuspendPolicy() == SuspendPolicy.NONE ? 1 : 0));
    }

    private final void j(BreakpointModel breakpointModel, BreakpointStatus breakpointStatus) {
        if (breakpointModel instanceof LineBreakpointModel) {
            Object object;
            XDebugSession xDebugSession = this.session;
            List list2 = this.breakpointMap.getKeysByValue((Object)breakpointModel.getId());
            if (list2 == null || (list2 = (XBreakpoint)CollectionsKt.firstOrNull((List)list2)) == null) {
                return;
            }
            List list3 = list2;
            switch (WhenMappings.$EnumSwitchMapping$0[breakpointStatus.getStatus().ordinal()]) {
                case 1: {
                    XBreakpointType xBreakpointType;
                    if (list3.getSuspendPolicy() == SuspendPolicy.NONE) {
                        xBreakpointType = list3.getType();
                        object = xBreakpointType instanceof IDotNetVerifiableBreakpointType ? (IDotNetVerifiableBreakpointType)xBreakpointType : null;
                        if (object != null && (object = object.getVerifiedIconWithNoSuspend()) != null) break;
                        Icon icon2 = AllIcons.Debugger.Db_verified_no_suspend_breakpoint;
                        object = icon2;
                        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Db_verified_no_suspend_breakpoint");
                        break;
                    }
                    xBreakpointType = list3.getType();
                    object = xBreakpointType instanceof IDotNetVerifiableBreakpointType ? (IDotNetVerifiableBreakpointType)xBreakpointType : null;
                    if (object != null && (object = object.getVerifiedIcon()) != null) break;
                    Icon icon3 = AllIcons.Debugger.Db_set_breakpoint;
                    object = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Db_set_breakpoint");
                    break;
                }
                case 2: {
                    Icon icon4 = list3.getType().getEnabledIcon();
                    object = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"getEnabledIcon(...)");
                    break;
                }
                case 3: {
                    Icon icon5 = list3.getType().getDisabledIcon();
                    object = icon5;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"getDisabledIcon(...)");
                    break;
                }
                default: {
                    XBreakpointType xBreakpointType = list3.getType();
                    object = xBreakpointType instanceof IDotNetVerifiableBreakpointType ? (IDotNetVerifiableBreakpointType)xBreakpointType : null;
                    if (object != null && (object = object.getInvalidIcon()) != null) break;
                    Icon icon6 = AllIcons.Debugger.Db_invalid_breakpoint;
                    object = icon6;
                    Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Db_invalid_breakpoint");
                }
            }
            Icon icon7 = object;
            String string = breakpointStatus.getMessage();
            XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)list3;
            xDebugSession.updateBreakpointPresentation(xLineBreakpoint, icon7, string);
        }
    }

    public final void unregisterLineBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        UIUtil.invokeLaterIfNeeded(() -> DotNetBreakpointsManager.j(breakpoint, this));
    }

    public final void unregisterExceptionBreakpoint(@NotNull XBreakpoint<DotNetExceptionBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        UIUtil.invokeLaterIfNeeded(() -> DotNetBreakpointsManager.N(breakpoint, this));
    }

    public final void unregisterMethodBreakpoint(@NotNull XBreakpoint<DotNetMethodBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        UIUtil.invokeLaterIfNeeded(() -> DotNetBreakpointsManager.j(breakpoint, this));
    }

    @Nullable
    public final XBreakpoint<?> tryGetBreakpoint(@NotNull BreakpointId breakpointId) {
        Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
        List list2 = this.breakpointMap.getKeysByValue((Object)breakpointId);
        return list2 != null ? (XBreakpoint)CollectionsKt.firstOrNull((List)list2) : null;
    }

    private static final void j(XBreakpoint xBreakpoint, DotNetBreakpointsManager dotNetBreakpointsManager, BreakpointModel breakpointModel) {
        BreakpointModel breakpointModel2;
        Intrinsics.checkNotNullParameter((Object)xBreakpoint, (String)"$breakpoint");
        Intrinsics.checkNotNullParameter((Object)dotNetBreakpointsManager, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)breakpointModel, (String)"$breakpointModel");
        RunProfile runProfile2 = dotNetBreakpointsManager.session.getRunProfile();
        logger.info("Registering " + xBreakpoint.getType() + " " + xBreakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = breakpointModel.getId();
        Map map2 = (Map)dotNetBreakpointsManager.sessionProxy.getBreakpoints();
        BreakpointModel breakpointModel3 = breakpointModel2 = breakpointModel;
        boolean bl = false;
        dotNetBreakpointsManager.j(xBreakpoint, breakpointModel3);
        map2.put(breakpointId, breakpointModel2);
        ((Map)dotNetBreakpointsManager.breakpointMap).put(xBreakpoint, breakpointId);
    }

    private static final void j(XLineBreakpoint xLineBreakpoint, DotNetBreakpointsManager dotNetBreakpointsManager) {
        Intrinsics.checkNotNullParameter((Object)xLineBreakpoint, (String)"$breakpoint");
        Intrinsics.checkNotNullParameter((Object)dotNetBreakpointsManager, (String)"this$0");
        RunProfile runProfile2 = dotNetBreakpointsManager.session.getRunProfile();
        logger.info("Unregistering line breakpoint " + xLineBreakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = (BreakpointId)dotNetBreakpointsManager.breakpointMap.get((Object)xLineBreakpoint);
        if (breakpointId == null) {
            return;
        }
        BreakpointId breakpointId2 = breakpointId;
        dotNetBreakpointsManager.sessionProxy.getBreakpoints().remove((Object)breakpointId2);
        dotNetBreakpointsManager.breakpointMap.remove((Object)xLineBreakpoint);
    }

    private static final void N(XBreakpoint xBreakpoint, DotNetBreakpointsManager dotNetBreakpointsManager) {
        Intrinsics.checkNotNullParameter((Object)xBreakpoint, (String)"$breakpoint");
        Intrinsics.checkNotNullParameter((Object)dotNetBreakpointsManager, (String)"this$0");
        RunProfile runProfile2 = dotNetBreakpointsManager.session.getRunProfile();
        logger.info("Unregistering exception breakpoint " + xBreakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = (BreakpointId)dotNetBreakpointsManager.breakpointMap.get((Object)xBreakpoint);
        if (breakpointId == null) {
            return;
        }
        BreakpointId breakpointId2 = breakpointId;
        dotNetBreakpointsManager.sessionProxy.getBreakpoints().remove((Object)breakpointId2);
        dotNetBreakpointsManager.breakpointMap.remove((Object)xBreakpoint);
    }

    private static final void j(XBreakpoint xBreakpoint, DotNetBreakpointsManager dotNetBreakpointsManager) {
        Intrinsics.checkNotNullParameter((Object)xBreakpoint, (String)"$breakpoint");
        Intrinsics.checkNotNullParameter((Object)dotNetBreakpointsManager, (String)"this$0");
        RunProfile runProfile2 = dotNetBreakpointsManager.session.getRunProfile();
        logger.info("Unregistering method breakpoint " + xBreakpoint.getProperties() + " on the session " + (runProfile2 != null ? runProfile2.getName() : null));
        BreakpointId breakpointId = (BreakpointId)dotNetBreakpointsManager.breakpointMap.get((Object)xBreakpoint);
        if (breakpointId == null) {
            return;
        }
        BreakpointId breakpointId2 = breakpointId;
        dotNetBreakpointsManager.sessionProxy.getBreakpoints().remove((Object)breakpointId2);
        dotNetBreakpointsManager.breakpointMap.remove((Object)xBreakpoint);
    }

    public static final /* synthetic */ void access$breakpointStatusChanged(DotNetBreakpointsManager $this, BreakpointModel breakPointModel, BreakpointStatus status) {
        $this.j(breakPointModel, status);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetBreakpointsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
        Key key2 = Key.create((String)"BreakpointAdditionalData");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        breakpointAdditionalDataKey = key2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RF\u0010\u0003\u001a7\u0012.\u0012,\u0012\u0004\u0012\u00020\u0006 \b*\u0016\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0006\u0018\u0001`\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00070\u0004\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/debugger/DotNetBreakpointsManager$Companion;", "", "()V", "breakpointAdditionalDataKey", "Lcom/intellij/openapi/util/Key;", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointAdditionalDataModel;", "Lkotlin/collections/ArrayList;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getBreakpointAdditionalDataKey", "()Lcom/intellij/openapi/util/Key;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Key<ArrayList<BreakpointAdditionalDataModel>> getBreakpointAdditionalDataKey() {
            return breakpointAdditionalDataKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BreakpointStatusKind.values().length];
            try {
                nArray[BreakpointStatusKind.Bound.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointStatusKind.Disconnected.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointStatusKind.ExternalCodeDisabled.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

