/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.model.debuggerWorker.DebuggerWorkerModel;
import com.jetbrains.rider.model.debuggerWorker.TargetExitedArgs;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandlerBase;", "Lcom/intellij/execution/process/ProcessHandler;", "workerModel", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerWorkerModel;", "(Lcom/jetbrains/rider/model/debuggerWorker/DebuggerWorkerModel;)V", "targetIsAlive", "", "getTargetIsAlive", "()Z", "setTargetIsAlive", "(Z)V", "targetProcessIsAlive", "getTargetProcessIsAlive", "getWorkerModel", "()Lcom/jetbrains/rider/model/debuggerWorker/DebuggerWorkerModel;", "destroyProcessImpl", "", "detachProcessImpl", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDebuggerWorkerProcessHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerWorkerProcessHandlerBase.kt\ncom/jetbrains/rider/debugger/DebuggerWorkerProcessHandlerBase\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n13#2:45\n13#3:46\n*S KotlinDebug\n*F\n+ 1 DebuggerWorkerProcessHandlerBase.kt\ncom/jetbrains/rider/debugger/DebuggerWorkerProcessHandlerBase\n*L\n12#1:45\n12#1:46\n*E\n"})
public abstract class DebuggerWorkerProcessHandlerBase
extends ProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DebuggerWorkerModel workerModel;
    private boolean targetIsAlive;
    @NotNull
    private static final Logger LOG;

    public DebuggerWorkerProcessHandlerBase(@NotNull DebuggerWorkerModel workerModel) {
        Intrinsics.checkNotNullParameter((Object)workerModel, (String)"workerModel");
        this.workerModel = workerModel;
        this.targetIsAlive = true;
        SourceExKt.adviseEternal((ISource)this.workerModel.getLogError(), (Function1)1.INSTANCE);
        SourceExKt.adviseEternal((ISource)this.workerModel.getTargetExited(), (Function1)((Function1)new Function1<TargetExitedArgs, Unit>(){

            public final void invoke(@NotNull TargetExitedArgs it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.setTargetIsAlive(false);
                LOG.debug("Target process has exited with code " + it.getExitCode());
            }
        }));
    }

    @NotNull
    public final DebuggerWorkerModel getWorkerModel() {
        return this.workerModel;
    }

    public final boolean getTargetIsAlive() {
        return this.targetIsAlive;
    }

    public final void setTargetIsAlive(boolean bl) {
        this.targetIsAlive = bl;
    }

    public final boolean getTargetProcessIsAlive() {
        return this.targetIsAlive;
    }

    protected void destroyProcessImpl() {
        InterfacesKt.fire((ISignal)((ISignal)this.workerModel.getDestroyTarget()));
        this.notifyProcessTerminated(0);
    }

    protected void detachProcessImpl() {
        InterfacesKt.fire((ISignal)((ISignal)this.workerModel.getDetachTarget()));
        this.notifyProcessDetached();
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DebuggerWorkerProcessHandlerBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/debugger/DebuggerWorkerProcessHandlerBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

