/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.DFA.EditorDebuggerModeWidget;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.debugger.DFA.DFAManager;
import com.jetbrains.rider.debugger.DFA.DFAManagerUtilsKt;
import com.jetbrains.rider.debugger.DFA.EditorDebuggerModeWidget.DFAModeComponent;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import icons.RiderIcons;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/debugger/DFA/EditorDebuggerModeWidget/DFAModeAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "customComponentSeqLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "logger", "Lcom/jetbrains/rd/util/Logger;", "getLogger", "()Lcom/jetbrains/rd/util/Logger;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "setSelected", "state", "update", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDFAModeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DFAModeAction.kt\ncom/jetbrains/rider/debugger/DFA/EditorDebuggerModeWidget/DFAModeAction\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,77:1\n94#2:78\n*S KotlinDebug\n*F\n+ 1 DFAModeAction.kt\ncom/jetbrains/rider/debugger/DFA/EditorDebuggerModeWidget/DFAModeAction\n*L\n28#1:78\n*E\n"})
public final class DFAModeAction
extends DumbAwareToggleAction
implements CustomComponentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SequentialLifetimes customComponentSeqLifetimes;
    @NotNull
    private static final Key<Boolean> DFADisabledForCurrentSessionPresentationKey = new Key("DFAModeAction_DFADisabledForCurrentSessionPresentationKey");

    public DFAModeAction(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        boolean bl = false;
        this.logger = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(DFAModeAction.class));
        Editor editor3 = this.editor;
        Intrinsics.checkNotNull((Object)editor3, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        Disposable disposable = ((EditorImpl)editor3).getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.customComponentSeqLifetimes = new SequentialLifetimes(LifetimeDisposableExKt.createLifetime((Disposable)disposable));
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DFAManagerUtilsKt.disableDFAForThisSession(e);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return true;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            DFAModeAction dFAModeAction = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project2 = project;
        DFAManager dFAManager = DFAManagerUtilsKt.getDFAManager(project2);
        if (dFAManager == null) {
            DFAModeAction dFAModeAction = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DFAManager dFAManager2 = dFAManager;
        if (!dFAManager2.needToShowDFAModeWidget(this.editor)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        if (dFAManager2.getDisabledForCurrentSession()) {
            e.getPresentation().setText(null);
            e.getPresentation().setHoveredIcon(null);
            e.getPresentation().setIcon(RiderIcons.Debugger.PredictiveDebugger);
            e.getPresentation().setDescription(RiderDebuggerBundle.Companion.message("rider.debugger.DFA.mode.enter.debugger.DFA.mode", new Object[0]));
        } else {
            e.getPresentation().setText(RiderDebuggerBundle.Companion.message("rider.debugger.DFA.mode", new Object[0]));
            e.getPresentation().setIcon(EmptyIcon.ICON_16);
            e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseDarkGrey);
            e.getPresentation().setDescription(RiderDebuggerBundle.Companion.message("rider.debugger.DFA.mode.exit.debugger.DFA.mode", new Object[0]));
        }
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Lifetime lifetime2 = (Lifetime)this.customComponentSeqLifetimes.next();
        AnAction anAction = (AnAction)this;
        JBDimension jBDimension = JBUI.size((int)18);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
        return (JComponent)((Object)new DFAModeComponent(lifetime2, this.editor, anAction, presentation2, place, (Dimension)jBDimension));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/DFA/EditorDebuggerModeWidget/DFAModeAction$Companion;", "", "()V", "DFADisabledForCurrentSessionPresentationKey", "Lcom/intellij/openapi/util/Key;", "", "getDFADisabledForCurrentSessionPresentationKey", "()Lcom/intellij/openapi/util/Key;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getDFADisabledForCurrentSessionPresentationKey() {
            return DFADisabledForCurrentSessionPresentationKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

