/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.Base64;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/debugger/ContentTypeConverter;", "", "()V", "decodeBase64", "", "s", "decodeUrl", "prettifyJson", "prettifyXml", "intellij.rider"})
final class ContentTypeConverter {
    @NotNull
    public final String prettifyJson(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        JsonElement jsonElement = JsonParser.parseString((String)s);
        Gson gson2 = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String string = gson2.toJson(jsonElement);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @NotNull
    public final String prettifyXml(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        InputSource inputSource = new InputSource(new StringReader(s));
        Document document2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(document2), new StreamResult(stringWriter));
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String decodeUrl(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = URLDecoder.decode(s, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        return string;
    }

    @NotNull
    public final String decodeBase64(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] byArray = Base64.getDecoder().decode(s);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }
}

