/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.statistics.VisualizerContentType;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerPresenterTab;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/debugger/Builder;", "", "project", "Lcom/intellij/openapi/project/Project;", "value", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "key", "getKey", "()Ljava/lang/String;", "prettified", "getPrettified", "prettyTabName", "getPrettyTabName", "getProject", "()Lcom/intellij/openapi/project/Project;", "sourceTabName", "getSourceTabName", "getValue", "visualizerContentType", "Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "getVisualizerContentType", "()Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "getTabs", "", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerPresenterTab;", "prettyView", "Ljavax/swing/JComponent;", "rawView", "content", "intellij.rider"})
abstract class Builder {
    @NotNull
    private final Project project;
    @NotNull
    private final String value;
    @NotNull
    private final String prettified;
    @NotNull
    private final String prettyTabName;
    @NotNull
    private final String sourceTabName;

    public Builder(@NotNull Project project, @NlsSafe @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.project = project;
        this.prettified = this.value = value;
        this.prettyTabName = RiderDebuggerBundle.Companion.message("rider.debugger.view.visualizers.formatted", new Object[0]);
        this.sourceTabName = RiderDebuggerBundle.Companion.message("rider.debugger.view.visualizers.raw", new Object[0]);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public String getPrettified() {
        return this.prettified;
    }

    @NotNull
    public abstract FileType getFileType();

    @NotNull
    public String getPrettyTabName() {
        return this.prettyTabName;
    }

    @NotNull
    public String getSourceTabName() {
        return this.sourceTabName;
    }

    @NotNull
    public abstract String getKey();

    @Nullable
    public abstract VisualizerContentType getVisualizerContentType();

    @NotNull
    public JComponent prettyView() {
        return this.rawView(this.getPrettified());
    }

    @NotNull
    public final JComponent rawView(@NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        JComponent jComponent = DebuggerUIUtil.createTextViewer((String)content2, (Project)this.project, (FileType)this.getFileType()).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public List<RiderDebuggerPresenterTab> getTabs() {
        Object[] objectArray = new RiderDebuggerPresenterTab[]{new RiderDebuggerPresenterTab(this.getPrettyTabName(), this.getKey(), this.prettyView(), this.getVisualizerContentType()), new RiderDebuggerPresenterTab(this.getSourceTabName(), "STRING_RAW_VIEW", this.rawView(this.value), null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

