/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.ui.old;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.rider.build.diagnostics.BuildDiagnostic;
import com.jetbrains.rider.build.diagnostics.DiagnosticKind;
import com.jetbrains.rider.build.ui.RiderBuildResultTreeNode;
import com.jetbrains.rider.build.ui.old.RiderBuildResultTreeModel;
import com.jetbrains.rider.ui.RiderUI;
import java.awt.Color;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\r\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016J!\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\r\u0010\"\u001a\t\u0018\u00010#\u00a2\u0006\u0002\b*H\u0002J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020,H\u0016J\b\u0010.\u001a\u00020\fH\u0016J\b\u0010/\u001a\u00020\fH\u0016J\u0010\u00100\u001a\u00020\f2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\f2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00104\u001a\u00020\u00162\u0006\u00101\u001a\u000202H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/rider/build/ui/old/RiderBuildResultTreePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ide/OccurenceNavigator;", "Lcom/intellij/ide/CopyProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "activeModel", "Lcom/jetbrains/rider/build/ui/old/RiderBuildResultTreeModel;", "errors", "hasError", "", "hasErrors", "getHasErrors", "()Z", "hasEvents", "getHasEvents", "hasWarnings", "getHasWarnings", "warnings", "activate", "", "addBuildEvent", "buildEvent", "Lcom/jetbrains/rider/build/diagnostics/BuildDiagnostic;", "clearTree", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getBackground", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "getData", "", "dataId", "", "getNextOccurenceActionName", "getPreviousOccurenceActionName", "j", "Lcom/intellij/pom/Navigatable;", "node", "Lcom/jetbrains/rider/build/ui/RiderBuildResultTreeNode;", "Lorg/jetbrains/annotations/NonNls;", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "hasNextOccurence", "hasPreviousOccurence", "isCopyEnabled", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "performCopy", "intellij.rider"})
public final class RiderBuildResultTreePanel
extends BorderLayoutPanel
implements DataProvider,
OccurenceNavigator,
CopyProvider {
    @NotNull
    private final Project project;
    private boolean hasError;
    @NotNull
    private final RiderBuildResultTreeModel errors;
    @NotNull
    private final RiderBuildResultTreeModel warnings;
    @NotNull
    private RiderBuildResultTreeModel activeModel;

    public RiderBuildResultTreePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.errors = new RiderBuildResultTreeModel(this.project);
        this.activeModel = this.warnings = new RiderBuildResultTreeModel(this.project);
        this.addToCenter(this.warnings.getTreeScrollPane());
    }

    public final boolean getHasErrors() {
        return this.errors.getRoot().getChildCount() > 0;
    }

    public final boolean getHasWarnings() {
        return this.warnings.getRoot().getChildCount() > 0;
    }

    public final boolean getHasEvents() {
        return this.activeModel.getRoot().getChildCount() > 0;
    }

    public final void clearTree() {
        this.errors.clearTree();
        this.warnings.clearTree();
        this.hasError = false;
        this.activeModel = this.warnings;
        this.remove(0);
        this.addToCenter(this.warnings.getTreeScrollPane());
    }

    @NotNull
    public Color getBackground() {
        return RiderUI.Companion.getUsualBackgroundColor();
    }

    public final void addBuildEvent(@NotNull BuildDiagnostic buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        switch (WhenMappings.$EnumSwitchMapping$0[buildEvent.getKind().ordinal()]) {
            case 1: {
                this.activeModel.addBuildEvent(buildEvent);
                break;
            }
            case 2: {
                if (!this.hasError) {
                    this.hasError = true;
                    this.warnings.clearTree();
                    this.remove(this.warnings.getTreeScrollPane());
                    this.addToCenter(this.errors.getTreeScrollPane());
                    this.activeModel = this.errors;
                    this.activeModel.getTree().updateUI();
                }
                this.activeModel.addBuildEvent(buildEvent);
                break;
            }
            case 3: {
                if (this.hasError) break;
                this.activeModel.addBuildEvent(buildEvent);
            }
        }
    }

    public boolean hasNextOccurence() {
        return this.activeModel.getNavigator().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.activeModel.getNavigator().hasPreviousOccurence();
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.activeModel.getNavigator().goNextOccurence();
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.activeModel.getNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return this.activeModel.getNavigator().getNextOccurenceActionName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return this.activeModel.getNavigator().getPreviousOccurenceActionName();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            RiderBuildResultTreeNode riderBuildResultTreeNode;
            RiderBuildResultTreeNode riderBuildResultTreeNode2 = riderBuildResultTreeNode = this.activeModel.getSelectedNode();
            object = riderBuildResultTreeNode2 != null ? arg_0 -> RiderBuildResultTreePanel.j(this, riderBuildResultTreeNode2, arg_0) : null;
        } else {
            object = PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this : (LangDataKeys.NO_NEW_ACTION.is(dataId) ? Boolean.valueOf(true) : null);
        }
        return object;
    }

    private final Navigatable j(RiderBuildResultTreeNode riderBuildResultTreeNode, String string) {
        return CommonDataKeys.NAVIGATABLE.is(string) ? riderBuildResultTreeNode.createNavigatable(this.project) : null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (((CharSequence)this.activeModel.getTextForCopy()).length() > 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.activeModel.getTextForCopy()));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return ((CharSequence)this.activeModel.getTextForCopy()).length() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public final void activate() {
        if (this.activeModel.getTree().getSelectionCount() == 0) {
            TreeUtil.selectFirstNode((JTree)((JTree)this.activeModel.getTree()));
        }
        this.activeModel.getTree().updateUI();
    }

    private static final Object j(RiderBuildResultTreePanel riderBuildResultTreePanel, RiderBuildResultTreeNode riderBuildResultTreeNode, String string) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderBuildResultTreePanel), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)string, (String)"realDataId");
        return riderBuildResultTreePanel.j(riderBuildResultTreeNode, string);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagnosticKind.values().length];
            try {
                nArray[DiagnosticKind.Reference.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticKind.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticKind.Warning.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

