/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.tasks;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.jetbrains.rider.build.BuildHost;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.tasks.BeforeRunTaskWithProjectProvider;
import com.jetbrains.rider.build.tasks.BuildProjectBeforeRunTask;
import com.jetbrains.rider.build.tasks.BuildTaskThrottler;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfiguration;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTaskProvider;", "Lcom/jetbrains/rider/build/tasks/BeforeRunTaskWithProjectProvider;", "Lcom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTask;", "()V", "baseDescription", "", "Lorg/jetbrains/annotations/Nls;", "getBaseDescription", "()Ljava/lang/String;", "canExecuteTask", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "task", "createTask", "executeTask", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getIcon", "Ljavax/swing/Icon;", "getId", "Lcom/intellij/openapi/util/Key;", "getName", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildProjectBeforeRunTaskProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProjectBeforeRunTaskProvider.kt\ncom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTaskProvider\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n13#3:81\n*S KotlinDebug\n*F\n+ 1 BuildProjectBeforeRunTaskProvider.kt\ncom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTaskProvider\n*L\n26#1:80\n26#1:81\n*E\n"})
public final class BuildProjectBeforeRunTaskProvider
extends BeforeRunTaskWithProjectProvider<BuildProjectBeforeRunTask> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<BuildProjectBeforeRunTask> providerId;
    @Nls
    @NotNull
    private static final String TASK_NAME;
    @NotNull
    private static final Logger logger;

    @Override
    @NotNull
    public String getBaseDescription() {
        return RiderBuildBundle.Companion.message("description.build.project", new Object[0]);
    }

    @NotNull
    public Key<BuildProjectBeforeRunTask> getId() {
        return providerId;
    }

    @NotNull
    public String getName() {
        return TASK_NAME;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = AllIcons.Actions.Compile;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Compile");
        return icon2;
    }

    @NotNull
    public BuildProjectBeforeRunTask createTask(@NotNull RunConfiguration configuration) {
        BuildProjectBeforeRunTask buildProjectBeforeRunTask;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        BuildProjectBeforeRunTask buildProjectBeforeRunTask2 = buildProjectBeforeRunTask = new BuildProjectBeforeRunTask();
        boolean bl = false;
        buildProjectBeforeRunTask2.setEnabled(this.shouldCreateBuildBeforeRunTaskByDefault(configuration));
        return buildProjectBeforeRunTask;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull BuildProjectBeforeRunTask task2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (Boolean)BuildHost.Companion.getInstance(project).getReady().getValue();
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull BuildProjectBeforeRunTask task2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BuildHost buildHost = BuildHost.Companion.getInstance(project);
        if (!((Boolean)buildHost.getReady().getValue()).booleanValue()) {
            logger.warn("buildHost is not ready");
            return false;
        }
        Object object2 = task2.getSelectedProject().getPath();
        if (object2 == null || (object2 = object2.toString()) == null) {
            BuildProjectBeforeRunTaskProvider buildProjectBeforeRunTaskProvider = this;
            boolean bl = false;
            RunConfiguration runConfiguration = configuration;
            object2 = runConfiguration instanceof RiderMultiPlatformConfiguration ? ((RiderMultiPlatformConfiguration)configuration).getParameters().getProjectFilePath() : (runConfiguration instanceof IProjectBasedRunConfiguration ? ((IProjectBasedRunConfiguration)configuration).getProjectFilePath() : null);
        }
        if ((object = object2) == null) {
            logger.warn("projectToBuildPath is null");
            return false;
        }
        List list2 = CollectionsKt.listOf((Object)object);
        RiderMultiPlatformConfiguration riderMultiPlatformConfiguration = configuration instanceof RiderMultiPlatformConfiguration ? (RiderMultiPlatformConfiguration)configuration : null;
        RdTargetFrameworkId rdTargetFrameworkId = riderMultiPlatformConfiguration != null ? riderMultiPlatformConfiguration.getTargetFrameworkId() : null;
        Project project2 = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        BuildTaskThrottler buildTaskThrottler = BuildTaskThrottler.Companion.getInstance(project2);
        return buildTaskThrottler.buildSequentiallySync(new BuildParameters((BuildTargetBase)new BuildTarget(), list2, false, false, false, false, false, rdTargetFrameworkId, 124, null)).getMsBuildStatus();
    }

    static {
        Key key2 = Key.create((String)"Build");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        providerId = key2;
        TASK_NAME = RiderBuildBundle.Companion.message("BuildProjectBeforeRunTaskProvider.task.name.build.project", new Object[0]);
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(BuildProjectBeforeRunTaskProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTaskProvider$Companion;", "", "()V", "TASK_NAME", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "providerId", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/build/tasks/BuildProjectBeforeRunTask;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProviderId", "()Lcom/intellij/openapi/util/Key;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<BuildProjectBeforeRunTask> getProviderId() {
            return providerId;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

