/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.jetbrains.rider.build.BuildHost;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.actions.BuildActionBase;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0003\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/build/actions/BuildCurrentProjectBase;", "Lcom/jetbrains/rider/build/actions/BuildActionBase;", "operation", "Lcom/jetbrains/rider/model/BuildTargetBase;", "operationText", "", "showProjectName", "", "withDependencies", "actionText", "(Lcom/jetbrains/rider/model/BuildTargetBase;Ljava/lang/String;ZZLjava/lang/String;)V", "getOperation", "()Lcom/jetbrains/rider/model/BuildTargetBase;", "actionPerformedInternal", "", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "buildHost", "Lcom/jetbrains/rider/build/BuildHost;", "getProjectModelEntityToBuild", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.rider"})
public class BuildCurrentProjectBase
extends BuildActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BuildTargetBase operation;
    @NotNull
    private final String operationText;
    private final boolean showProjectName;
    private final boolean withDependencies;
    @NotNull
    private final String actionText;

    public BuildCurrentProjectBase(@NotNull BuildTargetBase operation, @Nls @NotNull String operationText, boolean showProjectName, boolean withDependencies, @NlsActions.ActionText @NotNull String actionText) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)operationText, (String)"operationText");
        Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
        super(Companion.calculateActionText(operationText, actionText, withDependencies));
        this.operation = operation;
        this.operationText = operationText;
        this.showProjectName = showProjectName;
        this.withDependencies = withDependencies;
        this.actionText = actionText;
    }

    public /* synthetic */ BuildCurrentProjectBase(BuildTargetBase buildTargetBase, String string, boolean bl, boolean bl2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            string2 = RiderBuildBundle.Companion.message("BuildCurrentProjectBase.action.current.project.text", new Object[0]);
        }
        this(buildTargetBase, string, bl, bl2, string2);
    }

    @NotNull
    public final BuildTargetBase getOperation() {
        return this.operation;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setText(Companion.calculateActionText(this.operationText, this.actionText, this.withDependencies));
        Project project = e.getProject();
        ProjectModelEntity projectModelEntity = this.getProjectModelEntityToBuild(project, e.getDataContext());
        if (this.isReady(project) && projectModelEntity != null) {
            e.getPresentation().setEnabled(true);
            if (this.showProjectName) {
                Presentation presentation2 = e.getPresentation();
                presentation2.setText(presentation2.getText() + ": " + projectModelEntity.getName());
            }
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    @Nullable
    protected ProjectModelEntity getProjectModelEntityToBuild(@Nullable Project project, @Nullable DataContext dataContext) {
        DataContext dataContext2 = dataContext;
        return dataContext2 != null && (dataContext2 = ProjectModelEntityExtensionsKt.getProjectModelEntity((DataContext)dataContext2, (boolean)true)) != null ? ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)dataContext2) : null;
    }

    @Override
    protected void actionPerformedInternal(@NotNull Project project, @NotNull DataContext dataContext, @NotNull BuildHost buildHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)((Object)buildHost), (String)"buildHost");
        ProjectModelEntity projectModelEntity = this.getProjectModelEntityToBuild(project, dataContext);
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        if (projectModelEntity2 == null || (projectModelEntity2 = projectModelEntity2.getUrl()) == null || (projectModelEntity2 = VirtualFileUrls.getVirtualFile((VirtualFileUrl)projectModelEntity2)) == null) {
            return;
        }
        ProjectModelEntity projectModelEntity3 = projectModelEntity2;
        if (!BuildHost.requestBuild$default(buildHost, new BuildParameters(this.operation, CollectionsKt.listOf((Object)projectModelEntity3.getPath()), false, false, true, !this.withDependencies, false, null, 192, null), null, 2, null)) {
            new Notification("Build Messages", RiderBuildBundle.Companion.message("notification.title.another.build.is.already.in.progress", new Object[0]), RiderBuildBundle.Companion.message("notification.content.another.build.is.already.in.progress", new Object[0]), NotificationType.WARNING).notify(project);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0005\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/build/actions/BuildCurrentProjectBase$Companion;", "", "()V", "calculateActionText", "", "operationText", "actionText", "withDependencies", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nls
        @NotNull
        protected final String calculateActionText(@NotNull String operationText, @NotNull String actionText, boolean withDependencies) {
            Intrinsics.checkNotNullParameter((Object)operationText, (String)"operationText");
            Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
            Object[] objectArray = new Object[]{operationText, actionText, withDependencies ? 0 : 1};
            return RiderBuildBundle.Companion.message("BuildCurrentProjectBase.action.without.dependencies.text", objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

