/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.WhenShowBuildResultMode;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rider.build.BuildEventsService;
import com.jetbrains.rider.build.BuildHost;
import com.jetbrains.rider.build.BuildToolWindowContext;
import com.jetbrains.rider.build.BuildToolWindowFactory;
import com.jetbrains.rider.build.BuildUsagesCollector;
import com.jetbrains.rider.build.RdBuildExtensionsKt;
import com.jetbrains.rider.build.Rider25962Notification;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.diagnostics.BuildDiagnostic;
import com.jetbrains.rider.build.diagnostics.DiagnosticKind;
import com.jetbrains.rider.model.BuildEvent;
import com.jetbrains.rider.model.BuildEventRef;
import com.jetbrains.rider.model.BuildResult;
import com.jetbrains.rider.model.BuildSession;
import com.jetbrains.rider.model.ProjectId;
import com.jetbrains.rider.model.TxOutputItemBase;
import com.jetbrains.rider.model.build.BuildEventKind;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.settings.SettingsSynchronizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u001a\u001a\u00020\u00122\b\b\u0001\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!J\n\u0010\"\u001a\u00020#*\u00020$J\f\u0010%\u001a\u00020&*\u00020'H\u0002J\f\u0010%\u001a\u00020&*\u00020(H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/build/BuildSessionView;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "context", "Lcom/jetbrains/rider/build/BuildToolWindowContext;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "rider25962DontShow", "", "rider25962LastTimestamp", "", "rider25962Notification", "Lcom/jetbrains/rider/build/Rider25962Notification;", "settingsSynchronizer", "Lcom/jetbrains/rider/settings/SettingsSynchronizer;", "j", "", "buildTargetName", "", "buildResult", "Lcom/jetbrains/rider/model/BuildResult;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "activateToolWindow", "j", "text", "type", "Lcom/intellij/notification/NotificationType;", "j", "viewBuildSession", "session", "Lcom/jetbrains/rider/model/BuildSession;", "toDiagnostic", "Lcom/jetbrains/rider/build/diagnostics/BuildDiagnostic;", "Lcom/jetbrains/rider/model/BuildEvent;", "j", "Lcom/jetbrains/rider/build/diagnostics/DiagnosticKind;", "Lcom/jetbrains/rider/model/BuildEventKind;", "Lcom/jetbrains/rider/model/build/BuildEventKind;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildSessionView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSessionView.kt\ncom/jetbrains/rider/build/BuildSessionView\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 IProtocolHost.kt\ncom/jetbrains/rider/protocol/IProtocolHostKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n13#2:234\n13#3:235\n24#4:236\n800#5,11:237\n*S KotlinDebug\n*F\n+ 1 BuildSessionView.kt\ncom/jetbrains/rider/build/BuildSessionView\n*L\n29#1:234\n29#1:235\n30#1:236\n30#1:237,11\n*E\n"})
public final class BuildSessionView
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SettingsSynchronizer settingsSynchronizer;
    private boolean rider25962DontShow;
    private long rider25962LastTimestamp;
    @NotNull
    private final Rider25962Notification rider25962Notification;
    @NotNull
    private final BuildToolWindowContext context;

    public BuildSessionView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(BuildSessionView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        Object object = ApplicationProtocolKt.getProtocolHost((Project)this.project);
        BuildSessionView buildSessionView = this;
        bl2 = false;
        Iterable iterable = object.getComponents();
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl4 = false;
        for (Object t : iterable2) {
            if (!(t instanceof SettingsSynchronizer)) continue;
            collection.add(t);
        }
        buildSessionView.settingsSynchronizer = (SettingsSynchronizer)((ProtocolComponent)CollectionsKt.single((List)((List)collection)));
        Object object2 = object = new Rider25962Notification();
        buildSessionView = this;
        boolean bl5 = false;
        object2.addAction((AnAction)NotificationAction.createSimple((String)RiderBuildBundle.Companion.message("BuildSessionView.notification.content.how.to.fix", new Object[0]), () -> BuildSessionView.j((Rider25962Notification)((Object)object2))));
        object2.addAction((AnAction)NotificationAction.createSimple((String)RiderBuildBundle.Companion.message("BuildSessionView.notification.content.do.not.show.again", new Object[0]), () -> BuildSessionView.j((Rider25962Notification)((Object)object2), this)));
        buildSessionView.rider25962Notification = object;
        this.context = BuildToolWindowFactory.Companion.getInstance(this.project).getOrCreateContext(this.project);
    }

    public final void viewBuildSession(@NotNull Lifetime sessionLifetime, @NotNull BuildSession session) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (session.getDumbOpeningIsApplicable() && BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.settingsSynchronizer.getSettingsModel().getShowBuildProgressInToolWindow())) && BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.settingsSynchronizer.getRiderSettingsModel().getSolBuilderShowToolWindowWithoutSmartness()))) {
            BuildToolWindowFactory.Companion.getInstance(this.project).getOrCreateContext(this.project).showToolWindowIfHidden(false);
        }
        this.context.clear();
        this.context.updateLiveIcon(true);
        BuildEventsService buildEventsService = BuildEventsService.Companion.getInstance(this.project);
        session.getResult().advise(sessionLifetime, (Function1)new Function1<BuildResult, Unit>(this){
            final /* synthetic */ BuildSessionView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BuildResult buildResultKind) {
                Intrinsics.checkNotNullParameter((Object)buildResultKind, (String)"buildResultKind");
                BuildSessionView.access$getLogger$p(this.this$0).info("result: " + buildResultKind);
                BuildSessionView.access$getContext$p(this.this$0).updateLiveIcon(false);
            }
        });
        this.logger.info("new session");
        sessionLifetime.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ BuildSessionView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BuildSessionView.access$getLogger$p(this.this$0).info("terminate");
            }
        });
        buildEventsService.acceptNewSession(sessionLifetime, session);
        sessionLifetime.onTermination((Function0)new Function0<Unit>(buildEventsService, this){
            final /* synthetic */ BuildEventsService $eventsService;
            final /* synthetic */ BuildSessionView this$0;
            {
                this.$eventsService = $eventsService;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BuildEventsService.SessionEventStatistics sessionEventStatistics = this.$eventsService.getCurrentStatistics();
                if (sessionEventStatistics != null) {
                    BuildUsagesCollector.INSTANCE.logSessionClosed(BuildSessionView.access$getProject$p(this.this$0), sessionEventStatistics);
                }
            }
        });
        buildEventsService.replaceListener(this.context);
        boolean bl = this.context.isActive();
        this.context.updateProgress(session.getOperation());
        session.getBuildEventRefs().advise(sessionLifetime, (Function1)new Function1<List<? extends BuildEventRef>, Unit>(buildEventsService){
            final /* synthetic */ BuildEventsService $eventsService;
            {
                this.$eventsService = $eventsService;
                super(1);
            }

            public final void invoke(@NotNull List<BuildEventRef> refs) {
                Intrinsics.checkNotNullParameter(refs, (String)"refs");
                this.$eventsService.consumeRefs(refs);
            }
        });
        session.getOutput().getItem().advise(sessionLifetime, (Function1)new Function1<List<? extends TxOutputItemBase>, Unit>(this, session){
            final /* synthetic */ BuildSessionView this$0;
            final /* synthetic */ BuildSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@NotNull List<? extends TxOutputItemBase> outputItems) {
                Intrinsics.checkNotNullParameter(outputItems, (String)"outputItems");
                BuildSessionView.access$getContext$p(this.this$0).addOutputBatch(outputItems, (IMutableViewableMap<ProjectId, String>)this.$session.getOutput().getProjectsDirectories());
            }
        });
        session.getResult().advise(sessionLifetime, (Function1)new Function1<BuildResult, Unit>(buildEventsService, this, session, sessionLifetime){
            final /* synthetic */ BuildEventsService $eventsService;
            final /* synthetic */ BuildSessionView this$0;
            final /* synthetic */ BuildSession $session;
            final /* synthetic */ Lifetime $sessionLifetime;
            {
                this.$eventsService = $eventsService;
                this.this$0 = $receiver;
                this.$session = $session;
                this.$sessionLifetime = $sessionLifetime;
                super(1);
            }

            public final void invoke(@NotNull BuildResult buildResult) {
                Intrinsics.checkNotNullParameter((Object)buildResult, (String)"buildResult");
                this.$eventsService.notifyBuildFinished();
                BuildSessionView.access$getContext$p(this.this$0).notifyBuildFinished();
                BuildSessionView.access$handleBuildResult(this.this$0, BuildHost.Companion.getBuildTargetName(this.$session.getOperation()), buildResult, this.$sessionLifetime, this.$session.getActivateBuildResultsWindow(), BuildSessionView.access$getContext$p(this.this$0));
            }
        });
    }

    private final void j() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.rider25962DontShow || this.rider25962Notification.getBalloon() != null) {
            return;
        }
        long l = System.nanoTime();
        if (l - this.rider25962LastTimestamp < 1000000000L) {
            return;
        }
        this.rider25962LastTimestamp = l;
        this.rider25962Notification.notify(this.project);
    }

    @NotNull
    public final BuildDiagnostic toDiagnostic(@NotNull BuildEvent $this$toDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$toDiagnostic, (String)"<this>");
        return new BuildDiagnostic(this.j($this$toDiagnostic.getKind()), $this$toDiagnostic.getMessage(), $this$toDiagnostic.getCode(), $this$toDiagnostic.getProjectId(), $this$toDiagnostic.getTargetFramework(), $this$toDiagnostic.getFilePath(), $this$toDiagnostic.getLine(), $this$toDiagnostic.getColumn());
    }

    private final DiagnosticKind j(BuildEventKind buildEventKind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[buildEventKind.ordinal()]) {
            case 1 -> DiagnosticKind.Error;
            case 2 -> DiagnosticKind.Warning;
            case 3 -> DiagnosticKind.Reference;
            default -> throw new Exception("Unknown kind");
        };
    }

    private final DiagnosticKind j(com.jetbrains.rider.model.BuildEventKind buildEventKind) {
        return switch (WhenMappings.$EnumSwitchMapping$1[buildEventKind.ordinal()]) {
            case 1 -> DiagnosticKind.Error;
            case 2 -> DiagnosticKind.Warning;
            case 3 -> DiagnosticKind.Reference;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void j(String string, BuildResult buildResult, Lifetime lifetime2, boolean bl, BuildToolWindowContext buildToolWindowContext) {
        String string2 = buildToolWindowContext.updateStatus(buildResult.getKind(), string);
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.settingsSynchronizer.getSettingsModel().getSwitchToTreeViewForEvents()))) {
            buildToolWindowContext.invalidatePanelMode();
        }
        ApplicationKt.getApplication().invokeLater(() -> BuildSessionView.j(lifetime2, buildResult, string, this, string2, buildToolWindowContext, bl));
    }

    private final void j(@NlsContexts.NotificationContent String string, NotificationType notificationType, Lifetime lifetime2) {
        Notification notification2 = new Notification("Build Messages", "", string, notificationType);
        Notifications.Bus.notify((Notification)notification2, (Project)this.project);
        this.logger.trace("Build notification " + notification2.hashCode() + " expired");
        lifetime2.onTermination((Function0)new Function0<Unit>(this, notification2){
            final /* synthetic */ BuildSessionView this$0;
            final /* synthetic */ Notification $notification;
            {
                this.this$0 = $receiver;
                this.$notification = $notification;
                super(0);
            }

            public final void invoke() {
                if (!BuildSessionView.access$getProject$p(this.this$0).isDisposed()) {
                    BuildSessionView.access$getLogger$p(this.this$0).trace("Build notification " + this.$notification.hashCode() + " expired");
                    this.$notification.expire();
                }
            }
        });
    }

    private static final void j(Rider25962Notification rider25962Notification) {
        Intrinsics.checkNotNullParameter((Object)((Object)rider25962Notification), (String)"$this_apply");
        rider25962Notification.hideBalloon();
        BrowserUtil.browse((String)"https://jb.gg/incompatible-mono-dotnet-core");
    }

    private static final void j(Rider25962Notification rider25962Notification, BuildSessionView buildSessionView) {
        Intrinsics.checkNotNullParameter((Object)((Object)rider25962Notification), (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)((Object)buildSessionView), (String)"this$0");
        rider25962Notification.expire();
        buildSessionView.rider25962DontShow = true;
    }

    private static final void j(Lifetime lifetime2, BuildResult buildResult, String string, BuildSessionView buildSessionView, String string2, BuildToolWindowContext buildToolWindowContext, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"$sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)buildResult, (String)"$buildResult");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$buildTargetName");
        Intrinsics.checkNotNullParameter((Object)((Object)buildSessionView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"$statusText");
        Intrinsics.checkNotNullParameter((Object)buildToolWindowContext, (String)"$context");
        if (!RLifetimeKt.isAlive((Lifetime)lifetime2)) {
            return;
        }
        NotificationType notificationType = RdBuildExtensionsKt.toNotificationType(buildResult.getKind());
        if (buildResult.getShowNotification()) {
            SystemNotifications.getInstance().notify("Build Messages", RdBuildExtensionsKt.toShortStatusText(buildResult.getKind(), string), buildSessionView.project.getName());
            if (notificationType == NotificationType.INFORMATION || notificationType == NotificationType.WARNING) {
                buildSessionView.j(string2, notificationType, lifetime2);
            } else {
                new Notification("Build Errors", "", string2, notificationType).notify(buildSessionView.project);
                StatusBarUtil.setStatusBarInfo((Project)buildSessionView.project, (String)string2);
            }
        } else {
            StatusBarUtil.setStatusBarInfo((Project)buildSessionView.project, (String)string2);
        }
        WhenShowBuildResultMode whenShowBuildResultMode = (WhenShowBuildResultMode)buildSessionView.settingsSynchronizer.getSettingsModel().getShowResultAfterBuild().getValueOrNull();
        switch (whenShowBuildResultMode == null ? -1 : WhenMappings.$EnumSwitchMapping$2[whenShowBuildResultMode.ordinal()]) {
            case 1: {
                buildToolWindowContext.showToolWindowIfHidden(bl);
                break;
            }
            case 2: {
                if (notificationType != NotificationType.ERROR) break;
                buildToolWindowContext.showToolWindowIfHidden(bl);
                break;
            }
            case 3: {
                if (notificationType != NotificationType.WARNING && notificationType != NotificationType.ERROR) break;
                buildToolWindowContext.showToolWindowIfHidden(bl);
                break;
            }
            case 4: {
                break;
            }
            default: {
                if (notificationType != NotificationType.ERROR) break;
                buildToolWindowContext.showToolWindowIfHidden(bl);
            }
        }
    }

    public static final /* synthetic */ Logger access$getLogger$p(BuildSessionView $this) {
        return $this.logger;
    }

    public static final /* synthetic */ BuildToolWindowContext access$getContext$p(BuildSessionView $this) {
        return $this.context;
    }

    public static final /* synthetic */ Project access$getProject$p(BuildSessionView $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$handleBuildResult(BuildSessionView $this, String buildTargetName, BuildResult buildResult, Lifetime sessionLifetime, boolean activateToolWindow, BuildToolWindowContext context) {
        $this.j(buildTargetName, buildResult, sessionLifetime, activateToolWindow, context);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[BuildEventKind.values().length];
            try {
                nArray[BuildEventKind.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventKind.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventKind.Reference.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[com.jetbrains.rider.model.BuildEventKind.values().length];
            try {
                nArray[com.jetbrains.rider.model.BuildEventKind.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.jetbrains.rider.model.BuildEventKind.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.jetbrains.rider.model.BuildEventKind.Reference.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[WhenShowBuildResultMode.values().length];
            try {
                nArray[WhenShowBuildResultMode.Always.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WhenShowBuildResultMode.ForErrors.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WhenShowBuildResultMode.ForWarningsOrErrors.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WhenShowBuildResultMode.Never.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

