/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.build.BuildEventsService;
import com.jetbrains.rider.build.BuildHostKt;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.BuildProgressOnApplicationIconProgressIndicator;
import com.jetbrains.rider.build.BuildRequest;
import com.jetbrains.rider.build.BuildSessionView;
import com.jetbrains.rider.build.BuildToolWindowFactory;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.ui.OpenFileWithTargetFrameworkDescriptor;
import com.jetbrains.rider.model.BuildArgs;
import com.jetbrains.rider.model.BuildModel;
import com.jetbrains.rider.model.BuildModel_PregeneratedKt;
import com.jetbrains.rider.model.BuildResult;
import com.jetbrains.rider.model.BuildResultKind;
import com.jetbrains.rider.model.BuildSession;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.CleanTarget;
import com.jetbrains.rider.model.CustomTarget;
import com.jetbrains.rider.model.RdBuildEventNavigation;
import com.jetbrains.rider.model.RebuildTarget;
import com.jetbrains.rider.model.build.BuildEvent;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.settings.SettingsSynchronizer;
import com.jetbrains.rider.util.idea.IExternalTask;
import com.jetbrains.rider.util.idea.ProgressApiKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 92\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u000fH\u0002J5\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2%\b\u0002\u0010-\u001a\u001f\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020'\u0018\u00010.J5\u00103\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2%\b\u0002\u0010-\u001a\u001f\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020'\u0018\u00010.J\b\u00104\u001a\u00020'H\u0002J\u0018\u00105\u001a\u00020'2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u000bH\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/jetbrains/rider/build/BuildHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildModel", "Lcom/jetbrains/rider/model/BuildModel;", "getBuildModel", "()Lcom/jetbrains/rider/model/BuildModel;", "buildSession", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/rider/model/BuildSession;", "getBuildSession", "()Lcom/jetbrains/rd/util/reactive/Property;", "building", "", "getBuilding", "canceling", "getCanceling", "lastBuildLog", "", "getLastBuildLog", "notificationsExpireOnBuildFinish", "", "Lcom/intellij/notification/Notification;", "notificationsExpireOnBuildStart", "getProject", "()Lcom/intellij/openapi/project/Project;", "queuedRequest", "Lcom/jetbrains/rider/build/BuildRequest;", "getQueuedRequest", "()Lcom/jetbrains/rider/build/BuildRequest;", "setQueuedRequest", "(Lcom/jetbrains/rider/build/BuildRequest;)V", "ready", "getReady", "settingsSynchronizer", "Lcom/jetbrains/rider/settings/SettingsSynchronizer;", "cancel", "", "j", "value", "queueBuild", "buildParameters", "Lcom/jetbrains/rider/build/BuildParameters;", "onFinished", "Lkotlin/Function1;", "Lcom/jetbrains/rider/model/BuildResultKind;", "Lkotlin/ParameterName;", "name", "result", "requestBuild", "j", "j", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Companion", "ProtocolListener", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost\n+ 2 IProtocolHost.kt\ncom/jetbrains/rider/protocol/IProtocolHostKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,362:1\n24#2:363\n800#3,11:364\n1855#3:375\n1856#3:377\n1#4:376\n31#5,2:378\n*S KotlinDebug\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost\n*L\n73#1:363\n73#1:364,11\n87#1:375\n87#1:377\n148#1:378,2\n*E\n"})
public final class BuildHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SettingsSynchronizer settingsSynchronizer;
    @NotNull
    private final Property<Boolean> ready;
    @NotNull
    private final Property<Boolean> building;
    @NotNull
    private final Property<Boolean> canceling;
    @NotNull
    private final Property<String> lastBuildLog;
    @NotNull
    private final Property<BuildSession> buildSession;
    @Nullable
    private BuildRequest queuedRequest;
    @NotNull
    private final List<Notification> notificationsExpireOnBuildStart;
    @NotNull
    private final List<Notification> notificationsExpireOnBuildFinish;
    @NotNull
    public static final String GLOBAL_BUILD_GROUP_ID = "Global Build Messages";

    public BuildHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        IProtocolHost iProtocolHost = ApplicationProtocolKt.getProtocolHost((Project)this.project);
        BuildHost buildHost = this;
        boolean bl = false;
        Iterable iterable = iProtocolHost.getComponents();
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            if (!(t instanceof SettingsSynchronizer)) continue;
            collection.add(t);
        }
        buildHost.settingsSynchronizer = (SettingsSynchronizer)((ProtocolComponent)CollectionsKt.single((List)((List)collection)));
        this.ready = new Property((Object)false);
        this.building = new Property((Object)false);
        this.canceling = new Property((Object)false);
        this.lastBuildLog = new Property((Object)"");
        this.buildSession = new Property(null);
        this.notificationsExpireOnBuildStart = new ArrayList();
        this.notificationsExpireOnBuildFinish = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BuildModel getBuildModel() {
        return BuildModel_PregeneratedKt.getBuildModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
    }

    @NotNull
    public final Property<Boolean> getReady() {
        return this.ready;
    }

    @NotNull
    public final Property<Boolean> getBuilding() {
        return this.building;
    }

    @NotNull
    public final Property<Boolean> getCanceling() {
        return this.canceling;
    }

    @NotNull
    public final Property<String> getLastBuildLog() {
        return this.lastBuildLog;
    }

    @NotNull
    public final Property<BuildSession> getBuildSession() {
        return this.buildSession;
    }

    @Nullable
    public final BuildRequest getQueuedRequest() {
        return this.queuedRequest;
    }

    public final void setQueuedRequest(@Nullable BuildRequest buildRequest) {
        this.queuedRequest = buildRequest;
    }

    private final void j(Lifetime lifetime2, BuildSession buildSession) {
        Object object;
        boolean bl;
        Notification notification2;
        Object object22;
        Iterable iterable = this.notificationsExpireOnBuildStart;
        boolean bl2 = false;
        for (Object object22 : iterable) {
            Object object3;
            notification2 = (Notification)object22;
            bl = false;
            object = BuildHostKt.access$getLogger$p();
            try {
                object3 = object;
                boolean bl3 = false;
                notification2.expire();
                object3 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        this.notificationsExpireOnBuildStart.clear();
        iterable = lifetime2.createNested();
        Lifetime lifetime3 = iterable.getLifetime();
        buildSession.getResult().advise(lifetime2, (Function1)new Function1<BuildResult, Unit>((LifetimeDefinition)iterable, this){
            final /* synthetic */ LifetimeDefinition $activeBuildLifetimeDef;
            final /* synthetic */ BuildHost this$0;
            {
                this.$activeBuildLifetimeDef = $activeBuildLifetimeDef;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BuildResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$activeBuildLifetimeDef, (boolean)false, (int)1, null);
                this.this$0.getBuilding().setValue((Object)false);
                this.this$0.getCanceling().setValue((Object)false);
                ActionToolbarImpl.updateAllToolbarsImmediately();
                Iterable iterable = BuildHost.access$getNotificationsExpireOnBuildFinish$p(this.this$0);
                boolean bl = false;
                for (T t : iterable) {
                    Object object;
                    Notification notification2 = (Notification)t;
                    boolean bl2 = false;
                    Logger logger2 = BuildHostKt.access$getLogger$p();
                    try {
                        object = logger2;
                        boolean bl3 = false;
                        notification2.expire();
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                }
                BuildHost.access$getNotificationsExpireOnBuildFinish$p(this.this$0).clear();
            }
        });
        this.buildSession.setValue((Object)buildSession);
        lifetime2.onTermination((Function0)new Function0<Unit>(this, buildSession){
            final /* synthetic */ BuildHost this$0;
            final /* synthetic */ BuildSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(0);
            }

            public final void invoke() {
                if (Intrinsics.areEqual((Object)this.this$0.getBuildSession().getValue(), (Object)this.$session)) {
                    this.this$0.getBuildSession().setValue(null);
                }
            }
        });
        this.building.setValue((Object)true);
        this.canceling.setValue((Object)false);
        this.lastBuildLog.setValue((Object)"");
        buildSession.getLogFileName().view(lifetime2, (Function2)new Function2<Lifetime, String, Unit>(this){
            final /* synthetic */ BuildHost this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Lifetime logFileLifetime, @NotNull String fileName) {
                Intrinsics.checkNotNullParameter((Object)logFileLifetime, (String)"logFileLifetime");
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                if (((CharSequence)fileName).length() > 0) {
                    this.this$0.getLastBuildLog().setValue((Object)fileName);
                }
                logFileLifetime.onTermination((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ BuildHost this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getLastBuildLog().setValue((Object)"");
                    }
                });
            }
        });
        String string = buildSession.getProgressTitle();
        object22 = (Function0)new Function0<Unit>(this, buildSession){
            final /* synthetic */ BuildHost this$0;
            final /* synthetic */ BuildSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(0);
            }

            public final void invoke() {
                InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)this.this$0.getBuildModel())).getScheduler().invokeOrQueue((Function0)new Function0<Unit>(this.this$0, this.$session){
                    final /* synthetic */ BuildHost this$0;
                    final /* synthetic */ BuildSession $session;
                    {
                        this.this$0 = $receiver;
                        this.$session = $session;
                        super(0);
                    }

                    public final void invoke() {
                        if (RLifetimeKt.isAlive((Lifetime)BuildHost.access$getServiceLifetime(this.this$0))) {
                            com.jetbrains.rd.util.reactive.InterfacesKt.fire((ISignal)this.$session.getCancel());
                        }
                    }
                });
            }
        };
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.canceling), (Lifetime)lifetime2, (Function1)((Function1)new Function1<Lifetime, Unit>(object22){
            final /* synthetic */ Function0<Unit> $cancelAction;
            {
                this.$cancelAction = $cancelAction;
                super(1);
            }

            public final void invoke(@NotNull Lifetime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$cancelAction.invoke();
            }
        }));
        if (!ApplicationKt.getApplication().isUnitTestMode() && BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.settingsSynchronizer.getSettingsModel().getShowBuildProgressOnStatusBar()))) {
            notification2 = ProgressApiKt.externalTask((Project)this.project, (boolean)true, (IExternalTask)new IExternalTask(lifetime3, (Function0<Unit>)object22, string, buildSession){
                final /* synthetic */ Lifetime $activeBuildLifetime;
                final /* synthetic */ Function0<Unit> $cancelAction;
                final /* synthetic */ String $progressTitle;
                final /* synthetic */ BuildSession $session;
                {
                    this.$activeBuildLifetime = $activeBuildLifetime;
                    this.$cancelAction = $cancelAction;
                    this.$progressTitle = $progressTitle;
                    this.$session = $session;
                }

                @NotNull
                public Lifetime getLifetime() {
                    return this.$activeBuildLifetime;
                }

                @NotNull
                public Function0<Unit> getCancel() {
                    return this.$cancelAction;
                }

                @NotNull
                public String getTitle() {
                    return this.$progressTitle;
                }

                @NotNull
                public String getHeader() {
                    return (String)this.$session.getActiveProjectName().getValue();
                }

                @NotNull
                public String getDescription() {
                    return "";
                }

                public boolean isIndeterminate() {
                    return false;
                }

                public double getProgress() {
                    return ((Number)this.$session.getProgress().getValue()).doubleValue();
                }
            }, (ProgressIndicatorEx)((ProgressIndicatorEx)new BuildProgressOnApplicationIconProgressIndicator(lifetime2, this.project, buildSession)));
            BuildHostKt.access$getLogger$p().trace("Build running with progress on application icon");
            ProgressManager.getInstance().run((Task)notification2);
        } else {
            BuildHostKt.access$getLogger$p().trace("Build running without progress on application icon");
        }
        notification2 = (ComponentManager)this.project;
        bl = false;
        object = BuildSessionView.class;
        Object object4 = notification2.getService((Class)object);
        if (object4 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)notification2, (Class)object);
        }
        ((BuildSessionView)((Object)object4)).viewBuildSession(lifetime2, buildSession);
    }

    private final void j(boolean bl) {
        BuildRequest buildRequest;
        this.ready.setValue((Object)bl);
        if (bl && (buildRequest = this.queuedRequest) != null) {
            BuildHostKt.access$getLogger$p().trace("Transform queued request into backend request");
            this.requestBuild(buildRequest.getBuildParameters(), buildRequest.getOnFinished());
            this.building.setValue((Object)true);
            BuildHostKt.access$getLogger$p().trace("Cleanup queued request");
            this.queuedRequest = null;
        }
    }

    public final void cancel() {
        if (this.queuedRequest != null) {
            BuildHostKt.access$getLogger$p().trace("Cancel: clear queuedRequest");
            this.queuedRequest = null;
        } else {
            BuildHostKt.access$getLogger$p().trace("Cancel: send signal to backend");
            this.canceling.setValue((Object)true);
            com.jetbrains.rd.util.reactive.InterfacesKt.fire((ISignal)this.getBuildModel().getCancelCurrentRequest());
        }
    }

    public final boolean requestBuild(@NotNull BuildParameters buildParameters, @Nullable Function1<? super BuildResultKind, Unit> onFinished) {
        Intrinsics.checkNotNullParameter((Object)buildParameters, (String)"buildParameters");
        ThreadingAssertions.assertEventDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        if (BuildHostKt.access$getLogger$p().isTraceEnabled()) {
            BuildHostKt.access$getLogger$p().trace((Throwable)new Exception("requestBuild stack"));
        }
        if (((Boolean)this.building.getValue()).booleanValue()) {
            Notification notification2 = new Notification(GLOBAL_BUILD_GROUP_ID, "", RiderBuildBundle.Companion.message("BuildHost.notification.content.cannot.start.already.building", new Object[0]), NotificationType.WARNING);
            Notifications.Bus.notify((Notification)notification2, (Project)this.project);
            this.notificationsExpireOnBuildFinish.add(notification2);
            if (onFinished != null) {
                onFinished.invoke((Object)BuildResultKind.Crashed);
            }
            return false;
        }
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.getBuildModel().getReady()))) {
            try {
                BuildHostKt.access$getLogger$p().info("Request new build: operation=" + buildParameters.getOperation().getClass().getSimpleName() + ", selectedProjectPaths='" + CollectionsKt.joinToString$default((Iterable)buildParameters.getSelectedProjectsPaths(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "', silentMode=" + buildParameters.getSilentMode() + ", activateWindowOnStart=" + buildParameters.getActivateWindowOnStart() + ", diagnosticsMode=" + buildParameters.getDiagnosticsMode() + ", withoutDependencies=" + buildParameters.getWithoutDependencies() + ", targetFramework=" + buildParameters.getTargetFramework());
                this.buildSession.set(null);
                BuildTargetBase buildTargetBase = buildParameters.getOperation();
                this.getBuildModel().getRequest().set((Object)new BuildArgs(buildTargetBase, buildParameters.getSelectedProjectsPaths(), buildParameters.getDiagnosticsMode(), buildParameters.getSilentMode(), buildParameters.getWithoutDependencies(), buildParameters.getNoRestore(), buildParameters.getTargetFramework()));
                LifetimeDefinition lifetimeDefinition = this.getServiceLifetime().createNested();
                Lifetime lifetime2 = lifetimeDefinition.getLifetime();
                com.jetbrains.rd.util.reactive.InterfacesKt.viewNotNull((IViewable)((IViewable)this.buildSession), (Lifetime)lifetime2, (Function2)((Function2)new Function2<Lifetime, BuildSession, Unit>(this, buildParameters, lifetimeDefinition, onFinished, lifetime2){
                    final /* synthetic */ BuildHost this$0;
                    final /* synthetic */ BuildParameters $buildParameters;
                    final /* synthetic */ LifetimeDefinition $buildLifetimeDef;
                    final /* synthetic */ Function1<BuildResultKind, Unit> $onFinished;
                    final /* synthetic */ Lifetime $buildLifetime;
                    {
                        this.this$0 = $receiver;
                        this.$buildParameters = $buildParameters;
                        this.$buildLifetimeDef = $buildLifetimeDef;
                        this.$onFinished = $onFinished;
                        this.$buildLifetime = $buildLifetime;
                        super(2);
                    }

                    public final void invoke(@NotNull Lifetime sessionLifetime, @NotNull BuildSession session) {
                        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
                        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                        BuildHostKt.access$getLogger$p().info("Build session started");
                        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)BuildHost.access$getSettingsSynchronizer$p(this.this$0).getSettingsModel().getShowBuildProgressInToolWindow())) && (this.$buildParameters.getActivateWindowOnStart() || BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)BuildHost.access$getSettingsSynchronizer$p(this.this$0).getRiderSettingsModel().getSolBuilderShowToolWindowWithoutSmartness())))) {
                            BuildToolWindowFactory.Companion.getInstance(this.this$0.getProject()).getOrCreateContext(this.this$0.getProject()).showToolWindowIfHidden(false);
                        }
                        session.getResult().advise(sessionLifetime, (Function1)new Function1<BuildResult, Unit>(this.this$0, this.$buildLifetimeDef, this.$onFinished){
                            final /* synthetic */ BuildHost this$0;
                            final /* synthetic */ LifetimeDefinition $buildLifetimeDef;
                            final /* synthetic */ Function1<BuildResultKind, Unit> $onFinished;
                            {
                                this.this$0 = $receiver;
                                this.$buildLifetimeDef = $buildLifetimeDef;
                                this.$onFinished = $onFinished;
                                super(1);
                            }

                            public final void invoke(@NotNull BuildResult res) {
                                Intrinsics.checkNotNullParameter((Object)res, (String)"res");
                                BuildHostKt.access$getLogger$p().info("Build finished with result: " + res);
                                BuildHost.access$updateFileSystem(this.this$0);
                                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$buildLifetimeDef, (boolean)false, (int)1, null);
                                if (this.$onFinished != null) {
                                    this.$onFinished.invoke((Object)res.getKind());
                                }
                            }
                        });
                        sessionLifetime.onTermination((Function0)new Function0<Unit>(this.$buildLifetime, this.$buildLifetimeDef, this.$onFinished){
                            final /* synthetic */ Lifetime $buildLifetime;
                            final /* synthetic */ LifetimeDefinition $buildLifetimeDef;
                            final /* synthetic */ Function1<BuildResultKind, Unit> $onFinished;
                            {
                                this.$buildLifetime = $buildLifetime;
                                this.$buildLifetimeDef = $buildLifetimeDef;
                                this.$onFinished = $onFinished;
                                super(0);
                            }

                            public final void invoke() {
                                if (RLifetimeKt.isAlive((Lifetime)this.$buildLifetime)) {
                                    BuildHostKt.access$getLogger$p().info("Build finished by lifetime termination");
                                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$buildLifetimeDef, (boolean)false, (int)1, null);
                                    if (this.$onFinished != null) {
                                        this.$onFinished.invoke((Object)BuildResultKind.Crashed);
                                    }
                                }
                            }
                        });
                    }
                }));
                this.building.set((Object)true);
                return true;
            }
            catch (Throwable throwable) {
                BuildHostKt.access$getLogger$p().error(throwable);
                if (onFinished != null) {
                    onFinished.invoke((Object)BuildResultKind.Crashed);
                }
                return false;
            }
        }
        BuildHostKt.access$getLogger$p().warn("Cannot execute request !buildModel.buildModelReady.hasValue");
        if (onFinished != null) {
            onFinished.invoke((Object)BuildResultKind.Crashed);
        }
        return false;
    }

    public static /* synthetic */ boolean requestBuild$default(BuildHost buildHost, BuildParameters buildParameters, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return buildHost.requestBuild(buildParameters, (Function1<? super BuildResultKind, Unit>)function1);
    }

    private final void j() {
        boolean bl = !ApplicationKt.getApplication().isUnitTestMode();
        LocalFileSystem.getInstance().refresh(bl);
    }

    public final void queueBuild(@NotNull BuildParameters buildParameters, @Nullable Function1<? super BuildResultKind, Unit> onFinished) {
        Intrinsics.checkNotNullParameter((Object)buildParameters, (String)"buildParameters");
        this.queuedRequest = new BuildRequest(buildParameters, onFinished);
        Notification notification2 = new Notification(GLOBAL_BUILD_GROUP_ID, "", RiderBuildBundle.Companion.message("BuildHost.notification.content.queue.build", new Object[0]), NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification2, (Project)this.project);
        this.notificationsExpireOnBuildStart.add(notification2);
    }

    public static /* synthetic */ void queueBuild$default(BuildHost buildHost, BuildParameters buildParameters, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        buildHost.queueBuild(buildParameters, (Function1<? super BuildResultKind, Unit>)function1);
    }

    public static final /* synthetic */ List access$getNotificationsExpireOnBuildFinish$p(BuildHost $this) {
        return $this.notificationsExpireOnBuildFinish;
    }

    public static final /* synthetic */ Lifetime access$getServiceLifetime(BuildHost $this) {
        return $this.getServiceLifetime();
    }

    public static final /* synthetic */ SettingsSynchronizer access$getSettingsSynchronizer$p(BuildHost $this) {
        return $this.settingsSynchronizer;
    }

    public static final /* synthetic */ void access$updateFileSystem(BuildHost $this) {
        $this.j();
    }

    public static final /* synthetic */ void access$viewBuildSession(BuildHost $this, Lifetime sessionLifetime, BuildSession session) {
        $this.j(sessionLifetime, session);
    }

    public static final /* synthetic */ void access$handleReadyChange(BuildHost $this, boolean value) {
        $this.j(value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/build/BuildHost$Companion;", "", "()V", "GLOBAL_BUILD_GROUP_ID", "", "getBuildTargetName", "buildTarget", "Lcom/jetbrains/rider/model/BuildTargetBase;", "getInstance", "Lcom/jetbrains/rider/build/BuildHost;", "project", "Lcom/intellij/openapi/project/Project;", "isIdle", "", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nBuildHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,362:1\n31#2,2:363\n*S KotlinDebug\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost$Companion\n*L\n65#1:363,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getBuildTargetName(@NotNull BuildTargetBase buildTarget) {
            Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
            BuildTargetBase buildTargetBase = buildTarget;
            if (buildTargetBase instanceof BuildTarget) {
                return "Build";
            }
            if (buildTargetBase instanceof RebuildTarget) {
                return "Rebuild";
            }
            if (buildTargetBase instanceof CleanTarget) {
                return "Clean";
            }
            if (buildTargetBase instanceof CustomTarget) {
                return ((CustomTarget)buildTarget).getTargetName();
            }
            return "";
        }

        @NotNull
        public final BuildHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<BuildHost> clazz = BuildHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (BuildHost)((Object)object);
        }

        public final boolean isIdle(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BuildHost buildHost = this.getInstance(project);
            return (Boolean)buildHost.getReady().getValue() != false && buildHost.getQueuedRequest() == null && (Boolean)buildHost.getBuilding().getValue() == false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/build/BuildHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/BuildModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "j", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "", "projectId", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nBuildHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost$ProtocolListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n1855#2,2:363\n*S KotlinDebug\n*F\n+ 1 BuildHost.kt\ncom/jetbrains/rider/build/BuildHost$ProtocolListener\n*L\n347#1:363,2\n*E\n"})
    public static final class ProtocolListener
    implements SolutionExtListener<BuildModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session, @NotNull BuildModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            com.jetbrains.rd.util.reactive.InterfacesKt.viewNotNull((IViewable)((IViewable)model2.getBuildSession()), (Lifetime)lifetime2, (Function2)((Function2)new Function2<Lifetime, BuildSession, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(2);
                }

                public final void invoke(@NotNull Lifetime sessionLifetime, @NotNull BuildSession buildSession) {
                    Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
                    Intrinsics.checkNotNullParameter((Object)buildSession, (String)"buildSession");
                    BuildHost.access$viewBuildSession(BuildHost.Companion.getInstance(this.$session.getProject()), sessionLifetime, buildSession);
                }
            }));
            model2.getReady().advise(lifetime2, (Function1)new Function1<Boolean, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(boolean it) {
                    BuildHost.access$handleReadyChange(BuildHost.Companion.getInstance(this.$session.getProject()), it);
                }
            });
            model2.getRequestIsCancelledBeforeExecution().advise(lifetime2, (Function1)new Function1<Unit, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(@NotNull Unit it) {
                    BuildHost buildHost;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    BuildHost buildHost2 = buildHost = BuildHost.Companion.getInstance(this.$session.getProject());
                    boolean bl = false;
                    BuildHostKt.access$getLogger$p().trace("Receive requestIsCancelledBeforeExecution");
                    buildHost2.getCanceling().setValue((Object)false);
                    buildHost2.getBuilding().setValue((Object)false);
                }
            });
            model2.getNavigateToEvent().advise(lifetime2, (Function1)new Function1<RdBuildEventNavigation, Unit>(session, this){
                final /* synthetic */ ClientProjectSession $session;
                final /* synthetic */ ProtocolListener this$0;
                {
                    this.$session = $session;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull RdBuildEventNavigation it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    BuildHost buildHost = BuildHost.Companion.getInstance(this.$session.getProject());
                    ClientProjectSession clientProjectSession = this.$session;
                    ProtocolListener protocolListener = this.this$0;
                    BuildHost buildHost2 = buildHost;
                    boolean bl = false;
                    BuildEventsService buildEventsService = BuildEventsService.Companion.getInstance(clientProjectSession.getProject());
                    if (buildEventsService.isSessionActive()) {
                        try {
                            VirtualFile virtualFile2;
                            int n;
                            int n2;
                            BuildEvent buildEvent = buildEventsService.getEvent(it.getOffset());
                            if (buildEvent.getLine() != null) {
                                Integer n3 = buildEvent.getLine();
                                Intrinsics.checkNotNull((Object)n3);
                                v1 = n3;
                            } else {
                                v1 = n2 = 1;
                            }
                            if (buildEvent.getColumn() != null) {
                                Integer n4 = buildEvent.getColumn();
                                Intrinsics.checkNotNull((Object)n4);
                                n = n4;
                            } else {
                                n = 1;
                            }
                            int n5 = n;
                            String string = buildEvent.getFilePath();
                            boolean bl2 = string != null ? ((CharSequence)string).length() > 0 : false;
                            if (bl2 && buildEvent.getProjectId() != null) {
                                String string2 = buildEvent.getFilePath();
                                Intrinsics.checkNotNull((Object)string2);
                                Integer n6 = buildEvent.getProjectId();
                                Intrinsics.checkNotNull((Object)n6);
                                v8 = ProtocolListener.access$resolveSourceFile(protocolListener, string2, n6, clientProjectSession.getProject());
                            } else {
                                v8 = virtualFile2 = null;
                            }
                            if (virtualFile2 != null) {
                                OpenFileWithTargetFrameworkDescriptor openFileWithTargetFrameworkDescriptor = new OpenFileWithTargetFrameworkDescriptor(buildHost2.getProject(), virtualFile2, n2 - 1, n5 - 1, buildEvent.getTargetFramework(), buildEvent.getProjectId());
                                openFileWithTargetFrameworkDescriptor.navigate(true);
                            }
                        }
                        catch (Exception exception) {
                            BuildHostKt.access$getLogger$p().error("Failed navigation to " + it.getOffset(), (Throwable)exception);
                        }
                    }
                }
            });
        }

        private final VirtualFile j(String string, int n, Project project) {
            File file2 = new File(string);
            if (file2.isAbsolute()) {
                return VfsUtil.findFileByIoFile((File)file2, (boolean)false);
            }
            WorkspaceModel workspaceModel2 = WorkspaceModel.Companion.getInstance(project);
            Object object = new ProjectModelEntity[]{WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)workspaceModel2, (int)n), WorkspaceModelExtensionsKt.getSolutionEntity((WorkspaceModel)workspaceModel2)};
            List list2 = CollectionsKt.listOf((Object[])object);
            object = CollectionsKt.filterNotNull((Iterable)list2);
            boolean bl = false;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
                boolean bl2 = false;
                VirtualFile virtualFile2 = ProjectModelEntityExtensionsKt.getVirtualFileAsParent((ProjectModelEntity)projectModelEntity);
                if (virtualFile2 == null) continue;
                File file3 = DocumentUtilKt.toIOFile((VirtualFile)virtualFile2);
                String string2 = file2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                VirtualFile virtualFile3 = VfsUtil.findFileByIoFile((File)FilesKt.resolve((File)file3, (String)string2), (boolean)true);
                if (virtualFile3 == null) continue;
                return virtualFile3;
            }
            return null;
        }

        public static final /* synthetic */ VirtualFile access$resolveSourceFile(ProtocolListener $this, String filePath, int projectId, Project project) {
            return $this.j(filePath, projectId, project);
        }
    }
}

