/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.build.InFileBuildEventsLoader;
import com.jetbrains.rider.build.redesign.model.BuildNotificationsListener;
import com.jetbrains.rider.model.BuildEventKind;
import com.jetbrains.rider.model.BuildEventRef;
import com.jetbrains.rider.model.BuildSession;
import com.jetbrains.rider.model.build.BuildEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\b\u0007\u0018\u0000 62\u00020\u0001:\u000267B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019J\b\u0010)\u001a\u0004\u0018\u00010*J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J.\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u00100\u001a\u00020$2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0019\u0012\u0004\u0012\u00020\u001a0\u0018J\u0006\u00102\u001a\u00020\u001eJ\u0006\u00103\u001a\u00020\u001aJ\u000e\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u0010R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\r\u00a8\u00068"}, d2={"Lcom/jetbrains/rider/build/BuildEventsService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOCK", "", "Lorg/jetbrains/annotations/NotNull;", "errCnt", "", "getErrCnt", "()I", "setErrCnt", "(I)V", "listeners", "", "Lcom/jetbrains/rider/build/redesign/model/BuildNotificationsListener;", "loader", "Lcom/jetbrains/rider/build/InFileBuildEventsLoader;", "myCurrentEvents", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/model/BuildEventRef;", "Lkotlin/collections/ArrayList;", "myEventHandlers", "Lkotlin/Function1;", "", "", "mySequence", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "sessionActive", "", "warnCnt", "getWarnCnt", "setWarnCnt", "acceptNewSession", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/jetbrains/rider/model/BuildSession;", "consumeRefs", "refs", "getCurrentStatistics", "Lcom/jetbrains/rider/build/BuildEventsService$SessionEventStatistics;", "getEvent", "Lcom/jetbrains/rider/model/build/BuildEvent;", "item", "", "getEventsAndSubscribe", "lifetime", "handler", "isSessionActive", "notifyBuildFinished", "replaceListener", "l", "Companion", "SessionEventStatistics", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildEventsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildEventsService.kt\ncom/jetbrains/rider/build/BuildEventsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1855#2,2:102\n*S KotlinDebug\n*F\n+ 1 BuildEventsService.kt\ncom/jetbrains/rider/build/BuildEventsService\n*L\n53#1:102,2\n*E\n"})
public final class BuildEventsService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<Function1<List<BuildEventRef>, Unit>> myEventHandlers;
    @Nullable
    private InFileBuildEventsLoader loader;
    @NotNull
    private final SequentialLifetimes mySequence;
    private int errCnt;
    private int warnCnt;
    @NotNull
    private ArrayList<BuildEventRef> myCurrentEvents;
    @NotNull
    private final List<BuildNotificationsListener> listeners;
    private boolean sessionActive;
    @NotNull
    private final Object LOCK;

    public BuildEventsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myEventHandlers = new ArrayList();
        this.mySequence = new SequentialLifetimes(this.getServiceLifetime());
        this.myCurrentEvents = new ArrayList();
        this.listeners = new ArrayList();
        Object object = ObjectUtils.sentinel((String)"BuildEventsService Lock");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.LOCK = object;
    }

    public final int getErrCnt() {
        return this.errCnt;
    }

    public final void setErrCnt(int n) {
        this.errCnt = n;
    }

    public final int getWarnCnt() {
        return this.warnCnt;
    }

    public final void setWarnCnt(int n) {
        this.warnCnt = n;
    }

    public final void replaceListener(@NotNull BuildNotificationsListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.clear();
        this.listeners.add(l);
    }

    public final void notifyBuildFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void consumeRefs(@NotNull List<BuildEventRef> refs) {
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            int n = 0;
            for (BuildEventRef buildEventRef : refs) {
                int n2;
                if (n == 0 && buildEventRef.getProjectId() != null) {
                    Integer n3 = buildEventRef.getProjectId();
                    Intrinsics.checkNotNull((Object)n3);
                    n = n3;
                }
                if (buildEventRef.getKind() == BuildEventKind.Error) {
                    n2 = this.errCnt;
                    this.errCnt = n2 + 1;
                }
                if (buildEventRef.getKind() == BuildEventKind.Warning) {
                    n2 = this.warnCnt;
                    this.warnCnt = n2 + 1;
                }
                this.myCurrentEvents.add(buildEventRef);
            }
            Iterable iterable = this.myEventHandlers;
            boolean bl2 = false;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                Function1 function1 = (Function1)t;
                boolean bl3 = false;
                function1.invoke(refs);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void acceptNewSession(@NotNull Lifetime sessionLifetime, @NotNull BuildSession session) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Lifetime lifetime2 = this.mySequence.next().getLifetime();
            sessionLifetime.onTermination((Function0)new Function0<Unit>(this){
                final /* synthetic */ BuildEventsService this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    BuildEventsService.access$getMySequence$p(this.this$0).terminateCurrent();
                }
            });
            this.loader = new InFileBuildEventsLoader(lifetime2, session.getEventsStoragePath());
            this.sessionActive = true;
            lifetime2.onTermination((Function0)new Function0<Unit>(this){
                final /* synthetic */ BuildEventsService this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    BuildEventsService.access$getMyCurrentEvents$p(this.this$0).clear();
                    BuildEventsService.access$getListeners$p(this.this$0).clear();
                    BuildEventsService.access$setSessionActive$p(this.this$0, false);
                    this.this$0.setErrCnt(0);
                    this.this$0.setWarnCnt(0);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isSessionActive() {
        return this.sessionActive;
    }

    @NotNull
    public final BuildEvent getEvent(long item) {
        InFileBuildEventsLoader inFileBuildEventsLoader = this.loader;
        Intrinsics.checkNotNull((Object)inFileBuildEventsLoader);
        return inFileBuildEventsLoader.loadEvent(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<BuildEventRef> getEventsAndSubscribe(@NotNull Lifetime lifetime2, @NotNull Function1<? super List<BuildEventRef>, Unit> handler2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            this.myEventHandlers.add(handler2);
            lifetime2.onTermination((Function0)new Function0<Unit>(this, handler2){
                final /* synthetic */ BuildEventsService this$0;
                final /* synthetic */ Function1<List<BuildEventRef>, Unit> $handler;
                {
                    this.this$0 = $receiver;
                    this.$handler = $handler;
                    super(0);
                }

                public final void invoke() {
                    BuildEventsService.access$getMyEventHandlers$p(this.this$0).remove(this.$handler);
                }
            });
            List list2 = CollectionsKt.toList((Iterable)this.myCurrentEvents);
            return list2;
        }
    }

    @Nullable
    public final SessionEventStatistics getCurrentStatistics() {
        if (this.loader == null) {
            return null;
        }
        int n = ((Collection)this.myCurrentEvents).size();
        InFileBuildEventsLoader inFileBuildEventsLoader = this.loader;
        Intrinsics.checkNotNull((Object)inFileBuildEventsLoader);
        return new SessionEventStatistics(n, inFileBuildEventsLoader.getLoadedEventsCount(), this.errCnt, this.warnCnt);
    }

    public static final /* synthetic */ SequentialLifetimes access$getMySequence$p(BuildEventsService $this) {
        return $this.mySequence;
    }

    public static final /* synthetic */ ArrayList access$getMyCurrentEvents$p(BuildEventsService $this) {
        return $this.myCurrentEvents;
    }

    public static final /* synthetic */ List access$getListeners$p(BuildEventsService $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ void access$setSessionActive$p(BuildEventsService $this, boolean bl) {
        $this.sessionActive = bl;
    }

    public static final /* synthetic */ List access$getMyEventHandlers$p(BuildEventsService $this) {
        return $this.myEventHandlers;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/build/BuildEventsService$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/build/BuildEventsService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nBuildEventsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildEventsService.kt\ncom/jetbrains/rider/build/BuildEventsService$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,101:1\n17#2,2:102\n*S KotlinDebug\n*F\n+ 1 BuildEventsService.kt\ncom/jetbrains/rider/build/BuildEventsService$Companion\n*L\n24#1:102,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BuildEventsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Object object = componentManager.getService(BuildEventsService.class);
            if (object == null) {
                throw new IllegalStateException("Service " + BuildEventsService.class + " not found in container " + componentManager);
            }
            return (BuildEventsService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/build/BuildEventsService$SessionEventStatistics;", "", "totalEvents", "", "loadedEvents", "errCnt", "warnCnt", "(IIII)V", "getErrCnt", "()I", "getLoadedEvents", "getTotalEvents", "getWarnCnt", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider"})
    public static final class SessionEventStatistics {
        private final int totalEvents;
        private final int loadedEvents;
        private final int errCnt;
        private final int warnCnt;

        public SessionEventStatistics(int totalEvents, int loadedEvents, int errCnt, int warnCnt) {
            this.totalEvents = totalEvents;
            this.loadedEvents = loadedEvents;
            this.errCnt = errCnt;
            this.warnCnt = warnCnt;
        }

        public final int getTotalEvents() {
            return this.totalEvents;
        }

        public final int getLoadedEvents() {
            return this.loadedEvents;
        }

        public final int getErrCnt() {
            return this.errCnt;
        }

        public final int getWarnCnt() {
            return this.warnCnt;
        }

        public final int component1() {
            return this.totalEvents;
        }

        public final int component2() {
            return this.loadedEvents;
        }

        public final int component3() {
            return this.errCnt;
        }

        public final int component4() {
            return this.warnCnt;
        }

        @NotNull
        public final SessionEventStatistics copy(int totalEvents, int loadedEvents, int errCnt, int warnCnt) {
            return new SessionEventStatistics(totalEvents, loadedEvents, errCnt, warnCnt);
        }

        public static /* synthetic */ SessionEventStatistics copy$default(SessionEventStatistics sessionEventStatistics, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = sessionEventStatistics.totalEvents;
            }
            if ((n5 & 2) != 0) {
                n2 = sessionEventStatistics.loadedEvents;
            }
            if ((n5 & 4) != 0) {
                n3 = sessionEventStatistics.errCnt;
            }
            if ((n5 & 8) != 0) {
                n4 = sessionEventStatistics.warnCnt;
            }
            return sessionEventStatistics.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "SessionEventStatistics(totalEvents=" + this.totalEvents + ", loadedEvents=" + this.loadedEvents + ", errCnt=" + this.errCnt + ", warnCnt=" + this.warnCnt + ")";
        }

        public int hashCode() {
            int n = Integer.hashCode(this.totalEvents);
            n = n * 31 + Integer.hashCode(this.loadedEvents);
            n = n * 31 + Integer.hashCode(this.errCnt);
            n = n * 31 + Integer.hashCode(this.warnCnt);
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionEventStatistics)) {
                return false;
            }
            SessionEventStatistics sessionEventStatistics = (SessionEventStatistics)other;
            if (this.totalEvents != sessionEventStatistics.totalEvents) {
                return false;
            }
            if (this.loadedEvents != sessionEventStatistics.loadedEvents) {
                return false;
            }
            if (this.errCnt != sessionEventStatistics.errCnt) {
                return false;
            }
            return this.warnCnt == sessionEventStatistics.warnCnt;
        }
    }
}

