/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.modulesView;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.impl.modulesView.DebounceDocumentListener;
import com.intellij.xdebugger.impl.modulesView.DebuggerModule;
import com.intellij.xdebugger.impl.modulesView.messages.ModulesViewBundle;
import com.intellij.xdebugger.impl.modulesView.table.ModulesViewTable;
import java.awt.Component;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u001dB\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/xdebugger/impl/modulesView/ModulesView;", "TModule", "Lcom/intellij/xdebugger/impl/modulesView/DebuggerModule;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "parentDisposable", "table", "Lcom/intellij/xdebugger/impl/modulesView/table/ModulesViewTable;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/xdebugger/impl/modulesView/table/ModulesViewTable;)V", "filterField", "Lcom/intellij/ui/SearchTextField;", "mainComponent", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getMainComponent", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "dispose", "", "getData", "", "dataId", "", "getModuleByName", "name", "(Ljava/lang/String;)Lcom/intellij/xdebugger/impl/modulesView/DebuggerModule;", "navigateToModule", "moduleId", "Ljava/util/UUID;", "Companion", "intellij.platform.debugger.modulesView"})
@SourceDebugExtension(value={"SMAP\nModulesView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulesView.kt\ncom/intellij/xdebugger/impl/modulesView/ModulesView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public abstract class ModulesView<TModule extends DebuggerModule>
implements Disposable,
DataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModulesViewTable<TModule> table;
    @NotNull
    private final SearchTextField filterField;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final BorderLayoutPanel mainComponent;
    @NotNull
    private static final DataKey<ModulesViewTable<?>> MODULES_VIEW_TABLE = DataKey.Companion.create("MODULES_VIEW_TABLE");
    @NotNull
    private static final DataKey<CoroutineScope> MODULES_VIEW_SCOPE = DataKey.Companion.create("MODULES_VIEW_SCOPE");

    public ModulesView(@NotNull Disposable parentDisposable, @NotNull ModulesViewTable<TModule> table2) {
        SearchTextField searchTextField2;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(table2, (String)"table");
        this.table = table2;
        Object object = searchTextField2 = new SearchTextField(false);
        ModulesView modulesView = this;
        boolean bl = false;
        object.getTextEditor().getEmptyText().setText(ModulesViewBundle.message("modules.search.placeholder", new Object[0]));
        modulesView.filterField = searchTextField2;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.mainComponent = new BorderLayoutPanel();
        this.table.initialize();
        SearchTextField searchTextField3 = object = new BorderLayoutPanel();
        boolean bl2 = false;
        searchTextField3.addToCenter((Component)this.filterField);
        searchTextField2 = object;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.table)));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        object = jScrollPane;
        BorderLayoutPanel borderLayoutPanel = this.mainComponent;
        boolean bl3 = false;
        borderLayoutPanel.addToTop((Component)searchTextField2);
        borderLayoutPanel.addToCenter((Component)object);
        this.filterField.addDocumentListener((DocumentListener)((Object)new DebounceDocumentListener(this.scope, 300L, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ModulesViewTable modulesViewTable = table;
                String string = filterField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                modulesViewTable.setFilterPattern(string);
            }
        }))));
        DataManager.registerDataProvider((JComponent)((JComponent)((Object)this.table)), (DataProvider)this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.table));
    }

    @NotNull
    public final BorderLayoutPanel getMainComponent() {
        return this.mainComponent;
    }

    public final void navigateToModule(@NotNull UUID moduleId) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        this.table.navigateToModule(moduleId);
    }

    @Nullable
    public final TModule getModuleByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.table.getModuleByName(name);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (MODULES_VIEW_TABLE.is(dataId)) {
            return this.table;
        }
        if (MODULES_VIEW_SCOPE.is(dataId)) {
            return this.scope;
        }
        return null;
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/xdebugger/impl/modulesView/ModulesView$Companion;", "", "()V", "MODULES_VIEW_SCOPE", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lkotlinx/coroutines/CoroutineScope;", "getMODULES_VIEW_SCOPE", "()Lcom/intellij/openapi/actionSystem/DataKey;", "MODULES_VIEW_TABLE", "Lcom/intellij/xdebugger/impl/modulesView/table/ModulesViewTable;", "getMODULES_VIEW_TABLE", "intellij.platform.debugger.modulesView"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<ModulesViewTable<?>> getMODULES_VIEW_TABLE() {
            return MODULES_VIEW_TABLE;
        }

        @NotNull
        public final DataKey<CoroutineScope> getMODULES_VIEW_SCOPE() {
            return MODULES_VIEW_SCOPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

