/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.state;

import com.jetbrains.plugins.vagrant.state.Resolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\u0014\u001a\u00028\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\u00028\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u001a\u0010\f\u001a\u000e\u0018\u00010\rR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugins/vagrant/state/FileCacheWithValidityPeriodFallback;", "T", "", "path", "Ljava/nio/file/Path;", "validityPeriod", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/nio/file/Path;JLjava/util/concurrent/TimeUnit;)V", "validityPeriodInNanos", "(Ljava/nio/file/Path;J)V", "content", "Lcom/jetbrains/plugins/vagrant/state/FileCacheWithValidityPeriodFallback$CachedContent;", "contentLock", "Ljava/lang/Object;", "getPath", "()Ljava/nio/file/Path;", "getValidityPeriodInNanos", "()J", "getContent", "resolver", "Lcom/jetbrains/plugins/vagrant/state/Resolver;", "(Lcom/jetbrains/plugins/vagrant/state/Resolver;)Ljava/lang/Object;", "getContentImpl", "getLastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "CachedContent", "intellij.vagrant"})
public final class FileCacheWithValidityPeriodFallback<T> {
    @NotNull
    private final Path path;
    private final long validityPeriodInNanos;
    @NotNull
    private final Object contentLock;
    @Nullable
    private CachedContent content;

    public FileCacheWithValidityPeriodFallback(@NotNull Path path, long validityPeriodInNanos) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.validityPeriodInNanos = validityPeriodInNanos;
        this.contentLock = new Object();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public final long getValidityPeriodInNanos() {
        return this.validityPeriodInNanos;
    }

    public FileCacheWithValidityPeriodFallback(@NotNull Path path, long validityPeriod, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this(path, timeUnit.toNanos(validityPeriod));
    }

    public final T getContent(@NotNull Resolver<? extends T> resolver2) throws IOException {
        Intrinsics.checkNotNullParameter(resolver2, (String)"resolver");
        return this.getContentImpl(resolver2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final T getContentImpl(Resolver<? extends T> resolver2) {
        Object object = this.contentLock;
        synchronized (object) {
            CachedContent currentContent;
            block5: {
                boolean bl = false;
                currentContent = this.content;
                if (currentContent != null && !currentContent.isInvalidationRequired(this.getLastModifiedTime())) break block5;
                T updatedValue = resolver2.resolve(this.path);
                this.content = new CachedContent(this, updatedValue, this.getLastModifiedTime(), 0L, 4, null);
                T t = updatedValue;
                return t;
            }
            if (currentContent.hasLastModifiedTime()) {
                this.content = currentContent.updateExpiryTime();
            }
            Object t = currentContent.getValue();
            return t;
        }
    }

    private final FileTime getLastModifiedTime() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0013\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugins/vagrant/state/FileCacheWithValidityPeriodFallback$CachedContent;", "", "value", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "expiryTimeInNanos", "", "(Lcom/jetbrains/plugins/vagrant/state/FileCacheWithValidityPeriodFallback;Ljava/lang/Object;Ljava/nio/file/attribute/FileTime;J)V", "getExpiryTimeInNanos", "()J", "getLastModifiedTime", "()Ljava/nio/file/attribute/FileTime;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "hasLastModifiedTime", "", "isInvalidationRequired", "currentLastModifiedTime", "updateExpiryTime", "Lcom/jetbrains/plugins/vagrant/state/FileCacheWithValidityPeriodFallback;", "intellij.vagrant"})
    private final class CachedContent {
        private final T value;
        @Nullable
        private final FileTime lastModifiedTime;
        private final long expiryTimeInNanos;
        final /* synthetic */ FileCacheWithValidityPeriodFallback<T> this$0;

        public CachedContent(FileCacheWithValidityPeriodFallback this$0, @Nullable T value, FileTime lastModifiedTime, long expiryTimeInNanos) {
            this.this$0 = this$0;
            this.value = value;
            this.lastModifiedTime = lastModifiedTime;
            this.expiryTimeInNanos = expiryTimeInNanos;
        }

        public /* synthetic */ CachedContent(FileCacheWithValidityPeriodFallback fileCacheWithValidityPeriodFallback, Object object, FileTime fileTime, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                fileTime = null;
            }
            if ((n & 4) != 0) {
                l = System.nanoTime() + fileCacheWithValidityPeriodFallback.getValidityPeriodInNanos();
            }
            this(fileCacheWithValidityPeriodFallback, object, fileTime, l);
        }

        public final T getValue() {
            return this.value;
        }

        @Nullable
        public final FileTime getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final long getExpiryTimeInNanos() {
            return this.expiryTimeInNanos;
        }

        @NotNull
        public final CachedContent updateExpiryTime() {
            return new CachedContent(this.this$0, this.value, this.lastModifiedTime, 0L, 4, null);
        }

        public final boolean hasLastModifiedTime() {
            return this.lastModifiedTime != null;
        }

        public final boolean isInvalidationRequired(@Nullable FileTime currentLastModifiedTime) {
            return currentLastModifiedTime != null && !Intrinsics.areEqual((Object)currentLastModifiedTime, (Object)this.lastModifiedTime) || currentLastModifiedTime == null && System.nanoTime() > this.expiryTimeInNanos;
        }
    }
}

