#include <Core/Gen8/Den.hpp>
#include <Core/Gen8/StaticTemplate8.hpp>
#include <array>

constexpr std::array<StaticTemplate8, 3> STARTERS = { StaticTemplate8(Game::BDSP, 387, 0, Shiny::Random, 255, 255, 0, 5), StaticTemplate8(Game::BDSP, 390, 0, Shiny::Random, 255, 255, 0, 5), StaticTemplate8(Game::BDSP, 393, 0, Shiny::Random, 255, 255, 0, 5) };

constexpr std::array<StaticTemplate8, 3> GIFTS = { StaticTemplate8(Game::BDSP, 133, 0, Shiny::Random, 255, 255, 0, 5), StaticTemplate8(Game::BDSP, 440, 0, Shiny::Random, 255, 255, 0, 1), StaticTemplate8(Game::BDSP, 447, 0, Shiny::Random, 255, 255, 0, 1) };

constexpr std::array<StaticTemplate8, 7> FOSSILS = { StaticTemplate8(Game::BDSP, 138, 0, Shiny::Random, 255, 255, 3, 1), StaticTemplate8(Game::BDSP, 140, 0, Shiny::Random, 255, 255, 3, 1), StaticTemplate8(Game::BDSP, 142, 0, Shiny::Random, 255, 255, 3, 1), StaticTemplate8(Game::BDSP, 345, 0, Shiny::Random, 255, 255, 3, 1), StaticTemplate8(Game::BDSP, 347, 0, Shiny::Random, 255, 255, 3, 1), StaticTemplate8(Game::BDSP, 408, 0, Shiny::Random, 255, 255, 3, 1), StaticTemplate8(Game::BDSP, 410, 0, Shiny::Random, 255, 255, 3, 1) };

constexpr std::array<StaticTemplate8, 3> STATIONARY = { StaticTemplate8(Game::BDSP, 425, 0, Shiny::Random, 255, 255, 0, 22), StaticTemplate8(Game::BDSP, 442, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate8(Game::BDSP, 479, 0, Shiny::Random, 255, 255, 0, 15) };

constexpr std::array<StaticTemplate8, 2> ROAMERS = { StaticTemplate8(Game::BDSP, 481, 0, Shiny::Random, 255, 255, 3, 50), StaticTemplate8(Game::BDSP, 488, 0, Shiny::Random, 255, 255, 3, 50) };

constexpr std::array<StaticTemplate8, 7> LEGENDS = { StaticTemplate8(Game::BDSP, 480, 0, Shiny::Random, 255, 255, 3, 50), StaticTemplate8(Game::BDSP, 482, 0, Shiny::Random, 255, 255, 3, 50), StaticTemplate8(Game::BD, 483, 0, Shiny::Random, 255, 255, 3, 47), StaticTemplate8(Game::SP, 484, 0, Shiny::Random, 255, 255, 3, 47), StaticTemplate8(Game::BDSP, 485, 0, Shiny::Random, 255, 255, 3, 70), StaticTemplate8(Game::BDSP, 486, 0, Shiny::Random, 255, 255, 3, 70), StaticTemplate8(Game::BDSP, 487, 0, Shiny::Random, 255, 255, 3, 70) };

constexpr std::array<StaticTemplate8, 11> RAMANASPARKPURESPACE = { StaticTemplate8(Game::SP, 144, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::SP, 145, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::SP, 146, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BD, 243, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BD, 244, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BD, 245, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BDSP, 377, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BDSP, 378, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BDSP, 379, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BDSP, 380, 0, Shiny::Random, 255, 255, 3, 70), StaticTemplate8(Game::BDSP, 381, 0, Shiny::Random, 255, 255, 3, 70) };

constexpr std::array<StaticTemplate8, 6> RAMANASPARKSTRANGESPACE = { StaticTemplate8(Game::BDSP, 150, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::SP, 249, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BD, 250, 0, Shiny::Random, 2, 255, 3, 70), StaticTemplate8(Game::BDSP, 382, 0, Shiny::Random, 255, 255, 3, 70), StaticTemplate8(Game::BDSP, 383, 0, Shiny::Random, 255, 255, 3, 70), StaticTemplate8(Game::BDSP, 384, 0, Shiny::Random, 255, 255, 3, 70) };

constexpr std::array<StaticTemplate8, 5> MYTHICS = { StaticTemplate8(Game::BDSP, 151, 0, Shiny::Never, 1, 255, 3, 1), StaticTemplate8(Game::BDSP, 385, 0, Shiny::Never, 1, 255, 3, 5), StaticTemplate8(Game::BDSP, 491, 0, Shiny::Random, 255, 255, 3, 50), StaticTemplate8(Game::BDSP, 492, 0, Shiny::Random, 255, 255, 3, 30), StaticTemplate8(Game::BDSP, 493, 0, Shiny::Random, 255, 255, 3, 80) };

constexpr std::array<Den, 197> NESTS = { Den(0x314acb827c75109, std::array<Raid, 12> {Raid(870, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(236, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(533, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(83, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(870, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(623, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(865, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(534, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(106, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(237, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(68, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(870, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(236, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(533, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(533, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(870, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(623, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(534, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(534, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(107, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(237, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(68, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4c12cee7784c8b8, std::array<Raid, 12> {Raid(769, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(592, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(104, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(425, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(593, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(426, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(770, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(593, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(426, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(105, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(770, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(769, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(592, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(104, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(425, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(593, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(426, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(770, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(593, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(426, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(105, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(770, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x6f948f09933cdfc, std::array<Raid, 12> {Raid(619, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(559, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(539, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(620, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(870, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(766, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(539, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(620, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(560, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(853, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(865, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(619, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(453, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(538, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(620, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(870, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(620, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(538, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(620, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(454, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(853, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(870, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x779e9eb99c1292c, std::array<Raid, 12> {Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(347, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(347, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(345, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(347, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(830, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(348, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(598, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(346, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(345, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(345, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(347, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(345, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(830, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(346, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(598, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(348, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xa5696e4aa8d625a, std::array<Raid, 12> {Raid(303, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(304, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(305, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(305, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(213, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(303, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(303, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(839, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(302, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(304, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(305, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(305, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(213, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(302, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(302, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(839, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xf6389ad0bc9aaeb, std::array<Raid, 12> {Raid(138, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(349, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(138, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(349, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(340, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(550, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(139, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(550, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(350, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(369, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(140, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(349, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(140, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(349, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(340, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(550, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(141, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(550, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(350, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(369, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x12ad4e9a799417a5, std::array<Raid, 12> {Raid(131, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(363, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(364, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(364, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(713, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(615, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(365, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(584, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(365, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(131, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(131, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(363, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(364, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(364, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(713, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(615, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(365, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(584, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(365, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(131, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173efe56dc5df220, std::array<Raid, 12> {Raid(236, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(852, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(674, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(83, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(539, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(760, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(675, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(701, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(865, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(853, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(870, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(236, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(852, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(674, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(538, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(760, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(675, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(701, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(760, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(853, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(870, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173eff56dc5df3d3, std::array<Raid, 12> {Raid(599, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(52, 2, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(878, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(600, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(863, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(437, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(601, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(879, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(599, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(52, 2, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(878, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(600, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(863, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(437, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(601, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(879, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173f0056dc5df586, std::array<Raid, 12> {Raid(599, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(599, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(208, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(437, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(303, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(777, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(599, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(599, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(208, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(437, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(777, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173f0156dc5df739, std::array<Raid, 12> {Raid(439, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(856, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(857, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(561, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(178, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(876, 0, Shiny::Random, 3, 1, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(561, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(826, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(439, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(177, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(856, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(77, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(857, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(561, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(178, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(876, 1, Shiny::Random, 3, 2, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(765, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(78, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173f0256dc5df8ec, std::array<Raid, 12> {Raid(439, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(360, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(343, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(561, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(178, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(876, 0, Shiny::Random, 3, 1, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(344, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(202, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(439, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(360, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(343, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(561, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(178, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(876, 1, Shiny::Random, 3, 2, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(344, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(202, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173f0356dc5dfa9f, std::array<Raid, 12> {Raid(837, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(524, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(525, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(558, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(689, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(95, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(526, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(837, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(524, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(525, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(558, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(689, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(839, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(526, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(95, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173f0456dc5dfc52, std::array<Raid, 12> {Raid(50, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(749, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(290, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(529, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(208, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(340, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(660, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(51, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(530, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(750, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(50, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(749, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(290, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(529, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(208, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(340, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(660, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(51, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(530, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(750, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173f0556dc5dfe05, std::array<Raid, 12> {Raid(843, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(449, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(220, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(328, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(221, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(329, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(618, 1, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(450, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(867, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(330, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(844, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(843, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(449, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(328, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(220, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(221, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(618, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(329, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(330, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(867, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(450, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(844, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173f0656dc5dffb8, std::array<Raid, 12> {Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(554, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(758, 0, Shiny::Random, 3, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(38, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(631, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(555, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(758, 0, Shiny::Random, 3, 2, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(59, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(631, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x173f0756dc5e016b, std::array<Raid, 12> {Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(758, 0, Shiny::Random, 3, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(38, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(758, 0, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(776, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(758, 0, Shiny::Random, 3, 2, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(59, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(758, 0, Shiny::Random, 3, 2, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(324, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428156dc610690, std::array<Raid, 12> {Raid(438, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(524, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(111, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(525, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(689, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(112, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(185, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(558, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(526, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(213, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(438, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(524, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(111, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(525, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(689, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(112, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(185, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(526, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(558, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(213, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428256dc610843, std::array<Raid, 12> {Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(517, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(677, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(574, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(605, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(281, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(678, 0, Shiny::Random, 3, 1, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(575, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(518, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(576, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(338, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(517, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(677, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(577, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(605, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(281, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(678, 1, Shiny::Random, 3, 2, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(578, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(518, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(579, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(337, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428356dc6109f6, std::array<Raid, 12> {Raid(236, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(66, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(532, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(559, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(67, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(533, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(106, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(107, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(560, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(534, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(68, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(237, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(236, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(66, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(532, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(453, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(533, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(67, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(107, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(106, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(454, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(237, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(68, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(534, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428556dc610d5c, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(458, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(223, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(320, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(224, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(226, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(171, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(746, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(458, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(223, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(320, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(224, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(226, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(171, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(746, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428656dc610f0f, std::array<Raid, 12> {Raid(92, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(355, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(425, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(708, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(592, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(710, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(93, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(356, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(426, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(709, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(593, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(92, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(355, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(425, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(708, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(592, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(710, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(93, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(356, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(426, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(709, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(593, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428756dc6110c2, std::array<Raid, 12> {Raid(10, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(742, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(11, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(596, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(12, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(743, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(826, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(10, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(742, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(11, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(596, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(12, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(743, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(826, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428856dc611275, std::array<Raid, 12> {Raid(10, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(736, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(290, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(11, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(632, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(737, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(291, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(12, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(596, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(738, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(632, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(10, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(736, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(290, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(632, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(11, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(737, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(291, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(12, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(596, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(738, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(632, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428b56dc61178e, std::array<Raid, 12> {Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(535, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(341, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(90, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(536, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(834, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(195, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(771, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(91, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(342, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(535, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(341, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(90, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(536, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(834, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(195, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(771, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(91, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(342, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17428c56dc611941, std::array<Raid, 12> {Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(422, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(320, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(746, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(834, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(847, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(422, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(320, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(746, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(834, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(847, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17458456dc634180, std::array<Raid, 12> {Raid(827, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(509, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(633, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(828, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(861, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(634, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(862, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(635, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(827, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(509, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(629, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(828, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(861, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(630, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(862, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(248, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17458556dc634333, std::array<Raid, 12> {Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(328, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(610, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(782, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(329, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(783, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(611, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(612, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(330, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(776, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(784, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(610, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(328, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(704, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(329, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(611, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(705, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(330, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(612, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(780, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(706, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17458656dc6344e6, std::array<Raid, 12> {Raid(439, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(868, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(35, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(281, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(36, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(869, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(303, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(439, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(868, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(35, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(281, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(36, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(869, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(78, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17458756dc634699, std::array<Raid, 12> {Raid(509, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(434, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(686, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(510, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(435, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(461, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(687, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(342, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(275, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(509, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(434, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(686, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(510, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(435, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(461, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(687, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(342, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(302, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17458856dc63484c, std::array<Raid, 12> {Raid(821, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(278, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(425, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(822, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(426, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(279, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(178, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(701, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(845, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(821, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(278, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(425, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(822, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(426, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(279, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(178, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(701, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(845, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17458956dc6349ff, std::array<Raid, 12> {Raid(173, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(742, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(684, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(35, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(36, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(743, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(756, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(685, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(173, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(742, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(682, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(35, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(36, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(743, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(756, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(683, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17458a56dc634bb2, std::array<Raid, 12> {Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(92, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(43, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(44, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(93, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(109, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(211, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(45, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(315, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(849, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(110, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(92, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(43, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(44, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(93, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(109, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(211, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(45, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(315, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(849, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(110, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17458b56dc634d65, std::array<Raid, 12> {Raid(519, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(163, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(627, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(520, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(521, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(164, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(528, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(178, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(628, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(561, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(519, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(163, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(629, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(520, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(521, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(164, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(528, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(178, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(630, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(561, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17459256dc63594a, std::array<Raid, 12> {Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(782, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(885, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(714, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(886, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(715, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(783, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(784, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(841, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(887, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(704, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(885, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(714, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(886, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(715, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(705, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(706, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(842, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(887, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17459356dc635afd, std::array<Raid, 12> {Raid(659, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(163, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(519, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(572, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(694, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(660, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(164, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(521, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(695, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(573, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(760, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(659, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(163, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(519, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(572, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(694, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(660, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(164, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(521, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(695, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(573, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(760, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17490756dc6655f0, std::array<Raid, 12> {Raid(434, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(568, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(43, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(211, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(452, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(45, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(748, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(569, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(435, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(434, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(568, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(43, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(211, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(452, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(45, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(435, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(569, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(748, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17490856dc6657a3, std::array<Raid, 12> {Raid(710, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(708, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(710, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(710, 2, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(756, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(556, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(709, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(711, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(781, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(710, 3, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(710, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(708, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(710, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(710, 2, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(756, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(556, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(709, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(711, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(781, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(710, 3, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17490f56dc666388, std::array<Raid, 12> {Raid(582, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(220, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(459, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(712, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(225, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(583, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(221, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(713, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(460, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(91, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(582, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(220, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(459, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(712, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(225, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(583, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(221, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(713, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(460, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(91, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17491056dc66653b, std::array<Raid, 12> {Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(554, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(758, 0, Shiny::Random, 3, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(38, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(555, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(758, 0, Shiny::Random, 3, 2, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(59, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17491156dc6666ee, std::array<Raid, 12> {Raid(361, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(872, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(554, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(459, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(460, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(362, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(866, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(478, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(555, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(361, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(872, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(225, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(459, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(460, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(362, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(866, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(478, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17491256dc6668a1, std::array<Raid, 12> {Raid(220, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(613, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(872, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(221, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(91, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(614, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(866, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(473, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(461, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(220, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(613, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(872, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(221, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(91, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(614, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(866, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(473, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(461, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17491356dc666a54, std::array<Raid, 12> {Raid(835, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(694, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(171, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(836, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(695, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(777, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(877, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(835, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(694, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(171, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(836, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(695, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(777, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(877, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17491456dc666c07, std::array<Raid, 12> {Raid(172, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(309, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(737, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(310, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(171, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(596, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(738, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(26, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(172, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(309, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(737, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(310, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(171, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(596, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(738, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(26, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17491556dc666dba, std::array<Raid, 12> {Raid(406, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(546, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(420, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(421, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(841, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(406, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(546, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(420, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(421, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(842, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17491656dc666f6d, std::array<Raid, 12> {Raid(406, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(273, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(761, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(43, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(274, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(44, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(762, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(275, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(763, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(45, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(182, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(406, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(270, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(761, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(43, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(271, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(44, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(762, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(272, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(763, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(45, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(182, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17501a56dc6c94e7, std::array<Raid, 12> {Raid(422, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(341, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(771, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(99, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(342, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(689, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(593, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(422, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(341, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(771, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(99, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(342, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(689, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(593, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17501b56dc6c969a, std::array<Raid, 12> {Raid(535, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(90, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(536, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(91, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(171, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(746, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(847, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(748, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(535, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(90, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(536, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(748, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(91, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(171, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(746, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(847, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17501c56dc6c984d, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(831, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(446, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(876, 0, Shiny::Random, 3, 1, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(820, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(820, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(832, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(660, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(628, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(831, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(446, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(876, 1, Shiny::Random, 3, 2, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(820, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(820, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(832, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(660, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(765, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x17d327792698d15f, std::array<Raid, 12> {Raid(439, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(343, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(575, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(344, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(876, 0, Shiny::Random, 4, 1, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(576, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(344, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(437, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(439, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(77, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(578, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(344, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(876, 1, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(579, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(78, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(437, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x1928030ad989ad02, std::array<Raid, 12> {Raid(859, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(359, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(215, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(828, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(510, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(359, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(461, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(359, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(861, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(859, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(359, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(215, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(828, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(510, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(359, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(461, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(359, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(861, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x1c1962488c012ee8, std::array<Raid, 12> {Raid(403, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(172, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(871, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(404, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(26, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(836, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(702, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(310, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(405, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(462, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(403, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(172, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(871, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(404, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(26, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(836, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(702, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(310, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(405, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(462, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x21f6c865b3513bab, std::array<Raid, 12> {Raid(293, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(108, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(241, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(294, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(294, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(108, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(241, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(626, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(128, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(295, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(463, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(293, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(108, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(241, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(294, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(294, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(108, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(241, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(626, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(128, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(295, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(463, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x21f6c965b3513d5e, std::array<Raid, 12> {Raid(174, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(506, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(427, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(39, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(39, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(507, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(428, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(428, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(40, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(206, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(508, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(174, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(506, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(427, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(39, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(39, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(507, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(428, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(428, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(40, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(206, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(508, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x22ae28e80f536e8d, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x2640fa844b19c3cf, std::array<Raid, 12> {Raid(333, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(831, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(333, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(446, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(820, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(832, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(333, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(831, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(333, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(446, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(820, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(832, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x277effbe0b116e4a, std::array<Raid, 12> {Raid(349, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(138, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(349, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(369, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(550, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(99, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(369, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(139, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(350, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(99, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(349, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(140, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(349, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(369, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(99, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(369, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(141, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(350, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(99, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x2998f2424d0353eb, std::array<Raid, 12> {Raid(590, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(753, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(548, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(754, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(591, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(114, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(549, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(754, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(549, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(591, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(465, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(590, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(753, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(548, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(754, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(591, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(114, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(549, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(754, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(549, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(591, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(465, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x2cd8cf9a88739f98, std::array<Raid, 12> {Raid(361, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(554, 1, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(238, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(698, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(362, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(460, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(124, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(873, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(555, 2, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(699, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(473, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(361, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(361, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(238, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(698, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(362, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(460, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(124, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(873, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(873, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(699, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(473, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x316e6b5e74bc7aa3, std::array<Raid, 12> {Raid(636, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(636, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(757, 0, Shiny::Random, 2, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(324, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(758, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(663, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(637, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(38, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(6, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(636, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(636, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(757, 0, Shiny::Random, 2, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(324, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(758, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(663, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(637, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(59, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(6, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x3a41c5c485d3edee, std::array<Raid, 12> {Raid(240, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(240, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(608, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(126, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(126, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(467, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(240, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(240, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(126, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(126, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(467, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x3b3c0865d15b0aca, std::array<Raid, 12> {Raid(239, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(239, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(702, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(596, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(125, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(836, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(849, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(871, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(466, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(466, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(849, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(239, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(239, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(702, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(596, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(125, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(836, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(871, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(466, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(466, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(849, 1, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x3d2f6b02fc6dd797, std::array<Raid, 12> {Raid(621, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(371, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(371, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(696, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(372, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(147, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(372, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(621, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(373, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(373, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(621, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(443, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(443, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(696, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(444, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(147, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(444, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(621, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(445, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(445, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x3d6f1fcb3898d356, std::array<Raid, 12> {Raid(116, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(621, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(776, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(782, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(117, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(783, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(776, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(621, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(715, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(230, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(784, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(116, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(621, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(780, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(704, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(117, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(705, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(780, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(621, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(715, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(230, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(706, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x3ea9df3b7b2b5990, std::array<Raid, 12> {Raid(415, 0, Shiny::Random, 2, 2, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 2, 2, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 2, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(415, 0, Shiny::Random, 2, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(416, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(415, 0, Shiny::Random, 2, 2, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 2, 2, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 2, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(415, 0, Shiny::Random, 2, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(416, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(416, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(416, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x40bdbe4f3bcbac86, std::array<Raid, 12> {Raid(132, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(132, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x422f95fb66a95706, std::array<Raid, 12> {Raid(333, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(333, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(820, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(820, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(832, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(334, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(334, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(832, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(143, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(143, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(333, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(333, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(820, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(820, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(832, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(334, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(334, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(832, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(143, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(143, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4257e30e1c471230, std::array<Raid, 12> {Raid(72, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(223, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(73, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(746, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(224, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(226, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(99, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(91, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(73, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(72, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(223, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(73, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(746, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(224, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(226, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(99, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(91, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(73, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4257e40e1c4713e3, std::array<Raid, 12> {Raid(54, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(55, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(845, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(55, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(847, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(340, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(55, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(54, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(55, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(845, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(55, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(847, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(340, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(55, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4257e50e1c471596, std::array<Raid, 12> {Raid(60, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(118, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(61, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(342, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(61, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(119, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(342, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(195, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(62, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(186, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(60, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(118, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(61, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(342, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(61, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(119, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(342, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(195, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(62, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(186, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4257ea0e1c471e15, std::array<Raid, 12> {Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(692, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(692, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(120, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(320, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(746, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(171, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(693, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(319, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(170, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(690, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(690, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(120, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(320, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(746, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(171, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(691, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(319, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x42b21efc37c7b974, std::array<Raid, 12> {Raid(41, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(333, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(42, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(42, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(822, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(42, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(715, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(169, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(41, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(714, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(333, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(42, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(42, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(822, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(42, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(715, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(169, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x450097d99cf5626c, std::array<Raid, 12> {Raid(447, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(599, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(632, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(600, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(601, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(447, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(599, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(600, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(632, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(601, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x450098d99cf5641f, std::array<Raid, 12> {Raid(52, 2, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(679, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(863, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(618, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(884, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(52, 2, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(679, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(863, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(618, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(884, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x45009bd99cf56938, std::array<Raid, 12> {Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(38, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x45009cd99cf56aeb, std::array<Raid, 12> {Raid(447, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(66, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(83, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(760, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(67, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(870, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(701, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(475, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(865, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(679, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(92, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(680, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(222, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(93, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(302, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(855, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(864, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(867, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(94, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x45009dd99cf56c9e, std::array<Raid, 12> {Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(756, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(303, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(869, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(77, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(756, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(78, 1, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(869, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x45009ed99cf56e51, std::array<Raid, 12> {Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(438, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(837, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(185, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(689, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(558, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(874, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(582, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(613, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(712, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(361, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(713, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(362, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4500a0d99cf571b7, std::array<Raid, 12> {Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(4, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(5, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(38, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(38, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(758, 0, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(4, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(5, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(758, 0, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4500a1d99cf5736a, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(771, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(211, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(99, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(746, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(771, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(211, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(99, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(746, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4500a2d99cf5751d, std::array<Raid, 12> {Raid(406, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(273, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(274, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(275, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(598, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(407, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(841, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(406, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(270, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(271, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(272, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(598, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(407, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(842, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x45041ed99cf87da8, std::array<Raid, 12> {Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(622, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(536, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(195, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(618, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(623, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(844, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(622, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(536, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(195, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(618, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(623, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(844, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x45041fd99cf87f5b, std::array<Raid, 12> {Raid(767, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(588, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(616, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(826, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(768, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(589, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(767, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(616, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(588, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(826, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(768, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(617, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x450420d99cf8810e, std::array<Raid, 12> {Raid(341, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(342, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(99, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 1, 1, 1, 1 }), Raid(748, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(341, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(342, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(99, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 1, 1, 1, 1 }), Raid(748, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x450421d99cf882c1, std::array<Raid, 12> {Raid(767, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(588, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(616, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(826, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(768, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(589, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(767, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(616, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(588, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(826, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(768, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(617, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x450422d99cf88474, std::array<Raid, 12> {Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(163, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(821, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(278, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(12, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(822, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(164, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(279, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(178, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(701, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(561, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(163, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(821, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(278, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(12, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(822, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(164, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(279, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(178, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(701, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(561, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x450423d99cf88627, std::array<Raid, 12> {Raid(827, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(559, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(510, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(828, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(675, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(560, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(635, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(827, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(629, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(510, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(828, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(675, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(630, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(248, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x450424d99cf887da, std::array<Raid, 12> {Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(684, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(685, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(868, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(682, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(683, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(868, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x450425d99cf8898d, std::array<Raid, 12> {Raid(434, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(568, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(109, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(452, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(849, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(435, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(110, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(748, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(569, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(434, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(568, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(109, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(452, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(849, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(435, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(110, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(758, 0, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(569, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x47a5d8b98dd573ab, std::array<Raid, 12> {Raid(885, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(708, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(778, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(361, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(886, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(778, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(303, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(362, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(478, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(709, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(778, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(885, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(708, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(778, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(361, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(886, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(778, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(302, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(362, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(478, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(709, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(778, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4f1e561dd73ed3d8, std::array<Raid, 12> {Raid(590, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(102, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(114, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(315, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(114, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(315, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(103, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(3, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(465, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(407, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(3, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(590, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(102, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(114, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(315, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(114, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(315, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(103, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(3, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(465, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(407, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(3, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4f1e581dd73ed73e, std::array<Raid, 12> {Raid(98, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(223, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(73, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(224, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(713, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(614, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(99, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(91, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(99, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(98, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(223, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(73, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(224, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(713, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(614, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(99, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(91, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(99, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4f1e591dd73ed8f1, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(120, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(688, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(73, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(130, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(73, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(121, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(689, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(9, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(120, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(688, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(73, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(130, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(73, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(121, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(689, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(9, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4f1e5a1dd73edaa4, std::array<Raid, 12> {Raid(824, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(742, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(127, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(825, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(291, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(826, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(596, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(743, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(291, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(826, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(824, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(742, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(214, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(291, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(826, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(596, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(743, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(291, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(826, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4f1e5b1dd73edc57, std::array<Raid, 12> {Raid(833, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(54, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(55, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(845, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(55, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(847, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(550, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(340, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(834, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(833, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(54, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 1, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(55, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(845, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(55, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(847, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(550, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(340, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(834, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4f1e5c1dd73ede0a, std::array<Raid, 12> {Raid(840, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(761, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(420, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(840, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(762, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(841, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(820, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(841, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(820, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(763, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(841, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(840, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(761, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(420, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(840, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(762, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(842, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(820, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(842, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(820, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(763, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(842, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x4f1e5d1dd73edfbd, std::array<Raid, 12> {Raid(843, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(529, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(843, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(529, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(28, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(552, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(844, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(553, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(530, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(553, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(844, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(843, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(529, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(843, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(529, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(28, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(552, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(844, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(553, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(530, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(553, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(844, 0, Shiny::Random, 2, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x50eaf4685fa07085, std::array<Raid, 12> {Raid(707, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(81, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(81, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(227, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(82, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(82, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(707, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(462, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(227, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(707, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(81, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(81, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(227, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(82, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(82, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(707, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(462, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(227, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x52a7dfe87897d15d, std::array<Raid, 12> {Raid(29, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(41, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(29, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(32, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(30, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(33, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(31, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(42, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(42, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(31, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(34, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(32, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(41, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(32, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(29, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(33, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(30, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(34, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(42, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(42, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(34, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(31, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x53441b80e563ef1f, std::array<Raid, 12> {Raid(123, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(127, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(213, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(544, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(123, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(558, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(545, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(617, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(589, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(127, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(212, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(123, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(214, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(213, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(544, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(123, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(558, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(545, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(617, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(589, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(214, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(212, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x5584521f1e549486, std::array<Raid, 12> {Raid(744, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(744, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(744, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(745, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(745, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(744, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(744, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(745, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(745, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x55846e1f1e54c41a, std::array<Raid, 12> {Raid(744, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(744, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(744, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(745, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(745, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(745, 2, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(745, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(744, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(744, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(745, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(745, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(745, 2, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(745, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x55e4467f01ec60bb, std::array<Raid, 12> {Raid(874, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(304, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(304, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(874, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(874, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(305, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(303, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(305, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(703, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(837, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(304, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(304, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(305, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(302, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(305, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(703, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x58c3011eda59ea53, std::array<Raid, 12> {Raid(138, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(347, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(696, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(698, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(348, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(346, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(139, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(348, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(699, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(142, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(140, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(345, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(698, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(696, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(346, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(348, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(141, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(346, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(699, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(142, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x5b72bfac0ff3f885, std::array<Raid, 12> {Raid(661, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(636, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(662, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(636, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(663, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(758, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(324, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(637, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(661, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(636, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 2, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(662, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(636, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(324, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(663, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(758, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(324, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(637, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x5c9a35ca819b38c8, std::array<Raid, 12> {Raid(543, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(72, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(544, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(544, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(452, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(73, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(452, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(73, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(545, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(543, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(72, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(544, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(544, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(452, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(73, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(452, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(73, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(545, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x60ef1d711ae30cf0, std::array<Raid, 12> {Raid(27, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(551, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(104, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(27, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(552, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(28, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(844, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(28, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(105, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(553, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(115, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(27, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(551, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(104, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(27, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(552, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(28, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(844, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(28, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(105, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(553, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(115, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x685dad2aaedbca48, std::array<Raid, 12> {Raid(613, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(363, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(363, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(712, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(364, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(615, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(614, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(365, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(713, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(875, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(363, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(363, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(875, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(364, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(615, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(614, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(365, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(713, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x685db02aaedbcf61, std::array<Raid, 12> {Raid(238, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(554, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(238, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(698, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(221, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(460, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(124, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(555, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(699, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(362, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(238, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(220, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(238, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(698, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(221, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(460, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(124, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(699, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(362, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x68dd887d07e09158, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x68dd8d7d07e099d7, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }) }, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }) }), Den(0x68dd8e7d07e09b8a, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }) }, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }) }), Den(0x68dd8f7d07e09d3d, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }) }, std::array<Raid, 12> {Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 1, 1, 1, 0, 1 }) }), Den(0x6aebee2a2d6d8470, std::array<Raid, 12> {Raid(570, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(318, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(570, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(686, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(552, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(687, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(828, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(571, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(319, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(510, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(553, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(570, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(318, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(570, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(686, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(552, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(687, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(828, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(571, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(319, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(510, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(553, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x6b37a94863bf68c0, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(120, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(90, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(73, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(130, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(73, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(91, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(9, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(72, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(120, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(90, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(73, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(130, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(73, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(91, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(9, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x6c364ecc3616af63, std::array<Raid, 12> {Raid(240, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(240, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(126, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(126, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(851, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(609, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(38, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(467, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(467, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(851, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(240, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(240, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(126, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(126, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(851, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(609, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(59, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(467, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(467, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(851, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x6d015b7858eb5119, std::array<Raid, 12> {Raid(127, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(127, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(127, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(558, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(123, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(123, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(127, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(826, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(212, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(214, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(214, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(214, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(558, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(123, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(123, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(214, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(826, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(212, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x6e6b46639f77f0c8, std::array<Raid, 12> {Raid(702, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(81, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(403, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(877, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(702, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(404, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(702, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(82, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(405, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(462, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(702, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(81, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(403, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(877, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(702, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(404, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(702, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(82, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(405, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(462, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x7288f0346fd3cdd8, std::array<Raid, 12> {Raid(769, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(592, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(769, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(425, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(593, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(426, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(711, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 2, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 3, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(770, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(769, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(592, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(769, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(425, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(593, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(426, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(711, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 2, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 3, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(864, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x72f9d87337338120, std::array<Raid, 12> {Raid(703, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(546, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(35, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(703, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(703, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(547, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(110, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(858, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(36, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(110, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(858, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(703, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(546, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(35, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(703, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(703, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(547, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(110, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(858, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(36, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(110, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(858, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x75319113c8c3b924, std::array<Raid, 12> {Raid(532, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(622, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(622, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(533, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(623, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(534, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(623, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(623, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(534, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(532, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(622, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(622, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(533, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(623, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(534, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(623, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(623, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(534, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x79b25a4f80255a38, std::array<Raid, 12> {Raid(524, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(111, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(525, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(112, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(558, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(112, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(526, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(558, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(524, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(111, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(744, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(525, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(112, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(558, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(112, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(526, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(558, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(745, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x7ea57d4a1ef4c796, std::array<Raid, 12> {Raid(304, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(632, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(304, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(374, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(305, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(375, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(632, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(879, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(306, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(304, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(632, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(304, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(374, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(305, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(375, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(632, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(879, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(306, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x89955cc3a594e51a, std::array<Raid, 12> {Raid(173, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(183, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(35, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(281, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(707, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(764, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(36, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(282, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(756, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(184, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(173, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(183, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(35, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(281, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(707, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(764, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(36, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(282, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(756, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(184, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x8b5a3178ae3f236b, std::array<Raid, 12> {Raid(854, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(854, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 1, 1, 1, 1, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(854, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(855, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(855, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(869, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(854, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }), Raid(854, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 1, 1, 1, 1, 0 }), Raid(854, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(869, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(855, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(855, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(869, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x93a637943a964e41, std::array<Raid, 12> {Raid(347, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(345, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(347, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(345, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(752, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(12, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(348, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(346, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(830, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(348, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(12, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(345, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(347, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(345, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(347, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(752, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(12, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(346, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(348, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(830, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(346, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(12, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x9ab5727f28c3d593, std::array<Raid, 12> {Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(215, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(359, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(862, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(359, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(461, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(359, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(862, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(359, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(461, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x9b45ce9bd57148e7, std::array<Raid, 12> {Raid(113, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(113, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x9d415f6a7a841dd9, std::array<Raid, 12> {Raid(41, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(822, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(42, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(528, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(823, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(142, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(334, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(169, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(715, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(823, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(41, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(822, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(42, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(528, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(823, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(142, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(334, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(169, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(715, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(823, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0x9fdf11a0cde96b2e, std::array<Raid, 12> {Raid(132, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(132, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(132, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(132, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(132, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(132, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xa178d4769765abac, std::array<Raid, 12> {Raid(661, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(627, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(587, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(662, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(662, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(628, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(587, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(528, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(628, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(663, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(661, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(629, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(587, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(662, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(662, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(630, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(587, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(528, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(630, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(663, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xa23ec426e4e9430a, std::array<Raid, 12> {Raid(885, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(885, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(885, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(93, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(303, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(709, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(709, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(303, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(887, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(887, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(94, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(885, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(885, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(885, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(222, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(302, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(709, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(864, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(302, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(887, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(887, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(94, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xae57b2a84974c3a1, std::array<Raid, 12> {Raid(114, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(753, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(590, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(754, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(556, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(549, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(754, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(591, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(465, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(549, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(460, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(114, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(753, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(590, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(754, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(556, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(549, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(754, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(591, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(465, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(549, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(460, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xb0c9af2202b0a19e, std::array<Raid, 12> {Raid(782, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(116, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(117, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(621, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(783, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(621, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(841, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(230, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(784, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(704, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(116, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(117, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(621, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(705, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(621, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(842, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(230, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(706, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xb20a5ed251cd0456, std::array<Raid, 12> {Raid(876, 0, Shiny::Random, 2, 1, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(574, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(79, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(375, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(876, 0, Shiny::Random, 2, 1, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(876, 0, Shiny::Random, 2, 1, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(576, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(576, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(376, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(876, 1, Shiny::Random, 2, 2, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(577, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(79, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(375, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(876, 1, Shiny::Random, 2, 2, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(876, 1, Shiny::Random, 2, 2, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(579, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(579, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(376, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xb4dbd8428706d1c2, std::array<Raid, 12> {Raid(138, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(139, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }), Raid(142, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }), Raid(881, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }), Raid(880, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(882, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(142, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(881, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(883, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(880, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(882, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(140, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(141, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }), Raid(142, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }), Raid(883, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }), Raid(882, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(880, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }), Raid(142, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(883, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(881, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(882, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(880, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xb8a5e528bfee71bc, std::array<Raid, 12> {Raid(102, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(63, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(64, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(281, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(64, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(103, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(103, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(65, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(102, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(63, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(64, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(281, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(765, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(103, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(103, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(65, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805367100fc4ac, std::array<Raid, 12> {Raid(686, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(856, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(857, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(281, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(528, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(686, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(856, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(857, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(281, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(528, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805467100fc65f, std::array<Raid, 12> {Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(438, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(837, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(185, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(689, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(558, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(874, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(557, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(438, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(837, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(524, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(246, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(247, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(558, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(248, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805767100fcb78, std::array<Raid, 12> {Raid(767, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(588, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(616, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(826, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(768, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(589, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(292, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(767, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(824, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(616, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(588, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(557, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(825, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(826, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(768, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(617, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(292, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805867100fcd2b, std::array<Raid, 12> {Raid(679, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(425, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(680, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(710, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(426, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(711, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(855, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(867, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(681, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(679, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(425, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(680, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(222, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(426, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(302, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(855, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(864, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(867, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(681, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805967100fcede, std::array<Raid, 12> {Raid(447, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(66, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(559, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(760, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(870, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(67, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(560, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(68, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(766, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(475, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(447, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(66, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(453, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(760, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(870, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(67, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(454, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(68, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(701, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(475, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805a67100fd091, std::array<Raid, 12> {Raid(52, 2, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(679, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(863, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(618, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(879, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(884, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(52, 2, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(679, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(863, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(618, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(879, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(884, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805c67100fd3f7, std::array<Raid, 12> {Raid(92, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(355, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(93, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(710, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(356, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(855, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(711, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(867, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(477, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(94, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(92, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(355, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(93, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(222, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 1, 0 }), Raid(356, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(867, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(864, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(302, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(477, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(94, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805d67100fd5aa, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(349, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(211, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(748, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(350, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(349, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(211, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(748, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(350, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba805e67100fd75d, std::array<Raid, 12> {Raid(447, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(599, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(632, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(600, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(601, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(447, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(599, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(95, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(600, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(632, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(601, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83d8671012dc82, std::array<Raid, 12> {Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(163, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(821, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(278, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(12, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(822, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(164, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(279, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(178, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(701, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(177, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(163, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(821, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(278, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(12, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(822, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(164, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(279, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(178, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(701, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83d9671012de35, std::array<Raid, 12> {Raid(434, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(568, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(109, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(569, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(452, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(435, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(110, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(748, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(434, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(568, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(451, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(109, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(569, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(452, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(435, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(110, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(758, 0, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83da671012dfe8, std::array<Raid, 12> {Raid(420, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(273, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(546, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(274, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(421, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(756, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(275, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(781, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(420, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(270, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(546, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(271, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(421, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(756, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(272, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(781, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83db671012e19b, std::array<Raid, 12> {Raid(406, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(273, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(274, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(275, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(598, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(407, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(841, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(406, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(270, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(271, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(315, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(272, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(598, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(407, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(842, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83dc671012e34e, std::array<Raid, 12> {Raid(172, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(309, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(694, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(479, 5, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(479, 4, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(479, 3, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(479, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(479, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(172, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(309, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(694, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(479, 5, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(479, 4, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(479, 3, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(479, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(479, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83dd671012e501, std::array<Raid, 12> {Raid(835, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(171, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(836, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(596, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(777, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(877, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(835, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(171, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(836, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(596, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(777, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(877, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83de671012e6b4, std::array<Raid, 12> {Raid(582, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(554, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(712, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(361, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(713, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(362, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(555, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(582, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(613, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(712, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(361, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(713, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(362, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83df671012e867, std::array<Raid, 12> {Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(38, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(776, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(757, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(758, 0, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83e0671012ea1a, std::array<Raid, 12> {Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(4, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(5, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(38, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(38, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(758, 0, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(6, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(4, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(5, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(758, 0, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(6, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba83e1671012ebcd, std::array<Raid, 12> {Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(622, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(536, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(195, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(618, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(623, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(867, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(562, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(622, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(536, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(195, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(618, 1, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(623, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(867, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8745671015cb90, std::array<Raid, 12> {Raid(328, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(610, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(782, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(885, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(611, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(783, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(776, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(784, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(886, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(612, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(887, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(610, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(840, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(328, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(704, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(885, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(329, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(705, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(780, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(706, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(886, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(330, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(887, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8746671015cd43, std::array<Raid, 12> {Raid(659, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(519, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(133, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(520, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(831, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(521, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(832, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(628, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(876, 0, Shiny::Random, 4, 1, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(133, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(659, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(519, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(819, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(133, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(520, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(831, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(521, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(832, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(765, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(876, 1, Shiny::Random, 4, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(133, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8747671015cef6, std::array<Raid, 12> {Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(756, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(303, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(778, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(755, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(756, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(78, 1, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(778, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8748671015d0a9, std::array<Raid, 12> {Raid(827, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(559, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(510, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(828, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(675, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(461, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(560, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(862, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(635, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(827, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(629, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(215, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(510, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(828, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(675, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(461, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(630, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(862, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(248, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8749671015d25c, std::array<Raid, 12> {Raid(686, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(856, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(857, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(528, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(196, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(686, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(527, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(856, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(857, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(437, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(528, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(196, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba874a671015d40f, std::array<Raid, 12> {Raid(827, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(686, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(510, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(828, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(675, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(862, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(197, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(827, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(263, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(686, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(510, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(264, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(828, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(675, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(862, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(197, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba874b671015d5c2, std::array<Raid, 12> {Raid(132, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(132, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba874c671015d775, std::array<Raid, 12> {Raid(458, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(341, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(342, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(748, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(226, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(134, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(458, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(341, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(846, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(833, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(550, 1, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(342, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(748, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(226, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(134, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba874f671015dc8e, std::array<Raid, 12> {Raid(420, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(761, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(546, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(762, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(421, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(763, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(470, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(420, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(761, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(829, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(546, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(762, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(597, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(421, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(598, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(763, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(470, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8750671015de41, std::array<Raid, 12> {Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(37, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(38, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(136, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(850, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(607, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(58, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(838, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(631, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(608, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(324, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(38, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(59, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(136, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8a496710180833, std::array<Raid, 12> {Raid(458, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(223, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(320, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(771, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(99, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(550, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(211, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(224, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(226, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(458, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(223, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(320, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(771, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(99, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(550, 1, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(211, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(224, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(226, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8a4c6710180d4c, std::array<Raid, 12> {Raid(582, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(872, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(712, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(361, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(583, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(713, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(873, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(478, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(471, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(582, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(872, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(122, 1, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(712, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(361, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(583, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(713, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(873, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(866, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(478, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(471, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8a4d6710180eff, std::array<Raid, 12> {Raid(835, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(694, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(171, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(836, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(695, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(738, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(25, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(135, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(835, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(848, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(25, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(694, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(170, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(171, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(836, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(849, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(695, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(738, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(25, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(135, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8a4e67101810b2, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(746, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(99, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(340, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(211, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(195, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(129, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(194, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(339, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(98, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(746, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(99, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(340, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(211, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(195, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(130, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xba8a4f6710181265, std::array<Raid, 12> {Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(684, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(685, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(868, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(700, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(175, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(682, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(859, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(280, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(176, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(860, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(683, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(868, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(700, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xbc3d01fff751cde4, std::array<Raid, 12> {Raid(619, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(852, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(619, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(559, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(766, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(560, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(620, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(620, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(560, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(853, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(620, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(619, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(852, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(619, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(453, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(853, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(454, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(620, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(620, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(454, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(853, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(620, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xbdf065bb6332909f, std::array<Raid, 12> {Raid(133, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(133, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(133, 0, Shiny::Random, 2, 2, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(136, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(135, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(134, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(196, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(197, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(470, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(471, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(700, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }) }, std::array<Raid, 12> {Raid(133, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(133, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(133, 0, Shiny::Random, 2, 2, 4, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(136, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(135, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(134, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(196, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(197, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(470, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(471, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(700, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }) }), Den(0xc63dec8a65b5c540, std::array<Raid, 12> {Raid(318, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(318, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(570, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(319, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(687, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(452, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(319, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(571, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(318, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(624, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(318, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(570, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(319, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(687, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(452, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(625, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(319, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(571, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xc80756327d5de060, std::array<Raid, 12> {Raid(27, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(104, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(328, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(328, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(552, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(28, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(105, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(553, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(115, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(330, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(623, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(27, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(104, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(328, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(328, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(552, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(28, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(105, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(553, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(115, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(330, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(623, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xc862667fc72ee059, std::array<Raid, 12> {Raid(173, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(703, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(856, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(173, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(857, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(35, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(703, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(703, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(36, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(173, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(703, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(856, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(173, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(857, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(35, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(703, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(703, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(36, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xc88b8a5990a8ea5c, std::array<Raid, 12> {Raid(41, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(568, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(30, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(79, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(42, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(569, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(31, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(31, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(34, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(169, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(569, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(41, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(568, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(33, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(79, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(42, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(569, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(34, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(34, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(31, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(169, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(569, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xc8ea8c1618ab0a58, std::array<Raid, 12> {Raid(744, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(438, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(111, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(112, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(213, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(745, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(185, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(526, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(558, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(464, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(744, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(438, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(111, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(744, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(112, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(213, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(745, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(185, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(526, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(558, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(464, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xd4d5074d72c71271, std::array<Raid, 12> {Raid(440, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(440, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(440, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(440, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(440, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(113, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(113, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(242, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(242, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(440, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }), Raid(440, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(440, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(440, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(440, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(113, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(113, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(242, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(242, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xd8f0ffcde5822363, std::array<Raid, 12> {Raid(293, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(128, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(108, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(241, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(241, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(626, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(128, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(295, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(573, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(295, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(463, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(293, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(128, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(108, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(241, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(241, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(626, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(128, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(295, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(573, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(295, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(463, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xd8f100cde5822516, std::array<Raid, 12> {Raid(506, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(39, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(427, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(39, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(206, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(832, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(428, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(508, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(760, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(40, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(506, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(759, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(39, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(427, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(39, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(206, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(832, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(428, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(508, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(760, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(40, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xdb8629cba3383296, std::array<Raid, 12> {Raid(590, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(102, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(753, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(114, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(754, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(102, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(103, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(591, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(754, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(465, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(3, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(590, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(102, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(753, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(114, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(754, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(102, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(103, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(591, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(754, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(465, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(3, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xdf017f3fefba2704, std::array<Raid, 12> {Raid(605, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(63, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(79, 1, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(605, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(64, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(79, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(518, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(876, 0, Shiny::Random, 2, 1, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(606, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(65, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(678, 0, Shiny::Random, 2, 1, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(605, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(63, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(79, 1, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(605, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(765, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(79, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(518, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(876, 1, Shiny::Random, 2, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(606, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(65, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(678, 1, Shiny::Random, 2, 2, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xe0236c3b91edbebb, std::array<Raid, 12> {Raid(304, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(52, 2, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(632, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(305, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(863, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(863, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(879, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(376, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(376, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(879, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(304, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(52, 2, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(632, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(305, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(863, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(863, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(879, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(306, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(376, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(376, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(879, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xe234e939402a736b, std::array<Raid, 12> {Raid(239, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(239, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(871, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(125, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(778, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(596, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(836, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(125, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(466, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(239, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(595, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(239, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(871, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(125, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(778, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(596, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(836, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(125, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(466, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xe2c6e5e725342f4a, std::array<Raid, 12> {Raid(174, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(298, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(764, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(39, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(183, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(764, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(707, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(184, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(40, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(764, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(174, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(298, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(764, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(39, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(183, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(764, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(707, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(184, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(40, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(764, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xe78d0a25d0c67a32, std::array<Raid, 12> {Raid(133, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(133, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(133, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(136, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(135, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(134, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(196, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(197, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(470, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(471, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(700, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }) }, std::array<Raid, 12> {Raid(133, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(133, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(133, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 1, 1, 1, 1, 1 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(136, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(135, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(134, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(196, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(197, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(470, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(471, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(700, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }) }), Den(0xea4c3915ea6f95a0, std::array<Raid, 12> {Raid(415, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(415, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(415, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(415, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(113, 0, Shiny::Random, 3, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(416, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xf01dfb231a467c06, std::array<Raid, 12> {Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(854, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(854, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(854, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(854, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(854, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(854, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(854, 0, Shiny::Random, 3, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(531, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(854, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(854, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(854, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(854, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(854, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xf4a830850f51d034, std::array<Raid, 12> {Raid(163, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(519, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(627, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(520, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(528, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(164, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(521, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(663, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(587, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(628, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(663, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(163, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(519, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(629, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(520, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(528, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(164, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(521, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(663, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(587, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(630, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(663, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xf9222e1acdf486e8, std::array<Raid, 12> {Raid(747, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(211, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(544, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(544, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(211, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(591, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(748, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(545, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(452, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(110, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(545, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(747, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(211, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(544, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(544, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(211, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(591, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(748, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(545, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(452, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(110, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(545, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xf9280759d6cc62a3, std::array<Raid, 12> {Raid(81, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(227, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(52, 2, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(82, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(601, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(227, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(437, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(863, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(448, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(625, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(81, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(227, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(436, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(52, 2, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(82, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(601, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(227, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(437, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(863, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(448, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(625, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xf9d3242b837d627e, std::array<Raid, 12> {Raid(884, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(371, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(696, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(776, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(372, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(884, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(149, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(697, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(373, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(373, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(884, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(884, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(443, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(696, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(780, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(444, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(884, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(225, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(149, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(697, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(445, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(445, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(884, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xfe9695f9799c6258, std::array<Raid, 12> {Raid(90, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(223, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(73, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(771, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(224, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(226, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(689, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(91, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(748, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(90, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(688, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(747, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(223, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(73, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(771, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(224, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(226, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(689, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(91, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(748, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xfe9696f9799c640b, std::array<Raid, 12> {Raid(846, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(535, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(54, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(536, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(55, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(340, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(55, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(847, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(550, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(846, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(535, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(54, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(536, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(55, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(340, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(55, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(847, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(537, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(130, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(550, 1, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xfe9697f9799c65be, std::array<Raid, 12> {Raid(341, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(118, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(61, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(342, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(195, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(119, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(62, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(342, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(186, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(341, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(751, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(118, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(61, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(342, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(195, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(119, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(62, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(342, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(752, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(186, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }), Den(0xfe969cf9799c6e3d, std::array<Raid, 12> {Raid(692, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(120, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(320, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(279, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(171, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(117, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(693, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(171, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(121, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(693, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(319, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) }, std::array<Raid, 12> {Raid(690, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(120, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 1, 0, 0, 0 }), Raid(320, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(279, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 1, 0, 0 }), Raid(171, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(117, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 1, 0 }), Raid(242, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 1, 1, 1 }), Raid(691, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(171, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(121, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 1 }), Raid(691, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }), Raid(319, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }) })};

constexpr std::array<DenEvent, 69> NESTS_EVENT = { DenEvent(std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(843, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(843, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(843, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(843, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(844, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(844, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(844, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(844, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(834, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(834, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70) }, std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(823, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(851, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70) }), DenEvent(std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(843, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(843, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(844, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(844, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(834, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(834, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(143, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70) }, std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(851, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(143, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70) }), DenEvent(std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(843, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(225, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(843, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(225, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(225, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(844, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(834, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(834, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(225, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70) }, std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(225, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(225, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(225, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(851, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(225, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70) }), DenEvent(std::array<Raid, 30> {Raid(129, 0, Shiny::Always, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(843, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(843, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Always, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Always, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(844, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Always, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(844, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(129, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(834, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70) }, std::array<Raid, 30> {Raid(129, 0, Shiny::Always, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Always, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Always, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Always, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(129, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 70) }), DenEvent(std::array<Raid, 30> {Raid(840, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(840, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(837, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(837, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(841, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(841, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(869, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(869, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(838, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(838, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(841, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(841, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(869, 3, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(869, 4, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(839, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(839, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(841, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(841, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(869, 1, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(869, 2, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(839, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(839, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(841, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(841, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(869, 5, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(869, 6, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(840, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(840, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(131, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(131, 0, Shiny::Random, 2, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(842, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(842, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(869, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(869, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(131, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(131, 0, Shiny::Random, 2, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(842, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(842, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(869, 1, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(869, 2, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(131, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(131, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(842, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(842, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(869, 7, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(869, 8, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(131, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(131, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(842, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(842, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(869, 3, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(869, 4, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(131, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(131, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(841, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(839, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(841, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(839, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(841, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(842, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(131, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(842, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(131, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(842, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(131, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(99, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(99, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(857, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 1, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 1, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(826, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(858, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 1, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(98, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(98, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(848, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(848, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(99, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(99, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(849, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(849, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(99, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(99, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(99, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(99, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(825, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(825, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(856, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(856, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(848, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(848, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(826, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(856, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(856, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(849, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(849, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(857, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(857, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 1, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(858, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 1, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(826, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(858, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(858, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 1, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(1, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(7, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(98, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(848, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(1, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(4, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(7, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(99, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(849, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(1, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(4, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(7, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(99, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(2, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(5, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(8, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(150, 0, Shiny::Never, 0, 0, 6, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 100), Raid(150, 0, Shiny::Never, 0, 0, 6, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 100), Raid(150, 0, Shiny::Never, 0, 0, 6, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 100) }, std::array<Raid, 30> {Raid(1, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(7, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(825, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(856, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(848, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(1, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(4, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(7, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(856, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(849, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(1, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(4, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(7, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(857, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 1, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(2, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(5, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(8, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 1, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(858, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 1, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(150, 0, Shiny::Never, 0, 0, 6, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 100), Raid(150, 0, Shiny::Never, 0, 0, 6, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 100), Raid(150, 0, Shiny::Never, 0, 0, 6, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 100) }), DenEvent(std::array<Raid, 30> {Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(66, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(66, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(67, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(67, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(68, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(68, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(68, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(68, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(66, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(66, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(67, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(67, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(68, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(588, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(616, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(222, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(871, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(66, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(77, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(222, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(871, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(67, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(77, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(222, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(871, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(617, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(589, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(871, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(765, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(876, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(630, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(78, 1, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(68, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(588, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(616, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(554, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(871, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(66, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(83, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(554, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(871, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(67, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(83, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(554, 1, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(871, 0, Shiny::Random, 2, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(617, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(589, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(871, 0, Shiny::Random, 2, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(766, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(876, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(628, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(865, 0, Shiny::Random, 2, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(568, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(568, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(5, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(5, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(884, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(884, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(879, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(569, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(6, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(6, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(884, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(884, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(569, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(568, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(568, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(5, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(5, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(884, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(884, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(879, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(569, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(6, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(6, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(884, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(884, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(569, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(6, 0, Shiny::Never, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(6, 0, Shiny::Never, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(6, 0, Shiny::Never, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(568, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(568, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(884, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(5, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(848, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(458, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(406, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(236, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(447, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(446, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(439, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(175, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(360, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(173, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(172, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(132, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(132, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(568, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(568, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(884, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(5, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(848, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(458, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(406, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(236, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(447, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(446, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(439, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(175, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(360, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(173, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(172, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(132, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(132, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(6, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(6, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(246, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(479, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(529, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(546, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(885, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(175, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(247, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(479, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(529, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(546, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(886, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(176, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(248, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(479, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(530, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(547, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(887, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(468, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(248, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(479, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(530, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(887, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(248, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(479, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(530, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(547, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(887, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(468, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(246, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(479, 2, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(529, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(546, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(885, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(175, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(247, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(479, 2, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(529, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(546, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(886, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(176, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(248, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(479, 2, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(530, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(547, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(887, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(468, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(248, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(479, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(530, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(887, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(468, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(248, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(479, 2, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(530, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(547, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(887, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(468, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(869, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(851, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(131, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(99, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(842, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(569, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(869, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(131, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(826, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(68, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(841, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 1, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(68, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(143, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(131, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(807, 0, Shiny::Never, 0, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(99, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(842, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(807, 0, Shiny::Never, 0, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(569, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(869, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(807, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(807, 0, Shiny::Always, 0, 0, 6, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 100), Raid(131, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(143, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(68, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(807, 0, Shiny::Never, 0, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(841, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(807, 0, Shiny::Never, 0, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(807, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(807, 0, Shiny::Always, 0, 0, 6, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 100), Raid(849, 1, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(68, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(208, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 2, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(837, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(111, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(95, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(208, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(863, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(838, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(111, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(95, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(879, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(208, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(863, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(839, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(112, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(95, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(863, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(839, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(95, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(208, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(863, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(464, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(95, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(208, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 2, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(837, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(111, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(95, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(208, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(863, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(838, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(111, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(95, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(879, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(208, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(863, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(839, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(112, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(95, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(208, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(863, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(839, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(464, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(95, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(208, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(863, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(464, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(95, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(320, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(98, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(771, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(592, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(458, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(318, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(320, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(98, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(771, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(592, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(458, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(319, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(321, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(99, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(771, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(593, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(226, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(319, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(593, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(226, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(319, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(321, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(321, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(771, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(593, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(226, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(319, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(320, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(98, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(771, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(592, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(458, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(318, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(320, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(98, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(771, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(592, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(458, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(319, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(321, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(99, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(771, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(593, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(226, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(319, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(321, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(593, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(226, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(319, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(321, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(321, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(771, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(593, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(226, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(319, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(349, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(194, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(843, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(449, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(422, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(834, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(349, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(195, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(843, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(449, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(423, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(350, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(195, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(450, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(423, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(350, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(195, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(844, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(450, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(350, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(195, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(844, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(450, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(423, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(349, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(194, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(843, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(449, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(422, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(834, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(349, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(195, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(843, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(449, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(423, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(834, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(350, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(195, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(844, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(450, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(423, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(350, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(195, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(844, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(450, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(423, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(350, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(195, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(844, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(450, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(423, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(25, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(26, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(26, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(172, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(778, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(26, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(26, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(172, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(778, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(26, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(26, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(172, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(778, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(26, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(26, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(172, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(778, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(26, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(26, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(172, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(778, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(25, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(26, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(26, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(172, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(778, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(25, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(26, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(26, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(172, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(778, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(25, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(26, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(26, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(172, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(778, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(25, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(26, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(26, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(172, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(778, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(26, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(26, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(172, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(778, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(848, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(835, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(695, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(840, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(597, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(829, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(849, 1, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(836, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(695, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(842, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(597, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(830, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(849, 1, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(836, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(695, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(842, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(598, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(830, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 1, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(836, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(695, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(842, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(598, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 1, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(836, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(695, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(842, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(598, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(830, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(848, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(835, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(695, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(840, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(597, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(829, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(849, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(836, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(695, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(841, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(597, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(830, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(849, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(836, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(695, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(841, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(598, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(830, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(849, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(836, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(695, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(841, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(598, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(830, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(849, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(836, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(695, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(841, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(598, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(830, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(36, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(40, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(44, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(518, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(547, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(549, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(36, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(40, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(182, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(518, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(547, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(549, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(36, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(40, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(182, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(518, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(547, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(549, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(36, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(40, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(182, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(518, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(549, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(36, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(40, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(182, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(518, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(36, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(549, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(36, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(40, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(44, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(518, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(547, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(549, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(36, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(40, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(182, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(518, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(547, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(549, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(36, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(40, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(182, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(518, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(547, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(549, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(36, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(40, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(182, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(518, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(547, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(549, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(36, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(40, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(182, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(518, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(36, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(549, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(93, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(425, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(355, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(633, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(877, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(94, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(426, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(355, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(633, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(877, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(94, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(426, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(477, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(633, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(877, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(426, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(477, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(634, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(877, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(426, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(477, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(635, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(877, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(93, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(425, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(355, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(633, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(877, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(94, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(426, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(355, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(633, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(877, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(94, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(426, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(477, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(633, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(877, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(426, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(477, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(634, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(877, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(426, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(477, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(635, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(877, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(562, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(778, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(709, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(855, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(710, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(563, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(778, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(709, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(855, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(710, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(563, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(778, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(709, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(855, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(711, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(711, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(711, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(711, 3, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(563, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(778, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(709, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(855, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(711, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(711, 1, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(711, 2, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(711, 3, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(563, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(778, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(709, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(855, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(562, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(778, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(709, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(855, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(710, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(563, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(778, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(709, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(855, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(710, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(563, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(778, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(709, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(855, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(711, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(711, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(711, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(711, 3, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(563, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(778, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(709, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(855, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(711, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(711, 1, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(711, 2, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(711, 3, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(563, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(778, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(709, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(855, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(213, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(290, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(568, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(43, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(453, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(213, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(291, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(568, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(45, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(453, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(213, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(291, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(569, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(45, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(454, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(213, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(291, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(569, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(45, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(454, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(213, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(291, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(45, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(454, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(12, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(213, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(290, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(568, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(43, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(453, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(12, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(213, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(291, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(568, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(45, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(453, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(12, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(213, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(291, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(569, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(45, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(454, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(12, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(213, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(291, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(569, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(45, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(454, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(213, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(291, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(45, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(454, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(420, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(590, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(755, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(819, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(819, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(819, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(420, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(590, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(756, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(819, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(819, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(820, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(420, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(591, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(756, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(819, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(819, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(820, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(420, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(591, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(756, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(820, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(420, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(591, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(756, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(819, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(819, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(820, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(420, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(590, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(755, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(819, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(819, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(819, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(420, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(590, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(756, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(819, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(819, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(820, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(420, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(591, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(756, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(819, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(819, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(820, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(420, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(591, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(756, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(819, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(820, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(420, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(591, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(756, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(819, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(819, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(820, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(131, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(712, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(461, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(776, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(77, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(131, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(712, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(461, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(776, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(77, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(131, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(713, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(461, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(776, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(78, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(131, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(713, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(461, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(776, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(78, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(131, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(713, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(461, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(776, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(78, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(131, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(712, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(461, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(776, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(77, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(131, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(712, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(461, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(851, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(776, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(77, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(131, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(713, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(461, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(776, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(78, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(131, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(713, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(461, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(776, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(78, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(131, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(713, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(461, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(776, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(78, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(37, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(37, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(124, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(225, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(607, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(873, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(37, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(37, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(124, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(225, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(608, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(873, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(37, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(37, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(124, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(225, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(609, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(873, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(37, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(37, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(124, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(37, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(37, 1, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(124, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(225, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(609, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(873, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(37, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(37, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(124, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(225, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(607, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(873, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(37, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(37, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(124, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(225, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(608, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(873, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(37, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(37, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(124, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(225, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(609, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(873, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(37, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(37, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(124, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(873, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(37, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(37, 1, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(124, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(225, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(609, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(873, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(884, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(610, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(704, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(759, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(572, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(610, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(704, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(759, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(572, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(884, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(611, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(705, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(760, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(573, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(612, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(706, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(760, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(573, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(612, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(706, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(760, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(573, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(884, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(610, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(704, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(446, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(759, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(572, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(884, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(610, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(704, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(143, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(759, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(572, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(884, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(611, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(705, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(143, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(760, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(573, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(884, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(612, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(706, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(143, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(760, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(573, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(612, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(706, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(760, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(573, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(128, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(128, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(626, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(626, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(241, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(241, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(128, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(128, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(626, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(626, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(241, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(241, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(128, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(128, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(626, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(626, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(241, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(241, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(128, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(128, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(626, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(626, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(241, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(241, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(128, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(128, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(626, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(626, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(241, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(241, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(128, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(128, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(626, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(626, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(241, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(241, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(128, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(128, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(626, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(626, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(241, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(241, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(128, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(128, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(626, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(626, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(241, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(241, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(128, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(128, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(626, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(626, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(241, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(241, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(128, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(128, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(626, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(626, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(241, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(241, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(67, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(447, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(870, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(825, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(577, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(574, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(68, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(447, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(870, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(577, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(574, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(68, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(448, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(870, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(578, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(575, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(870, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(579, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(576, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(68, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(448, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(870, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(826, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(579, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(576, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(67, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(447, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(870, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(825, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(577, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(574, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(68, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(447, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(870, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(577, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(574, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(68, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(448, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(870, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(578, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(575, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(870, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(579, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(576, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(68, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(448, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(870, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(826, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(579, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(576, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(845, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(845, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(330, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(623, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(195, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(876, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(845, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(845, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(330, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(623, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(195, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(876, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(845, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(845, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(330, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(623, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(195, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(876, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(845, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(845, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(330, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(623, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(195, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(876, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(845, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(845, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(330, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(623, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(195, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(876, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(845, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(845, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(330, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(623, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(195, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(876, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(845, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(845, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(330, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(623, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(195, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(876, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(845, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(845, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(330, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(623, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(195, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(876, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(845, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(845, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(330, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(623, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(195, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(876, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(845, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(845, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(330, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(623, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(195, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(876, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(67, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(447, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(870, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(825, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(577, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(574, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(68, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(447, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(870, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(577, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(574, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(68, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(448, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(870, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(578, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(575, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(870, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(579, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(576, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(67, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(447, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(870, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(825, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(577, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(574, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(68, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(447, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(870, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(577, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(574, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(68, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(448, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(870, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(578, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(575, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(68, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(448, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(870, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(579, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(576, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(25, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(25, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(856, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(280, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(109, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(627, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(845, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(856, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(281, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(109, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(627, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(845, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(857, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(282, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(110, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(628, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(845, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(110, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(628, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(845, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(858, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(282, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(110, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(628, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(845, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(856, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(280, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(109, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(627, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(845, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(856, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(281, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(109, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(627, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(845, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(857, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(282, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(110, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(628, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(845, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(858, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(282, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(110, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(628, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(845, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(858, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(282, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(110, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(628, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(845, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(43, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(43, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(420, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(549, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(753, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(764, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(45, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(182, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(421, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(549, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(753, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(764, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(45, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(182, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(421, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(549, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(754, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(764, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(45, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(182, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(421, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(549, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(754, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(764, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(45, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(549, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(421, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(549, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(754, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(764, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(43, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(43, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(420, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(549, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(753, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(764, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(45, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(182, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(421, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(549, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(753, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(764, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(45, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(182, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(421, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(549, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(754, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(764, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(45, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(182, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(421, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(549, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(754, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(764, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(45, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(549, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(421, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(549, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(754, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(764, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(183, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(183, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(427, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(427, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(659, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(659, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(184, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(184, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(428, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(428, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(660, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(660, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(184, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(184, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(428, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(428, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(660, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(660, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(184, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(184, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(428, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(428, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(660, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(660, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(184, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(184, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(428, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(428, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(660, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(815, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(183, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(183, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(427, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(427, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(659, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(659, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(184, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(184, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(428, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(428, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(660, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(660, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(184, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(184, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(428, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(428, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(660, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(660, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(184, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(184, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(428, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(428, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(660, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(660, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(184, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(184, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(428, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(428, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(660, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(815, 0, Shiny::Random, 2, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(132, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(132, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(825, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(850, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(132, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(132, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(834, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(826, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(832, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(132, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(132, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(825, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(850, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(132, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(834, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(826, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(851, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(132, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(834, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(826, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(832, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(875, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(875, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(52, 2, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 2, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 2, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 2, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 2, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 2, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 2, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 2, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(52, 2, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 2, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 1, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 2, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 2, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 1, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 2, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 2, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 1, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 2, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 1, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 2, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 2, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 1, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(831, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(831, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(831, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(831, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(831, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(831, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(831, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(831, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(832, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(832, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(832, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(831, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(831, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(831, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(831, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(831, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(832, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(831, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(831, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(831, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(832, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(832, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(832, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(2, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(2, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(60, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(60, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(453, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(535, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(2, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(2, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(61, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(61, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(453, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(536, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(3, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(3, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(186, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(186, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(453, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(537, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(3, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(3, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(186, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(186, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(453, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(3, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(3, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(186, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(186, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(453, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(537, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(2, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(2, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(60, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(60, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(453, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(535, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(2, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(2, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(61, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(61, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(453, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(536, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(3, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(3, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(186, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(186, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(453, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(537, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(3, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(3, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(186, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(186, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(453, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(537, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(3, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(3, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(186, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(186, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(453, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(537, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(852, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(852, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(223, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(223, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(686, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(686, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(852, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(852, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(223, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(223, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(686, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(686, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(853, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(853, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(224, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(224, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(687, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(687, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(853, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(853, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(224, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(224, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(853, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(853, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(224, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(224, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(687, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(687, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(852, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(852, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(223, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(223, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(686, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(686, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(852, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(852, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(223, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(223, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(686, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(686, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(853, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(853, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(224, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(224, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(687, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(687, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(853, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(853, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(224, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(224, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(687, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(853, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(853, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(224, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(224, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(687, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(687, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(109, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(202, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(109, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(202, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(5, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(879, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(879, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(109, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(202, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(6, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(109, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(202, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(879, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(109, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(202, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(6, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(109, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(202, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(4, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(878, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(109, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(202, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(5, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(879, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(879, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(109, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(202, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(6, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(879, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(109, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(202, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(879, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(109, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(202, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(6, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(138, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(138, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(140, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(140, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(142, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(142, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(138, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(138, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(140, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(140, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(142, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(142, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(138, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(138, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(140, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(140, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(142, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(142, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(138, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(138, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(140, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(140, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(142, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(142, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(138, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(138, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(140, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(140, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(142, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(142, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(138, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(138, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(140, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(140, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(142, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(142, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(138, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(138, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(140, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(140, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(142, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(142, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(138, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(138, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(140, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(140, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(142, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(142, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(138, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(138, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(140, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(140, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(142, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(142, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(138, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(138, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(140, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(140, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(142, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(142, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(582, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(118, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(127, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(214, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(290, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(479, 4, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(582, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(118, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(127, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(214, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(291, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(479, 4, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(583, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(119, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(127, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(214, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(291, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(479, 4, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(119, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(127, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(214, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(291, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(479, 4, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(584, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(119, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(127, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(214, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(291, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(479, 4, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(582, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(118, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(127, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(214, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(290, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(479, 4, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(582, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(118, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(127, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(214, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(291, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(479, 4, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(583, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(119, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(127, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(214, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(291, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(479, 4, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(584, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(119, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(127, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(214, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(291, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(479, 4, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(584, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(119, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(127, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(214, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(291, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(479, 4, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(607, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(607, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(425, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(425, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(607, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(607, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(426, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(426, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(94, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(607, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(607, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(426, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(426, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(426, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(426, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(609, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(609, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(426, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(426, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(92, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(607, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(607, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(425, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(425, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(93, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(607, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(607, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(426, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(426, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(94, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(607, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(607, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(426, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(426, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(94, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(609, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(426, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(426, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(609, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(609, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(426, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(426, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(573, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(573, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(333, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(333, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(479, 5, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(767, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(573, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(573, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(333, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(333, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(479, 5, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(767, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(573, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(573, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(334, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(334, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(479, 5, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(767, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(573, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(573, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(479, 5, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(767, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(573, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(573, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(334, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(334, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(479, 5, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(767, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(573, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(573, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(333, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(333, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(479, 5, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(767, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(573, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(573, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(333, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(333, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(479, 5, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(767, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(573, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(573, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(334, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(334, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(479, 5, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(767, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(573, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(573, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(334, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(479, 5, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(767, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(573, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(573, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(334, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(334, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(479, 5, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(767, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(337, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(337, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(337, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(338, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(338, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(338, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(337, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(337, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(337, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(338, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(338, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(338, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(337, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(337, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(337, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(338, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(338, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(338, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(337, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(337, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(337, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(338, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(338, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(338, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(337, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(337, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(337, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(338, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(338, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(338, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(337, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(337, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(337, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(338, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(338, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(338, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(337, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(337, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(337, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(338, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(338, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(338, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(337, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(337, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(337, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(338, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(338, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(338, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(337, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(337, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(337, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(338, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(338, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(338, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(337, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(337, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(337, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(338, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(338, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(338, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(722, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(722, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(725, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(725, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(728, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(728, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(722, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(722, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(725, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(725, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(728, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(728, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(722, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(722, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(725, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(725, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(728, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(728, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(722, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(722, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(725, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(725, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(728, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(728, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(722, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(722, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(725, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(725, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(728, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(728, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(722, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(722, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(725, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(725, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(728, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(728, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(722, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(722, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(725, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(725, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(728, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(728, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(722, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(722, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(725, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(725, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(728, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(728, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(722, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(722, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(725, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(725, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(728, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(728, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(722, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(722, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(725, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(725, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(728, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(728, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(570, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(570, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(302, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(355, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(827, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(571, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(571, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(302, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(355, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(828, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(571, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(571, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(302, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(477, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(828, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(571, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(571, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(302, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(477, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(828, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(571, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(571, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(302, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(477, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(828, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(570, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(570, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(302, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(355, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(827, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(571, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(571, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(302, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(355, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(828, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(571, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(571, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(302, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(477, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(828, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(571, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(571, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(302, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(477, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(828, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(571, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(571, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(302, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(477, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(828, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(133, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(134, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(135, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(136, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(196, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(197, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(470, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(471, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(700, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(134, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(135, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(136, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(196, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(197, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(470, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(471, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(700, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(134, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(135, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(136, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(196, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(197, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(470, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(471, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(700, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(133, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(133, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(133, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(134, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(135, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(136, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(196, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(197, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(470, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(471, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(700, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(133, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(134, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(135, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(136, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(196, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(197, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(470, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(471, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(700, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(133, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(134, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(135, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(136, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(196, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(197, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(470, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(471, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(700, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(133, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(225, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(225, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(121, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(121, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(615, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(615, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(225, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(225, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(121, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(121, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(615, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(615, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(225, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(225, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(121, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(121, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(615, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(615, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(615, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(615, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(225, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(225, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(121, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(121, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(615, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(615, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(225, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(225, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(121, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(121, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(615, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(615, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(225, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(225, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(121, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(121, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(615, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(615, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(225, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(225, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(121, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(121, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(615, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(615, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(225, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(121, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(615, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(615, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(225, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(225, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(121, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(121, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(615, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(615, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(554, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(554, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(555, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(555, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(555, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(52, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(554, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(52, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(554, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(52, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(555, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(52, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(555, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(129, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(129, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(52, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(555, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 1, 1, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 2, 1, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 3, 1, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(868, 0, Shiny::Always, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(868, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(132, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(132, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(825, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(850, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(132, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(3, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(9, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(3, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(9, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(3, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(6, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(9, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(3, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(6, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(9, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80) }, std::array<Raid, 30> {Raid(132, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(821, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(132, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(822, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(825, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(850, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(132, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(834, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(826, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(851, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(3, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(9, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(3, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(6, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(9, 0, Shiny::Random, 4, 0, 4, 1, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(3, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(6, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(9, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(3, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(6, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80), Raid(9, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 80) }), DenEvent(std::array<Raid, 30> {Raid(696, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(696, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(696, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(564, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(566, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(698, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(696, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(696, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(696, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(564, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(566, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(698, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(697, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(697, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(697, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(565, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(567, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(699, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(565, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(567, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(699, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(697, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(697, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(697, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(565, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(567, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(699, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(696, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(696, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(696, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(564, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(566, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(698, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(696, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(696, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(696, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(564, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(566, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(698, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(697, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(697, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(697, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(565, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(567, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(699, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(697, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(565, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(567, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(699, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(697, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(697, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(697, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(565, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(567, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(699, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(438, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(185, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(185, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(90, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(90, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 0, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(892, 1, Shiny::Random, 0, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(183, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(183, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(60, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(60, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(363, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(363, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(183, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(183, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(60, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(60, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(363, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(363, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(183, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(183, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(60, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(60, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(363, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(363, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(183, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(183, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(60, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(60, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(363, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(363, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(183, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(183, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(60, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(60, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(363, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(363, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(183, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(183, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(60, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(60, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(363, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(363, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(183, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(183, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(60, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(60, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(363, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(363, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(183, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(183, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(60, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(60, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(363, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(363, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(183, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(183, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(60, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(60, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(363, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(363, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(183, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(183, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(60, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(60, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(363, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(363, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(859, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(859, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(859, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(860, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(860, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(859, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(859, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(859, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(859, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(859, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(860, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(859, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(860, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(860, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(859, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(859, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(861, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(872, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(872, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(771, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(771, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(871, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(871, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(872, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(872, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(771, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(771, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(871, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(871, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(872, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(872, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(771, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(771, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(871, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(871, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(872, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(872, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(872, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(872, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(771, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(771, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(871, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(871, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(872, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(872, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(771, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(771, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(871, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(871, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(872, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(872, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(771, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(771, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(871, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(871, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(872, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(872, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(771, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(771, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(871, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(871, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(872, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(872, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(771, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(871, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(872, 0, Shiny::Always, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(872, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(771, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(771, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(871, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(871, 0, Shiny::Random, 4, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(896, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(897, 0, Shiny::Never, 0, 0, 5, 0, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }), DenEvent(std::array<Raid, 30> {Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(842, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(826, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(841, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(844, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(869, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(834, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(858, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(131, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 1, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(68, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) }, std::array<Raid, 30> {Raid(824, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(833, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(832, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(823, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(850, 0, Shiny::Random, 4, 0, 1, 0, std::array<bool, 5> { 1, 0, 0, 0, 0 }, 17), Raid(831, 0, Shiny::Random, 4, 0, 2, 0, std::array<bool, 5> { 0, 1, 0, 0, 0 }, 30), Raid(826, 0, Shiny::Random, 4, 0, 3, 0, std::array<bool, 5> { 0, 0, 1, 0, 0 }, 40), Raid(132, 0, Shiny::Random, 4, 0, 4, 0, std::array<bool, 5> { 0, 0, 0, 1, 0 }, 50), Raid(99, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(842, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(851, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(826, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(841, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(844, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(823, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(861, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(569, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(869, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(834, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(858, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(12, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(131, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(94, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(884, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(849, 1, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(839, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(68, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(879, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60), Raid(143, 0, Shiny::Random, 4, 0, 5, 1, std::array<bool, 5> { 0, 0, 0, 0, 1 }, 60) })};

constexpr std::array<u8, 3752> BD = { 152, 74, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 187, 79, 102, 117, 0, 0, 190, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 47, 214, 221, 255, 255, 254, 125, 255, 255, 255, 255, 255, 255, 172, 185, 125, 104, 157, 232, 141, 33, 0, 96, 16, 125, 241, 231, 189, 57, 33, 169, 154, 182, 169, 221, 213, 213, 80, 85, 19, 222, 28, 240, 143, 118, 239, 125, 246, 116, 81, 76, 216, 0, 10, 170, 148, 169, 82, 129, 36, 162, 141, 41, 236, 19, 83, 244, 154, 158, 84, 242, 159, 169, 148, 240, 40, 246, 34, 79, 213, 61, 166, 163, 36, 253, 40, 204, 167, 180, 35, 9, 61, 76, 140, 159, 169, 234, 104, 158, 154, 64, 102, 163, 212, 201, 234, 50, 0, 0, 209, 234, 61, 64, 0, 1, 160, 208, 0, 0, 60, 166, 211, 80, 37, 18, 0, 147, 196, 211, 38, 65, 79, 20, 242, 16, 52, 153, 169, 229, 50, 121, 76, 154, 99, 34, 122, 158, 147, 70, 77, 1, 132, 13, 0, 0, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 3, 64, 0, 104, 10, 105, 20, 208, 60, 160, 104, 52, 105, 163, 64, 26, 104, 1, 160, 0, 52, 0, 0, 3, 77, 0, 0, 1, 160, 0, 0, 0, 0, 13, 3, 64, 1, 160, 0, 0, 8, 82, 136, 170, 126, 84, 246, 148, 122, 67, 64, 50, 25, 48, 76, 154, 0, 13, 27, 40, 26, 105, 166, 154, 97, 13, 25, 25, 25, 0, 0, 0, 0, 196, 1, 166, 65, 144, 104, 200, 105, 136, 104, 52, 52, 100, 0, 25, 0, 168, 136, 200, 52, 208, 0, 208, 26, 26, 52, 0, 208, 104, 0, 52, 0, 13, 26, 12, 128, 49, 12, 131, 64, 100, 50, 0, 104, 0, 0, 105, 166, 128, 211, 210, 0, 0, 26, 0, 0, 34, 72, 137, 160, 154, 38, 154, 106, 122, 145, 181, 26, 109, 67, 212, 103, 170, 121, 64, 253, 40, 13, 7, 169, 160, 0, 3, 71, 164, 104, 245, 26, 0, 6, 134, 64, 208, 0, 3, 64, 61, 64, 0, 0, 211, 64, 0, 0, 3, 245, 78, 39, 128, 111, 13, 21, 133, 153, 54, 43, 48, 204, 24, 241, 120, 6, 137, 168, 135, 161, 6, 2, 98, 169, 31, 26, 98, 191, 95, 244, 129, 111, 228, 114, 199, 150, 125, 157, 3, 206, 234, 58, 143, 159, 195, 152, 201, 225, 255, 219, 72, 42, 109, 68, 20, 48, 215, 39, 140, 148, 78, 105, 106, 124, 124, 46, 18, 73, 6, 189, 178, 35, 107, 37, 170, 138, 143, 71, 116, 70, 238, 55, 42, 87, 60, 170, 181, 54, 50, 232, 240, 192, 48, 45, 138, 170, 21, 217, 154, 106, 110, 252, 157, 133, 70, 193, 100, 19, 227, 5, 66, 44, 37, 52, 14, 175, 41, 64, 57, 121, 87, 36, 96, 202, 211, 128, 5, 138, 40, 131, 178, 161, 135, 0, 91, 231, 3, 196, 98, 11, 61, 7, 6, 179, 38, 226, 67, 13, 96, 146, 0, 129, 59, 20, 12, 48, 1, 129, 100, 94, 108, 71, 62, 165, 83, 101, 195, 36, 45, 64, 6, 81, 33, 80, 72, 97, 19, 22, 168, 240, 25, 102, 88, 240, 146, 109, 74, 14, 70, 90, 184, 8, 129, 5, 215, 162, 22, 207, 68, 2, 208, 16, 101, 104, 88, 161, 58, 181, 0, 210, 113, 1, 204, 229, 253, 17, 138, 242, 66, 37, 173, 248, 83, 66, 80, 106, 254, 211, 232, 43, 129, 106, 233, 212, 94, 141, 47, 114, 155, 149, 191, 127, 11, 72, 48, 156, 236, 138, 243, 180, 7, 102, 179, 181, 30, 41, 12, 5, 124, 82, 196, 5, 37, 32, 57, 65, 198, 113, 165, 173, 213, 137, 161, 17, 105, 154, 26, 163, 137, 17, 16, 22, 247, 159, 52, 195, 198, 246, 121, 156, 46, 110, 27, 152, 107, 192, 53, 26, 128, 242, 28, 179, 149, 213, 109, 234, 214, 100, 100, 6, 126, 78, 252, 23, 126, 35, 190, 140, 82, 219, 229, 238, 141, 219, 12, 66, 1, 0, 252, 158, 137, 210, 105, 53, 241, 54, 9, 134, 201, 183, 172, 225, 199, 28, 239, 47, 56, 234, 60, 204, 227, 67, 117, 54, 35, 110, 160, 249, 224, 136, 116, 64, 143, 36, 162, 138, 1, 73, 112, 73, 80, 125, 12, 218, 164, 68, 66, 132, 78, 34, 130, 140, 53, 188, 85, 103, 207, 213, 241, 208, 120, 124, 80, 112, 54, 147, 21, 42, 215, 72, 229, 73, 71, 244, 44, 109, 92, 177, 28, 103, 240, 235, 13, 97, 214, 157, 105, 231, 142, 124, 162, 185, 228, 222, 46, 209, 156, 219, 46, 105, 53, 145, 117, 197, 170, 250, 219, 133, 102, 47, 88, 21, 12, 198, 9, 129, 30, 214, 237, 174, 220, 45, 11, 50, 161, 193, 151, 94, 14, 135, 184, 166, 148, 206, 119, 242, 128, 34, 81, 18, 210, 172, 148, 188, 127, 139, 237, 127, 180, 43, 17, 192, 0, 228, 127, 162, 11, 241, 168, 161, 100, 122, 254, 205, 26, 109, 13, 68, 22, 29, 150, 1, 46, 154, 223, 140, 203, 44, 224, 28, 29, 240, 102, 112, 179, 2, 128, 95, 131, 102, 139, 16, 89, 8, 197, 91, 59, 173, 229, 177, 103, 105, 201, 33, 91, 205, 51, 137, 78, 239, 83, 221, 121, 24, 219, 2, 146, 7, 109, 18, 228, 191, 83, 160, 49, 52, 152, 38, 110, 0, 156, 58, 158, 122, 91, 48, 242, 187, 39, 131, 131, 12, 63, 39, 19, 122, 82, 18, 138, 67, 81, 68, 118, 167, 19, 136, 101, 186, 56, 206, 209, 234, 131, 116, 159, 72, 29, 23, 86, 153, 213, 176, 46, 217, 14, 11, 57, 208, 200, 29, 238, 35, 26, 99, 242, 44, 81, 60, 143, 0, 17, 189, 16, 241, 10, 76, 184, 115, 74, 146, 149, 4, 184, 157, 41, 211, 26, 108, 13, 243, 122, 120, 109, 74, 84, 152, 155, 174, 91, 173, 50, 77, 219, 79, 40, 170, 231, 214, 101, 141, 29, 168, 193, 134, 48, 251, 195, 237, 144, 43, 141, 111, 55, 198, 246, 121, 234, 207, 86, 25, 98, 77, 243, 64, 217, 180, 216, 166, 192, 240, 194, 198, 33, 82, 21, 69, 14, 230, 47, 37, 234, 164, 37, 116, 54, 75, 108, 108, 244, 71, 75, 181, 183, 13, 157, 13, 113, 37, 107, 136, 211, 28, 112, 197, 215, 223, 49, 58, 12, 84, 123, 123, 190, 25, 148, 101, 25, 124, 124, 103, 90, 100, 126, 213, 255, 175, 230, 104, 8, 230, 126, 229, 210, 212, 73, 99, 76, 199, 143, 103, 149, 199, 122, 31, 179, 111, 44, 95, 79, 125, 24, 55, 205, 202, 135, 124, 14, 112, 28, 227, 155, 57, 180, 96, 108, 134, 67, 153, 109, 141, 170, 218, 45, 173, 234, 173, 82, 148, 120, 234, 68, 38, 127, 21, 85, 76, 143, 33, 68, 88, 216, 121, 46, 100, 51, 99, 157, 60, 66, 57, 177, 11, 160, 211, 14, 6, 255, 245, 236, 127, 220, 51, 28, 191, 151, 183, 160, 35, 74, 11, 56, 204, 188, 235, 83, 27, 32, 125, 47, 78, 208, 93, 72, 5, 21, 63, 187, 166, 222, 164, 49, 113, 237, 153, 230, 203, 126, 67, 33, 65, 8, 99, 17, 125, 83, 109, 73, 154, 136, 176, 134, 72, 194, 57, 67, 136, 76, 48, 144, 136, 232, 54, 193, 130, 178, 12, 234, 213, 5, 220, 12, 27, 183, 254, 12, 8, 233, 164, 37, 38, 28, 49, 220, 132, 135, 131, 130, 162, 165, 217, 70, 25, 45, 80, 147, 102, 248, 242, 235, 102, 211, 235, 40, 22, 38, 203, 18, 250, 67, 115, 227, 160, 154, 67, 143, 233, 152, 53, 180, 240, 99, 236, 241, 182, 59, 189, 103, 208, 170, 33, 218, 145, 73, 165, 92, 151, 48, 205, 196, 249, 232, 45, 146, 99, 100, 97, 24, 70, 18, 165, 174, 10, 36, 154, 37, 186, 232, 157, 58, 53, 56, 65, 104, 43, 48, 112, 103, 32, 65, 222, 188, 194, 17, 78, 155, 77, 208, 39, 230, 146, 181, 75, 178, 190, 22, 14, 122, 210, 71, 42, 133, 112, 138, 98, 136, 202, 121, 181, 20, 25, 164, 113, 152, 87, 79, 213, 195, 151, 39, 23, 153, 215, 112, 29, 218, 77, 136, 188, 232, 85, 13, 74, 232, 130, 214, 171, 157, 246, 167, 147, 220, 191, 105, 13, 65, 147, 104, 20, 81, 67, 16, 98, 90, 181, 109, 173, 82, 131, 161, 86, 171, 65, 26, 162, 38, 56, 115, 77, 142, 78, 255, 177, 197, 240, 132, 29, 237, 227, 86, 163, 141, 186, 238, 189, 236, 163, 172, 117, 183, 55, 143, 84, 24, 37, 237, 78, 37, 160, 188, 33, 146, 149, 135, 228, 156, 205, 17, 177, 53, 218, 172, 132, 228, 179, 18, 249, 144, 149, 51, 140, 81, 152, 81, 42, 85, 36, 141, 25, 48, 194, 201, 38, 68, 122, 235, 10, 204, 120, 105, 34, 91, 75, 150, 92, 59, 41, 175, 33, 217, 67, 160, 68, 140, 251, 74, 61, 65, 144, 252, 1, 90, 232, 209, 115, 195, 243, 180, 151, 66, 246, 125, 20, 162, 179, 133, 176, 227, 28, 92, 246, 148, 176, 49, 82, 200, 197, 73, 216, 161, 169, 21, 75, 89, 39, 82, 60, 240, 230, 133, 180, 169, 2, 176, 8, 86, 66, 153, 182, 185, 46, 2, 80, 74, 3, 178, 185, 158, 85, 138, 133, 253, 7, 44, 103, 147, 192, 112, 189, 193, 82, 146, 180, 187, 44, 163, 102, 132, 201, 54, 193, 243, 89, 88, 49, 239, 234, 59, 102, 58, 41, 47, 149, 173, 208, 132, 81, 187, 177, 243, 106, 39, 23, 232, 223, 38, 155, 112, 64, 95, 16, 7, 196, 171, 169, 133, 11, 232, 215, 241, 171, 181, 242, 91, 223, 49, 85, 233, 71, 201, 188, 97, 212, 201, 212, 50, 196, 113, 137, 51, 37, 188, 72, 44, 23, 184, 119, 157, 177, 22, 93, 150, 153, 12, 59, 107, 230, 206, 233, 137, 179, 135, 55, 23, 253, 176, 137, 96, 11, 8, 22, 39, 9, 211, 132, 218, 248, 230, 102, 199, 48, 85, 146, 138, 69, 46, 29, 96, 141, 218, 91, 99, 23, 53, 71, 140, 215, 195, 26, 2, 229, 209, 86, 237, 194, 237, 223, 251, 127, 168, 109, 130, 104, 52, 11, 160, 51, 52, 161, 106, 130, 186, 208, 198, 50, 138, 243, 189, 159, 171, 23, 69, 130, 52, 146, 77, 46, 126, 71, 6, 234, 56, 152, 120, 139, 135, 128, 192, 103, 24, 103, 144, 145, 104, 209, 243, 8, 105, 173, 32, 181, 7, 42, 88, 192, 198, 243, 120, 1, 102, 216, 244, 241, 26, 181, 115, 96, 98, 107, 204, 11, 182, 53, 217, 105, 174, 126, 53, 77, 59, 6, 136, 31, 161, 40, 41, 82, 114, 153, 137, 210, 212, 213, 212, 174, 170, 137, 172, 172, 145, 89, 234, 115, 226, 138, 221, 203, 69, 131, 52, 162, 162, 237, 199, 73, 150, 62, 66, 173, 243, 234, 130, 164, 141, 147, 24, 197, 39, 207, 158, 231, 118, 111, 88, 106, 246, 91, 167, 160, 189, 18, 113, 89, 188, 75, 37, 236, 93, 202, 106, 160, 88, 80, 98, 224, 34, 42, 152, 206, 101, 237, 112, 103, 134, 160, 47, 109, 223, 168, 133, 130, 49, 108, 34, 198, 216, 219, 131, 16, 32, 77, 104, 33, 4, 40, 3, 4, 40, 91, 150, 130, 66, 132, 51, 10, 144, 166, 19, 206, 128, 146, 82, 46, 9, 211, 133, 75, 33, 167, 215, 228, 178, 212, 147, 228, 112, 91, 192, 130, 241, 210, 53, 209, 166, 122, 87, 154, 117, 86, 43, 21, 169, 18, 254, 230, 86, 158, 21, 210, 50, 145, 178, 1, 178, 130, 147, 181, 19, 116, 37, 8, 119, 192, 58, 3, 192, 62, 4, 0, 84, 2, 48, 44, 1, 24, 19, 129, 92, 13, 32, 26, 144, 48, 128, 2, 80, 58, 112, 75, 132, 56, 81, 198, 214, 66, 153, 34, 202, 114, 207, 143, 174, 203, 14, 184, 150, 76, 221, 133, 170, 46, 73, 169, 135, 10, 65, 73, 25, 85, 251, 232, 49, 75, 228, 198, 1, 2, 220, 80, 20, 224, 132, 77, 5, 40, 176, 160, 94, 228, 149, 85, 89, 180, 182, 231, 26, 195, 139, 105, 199, 173, 126, 112, 241, 187, 101, 158, 42, 19, 183, 176, 115, 206, 9, 232, 40, 60, 151, 132, 226, 67, 236, 247, 67, 255, 31, 191, 240, 58, 78, 139, 67, 131, 250, 215, 182, 89, 59, 121, 197, 235, 44, 28, 139, 13, 37, 238, 35, 101, 96, 134, 193, 153, 137, 64, 80, 138, 208, 42, 112, 100, 143, 246, 206, 110, 38, 164, 9, 33, 67, 43, 133, 1, 76, 208, 41, 229, 168, 168, 215, 125, 8, 141, 68, 148, 71, 119, 140, 28, 75, 70, 20, 68, 46, 14, 160, 207, 30, 166, 102, 50, 232, 178, 151, 166, 196, 134, 110, 106, 137, 47, 32, 134, 208, 142, 24, 212, 148, 157, 100, 56, 215, 214, 137, 38, 75, 37, 60, 133, 130, 153, 176, 131, 33, 180, 29, 153, 17, 85, 25, 17, 68, 129, 55, 86, 195, 85, 78, 56, 195, 138, 64, 64, 127, 72, 10, 82, 17, 199, 49, 2, 92, 81, 102, 37, 149, 136, 156, 118, 157, 230, 138, 165, 104, 91, 50, 18, 146, 83, 1, 32, 231, 17, 18, 68, 92, 45, 251, 146, 141, 219, 116, 112, 146, 82, 82, 66, 66, 233, 188, 8, 8, 35, 168, 66, 225, 100, 65, 44, 136, 17, 143, 149, 5, 189, 152, 87, 100, 173, 159, 205, 114, 150, 149, 157, 12, 46, 94, 92, 70, 19, 30, 150, 116, 48, 219, 207, 168, 178, 96, 232, 146, 197, 187, 128, 154, 1, 247, 103, 106, 107, 58, 120, 30, 246, 77, 234, 233, 171, 69, 202, 57, 143, 116, 59, 208, 102, 36, 56, 12, 177, 38, 89, 22, 204, 24, 14, 22, 192, 176, 67, 48, 71, 30, 99, 96, 187, 114, 130, 184, 101, 22, 225, 226, 246, 150, 120, 187, 254, 28, 7, 180, 244, 3, 238, 148, 135, 92, 19, 213, 152, 112, 108, 26, 206, 55, 25, 214, 108, 119, 55, 145, 210, 113, 111, 144, 30, 248, 208, 80, 90, 27, 145, 115, 153, 15, 220, 177, 164, 195, 159, 98, 166, 91, 102, 211, 107, 65, 69, 139, 203, 78, 57, 164, 220, 63, 164, 90, 41, 85, 68, 69, 20, 21, 20, 84, 7, 225, 247, 29, 125, 30, 209, 101, 78, 213, 249, 233, 125, 244, 163, 183, 116, 195, 31, 75, 236, 105, 168, 126, 29, 223, 127, 186, 54, 113, 84, 134, 28, 37, 184, 4, 146, 185, 108, 57, 66, 202, 27, 228, 243, 133, 178, 53, 239, 12, 182, 42, 188, 15, 40, 24, 99, 32, 139, 39, 39, 141, 245, 165, 32, 210, 168, 170, 169, 117, 193, 61, 238, 39, 71, 157, 7, 146, 104, 96, 204, 82, 160, 154, 37, 67, 249, 153, 43, 114, 158, 34, 213, 138, 205, 107, 204, 79, 16, 183, 230, 101, 32, 175, 181, 229, 193, 125, 59, 112, 101, 81, 29, 116, 81, 37, 56, 228, 112, 39, 230, 65, 196, 70, 12, 98, 73, 3, 60, 31, 15, 48, 20, 192, 119, 52, 157, 128, 96, 80, 198, 71, 45, 196, 86, 219, 41, 64, 22, 166, 178, 225, 17, 198, 42, 25, 33, 87, 30, 7, 238, 9, 140, 36, 38, 177, 201, 53, 174, 86, 219, 33, 106, 195, 166, 100, 130, 217, 123, 226, 228, 85, 6, 65, 14, 250, 157, 184, 1, 181, 143, 97, 35, 1, 36, 110, 0, 221, 44, 141, 134, 253, 90, 170, 26, 46, 146, 203, 72, 200, 143, 33, 35, 137, 20, 136, 228, 14, 0, 32, 95, 10, 20, 24, 2, 12, 1, 0, 48, 6, 243, 201, 151, 202, 38, 169, 114, 252, 80, 107, 245, 249, 140, 102, 57, 184, 247, 21, 115, 170, 19, 163, 16, 196, 239, 79, 143, 151, 159, 167, 168, 148, 51, 253, 142, 250, 223, 194, 205, 204, 208, 188, 201, 150, 76, 73, 128, 96, 1, 22, 120, 28, 158, 166, 110, 139, 228, 16, 221, 25, 152, 102, 66, 40, 233, 17, 16, 221, 67, 85, 221, 196, 196, 150, 242, 54, 50, 69, 17, 153, 148, 69, 17, 81, 9, 209, 126, 254, 127, 222, 250, 159, 201, 204, 122, 191, 157, 245, 250, 173, 227, 122, 34, 32, 166, 106, 3, 131, 219, 118, 125, 38, 225, 186, 124, 52, 167, 141, 18, 8, 68, 130, 129, 18, 13, 68, 55, 96, 25, 215, 67, 85, 36, 68, 21, 52, 197, 64, 91, 108, 106, 9, 138, 74, 144, 239, 242, 226, 75, 50, 68, 20, 37, 152, 166, 75, 16, 153, 43, 147, 75, 53, 4, 20, 144, 27, 169, 164, 98, 33, 162, 50, 4, 44, 2, 36, 16, 200, 28, 224, 55, 179, 101, 179, 98, 138, 72, 1, 18, 160, 36, 96, 178, 14, 42, 16, 167, 85, 45, 162, 154, 104, 176, 97, 96, 216, 106, 27, 9, 10, 24, 129, 147, 110, 6, 65, 49, 223, 170, 20, 196, 168, 97, 154, 9, 98, 32, 13, 208, 108, 183, 28, 54, 70, 148, 179, 48, 64, 20, 184, 15, 173, 212, 222, 230, 115, 11, 54, 9, 22, 33, 22, 16, 33, 4, 131, 166, 130, 138, 170, 100, 98, 86, 70, 17, 32, 100, 8, 72, 100, 33, 28, 240, 73, 169, 52, 82, 225, 100, 41, 137, 169, 170, 213, 68, 100, 228, 76, 12, 56, 195, 140, 204, 130, 177, 199, 6, 19, 2, 103, 125, 221, 79, 247, 67, 149, 201, 212, 244, 233, 253, 155, 255, 239, 87, 78, 151, 196, 240, 240, 12, 50, 97, 147, 36, 195, 34, 77, 119, 241, 173, 205, 213, 253, 126, 122, 122, 122, 156, 13, 94, 46, 103, 59, 87, 157, 157, 194, 205, 225, 231, 103, 107, 103, 250, 90, 60, 217, 34, 54, 2, 157, 135, 13, 32, 216, 24, 164, 14, 5, 67, 197, 36, 84, 78, 154, 35, 112, 11, 144, 52, 193, 34, 92, 86, 6, 64, 148, 196, 179, 65, 77, 159, 11, 69, 219, 170, 14, 16, 36, 75, 37, 80, 126, 222, 87, 244, 252, 255, 181, 183, 130, 111, 163, 117, 204, 48, 136, 35, 116, 77, 90, 34, 166, 38, 34, 34, 36, 146, 96, 152, 106, 8, 146, 24, 162, 34, 104, 34, 45, 244, 142, 3, 2, 176, 50, 239, 16, 163, 148, 146, 5, 36, 164, 1, 77, 9, 36, 49, 88, 166, 192, 54, 25, 130, 20, 45, 100, 228, 154, 235, 28, 41, 74, 4, 112, 229, 92, 64, 194, 24, 136, 132, 38, 152, 136, 10, 30, 241, 34, 26, 30, 104, 103, 1, 53, 130, 225, 96, 151, 121, 210, 208, 3, 6, 64, 201, 92, 40, 149, 37, 168, 144, 129, 41, 100, 219, 137, 153, 139, 132, 197, 83, 20, 85, 46, 227, 14, 36, 96, 156, 41, 76, 13, 9, 138, 138, 11, 92, 48, 56, 88, 82, 153, 50, 84, 86, 230, 24, 204, 69, 41, 35, 66, 77, 84, 76, 68, 203, 12, 192, 196, 112, 1, 31, 121, 134, 148, 193, 111, 97, 149, 45, 80, 166, 64, 228, 180, 108, 128, 113, 36, 138, 73, 64, 137, 86, 219, 128, 225, 76, 5, 152, 58, 200, 209, 169, 7, 155, 141, 153, 24, 217, 137, 160, 140, 166, 149, 80, 181, 16, 72, 66, 101, 145, 134, 253, 34, 81, 128, 41, 45, 125, 69, 150, 59, 35, 69, 194, 16, 128, 233, 161, 168, 194, 16, 18, 49, 6, 72, 74, 26, 24, 37, 162, 8, 96, 148, 219, 56, 70, 238, 96, 94, 3, 65, 43, 155, 172, 200, 205, 134, 139, 102, 38, 206, 6, 128, 209, 138, 103, 76, 82, 217, 55, 42, 148, 220, 52, 49, 28, 183, 54, 22, 38, 244, 58, 197, 21, 84, 34, 76, 20, 228, 4, 138, 18, 52, 49, 102, 53, 98, 101, 122, 213, 84, 84, 146, 85, 85, 26, 1, 205, 99, 38, 141, 166, 195, 104, 162, 208, 137, 79, 0, 25, 17, 194, 81, 36, 168, 74, 2, 64, 207, 96, 18, 173, 4, 12, 240, 10, 32, 70, 34, 58, 68, 53, 8, 209, 169, 77, 73, 165, 72, 56, 37, 139, 58, 96, 102, 76, 91, 177, 81, 168, 129, 6, 8, 39, 250, 140, 100, 136, 136, 136, 10, 36, 39, 125, 222, 176, 136, 118, 25, 129, 47, 65, 42, 130, 213, 9, 124, 180, 21, 124, 179, 219, 28, 81, 196, 71, 54, 89, 35, 163, 58, 49, 26, 51, 24, 12, 145, 194, 157, 140, 2, 68, 33, 23, 24, 181, 91, 21, 100, 45, 166, 138, 181, 173, 251, 64, 31, 224, 131, 36, 11, 238, 69, 64, 223, 178, 4, 171, 191, 100, 152, 82, 34, 27, 12, 0, 196, 206, 203, 93, 34, 140, 134, 123, 205, 46, 173, 140, 193, 44, 155, 68, 86, 169, 40, 136, 117, 106, 136, 168, 123, 222, 43, 145, 49, 6, 166, 8, 56, 67, 11, 179, 17, 54, 65, 65, 78, 149, 80, 233, 1, 132, 102, 24, 12, 100, 35, 9, 10, 202, 192, 90, 22, 203, 61, 178, 202, 132, 49, 19, 18, 195, 37, 238, 222, 1, 174, 230, 83, 73, 90, 68, 208, 105, 6, 68, 6, 140, 159, 158, 19, 52, 50, 139, 197, 162, 37, 97, 74, 218, 44, 90, 160, 10, 10, 181, 137, 158, 73, 76, 131, 47, 72, 108, 218, 155, 83, 72, 182, 139, 81, 180, 10, 141, 69, 88, 50, 12, 64, 198, 42, 154, 144, 58, 164, 33, 169, 83, 16, 68, 148, 142, 179, 80, 98, 85, 162, 21, 1, 164, 192, 148, 13, 162, 103, 67, 80, 133, 0, 41, 130, 218, 96, 166, 152, 84, 184, 56, 144, 200, 184, 80, 182, 136, 4, 34, 212, 82, 160, 169, 136, 25, 128, 46, 56, 142, 104, 66, 81, 130, 24, 196, 9, 255, 197, 220, 145, 78, 20, 36, 46, 211, 217, 157, 64 };

constexpr std::array<u8, 1418> BD_UNDERGROUND = { 90, 36, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 4, 228, 174, 219, 0, 10, 64, 255, 255, 255, 255, 253, 239, 123, 125, 249, 127, 95, 254, 255, 212, 222, 247, 213, 88, 77, 32, 237, 73, 189, 216, 188, 13, 187, 92, 170, 157, 98, 197, 165, 132, 224, 6, 95, 0, 0, 0, 0, 0, 0, 16, 105, 145, 144, 100, 196, 105, 166, 4, 211, 4, 25, 49, 24, 8, 201, 163, 70, 32, 196, 50, 25, 52, 100, 193, 12, 140, 77, 12, 16, 201, 145, 160, 105, 136, 104, 25, 13, 50, 96, 65, 166, 70, 65, 147, 17, 166, 152, 19, 76, 16, 100, 196, 96, 35, 38, 141, 24, 131, 16, 200, 100, 209, 147, 4, 50, 49, 52, 48, 67, 38, 70, 129, 166, 33, 160, 100, 52, 201, 129, 6, 153, 25, 6, 76, 70, 154, 96, 77, 48, 65, 147, 17, 128, 140, 154, 52, 98, 12, 67, 33, 147, 70, 76, 16, 200, 196, 208, 193, 12, 153, 26, 6, 152, 134, 129, 144, 211, 38, 4, 26, 100, 100, 25, 49, 26, 105, 129, 52, 193, 6, 76, 70, 2, 50, 104, 209, 136, 49, 12, 134, 77, 25, 48, 67, 35, 19, 67, 4, 50, 100, 104, 26, 98, 26, 6, 67, 76, 152, 16, 105, 145, 144, 100, 196, 105, 166, 4, 211, 4, 25, 49, 24, 8, 201, 163, 70, 32, 196, 50, 25, 52, 100, 193, 12, 140, 77, 12, 16, 201, 145, 160, 105, 136, 104, 25, 13, 50, 96, 17, 36, 130, 41, 180, 72, 153, 181, 52, 122, 72, 211, 70, 158, 161, 166, 202, 122, 141, 49, 52, 105, 145, 234, 3, 101, 3, 79, 41, 228, 129, 137, 166, 131, 79, 83, 53, 49, 13, 54, 158, 160, 212, 242, 155, 80, 54, 147, 245, 79, 105, 48, 196, 211, 213, 53, 32, 62, 34, 107, 62, 106, 120, 201, 114, 32, 158, 251, 180, 109, 29, 154, 119, 9, 168, 81, 14, 228, 123, 176, 62, 48, 31, 28, 14, 240, 47, 135, 124, 187, 229, 223, 134, 111, 1, 232, 31, 73, 49, 60, 63, 172, 49, 225, 125, 208, 143, 144, 113, 158, 33, 228, 182, 63, 48, 91, 206, 127, 97, 98, 63, 199, 213, 31, 101, 244, 15, 108, 230, 60, 211, 251, 156, 223, 112, 255, 5, 26, 199, 110, 67, 14, 139, 110, 137, 211, 122, 111, 72, 233, 220, 117, 58, 180, 81, 70, 248, 218, 13, 147, 174, 81, 118, 38, 222, 115, 142, 190, 74, 126, 119, 202, 40, 143, 156, 60, 144, 245, 14, 79, 173, 170, 26, 165, 143, 108, 57, 104, 115, 249, 102, 178, 88, 232, 23, 67, 94, 227, 104, 184, 219, 46, 40, 221, 30, 192, 123, 129, 240, 28, 50, 16, 227, 16, 156, 87, 176, 255, 227, 160, 67, 93, 174, 48, 160, 129, 138, 198, 44, 19, 101, 216, 245, 223, 105, 158, 185, 70, 209, 156, 152, 128, 137, 229, 153, 74, 85, 4, 138, 81, 8, 18, 12, 17, 145, 5, 40, 20, 131, 24, 72, 69, 35, 19, 152, 245, 71, 214, 75, 155, 224, 17, 130, 145, 138, 139, 9, 9, 24, 9, 8, 66, 9, 18, 40, 178, 4, 32, 44, 130, 167, 196, 59, 135, 21, 21, 91, 119, 205, 84, 9, 0, 241, 165, 19, 205, 138, 211, 36, 82, 68, 168, 148, 65, 115, 144, 166, 10, 194, 3, 100, 136, 86, 245, 222, 150, 16, 178, 196, 192, 226, 148, 138, 22, 18, 33, 21, 34, 114, 147, 217, 14, 88, 115, 83, 58, 127, 179, 254, 38, 46, 70, 16, 139, 34, 144, 136, 194, 43, 162, 208, 208, 196, 162, 129, 174, 202, 150, 130, 44, 32, 106, 118, 77, 22, 15, 236, 66, 235, 155, 139, 18, 24, 66, 161, 0, 132, 144, 8, 37, 37, 20, 70, 33, 8, 88, 167, 75, 196, 163, 21, 188, 48, 36, 48, 179, 40, 185, 120, 187, 5, 48, 170, 203, 139, 68, 8, 95, 107, 13, 152, 194, 196, 100, 26, 36, 10, 144, 133, 4, 32, 135, 106, 80, 208, 27, 141, 195, 73, 96, 189, 164, 160, 130, 72, 178, 4, 34, 69, 136, 227, 184, 41, 75, 48, 2, 48, 119, 92, 124, 186, 119, 165, 227, 24, 18, 67, 33, 67, 68, 192, 250, 238, 236, 134, 70, 230, 248, 66, 48, 132, 55, 36, 40, 100, 33, 24, 72, 65, 166, 35, 165, 69, 3, 155, 114, 211, 10, 148, 232, 16, 112, 35, 191, 14, 253, 56, 111, 160, 158, 143, 170, 27, 234, 57, 70, 169, 170, 92, 92, 112, 83, 152, 112, 125, 163, 236, 7, 233, 40, 203, 113, 222, 39, 59, 249, 156, 1, 243, 239, 50, 28, 231, 129, 238, 135, 138, 115, 203, 58, 205, 143, 184, 107, 25, 180, 75, 91, 93, 132, 57, 161, 202, 14, 120, 123, 198, 177, 8, 81, 71, 144, 122, 39, 226, 43, 160, 209, 90, 239, 148, 125, 164, 215, 55, 228, 60, 7, 162, 29, 39, 164, 252, 211, 129, 29, 128, 228, 60, 55, 150, 31, 59, 15, 31, 126, 133, 73, 154, 37, 162, 85, 145, 44, 17, 4, 178, 64, 3, 195, 61, 224, 129, 215, 108, 221, 19, 2, 1, 76, 70, 4, 7, 241, 165, 20, 17, 96, 22, 138, 68, 138, 70, 10, 148, 132, 129, 102, 21, 26, 161, 160, 178, 66, 152, 144, 144, 168, 84, 32, 80, 211, 8, 81, 2, 204, 168, 88, 197, 44, 88, 168, 74, 37, 138, 11, 16, 128, 92, 196, 42, 33, 144, 138, 20, 131, 200, 61, 247, 148, 156, 158, 186, 66, 224, 217, 31, 81, 49, 16, 19, 123, 206, 4, 77, 13, 9, 12, 197, 18, 136, 194, 68, 77, 34, 36, 129, 8, 16, 128, 89, 128, 80, 96, 82, 150, 34, 165, 201, 164, 148, 132, 136, 194, 232, 92, 75, 55, 176, 180, 40, 132, 96, 24, 1, 11, 146, 38, 9, 19, 6, 12, 35, 142, 154, 32, 157, 253, 28, 47, 23, 129, 123, 199, 125, 208, 134, 96, 234, 6, 200, 237, 58, 161, 14, 18, 117, 143, 219, 231, 251, 20, 109, 149, 200, 3, 49, 156, 51, 253, 255, 161, 167, 219, 81, 245, 116, 205, 221, 221, 209, 216, 40, 188, 191, 130, 76, 53, 11, 204, 76, 78, 228, 16, 222, 58, 138, 164, 0, 68, 250, 155, 38, 115, 249, 118, 115, 48, 113, 2, 29, 216, 137, 149, 0, 203, 109, 178, 26, 199, 98, 230, 240, 2, 107, 94, 82, 89, 89, 142, 197, 187, 223, 147, 199, 234, 247, 191, 51, 99, 125, 155, 50, 117, 129, 21, 102, 243, 165, 113, 196, 151, 47, 83, 119, 142, 166, 223, 91, 111, 180, 3, 57, 163, 78, 129, 161, 8, 135, 117, 13, 32, 84, 129, 21, 76, 232, 7, 192, 0, 94, 173, 218, 107, 26, 157, 168, 98, 36, 18, 65, 129, 5, 97, 4, 33, 0, 128, 198, 1, 22, 49, 139, 6, 48, 131, 34, 201, 25, 2, 4, 33, 24, 64, 131, 0, 132, 18, 9, 4, 132, 8, 70, 17, 21, 129, 4, 96, 144, 129, 2, 1, 24, 164, 88, 196, 82, 44, 129, 22, 16, 33, 0, 145, 98, 196, 35, 40, 110, 221, 210, 84, 5, 186, 21, 106, 74, 170, 27, 16, 11, 100, 5, 76, 138, 32, 88, 11, 187, 106, 7, 40, 40, 152, 99, 38, 80, 80, 110, 64, 180, 67, 13, 213, 8, 23, 33, 106, 10, 20, 166, 129, 168, 0, 180, 140, 70, 17, 32, 41, 8, 68, 145, 40, 0, 60, 125, 14, 197, 66, 136, 84, 167, 183, 171, 25, 9, 87, 86, 242, 90, 18, 73, 9, 12, 164, 162, 99, 81, 37, 244, 38, 88, 24, 99, 69, 240, 102, 84, 27, 65, 75, 226, 45, 110, 9, 72, 150, 136, 50, 33, 126, 38, 6, 57, 46, 45, 87, 95, 47, 189, 182, 82, 138, 196, 138, 161, 24, 224, 110, 114, 95, 116, 107, 26, 180, 10, 181, 155, 76, 32, 129, 50, 16, 164, 104, 148, 64, 88, 100, 41, 64, 202, 65, 11, 36, 36, 0, 91, 140, 52, 108, 118, 145, 4, 200, 96, 210, 232, 17, 2, 161, 32, 172, 34, 51, 44, 164, 209, 128, 55, 213, 35, 255, 197, 220, 145, 78, 20, 36, 1, 57, 43, 182, 192 };

constexpr std::array<u8, 3731> SP = { 152, 74, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 253, 153, 177, 67, 0, 0, 190, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 175, 214, 221, 255, 255, 254, 253, 255, 255, 255, 255, 255, 255, 172, 184, 125, 104, 157, 234, 157, 32, 0, 96, 16, 125, 95, 117, 5, 33, 218, 69, 173, 83, 221, 213, 212, 65, 84, 143, 115, 222, 26, 15, 77, 239, 182, 4, 168, 122, 0, 0, 106, 149, 42, 84, 160, 73, 40, 169, 178, 155, 76, 212, 102, 161, 149, 61, 39, 132, 96, 83, 121, 77, 169, 128, 210, 104, 218, 83, 211, 73, 237, 76, 4, 158, 167, 148, 27, 19, 65, 61, 79, 68, 15, 36, 61, 16, 104, 0, 0, 6, 212, 30, 160, 0, 0, 0, 1, 160, 105, 134, 154, 130, 81, 19, 64, 140, 38, 154, 100, 38, 19, 33, 168, 197, 13, 166, 137, 54, 153, 79, 212, 212, 246, 154, 41, 237, 79, 74, 126, 166, 167, 148, 109, 76, 218, 147, 70, 128, 1, 161, 163, 70, 212, 209, 145, 160, 104, 0, 104, 0, 12, 131, 52, 155, 80, 98, 104, 0, 6, 128, 198, 20, 122, 167, 168, 0, 0, 0, 0, 6, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 2, 20, 162, 42, 158, 245, 79, 37, 60, 147, 26, 154, 6, 134, 152, 134, 154, 104, 0, 13, 166, 160, 6, 210, 0, 6, 141, 26, 104, 0, 3, 65, 144, 0, 26, 0, 6, 19, 64, 0, 0, 105, 144, 0, 1, 160, 12, 166, 129, 160, 104, 208, 104, 3, 64, 50, 26, 0, 6, 140, 64, 104, 3, 35, 212, 48, 128, 50, 50, 0, 208, 50, 25, 6, 128, 26, 50, 0, 52, 104, 0, 49, 13, 1, 144, 0, 3, 64, 34, 68, 130, 70, 137, 8, 218, 158, 83, 76, 129, 160, 27, 212, 77, 27, 73, 160, 26, 104, 0, 0, 30, 163, 70, 212, 217, 64, 0, 211, 67, 64, 0, 209, 160, 30, 160, 0, 0, 0, 0, 0, 0, 52, 208, 57, 110, 25, 190, 52, 86, 22, 100, 216, 172, 195, 48, 99, 220, 176, 13, 19, 81, 14, 56, 38, 4, 64, 18, 25, 96, 144, 18, 247, 127, 0, 29, 229, 18, 197, 44, 247, 225, 11, 123, 14, 195, 83, 157, 4, 215, 174, 70, 175, 58, 42, 5, 78, 70, 65, 67, 111, 10, 184, 246, 23, 136, 52, 199, 200, 70, 161, 85, 14, 123, 180, 71, 75, 75, 170, 42, 60, 92, 34, 56, 115, 193, 82, 185, 69, 85, 211, 102, 188, 92, 178, 12, 140, 213, 80, 193, 127, 200, 242, 58, 145, 244, 228, 207, 224, 153, 233, 128, 89, 232, 153, 224, 89, 251, 141, 51, 179, 230, 145, 35, 206, 126, 1, 94, 209, 1, 142, 137, 246, 190, 98, 173, 200, 14, 147, 159, 49, 156, 116, 190, 139, 77, 115, 43, 28, 89, 153, 103, 92, 110, 1, 155, 140, 57, 195, 0, 96, 78, 218, 23, 132, 119, 154, 170, 114, 248, 169, 27, 98, 3, 136, 76, 88, 18, 56, 196, 205, 57, 0, 29, 137, 216, 144, 9, 54, 233, 81, 209, 181, 21, 132, 44, 89, 109, 19, 153, 168, 156, 13, 32, 64, 244, 253, 60, 136, 35, 83, 252, 1, 226, 49, 0, 242, 188, 126, 173, 195, 56, 186, 133, 170, 63, 125, 117, 37, 71, 97, 251, 79, 44, 184, 5, 252, 71, 121, 142, 84, 199, 219, 244, 151, 38, 75, 59, 241, 133, 39, 128, 92, 165, 160, 120, 43, 75, 101, 210, 35, 136, 185, 164, 93, 136, 172, 172, 7, 84, 110, 246, 69, 253, 235, 182, 227, 17, 107, 183, 57, 97, 201, 33, 32, 30, 102, 14, 231, 245, 210, 68, 94, 141, 99, 8, 71, 23, 11, 143, 204, 248, 72, 72, 6, 238, 177, 192, 229, 91, 179, 49, 9, 8, 17, 111, 250, 213, 17, 56, 34, 60, 8, 197, 47, 128, 198, 17, 195, 99, 16, 128, 64, 63, 55, 161, 119, 77, 211, 127, 153, 222, 35, 166, 40, 148, 227, 142, 118, 58, 251, 87, 224, 72, 89, 204, 232, 153, 115, 211, 104, 121, 208, 33, 17, 243, 196, 61, 176, 36, 41, 108, 81, 64, 47, 24, 196, 182, 132, 40, 114, 232, 37, 37, 20, 36, 114, 40, 40, 195, 98, 136, 15, 235, 0, 224, 124, 128, 80, 200, 57, 163, 101, 90, 71, 74, 74, 63, 161, 102, 254, 11, 35, 148, 254, 62, 104, 218, 28, 131, 144, 117, 103, 38, 81, 92, 146, 112, 204, 52, 108, 57, 147, 6, 233, 190, 69, 223, 139, 85, 245, 187, 49, 90, 24, 172, 138, 134, 134, 73, 145, 31, 203, 134, 240, 224, 46, 22, 202, 135, 27, 94, 180, 29, 199, 159, 77, 212, 216, 119, 194, 128, 34, 81, 18, 229, 90, 82, 243, 159, 15, 218, 127, 104, 86, 99, 144, 1, 219, 123, 18, 11, 203, 162, 133, 145, 235, 126, 34, 52, 220, 54, 140, 36, 246, 198, 248, 149, 154, 183, 227, 50, 224, 28, 19, 133, 146, 25, 221, 118, 112, 93, 132, 208, 108, 241, 96, 11, 25, 24, 42, 199, 172, 210, 50, 232, 102, 20, 101, 104, 196, 89, 216, 151, 54, 55, 249, 95, 107, 134, 32, 161, 124, 65, 225, 237, 136, 193, 242, 192, 250, 16, 53, 168, 90, 142, 40, 177, 100, 179, 17, 149, 161, 116, 14, 12, 49, 8, 181, 44, 172, 200, 137, 241, 228, 248, 142, 204, 208, 208, 55, 238, 142, 51, 179, 177, 195, 37, 64, 144, 58, 44, 132, 206, 170, 130, 209, 144, 224, 184, 174, 134, 48, 238, 149, 33, 203, 33, 15, 190, 40, 200, 120, 64, 143, 62, 68, 148, 46, 90, 39, 73, 200, 196, 192, 157, 217, 238, 77, 60, 143, 122, 237, 88, 239, 78, 88, 160, 163, 190, 92, 45, 100, 219, 205, 129, 69, 87, 121, 199, 16, 104, 162, 154, 100, 15, 144, 60, 66, 174, 110, 247, 122, 119, 86, 237, 205, 110, 104, 231, 145, 59, 214, 131, 198, 223, 162, 78, 57, 200, 17, 21, 21, 1, 138, 163, 24, 48, 74, 95, 77, 36, 217, 85, 21, 159, 98, 97, 178, 77, 89, 142, 122, 20, 154, 52, 101, 168, 174, 238, 44, 12, 81, 198, 187, 170, 42, 248, 117, 138, 15, 3, 140, 57, 110, 91, 151, 29, 59, 199, 28, 218, 255, 180, 156, 222, 99, 243, 227, 207, 235, 233, 234, 10, 104, 138, 70, 205, 143, 59, 111, 7, 58, 254, 239, 163, 175, 53, 179, 71, 209, 231, 134, 244, 232, 97, 210, 135, 28, 14, 57, 211, 206, 158, 140, 142, 16, 106, 58, 45, 113, 120, 174, 149, 229, 202, 163, 82, 84, 120, 234, 68, 70, 132, 250, 131, 180, 165, 142, 168, 150, 21, 254, 43, 152, 140, 216, 100, 218, 34, 57, 181, 9, 97, 203, 15, 139, 211, 254, 221, 255, 252, 248, 58, 39, 4, 203, 197, 231, 86, 19, 37, 101, 254, 177, 153, 239, 182, 147, 150, 16, 166, 125, 198, 134, 52, 136, 81, 83, 253, 227, 48, 103, 131, 7, 18, 189, 163, 54, 108, 33, 226, 36, 48, 120, 97, 253, 66, 251, 41, 155, 118, 41, 195, 36, 78, 25, 32, 159, 19, 129, 172, 24, 43, 33, 230, 90, 140, 95, 74, 48, 122, 255, 158, 48, 36, 170, 160, 156, 160, 113, 172, 232, 200, 248, 49, 60, 230, 234, 155, 178, 82, 187, 217, 79, 47, 37, 251, 60, 188, 153, 165, 65, 51, 2, 234, 59, 72, 29, 4, 209, 220, 133, 150, 110, 159, 203, 221, 82, 220, 226, 75, 201, 213, 129, 19, 92, 245, 96, 249, 100, 79, 244, 110, 110, 204, 59, 123, 116, 21, 169, 49, 112, 95, 151, 229, 250, 222, 197, 9, 197, 60, 226, 189, 88, 58, 109, 149, 90, 29, 219, 71, 33, 162, 128, 3, 10, 33, 163, 74, 3, 40, 134, 214, 64, 53, 70, 192, 157, 59, 91, 11, 179, 92, 234, 91, 233, 198, 18, 192, 140, 252, 39, 241, 0, 169, 48, 22, 112, 177, 4, 160, 134, 146, 57, 204, 171, 160, 227, 199, 163, 36, 236, 231, 77, 202, 239, 71, 69, 38, 244, 94, 166, 21, 67, 82, 184, 129, 119, 92, 247, 190, 232, 251, 126, 148, 58, 200, 107, 29, 125, 240, 81, 69, 12, 195, 18, 253, 252, 230, 246, 10, 15, 132, 243, 180, 37, 84, 68, 215, 13, 162, 78, 233, 208, 250, 236, 222, 160, 131, 196, 226, 27, 118, 156, 223, 13, 225, 189, 41, 71, 113, 119, 220, 28, 67, 213, 6, 73, 139, 167, 50, 225, 56, 199, 13, 40, 33, 154, 147, 148, 35, 194, 113, 253, 7, 9, 61, 70, 210, 100, 56, 73, 99, 108, 210, 25, 102, 69, 73, 201, 165, 70, 91, 24, 94, 48, 221, 143, 77, 83, 67, 138, 240, 145, 41, 164, 202, 109, 155, 178, 90, 225, 237, 147, 211, 74, 42, 72, 26, 113, 245, 198, 52, 36, 2, 234, 85, 119, 157, 128, 231, 133, 231, 233, 174, 36, 60, 218, 238, 162, 179, 137, 121, 204, 114, 243, 90, 165, 225, 138, 151, 198, 42, 92, 98, 134, 176, 170, 103, 112, 207, 116, 65, 0, 236, 143, 35, 128, 161, 2, 37, 88, 172, 119, 82, 201, 33, 40, 37, 1, 196, 151, 48, 159, 20, 219, 201, 174, 85, 76, 38, 0, 225, 117, 126, 165, 40, 209, 111, 238, 73, 200, 125, 63, 123, 175, 54, 241, 130, 203, 99, 223, 180, 240, 197, 23, 167, 184, 169, 8, 113, 32, 110, 117, 45, 86, 39, 179, 177, 31, 127, 32, 159, 54, 229, 1, 0, 147, 47, 104, 67, 155, 176, 205, 53, 140, 53, 114, 96, 121, 22, 204, 58, 153, 58, 134, 88, 78, 49, 34, 84, 151, 138, 50, 140, 166, 219, 193, 126, 153, 56, 151, 26, 200, 227, 232, 97, 57, 151, 204, 126, 142, 61, 172, 159, 246, 234, 37, 208, 46, 160, 93, 164, 41, 78, 23, 105, 244, 141, 158, 70, 200, 171, 53, 85, 138, 97, 61, 224, 143, 95, 92, 225, 139, 201, 82, 3, 147, 8, 102, 136, 195, 136, 85, 197, 132, 197, 139, 255, 119, 218, 143, 48, 76, 24, 23, 1, 179, 192, 11, 245, 23, 22, 166, 49, 149, 92, 166, 14, 23, 102, 171, 155, 44, 169, 52, 218, 123, 123, 155, 175, 163, 147, 67, 69, 116, 50, 153, 77, 179, 64, 250, 105, 38, 249, 33, 44, 141, 110, 252, 91, 3, 172, 93, 202, 199, 185, 95, 220, 47, 103, 16, 83, 33, 198, 87, 108, 154, 60, 131, 42, 243, 206, 203, 144, 156, 104, 66, 94, 177, 70, 145, 67, 82, 84, 86, 165, 37, 118, 202, 82, 253, 187, 138, 170, 92, 2, 210, 89, 187, 222, 110, 89, 179, 127, 5, 227, 18, 174, 160, 245, 163, 142, 146, 170, 124, 117, 26, 44, 107, 209, 250, 137, 180, 190, 131, 193, 12, 133, 143, 64, 97, 19, 38, 76, 115, 184, 51, 24, 106, 38, 93, 86, 82, 202, 86, 210, 26, 100, 24, 183, 7, 200, 139, 142, 226, 238, 228, 220, 14, 184, 48, 243, 225, 176, 133, 162, 81, 109, 34, 202, 240, 243, 133, 44, 88, 215, 91, 33, 12, 38, 131, 4, 72, 152, 237, 12, 137, 16, 102, 22, 104, 162, 133, 109, 229, 139, 150, 36, 194, 240, 173, 51, 73, 69, 197, 192, 201, 231, 27, 236, 218, 184, 104, 175, 95, 87, 185, 10, 114, 158, 169, 190, 221, 55, 18, 228, 243, 170, 177, 88, 173, 173, 52, 122, 87, 155, 0, 175, 146, 151, 135, 136, 135, 139, 165, 227, 192, 19, 120, 74, 144, 240, 192, 124, 8, 0, 132, 8, 128, 176, 4, 160, 97, 2, 80, 40, 192, 164, 2, 72, 22, 224, 67, 0, 8, 160, 113, 65, 85, 16, 161, 188, 243, 182, 76, 89, 141, 98, 229, 119, 30, 47, 4, 50, 201, 102, 214, 228, 43, 81, 100, 110, 83, 14, 25, 129, 152, 142, 163, 97, 190, 134, 249, 116, 152, 190, 40, 43, 197, 64, 166, 4, 66, 216, 20, 146, 166, 236, 179, 222, 16, 96, 240, 243, 48, 142, 53, 78, 141, 103, 30, 142, 17, 218, 11, 175, 197, 228, 174, 217, 105, 10, 246, 227, 45, 238, 16, 236, 57, 93, 179, 150, 14, 179, 253, 143, 253, 126, 199, 213, 233, 112, 226, 254, 149, 236, 86, 79, 215, 56, 189, 93, 131, 145, 97, 164, 191, 186, 181, 188, 21, 48, 99, 24, 108, 44, 171, 193, 125, 143, 43, 220, 243, 154, 26, 150, 98, 242, 44, 46, 74, 46, 117, 61, 87, 38, 251, 13, 51, 150, 110, 85, 101, 150, 90, 147, 59, 228, 22, 102, 119, 156, 172, 147, 202, 92, 144, 234, 170, 249, 139, 182, 73, 137, 39, 239, 242, 161, 1, 178, 27, 253, 10, 32, 117, 2, 2, 11, 188, 33, 48, 193, 135, 184, 193, 16, 64, 0, 202, 32, 194, 1, 144, 208, 198, 16, 136, 65, 24, 66, 34, 140, 49, 219, 220, 157, 97, 132, 113, 240, 4, 14, 213, 3, 197, 66, 24, 108, 192, 141, 237, 19, 184, 182, 153, 81, 199, 140, 255, 173, 39, 40, 141, 227, 174, 74, 203, 70, 73, 149, 93, 177, 34, 72, 123, 35, 243, 78, 54, 251, 137, 103, 39, 37, 37, 48, 155, 193, 9, 12, 145, 145, 184, 186, 32, 151, 68, 9, 8, 75, 2, 226, 217, 41, 103, 158, 241, 73, 80, 214, 183, 218, 98, 123, 69, 130, 191, 141, 124, 71, 17, 10, 13, 72, 21, 88, 209, 115, 196, 33, 4, 240, 142, 169, 100, 212, 180, 192, 248, 213, 78, 214, 214, 204, 140, 145, 225, 135, 94, 155, 227, 92, 32, 21, 78, 144, 215, 50, 107, 169, 122, 6, 67, 149, 228, 88, 67, 64, 142, 124, 102, 195, 14, 10, 10, 255, 210, 139, 230, 254, 207, 146, 212, 175, 87, 104, 4, 234, 119, 66, 120, 40, 130, 158, 176, 23, 187, 29, 195, 241, 229, 38, 42, 169, 38, 51, 38, 118, 60, 148, 172, 32, 124, 114, 49, 130, 85, 100, 115, 81, 35, 34, 19, 198, 105, 100, 131, 213, 180, 98, 197, 213, 41, 40, 71, 158, 81, 69, 14, 123, 242, 116, 25, 85, 106, 168, 136, 162, 130, 162, 138, 129, 110, 47, 203, 169, 26, 64, 205, 138, 91, 150, 154, 223, 129, 42, 248, 143, 154, 36, 41, 149, 141, 108, 126, 78, 247, 233, 233, 22, 99, 138, 43, 11, 128, 9, 103, 117, 224, 237, 138, 208, 247, 233, 229, 10, 202, 207, 146, 29, 65, 151, 197, 88, 66, 21, 3, 64, 100, 114, 235, 107, 115, 188, 90, 8, 180, 212, 85, 84, 196, 225, 58, 156, 205, 184, 126, 177, 142, 30, 74, 145, 136, 179, 61, 23, 91, 207, 76, 221, 4, 140, 63, 8, 84, 134, 7, 134, 87, 253, 121, 8, 41, 171, 108, 23, 205, 2, 219, 12, 200, 156, 58, 232, 168, 101, 56, 228, 128, 163, 232, 141, 227, 144, 83, 12, 48, 96, 243, 160, 118, 235, 42, 71, 57, 88, 26, 80, 15, 9, 7, 166, 134, 151, 15, 240, 119, 201, 0, 156, 10, 22, 201, 44, 162, 161, 174, 19, 235, 69, 14, 17, 53, 4, 140, 227, 58, 95, 66, 234, 57, 200, 95, 187, 73, 181, 56, 183, 136, 20, 234, 244, 85, 4, 85, 16, 60, 52, 57, 224, 6, 236, 235, 164, 96, 36, 142, 0, 28, 37, 163, 99, 142, 193, 85, 11, 93, 37, 150, 146, 68, 123, 172, 142, 36, 82, 35, 144, 56, 39, 190, 204, 134, 1, 112, 0, 128, 4, 128, 147, 139, 231, 79, 172, 8, 42, 134, 180, 28, 203, 107, 160, 131, 85, 188, 159, 163, 167, 169, 94, 56, 51, 235, 60, 253, 61, 125, 189, 248, 75, 216, 28, 189, 23, 128, 110, 166, 214, 38, 119, 160, 56, 22, 1, 21, 80, 237, 254, 27, 217, 119, 238, 241, 203, 205, 13, 251, 36, 132, 136, 146, 29, 90, 34, 27, 144, 212, 221, 137, 137, 44, 119, 219, 25, 34, 137, 115, 50, 138, 170, 106, 36, 58, 63, 223, 230, 122, 110, 195, 240, 241, 250, 78, 167, 231, 124, 173, 243, 126, 38, 146, 137, 168, 14, 127, 176, 249, 61, 183, 147, 56, 135, 197, 76, 121, 73, 33, 9, 33, 64, 146, 28, 144, 226, 64, 110, 94, 66, 170, 161, 136, 130, 162, 152, 168, 11, 109, 141, 65, 49, 73, 82, 28, 73, 113, 37, 153, 34, 10, 18, 204, 83, 37, 136, 76, 149, 201, 165, 154, 130, 10, 72, 13, 201, 164, 98, 33, 162, 50, 4, 44, 4, 144, 134, 160, 236, 1, 197, 182, 182, 217, 69, 36, 0, 137, 80, 18, 20, 44, 65, 165, 66, 10, 114, 226, 203, 82, 237, 96, 81, 40, 101, 24, 12, 136, 132, 131, 16, 50, 109, 192, 200, 38, 57, 58, 133, 49, 42, 24, 102, 130, 88, 66, 0, 108, 6, 26, 182, 229, 11, 145, 99, 24, 16, 67, 0, 61, 102, 215, 24, 55, 27, 52, 116, 10, 88, 137, 36, 136, 98, 18, 29, 236, 12, 42, 169, 145, 137, 89, 24, 68, 129, 144, 33, 33, 144, 132, 115, 181, 38, 164, 209, 75, 133, 144, 166, 38, 166, 171, 85, 17, 147, 145, 65, 25, 25, 82, 28, 44, 201, 96, 109, 62, 183, 101, 254, 189, 175, 200, 247, 29, 151, 89, 210, 118, 62, 131, 251, 255, 207, 243, 209, 244, 188, 138, 29, 160, 130, 38, 70, 100, 204, 20, 244, 223, 222, 183, 63, 87, 149, 224, 239, 185, 156, 222, 6, 174, 135, 91, 208, 213, 232, 104, 231, 103, 231, 232, 232, 235, 118, 188, 159, 55, 159, 78, 34, 160, 72, 210, 211, 113, 3, 160, 50, 144, 119, 229, 67, 198, 164, 168, 156, 188, 142, 160, 26, 144, 52, 73, 34, 92, 190, 24, 84, 161, 76, 75, 52, 20, 217, 212, 104, 187, 117, 65, 194, 4, 137, 100, 170, 15, 203, 197, 252, 93, 79, 87, 183, 159, 55, 163, 115, 152, 97, 16, 70, 225, 53, 104, 138, 152, 152, 136, 136, 146, 73, 130, 97, 168, 34, 72, 98, 136, 137, 160, 136, 183, 164, 112, 24, 21, 129, 151, 124, 133, 28, 164, 144, 41, 37, 32, 10, 104, 73, 33, 138, 197, 54, 1, 176, 204, 16, 161, 107, 39, 36, 215, 88, 227, 74, 82, 137, 144, 17, 197, 113, 3, 8, 98, 34, 16, 146, 34, 10, 10, 94, 205, 34, 26, 30, 24, 103, 1, 53, 130, 227, 96, 151, 33, 165, 160, 6, 12, 129, 146, 184, 81, 42, 67, 72, 192, 148, 178, 109, 196, 204, 197, 194, 98, 169, 138, 42, 151, 128, 193, 139, 24, 39, 26, 83, 3, 66, 98, 162, 130, 215, 14, 52, 80, 186, 37, 17, 92, 12, 49, 152, 138, 82, 70, 132, 154, 168, 152, 137, 150, 25, 129, 136, 225, 130, 61, 54, 26, 83, 5, 191, 134, 84, 181, 66, 153, 3, 146, 209, 178, 65, 196, 146, 41, 33, 2, 37, 91, 110, 3, 133, 48, 22, 96, 235, 35, 70, 164, 30, 30, 54, 100, 96, 100, 154, 8, 202, 105, 85, 11, 81, 4, 132, 38, 89, 24, 112, 82, 37, 24, 3, 19, 77, 119, 205, 22, 120, 67, 134, 161, 17, 3, 189, 131, 147, 17, 2, 76, 68, 140, 67, 36, 37, 13, 12, 18, 209, 4, 48, 74, 109, 156, 35, 118, 96, 98, 3, 65, 43, 168, 223, 53, 52, 203, 114, 244, 39, 11, 35, 112, 55, 51, 77, 137, 154, 94, 174, 10, 165, 53, 52, 49, 28, 184, 27, 11, 19, 126, 29, 98, 138, 170, 17, 38, 10, 114, 2, 69, 9, 26, 24, 179, 58, 178, 107, 138, 219, 25, 36, 149, 85, 70, 224, 58, 89, 171, 70, 102, 195, 106, 10, 208, 137, 79, 12, 25, 17, 194, 81, 36, 168, 74, 90, 77, 218, 0, 153, 164, 128, 110, 128, 194, 9, 145, 26, 13, 225, 13, 241, 26, 54, 169, 181, 55, 84, 131, 146, 89, 123, 186, 38, 110, 24, 10, 212, 6, 12, 16, 79, 241, 14, 17, 17, 16, 20, 72, 78, 246, 211, 179, 232, 96, 97, 131, 180, 204, 11, 42, 9, 84, 23, 80, 150, 222, 90, 238, 21, 158, 155, 47, 92, 209, 204, 71, 77, 117, 71, 115, 98, 49, 26, 52, 28, 147, 123, 1, 34, 16, 139, 148, 90, 173, 234, 180, 47, 118, 138, 187, 191, 212, 0, 254, 196, 25, 32, 95, 92, 42, 7, 5, 144, 37, 94, 11, 36, 194, 146, 33, 181, 128, 25, 155, 25, 120, 72, 163, 33, 179, 19, 117, 222, 222, 208, 37, 167, 48, 69, 100, 145, 40, 136, 117, 106, 136, 168, 120, 88, 174, 68, 196, 26, 152, 32, 225, 12, 46, 204, 68, 217, 5, 5, 58, 85, 67, 164, 6, 17, 144, 56, 213, 16, 146, 5, 107, 104, 92, 189, 118, 94, 186, 208, 134, 98, 102, 88, 201, 140, 56, 128, 99, 90, 145, 164, 173, 40, 170, 13, 32, 200, 128, 209, 147, 240, 66, 102, 134, 81, 172, 184, 68, 172, 233, 91, 139, 23, 58, 0, 160, 172, 89, 54, 73, 41, 144, 102, 41, 14, 21, 211, 112, 40, 129, 34, 45, 213, 55, 84, 212, 85, 131, 32, 196, 13, 34, 169, 136, 10, 7, 84, 128, 53, 42, 98, 8, 146, 145, 214, 106, 12, 76, 184, 133, 64, 105, 50, 37, 3, 113, 54, 33, 180, 66, 128, 20, 201, 110, 100, 166, 236, 42, 96, 28, 200, 106, 96, 40, 91, 136, 4, 34, 212, 82, 160, 169, 152, 26, 0, 96, 115, 29, 33, 9, 70, 66, 102, 68, 145, 144, 25, 63, 248, 187, 146, 41, 194, 132, 135, 236, 205, 138, 24 };

constexpr std::array<u8, 1365> SP_UNDERGROUND = { 194, 36, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 238, 40, 105, 110, 0, 10, 110, 127, 255, 255, 255, 255, 239, 126, 125, 121, 127, 223, 126, 239, 212, 222, 255, 221, 80, 205, 32, 237, 73, 189, 216, 236, 13, 186, 92, 42, 221, 98, 133, 100, 20, 224, 6, 94, 3, 224, 160, 17, 0, 168, 128, 1, 3, 38, 64, 196, 26, 105, 166, 4, 194, 50, 97, 13, 24, 0, 154, 52, 194, 6, 33, 132, 196, 104, 3, 35, 67, 2, 100, 96, 152, 77, 52, 105, 161, 161, 160, 209, 128, 16, 50, 100, 12, 65, 166, 154, 96, 76, 35, 38, 16, 209, 128, 9, 163, 76, 32, 98, 24, 76, 70, 128, 50, 52, 48, 38, 70, 9, 132, 211, 70, 154, 26, 26, 13, 24, 1, 3, 38, 64, 196, 26, 105, 166, 4, 194, 50, 97, 13, 24, 0, 154, 52, 194, 6, 33, 132, 196, 104, 3, 35, 67, 2, 100, 96, 152, 77, 52, 105, 161, 161, 160, 209, 128, 16, 50, 100, 12, 65, 166, 154, 96, 76, 35, 38, 16, 209, 128, 9, 163, 76, 32, 98, 24, 76, 70, 128, 50, 52, 48, 38, 70, 9, 132, 211, 70, 154, 26, 26, 13, 24, 0, 69, 36, 41, 166, 163, 70, 160, 245, 50, 98, 13, 30, 68, 205, 70, 76, 158, 128, 134, 131, 16, 52, 218, 38, 134, 155, 80, 194, 104, 26, 100, 122, 6, 147, 35, 196, 25, 76, 26, 154, 30, 167, 177, 41, 250, 163, 244, 201, 54, 148, 16, 164, 136, 34, 81, 136, 104, 253, 80, 209, 166, 128, 6, 128, 0, 26, 6, 131, 64, 0, 208, 0, 0, 52, 0, 0, 0, 0, 208, 0, 0, 128, 119, 137, 152, 253, 169, 237, 36, 234, 162, 87, 108, 134, 113, 120, 154, 180, 214, 121, 193, 4, 196, 23, 160, 95, 1, 174, 3, 94, 23, 240, 108, 215, 211, 93, 160, 89, 220, 181, 143, 93, 41, 27, 241, 166, 240, 112, 67, 227, 56, 207, 202, 124, 236, 199, 28, 38, 184, 57, 140, 115, 73, 200, 113, 49, 71, 33, 232, 159, 177, 221, 123, 199, 124, 239, 229, 16, 120, 10, 161, 170, 46, 51, 74, 237, 118, 121, 139, 13, 134, 127, 248, 177, 65, 157, 102, 130, 9, 17, 57, 124, 150, 156, 254, 25, 243, 47, 25, 62, 147, 146, 68, 18, 35, 238, 10, 8, 57, 192, 116, 204, 63, 215, 28, 49, 201, 140, 128, 201, 67, 47, 32, 168, 147, 21, 137, 224, 205, 180, 80, 78, 76, 65, 120, 119, 2, 217, 192, 32, 131, 138, 65, 242, 50, 209, 106, 21, 72, 43, 50, 226, 136, 40, 20, 129, 134, 22, 4, 178, 231, 98, 189, 119, 20, 148, 139, 70, 129, 20, 132, 20, 228, 148, 201, 32, 34, 66, 146, 32, 130, 72, 102, 133, 104, 16, 136, 68, 196, 6, 25, 130, 6, 2, 79, 188, 255, 97, 250, 137, 179, 188, 139, 48, 0, 17, 73, 2, 68, 68, 36, 146, 11, 65, 18, 173, 8, 157, 161, 224, 251, 76, 57, 42, 0, 27, 104, 237, 117, 168, 40, 13, 160, 247, 242, 104, 130, 237, 240, 28, 128, 164, 212, 152, 203, 255, 136, 56, 242, 217, 208, 158, 132, 128, 112, 138, 40, 78, 9, 33, 154, 193, 12, 88, 74, 100, 42, 36, 132, 132, 33, 24, 79, 209, 49, 131, 180, 25, 41, 108, 202, 63, 116, 164, 220, 180, 64, 17, 35, 61, 118, 11, 214, 116, 56, 50, 97, 128, 227, 44, 18, 196, 28, 15, 1, 105, 218, 35, 99, 3, 238, 23, 2, 225, 193, 220, 224, 91, 37, 132, 134, 48, 67, 132, 99, 19, 36, 71, 96, 99, 232, 35, 146, 238, 110, 193, 192, 249, 251, 26, 55, 95, 101, 253, 204, 115, 14, 46, 186, 39, 24, 130, 55, 214, 135, 72, 76, 44, 80, 106, 136, 192, 136, 10, 67, 189, 30, 116, 208, 232, 14, 153, 48, 55, 113, 48, 33, 41, 104, 34, 73, 100, 121, 156, 241, 29, 12, 164, 201, 216, 157, 177, 203, 93, 93, 93, 60, 67, 101, 152, 42, 58, 12, 30, 61, 55, 197, 52, 239, 17, 49, 17, 4, 193, 20, 67, 222, 122, 217, 162, 30, 189, 145, 236, 14, 191, 1, 223, 131, 142, 228, 243, 57, 24, 114, 39, 201, 7, 150, 78, 225, 249, 105, 221, 119, 212, 217, 72, 198, 63, 3, 28, 156, 156, 223, 39, 214, 111, 186, 231, 184, 25, 36, 138, 115, 154, 228, 238, 226, 27, 81, 230, 80, 92, 157, 199, 107, 148, 30, 3, 248, 38, 114, 220, 199, 251, 106, 183, 7, 4, 152, 211, 221, 147, 86, 76, 148, 198, 12, 176, 219, 4, 24, 102, 101, 87, 108, 201, 172, 243, 222, 81, 238, 165, 81, 192, 43, 6, 233, 205, 10, 237, 119, 0, 115, 131, 222, 76, 55, 5, 168, 27, 125, 223, 195, 128, 134, 77, 222, 36, 49, 53, 154, 210, 154, 8, 84, 210, 64, 7, 108, 126, 224, 131, 253, 167, 252, 118, 119, 147, 137, 1, 140, 12, 16, 61, 202, 97, 129, 44, 6, 165, 36, 128, 153, 5, 196, 40, 52, 198, 78, 96, 224, 105, 35, 25, 34, 137, 52, 154, 210, 68, 104, 131, 77, 173, 97, 135, 36, 209, 162, 50, 45, 26, 52, 75, 179, 182, 40, 243, 37, 118, 17, 238, 143, 232, 253, 148, 250, 14, 131, 252, 14, 226, 2, 119, 104, 9, 203, 149, 208, 69, 140, 193, 72, 157, 4, 148, 51, 17, 37, 38, 152, 12, 55, 49, 52, 66, 59, 37, 210, 146, 20, 14, 243, 27, 198, 230, 156, 115, 12, 8, 160, 56, 1, 27, 164, 156, 24, 34, 30, 12, 196, 246, 42, 162, 121, 158, 212, 242, 154, 123, 151, 187, 8, 168, 17, 96, 44, 141, 167, 178, 16, 124, 73, 158, 115, 127, 30, 212, 143, 9, 44, 48, 52, 165, 176, 183, 227, 237, 248, 151, 156, 173, 18, 142, 204, 142, 6, 219, 240, 58, 179, 183, 118, 206, 7, 35, 145, 158, 152, 226, 118, 66, 135, 129, 123, 52, 66, 16, 68, 166, 96, 157, 83, 127, 160, 70, 125, 1, 132, 151, 162, 37, 49, 66, 156, 254, 27, 137, 21, 9, 218, 17, 8, 154, 238, 36, 147, 43, 20, 175, 166, 216, 235, 240, 172, 236, 111, 237, 122, 87, 87, 73, 192, 0, 0, 35, 242, 56, 249, 180, 26, 49, 66, 216, 208, 185, 212, 104, 89, 251, 47, 0, 186, 135, 72, 105, 32, 132, 186, 21, 91, 98, 134, 138, 33, 58, 179, 249, 11, 2, 202, 20, 239, 97, 225, 70, 36, 132, 146, 80, 34, 16, 136, 8, 25, 128, 150, 98, 88, 102, 33, 165, 169, 146, 98, 98, 8, 105, 130, 102, 73, 25, 8, 72, 150, 36, 86, 72, 86, 8, 130, 8, 101, 129, 150, 97, 165, 8, 132, 36, 8, 34, 8, 128, 165, 150, 66, 108, 118, 234, 192, 114, 19, 104, 51, 88, 185, 152, 9, 156, 144, 83, 144, 170, 232, 13, 200, 30, 64, 130, 111, 195, 65, 201, 4, 25, 53, 172, 4, 223, 190, 103, 51, 184, 234, 234, 229, 184, 175, 52, 61, 81, 134, 10, 115, 112, 28, 128, 23, 17, 145, 137, 33, 18, 32, 138, 76, 0, 14, 60, 247, 50, 57, 153, 141, 143, 44, 236, 139, 109, 243, 86, 170, 42, 170, 55, 44, 224, 101, 144, 90, 197, 41, 219, 158, 27, 73, 114, 20, 53, 42, 93, 56, 13, 152, 42, 116, 66, 27, 155, 220, 78, 58, 229, 177, 155, 235, 115, 125, 221, 185, 146, 32, 113, 213, 148, 240, 58, 238, 91, 237, 57, 199, 90, 76, 214, 157, 92, 32, 67, 145, 142, 0, 102, 22, 40, 28, 141, 24, 136, 198, 214, 76, 40, 180, 208, 172, 205, 214, 204, 186, 219, 98, 161, 162, 22, 36, 120, 70, 16, 165, 39, 73, 129, 136, 127, 241, 119, 36, 83, 133, 9, 14, 226, 134, 150, 224 };

