#include <Core/Gen5/DreamRadarTemplate.hpp>
#include <Core/Parents/StaticTemplate.hpp>
#include <array>

constexpr std::array<DreamRadarTemplate, 26> DREAMRADAR = { DreamRadarTemplate(79, 0, 2), DreamRadarTemplate(120, 0, 2), DreamRadarTemplate(137, 0, 2), DreamRadarTemplate(163, 0, 2), DreamRadarTemplate(174, 0, 2), DreamRadarTemplate(175, 0, 2), DreamRadarTemplate(213, 0, 2), DreamRadarTemplate(238, 0, 2), DreamRadarTemplate(249, 0, 2), DreamRadarTemplate(250, 0, 2), DreamRadarTemplate(280, 0, 2), DreamRadarTemplate(333, 0, 2), DreamRadarTemplate(374, 0, 2), DreamRadarTemplate(425, 0, 2), DreamRadarTemplate(436, 0, 2), DreamRadarTemplate(442, 0, 2), DreamRadarTemplate(447, 0, 2), DreamRadarTemplate(479, 0, 255), DreamRadarTemplate(483, 0, 2), DreamRadarTemplate(484, 0, 2), DreamRadarTemplate(487, 0, 2), DreamRadarTemplate(517, 0, 2), DreamRadarTemplate(561, 0, 2), DreamRadarTemplate(641, 1, 2), DreamRadarTemplate(642, 1, 2), DreamRadarTemplate(645, 1, 2) };

constexpr std::array<StaticTemplate, 3> STARTERS = { StaticTemplate(Game::Gen5, 495, 0, Shiny::Random, 255, 255, 0, 5), StaticTemplate(Game::Gen5, 498, 0, Shiny::Random, 255, 255, 0, 5), StaticTemplate(Game::Gen5, 501, 0, Shiny::Random, 255, 255, 0, 5) };

constexpr std::array<StaticTemplate, 9> FOSSILS = { StaticTemplate(Game::Gen5, 138, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate(Game::Gen5, 140, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate(Game::Gen5, 142, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate(Game::Gen5, 345, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate(Game::Gen5, 347, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate(Game::Gen5, 408, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate(Game::Gen5, 410, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate(Game::Gen5, 564, 0, Shiny::Random, 255, 255, 0, 25), StaticTemplate(Game::Gen5, 566, 0, Shiny::Random, 255, 255, 0, 25) };

constexpr std::array<StaticTemplate, 10> GIFTS = { StaticTemplate(Game::BW, 511, 0, Shiny::Random, 255, 255, 0, 10), StaticTemplate(Game::BW, 513, 0, Shiny::Random, 255, 255, 0, 10), StaticTemplate(Game::BW, 515, 0, Shiny::Random, 255, 255, 0, 10), StaticTemplate(Game::BW, 636, 0, Shiny::Random, 255, 255, 0, 1), StaticTemplate(Game::BW2, 133, 0, Shiny::Random, 2, 255, 0, 10), StaticTemplate(Game::BW2, 585, 0, Shiny::Random, 2, 255, 0, 30), StaticTemplate(Game::Black2, 443, 0, Shiny::Always, 2, 0, 0, 1), StaticTemplate(Game::Black2, 147, 0, Shiny::Always, 2, 0, 0, 1), StaticTemplate(Game::BW2, 440, 0, Shiny::Random, 255, 255, 0, 1), StaticTemplate(Game::Gen5, 129, 0, Shiny::Random, 255, 255, 0, 5) };

constexpr std::array<StaticTemplate, 18> STATIONARY = { StaticTemplate(Game::BW, 518, 0, Shiny::Random, 2, 255, 0, 50), StaticTemplate(Game::BW, 590, 0, Shiny::Random, 255, 255, 0, 20), StaticTemplate(Game::BW, 590, 0, Shiny::Random, 255, 255, 0, 30), StaticTemplate(Game::BW, 591, 0, Shiny::Random, 255, 255, 0, 40), StaticTemplate(Game::BW, 555, 0, Shiny::Random, 2, 255, 0, 35), StaticTemplate(Game::BW, 637, 0, Shiny::Random, 255, 255, 0, 70), StaticTemplate(Game::BW2, 590, 0, Shiny::Random, 255, 255, 0, 29), StaticTemplate(Game::BW2, 591, 0, Shiny::Random, 255, 255, 0, 43), StaticTemplate(Game::BW2, 591, 0, Shiny::Random, 255, 255, 0, 47), StaticTemplate(Game::BW2, 591, 0, Shiny::Random, 255, 255, 0, 56), StaticTemplate(Game::Black2, 593, 0, Shiny::Random, 2, 0, 0, 40), StaticTemplate(Game::White2, 593, 0, Shiny::Random, 2, 1, 0, 40), StaticTemplate(Game::White2, 628, 0, Shiny::Random, 2, 0, 0, 25), StaticTemplate(Game::Black2, 630, 0, Shiny::Random, 2, 1, 0, 25), StaticTemplate(Game::BW2, 637, 0, Shiny::Random, 255, 255, 0, 35), StaticTemplate(Game::BW2, 637, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::BW2, 558, 0, Shiny::Random, 255, 255, 0, 42), StaticTemplate(Game::BW2, 612, 0, Shiny::Always, 255, 255, 0, 60) };

constexpr std::array<StaticTemplate, 27> LEGENDS = { StaticTemplate(Game::BW, 638, 0, Shiny::Random, 255, 255, 0, 42), StaticTemplate(Game::BW, 639, 0, Shiny::Random, 255, 255, 0, 42), StaticTemplate(Game::BW, 640, 0, Shiny::Random, 255, 255, 0, 42), StaticTemplate(Game::Black, 643, 0, Shiny::Never, 255, 255, 0, 50), StaticTemplate(Game::White, 644, 0, Shiny::Never, 255, 255, 0, 50), StaticTemplate(Game::BW, 645, 0, Shiny::Random, 255, 255, 0, 70), StaticTemplate(Game::BW, 646, 0, Shiny::Random, 255, 255, 0, 75), StaticTemplate(Game::BW2, 377, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::BW2, 378, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::BW2, 379, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::White2, 380, 0, Shiny::Random, 255, 255, 0, 68), StaticTemplate(Game::Black2, 381, 0, Shiny::Random, 255, 255, 0, 68), StaticTemplate(Game::BW2, 480, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::BW2, 481, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::BW2, 482, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::BW2, 485, 0, Shiny::Random, 255, 255, 0, 68), StaticTemplate(Game::BW2, 486, 0, Shiny::Random, 255, 255, 0, 68), StaticTemplate(Game::BW2, 488, 0, Shiny::Random, 255, 255, 0, 68), StaticTemplate(Game::BW2, 638, 0, Shiny::Random, 255, 255, 0, 45), StaticTemplate(Game::BW2, 638, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::BW2, 639, 0, Shiny::Random, 255, 255, 0, 45), StaticTemplate(Game::BW2, 639, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::BW2, 640, 0, Shiny::Random, 255, 255, 0, 45), StaticTemplate(Game::BW2, 640, 0, Shiny::Random, 255, 255, 0, 65), StaticTemplate(Game::White2, 643, 0, Shiny::Never, 255, 255, 0, 70), StaticTemplate(Game::Black2, 644, 0, Shiny::Never, 255, 255, 0, 70), StaticTemplate(Game::BW2, 646, 0, Shiny::Random, 255, 255, 0, 70) };

constexpr std::array<StaticTemplate, 3> EVENTS = { StaticTemplate(Game::BW, 494, 0, Shiny::Never, 255, 255, 0, 15), StaticTemplate(Game::BW, 570, 0, Shiny::Never, 255, 0, 0, 10), StaticTemplate(Game::BW, 571, 0, Shiny::Never, 255, 1, 0, 25) };

constexpr std::array<StaticTemplate, 2> ROAMERS = { StaticTemplate(Game::Black, 641, 0, Shiny::Random, 255, 255, 0, 40), StaticTemplate(Game::White, 642, 0, Shiny::Random, 255, 255, 0, 40) };

constexpr std::array<u8, 3631> BLACK = { 82, 110, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 78, 148, 83, 242, 0, 1, 108, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 140, 2, 94, 0, 223, 123, 2, 16, 193, 241, 171, 227, 245, 16, 0, 255, 224, 17, 95, 10, 0, 171, 187, 184, 166, 187, 114, 189, 77, 185, 107, 199, 183, 125, 174, 223, 47, 10, 128, 68, 7, 74, 4, 169, 74, 137, 72, 0, 161, 21, 72, 37, 20, 81, 154, 17, 60, 83, 38, 211, 81, 225, 25, 52, 79, 10, 104, 109, 19, 76, 158, 167, 137, 52, 0, 26, 13, 0, 0, 0, 0, 0, 3, 70, 131, 38, 35, 70, 154, 30, 160, 6, 129, 144, 0, 74, 42, 99, 212, 79, 76, 69, 60, 153, 70, 147, 79, 74, 1, 163, 71, 148, 122, 155, 83, 70, 64, 0, 208, 0, 0, 0, 6, 152, 140, 152, 154, 105, 144, 208, 52, 0, 0, 0, 0, 0, 122, 128, 52, 70, 154, 10, 104, 144, 211, 212, 104, 104, 0, 0, 209, 144, 26, 52, 3, 64, 0, 0, 12, 131, 70, 128, 0, 3, 32, 26, 0, 0, 0, 0, 0, 0, 16, 164, 137, 50, 154, 34, 104, 0, 13, 0, 0, 0, 245, 6, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 131, 69, 34, 0, 13, 6, 64, 0, 0, 0, 0, 208, 0, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 42, 72, 130, 0, 154, 76, 154, 104, 105, 52, 211, 17, 233, 162, 167, 228, 36, 61, 67, 212, 6, 67, 64, 105, 166, 64, 61, 71, 168, 6, 128, 245, 15, 213, 0, 1, 160, 0, 0, 208, 52, 0, 104, 6, 128, 82, 36, 185, 52, 109, 118, 167, 160, 79, 64, 169, 234, 15, 20, 158, 172, 245, 189, 158, 25, 120, 102, 187, 19, 151, 177, 132, 240, 79, 71, 116, 200, 195, 107, 109, 20, 155, 61, 142, 253, 182, 250, 90, 38, 191, 83, 23, 137, 76, 123, 219, 33, 204, 194, 145, 132, 234, 187, 6, 237, 61, 52, 207, 178, 137, 41, 234, 203, 68, 169, 209, 123, 200, 66, 149, 36, 147, 154, 29, 187, 68, 34, 210, 209, 10, 179, 30, 111, 79, 24, 238, 178, 202, 16, 199, 27, 33, 232, 225, 235, 251, 167, 66, 236, 59, 227, 42, 177, 136, 165, 107, 164, 119, 34, 150, 35, 244, 146, 192, 169, 84, 146, 146, 177, 31, 163, 241, 28, 165, 90, 4, 4, 175, 74, 231, 196, 196, 121, 72, 154, 83, 50, 119, 121, 249, 249, 220, 238, 126, 126, 51, 140, 224, 121, 78, 179, 67, 65, 155, 67, 116, 209, 33, 226, 40, 82, 77, 229, 138, 26, 147, 210, 79, 50, 83, 213, 147, 193, 38, 222, 63, 31, 55, 179, 126, 14, 7, 19, 129, 190, 113, 27, 202, 20, 78, 41, 114, 196, 162, 141, 201, 196, 164, 245, 228, 226, 37, 73, 242, 9, 55, 205, 166, 211, 105, 181, 29, 196, 228, 78, 228, 230, 146, 84, 222, 144, 226, 72, 112, 144, 225, 36, 145, 82, 29, 112, 227, 14, 57, 39, 26, 73, 66, 146, 164, 164, 56, 228, 227, 144, 84, 157, 241, 214, 29, 195, 149, 20, 82, 61, 151, 51, 208, 115, 199, 119, 204, 233, 117, 67, 213, 121, 147, 199, 175, 163, 190, 119, 207, 68, 239, 41, 61, 127, 73, 147, 189, 227, 241, 149, 88, 151, 158, 233, 224, 242, 75, 81, 213, 228, 82, 149, 225, 45, 30, 69, 25, 163, 196, 81, 228, 58, 141, 71, 106, 142, 166, 144, 169, 74, 149, 58, 98, 188, 72, 234, 170, 241, 82, 71, 147, 81, 37, 37, 41, 81, 210, 181, 143, 89, 53, 189, 97, 24, 74, 213, 146, 4, 144, 9, 36, 80, 84, 21, 17, 21, 75, 107, 83, 52, 76, 179, 105, 166, 237, 69, 34, 16, 97, 192, 130, 225, 230, 116, 19, 182, 23, 213, 135, 91, 103, 131, 103, 129, 86, 246, 60, 56, 124, 140, 61, 24, 119, 33, 220, 133, 67, 67, 186, 130, 14, 154, 115, 70, 57, 28, 55, 33, 185, 88, 98, 138, 85, 217, 89, 12, 20, 144, 34, 88, 190, 101, 227, 183, 143, 36, 72, 133, 12, 144, 170, 132, 138, 160, 120, 0, 16, 52, 1, 41, 61, 21, 207, 101, 202, 103, 134, 74, 16, 152, 196, 32, 81, 161, 116, 190, 222, 242, 17, 17, 20, 80, 79, 97, 85, 107, 13, 6, 157, 225, 144, 53, 69, 1, 154, 165, 85, 62, 252, 59, 5, 198, 151, 165, 241, 48, 11, 129, 198, 126, 127, 13, 162, 185, 53, 141, 26, 203, 150, 226, 122, 103, 14, 231, 14, 55, 27, 140, 224, 227, 58, 94, 196, 19, 108, 245, 30, 119, 221, 122, 25, 125, 36, 254, 31, 139, 207, 88, 237, 175, 132, 215, 229, 40, 160, 180, 227, 106, 154, 252, 190, 89, 88, 72, 181, 84, 245, 99, 3, 45, 122, 76, 109, 235, 179, 233, 45, 179, 204, 106, 30, 24, 118, 55, 95, 30, 126, 211, 199, 214, 121, 24, 34, 163, 100, 202, 195, 35, 124, 43, 34, 149, 152, 69, 45, 19, 231, 190, 175, 187, 251, 107, 50, 165, 135, 169, 8, 28, 152, 142, 134, 156, 203, 128, 94, 196, 60, 224, 237, 228, 183, 50, 199, 164, 185, 18, 45, 11, 2, 211, 31, 13, 96, 182, 191, 96, 98, 89, 17, 178, 103, 166, 55, 116, 94, 240, 56, 229, 26, 33, 120, 38, 8, 246, 228, 93, 35, 242, 255, 210, 63, 27, 226, 221, 120, 167, 237, 75, 232, 67, 226, 13, 38, 56, 204, 227, 160, 237, 22, 6, 119, 45, 157, 147, 9, 89, 32, 74, 159, 108, 217, 252, 122, 50, 116, 233, 211, 178, 175, 101, 77, 155, 60, 117, 58, 160, 38, 83, 20, 243, 219, 57, 122, 82, 41, 80, 102, 93, 153, 134, 217, 33, 185, 46, 196, 96, 96, 209, 23, 2, 220, 16, 96, 74, 148, 125, 107, 214, 189, 16, 146, 36, 128, 96, 184, 8, 249, 69, 67, 242, 79, 109, 44, 12, 163, 98, 103, 242, 151, 151, 140, 12, 92, 94, 105, 232, 108, 169, 52, 121, 205, 24, 145, 152, 161, 227, 199, 189, 5, 229, 139, 82, 102, 105, 5, 123, 143, 112, 56, 28, 56, 23, 91, 114, 171, 164, 209, 79, 124, 62, 14, 153, 8, 60, 152, 168, 200, 98, 135, 117, 112, 163, 51, 136, 193, 224, 32, 130, 21, 160, 44, 128, 125, 156, 226, 180, 47, 191, 178, 119, 192, 176, 64, 68, 200, 57, 92, 230, 2, 70, 176, 194, 49, 132, 41, 9, 216, 38, 79, 164, 44, 53, 198, 180, 47, 213, 153, 217, 217, 198, 159, 102, 12, 195, 51, 12, 192, 204, 51, 48, 204, 101, 147, 44, 178, 100, 202, 116, 244, 213, 85, 82, 158, 162, 124, 147, 193, 168, 105, 51, 26, 55, 51, 30, 3, 192, 100, 119, 206, 159, 125, 244, 196, 147, 63, 111, 171, 219, 220, 114, 14, 67, 81, 212, 29, 71, 17, 215, 162, 148, 198, 85, 13, 8, 87, 87, 87, 95, 98, 107, 143, 4, 194, 206, 28, 97, 48, 153, 132, 169, 224, 74, 155, 201, 6, 217, 74, 79, 179, 203, 12, 220, 194, 157, 169, 122, 181, 74, 151, 157, 142, 142, 38, 199, 46, 216, 172, 163, 57, 217, 181, 104, 84, 163, 182, 140, 114, 115, 110, 105, 219, 143, 33, 154, 57, 86, 79, 43, 88, 97, 23, 35, 157, 236, 3, 61, 147, 151, 70, 235, 58, 55, 67, 128, 29, 4, 80, 209, 55, 103, 203, 159, 101, 189, 131, 137, 131, 65, 188, 212, 90, 13, 80, 237, 67, 180, 134, 155, 168, 109, 84, 236, 6, 196, 58, 152, 97, 215, 90, 157, 165, 59, 113, 61, 41, 153, 237, 90, 3, 166, 7, 87, 206, 189, 87, 63, 58, 244, 70, 128, 228, 241, 30, 142, 173, 232, 221, 209, 69, 116, 44, 179, 122, 138, 184, 123, 132, 184, 41, 43, 51, 202, 203, 174, 129, 49, 150, 64, 140, 227, 237, 32, 150, 197, 87, 87, 179, 50, 120, 229, 47, 90, 95, 155, 98, 201, 120, 48, 74, 74, 83, 132, 153, 39, 208, 89, 45, 131, 5, 142, 89, 203, 58, 56, 183, 239, 219, 186, 145, 65, 10, 49, 163, 38, 210, 164, 226, 97, 145, 153, 210, 204, 108, 52, 97, 132, 1, 129, 141, 11, 2, 4, 231, 24, 69, 15, 132, 8, 56, 42, 176, 40, 84, 104, 10, 231, 6, 128, 176, 83, 123, 220, 4, 230, 177, 219, 84, 188, 172, 101, 81, 62, 245, 20, 161, 67, 118, 22, 97, 161, 181, 205, 231, 243, 253, 217, 231, 243, 249, 242, 243, 251, 159, 128, 174, 163, 211, 233, 50, 163, 168, 234, 179, 3, 197, 233, 250, 134, 245, 9, 3, 91, 128, 150, 156, 194, 219, 104, 66, 219, 45, 60, 90, 52, 180, 180, 142, 67, 21, 247, 93, 117, 215, 93, 112, 113, 231, 26, 60, 98, 65, 214, 228, 236, 245, 157, 158, 73, 239, 28, 174, 70, 182, 183, 79, 194, 198, 167, 164, 70, 180, 169, 106, 44, 168, 149, 84, 81, 52, 42, 149, 65, 140, 58, 191, 53, 215, 106, 153, 186, 32, 13, 125, 255, 60, 55, 68, 90, 87, 213, 15, 33, 95, 234, 175, 243, 238, 250, 215, 151, 219, 45, 95, 139, 7, 57, 111, 216, 206, 79, 157, 153, 180, 212, 79, 157, 111, 109, 219, 187, 187, 173, 190, 231, 119, 175, 35, 199, 174, 72, 232, 168, 162, 136, 40, 163, 40, 50, 135, 240, 86, 40, 180, 122, 22, 104, 148, 83, 73, 202, 240, 50, 210, 180, 36, 223, 6, 7, 162, 239, 209, 129, 230, 212, 220, 225, 238, 245, 157, 203, 170, 20, 47, 104, 80, 195, 232, 84, 149, 48, 21, 133, 84, 97, 129, 250, 1, 212, 58, 135, 254, 35, 168, 97, 134, 209, 135, 80, 34, 74, 66, 138, 160, 216, 135, 42, 161, 123, 44, 162, 152, 96, 97, 129, 241, 173, 216, 250, 183, 198, 254, 199, 249, 106, 207, 253, 171, 203, 193, 229, 102, 229, 114, 227, 241, 254, 121, 239, 16, 156, 243, 78, 215, 236, 69, 77, 21, 66, 75, 127, 202, 231, 119, 250, 73, 46, 164, 32, 146, 145, 44, 44, 114, 25, 69, 133, 14, 63, 129, 225, 216, 0, 67, 31, 80, 205, 74, 210, 68, 106, 73, 248, 236, 64, 47, 176, 100, 47, 129, 152, 18, 64, 65, 128, 64, 112, 2, 246, 22, 104, 137, 120, 127, 234, 85, 58, 60, 47, 75, 195, 224, 238, 119, 28, 142, 219, 163, 14, 142, 102, 158, 243, 191, 91, 112, 203, 42, 212, 213, 165, 169, 143, 132, 38, 18, 165, 2, 100, 18, 166, 99, 36, 160, 23, 210, 4, 30, 67, 81, 154, 234, 68, 17, 40, 80, 95, 0, 17, 194, 126, 130, 64, 144, 82, 72, 193, 27, 159, 239, 220, 104, 28, 140, 242, 3, 201, 23, 227, 158, 232, 249, 194, 255, 152, 77, 254, 7, 185, 208, 100, 25, 132, 123, 119, 199, 127, 193, 139, 47, 123, 102, 108, 243, 51, 51, 50, 201, 24, 188, 185, 219, 54, 108, 204, 152, 124, 60, 89, 103, 131, 67, 192, 120, 32, 215, 131, 225, 180, 42, 6, 164, 19, 145, 202, 229, 210, 35, 120, 241, 14, 58, 184, 202, 65, 4, 4, 157, 99, 102, 238, 112, 4, 42, 0, 33, 24, 66, 19, 79, 140, 171, 102, 152, 173, 25, 33, 40, 56, 57, 95, 3, 6, 16, 149, 163, 126, 133, 180, 27, 33, 129, 25, 185, 55, 91, 224, 57, 45, 53, 254, 134, 223, 209, 219, 220, 110, 111, 127, 202, 219, 156, 79, 111, 101, 183, 115, 163, 198, 121, 10, 20, 111, 100, 39, 175, 189, 182, 178, 1, 2, 6, 170, 241, 197, 132, 252, 4, 218, 18, 138, 42, 35, 211, 202, 205, 141, 105, 228, 146, 56, 117, 66, 68, 129, 80, 240, 82, 67, 187, 43, 175, 82, 216, 240, 113, 56, 181, 150, 198, 121, 51, 199, 156, 244, 202, 170, 170, 178, 134, 48, 157, 30, 151, 147, 69, 56, 161, 39, 7, 147, 149, 85, 60, 72, 145, 31, 77, 90, 155, 229, 57, 84, 159, 17, 69, 169, 90, 99, 70, 75, 4, 140, 69, 196, 12, 128, 213, 90, 102, 164, 170, 139, 138, 118, 8, 144, 66, 248, 160, 200, 229, 69, 242, 18, 195, 32, 142, 152, 235, 206, 52, 220, 106, 190, 153, 239, 48, 57, 180, 234, 87, 44, 183, 220, 159, 51, 82, 152, 238, 252, 214, 59, 103, 195, 149, 34, 75, 152, 20, 132, 246, 94, 170, 170, 171, 82, 52, 105, 138, 42, 60, 138, 17, 21, 98, 224, 162, 74, 209, 201, 94, 146, 40, 250, 82, 80, 177, 209, 44, 123, 211, 145, 33, 214, 24, 19, 171, 79, 38, 248, 217, 81, 74, 212, 118, 230, 139, 224, 222, 151, 77, 134, 67, 84, 214, 144, 196, 199, 68, 164, 48, 14, 30, 108, 120, 147, 131, 100, 155, 20, 214, 112, 50, 177, 198, 88, 224, 185, 129, 83, 207, 44, 54, 19, 122, 67, 116, 143, 133, 12, 246, 190, 161, 74, 82, 156, 116, 196, 102, 133, 205, 68, 253, 40, 114, 124, 25, 238, 252, 119, 242, 249, 105, 89, 147, 132, 226, 144, 235, 77, 201, 116, 216, 109, 59, 66, 133, 12, 164, 146, 55, 206, 232, 175, 98, 137, 214, 111, 236, 246, 171, 241, 125, 223, 52, 232, 104, 211, 181, 56, 112, 118, 33, 207, 15, 114, 29, 141, 60, 233, 217, 85, 113, 246, 205, 175, 251, 111, 157, 142, 190, 16, 215, 13, 144, 208, 241, 104, 222, 223, 13, 237, 105, 190, 111, 76, 83, 124, 90, 186, 214, 158, 140, 221, 182, 23, 198, 165, 201, 192, 172, 101, 37, 74, 68, 198, 23, 188, 191, 95, 110, 144, 226, 82, 82, 2, 5, 132, 200, 20, 170, 42, 173, 42, 95, 12, 65, 0, 176, 233, 95, 112, 169, 36, 169, 192, 219, 180, 217, 88, 116, 200, 161, 193, 233, 206, 255, 227, 33, 50, 45, 206, 48, 17, 35, 60, 209, 198, 155, 194, 145, 198, 11, 147, 145, 4, 50, 2, 34, 112, 132, 65, 227, 140, 187, 92, 64, 178, 41, 4, 130, 76, 150, 12, 60, 120, 254, 232, 15, 236, 2, 132, 194, 75, 19, 133, 230, 216, 125, 107, 164, 89, 56, 124, 30, 47, 2, 110, 79, 136, 222, 31, 93, 175, 172, 209, 215, 213, 171, 94, 196, 212, 215, 13, 137, 73, 177, 36, 207, 100, 217, 175, 68, 156, 237, 122, 90, 197, 73, 130, 107, 107, 98, 186, 93, 173, 52, 99, 33, 100, 137, 169, 77, 45, 63, 133, 150, 157, 50, 104, 57, 201, 251, 98, 80, 155, 36, 188, 154, 146, 113, 25, 181, 73, 162, 38, 18, 98, 146, 164, 22, 237, 34, 195, 176, 57, 127, 37, 140, 184, 213, 49, 29, 225, 113, 239, 243, 215, 161, 199, 207, 245, 63, 53, 143, 161, 163, 134, 193, 172, 107, 214, 225, 175, 216, 223, 167, 78, 90, 89, 105, 241, 220, 139, 35, 231, 234, 22, 81, 134, 189, 187, 244, 69, 91, 118, 82, 173, 218, 187, 189, 82, 114, 146, 57, 137, 82, 53, 159, 199, 203, 171, 150, 250, 248, 100, 246, 185, 121, 112, 194, 49, 209, 157, 234, 215, 183, 181, 176, 158, 248, 63, 16, 253, 130, 139, 69, 16, 135, 162, 35, 167, 232, 211, 6, 66, 104, 2, 87, 167, 176, 154, 83, 127, 53, 195, 189, 247, 222, 30, 51, 171, 251, 31, 3, 218, 247, 50, 108, 159, 249, 190, 45, 81, 210, 31, 71, 18, 165, 42, 146, 40, 40, 40, 169, 46, 198, 156, 88, 173, 121, 42, 111, 184, 90, 172, 156, 102, 44, 24, 213, 37, 58, 241, 63, 250, 144, 205, 93, 50, 53, 84, 3, 38, 242, 240, 244, 6, 13, 156, 93, 39, 26, 72, 227, 204, 41, 107, 201, 41, 97, 221, 73, 58, 240, 162, 42, 124, 163, 202, 71, 191, 12, 18, 74, 42, 33, 98, 197, 86, 105, 157, 9, 74, 169, 163, 64, 94, 73, 68, 162, 74, 151, 146, 84, 146, 69, 42, 90, 20, 171, 84, 69, 171, 121, 133, 228, 146, 75, 136, 215, 182, 116, 137, 212, 69, 18, 80, 74, 18, 137, 70, 16, 155, 153, 36, 84, 168, 21, 33, 80, 68, 177, 97, 96, 84, 149, 16, 40, 162, 69, 84, 141, 196, 220, 193, 11, 163, 10, 146, 36, 170, 65, 82, 162, 68, 107, 185, 27, 235, 69, 16, 26, 44, 2, 3, 211, 164, 66, 146, 4, 206, 226, 110, 38, 0, 111, 46, 224, 4, 137, 146, 134, 16, 198, 24, 174, 253, 111, 116, 215, 83, 132, 28, 52, 188, 50, 202, 241, 133, 69, 40, 74, 113, 161, 89, 194, 233, 38, 89, 101, 116, 97, 18, 41, 32, 238, 194, 61, 96, 12, 131, 243, 196, 79, 12, 55, 143, 12, 177, 48, 34, 130, 42, 149, 69, 40, 164, 188, 76, 106, 70, 157, 58, 111, 33, 123, 222, 250, 97, 188, 155, 203, 195, 50, 161, 51, 207, 60, 24, 68, 51, 36, 168, 145, 45, 101, 152, 227, 142, 38, 8, 83, 16, 192, 21, 198, 72, 97, 2, 192, 76, 69, 76, 149, 40, 20, 223, 28, 87, 75, 222, 248, 114, 100, 140, 72, 200, 140, 40, 146, 138, 34, 21, 80, 149, 81, 11, 101, 96, 189, 24, 37, 64, 181, 69, 20, 140, 48, 181, 173, 146, 241, 38, 13, 204, 17, 76, 132, 128, 132, 74, 136, 74, 6, 36, 119, 223, 115, 70, 202, 165, 76, 80, 168, 150, 165, 90, 90, 37, 69, 4, 106, 19, 80, 154, 214, 20, 197, 113, 48, 51, 22, 48, 1, 129, 192, 12, 6, 25, 137, 198, 6, 7, 28, 164, 12, 2, 67, 24, 6, 48, 100, 48, 3, 3, 0, 198, 89, 48, 113, 49, 49, 49, 52, 59, 132, 27, 146, 241, 227, 196, 210, 131, 181, 42, 132, 148, 168, 198, 169, 68, 177, 235, 5, 40, 81, 144, 81, 180, 41, 206, 41, 189, 10, 170, 82, 148, 199, 144, 74, 73, 50, 35, 34, 50, 70, 235, 186, 164, 149, 204, 136, 243, 18, 156, 72, 87, 19, 210, 178, 56, 10, 145, 80, 111, 189, 226, 170, 92, 77, 33, 68, 40, 169, 36, 117, 234, 73, 37, 210, 85, 173, 10, 165, 110, 22, 21, 106, 69, 160, 151, 69, 128, 180, 95, 60, 2, 211, 153, 145, 98, 76, 5, 148, 65, 77, 2, 234, 200, 180, 11, 149, 152, 212, 99, 6, 100, 96, 88, 230, 17, 131, 154, 205, 22, 128, 36, 8, 49, 204, 195, 37, 195, 6, 192, 51, 45, 90, 211, 134, 101, 82, 38, 74, 86, 97, 142, 81, 102, 24, 25, 12, 97, 78, 52, 146, 148, 96, 228, 20, 99, 142, 24, 102, 49, 4, 85, 130, 39, 97, 193, 221, 184, 9, 156, 116, 39, 2, 51, 12, 225, 173, 105, 236, 91, 106, 116, 5, 54, 92, 100, 212, 14, 131, 28, 48, 2, 72, 102, 8, 44, 83, 51, 0, 9, 73, 75, 24, 24, 16, 193, 135, 35, 42, 6, 128, 128, 130, 98, 193, 132, 32, 145, 192, 128, 212, 6, 137, 213, 21, 5, 58, 131, 52, 101, 148, 99, 22, 24, 22, 102, 70, 38, 107, 28, 33, 181, 145, 134, 56, 85, 155, 102, 180, 53, 133, 153, 135, 84, 116, 142, 151, 75, 156, 49, 83, 152, 120, 115, 24, 77, 25, 69, 135, 44, 4, 222, 116, 100, 19, 102, 22, 5, 74, 82, 44, 74, 42, 152, 18, 242, 75, 85, 37, 209, 73, 104, 198, 6, 55, 133, 142, 68, 212, 230, 180, 155, 26, 86, 214, 141, 181, 176, 155, 115, 1, 134, 138, 53, 187, 180, 227, 244, 247, 83, 51, 20, 225, 0, 112, 151, 153, 37, 201, 149, 132, 200, 194, 137, 76, 131, 2, 88, 38, 25, 42, 25, 74, 8, 164, 101, 153, 105, 19, 120, 13, 160, 104, 16, 160, 12, 132, 12, 132, 50, 21, 114, 9, 51, 94, 193, 108, 19, 11, 142, 245, 115, 86, 192, 182, 131, 86, 3, 1, 117, 238, 46, 75, 204, 176, 33, 192, 148, 77, 19, 40, 88, 152, 34, 137, 77, 85, 116, 212, 95, 2, 203, 94, 71, 10, 145, 102, 4, 223, 116, 200, 186, 82, 235, 75, 164, 181, 34, 247, 177, 200, 183, 201, 145, 119, 35, 110, 132, 244, 54, 216, 29, 60, 51, 68, 60, 168, 32, 93, 68, 189, 18, 90, 162, 69, 234, 202, 67, 100, 217, 73, 77, 132, 70, 98, 103, 179, 41, 17, 51, 51, 76, 0, 115, 103, 57, 160, 13, 26, 196, 43, 148, 166, 0, 194, 72, 81, 133, 72, 215, 46, 146, 90, 42, 49, 138, 139, 72, 201, 76, 146, 145, 82, 81, 18, 235, 218, 11, 42, 19, 65, 97, 49, 49, 194, 98, 96, 82, 193, 105, 73, 133, 172, 9, 129, 129, 138, 71, 6, 3, 96, 208, 134, 50, 166, 24, 174, 24, 225, 102, 206, 156, 87, 120, 105, 0, 41, 24, 133, 15, 254, 46, 228, 138, 112, 161, 32, 157, 40, 167, 228 };

constexpr std::array<u8, 5043> BLACK2 = { 170, 127, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 21, 139, 236, 141, 0, 1, 131, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 255, 255, 255, 2, 14, 128, 220, 62, 14, 208, 171, 249, 235, 227, 249, 0, 64, 255, 224, 24, 7, 200, 18, 85, 230, 203, 160, 3, 69, 107, 90, 26, 3, 119, 213, 213, 197, 123, 94, 185, 20, 19, 173, 84, 50, 26, 238, 216, 160, 8, 128, 10, 0, 0, 0, 80, 144, 66, 69, 0, 73, 36, 16, 0, 101, 48, 77, 48, 38, 152, 77, 38, 196, 76, 36, 244, 25, 41, 233, 138, 121, 65, 147, 212, 211, 71, 144, 79, 83, 106, 122, 129, 166, 129, 234, 1, 160, 1, 136, 0, 7, 168, 3, 210, 3, 70, 76, 106, 26, 0, 18, 146, 109, 38, 152, 137, 166, 65, 77, 170, 60, 212, 154, 109, 170, 26, 25, 52, 24, 212, 13, 30, 160, 208, 0, 0, 26, 15, 81, 160, 0, 105, 167, 168, 105, 160, 0, 0, 0, 0, 0, 0, 26, 1, 234, 104, 65, 163, 67, 64, 13, 6, 154, 0, 200, 104, 26, 105, 163, 67, 9, 160, 25, 52, 6, 128, 6, 134, 35, 38, 153, 48, 4, 98, 98, 0, 52, 13, 50, 25, 6, 17, 160, 52, 100, 208, 0, 0, 16, 148, 161, 18, 98, 41, 189, 36, 245, 50, 52, 30, 166, 128, 0, 30, 167, 164, 208, 0, 52, 104, 0, 0, 0, 0, 0, 104, 0, 104, 0, 0, 0, 0, 0, 0, 0, 2, 33, 36, 208, 52, 0, 0, 104, 52, 0, 208, 0, 26, 0, 104, 0, 0, 0, 52, 0, 0, 1, 163, 65, 161, 160, 3, 64, 104, 13, 54, 160, 13, 0, 0, 52, 10, 146, 64, 16, 77, 20, 241, 61, 73, 233, 169, 170, 122, 53, 54, 212, 65, 250, 159, 169, 50, 35, 26, 155, 213, 61, 165, 26, 61, 64, 52, 52, 104, 0, 245, 61, 32, 49, 6, 212, 6, 135, 168, 3, 65, 160, 0, 3, 64, 26, 0, 0, 52, 209, 146, 18, 148, 73, 5, 78, 205, 164, 91, 47, 173, 92, 121, 118, 77, 1, 190, 132, 114, 9, 181, 220, 29, 228, 113, 194, 249, 144, 102, 112, 40, 26, 141, 1, 193, 4, 185, 132, 188, 212, 76, 176, 80, 98, 43, 209, 194, 252, 197, 141, 168, 98, 133, 82, 205, 179, 12, 18, 117, 135, 144, 234, 120, 105, 39, 173, 53, 116, 57, 173, 211, 223, 223, 127, 118, 16, 206, 109, 170, 117, 90, 222, 106, 203, 226, 72, 82, 161, 14, 186, 39, 147, 15, 30, 235, 164, 146, 23, 203, 16, 171, 62, 123, 228, 188, 219, 147, 1, 131, 3, 60, 132, 46, 219, 188, 208, 116, 137, 16, 9, 60, 3, 255, 131, 153, 88, 239, 66, 209, 45, 98, 12, 177, 173, 144, 217, 104, 241, 231, 208, 94, 219, 3, 8, 45, 208, 186, 22, 238, 38, 89, 205, 227, 33, 160, 143, 57, 201, 57, 88, 87, 48, 225, 47, 200, 86, 220, 101, 46, 9, 146, 231, 50, 231, 171, 201, 150, 10, 160, 105, 1, 20, 242, 80, 164, 129, 228, 127, 98, 79, 128, 99, 16, 156, 15, 193, 0, 244, 3, 43, 1, 159, 58, 178, 19, 183, 20, 83, 148, 81, 41, 211, 167, 79, 187, 117, 247, 160, 129, 220, 53, 153, 20, 85, 210, 146, 162, 168, 165, 83, 138, 237, 211, 129, 112, 28, 217, 218, 161, 170, 181, 90, 218, 28, 195, 63, 121, 12, 48, 43, 37, 145, 28, 242, 176, 56, 157, 87, 146, 251, 206, 60, 45, 77, 78, 93, 148, 115, 17, 103, 80, 211, 190, 83, 190, 158, 75, 33, 102, 129, 26, 72, 140, 140, 136, 93, 180, 126, 72, 231, 138, 143, 75, 166, 104, 165, 95, 105, 211, 210, 233, 186, 43, 230, 159, 32, 226, 113, 138, 74, 73, 198, 78, 36, 84, 84, 165, 28, 81, 77, 207, 130, 237, 243, 252, 175, 208, 119, 147, 188, 157, 103, 92, 146, 138, 117, 187, 209, 222, 45, 150, 49, 33, 134, 48, 226, 67, 48, 116, 131, 166, 25, 18, 89, 0, 198, 25, 18, 76, 12, 140, 136, 70, 49, 36, 84, 18, 70, 52, 128, 49, 136, 175, 210, 213, 220, 48, 187, 19, 139, 120, 6, 98, 225, 190, 28, 32, 114, 143, 53, 36, 244, 61, 179, 195, 27, 252, 6, 103, 129, 224, 138, 84, 121, 92, 206, 87, 43, 155, 178, 123, 119, 158, 121, 207, 96, 61, 209, 30, 24, 24, 55, 3, 96, 54, 195, 141, 199, 17, 180, 141, 160, 76, 140, 195, 150, 210, 27, 59, 145, 159, 105, 53, 148, 175, 41, 81, 173, 60, 171, 73, 232, 69, 188, 187, 82, 108, 154, 180, 158, 191, 207, 200, 243, 15, 49, 217, 60, 201, 101, 123, 196, 122, 9, 222, 30, 131, 53, 39, 198, 252, 17, 232, 250, 171, 95, 12, 158, 20, 125, 104, 94, 21, 40, 125, 90, 176, 68, 50, 17, 18, 122, 180, 48, 146, 23, 162, 98, 166, 110, 239, 107, 243, 252, 243, 207, 61, 82, 37, 79, 155, 59, 33, 201, 58, 227, 114, 130, 169, 86, 173, 85, 166, 115, 226, 170, 146, 100, 55, 56, 161, 135, 6, 12, 24, 48, 96, 213, 40, 121, 220, 196, 111, 135, 139, 14, 79, 84, 139, 66, 189, 95, 47, 132, 244, 11, 236, 105, 231, 156, 118, 241, 158, 75, 142, 253, 243, 89, 235, 30, 123, 229, 36, 246, 21, 174, 205, 141, 53, 215, 154, 155, 30, 186, 234, 156, 221, 116, 231, 121, 23, 84, 241, 230, 121, 227, 208, 120, 79, 9, 225, 57, 96, 109, 93, 187, 163, 215, 19, 171, 238, 239, 55, 35, 125, 16, 5, 122, 103, 125, 84, 182, 18, 137, 32, 79, 140, 87, 132, 80, 245, 161, 193, 93, 138, 198, 38, 35, 17, 43, 115, 44, 203, 178, 136, 12, 69, 78, 242, 53, 254, 211, 26, 188, 252, 243, 95, 159, 54, 169, 186, 203, 83, 17, 159, 195, 240, 154, 234, 117, 205, 181, 186, 108, 230, 204, 183, 73, 249, 240, 212, 25, 172, 91, 48, 222, 187, 119, 198, 225, 56, 119, 216, 118, 237, 42, 83, 149, 195, 80, 170, 62, 81, 55, 161, 55, 245, 172, 22, 22, 177, 6, 179, 67, 13, 219, 115, 100, 67, 251, 218, 25, 144, 16, 74, 104, 14, 58, 58, 20, 112, 7, 20, 157, 126, 59, 154, 145, 25, 87, 130, 167, 0, 192, 206, 118, 218, 107, 229, 194, 237, 51, 187, 88, 105, 24, 122, 60, 108, 215, 67, 65, 190, 49, 205, 228, 92, 157, 118, 36, 113, 93, 31, 76, 220, 235, 67, 193, 243, 134, 54, 28, 55, 214, 254, 171, 186, 30, 237, 125, 34, 179, 16, 56, 171, 201, 244, 10, 213, 206, 108, 116, 53, 34, 151, 83, 166, 114, 211, 103, 79, 224, 193, 127, 163, 131, 166, 78, 38, 231, 210, 210, 142, 60, 7, 21, 77, 35, 53, 210, 98, 41, 34, 5, 142, 191, 167, 170, 195, 221, 1, 131, 209, 38, 143, 67, 247, 37, 198, 252, 26, 230, 86, 110, 170, 64, 181, 12, 125, 220, 88, 241, 16, 203, 41, 34, 59, 113, 26, 74, 14, 61, 40, 156, 64, 90, 139, 140, 182, 5, 97, 103, 207, 63, 14, 97, 155, 19, 97, 49, 13, 78, 127, 120, 92, 168, 246, 171, 28, 212, 94, 68, 82, 85, 105, 53, 96, 123, 88, 132, 190, 95, 13, 170, 181, 154, 214, 209, 105, 49, 229, 235, 109, 137, 180, 167, 209, 240, 98, 66, 42, 92, 253, 223, 221, 238, 157, 230, 192, 75, 110, 23, 220, 59, 137, 186, 103, 45, 134, 110, 161, 222, 247, 183, 178, 108, 95, 243, 15, 108, 17, 199, 200, 55, 245, 78, 248, 97, 138, 232, 71, 162, 8, 245, 34, 121, 15, 33, 27, 8, 211, 118, 62, 135, 149, 218, 144, 1, 38, 157, 194, 100, 183, 244, 216, 177, 214, 37, 251, 63, 16, 241, 30, 244, 187, 148, 124, 203, 222, 104, 209, 66, 229, 88, 172, 97, 192, 82, 150, 117, 176, 119, 235, 171, 135, 77, 76, 61, 137, 52, 240, 206, 152, 225, 227, 195, 44, 208, 179, 67, 119, 115, 187, 246, 242, 160, 30, 75, 183, 249, 195, 238, 80, 186, 75, 174, 61, 217, 151, 168, 125, 13, 21, 15, 232, 63, 52, 163, 107, 100, 216, 122, 79, 6, 233, 94, 200, 31, 79, 139, 72, 47, 27, 182, 7, 138, 227, 5, 114, 193, 213, 55, 180, 103, 235, 114, 194, 106, 236, 27, 179, 237, 202, 128, 200, 74, 134, 12, 19, 7, 224, 203, 154, 21, 32, 122, 153, 76, 167, 76, 102, 26, 157, 44, 68, 243, 216, 114, 144, 207, 163, 103, 26, 251, 250, 131, 122, 140, 222, 162, 240, 187, 139, 207, 20, 12, 251, 215, 19, 223, 96, 192, 144, 39, 149, 244, 48, 251, 25, 84, 163, 92, 60, 180, 75, 216, 37, 132, 217, 88, 210, 45, 36, 198, 151, 87, 125, 111, 134, 190, 250, 245, 228, 254, 97, 223, 24, 147, 129, 54, 23, 27, 99, 226, 45, 13, 165, 26, 14, 187, 153, 141, 179, 100, 233, 121, 7, 142, 247, 7, 39, 223, 250, 254, 184, 120, 167, 51, 173, 151, 221, 19, 13, 114, 65, 196, 74, 204, 117, 122, 210, 85, 69, 85, 85, 21, 85, 84, 85, 93, 105, 173, 40, 14, 223, 171, 186, 56, 112, 224, 115, 156, 56, 112, 224, 115, 156, 64, 64, 62, 62, 81, 55, 55, 0, 150, 18, 205, 189, 191, 4, 165, 193, 209, 222, 160, 6, 248, 113, 4, 61, 10, 194, 15, 13, 42, 251, 172, 145, 55, 30, 215, 45, 199, 119, 227, 166, 253, 243, 143, 107, 184, 119, 14, 129, 208, 40, 164, 215, 111, 133, 238, 62, 94, 232, 157, 5, 110, 151, 60, 35, 8, 228, 194, 86, 147, 44, 237, 66, 118, 14, 161, 212, 58, 144, 89, 153, 75, 99, 40, 197, 146, 217, 82, 10, 48, 108, 4, 61, 182, 239, 161, 155, 152, 100, 213, 155, 211, 167, 87, 48, 177, 71, 2, 170, 49, 237, 71, 157, 150, 206, 204, 171, 47, 76, 60, 122, 51, 49, 210, 69, 11, 74, 241, 136, 20, 223, 24, 162, 72, 10, 182, 231, 172, 203, 37, 101, 145, 8, 199, 24, 3, 32, 96, 10, 225, 48, 140, 43, 41, 204, 48, 51, 68, 195, 68, 68, 49, 80, 236, 154, 67, 229, 129, 140, 116, 204, 116, 200, 167, 41, 200, 51, 205, 167, 158, 127, 139, 234, 185, 213, 118, 105, 17, 235, 93, 128, 20, 194, 114, 105, 100, 212, 208, 66, 199, 26, 243, 18, 66, 64, 1, 160, 53, 1, 68, 5, 104, 85, 194, 218, 12, 226, 11, 52, 246, 97, 102, 205, 124, 183, 106, 213, 74, 83, 38, 178, 7, 0, 85, 109, 180, 113, 145, 217, 217, 217, 216, 251, 61, 231, 199, 156, 135, 35, 171, 110, 232, 56, 11, 172, 199, 12, 103, 36, 194, 101, 140, 170, 26, 43, 53, 163, 175, 86, 211, 100, 135, 60, 51, 164, 82, 51, 110, 141, 74, 142, 156, 18, 72, 96, 41, 132, 32, 16, 16, 161, 14, 0, 124, 148, 44, 154, 9, 103, 181, 51, 15, 137, 110, 113, 201, 6, 238, 39, 188, 6, 44, 95, 204, 97, 203, 141, 205, 151, 82, 211, 74, 46, 110, 110, 17, 198, 70, 37, 215, 151, 50, 100, 189, 144, 217, 10, 15, 207, 39, 195, 127, 85, 108, 186, 206, 13, 224, 144, 16, 26, 222, 56, 124, 38, 70, 100, 103, 101, 240, 12, 120, 118, 182, 227, 10, 219, 237, 114, 172, 148, 18, 80, 107, 201, 213, 213, 204, 237, 15, 83, 11, 149, 66, 102, 166, 130, 74, 48, 191, 97, 181, 52, 52, 60, 20, 100, 157, 252, 242, 91, 194, 17, 48, 208, 94, 185, 165, 30, 109, 105, 20, 164, 81, 188, 68, 103, 39, 19, 182, 204, 14, 70, 138, 35, 144, 246, 16, 219, 80, 92, 187, 71, 14, 230, 38, 220, 193, 64, 197, 100, 113, 218, 210, 192, 14, 102, 70, 186, 78, 100, 218, 207, 205, 17, 52, 222, 83, 142, 0, 164, 178, 166, 11, 74, 37, 42, 123, 13, 124, 188, 48, 204, 234, 78, 53, 221, 192, 101, 102, 145, 72, 227, 54, 21, 41, 145, 136, 145, 139, 34, 40, 162, 97, 192, 134, 20, 67, 10, 24, 81, 137, 40, 231, 25, 199, 0, 111, 167, 3, 146, 202, 225, 89, 102, 10, 124, 135, 139, 167, 219, 121, 15, 65, 70, 2, 105, 161, 143, 54, 53, 30, 165, 15, 200, 39, 156, 233, 245, 62, 155, 248, 254, 227, 244, 16, 25, 68, 6, 192, 13, 154, 1, 8, 224, 196, 0, 0, 186, 52, 165, 157, 107, 48, 177, 163, 150, 159, 61, 55, 45, 73, 212, 50, 48, 173, 186, 87, 202, 17, 150, 161, 49, 116, 22, 57, 95, 141, 251, 127, 89, 242, 62, 179, 239, 79, 252, 189, 212, 131, 4, 82, 123, 113, 237, 0, 68, 158, 223, 94, 210, 97, 180, 229, 234, 173, 246, 65, 8, 130, 16, 196, 48, 2, 138, 33, 205, 82, 143, 159, 148, 163, 47, 153, 39, 60, 77, 205, 68, 9, 169, 205, 205, 142, 12, 212, 169, 55, 171, 184, 208, 161, 212, 79, 113, 86, 224, 143, 223, 119, 216, 122, 31, 87, 242, 254, 159, 215, 220, 238, 118, 123, 54, 181, 243, 139, 177, 216, 243, 115, 139, 104, 24, 58, 169, 66, 38, 64, 48, 48, 195, 135, 132, 33, 129, 6, 33, 128, 132, 3, 68, 72, 1, 1, 4, 164, 10, 154, 1, 170, 236, 84, 8, 59, 74, 40, 20, 152, 32, 25, 39, 116, 192, 1, 128, 43, 21, 208, 133, 133, 205, 76, 240, 201, 200, 35, 147, 232, 47, 248, 31, 192, 238, 177, 227, 30, 159, 158, 24, 126, 203, 213, 30, 82, 22, 63, 230, 75, 19, 207, 53, 234, 16, 7, 141, 52, 119, 187, 207, 130, 95, 202, 154, 224, 85, 2, 135, 163, 82, 207, 195, 114, 199, 48, 172, 77, 142, 178, 184, 190, 225, 47, 242, 153, 138, 155, 42, 97, 114, 56, 221, 179, 27, 24, 77, 167, 39, 162, 20, 190, 214, 80, 80, 59, 72, 144, 77, 69, 150, 105, 219, 125, 54, 185, 249, 137, 250, 233, 34, 167, 27, 201, 131, 145, 129, 120, 133, 182, 220, 174, 181, 86, 12, 43, 158, 118, 116, 117, 61, 20, 24, 98, 218, 31, 236, 218, 129, 228, 231, 105, 57, 213, 222, 79, 39, 74, 125, 76, 135, 0, 36, 170, 145, 42, 196, 249, 45, 9, 46, 99, 100, 186, 242, 121, 118, 120, 81, 174, 143, 240, 129, 253, 233, 37, 101, 105, 12, 169, 208, 55, 71, 65, 84, 204, 13, 124, 144, 220, 220, 216, 149, 161, 70, 142, 18, 37, 52, 127, 218, 12, 221, 43, 174, 86, 127, 182, 197, 63, 198, 243, 26, 172, 83, 226, 83, 245, 94, 223, 235, 7, 109, 241, 149, 244, 246, 185, 243, 174, 227, 221, 9, 255, 178, 164, 76, 35, 186, 18, 73, 3, 207, 13, 108, 100, 160, 66, 24, 75, 146, 78, 179, 117, 235, 180, 226, 179, 33, 92, 146, 231, 171, 192, 66, 234, 234, 199, 11, 237, 130, 214, 53, 156, 59, 83, 225, 58, 78, 51, 233, 174, 175, 138, 244, 112, 71, 25, 84, 122, 154, 252, 140, 169, 22, 135, 234, 191, 52, 13, 56, 130, 61, 72, 30, 189, 253, 192, 48, 124, 235, 10, 240, 32, 224, 115, 37, 197, 21, 31, 96, 94, 46, 46, 162, 148, 79, 113, 250, 255, 163, 248, 119, 174, 186, 252, 62, 18, 73, 224, 38, 192, 206, 24, 19, 36, 196, 15, 123, 184, 145, 9, 123, 178, 26, 249, 212, 156, 126, 210, 168, 120, 84, 17, 245, 96, 62, 18, 45, 32, 18, 166, 36, 31, 1, 30, 62, 89, 218, 45, 151, 174, 76, 54, 114, 98, 219, 24, 49, 69, 34, 147, 82, 210, 112, 249, 11, 76, 38, 165, 150, 111, 187, 237, 253, 162, 230, 12, 223, 99, 127, 162, 124, 19, 17, 189, 139, 107, 177, 161, 115, 226, 177, 247, 91, 178, 92, 244, 202, 105, 226, 224, 244, 214, 213, 129, 77, 77, 87, 27, 206, 165, 26, 109, 201, 147, 41, 248, 30, 211, 67, 123, 213, 145, 135, 48, 230, 57, 13, 237, 142, 27, 255, 32, 91, 3, 110, 246, 167, 179, 217, 85, 85, 85, 249, 199, 187, 243, 172, 94, 96, 68, 33, 145, 11, 232, 93, 3, 30, 56, 52, 235, 141, 180, 211, 160, 196, 64, 121, 181, 31, 76, 21, 39, 138, 81, 83, 117, 55, 152, 221, 177, 37, 198, 121, 190, 142, 126, 231, 41, 202, 108, 112, 218, 151, 14, 83, 41, 176, 207, 12, 52, 114, 225, 18, 117, 22, 182, 214, 105, 158, 83, 193, 145, 177, 172, 224, 224, 180, 123, 57, 226, 119, 14, 126, 110, 70, 30, 244, 178, 59, 166, 212, 235, 107, 138, 155, 180, 231, 83, 91, 204, 28, 39, 36, 243, 147, 84, 97, 48, 112, 157, 101, 184, 204, 6, 121, 38, 5, 196, 241, 175, 156, 247, 41, 204, 106, 211, 218, 219, 87, 215, 84, 233, 207, 6, 70, 233, 184, 95, 28, 234, 156, 133, 98, 194, 97, 55, 76, 18, 226, 232, 48, 198, 162, 250, 222, 217, 93, 37, 254, 94, 77, 195, 209, 12, 209, 142, 199, 49, 105, 88, 79, 78, 166, 182, 164, 248, 100, 132, 196, 236, 75, 187, 205, 173, 233, 109, 125, 234, 28, 73, 147, 48, 52, 215, 151, 214, 102, 77, 198, 8, 148, 9, 26, 238, 13, 168, 92, 21, 221, 87, 10, 205, 10, 225, 18, 199, 20, 189, 237, 186, 106, 138, 240, 91, 136, 54, 81, 188, 204, 156, 153, 48, 153, 48, 192, 153, 76, 158, 79, 38, 20, 163, 137, 248, 101, 186, 71, 197, 103, 36, 244, 145, 162, 162, 209, 216, 11, 175, 47, 82, 58, 166, 168, 133, 20, 5, 19, 80, 244, 170, 112, 156, 54, 233, 101, 135, 7, 108, 193, 48, 217, 195, 19, 131, 66, 226, 92, 158, 185, 197, 107, 163, 209, 62, 27, 238, 23, 238, 114, 213, 86, 173, 76, 198, 17, 251, 242, 124, 150, 109, 149, 32, 211, 227, 129, 0, 27, 141, 129, 24, 236, 175, 211, 84, 41, 242, 138, 106, 21, 165, 74, 193, 212, 142, 65, 164, 91, 213, 84, 194, 166, 233, 186, 89, 194, 176, 199, 108, 219, 52, 154, 182, 27, 83, 201, 118, 162, 53, 221, 193, 86, 209, 112, 145, 124, 172, 82, 119, 118, 19, 178, 206, 181, 11, 160, 109, 194, 65, 237, 193, 67, 26, 4, 110, 75, 97, 154, 134, 83, 118, 196, 184, 113, 136, 221, 14, 27, 163, 64, 219, 242, 217, 92, 190, 47, 39, 164, 89, 154, 72, 225, 175, 114, 137, 237, 176, 37, 236, 182, 84, 175, 79, 147, 193, 83, 131, 122, 113, 108, 22, 159, 165, 14, 239, 168, 174, 170, 218, 116, 67, 119, 92, 116, 57, 92, 233, 35, 183, 208, 55, 162, 110, 134, 186, 114, 246, 220, 206, 65, 177, 29, 193, 196, 163, 149, 221, 173, 247, 29, 99, 222, 148, 98, 79, 47, 162, 28, 189, 91, 187, 240, 253, 142, 68, 193, 60, 87, 23, 43, 138, 68, 62, 176, 38, 16, 75, 237, 187, 19, 10, 180, 212, 12, 229, 60, 172, 123, 140, 47, 221, 152, 165, 63, 123, 206, 141, 18, 9, 98, 7, 235, 0, 17, 151, 236, 0, 95, 42, 139, 76, 127, 80, 180, 209, 249, 83, 145, 92, 66, 43, 191, 247, 165, 217, 37, 42, 138, 163, 182, 120, 211, 149, 46, 155, 83, 35, 173, 55, 35, 73, 124, 77, 42, 78, 121, 123, 198, 209, 167, 54, 43, 55, 41, 74, 82, 245, 175, 241, 55, 213, 169, 86, 104, 171, 212, 101, 177, 250, 150, 142, 106, 142, 103, 110, 174, 231, 97, 132, 254, 199, 146, 15, 88, 40, 59, 19, 177, 46, 18, 229, 7, 93, 82, 170, 81, 84, 85, 37, 149, 30, 68, 88, 134, 9, 132, 236, 150, 151, 197, 248, 73, 41, 124, 180, 151, 36, 168, 143, 35, 189, 218, 245, 183, 76, 14, 200, 228, 212, 24, 167, 162, 184, 54, 133, 221, 144, 222, 29, 123, 44, 84, 145, 67, 25, 2, 5, 53, 78, 85, 85, 9, 150, 54, 26, 102, 120, 252, 147, 57, 214, 101, 172, 223, 122, 253, 106, 170, 187, 46, 187, 29, 181, 85, 150, 90, 218, 155, 29, 62, 231, 220, 148, 119, 202, 176, 200, 190, 247, 181, 2, 81, 192, 11, 235, 179, 193, 3, 144, 73, 166, 148, 217, 50, 112, 116, 164, 247, 59, 202, 90, 223, 6, 197, 188, 30, 148, 221, 249, 243, 199, 153, 195, 79, 112, 190, 191, 24, 72, 15, 104, 48, 152, 97, 52, 82, 21, 134, 46, 214, 89, 47, 72, 200, 245, 5, 164, 81, 72, 198, 74, 90, 249, 35, 246, 100, 30, 48, 1, 85, 64, 4, 221, 30, 153, 0, 248, 238, 157, 0, 131, 141, 108, 27, 5, 131, 7, 203, 113, 30, 11, 33, 20, 37, 41, 23, 167, 4, 245, 169, 41, 122, 69, 125, 96, 188, 87, 217, 202, 28, 56, 17, 48, 92, 56, 193, 16, 72, 204, 199, 34, 197, 22, 85, 37, 173, 31, 26, 132, 223, 215, 201, 69, 49, 196, 193, 106, 181, 118, 230, 56, 105, 77, 136, 57, 106, 97, 26, 2, 148, 32, 8, 68, 229, 27, 115, 156, 230, 34, 106, 0, 52, 8, 96, 201, 0, 125, 0, 18, 113, 36, 131, 89, 82, 76, 50, 73, 143, 125, 126, 80, 98, 112, 116, 235, 140, 109, 170, 10, 166, 96, 182, 196, 158, 102, 18, 130, 96, 137, 72, 129, 3, 81, 69, 195, 11, 221, 192, 232, 192, 208, 1, 73, 64, 17, 8, 82, 76, 2, 72, 146, 36, 72, 34, 121, 131, 230, 3, 215, 157, 164, 50, 80, 68, 81, 18, 66, 135, 89, 66, 133, 5, 152, 26, 26, 80, 92, 76, 94, 41, 238, 142, 4, 144, 61, 72, 3, 210, 112, 57, 40, 23, 18, 146, 46, 66, 26, 0, 240, 250, 62, 159, 143, 97, 59, 100, 59, 85, 200, 49, 10, 73, 105, 36, 104, 42, 95, 120, 203, 44, 178, 190, 76, 74, 81, 73, 90, 35, 145, 38, 120, 94, 96, 70, 225, 53, 168, 82, 145, 104, 151, 148, 133, 244, 150, 81, 22, 42, 53, 215, 91, 134, 24, 65, 158, 228, 220, 48, 11, 234, 82, 42, 97, 40, 177, 38, 22, 146, 76, 221, 253, 253, 252, 14, 221, 87, 96, 132, 192, 61, 178, 105, 66, 134, 129, 225, 12, 192, 248, 184, 9, 152, 147, 146, 98, 68, 113, 76, 172, 135, 93, 221, 221, 211, 199, 216, 30, 164, 156, 234, 153, 51, 184, 113, 50, 120, 71, 197, 40, 208, 148, 129, 61, 16, 234, 50, 140, 64, 245, 221, 176, 241, 83, 142, 8, 48, 106, 206, 96, 242, 184, 39, 16, 56, 194, 149, 156, 97, 152, 152, 116, 196, 224, 159, 5, 223, 224, 237, 217, 232, 189, 130, 68, 205, 130, 216, 206, 214, 51, 188, 168, 83, 74, 156, 86, 217, 153, 6, 194, 108, 78, 48, 86, 154, 28, 37, 131, 137, 224, 147, 198, 224, 48, 71, 239, 188, 245, 252, 58, 7, 67, 161, 206, 157, 123, 168, 149, 171, 184, 219, 103, 6, 49, 68, 196, 193, 141, 160, 198, 164, 239, 225, 150, 146, 230, 130, 219, 24, 154, 180, 27, 16, 110, 251, 15, 11, 103, 56, 213, 38, 168, 198, 191, 251, 211, 42, 100, 241, 9, 80, 67, 94, 198, 105, 169, 243, 159, 57, 136, 51, 242, 119, 156, 158, 148, 29, 92, 141, 214, 146, 75, 133, 195, 101, 165, 137, 124, 137, 126, 194, 54, 72, 216, 216, 149, 162, 97, 68, 0, 118, 67, 184, 24, 128, 144, 35, 158, 37, 240, 79, 143, 27, 103, 27, 58, 139, 81, 163, 24, 173, 21, 90, 131, 226, 2, 7, 85, 60, 39, 96, 198, 72, 160, 157, 182, 103, 16, 69, 188, 163, 134, 226, 86, 57, 56, 39, 140, 199, 49, 78, 88, 121, 78, 77, 130, 70, 77, 98, 56, 70, 224, 198, 231, 114, 158, 67, 200, 0, 80, 1, 180, 121, 46, 34, 16, 200, 180, 3, 114, 44, 14, 14, 24, 30, 221, 196, 119, 44, 91, 27, 89, 197, 106, 192, 16, 179, 14, 35, 15, 93, 229, 164, 7, 30, 145, 54, 34, 71, 195, 104, 132, 164, 138, 25, 46, 75, 148, 216, 34, 46, 184, 123, 165, 7, 184, 8, 240, 93, 158, 214, 36, 170, 185, 188, 7, 81, 19, 182, 192, 35, 182, 139, 117, 232, 7, 103, 16, 81, 7, 116, 24, 224, 134, 101, 49, 27, 89, 198, 195, 51, 17, 160, 185, 195, 130, 156, 128, 167, 201, 197, 30, 112, 208, 17, 20, 148, 109, 138, 104, 214, 35, 153, 76, 215, 32, 234, 246, 227, 197, 232, 72, 134, 106, 29, 49, 178, 104, 48, 64, 108, 138, 244, 94, 176, 112, 79, 12, 24, 236, 104, 76, 99, 172, 151, 131, 184, 138, 142, 157, 64, 92, 189, 102, 122, 227, 4, 98, 55, 94, 161, 224, 59, 56, 64, 157, 144, 50, 74, 209, 43, 74, 4, 32, 74, 200, 201, 76, 80, 68, 45, 2, 80, 16, 64, 147, 1, 48, 12, 148, 72, 157, 123, 53, 29, 182, 10, 13, 20, 110, 252, 154, 121, 178, 6, 68, 149, 52, 130, 105, 82, 218, 100, 16, 137, 71, 72, 68, 78, 96, 73, 41, 39, 52, 137, 144, 144, 211, 220, 121, 167, 165, 56, 189, 97, 46, 177, 17, 142, 177, 168, 227, 131, 72, 9, 72, 72, 73, 27, 9, 161, 41, 2, 149, 73, 212, 138, 105, 106, 66, 145, 209, 147, 38, 81, 192, 146, 37, 8, 16, 84, 14, 147, 70, 130, 54, 72, 201, 138, 65, 213, 0, 26, 112, 4, 1, 71, 14, 167, 83, 136, 244, 150, 33, 18, 171, 169, 86, 196, 57, 40, 7, 25, 193, 64, 38, 146, 173, 132, 41, 58, 245, 198, 217, 198, 48, 60, 186, 26, 198, 219, 59, 52, 211, 172, 81, 5, 108, 99, 84, 100, 113, 102, 48, 39, 121, 230, 30, 34, 241, 199, 120, 121, 106, 214, 90, 249, 116, 21, 16, 193, 49, 35, 109, 164, 44, 197, 77, 42, 13, 40, 150, 132, 49, 3, 144, 56, 33, 88, 56, 6, 147, 41, 197, 226, 212, 16, 97, 121, 17, 5, 192, 25, 220, 3, 109, 239, 208, 157, 5, 8, 232, 3, 132, 73, 132, 210, 39, 70, 7, 3, 153, 115, 57, 192, 156, 65, 160, 149, 147, 68, 199, 3, 155, 110, 108, 224, 225, 216, 100, 224, 188, 89, 114, 139, 45, 17, 116, 196, 66, 164, 100, 133, 166, 118, 149, 6, 236, 83, 21, 236, 18, 145, 119, 69, 166, 57, 175, 10, 198, 212, 82, 150, 164, 211, 118, 245, 247, 227, 147, 40, 190, 162, 175, 170, 133, 140, 152, 141, 171, 119, 249, 175, 64, 226, 116, 157, 14, 182, 182, 32, 240, 120, 60, 7, 7, 172, 76, 117, 209, 229, 119, 129, 209, 78, 16, 68, 7, 73, 59, 187, 177, 182, 229, 87, 76, 89, 198, 141, 151, 245, 114, 152, 141, 11, 165, 163, 172, 2, 153, 32, 32, 128, 142, 155, 19, 65, 85, 3, 32, 140, 16, 13, 17, 80, 82, 148, 62, 84, 167, 138, 17, 208, 41, 164, 3, 74, 6, 132, 87, 146, 214, 14, 138, 233, 229, 37, 174, 170, 54, 55, 209, 44, 232, 47, 181, 120, 137, 170, 89, 52, 164, 102, 153, 179, 149, 155, 20, 193, 141, 35, 24, 99, 131, 9, 146, 82, 114, 73, 81, 82, 82, 45, 22, 73, 82, 108, 202, 82, 146, 244, 186, 40, 189, 37, 164, 206, 151, 165, 245, 166, 121, 185, 88, 177, 48, 193, 121, 131, 46, 140, 208, 221, 180, 181, 26, 100, 165, 92, 185, 75, 151, 89, 98, 195, 27, 163, 192, 54, 189, 139, 143, 78, 128, 57, 129, 19, 164, 29, 213, 5, 45, 12, 66, 114, 14, 71, 67, 142, 65, 131, 28, 224, 242, 52, 120, 228, 230, 12, 3, 227, 129, 85, 82, 66, 234, 66, 166, 141, 247, 219, 120, 151, 175, 94, 151, 165, 241, 23, 162, 137, 114, 74, 147, 126, 49, 51, 172, 46, 180, 132, 186, 217, 174, 36, 93, 166, 11, 163, 85, 5, 234, 54, 97, 100, 198, 165, 219, 219, 235, 2, 213, 152, 168, 166, 9, 133, 235, 155, 23, 93, 114, 242, 177, 163, 93, 229, 238, 33, 223, 11, 45, 219, 197, 96, 226, 194, 120, 123, 196, 123, 29, 239, 78, 42, 24, 59, 48, 190, 241, 75, 90, 173, 54, 101, 105, 85, 49, 86, 6, 202, 45, 178, 201, 44, 24, 10, 22, 147, 26, 56, 59, 77, 154, 108, 205, 181, 166, 83, 22, 89, 45, 139, 44, 150, 201, 153, 99, 18, 139, 133, 196, 177, 80, 155, 162, 141, 10, 41, 42, 26, 52, 100, 186, 52, 100, 211, 77, 17, 129, 162, 40, 203, 58, 178, 204, 152, 169, 66, 92, 137, 173, 73, 37, 180, 103, 44, 194, 109, 89, 101, 75, 242, 153, 228, 68, 93, 134, 9, 116, 134, 117, 11, 242, 100, 101, 142, 84, 84, 82, 49, 11, 229, 246, 154, 229, 145, 157, 241, 47, 164, 11, 82, 169, 33, 63, 252, 93, 201, 20, 225, 66, 64, 86, 47, 178, 52 };

constexpr std::array<u8, 578> BW2_GROTTO = { 200, 10, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 233, 76, 190, 19, 0, 3, 169, 255, 254, 254, 124, 164, 179, 90, 106, 95, 166, 0, 127, 255, 160, 254, 158, 153, 169, 156, 240, 66, 0, 160, 32, 4, 160, 9, 1, 145, 129, 0, 41, 64, 2, 156, 0, 0, 14, 52, 50, 105, 166, 77, 0, 12, 16, 6, 131, 38, 128, 1, 147, 64, 0, 0, 201, 144, 13, 14, 52, 50, 105, 166, 77, 0, 12, 16, 6, 131, 38, 128, 1, 147, 64, 0, 0, 201, 144, 13, 14, 52, 50, 105, 166, 77, 0, 12, 16, 6, 131, 38, 128, 1, 147, 64, 0, 0, 201, 144, 13, 2, 164, 136, 154, 152, 147, 41, 147, 64, 245, 0, 26, 15, 80, 211, 106, 3, 79, 81, 234, 52, 52, 49, 138, 100, 245, 15, 83, 212, 245, 7, 131, 84, 217, 54, 147, 215, 118, 230, 224, 119, 3, 185, 62, 230, 129, 26, 68, 110, 183, 182, 231, 164, 126, 181, 54, 74, 57, 15, 240, 245, 8, 185, 221, 239, 211, 173, 82, 202, 71, 15, 52, 243, 72, 205, 38, 177, 77, 138, 211, 85, 195, 105, 238, 158, 19, 207, 59, 207, 91, 139, 52, 207, 71, 104, 142, 35, 157, 240, 157, 242, 63, 18, 51, 31, 145, 20, 142, 103, 89, 75, 55, 234, 110, 55, 142, 67, 152, 231, 110, 82, 166, 233, 192, 232, 119, 90, 39, 201, 188, 71, 216, 35, 188, 71, 128, 141, 240, 242, 77, 190, 92, 242, 70, 249, 21, 33, 187, 42, 27, 148, 250, 168, 181, 21, 112, 112, 135, 136, 141, 242, 56, 8, 224, 35, 39, 140, 143, 25, 36, 179, 222, 113, 90, 45, 162, 85, 167, 45, 79, 235, 94, 91, 27, 86, 55, 147, 143, 226, 151, 249, 85, 58, 245, 56, 59, 18, 198, 71, 211, 87, 168, 153, 20, 81, 83, 146, 167, 134, 167, 130, 166, 215, 45, 147, 143, 93, 203, 176, 193, 48, 89, 99, 73, 71, 81, 254, 154, 142, 51, 81, 195, 231, 85, 118, 142, 131, 164, 203, 81, 83, 176, 114, 29, 14, 118, 141, 21, 93, 51, 148, 233, 159, 247, 52, 236, 215, 95, 83, 46, 130, 242, 237, 71, 160, 35, 81, 172, 109, 22, 154, 226, 163, 148, 216, 158, 69, 23, 85, 150, 77, 79, 48, 192, 233, 42, 104, 8, 234, 41, 226, 63, 66, 141, 36, 188, 71, 81, 82, 39, 32, 148, 108, 148, 69, 202, 57, 229, 138, 133, 200, 186, 70, 105, 49, 53, 22, 153, 202, 109, 180, 76, 101, 201, 99, 239, 83, 25, 121, 105, 99, 1, 97, 172, 197, 97, 145, 154, 96, 193, 134, 53, 133, 87, 111, 28, 114, 195, 44, 178, 46, 205, 51, 47, 49, 152, 90, 74, 76, 197, 22, 50, 42, 90, 90, 101, 51, 75, 198, 70, 6, 38, 120, 210, 81, 164, 46, 75, 73, 160, 146, 96, 48, 46, 105, 37, 22, 151, 42, 42, 213, 42, 84, 162, 172, 170, 146, 164, 84, 90, 76, 233, 84, 177, 114, 139, 23, 19, 57, 48, 89, 36, 59, 42, 74, 73, 37, 22, 148, 169, 97, 101, 204, 213, 82, 181, 203, 161, 140, 168, 161, 145, 82, 210, 146, 146, 139, 74, 22, 170, 137, 17, 48, 81, 32, 255, 197, 220, 145, 78, 20, 36, 58, 83, 47, 132, 192 };

constexpr std::array<u8, 3667> WHITE = { 82, 110, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 5, 71, 23, 50, 0, 1, 109, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 140, 2, 94, 0, 223, 122, 2, 16, 192, 241, 171, 227, 241, 16, 0, 255, 224, 17, 126, 248, 221, 157, 58, 85, 205, 142, 135, 220, 122, 215, 174, 165, 94, 61, 187, 222, 189, 239, 2, 237, 128, 216, 98, 153, 74, 148, 93, 132, 166, 201, 128, 6, 136, 150, 155, 9, 68, 146, 122, 98, 83, 213, 63, 53, 73, 250, 155, 20, 120, 13, 10, 79, 192, 166, 166, 244, 147, 105, 234, 122, 167, 178, 18, 96, 70, 141, 24, 134, 141, 0, 3, 38, 8, 0, 3, 17, 135, 168, 212, 244, 38, 39, 181, 64, 104, 209, 167, 162, 100, 104, 37, 20, 105, 145, 137, 162, 101, 61, 40, 245, 35, 194, 8, 245, 24, 104, 212, 1, 160, 6, 128, 1, 160, 6, 129, 160, 196, 1, 160, 218, 141, 52, 209, 161, 160, 0, 0, 0, 0, 15, 72, 32, 201, 136, 201, 166, 77, 6, 134, 76, 67, 32, 13, 52, 6, 17, 130, 52, 211, 4, 24, 76, 67, 17, 163, 64, 26, 1, 132, 96, 77, 3, 77, 52, 25, 0, 100, 52, 201, 160, 6, 153, 2, 77, 41, 18, 79, 73, 168, 0, 76, 0, 0, 1, 48, 9, 128, 0, 9, 128, 17, 129, 25, 24, 0, 19, 0, 0, 4, 193, 24, 1, 52, 192, 0, 26, 8, 148, 66, 153, 83, 207, 85, 63, 77, 83, 79, 105, 67, 79, 68, 104, 104, 104, 52, 200, 30, 161, 160, 0, 30, 160, 0, 0, 0, 208, 97, 0, 13, 0, 0, 208, 0, 0, 0, 0, 218, 129, 82, 68, 16, 4, 202, 100, 24, 146, 109, 39, 147, 13, 84, 245, 63, 65, 38, 105, 0, 3, 38, 67, 64, 100, 208, 209, 160, 6, 70, 30, 168, 61, 64, 0, 25, 24, 129, 129, 25, 50, 7, 168, 211, 64, 105, 4, 90, 131, 130, 243, 82, 234, 193, 213, 132, 120, 64, 53, 203, 176, 118, 59, 44, 119, 107, 92, 186, 3, 157, 189, 88, 240, 79, 115, 116, 200, 195, 107, 109, 20, 155, 61, 62, 237, 182, 250, 221, 19, 95, 131, 23, 137, 76, 124, 205, 144, 236, 48, 169, 24, 78, 171, 176, 110, 211, 225, 167, 58, 36, 209, 61, 9, 104, 149, 59, 119, 188, 132, 41, 64, 118, 33, 211, 104, 132, 90, 90, 33, 86, 99, 216, 239, 227, 30, 91, 44, 145, 12, 113, 178, 29, 204, 61, 47, 92, 237, 174, 195, 186, 52, 171, 80, 128, 171, 17, 35, 87, 139, 74, 90, 88, 96, 169, 65, 44, 165, 52, 150, 146, 196, 121, 40, 160, 76, 75, 105, 171, 146, 94, 72, 250, 97, 42, 17, 192, 153, 217, 50, 100, 50, 25, 50, 71, 153, 188, 47, 11, 131, 104, 17, 202, 32, 64, 30, 64, 181, 42, 68, 29, 69, 10, 73, 192, 177, 67, 90, 119, 83, 208, 74, 122, 50, 121, 178, 109, 221, 231, 111, 111, 55, 55, 155, 102, 227, 105, 66, 137, 186, 92, 177, 40, 163, 98, 110, 82, 122, 82, 110, 37, 71, 137, 23, 57, 188, 47, 11, 194, 241, 53, 67, 168, 29, 83, 145, 88, 226, 20, 51, 69, 12, 106, 56, 73, 36, 84, 135, 48, 113, 14, 50, 78, 41, 37, 10, 74, 146, 144, 227, 39, 25, 5, 73, 221, 29, 97, 229, 29, 116, 81, 72, 250, 215, 59, 214, 59, 81, 229, 249, 239, 11, 170, 30, 129, 144, 37, 152, 147, 105, 133, 48, 162, 20, 133, 18, 228, 3, 101, 43, 54, 65, 87, 24, 26, 76, 146, 165, 164, 98, 133, 139, 69, 41, 94, 105, 104, 243, 148, 102, 143, 17, 71, 156, 117, 26, 142, 138, 58, 154, 66, 165, 42, 84, 240, 197, 120, 145, 213, 85, 226, 164, 143, 59, 81, 37, 37, 41, 81, 225, 90, 199, 162, 154, 222, 136, 168, 37, 85, 176, 5, 128, 11, 4, 0, 168, 42, 34, 42, 153, 151, 77, 137, 123, 94, 227, 144, 220, 128, 164, 77, 159, 50, 107, 175, 61, 219, 39, 72, 95, 86, 29, 109, 157, 237, 157, 229, 91, 211, 243, 112, 250, 168, 119, 33, 229, 67, 202, 133, 67, 12, 180, 33, 141, 208, 39, 184, 179, 197, 20, 163, 174, 215, 12, 35, 106, 168, 228, 197, 34, 16, 3, 114, 97, 190, 219, 239, 215, 175, 58, 121, 93, 85, 10, 244, 5, 215, 131, 9, 192, 123, 220, 198, 208, 233, 179, 248, 206, 113, 76, 203, 30, 77, 92, 33, 98, 144, 130, 71, 22, 174, 171, 233, 41, 38, 78, 71, 60, 217, 50, 138, 131, 56, 50, 202, 67, 139, 82, 49, 142, 58, 185, 117, 200, 151, 165, 242, 38, 22, 103, 154, 189, 94, 94, 130, 230, 103, 182, 86, 151, 45, 200, 239, 156, 58, 56, 113, 113, 113, 56, 56, 158, 23, 167, 4, 219, 60, 15, 35, 222, 121, 153, 125, 212, 254, 223, 238, 237, 86, 59, 107, 173, 151, 44, 138, 40, 44, 129, 185, 86, 59, 252, 133, 98, 65, 66, 69, 17, 131, 78, 98, 52, 189, 104, 199, 245, 113, 184, 250, 95, 142, 132, 251, 92, 127, 223, 225, 223, 244, 190, 136, 245, 2, 4, 109, 53, 147, 202, 157, 106, 112, 20, 250, 100, 88, 82, 95, 252, 187, 50, 243, 53, 228, 166, 62, 147, 129, 227, 248, 136, 56, 246, 116, 195, 13, 35, 68, 35, 71, 184, 245, 193, 242, 229, 122, 247, 77, 105, 119, 79, 61, 102, 183, 158, 193, 151, 10, 77, 166, 207, 193, 135, 16, 195, 236, 241, 12, 100, 67, 154, 137, 209, 14, 209, 74, 138, 110, 63, 100, 242, 62, 170, 149, 72, 110, 90, 224, 68, 249, 0, 194, 22, 218, 229, 38, 128, 106, 67, 90, 108, 178, 54, 86, 39, 43, 68, 203, 56, 51, 27, 151, 91, 24, 191, 126, 253, 253, 99, 246, 114, 242, 240, 17, 47, 227, 133, 238, 244, 145, 129, 183, 159, 52, 202, 99, 153, 81, 143, 1, 189, 81, 12, 185, 146, 48, 97, 183, 55, 34, 238, 73, 179, 44, 217, 59, 22, 214, 218, 33, 97, 18, 184, 48, 221, 5, 107, 74, 135, 242, 154, 9, 167, 7, 203, 164, 252, 172, 150, 12, 100, 146, 73, 12, 33, 152, 228, 146, 214, 214, 33, 111, 54, 219, 67, 163, 163, 174, 160, 183, 139, 165, 237, 138, 11, 222, 70, 116, 116, 117, 209, 119, 187, 213, 93, 198, 219, 4, 130, 64, 124, 164, 224, 251, 244, 145, 160, 210, 14, 82, 244, 234, 53, 215, 167, 188, 76, 141, 119, 46, 26, 53, 67, 83, 200, 215, 207, 66, 126, 26, 191, 67, 245, 206, 0, 52, 176, 207, 70, 121, 210, 101, 138, 153, 90, 77, 102, 121, 24, 207, 158, 113, 122, 78, 249, 215, 237, 186, 122, 122, 94, 187, 240, 204, 178, 101, 150, 76, 178, 50, 201, 150, 89, 50, 200, 203, 38, 89, 100, 201, 148, 234, 240, 85, 85, 82, 158, 4, 245, 238, 246, 161, 164, 204, 104, 220, 204, 119, 142, 241, 145, 221, 60, 62, 219, 239, 9, 38, 126, 239, 171, 221, 238, 57, 71, 41, 168, 234, 14, 163, 144, 235, 208, 170, 100, 44, 175, 101, 93, 182, 109, 237, 236, 205, 19, 118, 84, 215, 143, 42, 42, 53, 35, 19, 116, 196, 223, 78, 55, 164, 96, 237, 230, 160, 53, 90, 149, 58, 37, 234, 213, 42, 94, 118, 123, 124, 141, 142, 109, 177, 89, 70, 115, 158, 213, 161, 82, 142, 148, 99, 147, 177, 185, 167, 45, 118, 146, 49, 77, 43, 89, 165, 197, 40, 142, 147, 95, 54, 130, 51, 108, 211, 172, 236, 218, 206, 174, 128, 53, 97, 67, 68, 221, 159, 54, 124, 237, 236, 28, 140, 26, 13, 230, 162, 208, 106, 135, 68, 58, 16, 211, 85, 11, 36, 145, 176, 11, 8, 53, 140, 24, 53, 223, 147, 125, 77, 97, 27, 227, 24, 232, 84, 61, 120, 223, 174, 77, 218, 245, 201, 177, 42, 134, 153, 161, 54, 94, 177, 170, 99, 46, 170, 85, 42, 181, 49, 90, 108, 214, 224, 38, 1, 2, 211, 52, 180, 195, 10, 202, 13, 65, 89, 39, 17, 188, 173, 47, 146, 174, 94, 240, 204, 210, 33, 21, 134, 204, 219, 22, 75, 193, 130, 82, 82, 156, 36, 201, 62, 226, 201, 108, 24, 44, 115, 78, 105, 219, 228, 223, 191, 108, 172, 106, 33, 133, 88, 62, 123, 217, 4, 153, 81, 85, 111, 138, 204, 172, 153, 70, 4, 196, 211, 141, 101, 40, 37, 19, 12, 104, 234, 105, 66, 129, 173, 152, 104, 214, 78, 13, 162, 130, 112, 109, 45, 87, 58, 128, 132, 243, 81, 224, 51, 90, 218, 159, 179, 175, 93, 83, 43, 219, 123, 47, 155, 99, 177, 228, 242, 123, 211, 201, 228, 242, 101, 228, 251, 255, 130, 174, 163, 191, 225, 50, 163, 168, 234, 179, 3, 197, 223, 240, 27, 212, 39, 13, 124, 195, 33, 169, 47, 190, 148, 47, 186, 243, 123, 78, 142, 142, 137, 180, 202, 199, 134, 24, 97, 134, 24, 6, 204, 216, 17, 26, 78, 58, 220, 188, 253, 103, 63, 44, 251, 87, 51, 149, 173, 175, 95, 131, 224, 101, 83, 196, 70, 196, 169, 106, 44, 168, 149, 84, 81, 150, 20, 5, 80, 234, 181, 71, 240, 227, 242, 36, 67, 68, 1, 207, 131, 252, 224, 60, 65, 22, 84, 152, 243, 185, 254, 63, 63, 103, 27, 231, 230, 115, 188, 207, 35, 67, 161, 155, 157, 244, 230, 224, 191, 149, 176, 241, 112, 95, 206, 204, 228, 114, 121, 53, 121, 222, 255, 43, 153, 90, 182, 173, 43, 34, 162, 138, 32, 162, 141, 32, 210, 31, 232, 172, 133, 183, 218, 181, 9, 69, 55, 28, 108, 45, 56, 174, 9, 127, 14, 126, 143, 217, 163, 159, 213, 221, 111, 58, 158, 166, 239, 237, 250, 241, 98, 195, 139, 23, 83, 226, 148, 74, 152, 172, 85, 70, 48, 150, 128, 108, 13, 129, 251, 9, 176, 41, 76, 146, 155, 0, 70, 11, 1, 69, 80, 200, 73, 106, 168, 94, 203, 40, 166, 24, 24, 96, 122, 182, 236, 251, 151, 171, 244, 31, 237, 171, 63, 165, 94, 62, 15, 27, 55, 51, 155, 31, 250, 251, 115, 225, 43, 113, 194, 55, 31, 122, 42, 104, 42, 19, 223, 196, 181, 207, 255, 73, 217, 29, 58, 209, 132, 139, 139, 158, 134, 34, 226, 167, 159, 217, 152, 107, 144, 77, 199, 179, 38, 158, 94, 59, 52, 221, 140, 239, 65, 255, 136, 158, 33, 32, 115, 161, 199, 130, 31, 24, 255, 38, 205, 160, 70, 144, 52, 68, 85, 38, 213, 32, 171, 82, 116, 226, 65, 48, 155, 10, 108, 145, 218, 69, 53, 139, 9, 182, 213, 225, 231, 71, 140, 109, 105, 158, 116, 15, 27, 19, 38, 126, 115, 144, 31, 242, 137, 160, 95, 155, 78, 32, 52, 180, 159, 232, 25, 163, 186, 26, 52, 211, 108, 19, 51, 244, 253, 112, 18, 165, 230, 9, 166, 18, 121, 7, 120, 121, 228, 157, 202, 67, 63, 7, 186, 192, 84, 45, 19, 184, 122, 175, 249, 49, 101, 236, 236, 205, 158, 102, 102, 102, 89, 35, 23, 143, 59, 102, 205, 153, 147, 15, 223, 197, 150, 120, 78, 56, 28, 33, 59, 133, 223, 78, 53, 132, 236, 165, 154, 94, 135, 163, 99, 39, 223, 212, 80, 187, 90, 158, 242, 146, 129, 244, 110, 248, 12, 208, 4, 41, 115, 157, 8, 211, 86, 218, 16, 79, 82, 103, 143, 166, 130, 134, 186, 149, 20, 98, 54, 115, 122, 196, 239, 206, 240, 214, 14, 47, 148, 219, 114, 249, 146, 28, 42, 253, 42, 242, 201, 22, 26, 100, 210, 45, 59, 136, 205, 46, 26, 34, 38, 192, 54, 32, 160, 44, 192, 169, 99, 80, 117, 189, 237, 246, 149, 133, 101, 103, 21, 140, 121, 112, 238, 10, 120, 35, 5, 21, 18, 41, 231, 234, 165, 106, 112, 9, 222, 62, 193, 36, 86, 88, 68, 20, 156, 220, 150, 219, 196, 190, 92, 60, 167, 151, 181, 110, 108, 74, 34, 68, 219, 80, 170, 170, 170, 192, 200, 14, 72, 166, 50, 137, 39, 26, 35, 130, 35, 139, 44, 116, 137, 18, 35, 11, 52, 247, 234, 109, 81, 217, 69, 55, 165, 169, 145, 26, 151, 38, 237, 202, 229, 50, 134, 91, 250, 206, 121, 133, 74, 229, 207, 35, 115, 108, 117, 247, 70, 83, 85, 74, 253, 153, 197, 225, 140, 231, 24, 222, 24, 107, 129, 230, 172, 12, 152, 48, 147, 121, 105, 179, 14, 86, 48, 182, 255, 56, 182, 247, 208, 98, 182, 103, 134, 88, 59, 22, 10, 170, 170, 182, 35, 101, 9, 34, 164, 73, 33, 33, 86, 79, 10, 103, 181, 30, 150, 232, 162, 135, 84, 8, 162, 199, 76, 177, 236, 206, 84, 135, 88, 96, 78, 173, 60, 187, 227, 101, 69, 43, 81, 209, 52, 95, 6, 244, 186, 108, 50, 26, 166, 180, 134, 38, 58, 37, 33, 128, 112, 243, 241, 228, 78, 13, 146, 108, 83, 89, 192, 202, 199, 18, 199, 5, 204, 10, 158, 73, 97, 176, 155, 210, 27, 164, 126, 116, 51, 218, 252, 21, 41, 74, 113, 166, 35, 52, 46, 106, 39, 242, 67, 151, 240, 39, 218, 117, 95, 234, 72, 241, 248, 233, 90, 9, 198, 112, 144, 229, 155, 210, 233, 180, 220, 116, 138, 20, 50, 146, 72, 228, 157, 193, 94, 157, 35, 149, 78, 78, 142, 154, 245, 63, 91, 179, 60, 166, 122, 118, 167, 14, 14, 212, 57, 225, 239, 225, 218, 211, 206, 157, 10, 174, 61, 179, 107, 236, 247, 206, 207, 95, 8, 107, 134, 200, 104, 120, 180, 111, 111, 134, 246, 180, 223, 55, 166, 41, 189, 41, 53, 20, 117, 142, 239, 122, 21, 182, 53, 7, 24, 75, 88, 49, 130, 54, 161, 90, 181, 201, 126, 16, 120, 193, 133, 98, 5, 197, 8, 16, 84, 85, 88, 41, 142, 188, 160, 172, 46, 60, 184, 224, 42, 78, 196, 224, 248, 237, 163, 21, 92, 145, 36, 61, 62, 164, 221, 126, 37, 116, 34, 224, 242, 98, 68, 157, 68, 178, 38, 145, 1, 228, 216, 38, 88, 34, 38, 105, 88, 64, 168, 199, 117, 68, 76, 85, 164, 82, 41, 66, 98, 26, 68, 137, 125, 123, 144, 52, 192, 42, 71, 140, 176, 206, 116, 67, 182, 56, 224, 38, 19, 23, 93, 110, 184, 73, 9, 241, 150, 0, 110, 33, 121, 78, 55, 190, 17, 17, 228, 16, 34, 34, 137, 20, 147, 61, 147, 102, 189, 18, 118, 90, 244, 181, 138, 147, 4, 214, 214, 197, 116, 187, 90, 104, 198, 66, 201, 19, 82, 154, 90, 127, 87, 45, 58, 100, 208, 118, 137, 241, 73, 231, 133, 18, 194, 88, 219, 38, 18, 107, 73, 192, 208, 215, 38, 152, 152, 73, 138, 74, 144, 90, 135, 100, 115, 126, 219, 9, 113, 166, 98, 6, 176, 9, 192, 235, 92, 250, 75, 178, 118, 28, 237, 25, 180, 219, 16, 32, 4, 32, 91, 14, 90, 202, 170, 109, 67, 106, 216, 206, 17, 100, 123, 42, 133, 148, 97, 175, 110, 253, 17, 86, 221, 148, 171, 116, 93, 230, 117, 209, 105, 59, 4, 214, 125, 30, 109, 92, 215, 215, 195, 39, 186, 230, 230, 195, 8, 199, 70, 119, 171, 94, 223, 137, 180, 141, 132, 164, 61, 176, 122, 135, 195, 40, 81, 32, 65, 14, 180, 134, 143, 92, 52, 24, 132, 100, 0, 138, 232, 216, 37, 84, 183, 165, 187, 95, 176, 187, 152, 205, 220, 245, 29, 134, 214, 227, 49, 221, 98, 74, 68, 225, 93, 41, 36, 5, 128, 145, 72, 1, 0, 162, 133, 216, 211, 147, 21, 175, 37, 77, 247, 11, 85, 147, 137, 139, 6, 53, 73, 78, 196, 31, 14, 8, 101, 43, 86, 35, 36, 146, 0, 196, 182, 45, 221, 89, 65, 148, 192, 213, 48, 72, 144, 193, 148, 35, 74, 171, 10, 1, 145, 64, 200, 192, 72, 135, 33, 64, 73, 175, 14, 152, 40, 46, 129, 98, 197, 21, 89, 166, 117, 36, 102, 171, 42, 166, 139, 133, 85, 136, 192, 88, 213, 88, 170, 144, 141, 4, 164, 20, 196, 22, 88, 170, 207, 117, 9, 129, 27, 55, 79, 16, 159, 210, 80, 80, 81, 40, 37, 9, 68, 163, 8, 77, 236, 210, 42, 84, 10, 144, 168, 34, 88, 176, 176, 34, 196, 64, 32, 64, 82, 69, 49, 3, 136, 176, 66, 162, 89, 21, 22, 68, 21, 42, 36, 70, 203, 145, 201, 87, 85, 40, 93, 86, 26, 214, 36, 161, 82, 38, 44, 69, 10, 88, 49, 169, 49, 5, 68, 90, 164, 44, 164, 165, 150, 146, 99, 229, 247, 47, 244, 242, 163, 43, 201, 150, 89, 94, 48, 168, 165, 9, 78, 40, 86, 112, 185, 91, 174, 186, 162, 88, 138, 65, 70, 214, 8, 227, 1, 184, 18, 137, 233, 168, 108, 133, 230, 2, 217, 33, 88, 80, 69, 4, 84, 80, 68, 18, 98, 19, 67, 33, 142, 157, 55, 144, 189, 239, 125, 36, 155, 201, 188, 188, 51, 42, 19, 60, 243, 193, 132, 67, 56, 84, 72, 150, 178, 204, 113, 199, 19, 4, 41, 137, 97, 36, 180, 168, 164, 164, 21, 98, 45, 18, 69, 170, 72, 170, 36, 99, 142, 43, 165, 239, 124, 57, 114, 70, 66, 47, 68, 148, 81, 16, 170, 132, 170, 136, 101, 149, 130, 245, 48, 74, 129, 106, 130, 9, 12, 178, 182, 232, 49, 9, 50, 51, 41, 9, 10, 144, 64, 72, 65, 81, 32, 161, 17, 132, 207, 60, 204, 25, 10, 32, 10, 57, 203, 9, 152, 65, 9, 38, 152, 77, 80, 154, 212, 72, 180, 146, 209, 98, 214, 146, 150, 9, 68, 176, 40, 68, 140, 70, 88, 132, 66, 89, 86, 1, 64, 96, 88, 132, 137, 100, 72, 80, 10, 20, 11, 25, 24, 82, 88, 88, 88, 88, 96, 154, 1, 11, 136, 183, 96, 192, 85, 18, 193, 8, 171, 33, 34, 172, 72, 131, 8, 150, 200, 162, 122, 82, 12, 136, 218, 71, 105, 27, 228, 229, 18, 162, 171, 18, 52, 78, 21, 97, 76, 194, 140, 194, 140, 197, 50, 20, 164, 85, 82, 148, 166, 57, 193, 192, 136, 216, 69, 48, 144, 86, 137, 216, 177, 26, 2, 164, 34, 6, 109, 106, 146, 53, 85, 92, 145, 85, 160, 178, 148, 66, 66, 98, 66, 128, 74, 65, 40, 128, 230, 16, 176, 0, 176, 198, 166, 96, 14, 37, 181, 27, 6, 32, 53, 68, 22, 40, 73, 134, 163, 128, 146, 173, 177, 82, 196, 45, 74, 13, 150, 137, 73, 113, 112, 56, 0, 96, 8, 89, 109, 43, 37, 41, 26, 5, 174, 28, 98, 82, 213, 20, 33, 89, 5, 180, 178, 169, 109, 16, 169, 18, 139, 44, 88, 50, 10, 82, 84, 20, 178, 202, 82, 216, 136, 34, 182, 66, 27, 77, 38, 113, 200, 133, 215, 96, 134, 4, 180, 185, 227, 24, 155, 86, 88, 102, 0, 88, 215, 81, 134, 16, 154, 226, 22, 82, 144, 96, 145, 136, 32, 217, 11, 108, 0, 100, 25, 6, 204, 130, 33, 3, 4, 73, 132, 170, 132, 80, 16, 16, 98, 54, 70, 16, 65, 132, 160, 129, 146, 6, 67, 48, 162, 160, 179, 8, 92, 21, 170, 88, 141, 40, 54, 212, 176, 184, 178, 137, 28, 84, 165, 148, 86, 231, 113, 130, 45, 27, 105, 175, 54, 35, 91, 98, 210, 22, 72, 106, 19, 70, 161, 70, 41, 84, 105, 166, 132, 48, 204, 21, 6, 54, 141, 5, 100, 22, 66, 132, 65, 68, 37, 146, 85, 37, 145, 73, 104, 194, 6, 23, 133, 141, 42, 149, 85, 45, 123, 197, 176, 189, 216, 97, 47, 152, 197, 116, 198, 115, 38, 96, 200, 147, 43, 100, 168, 250, 86, 66, 219, 33, 161, 0, 201, 147, 82, 12, 149, 140, 145, 33, 82, 138, 33, 42, 20, 25, 16, 98, 68, 138, 145, 144, 80, 69, 132, 100, 99, 34, 146, 25, 160, 100, 132, 80, 128, 160, 45, 72, 45, 72, 90, 146, 73, 106, 18, 102, 189, 130, 216, 38, 23, 30, 101, 112, 173, 129, 109, 102, 188, 6, 2, 235, 220, 92, 151, 153, 96, 67, 129, 40, 154, 38, 80, 177, 48, 69, 18, 154, 170, 233, 168, 190, 5, 150, 188, 142, 21, 34, 204, 9, 190, 233, 144, 96, 137, 130, 204, 18, 84, 134, 49, 73, 81, 206, 177, 132, 153, 137, 150, 171, 53, 114, 200, 38, 38, 139, 129, 38, 149, 4, 36, 194, 76, 33, 37, 97, 33, 134, 137, 3, 90, 107, 82, 83, 97, 17, 152, 153, 236, 202, 68, 139, 90, 215, 148, 12, 237, 173, 112, 186, 246, 66, 76, 49, 74, 0, 197, 108, 138, 80, 98, 71, 44, 32, 9, 104, 193, 170, 178, 83, 36, 164, 84, 148, 68, 186, 246, 130, 202, 68, 208, 88, 76, 76, 112, 152, 152, 20, 176, 90, 82, 97, 107, 17, 98, 197, 161, 74, 101, 44, 48, 46, 129, 99, 36, 41, 100, 148, 178, 142, 82, 204, 73, 51, 72, 176, 0, 88, 68, 130, 135, 254, 46, 228, 138, 112, 161, 32, 10, 142, 46, 100 };

constexpr std::array<u8, 5026> WHITE2 = { 170, 127, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 187, 73, 126, 116, 0, 1, 131, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 255, 255, 255, 2, 14, 128, 220, 58, 14, 208, 171, 249, 234, 227, 249, 0, 128, 255, 224, 24, 11, 229, 165, 99, 39, 155, 144, 21, 85, 216, 182, 208, 165, 26, 162, 125, 123, 128, 47, 52, 164, 145, 34, 168, 155, 38, 137, 0, 136, 10, 36, 80, 0, 0, 72, 80, 42, 72, 2, 18, 74, 68, 79, 77, 24, 19, 212, 105, 163, 76, 104, 106, 158, 154, 76, 209, 148, 210, 111, 20, 205, 19, 210, 154, 108, 132, 98, 0, 104, 208, 245, 52, 211, 65, 234, 26, 26, 26, 26, 13, 52, 13, 52, 0, 3, 64, 217, 64, 0, 100, 0, 4, 146, 8, 0, 64, 153, 6, 128, 35, 4, 98, 158, 163, 106, 71, 164, 245, 60, 154, 8, 208, 12, 143, 73, 167, 148, 245, 13, 61, 65, 161, 161, 163, 16, 26, 104, 26, 13, 25, 13, 25, 0, 0, 1, 147, 76, 134, 135, 161, 16, 52, 100, 52, 200, 3, 38, 77, 3, 70, 33, 161, 166, 76, 76, 134, 70, 131, 70, 141, 50, 0, 208, 201, 145, 132, 49, 6, 70, 140, 38, 64, 0, 13, 24, 38, 77, 0, 0, 0, 104, 0, 16, 148, 161, 8, 42, 121, 52, 212, 0, 0, 0, 30, 161, 166, 77, 0, 0, 122, 154, 0, 245, 0, 0, 0, 0, 0, 0, 0, 0, 208, 0, 0, 0, 0, 13, 14, 244, 210, 154, 1, 166, 129, 161, 163, 67, 64, 104, 6, 134, 131, 33, 161, 137, 166, 64, 104, 12, 154, 6, 128, 52, 1, 160, 0, 26, 1, 166, 64, 104, 1, 161, 160, 49, 50, 104, 208, 104, 52, 2, 164, 132, 8, 18, 100, 212, 245, 79, 212, 153, 169, 168, 7, 181, 53, 27, 53, 60, 141, 72, 201, 145, 166, 128, 200, 52, 196, 6, 153, 25, 52, 217, 64, 100, 244, 4, 200, 13, 0, 104, 26, 3, 76, 153, 50, 100, 0, 1, 160, 208, 209, 146, 18, 188, 33, 2, 147, 50, 106, 39, 20, 85, 42, 153, 25, 69, 112, 178, 132, 90, 47, 165, 184, 27, 103, 93, 187, 130, 99, 140, 206, 5, 22, 186, 209, 193, 26, 41, 40, 223, 184, 221, 141, 172, 96, 213, 195, 36, 41, 91, 77, 110, 204, 138, 246, 254, 244, 145, 155, 140, 61, 15, 9, 234, 41, 39, 159, 55, 60, 7, 69, 186, 188, 142, 88, 241, 33, 13, 103, 10, 167, 133, 107, 122, 85, 152, 137, 33, 74, 132, 59, 84, 79, 22, 31, 63, 123, 201, 36, 49, 44, 66, 172, 251, 79, 65, 233, 110, 153, 12, 155, 12, 244, 33, 126, 71, 126, 224, 116, 178, 196, 73, 224, 67, 202, 230, 228, 59, 64, 209, 40, 91, 33, 187, 133, 111, 6, 243, 97, 218, 224, 174, 80, 204, 10, 96, 192, 193, 181, 6, 7, 130, 116, 244, 202, 177, 96, 199, 43, 142, 214, 51, 139, 116, 214, 129, 183, 40, 202, 180, 156, 110, 154, 98, 100, 187, 54, 93, 170, 213, 76, 182, 51, 0, 196, 6, 11, 9, 197, 48, 31, 27, 253, 19, 116, 13, 161, 9, 193, 8, 196, 124, 70, 89, 193, 193, 192, 180, 2, 190, 82, 193, 90, 193, 129, 87, 93, 118, 106, 106, 65, 241, 139, 185, 217, 25, 23, 39, 137, 10, 58, 142, 150, 13, 199, 158, 51, 86, 105, 163, 18, 144, 82, 84, 154, 114, 28, 97, 160, 208, 67, 12, 10, 97, 48, 71, 106, 100, 7, 21, 227, 245, 80, 123, 143, 115, 151, 47, 171, 208, 71, 53, 26, 25, 76, 253, 98, 254, 178, 122, 91, 102, 133, 166, 20, 145, 132, 194, 118, 83, 226, 71, 197, 142, 152, 168, 246, 189, 83, 101, 43, 22, 157, 93, 78, 171, 197, 125, 139, 233, 93, 103, 92, 82, 82, 78, 185, 58, 200, 168, 169, 74, 58, 209, 78, 47, 216, 120, 61, 63, 81, 246, 221, 180, 237, 167, 104, 237, 73, 40, 167, 105, 219, 142, 219, 196, 121, 222, 220, 82, 158, 47, 110, 42, 143, 84, 125, 153, 227, 73, 60, 97, 231, 207, 26, 73, 67, 35, 29, 8, 168, 36, 140, 17, 36, 84, 72, 2, 160, 137, 123, 186, 93, 17, 77, 204, 103, 9, 207, 140, 196, 242, 200, 109, 192, 182, 25, 194, 75, 117, 158, 104, 162, 46, 128, 66, 13, 3, 65, 12, 50, 43, 201, 36, 18, 9, 53, 150, 228, 232, 207, 172, 119, 139, 253, 146, 234, 40, 239, 158, 128, 242, 79, 31, 202, 71, 122, 59, 196, 168, 238, 45, 59, 209, 94, 134, 209, 232, 123, 209, 186, 85, 119, 84, 91, 117, 157, 219, 73, 234, 98, 222, 77, 169, 55, 205, 205, 167, 115, 235, 116, 60, 163, 202, 122, 15, 168, 113, 123, 220, 122, 132, 239, 15, 80, 205, 73, 235, 62, 20, 245, 94, 169, 215, 196, 167, 141, 31, 68, 47, 26, 148, 62, 173, 88, 34, 25, 8, 137, 61, 90, 24, 73, 11, 212, 152, 169, 155, 219, 222, 120, 120, 176, 136, 81, 111, 111, 177, 204, 227, 80, 107, 97, 40, 149, 42, 82, 196, 55, 50, 165, 36, 153, 13, 184, 35, 83, 125, 247, 223, 125, 253, 114, 223, 19, 154, 130, 196, 25, 200, 45, 213, 16, 228, 13, 173, 123, 158, 29, 176, 66, 126, 200, 50, 84, 54, 69, 142, 177, 171, 10, 216, 156, 227, 61, 149, 121, 24, 180, 210, 123, 46, 200, 235, 210, 225, 106, 205, 178, 149, 182, 106, 43, 31, 86, 96, 115, 195, 158, 26, 33, 158, 5, 119, 158, 175, 189, 34, 73, 218, 216, 107, 86, 81, 116, 19, 100, 155, 249, 134, 24, 94, 16, 128, 138, 232, 168, 17, 186, 96, 205, 141, 34, 11, 50, 150, 75, 47, 100, 189, 34, 124, 136, 87, 131, 40, 43, 143, 14, 55, 65, 195, 39, 133, 156, 103, 85, 97, 202, 91, 45, 140, 37, 12, 48, 128, 200, 128, 100, 197, 131, 136, 102, 45, 129, 119, 29, 174, 92, 44, 220, 114, 172, 13, 156, 213, 68, 185, 110, 197, 153, 150, 96, 73, 146, 88, 151, 45, 90, 34, 217, 171, 130, 51, 80, 166, 85, 199, 169, 81, 231, 165, 96, 59, 63, 233, 137, 56, 152, 93, 14, 145, 200, 116, 96, 151, 148, 26, 241, 109, 17, 165, 14, 227, 193, 145, 180, 134, 52, 226, 49, 82, 212, 140, 209, 129, 156, 115, 100, 155, 20, 195, 49, 48, 139, 243, 158, 108, 30, 211, 199, 200, 197, 10, 229, 145, 141, 27, 83, 239, 158, 191, 69, 199, 136, 41, 155, 113, 56, 128, 46, 73, 97, 134, 230, 116, 23, 60, 59, 165, 231, 24, 76, 93, 56, 74, 181, 248, 24, 82, 205, 23, 99, 98, 223, 195, 193, 222, 25, 169, 171, 40, 47, 191, 71, 77, 253, 225, 16, 190, 173, 129, 128, 235, 175, 153, 248, 56, 6, 91, 197, 234, 36, 34, 233, 84, 151, 250, 82, 98, 6, 144, 193, 230, 151, 92, 93, 105, 36, 254, 69, 120, 97, 124, 147, 112, 221, 102, 232, 164, 11, 41, 181, 231, 236, 237, 108, 146, 82, 98, 70, 77, 44, 102, 106, 186, 218, 73, 117, 194, 232, 155, 127, 85, 100, 138, 106, 173, 90, 45, 60, 177, 155, 25, 169, 152, 195, 73, 139, 182, 30, 193, 129, 140, 197, 180, 81, 69, 252, 37, 146, 108, 113, 126, 177, 33, 172, 107, 7, 14, 60, 141, 163, 148, 225, 6, 54, 56, 70, 96, 99, 13, 118, 247, 55, 208, 140, 90, 95, 195, 253, 191, 73, 230, 164, 67, 109, 8, 46, 56, 219, 151, 52, 139, 108, 51, 117, 6, 235, 77, 234, 153, 20, 57, 102, 160, 58, 235, 198, 224, 223, 27, 243, 52, 112, 128, 123, 67, 61, 8, 243, 65, 30, 134, 39, 161, 232, 71, 37, 25, 93, 183, 219, 125, 142, 254, 80, 9, 176, 234, 148, 209, 12, 172, 104, 116, 74, 58, 222, 9, 193, 129, 249, 235, 71, 229, 210, 215, 26, 254, 237, 197, 48, 195, 42, 83, 36, 67, 56, 20, 250, 149, 215, 212, 196, 91, 179, 117, 16, 136, 48, 198, 28, 76, 56, 159, 11, 253, 191, 123, 219, 33, 121, 62, 39, 199, 60, 120, 46, 47, 115, 203, 52, 253, 3, 213, 209, 80, 254, 147, 245, 202, 14, 105, 74, 165, 55, 80, 230, 156, 64, 244, 241, 112, 134, 161, 197, 197, 191, 189, 214, 67, 28, 118, 8, 198, 26, 114, 144, 143, 17, 162, 82, 46, 81, 196, 116, 77, 205, 234, 159, 204, 233, 48, 95, 95, 0, 137, 120, 154, 40, 222, 227, 41, 75, 11, 11, 44, 25, 134, 220, 48, 157, 199, 49, 13, 229, 30, 131, 55, 160, 186, 127, 181, 121, 98, 139, 65, 250, 73, 255, 112, 215, 72, 19, 214, 170, 24, 131, 27, 138, 115, 108, 60, 84, 221, 244, 205, 199, 13, 188, 129, 45, 36, 206, 151, 175, 33, 111, 146, 198, 43, 184, 79, 150, 60, 129, 153, 59, 2, 189, 8, 1, 124, 143, 177, 87, 108, 7, 80, 106, 56, 204, 102, 20, 205, 223, 20, 213, 129, 111, 63, 139, 190, 212, 14, 204, 208, 236, 51, 59, 146, 244, 166, 74, 118, 36, 251, 167, 71, 165, 52, 32, 66, 16, 132, 8, 66, 16, 129, 8, 67, 116, 221, 38, 14, 251, 169, 113, 18, 36, 66, 49, 139, 38, 76, 140, 178, 201, 147, 38, 24, 118, 29, 222, 232, 220, 110, 119, 251, 255, 118, 231, 244, 222, 171, 191, 204, 55, 157, 145, 96, 3, 12, 171, 184, 37, 65, 211, 74, 21, 184, 72, 85, 135, 46, 185, 131, 46, 138, 158, 197, 143, 50, 208, 180, 48, 1, 128, 6, 6, 21, 21, 114, 203, 252, 199, 224, 116, 113, 123, 14, 104, 97, 12, 51, 72, 122, 233, 168, 60, 9, 15, 124, 116, 14, 129, 208, 142, 133, 55, 183, 54, 198, 52, 14, 49, 153, 27, 163, 184, 18, 124, 124, 254, 239, 180, 202, 108, 110, 158, 198, 50, 66, 44, 94, 129, 16, 132, 19, 74, 245, 41, 240, 253, 181, 236, 151, 176, 56, 148, 149, 54, 88, 210, 160, 26, 43, 84, 217, 5, 87, 80, 184, 148, 49, 233, 88, 183, 214, 222, 69, 182, 132, 109, 116, 133, 66, 131, 193, 55, 186, 78, 185, 198, 148, 85, 118, 105, 93, 151, 101, 78, 167, 150, 240, 24, 103, 12, 109, 95, 54, 175, 152, 43, 85, 160, 224, 170, 255, 5, 158, 239, 178, 236, 241, 239, 94, 48, 241, 181, 34, 10, 146, 180, 212, 21, 38, 140, 140, 114, 117, 88, 152, 37, 0, 53, 195, 60, 57, 26, 176, 16, 111, 136, 52, 46, 219, 162, 86, 222, 215, 52, 114, 229, 195, 85, 90, 236, 133, 131, 170, 188, 152, 243, 146, 59, 157, 206, 231, 113, 230, 114, 62, 140, 230, 57, 158, 119, 135, 24, 59, 2, 246, 103, 150, 114, 213, 21, 44, 137, 152, 27, 6, 126, 230, 30, 62, 61, 38, 208, 147, 130, 74, 229, 188, 111, 241, 13, 122, 236, 248, 204, 73, 18, 248, 72, 1, 18, 68, 33, 192, 16, 39, 22, 231, 93, 189, 117, 235, 215, 184, 75, 142, 232, 235, 10, 4, 168, 214, 42, 56, 184, 159, 219, 177, 159, 175, 192, 108, 242, 54, 220, 220, 140, 88, 154, 115, 82, 225, 46, 238, 73, 101, 147, 32, 117, 161, 76, 40, 40, 147, 38, 106, 228, 59, 59, 91, 120, 39, 152, 36, 53, 245, 67, 193, 100, 85, 70, 83, 46, 252, 166, 253, 109, 155, 161, 133, 97, 166, 71, 132, 130, 18, 10, 144, 167, 207, 170, 230, 92, 9, 33, 62, 80, 83, 151, 124, 153, 26, 208, 206, 108, 187, 237, 39, 97, 116, 199, 111, 97, 67, 196, 34, 147, 124, 213, 211, 197, 135, 76, 188, 111, 19, 147, 117, 134, 179, 145, 147, 12, 113, 16, 31, 10, 234, 234, 108, 232, 239, 230, 108, 91, 50, 140, 99, 99, 132, 56, 113, 176, 40, 131, 140, 200, 168, 147, 140, 154, 148, 26, 132, 84, 114, 149, 103, 44, 47, 45, 180, 193, 198, 88, 20, 246, 48, 218, 102, 136, 195, 51, 175, 56, 218, 119, 44, 219, 102, 150, 241, 186, 218, 202, 118, 162, 129, 81, 67, 80, 64, 128, 179, 49, 35, 49, 35, 49, 25, 137, 149, 52, 112, 156, 39, 32, 235, 141, 253, 139, 214, 207, 105, 123, 21, 87, 202, 183, 60, 28, 7, 92, 144, 153, 38, 25, 153, 147, 48, 152, 194, 195, 153, 141, 116, 30, 40, 201, 240, 32, 247, 18, 245, 248, 254, 199, 10, 239, 202, 39, 132, 251, 225, 39, 217, 0, 69, 111, 107, 95, 43, 22, 12, 46, 103, 43, 157, 203, 248, 117, 187, 44, 174, 71, 73, 106, 111, 167, 198, 215, 243, 121, 58, 223, 7, 111, 175, 213, 249, 158, 127, 55, 187, 222, 233, 249, 7, 248, 217, 67, 3, 128, 195, 50, 49, 137, 224, 48, 200, 168, 205, 64, 112, 76, 17, 0, 16, 0, 104, 223, 176, 128, 1, 0, 4, 0, 131, 6, 10, 40, 97, 246, 197, 62, 126, 138, 183, 183, 185, 71, 124, 222, 13, 132, 171, 173, 79, 22, 247, 62, 178, 181, 28, 150, 221, 57, 188, 143, 87, 230, 213, 212, 161, 202, 213, 223, 211, 210, 230, 115, 126, 94, 118, 182, 183, 19, 137, 55, 101, 88, 92, 62, 30, 189, 97, 108, 193, 131, 128, 149, 216, 153, 0, 193, 17, 142, 44, 105, 133, 47, 174, 222, 250, 153, 245, 39, 62, 72, 189, 119, 245, 250, 227, 233, 191, 179, 156, 57, 253, 184, 237, 207, 238, 245, 129, 1, 255, 51, 142, 72, 194, 236, 83, 60, 100, 228, 24, 102, 243, 23, 162, 29, 225, 231, 177, 239, 79, 59, 203, 14, 63, 142, 252, 199, 169, 86, 215, 122, 80, 39, 189, 242, 192, 39, 9, 71, 158, 7, 30, 73, 150, 28, 142, 172, 42, 152, 150, 84, 245, 229, 249, 237, 6, 43, 23, 51, 147, 92, 242, 230, 216, 83, 255, 170, 113, 91, 234, 174, 139, 41, 209, 143, 72, 125, 19, 187, 72, 146, 105, 234, 150, 251, 76, 76, 71, 170, 82, 14, 154, 253, 253, 39, 231, 135, 201, 231, 121, 221, 84, 245, 207, 237, 131, 80, 76, 24, 9, 239, 223, 178, 219, 97, 6, 24, 182, 73, 27, 163, 92, 170, 0, 198, 111, 80, 244, 93, 168, 74, 86, 236, 78, 118, 107, 211, 211, 167, 130, 166, 77, 128, 73, 99, 48, 44, 133, 147, 52, 133, 20, 182, 222, 171, 211, 215, 191, 231, 35, 113, 31, 241, 7, 253, 234, 171, 75, 84, 249, 36, 65, 233, 29, 205, 110, 96, 229, 82, 143, 241, 103, 48, 181, 19, 120, 57, 133, 5, 83, 122, 126, 241, 189, 40, 70, 198, 155, 201, 36, 23, 153, 0, 145, 154, 65, 127, 22, 60, 126, 213, 186, 96, 102, 158, 152, 222, 221, 207, 51, 253, 122, 110, 232, 5, 213, 76, 146, 97, 30, 112, 76, 74, 61, 227, 105, 12, 148, 80, 134, 18, 171, 63, 79, 78, 245, 252, 249, 22, 148, 174, 126, 72, 146, 118, 3, 103, 231, 203, 5, 36, 95, 32, 231, 4, 46, 204, 94, 49, 152, 25, 23, 114, 246, 234, 29, 72, 136, 200, 153, 131, 195, 163, 117, 148, 208, 253, 95, 231, 1, 167, 16, 71, 182, 129, 248, 111, 173, 3, 7, 207, 176, 175, 2, 11, 151, 180, 46, 81, 81, 236, 204, 11, 151, 162, 148, 79, 89, 240, 190, 63, 175, 194, 249, 99, 47, 218, 135, 213, 147, 209, 62, 157, 69, 165, 228, 93, 179, 226, 251, 125, 237, 119, 239, 124, 59, 233, 157, 217, 180, 246, 156, 118, 219, 243, 118, 126, 54, 205, 39, 164, 190, 78, 73, 7, 20, 213, 57, 56, 165, 35, 71, 95, 209, 125, 61, 33, 195, 228, 28, 96, 188, 195, 64, 129, 90, 117, 47, 51, 57, 222, 3, 212, 191, 113, 166, 175, 109, 224, 251, 85, 217, 179, 123, 44, 123, 51, 245, 12, 199, 39, 6, 174, 234, 155, 31, 246, 207, 239, 56, 232, 187, 205, 41, 183, 135, 147, 205, 91, 115, 34, 155, 141, 203, 156, 143, 9, 70, 220, 52, 104, 209, 120, 29, 132, 225, 97, 11, 130, 240, 48, 88, 21, 148, 22, 215, 225, 128, 232, 133, 53, 148, 7, 46, 134, 102, 102, 111, 174, 118, 40, 121, 126, 163, 113, 183, 209, 71, 102, 59, 3, 181, 218, 210, 239, 49, 230, 219, 56, 169, 13, 30, 221, 167, 29, 177, 51, 221, 53, 225, 125, 199, 35, 59, 239, 73, 115, 93, 94, 186, 124, 62, 115, 156, 155, 221, 142, 9, 206, 105, 55, 154, 227, 73, 203, 209, 66, 89, 192, 231, 84, 76, 41, 165, 92, 233, 66, 146, 133, 113, 112, 228, 122, 149, 131, 146, 176, 223, 180, 143, 122, 14, 17, 164, 21, 11, 41, 68, 131, 21, 207, 132, 98, 136, 4, 75, 149, 171, 158, 42, 4, 69, 68, 185, 101, 7, 100, 153, 13, 116, 76, 139, 147, 207, 98, 116, 221, 78, 131, 115, 111, 197, 182, 231, 178, 169, 213, 174, 77, 14, 51, 136, 196, 116, 170, 115, 21, 155, 41, 148, 227, 50, 75, 151, 131, 44, 234, 49, 92, 155, 235, 168, 99, 201, 209, 196, 37, 65, 174, 52, 116, 92, 95, 45, 9, 44, 133, 122, 208, 79, 204, 165, 14, 34, 202, 237, 123, 239, 189, 39, 78, 156, 19, 200, 153, 131, 30, 8, 253, 214, 227, 115, 49, 82, 76, 42, 45, 176, 126, 43, 72, 219, 115, 226, 69, 190, 13, 179, 208, 94, 137, 84, 178, 190, 227, 104, 182, 246, 44, 221, 225, 153, 117, 236, 201, 201, 132, 12, 169, 176, 176, 164, 189, 133, 248, 41, 149, 242, 247, 236, 228, 161, 48, 216, 46, 121, 28, 69, 218, 59, 60, 25, 113, 190, 17, 174, 166, 182, 215, 73, 199, 51, 51, 222, 78, 110, 126, 119, 122, 138, 94, 249, 153, 157, 134, 197, 201, 116, 241, 149, 214, 188, 123, 67, 222, 191, 29, 151, 23, 61, 85, 110, 110, 53, 25, 71, 242, 111, 211, 126, 45, 232, 212, 15, 36, 152, 152, 7, 229, 96, 135, 103, 70, 10, 106, 158, 159, 168, 77, 81, 7, 149, 126, 102, 36, 168, 138, 30, 8, 118, 171, 40, 178, 153, 84, 156, 92, 209, 146, 165, 82, 157, 80, 82, 21, 11, 142, 98, 74, 139, 46, 25, 211, 150, 20, 152, 75, 72, 23, 71, 226, 72, 207, 239, 17, 112, 31, 44, 40, 15, 38, 48, 13, 20, 22, 81, 71, 22, 186, 50, 63, 170, 83, 74, 11, 114, 36, 113, 227, 27, 6, 253, 61, 54, 152, 101, 25, 19, 204, 44, 213, 36, 107, 175, 135, 68, 250, 172, 137, 132, 172, 201, 190, 85, 156, 214, 86, 149, 139, 25, 64, 14, 94, 50, 13, 47, 12, 108, 230, 168, 48, 160, 175, 46, 18, 227, 0, 148, 117, 244, 142, 72, 156, 97, 187, 110, 126, 183, 67, 152, 111, 71, 132, 60, 225, 71, 59, 196, 174, 87, 60, 48, 59, 224, 96, 144, 23, 91, 137, 5, 237, 58, 247, 144, 125, 251, 69, 17, 103, 25, 11, 198, 65, 36, 65, 108, 38, 16, 81, 248, 93, 178, 194, 201, 82, 6, 176, 122, 200, 124, 46, 59, 245, 41, 83, 195, 87, 250, 97, 68, 163, 242, 0, 24, 77, 108, 224, 11, 4, 26, 198, 49, 103, 145, 202, 104, 182, 31, 18, 180, 102, 136, 70, 108, 60, 138, 52, 9, 214, 98, 204, 117, 58, 42, 248, 158, 184, 38, 135, 105, 56, 163, 105, 136, 155, 84, 158, 4, 195, 207, 108, 219, 163, 53, 156, 84, 165, 41, 133, 177, 217, 229, 86, 165, 89, 178, 176, 163, 77, 239, 219, 180, 116, 84, 116, 60, 26, 191, 75, 44, 167, 246, 188, 88, 31, 72, 37, 15, 64, 125, 1, 224, 15, 8, 3, 217, 104, 166, 10, 10, 83, 219, 147, 138, 145, 20, 87, 2, 114, 130, 34, 146, 136, 160, 156, 147, 196, 153, 8, 215, 217, 199, 181, 113, 138, 59, 17, 90, 134, 108, 147, 91, 59, 230, 134, 114, 52, 227, 160, 61, 80, 74, 205, 49, 49, 77, 82, 21, 85, 50, 208, 31, 62, 54, 212, 177, 76, 178, 132, 180, 43, 32, 116, 241, 85, 122, 28, 231, 111, 37, 93, 221, 222, 45, 30, 51, 210, 244, 130, 15, 121, 11, 6, 69, 247, 237, 168, 18, 142, 0, 95, 101, 158, 8, 28, 130, 77, 52, 166, 204, 224, 244, 125, 175, 248, 62, 3, 211, 123, 135, 219, 251, 39, 180, 115, 127, 159, 15, 231, 229, 201, 122, 178, 185, 89, 62, 15, 142, 144, 122, 245, 37, 41, 42, 41, 10, 203, 55, 86, 154, 58, 10, 119, 7, 226, 129, 148, 130, 19, 178, 198, 232, 169, 250, 242, 15, 24, 0, 170, 160, 2, 110, 143, 76, 128, 115, 128, 65, 154, 216, 54, 11, 6, 15, 153, 226, 60, 22, 66, 41, 74, 18, 47, 114, 21, 244, 72, 38, 4, 190, 53, 253, 224, 58, 37, 164, 152, 145, 30, 34, 162, 146, 216, 42, 228, 145, 114, 176, 188, 147, 3, 99, 77, 75, 20, 89, 84, 150, 180, 124, 234, 19, 151, 107, 154, 138, 103, 153, 146, 213, 106, 206, 246, 93, 105, 77, 136, 57, 106, 97, 26, 2, 148, 32, 8, 68, 229, 27, 115, 156, 230, 34, 9, 0, 208, 33, 244, 135, 0, 147, 36, 1, 196, 151, 7, 41, 82, 72, 100, 151, 210, 88, 55, 76, 99, 109, 52, 85, 51, 5, 182, 36, 243, 48, 148, 19, 4, 74, 68, 8, 26, 138, 46, 24, 94, 220, 14, 140, 13, 0, 20, 148, 1, 16, 133, 36, 192, 36, 137, 34, 68, 130, 39, 152, 62, 96, 61, 121, 218, 67, 37, 4, 69, 17, 36, 40, 117, 148, 40, 80, 89, 129, 161, 161, 5, 196, 197, 227, 158, 232, 224, 73, 3, 212, 128, 60, 222, 7, 37, 2, 226, 82, 69, 200, 67, 64, 55, 119, 250, 239, 51, 70, 118, 134, 117, 85, 122, 44, 164, 138, 139, 73, 35, 97, 83, 24, 26, 105, 166, 152, 134, 98, 146, 182, 71, 36, 154, 229, 169, 198, 19, 117, 66, 148, 141, 98, 96, 164, 53, 164, 178, 164, 50, 221, 186, 232, 200, 202, 197, 136, 107, 197, 56, 140, 3, 164, 194, 79, 86, 12, 135, 92, 171, 155, 191, 191, 191, 129, 219, 171, 176, 66, 96, 94, 217, 52, 161, 67, 64, 156, 33, 152, 60, 156, 4, 204, 73, 201, 49, 34, 56, 166, 86, 67, 174, 238, 238, 233, 229, 236, 14, 235, 147, 168, 151, 30, 112, 78, 111, 24, 30, 73, 70, 148, 160, 73, 200, 117, 25, 70, 32, 122, 110, 216, 120, 169, 199, 4, 24, 53, 103, 48, 120, 184, 39, 16, 56, 194, 149, 156, 97, 152, 152, 116, 196, 224, 159, 11, 191, 195, 183, 103, 162, 246, 9, 19, 49, 131, 70, 118, 177, 157, 226, 226, 187, 153, 153, 6, 194, 108, 78, 48, 86, 154, 28, 24, 80, 163, 108, 73, 198, 162, 194, 138, 127, 52, 191, 255, 93, 131, 12, 47, 140, 179, 170, 82, 74, 174, 230, 51, 6, 49, 68, 196, 193, 141, 162, 141, 170, 131, 191, 10, 114, 84, 142, 45, 37, 180, 22, 216, 196, 85, 77, 88, 157, 223, 193, 55, 7, 20, 107, 56, 213, 52, 106, 140, 111, 96, 4, 241, 169, 236, 94, 190, 183, 158, 7, 166, 168, 27, 67, 129, 21, 33, 77, 36, 141, 190, 117, 70, 202, 162, 84, 81, 172, 180, 108, 117, 20, 168, 180, 245, 213, 190, 55, 200, 181, 110, 111, 176, 46, 46, 55, 90, 97, 11, 131, 33, 211, 200, 189, 39, 203, 141, 179, 141, 157, 21, 22, 163, 69, 173, 21, 90, 131, 226, 194, 7, 85, 60, 39, 96, 198, 72, 160, 157, 182, 118, 104, 43, 202, 23, 11, 142, 48, 102, 9, 196, 112, 136, 131, 46, 3, 156, 158, 69, 172, 85, 212, 139, 69, 213, 101, 41, 75, 174, 41, 107, 244, 116, 3, 84, 89, 144, 13, 160, 200, 132, 48, 163, 104, 176, 56, 96, 121, 216, 142, 171, 22, 198, 214, 49, 21, 181, 149, 133, 152, 113, 24, 122, 111, 53, 32, 56, 244, 140, 103, 57, 31, 21, 162, 18, 146, 40, 100, 185, 41, 148, 216, 34, 46, 184, 15, 58, 80, 123, 128, 142, 180, 245, 177, 225, 131, 85, 71, 65, 79, 2, 4, 237, 176, 8, 237, 162, 221, 58, 1, 217, 196, 20, 65, 221, 6, 56, 33, 153, 12, 65, 181, 156, 108, 51, 49, 26, 11, 156, 56, 41, 200, 10, 124, 238, 40, 243, 134, 128, 136, 164, 162, 216, 211, 70, 177, 28, 202, 102, 185, 7, 87, 183, 30, 47, 66, 20, 48, 67, 166, 54, 77, 6, 8, 13, 145, 94, 139, 214, 14, 9, 227, 131, 29, 141, 9, 140, 29, 123, 24, 209, 224, 112, 168, 233, 212, 5, 194, 116, 14, 184, 193, 98, 49, 212, 234, 30, 7, 103, 8, 19, 178, 6, 73, 90, 37, 105, 64, 132, 9, 89, 25, 32, 38, 0, 160, 74, 6, 8, 2, 96, 38, 1, 146, 137, 19, 157, 154, 142, 187, 5, 6, 138, 55, 126, 77, 60, 217, 3, 34, 74, 154, 65, 52, 169, 90, 153, 4, 34, 81, 210, 17, 16, 153, 145, 146, 146, 115, 72, 153, 9, 13, 61, 199, 167, 60, 243, 139, 214, 18, 235, 21, 93, 78, 70, 163, 143, 3, 72, 9, 72, 72, 73, 27, 9, 161, 41, 2, 149, 73, 212, 32, 233, 106, 66, 145, 209, 147, 38, 81, 192, 146, 37, 8, 16, 84, 14, 147, 70, 130, 54, 72, 201, 138, 93, 80, 1, 167, 0, 66, 5, 28, 58, 157, 78, 35, 210, 88, 132, 74, 174, 165, 91, 16, 228, 160, 28, 103, 5, 0, 154, 74, 182, 16, 164, 235, 215, 27, 103, 24, 192, 242, 232, 107, 27, 108, 236, 211, 78, 177, 68, 21, 177, 141, 85, 75, 68, 178, 173, 41, 98, 53, 114, 112, 87, 26, 106, 114, 139, 89, 108, 75, 193, 81, 12, 147, 57, 39, 11, 72, 91, 106, 35, 101, 19, 90, 130, 213, 18, 200, 93, 10, 193, 192, 52, 153, 78, 1, 197, 168, 32, 194, 242, 34, 11, 0, 91, 104, 78, 0, 103, 156, 4, 56, 71, 0, 96, 19, 25, 194, 100, 32, 120, 201, 145, 51, 57, 153, 204, 9, 196, 30, 65, 149, 147, 144, 96, 230, 219, 152, 32, 225, 212, 100, 224, 188, 89, 114, 129, 140, 137, 199, 168, 33, 82, 51, 66, 211, 75, 74, 131, 134, 105, 155, 12, 146, 145, 122, 232, 166, 122, 231, 149, 17, 26, 31, 15, 39, 148, 233, 211, 183, 113, 206, 82, 93, 198, 76, 70, 213, 223, 233, 222, 29, 19, 164, 232, 117, 181, 177, 7, 135, 135, 129, 193, 235, 19, 29, 116, 120, 187, 192, 199, 0, 58, 41, 136, 34, 3, 73, 221, 221, 141, 183, 42, 232, 101, 161, 177, 103, 26, 54, 89, 160, 61, 108, 165, 3, 160, 20, 146, 2, 8, 8, 235, 177, 52, 21, 80, 48, 40, 193, 0, 209, 21, 5, 41, 67, 226, 148, 242, 66, 58, 5, 52, 128, 104, 84, 208, 138, 241, 216, 3, 206, 188, 255, 52, 29, 202, 27, 220, 168, 150, 116, 152, 181, 116, 38, 228, 178, 109, 72, 213, 53, 107, 43, 86, 105, 147, 58, 71, 100, 59, 117, 58, 189, 195, 15, 152, 178, 75, 9, 147, 11, 47, 143, 185, 136, 122, 15, 34, 140, 36, 180, 154, 222, 204, 73, 182, 188, 237, 153, 51, 50, 201, 145, 147, 78, 157, 80, 227, 192, 181, 27, 104, 165, 93, 117, 46, 189, 150, 44, 51, 188, 151, 22, 181, 117, 94, 99, 2, 90, 80, 34, 116, 131, 186, 160, 165, 161, 136, 78, 65, 200, 232, 113, 200, 48, 99, 156, 30, 70, 143, 44, 156, 193, 128, 124, 176, 41, 64, 188, 132, 39, 192, 245, 238, 155, 144, 152, 97, 132, 194, 98, 35, 8, 162, 93, 37, 73, 203, 56, 154, 214, 87, 180, 132, 189, 181, 92, 145, 125, 173, 27, 148, 23, 102, 177, 191, 43, 38, 117, 47, 201, 202, 178, 45, 89, 138, 138, 100, 153, 81, 133, 219, 216, 189, 210, 103, 57, 111, 184, 106, 43, 46, 21, 98, 242, 82, 55, 238, 68, 205, 172, 197, 228, 133, 140, 217, 99, 2, 150, 181, 82, 89, 190, 180, 169, 85, 51, 86, 13, 244, 91, 125, 146, 88, 50, 20, 45, 38, 116, 115, 52, 110, 103, 187, 125, 181, 182, 115, 51, 54, 76, 242, 91, 54, 133, 140, 202, 46, 46, 75, 21, 33, 194, 40, 106, 149, 69, 14, 166, 109, 151, 140, 219, 53, 219, 100, 100, 108, 138, 141, 117, 171, 44, 212, 209, 18, 232, 155, 170, 73, 45, 179, 89, 102, 83, 130, 203, 42, 99, 73, 174, 132, 69, 242, 201, 47, 19, 90, 134, 52, 104, 105, 158, 148, 84, 82, 51, 12, 76, 90, 110, 211, 67, 92, 68, 197, 32, 52, 80, 160, 255, 248, 187, 146, 41, 194, 132, 133, 218, 75, 243, 160 };

