#include <Core/Gen4/StaticTemplate4.hpp>
#include <array>

constexpr std::array<StaticTemplate4, 12> STARTERS = { StaticTemplate4(Game::DPPt, 387, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::DPPt, 390, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::DPPt, 393, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 1, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 4, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 7, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 152, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 155, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 158, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 252, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 255, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 258, 0, Shiny::Random, 5, Method::Method1) };

constexpr std::array<StaticTemplate4, 7> FOSSILS = { StaticTemplate4(Game::Gen4, 138, 0, Shiny::Random, 20, Method::Method1), StaticTemplate4(Game::Gen4, 140, 0, Shiny::Random, 20, Method::Method1), StaticTemplate4(Game::Gen4, 142, 0, Shiny::Random, 20, Method::Method1), StaticTemplate4(Game::Gen4, 345, 0, Shiny::Random, 20, Method::Method1), StaticTemplate4(Game::Gen4, 347, 0, Shiny::Random, 20, Method::Method1), StaticTemplate4(Game::Gen4, 408, 0, Shiny::Random, 20, Method::Method1), StaticTemplate4(Game::Gen4, 410, 0, Shiny::Random, 20, Method::Method1) };

constexpr std::array<StaticTemplate4, 14> GIFTS = { StaticTemplate4(Game::DP, 133, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::Platinum, 133, 0, Shiny::Random, 20, Method::Method1), StaticTemplate4(Game::Platinum, 137, 0, Shiny::Random, 25, Method::Method1), StaticTemplate4(Game::Platinum, 175, 0, Shiny::Random, 1, Method::Method1), StaticTemplate4(Game::DP, 440, 0, Shiny::Random, 1, Method::Method1), StaticTemplate4(Game::DPPt, 447, 0, Shiny::Random, 1, Method::Method1), StaticTemplate4(Game::HGSS, 72, 0, Shiny::Random, 15, Method::Method1), StaticTemplate4(Game::HGSS, 133, 0, Shiny::Random, 5, Method::Method1), StaticTemplate4(Game::HGSS, 147, 0, Shiny::Random, 15, Method::Method1), StaticTemplate4(Game::HGSS, 236, 0, Shiny::Random, 10, Method::Method1), StaticTemplate4(Game::HGSS, 175, 0, Shiny::Random, 1, Method::Method1), StaticTemplate4(Game::HGSS, 179, 0, Shiny::Random, 1, Method::Method1), StaticTemplate4(Game::HGSS, 194, 0, Shiny::Random, 1, Method::Method1), StaticTemplate4(Game::HGSS, 218, 0, Shiny::Random, 1, Method::Method1) };

constexpr std::array<StaticTemplate4, 7> GAMECORNER = { StaticTemplate4(Game::HGSS, 122, 0, Shiny::Random, 15, Method::Method1), StaticTemplate4(Game::HGSS, 133, 0, Shiny::Random, 15, Method::Method1), StaticTemplate4(Game::HGSS, 137, 0, Shiny::Random, 15, Method::Method1), StaticTemplate4(Game::HGSS, 63, 0, Shiny::Random, 15, Method::Method1), StaticTemplate4(Game::HeartGold, 23, 0, Shiny::Random, 15, Method::Method1), StaticTemplate4(Game::SoulSilver, 27, 0, Shiny::Random, 15, Method::Method1), StaticTemplate4(Game::HGSS, 147, 0, Shiny::Random, 15, Method::Method1) };

constexpr std::array<StaticTemplate4, 13> STATIONARY = { StaticTemplate4(Game::DP, 425, 0, Shiny::Random, 22, Method::MethodJ), StaticTemplate4(Game::Platinum, 425, 0, Shiny::Random, 15, Method::MethodJ), StaticTemplate4(Game::DP, 479, 0, Shiny::Random, 15, Method::MethodJ), StaticTemplate4(Game::Platinum, 479, 0, Shiny::Random, 20, Method::MethodJ), StaticTemplate4(Game::DPPt, 442, 0, Shiny::Random, 25, Method::MethodJ), StaticTemplate4(Game::HGSS, 100, 0, Shiny::Random, 23, Method::MethodK), StaticTemplate4(Game::HGSS, 74, 0, Shiny::Random, 21, Method::MethodK), StaticTemplate4(Game::HGSS, 109, 0, Shiny::Random, 21, Method::MethodK), StaticTemplate4(Game::HGSS, 130, 0, Shiny::Always, 30, Method::Method1), StaticTemplate4(Game::HGSS, 131, 0, Shiny::Random, 20, Method::MethodK), StaticTemplate4(Game::HGSS, 101, 0, Shiny::Random, 23, Method::MethodK), StaticTemplate4(Game::HGSS, 143, 0, Shiny::Random, 50, Method::MethodK), StaticTemplate4(Game::HGSS, 185, 0, Shiny::Random, 20, Method::MethodK) };

constexpr std::array<StaticTemplate4, 33> LEGENDS = { StaticTemplate4(Game::Platinum, 377, 0, Shiny::Random, 30, Method::MethodJ), StaticTemplate4(Game::Platinum, 378, 0, Shiny::Random, 30, Method::MethodJ), StaticTemplate4(Game::Platinum, 379, 0, Shiny::Random, 30, Method::MethodJ), StaticTemplate4(Game::DPPt, 480, 0, Shiny::Random, 50, Method::MethodJ), StaticTemplate4(Game::DPPt, 482, 0, Shiny::Random, 50, Method::MethodJ), StaticTemplate4(Game::Diamond, 483, 0, Shiny::Random, 47, Method::MethodJ), StaticTemplate4(Game::Pearl, 484, 0, Shiny::Random, 47, Method::MethodJ), StaticTemplate4(Game::Platinum, 483, 0, Shiny::Random, 70, Method::MethodJ), StaticTemplate4(Game::Platinum, 484, 0, Shiny::Random, 70, Method::MethodJ), StaticTemplate4(Game::DP, 485, 0, Shiny::Random, 70, Method::MethodJ), StaticTemplate4(Game::Platinum, 485, 0, Shiny::Random, 50, Method::MethodJ), StaticTemplate4(Game::DP, 486, 0, Shiny::Random, 70, Method::MethodJ), StaticTemplate4(Game::Platinum, 486, 0, Shiny::Random, 1, Method::MethodJ), StaticTemplate4(Game::DP, 487, 0, Shiny::Random, 70, Method::MethodJ), StaticTemplate4(Game::Platinum, 487, 0, Shiny::Random, 47, Method::MethodJ), StaticTemplate4(Game::Platinum, 487, 1, Shiny::Random, 47, Method::MethodJ), StaticTemplate4(Game::HGSS, 144, 0, Shiny::Random, 50, Method::MethodK), StaticTemplate4(Game::HGSS, 145, 0, Shiny::Random, 50, Method::MethodK), StaticTemplate4(Game::HGSS, 146, 0, Shiny::Random, 50, Method::MethodK), StaticTemplate4(Game::HGSS, 150, 0, Shiny::Random, 70, Method::MethodK), StaticTemplate4(Game::HGSS, 245, 0, Shiny::Random, 40, Method::MethodK), StaticTemplate4(Game::HeartGold, 249, 0, Shiny::Random, 70, Method::MethodK), StaticTemplate4(Game::SoulSilver, 249, 0, Shiny::Random, 45, Method::MethodK), StaticTemplate4(Game::HeartGold, 250, 0, Shiny::Random, 45, Method::MethodK), StaticTemplate4(Game::SoulSilver, 250, 0, Shiny::Random, 70, Method::MethodK), StaticTemplate4(Game::HeartGold, 381, 0, Shiny::Random, 40, Method::MethodK), StaticTemplate4(Game::SoulSilver, 380, 0, Shiny::Random, 40, Method::MethodK), StaticTemplate4(Game::HeartGold, 382, 0, Shiny::Random, 50, Method::MethodK), StaticTemplate4(Game::SoulSilver, 383, 0, Shiny::Random, 50, Method::MethodK), StaticTemplate4(Game::HGSS, 384, 0, Shiny::Random, 50, Method::MethodK), StaticTemplate4(Game::HGSS, 483, 0, Shiny::Random, 1, Method::Method1), StaticTemplate4(Game::HGSS, 484, 0, Shiny::Random, 1, Method::Method1), StaticTemplate4(Game::HGSS, 487, 1, Shiny::Random, 1, Method::Method1) };

constexpr std::array<StaticTemplate4, 3> EVENTS = { StaticTemplate4(Game::Gen4, 490, 0, Shiny::Never, 1, Method::Method1), StaticTemplate4(Game::Platinum, 491, 0, Shiny::Random, 50, Method::MethodJ), StaticTemplate4(Game::Platinum, 492, 0, Shiny::Random, 30, Method::MethodJ) };

constexpr std::array<StaticTemplate4, 9> ROAMERS = { StaticTemplate4(Game::DPPt, 481, 0, Shiny::Random, 50, Method::Method1), StaticTemplate4(Game::DPPt, 488, 0, Shiny::Random, 50, Method::Method1), StaticTemplate4(Game::Platinum, 144, 0, Shiny::Random, 60, Method::Method1), StaticTemplate4(Game::Platinum, 145, 0, Shiny::Random, 60, Method::Method1), StaticTemplate4(Game::Platinum, 146, 0, Shiny::Random, 60, Method::Method1), StaticTemplate4(Game::HGSS, 243, 0, Shiny::Random, 40, Method::Method1), StaticTemplate4(Game::HGSS, 244, 0, Shiny::Random, 40, Method::Method1), StaticTemplate4(Game::HeartGold, 380, 0, Shiny::Random, 35, Method::Method1), StaticTemplate4(Game::SoulSilver, 381, 0, Shiny::Random, 35, Method::Method1) };

constexpr std::array<u8, 4191> DIAMOND = { 236, 82, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 181, 133, 28, 158, 0, 0, 185, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 215, 221, 255, 255, 254, 125, 255, 255, 255, 255, 255, 255, 172, 185, 125, 234, 253, 232, 141, 225, 0, 96, 18, 221, 245, 119, 182, 20, 168, 245, 171, 183, 118, 149, 157, 206, 59, 45, 41, 42, 136, 220, 57, 138, 130, 85, 231, 221, 128, 1, 242, 0, 0, 213, 0, 132, 0, 160, 74, 36, 147, 77, 83, 244, 244, 19, 84, 253, 41, 250, 166, 216, 148, 123, 84, 253, 0, 79, 18, 98, 155, 83, 242, 166, 218, 167, 167, 170, 55, 169, 54, 106, 158, 70, 167, 147, 34, 121, 35, 79, 105, 52, 17, 160, 100, 218, 134, 131, 212, 109, 32, 6, 128, 0, 0, 208, 0, 52, 3, 64, 0, 60, 52, 210, 130, 73, 64, 140, 70, 154, 100, 200, 38, 70, 34, 98, 158, 169, 249, 81, 248, 19, 83, 83, 76, 158, 167, 233, 27, 77, 39, 169, 63, 37, 51, 83, 71, 141, 83, 104, 70, 65, 234, 54, 80, 100, 0, 200, 0, 0, 52, 52, 0, 1, 181, 6, 153, 30, 160, 0, 1, 234, 104, 0, 106, 98, 4, 84, 208, 253, 83, 71, 138, 6, 129, 160, 245, 1, 160, 0, 0, 0, 0, 30, 160, 52, 13, 52, 3, 64, 30, 166, 128, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 2, 20, 146, 154, 53, 26, 166, 106, 26, 104, 0, 104, 0, 0, 0, 211, 16, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 12, 167, 169, 160, 208, 3, 65, 160, 0, 50, 52, 13, 0, 104, 104, 105, 160, 3, 32, 0, 104, 208, 0, 0, 208, 0, 26, 12, 128, 0, 208, 50, 1, 147, 64, 30, 160, 0, 24, 128, 100, 0, 36, 68, 33, 38, 36, 194, 147, 99, 84, 253, 36, 109, 79, 81, 237, 73, 188, 163, 212, 196, 212, 121, 52, 135, 160, 245, 79, 41, 234, 109, 77, 169, 167, 163, 34, 122, 19, 64, 100, 3, 77, 25, 0, 0, 6, 134, 128, 0, 104, 52, 0, 3, 33, 166, 38, 70, 128, 208, 50, 58, 119, 40, 227, 104, 172, 44, 201, 177, 89, 178, 76, 96, 199, 169, 96, 26, 77, 148, 10, 136, 26, 225, 153, 246, 3, 237, 254, 192, 41, 226, 173, 97, 115, 39, 117, 197, 23, 40, 118, 215, 86, 56, 222, 110, 168, 89, 68, 133, 59, 228, 136, 134, 238, 26, 231, 236, 46, 120, 214, 61, 214, 54, 10, 168, 115, 212, 34, 58, 210, 76, 65, 13, 108, 232, 132, 42, 43, 80, 135, 29, 121, 17, 48, 164, 191, 103, 251, 221, 172, 22, 38, 228, 146, 65, 126, 239, 139, 226, 244, 227, 245, 242, 97, 147, 55, 56, 211, 57, 28, 147, 18, 244, 64, 211, 91, 209, 161, 240, 26, 156, 28, 42, 240, 167, 160, 8, 29, 131, 48, 4, 129, 173, 1, 139, 67, 32, 192, 7, 138, 203, 87, 13, 113, 7, 164, 227, 216, 1, 37, 72, 152, 33, 88, 150, 40, 192, 7, 41, 139, 87, 50, 128, 119, 126, 53, 133, 201, 194, 194, 187, 43, 102, 198, 253, 99, 156, 192, 56, 155, 227, 126, 6, 128, 242, 9, 227, 198, 45, 43, 68, 32, 62, 117, 197, 65, 75, 188, 96, 60, 180, 208, 198, 136, 235, 59, 61, 147, 74, 121, 64, 209, 4, 28, 191, 99, 158, 132, 234, 234, 129, 225, 184, 128, 241, 186, 127, 135, 207, 23, 64, 182, 95, 47, 34, 123, 95, 170, 237, 197, 112, 235, 127, 57, 212, 45, 129, 127, 40, 245, 146, 200, 176, 243, 121, 205, 143, 29, 109, 49, 194, 209, 224, 148, 90, 116, 15, 9, 173, 59, 38, 105, 20, 37, 25, 165, 200, 75, 101, 176, 31, 164, 222, 223, 47, 94, 138, 228, 241, 137, 173, 207, 177, 90, 201, 2, 176, 88, 2, 57, 230, 74, 3, 121, 22, 225, 104, 65, 241, 235, 5, 168, 44, 64, 24, 204, 96, 116, 220, 241, 175, 253, 116, 50, 110, 145, 178, 48, 48, 3, 22, 231, 85, 137, 106, 180, 45, 84, 38, 145, 58, 165, 40, 132, 242, 116, 76, 129, 128, 96, 60, 126, 245, 86, 35, 44, 77, 92, 228, 25, 35, 181, 38, 40, 148, 236, 135, 241, 65, 239, 177, 193, 81, 85, 115, 116, 139, 26, 221, 30, 129, 21, 79, 134, 35, 211, 130, 168, 167, 24, 96, 11, 166, 17, 78, 138, 168, 236, 229, 43, 153, 6, 25, 42, 152, 50, 14, 139, 58, 227, 249, 220, 84, 44, 92, 48, 168, 114, 51, 204, 83, 68, 53, 124, 35, 152, 58, 126, 241, 226, 87, 199, 70, 80, 55, 235, 231, 17, 7, 112, 119, 7, 114, 119, 76, 224, 231, 116, 53, 193, 228, 225, 9, 48, 241, 25, 148, 105, 101, 105, 68, 125, 157, 18, 46, 41, 21, 33, 147, 140, 188, 178, 36, 107, 244, 85, 77, 21, 2, 89, 41, 195, 55, 184, 118, 96, 179, 23, 147, 70, 52, 96, 111, 200, 0, 104, 129, 162, 92, 74, 33, 45, 63, 145, 238, 60, 54, 69, 133, 80, 3, 111, 226, 12, 75, 228, 193, 2, 77, 174, 207, 184, 66, 133, 44, 198, 49, 44, 189, 34, 213, 244, 139, 44, 85, 77, 225, 152, 111, 114, 3, 35, 35, 122, 23, 193, 177, 5, 223, 9, 60, 77, 170, 24, 9, 208, 93, 73, 201, 177, 35, 150, 66, 136, 27, 134, 157, 148, 39, 157, 227, 165, 121, 141, 77, 189, 166, 132, 32, 97, 164, 2, 160, 233, 208, 226, 11, 25, 133, 81, 118, 240, 54, 7, 73, 166, 209, 102, 38, 90, 230, 200, 56, 48, 196, 70, 153, 171, 172, 87, 83, 146, 41, 196, 119, 199, 71, 162, 119, 142, 144, 231, 206, 117, 1, 212, 171, 108, 201, 23, 29, 57, 91, 99, 118, 209, 11, 215, 207, 32, 159, 99, 203, 31, 220, 196, 104, 104, 11, 61, 26, 105, 29, 240, 168, 4, 65, 154, 66, 101, 215, 167, 16, 138, 109, 43, 68, 130, 202, 92, 179, 164, 104, 102, 61, 204, 230, 54, 148, 121, 51, 149, 173, 148, 208, 148, 132, 56, 177, 136, 226, 4, 76, 242, 139, 88, 65, 173, 6, 12, 71, 15, 112, 122, 196, 4, 196, 98, 134, 82, 88, 158, 141, 26, 40, 209, 102, 103, 101, 94, 202, 66, 135, 19, 162, 92, 19, 163, 18, 105, 160, 134, 200, 130, 5, 163, 101, 168, 186, 70, 199, 31, 71, 52, 151, 143, 160, 149, 239, 224, 40, 249, 218, 50, 174, 173, 174, 138, 220, 195, 24, 183, 213, 229, 134, 254, 197, 42, 113, 247, 3, 37, 146, 201, 152, 146, 132, 31, 28, 66, 234, 215, 241, 167, 171, 228, 188, 81, 25, 47, 27, 170, 214, 246, 213, 102, 197, 140, 201, 178, 176, 121, 84, 203, 19, 171, 86, 85, 226, 126, 138, 42, 192, 186, 15, 68, 250, 122, 166, 171, 54, 161, 214, 1, 214, 27, 15, 98, 10, 153, 161, 120, 174, 75, 80, 216, 93, 10, 216, 224, 45, 21, 172, 180, 252, 76, 228, 100, 64, 174, 221, 87, 157, 106, 244, 40, 181, 46, 222, 83, 174, 87, 105, 219, 57, 218, 179, 121, 195, 178, 148, 188, 107, 155, 40, 99, 92, 37, 217, 243, 102, 89, 168, 98, 171, 191, 56, 70, 167, 41, 125, 26, 12, 146, 145, 15, 100, 85, 126, 83, 177, 137, 100, 76, 236, 72, 153, 68, 48, 203, 201, 188, 118, 144, 118, 188, 173, 195, 193, 242, 177, 25, 76, 152, 242, 140, 209, 250, 71, 7, 146, 222, 192, 186, 81, 164, 116, 167, 110, 66, 19, 24, 177, 10, 192, 243, 131, 131, 57, 14, 222, 249, 25, 203, 24, 122, 255, 248, 28, 146, 229, 203, 36, 227, 230, 147, 241, 17, 106, 66, 247, 183, 32, 123, 172, 59, 51, 65, 113, 107, 172, 92, 158, 21, 103, 25, 205, 198, 78, 230, 214, 105, 207, 18, 232, 108, 33, 185, 25, 16, 98, 195, 168, 170, 201, 54, 124, 214, 76, 253, 101, 206, 214, 235, 113, 164, 251, 67, 87, 152, 105, 254, 2, 14, 160, 91, 16, 142, 24, 236, 150, 61, 138, 204, 19, 14, 246, 245, 3, 90, 136, 164, 210, 129, 64, 160, 152, 80, 67, 166, 35, 95, 154, 212, 144, 208, 156, 84, 149, 4, 185, 211, 156, 192, 69, 0, 115, 25, 86, 88, 115, 107, 165, 47, 86, 217, 55, 83, 155, 85, 106, 247, 98, 176, 40, 162, 190, 37, 245, 8, 79, 18, 181, 212, 193, 1, 115, 106, 206, 177, 205, 249, 214, 107, 183, 155, 229, 248, 123, 211, 89, 188, 141, 46, 173, 145, 2, 135, 26, 1, 51, 26, 92, 13, 110, 171, 147, 126, 170, 53, 77, 222, 144, 52, 198, 150, 220, 227, 110, 158, 216, 170, 211, 211, 219, 77, 26, 87, 180, 132, 214, 118, 123, 161, 43, 36, 180, 228, 101, 199, 25, 25, 218, 62, 182, 5, 31, 98, 116, 128, 118, 160, 178, 50, 10, 242, 23, 46, 171, 171, 96, 112, 231, 41, 147, 198, 65, 234, 1, 244, 60, 235, 138, 1, 214, 27, 96, 215, 84, 21, 101, 148, 220, 19, 194, 218, 225, 190, 141, 101, 135, 109, 101, 154, 106, 61, 211, 56, 114, 188, 44, 153, 12, 41, 75, 18, 39, 82, 59, 118, 73, 235, 67, 197, 227, 11, 247, 110, 100, 99, 216, 9, 44, 246, 204, 64, 37, 44, 169, 68, 134, 164, 174, 189, 252, 119, 211, 72, 16, 28, 249, 58, 199, 5, 198, 37, 82, 32, 38, 165, 167, 35, 73, 39, 34, 46, 11, 142, 63, 144, 232, 23, 205, 76, 226, 155, 67, 106, 38, 65, 192, 52, 138, 193, 81, 241, 101, 154, 68, 53, 227, 200, 107, 151, 134, 27, 177, 179, 79, 124, 37, 184, 103, 104, 95, 121, 109, 197, 21, 81, 97, 176, 25, 144, 245, 98, 14, 155, 231, 85, 111, 56, 92, 249, 207, 110, 183, 71, 173, 231, 239, 74, 160, 27, 108, 27, 70, 129, 169, 251, 57, 236, 141, 52, 154, 3, 7, 65, 37, 20, 2, 117, 250, 86, 65, 215, 205, 48, 16, 165, 83, 185, 25, 181, 88, 56, 121, 122, 222, 11, 144, 12, 89, 249, 124, 108, 97, 94, 72, 57, 63, 54, 53, 195, 250, 57, 132, 243, 243, 72, 78, 41, 25, 1, 165, 113, 36, 194, 239, 250, 77, 140, 45, 148, 40, 156, 223, 39, 143, 94, 215, 36, 112, 147, 77, 183, 137, 49, 70, 145, 81, 164, 21, 58, 118, 41, 206, 202, 147, 88, 67, 33, 145, 99, 72, 101, 105, 249, 206, 170, 119, 93, 87, 55, 156, 105, 143, 94, 227, 216, 152, 49, 203, 76, 23, 116, 45, 116, 226, 34, 68, 2, 34, 4, 72, 33, 5, 47, 49, 185, 6, 231, 35, 112, 102, 177, 77, 177, 140, 75, 217, 11, 163, 191, 5, 246, 192, 56, 219, 172, 66, 110, 196, 26, 177, 153, 88, 70, 108, 57, 70, 22, 194, 197, 60, 233, 129, 183, 188, 169, 112, 38, 22, 21, 246, 52, 120, 235, 28, 194, 187, 8, 209, 8, 107, 17, 140, 100, 72, 117, 181, 56, 181, 130, 211, 145, 106, 249, 31, 191, 187, 197, 155, 122, 229, 42, 18, 218, 221, 109, 172, 203, 50, 33, 102, 93, 35, 201, 8, 232, 108, 105, 169, 34, 213, 20, 220, 183, 91, 105, 73, 173, 82, 167, 83, 199, 196, 255, 3, 43, 17, 29, 217, 142, 59, 63, 190, 105, 111, 25, 237, 207, 63, 206, 247, 37, 111, 67, 97, 150, 203, 131, 164, 80, 223, 87, 204, 12, 91, 47, 218, 40, 88, 109, 82, 197, 44, 201, 110, 204, 171, 228, 251, 161, 30, 23, 4, 146, 97, 204, 190, 102, 179, 56, 141, 97, 237, 167, 30, 54, 49, 244, 25, 13, 137, 83, 232, 58, 7, 36, 44, 168, 70, 228, 157, 58, 115, 59, 99, 128, 162, 197, 84, 204, 153, 5, 228, 26, 189, 128, 255, 121, 122, 233, 46, 17, 196, 8, 246, 187, 45, 186, 77, 120, 178, 33, 198, 180, 103, 140, 76, 80, 106, 65, 181, 193, 157, 205, 215, 204, 238, 234, 198, 42, 200, 97, 96, 44, 13, 129, 53, 135, 199, 160, 24, 109, 187, 197, 120, 243, 104, 175, 94, 229, 43, 99, 199, 130, 170, 117, 105, 114, 95, 21, 228, 99, 172, 36, 18, 201, 129, 230, 67, 13, 118, 210, 91, 28, 9, 145, 45, 28, 77, 94, 40, 69, 136, 168, 27, 79, 124, 197, 219, 170, 109, 80, 204, 227, 56, 206, 128, 74, 177, 200, 141, 249, 170, 143, 149, 9, 75, 131, 196, 67, 197, 178, 225, 240, 133, 233, 5, 50, 60, 48, 32, 2, 160, 21, 64, 132, 8, 192, 176, 5, 208, 36, 2, 128, 41, 3, 64, 13, 128, 43, 0, 32, 178, 7, 64, 22, 73, 21, 105, 36, 119, 101, 142, 180, 91, 118, 100, 9, 97, 159, 2, 88, 149, 221, 137, 105, 50, 236, 45, 132, 55, 197, 193, 174, 203, 11, 36, 46, 75, 196, 81, 134, 252, 49, 208, 234, 99, 109, 178, 158, 195, 38, 34, 148, 6, 228, 136, 218, 76, 7, 167, 50, 9, 186, 78, 143, 168, 72, 86, 115, 201, 209, 68, 28, 14, 221, 230, 209, 197, 51, 236, 179, 173, 243, 225, 59, 51, 113, 183, 105, 68, 78, 134, 125, 22, 242, 78, 212, 36, 112, 197, 224, 156, 19, 180, 77, 56, 214, 1, 77, 161, 70, 125, 188, 191, 78, 254, 218, 188, 42, 165, 100, 154, 60, 6, 161, 47, 172, 224, 80, 199, 4, 180, 188, 38, 233, 52, 33, 208, 165, 40, 164, 16, 26, 46, 136, 80, 5, 27, 62, 249, 189, 205, 78, 1, 8, 64, 180, 96, 64, 16, 136, 194, 22, 79, 49, 64, 155, 247, 52, 144, 66, 102, 198, 49, 224, 154, 192, 23, 154, 11, 8, 38, 88, 128, 138, 117, 8, 136, 79, 154, 76, 164, 117, 169, 114, 149, 42, 80, 13, 97, 60, 156, 103, 30, 116, 239, 239, 70, 195, 49, 5, 64, 227, 159, 68, 202, 20, 246, 25, 204, 66, 179, 162, 129, 28, 132, 75, 14, 137, 86, 241, 99, 55, 48, 157, 11, 214, 179, 52, 72, 154, 182, 172, 216, 40, 226, 110, 159, 42, 65, 61, 225, 131, 94, 20, 7, 249, 64, 117, 84, 30, 250, 67, 148, 152, 181, 79, 200, 84, 149, 62, 116, 224, 244, 196, 164, 209, 60, 108, 44, 130, 201, 158, 88, 31, 227, 87, 85, 204, 179, 41, 162, 134, 81, 252, 154, 133, 66, 73, 73, 75, 4, 38, 89, 221, 132, 36, 50, 70, 68, 249, 112, 66, 184, 32, 144, 170, 70, 54, 94, 217, 68, 110, 217, 124, 255, 84, 22, 157, 103, 58, 81, 215, 108, 245, 32, 118, 230, 31, 216, 174, 134, 24, 201, 69, 86, 38, 228, 159, 32, 35, 16, 47, 138, 126, 211, 41, 206, 48, 237, 219, 218, 71, 145, 140, 84, 32, 220, 174, 104, 222, 34, 225, 176, 91, 194, 73, 69, 246, 29, 244, 10, 2, 188, 172, 133, 133, 105, 177, 38, 163, 32, 184, 26, 187, 209, 41, 10, 42, 16, 17, 216, 56, 39, 255, 104, 254, 185, 90, 60, 223, 8, 5, 250, 187, 33, 123, 196, 134, 58, 0, 221, 232, 254, 205, 114, 66, 154, 84, 133, 124, 245, 153, 130, 120, 129, 248, 64, 248, 4, 99, 128, 235, 22, 153, 44, 70, 2, 59, 137, 49, 149, 244, 242, 67, 191, 60, 217, 41, 150, 51, 229, 35, 182, 68, 194, 54, 95, 93, 117, 84, 92, 140, 90, 203, 186, 210, 118, 246, 67, 50, 73, 134, 6, 76, 50, 8, 164, 245, 208, 68, 170, 121, 78, 186, 227, 182, 243, 121, 238, 6, 8, 97, 89, 30, 5, 67, 172, 33, 124, 97, 131, 168, 48, 103, 48, 243, 239, 214, 241, 187, 199, 213, 120, 56, 78, 26, 210, 87, 236, 17, 82, 165, 134, 60, 134, 204, 38, 181, 6, 62, 228, 190, 143, 102, 190, 176, 215, 199, 127, 0, 230, 72, 205, 82, 163, 26, 6, 141, 15, 71, 98, 142, 37, 244, 76, 69, 113, 134, 111, 28, 113, 60, 197, 14, 32, 78, 139, 236, 238, 100, 194, 48, 205, 155, 244, 12, 60, 184, 246, 192, 37, 112, 218, 176, 45, 52, 103, 60, 248, 90, 128, 133, 229, 99, 89, 239, 166, 207, 104, 47, 19, 200, 45, 140, 126, 32, 15, 142, 0, 192, 21, 165, 93, 132, 106, 249, 43, 202, 37, 132, 248, 223, 141, 175, 117, 41, 65, 198, 23, 51, 206, 116, 97, 199, 253, 55, 129, 154, 247, 61, 67, 109, 28, 174, 104, 58, 114, 104, 45, 20, 115, 241, 8, 54, 97, 78, 61, 220, 198, 245, 53, 52, 74, 141, 49, 144, 136, 42, 139, 48, 211, 12, 58, 187, 186, 156, 210, 140, 86, 186, 18, 135, 175, 128, 240, 170, 121, 254, 8, 120, 152, 26, 253, 82, 187, 17, 121, 141, 68, 163, 23, 94, 129, 192, 230, 93, 235, 216, 56, 238, 78, 83, 64, 197, 86, 73, 131, 7, 230, 154, 76, 30, 215, 104, 140, 253, 222, 76, 104, 218, 155, 148, 13, 111, 147, 19, 65, 148, 225, 91, 150, 225, 214, 246, 5, 142, 196, 5, 238, 14, 12, 215, 78, 86, 197, 37, 14, 198, 121, 155, 109, 107, 133, 57, 103, 169, 207, 100, 38, 97, 5, 228, 104, 0, 45, 104, 246, 20, 192, 148, 236, 0, 236, 154, 71, 67, 183, 139, 85, 67, 75, 169, 101, 164, 100, 71, 180, 200, 226, 69, 34, 57, 3, 130, 123, 156, 200, 97, 34, 13, 208, 115, 164, 165, 16, 197, 43, 77, 5, 98, 189, 92, 252, 1, 117, 156, 11, 179, 40, 172, 215, 111, 159, 167, 175, 183, 184, 83, 237, 199, 112, 90, 113, 170, 234, 174, 201, 20, 108, 24, 8, 32, 0, 0, 32, 3, 0, 17, 183, 225, 252, 30, 38, 183, 65, 100, 25, 100, 109, 141, 161, 13, 158, 217, 8, 65, 38, 8, 32, 162, 43, 124, 152, 178, 221, 126, 48, 169, 8, 162, 50, 50, 162, 40, 130, 162, 18, 67, 201, 254, 223, 25, 230, 251, 215, 156, 230, 249, 191, 181, 208, 120, 47, 9, 198, 116, 40, 136, 134, 153, 169, 8, 229, 191, 47, 195, 233, 156, 193, 204, 157, 2, 97, 209, 164, 132, 33, 133, 2, 72, 114, 67, 153, 128, 228, 47, 33, 170, 150, 34, 10, 154, 98, 160, 45, 214, 53, 4, 197, 37, 72, 73, 85, 200, 197, 196, 150, 100, 136, 40, 72, 172, 196, 76, 150, 33, 50, 87, 38, 150, 98, 152, 41, 32, 55, 166, 163, 17, 13, 35, 32, 66, 192, 73, 8, 113, 3, 188, 7, 28, 54, 147, 78, 24, 98, 64, 18, 100, 9, 97, 64, 200, 56, 168, 66, 159, 18, 91, 74, 107, 75, 6, 22, 13, 134, 194, 240, 18, 20, 49, 3, 38, 236, 12, 130, 99, 152, 168, 83, 18, 161, 134, 104, 37, 136, 128, 55, 131, 101, 196, 225, 193, 26, 41, 102, 8, 32, 10, 216, 7, 206, 241, 187, 109, 111, 53, 164, 208, 72, 82, 200, 64, 68, 17, 9, 15, 39, 3, 10, 170, 36, 164, 98, 86, 70, 17, 32, 100, 8, 72, 100, 33, 28, 233, 41, 194, 77, 20, 184, 89, 10, 98, 108, 108, 181, 81, 25, 46, 69, 4, 100, 229, 18, 28, 6, 48, 81, 20, 17, 106, 61, 253, 29, 44, 239, 43, 141, 163, 236, 101, 114, 232, 255, 180, 180, 48, 254, 56, 4, 0, 20, 84, 81, 81, 81, 20, 84, 34, 214, 255, 84, 244, 233, 114, 185, 91, 173, 13, 28, 186, 91, 188, 205, 74, 90, 156, 44, 170, 57, 124, 46, 202, 158, 111, 93, 230, 233, 197, 64, 174, 65, 85, 0, 226, 106, 177, 1, 208, 50, 144, 118, 85, 67, 159, 73, 81, 57, 169, 29, 128, 54, 32, 104, 130, 20, 185, 172, 114, 68, 166, 37, 154, 10, 108, 244, 250, 3, 72, 49, 1, 9, 3, 18, 192, 213, 2, 126, 142, 217, 249, 61, 231, 201, 221, 206, 28, 142, 60, 39, 48, 194, 32, 141, 226, 108, 209, 21, 49, 53, 16, 68, 68, 146, 77, 76, 67, 80, 68, 144, 197, 17, 19, 65, 17, 114, 100, 112, 24, 21, 129, 151, 140, 133, 28, 164, 144, 41, 37, 32, 10, 104, 73, 33, 138, 197, 56, 0, 224, 51, 4, 40, 90, 201, 201, 54, 121, 217, 74, 69, 56, 32, 35, 181, 56, 136, 97, 13, 12, 192, 4, 211, 17, 1, 36, 60, 48, 33, 163, 158, 25, 192, 77, 160, 185, 220, 18, 228, 106, 208, 6, 12, 46, 64, 225, 68, 0, 203, 81, 33, 40, 210, 81, 1, 187, 23, 51, 23, 9, 138, 166, 40, 170, 94, 38, 28, 72, 193, 57, 217, 76, 13, 19, 21, 21, 9, 48, 201, 180, 96, 115, 152, 82, 153, 50, 21, 21, 197, 134, 51, 17, 74, 72, 208, 147, 85, 19, 17, 50, 195, 48, 49, 28, 160, 71, 253, 225, 170, 96, 184, 240, 202, 150, 168, 160, 76, 149, 50, 82, 162, 164, 184, 48, 7, 18, 72, 164, 132, 137, 6, 37, 88, 34, 25, 41, 6, 55, 96, 56, 83, 1, 102, 14, 208, 133, 27, 27, 57, 219, 113, 172, 170, 201, 52, 35, 41, 170, 145, 36, 146, 148, 169, 41, 149, 202, 25, 6, 68, 49, 164, 38, 1, 4, 211, 25, 41, 53, 154, 40, 40, 198, 52, 25, 144, 40, 152, 136, 18, 100, 25, 33, 40, 105, 104, 104, 166, 128, 221, 40, 25, 48, 160, 80, 193, 64, 56, 224, 229, 46, 41, 132, 64, 243, 111, 48, 10, 162, 224, 170, 29, 150, 142, 12, 3, 122, 67, 22, 139, 46, 29, 197, 137, 201, 135, 104, 161, 170, 26, 72, 144, 73, 130, 156, 128, 177, 198, 65, 128, 50, 112, 100, 46, 60, 209, 111, 219, 56, 241, 170, 162, 141, 224, 240, 232, 226, 112, 220, 112, 27, 145, 22, 148, 165, 16, 128, 32, 74, 229, 3, 42, 152, 69, 10, 146, 84, 40, 67, 20, 176, 83, 33, 191, 64, 38, 26, 132, 40, 77, 240, 225, 17, 5, 67, 34, 50, 196, 0, 205, 16, 64, 114, 68, 56, 196, 112, 227, 83, 141, 57, 42, 67, 192, 154, 216, 27, 103, 147, 7, 10, 108, 236, 200, 9, 144, 9, 48, 160, 255, 152, 198, 72, 136, 136, 128, 162, 66, 121, 60, 182, 17, 15, 1, 152, 27, 10, 28, 3, 136, 8, 27, 27, 153, 99, 188, 196, 90, 151, 225, 54, 178, 21, 132, 43, 239, 189, 11, 22, 8, 77, 10, 11, 138, 138, 160, 50, 27, 81, 11, 37, 65, 180, 12, 105, 89, 165, 17, 146, 37, 4, 230, 65, 19, 51, 225, 0, 47, 226, 129, 52, 48, 75, 215, 9, 32, 50, 38, 128, 105, 37, 145, 52, 52, 196, 134, 132, 25, 19, 0, 177, 130, 115, 68, 52, 132, 217, 133, 30, 98, 199, 144, 225, 11, 52, 156, 162, 86, 169, 40, 136, 112, 34, 10, 166, 40, 136, 168, 121, 124, 23, 26, 136, 34, 7, 11, 4, 74, 2, 42, 72, 162, 32, 30, 12, 68, 218, 10, 10, 83, 73, 72, 84, 180, 234, 3, 8, 204, 48, 24, 40, 153, 165, 163, 56, 180, 6, 163, 92, 91, 245, 195, 197, 130, 27, 148, 220, 105, 54, 203, 54, 118, 128, 219, 139, 41, 167, 84, 70, 89, 19, 76, 144, 26, 131, 34, 2, 211, 137, 248, 225, 51, 64, 100, 133, 4, 109, 46, 18, 103, 6, 43, 169, 96, 76, 192, 12, 34, 128, 148, 221, 182, 139, 125, 88, 237, 152, 165, 152, 132, 84, 55, 47, 173, 58, 199, 17, 117, 33, 168, 53, 57, 4, 22, 78, 64, 17, 35, 3, 76, 129, 12, 15, 12, 169, 140, 204, 206, 198, 3, 178, 72, 58, 42, 98, 2, 36, 160, 91, 108, 106, 50, 48, 117, 46, 161, 176, 80, 138, 142, 1, 75, 70, 8, 49, 136, 32, 0, 2, 169, 75, 170, 70, 99, 50, 216, 29, 196, 113, 27, 6, 40, 104, 106, 6, 132, 72, 151, 44, 148, 165, 160, 10, 66, 38, 168, 71, 112, 28, 32, 27, 14, 225, 225, 136, 176, 224, 67, 116, 12, 74, 223, 252, 93, 201, 20, 225, 66, 66, 214, 20, 114, 120 };

constexpr std::array<u8, 4181> HEARTGOLD = { 44, 94, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 136, 220, 12, 41, 0, 21, 151, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 255, 255, 255, 238, 173, 0, 60, 216, 44, 172, 185, 249, 234, 149, 148, 216, 33, 128, 96, 18, 61, 95, 125, 221, 203, 85, 220, 238, 119, 28, 238, 199, 105, 221, 174, 154, 117, 27, 174, 236, 76, 154, 103, 58, 9, 183, 13, 198, 168, 119, 96, 187, 72, 161, 64, 0, 208, 0, 9, 36, 33, 0, 131, 76, 154, 155, 66, 98, 100, 109, 9, 166, 134, 79, 83, 81, 166, 158, 167, 162, 30, 166, 134, 131, 210, 52, 105, 234, 50, 15, 64, 140, 16, 211, 208, 158, 163, 64, 52, 6, 154, 3, 65, 160, 6, 65, 144, 3, 67, 101, 16, 52, 52, 104, 6, 16, 26, 13, 3, 2, 0, 13, 1, 166, 64, 104, 12, 2, 3, 38, 154, 0, 0, 26, 96, 154, 105, 130, 3, 38, 140, 131, 70, 16, 0, 100, 48, 134, 153, 8, 26, 26, 52, 3, 8, 13, 6, 129, 129, 0, 6, 128, 211, 32, 52, 6, 1, 1, 147, 77, 0, 0, 13, 48, 77, 52, 193, 1, 147, 70, 65, 163, 8, 0, 50, 24, 67, 76, 129, 34, 34, 106, 83, 193, 4, 210, 120, 6, 165, 63, 84, 243, 84, 253, 41, 224, 158, 145, 169, 181, 49, 166, 145, 234, 105, 167, 148, 218, 158, 145, 237, 81, 233, 52, 30, 166, 212, 211, 67, 67, 105, 169, 234, 100, 104, 15, 68, 245, 26, 0, 0, 0, 0, 0, 1, 233, 168, 200, 34, 82, 129, 54, 154, 148, 201, 224, 166, 202, 52, 104, 15, 212, 134, 128, 0, 211, 106, 12, 128, 100, 3, 212, 12, 134, 71, 168, 27, 72, 1, 160, 13, 0, 52, 1, 234, 7, 164, 0, 0, 208, 0, 26, 111, 84, 17, 36, 16, 132, 25, 33, 52, 211, 84, 241, 141, 73, 169, 237, 83, 205, 5, 26, 26, 26, 26, 12, 131, 67, 211, 80, 104, 0, 52, 1, 160, 30, 160, 54, 160, 30, 160, 0, 0, 0, 0, 0, 0, 6, 182, 207, 101, 224, 106, 103, 57, 6, 60, 4, 17, 150, 48, 137, 164, 211, 113, 88, 78, 164, 81, 65, 90, 149, 172, 148, 10, 91, 216, 28, 157, 175, 207, 155, 168, 232, 74, 233, 126, 228, 87, 121, 108, 241, 172, 228, 159, 224, 27, 158, 124, 117, 205, 236, 204, 140, 120, 173, 44, 93, 127, 111, 6, 193, 177, 166, 74, 198, 143, 72, 123, 182, 104, 14, 50, 114, 50, 187, 95, 69, 187, 59, 108, 24, 6, 101, 214, 37, 185, 107, 138, 240, 142, 117, 226, 230, 83, 19, 37, 206, 3, 127, 54, 214, 193, 175, 129, 235, 246, 184, 237, 110, 190, 17, 77, 60, 179, 178, 169, 140, 34, 9, 236, 193, 21, 107, 129, 18, 65, 32, 136, 69, 165, 38, 131, 69, 7, 43, 240, 152, 255, 1, 141, 106, 221, 170, 42, 151, 24, 0, 27, 3, 10, 4, 241, 235, 43, 106, 114, 67, 175, 221, 95, 94, 73, 55, 128, 251, 124, 90, 22, 151, 5, 142, 227, 105, 50, 170, 64, 88, 49, 89, 173, 29, 99, 140, 75, 53, 154, 172, 144, 198, 162, 27, 105, 60, 190, 7, 192, 241, 189, 158, 223, 131, 107, 198, 3, 24, 46, 126, 219, 234, 133, 190, 39, 78, 190, 254, 135, 125, 202, 4, 16, 142, 161, 17, 250, 116, 96, 159, 22, 39, 88, 80, 164, 20, 222, 4, 41, 3, 49, 68, 11, 208, 6, 17, 164, 46, 41, 116, 252, 207, 145, 43, 199, 196, 26, 9, 134, 169, 155, 19, 10, 25, 1, 9, 131, 81, 10, 224, 149, 151, 251, 58, 189, 3, 82, 238, 47, 182, 253, 59, 92, 18, 47, 95, 179, 46, 248, 185, 56, 57, 123, 219, 125, 117, 125, 127, 23, 58, 190, 119, 19, 171, 248, 176, 92, 94, 137, 227, 125, 154, 108, 3, 58, 215, 42, 22, 112, 54, 152, 36, 129, 46, 239, 52, 224, 239, 175, 241, 155, 223, 202, 83, 16, 156, 40, 105, 181, 17, 197, 224, 148, 10, 126, 62, 193, 203, 43, 81, 156, 143, 200, 31, 182, 132, 168, 57, 148, 142, 74, 52, 98, 120, 243, 220, 207, 128, 242, 88, 229, 53, 134, 37, 76, 31, 174, 38, 39, 97, 209, 195, 204, 219, 247, 188, 204, 21, 173, 57, 1, 126, 247, 78, 73, 103, 243, 61, 208, 171, 59, 205, 50, 11, 64, 244, 115, 199, 113, 82, 230, 46, 255, 175, 111, 239, 185, 174, 119, 149, 196, 210, 50, 241, 52, 164, 108, 6, 208, 227, 104, 34, 236, 34, 220, 137, 167, 194, 160, 155, 40, 23, 163, 172, 37, 168, 218, 39, 160, 211, 12, 52, 252, 187, 245, 166, 13, 161, 120, 107, 230, 224, 183, 176, 119, 252, 18, 122, 247, 230, 24, 113, 122, 124, 59, 5, 175, 79, 18, 26, 17, 11, 28, 193, 123, 74, 44, 18, 37, 221, 124, 187, 15, 49, 224, 254, 206, 163, 118, 25, 177, 77, 154, 142, 199, 22, 201, 82, 122, 137, 117, 138, 8, 42, 42, 4, 93, 131, 214, 167, 80, 152, 184, 42, 132, 118, 76, 152, 179, 41, 39, 148, 91, 59, 249, 65, 189, 195, 153, 148, 80, 78, 75, 165, 228, 51, 203, 151, 135, 229, 154, 170, 186, 54, 190, 30, 103, 71, 80, 87, 198, 46, 102, 43, 149, 19, 80, 44, 1, 102, 60, 107, 107, 30, 56, 178, 145, 173, 147, 157, 39, 221, 238, 187, 202, 15, 156, 28, 159, 172, 209, 109, 130, 200, 13, 157, 74, 84, 90, 27, 102, 248, 235, 181, 152, 215, 16, 43, 86, 68, 9, 9, 21, 169, 128, 159, 212, 117, 185, 9, 18, 9, 15, 134, 154, 153, 247, 63, 210, 38, 80, 233, 63, 221, 125, 209, 213, 106, 80, 184, 14, 138, 172, 222, 210, 39, 57, 213, 87, 11, 211, 123, 7, 35, 221, 211, 136, 154, 98, 185, 196, 252, 145, 57, 132, 172, 46, 121, 127, 223, 146, 121, 143, 181, 151, 177, 5, 162, 15, 247, 16, 162, 36, 15, 97, 129, 215, 44, 96, 113, 126, 73, 116, 242, 31, 41, 74, 177, 5, 166, 211, 22, 226, 194, 78, 47, 200, 200, 32, 139, 182, 233, 184, 89, 95, 214, 60, 233, 229, 101, 113, 239, 81, 205, 230, 169, 177, 199, 113, 72, 207, 232, 239, 140, 161, 135, 110, 205, 79, 249, 206, 114, 43, 44, 60, 82, 252, 36, 19, 49, 88, 81, 130, 197, 24, 118, 115, 6, 137, 245, 201, 150, 255, 17, 196, 12, 34, 196, 110, 139, 235, 40, 183, 46, 144, 103, 3, 10, 151, 215, 28, 13, 121, 24, 144, 97, 18, 36, 132, 144, 140, 134, 108, 164, 83, 39, 131, 46, 229, 33, 154, 193, 134, 5, 111, 35, 132, 152, 114, 126, 64, 230, 26, 175, 78, 110, 77, 150, 151, 60, 21, 133, 165, 150, 224, 85, 175, 196, 229, 121, 113, 65, 195, 139, 156, 147, 232, 148, 76, 187, 188, 178, 153, 115, 16, 194, 176, 223, 154, 124, 47, 12, 237, 103, 112, 77, 164, 2, 243, 145, 72, 176, 231, 42, 176, 16, 75, 170, 159, 16, 174, 104, 209, 11, 62, 225, 209, 168, 5, 160, 158, 132, 232, 136, 63, 63, 93, 222, 11, 36, 200, 15, 115, 224, 189, 153, 118, 23, 211, 233, 182, 54, 60, 72, 60, 196, 153, 51, 229, 241, 217, 216, 148, 158, 36, 164, 180, 90, 32, 123, 185, 216, 114, 53, 130, 64, 144, 136, 64, 8, 50, 225, 27, 69, 131, 29, 253, 4, 214, 137, 112, 178, 149, 23, 245, 162, 104, 175, 175, 68, 176, 232, 92, 29, 78, 161, 173, 206, 108, 101, 228, 137, 99, 40, 155, 116, 63, 53, 85, 99, 251, 233, 44, 4, 180, 86, 246, 74, 169, 239, 38, 136, 152, 52, 61, 230, 152, 36, 143, 83, 10, 187, 88, 41, 236, 60, 246, 32, 145, 11, 26, 79, 135, 235, 163, 161, 144, 200, 232, 39, 222, 179, 193, 130, 19, 55, 220, 145, 246, 226, 181, 184, 233, 165, 106, 21, 184, 108, 52, 5, 228, 142, 112, 178, 216, 70, 173, 114, 238, 193, 61, 80, 76, 41, 170, 122, 156, 158, 21, 193, 95, 25, 1, 192, 151, 71, 86, 14, 119, 190, 224, 131, 114, 15, 72, 224, 119, 101, 133, 61, 160, 24, 62, 136, 123, 32, 48, 83, 35, 33, 150, 105, 37, 61, 37, 254, 91, 116, 232, 77, 4, 234, 56, 204, 83, 85, 68, 226, 90, 196, 23, 40, 85, 19, 144, 89, 115, 203, 204, 31, 238, 241, 101, 234, 12, 205, 50, 23, 12, 145, 180, 221, 1, 221, 152, 205, 215, 16, 29, 211, 116, 74, 243, 193, 195, 132, 72, 32, 150, 215, 138, 235, 52, 112, 112, 65, 138, 139, 188, 94, 38, 232, 59, 61, 75, 106, 145, 52, 45, 201, 201, 134, 24, 192, 77, 177, 165, 144, 112, 5, 102, 254, 58, 99, 84, 102, 113, 11, 66, 207, 50, 156, 8, 221, 127, 105, 28, 158, 139, 184, 199, 100, 132, 125, 203, 218, 215, 198, 237, 229, 12, 184, 199, 156, 15, 134, 29, 134, 121, 228, 60, 118, 130, 130, 231, 173, 220, 249, 187, 134, 128, 194, 83, 129, 98, 169, 104, 28, 177, 5, 122, 105, 216, 212, 12, 153, 149, 5, 212, 94, 214, 97, 229, 215, 91, 195, 83, 116, 155, 60, 178, 197, 85, 204, 48, 191, 84, 72, 142, 244, 172, 196, 225, 151, 34, 216, 214, 25, 39, 11, 137, 1, 177, 53, 89, 178, 230, 233, 214, 50, 124, 230, 40, 20, 121, 243, 136, 204, 120, 115, 34, 43, 202, 14, 239, 96, 141, 197, 206, 31, 18, 10, 48, 155, 183, 73, 7, 80, 237, 113, 66, 147, 52, 98, 248, 121, 181, 115, 54, 46, 46, 54, 124, 191, 70, 88, 166, 42, 119, 37, 231, 84, 51, 225, 100, 100, 172, 70, 86, 201, 197, 91, 212, 195, 150, 82, 130, 137, 56, 91, 107, 83, 15, 119, 138, 17, 233, 89, 148, 72, 164, 192, 46, 182, 20, 200, 161, 206, 202, 228, 104, 26, 105, 14, 245, 217, 132, 211, 74, 233, 227, 21, 211, 146, 209, 85, 70, 168, 141, 56, 207, 9, 141, 104, 140, 138, 52, 230, 144, 186, 66, 170, 202, 207, 247, 119, 161, 81, 232, 120, 177, 183, 205, 141, 211, 82, 101, 154, 160, 193, 172, 141, 51, 34, 236, 201, 41, 101, 234, 197, 202, 52, 40, 58, 170, 175, 52, 157, 97, 216, 124, 166, 27, 135, 56, 123, 238, 165, 153, 28, 58, 14, 142, 88, 56, 123, 55, 250, 193, 233, 202, 22, 118, 104, 83, 84, 66, 166, 46, 91, 8, 222, 104, 216, 106, 51, 185, 51, 32, 236, 241, 216, 150, 76, 144, 123, 39, 87, 204, 165, 19, 135, 170, 239, 122, 99, 98, 136, 217, 166, 49, 160, 59, 30, 154, 112, 60, 175, 9, 65, 171, 117, 193, 248, 111, 104, 89, 120, 99, 136, 131, 97, 244, 5, 75, 235, 81, 214, 179, 199, 142, 56, 240, 121, 2, 161, 122, 83, 8, 195, 95, 165, 66, 68, 97, 96, 35, 53, 153, 225, 233, 208, 152, 109, 130, 96, 111, 129, 48, 34, 85, 89, 203, 49, 243, 5, 79, 32, 126, 208, 240, 37, 71, 215, 133, 155, 43, 100, 33, 16, 162, 252, 21, 60, 64, 121, 63, 126, 72, 4, 47, 238, 76, 87, 130, 225, 232, 176, 141, 62, 46, 77, 39, 133, 248, 52, 48, 135, 160, 132, 67, 38, 95, 153, 58, 178, 238, 220, 251, 39, 120, 197, 159, 144, 31, 181, 41, 158, 209, 179, 166, 136, 83, 94, 64, 26, 29, 32, 247, 65, 128, 241, 85, 149, 174, 109, 49, 243, 105, 141, 3, 243, 53, 124, 134, 254, 131, 167, 0, 48, 11, 211, 30, 105, 169, 66, 178, 178, 148, 119, 71, 114, 153, 197, 76, 209, 95, 36, 98, 223, 171, 41, 37, 50, 215, 222, 236, 65, 156, 188, 35, 176, 199, 177, 129, 98, 52, 151, 12, 54, 133, 156, 253, 128, 230, 16, 48, 203, 87, 246, 138, 133, 215, 14, 117, 228, 37, 250, 27, 251, 90, 87, 165, 179, 228, 203, 108, 143, 11, 130, 12, 152, 123, 4, 32, 227, 101, 84, 107, 123, 17, 72, 82, 166, 201, 134, 116, 208, 199, 96, 40, 167, 30, 10, 222, 3, 129, 64, 47, 2, 183, 37, 73, 226, 179, 121, 231, 173, 234, 231, 250, 162, 69, 143, 201, 228, 183, 242, 135, 58, 4, 77, 34, 37, 203, 137, 215, 130, 23, 71, 119, 61, 55, 72, 112, 124, 24, 186, 92, 90, 244, 82, 46, 112, 201, 129, 240, 187, 254, 210, 134, 173, 218, 248, 75, 213, 6, 70, 63, 70, 213, 254, 104, 215, 115, 223, 251, 102, 85, 138, 66, 195, 216, 125, 246, 52, 55, 192, 212, 246, 72, 67, 98, 134, 25, 125, 244, 169, 11, 82, 231, 176, 146, 158, 166, 66, 70, 138, 180, 63, 46, 3, 172, 52, 207, 110, 99, 189, 95, 90, 189, 207, 137, 30, 62, 43, 235, 170, 168, 121, 195, 87, 224, 195, 225, 25, 71, 146, 94, 10, 27, 25, 79, 112, 31, 48, 238, 123, 8, 71, 29, 120, 125, 39, 11, 17, 136, 227, 212, 56, 8, 49, 54, 35, 222, 169, 169, 178, 159, 89, 98, 76, 77, 45, 219, 148, 231, 60, 44, 148, 193, 192, 165, 9, 140, 160, 99, 119, 116, 88, 21, 42, 60, 152, 77, 153, 105, 64, 173, 177, 50, 13, 213, 103, 104, 140, 12, 198, 221, 113, 141, 208, 204, 181, 135, 43, 99, 26, 148, 54, 224, 76, 180, 143, 2, 220, 223, 106, 36, 40, 98, 155, 46, 247, 111, 119, 34, 230, 213, 149, 183, 107, 207, 5, 13, 142, 206, 29, 227, 156, 22, 24, 66, 142, 141, 190, 112, 140, 12, 54, 195, 129, 210, 55, 157, 131, 170, 121, 174, 154, 230, 33, 33, 67, 18, 103, 97, 58, 227, 183, 66, 120, 244, 82, 122, 160, 118, 65, 245, 64, 160, 226, 15, 186, 208, 243, 29, 239, 7, 223, 189, 135, 187, 206, 93, 3, 44, 18, 53, 186, 244, 136, 105, 80, 164, 45, 225, 54, 199, 80, 153, 79, 17, 169, 164, 229, 80, 226, 94, 69, 191, 210, 18, 28, 44, 44, 56, 102, 136, 6, 4, 43, 34, 72, 145, 221, 122, 89, 149, 61, 58, 30, 48, 68, 162, 72, 144, 35, 48, 74, 72, 30, 207, 183, 184, 249, 0, 118, 219, 77, 78, 229, 68, 237, 48, 6, 239, 14, 86, 227, 10, 80, 117, 101, 97, 102, 192, 72, 252, 180, 117, 25, 181, 216, 180, 144, 144, 245, 253, 26, 39, 231, 182, 161, 105, 211, 232, 34, 82, 21, 205, 32, 167, 74, 41, 226, 27, 80, 28, 181, 19, 112, 162, 110, 66, 241, 86, 3, 98, 233, 177, 98, 79, 140, 164, 104, 66, 133, 8, 118, 136, 29, 127, 181, 240, 44, 30, 164, 64, 212, 8, 18, 6, 169, 169, 40, 162, 148, 148, 159, 157, 173, 84, 63, 130, 175, 28, 23, 89, 1, 15, 54, 5, 172, 72, 203, 201, 84, 100, 149, 140, 193, 246, 173, 70, 100, 183, 196, 68, 73, 28, 79, 116, 112, 130, 73, 41, 209, 237, 182, 125, 47, 107, 115, 215, 114, 243, 122, 52, 138, 36, 250, 88, 79, 74, 210, 3, 148, 55, 152, 104, 236, 52, 97, 16, 148, 72, 159, 87, 171, 127, 197, 234, 111, 22, 235, 132, 32, 68, 48, 155, 173, 230, 70, 10, 132, 36, 231, 70, 175, 68, 115, 49, 71, 53, 175, 235, 130, 177, 90, 118, 148, 225, 95, 213, 187, 9, 130, 252, 184, 100, 59, 96, 100, 223, 40, 203, 0, 171, 115, 146, 152, 174, 36, 160, 199, 66, 111, 83, 243, 178, 42, 48, 137, 120, 105, 66, 27, 190, 82, 206, 152, 241, 157, 14, 151, 252, 250, 155, 93, 125, 174, 135, 91, 81, 103, 98, 109, 12, 109, 230, 172, 221, 152, 73, 3, 96, 54, 133, 41, 192, 196, 20, 52, 41, 157, 17, 212, 116, 112, 216, 232, 66, 146, 36, 142, 243, 206, 182, 211, 0, 240, 35, 42, 154, 66, 216, 170, 228, 70, 4, 75, 27, 243, 208, 245, 186, 223, 75, 228, 230, 104, 232, 204, 83, 84, 253, 37, 123, 237, 156, 64, 36, 145, 195, 147, 178, 146, 246, 205, 90, 208, 169, 220, 181, 177, 69, 161, 24, 138, 64, 130, 48, 72, 8, 16, 88, 36, 72, 138, 132, 18, 8, 4, 70, 192, 133, 30, 118, 226, 193, 24, 17, 9, 167, 103, 107, 165, 211, 201, 55, 60, 55, 166, 226, 9, 135, 195, 51, 235, 86, 150, 144, 166, 24, 146, 193, 87, 232, 90, 140, 48, 223, 34, 182, 42, 174, 105, 210, 196, 12, 163, 164, 196, 18, 226, 252, 22, 181, 136, 175, 161, 215, 250, 184, 231, 240, 9, 153, 33, 56, 79, 203, 164, 122, 238, 117, 4, 197, 86, 150, 162, 22, 152, 23, 159, 216, 229, 115, 139, 136, 109, 102, 197, 21, 37, 53, 22, 97, 36, 196, 61, 203, 85, 165, 28, 68, 249, 87, 170, 145, 106, 16, 69, 3, 182, 165, 113, 105, 193, 197, 245, 178, 134, 98, 140, 103, 173, 237, 247, 64, 255, 59, 134, 8, 16, 32, 18, 39, 196, 71, 196, 239, 4, 230, 32, 9, 226, 137, 231, 192, 132, 2, 160, 50, 32, 73, 96, 156, 117, 173, 247, 26, 170, 74, 232, 189, 80, 66, 170, 214, 117, 248, 20, 6, 176, 92, 65, 25, 199, 64, 210, 64, 181, 228, 227, 47, 37, 235, 22, 132, 181, 190, 78, 253, 153, 184, 110, 171, 177, 0, 0, 146, 64, 73, 17, 76, 56, 10, 210, 72, 25, 16, 0, 171, 30, 186, 87, 66, 151, 125, 170, 203, 25, 24, 183, 127, 204, 26, 30, 230, 223, 235, 204, 207, 238, 250, 155, 157, 15, 55, 67, 109, 112, 53, 138, 18, 67, 153, 26, 62, 223, 191, 190, 250, 120, 241, 161, 37, 205, 205, 230, 252, 95, 14, 134, 150, 66, 128, 216, 120, 87, 174, 187, 251, 240, 2, 41, 140, 245, 235, 124, 220, 190, 15, 48, 177, 231, 79, 75, 211, 79, 82, 202, 33, 220, 136, 144, 136, 161, 255, 16, 5, 105, 136, 44, 34, 27, 211, 197, 17, 95, 68, 143, 53, 248, 24, 57, 240, 95, 156, 156, 246, 207, 163, 233, 88, 92, 196, 117, 137, 68, 18, 26, 21, 12, 150, 18, 104, 92, 162, 172, 108, 242, 43, 55, 202, 88, 162, 212, 211, 154, 11, 223, 38, 0, 197, 137, 70, 49, 18, 128, 132, 2, 147, 5, 238, 92, 205, 95, 5, 13, 219, 5, 175, 108, 149, 239, 120, 95, 28, 52, 53, 141, 136, 93, 43, 177, 72, 130, 130, 149, 62, 3, 199, 177, 97, 23, 237, 18, 251, 184, 145, 190, 188, 159, 175, 251, 51, 67, 71, 94, 242, 196, 13, 15, 99, 159, 198, 209, 204, 232, 72, 133, 79, 190, 207, 239, 186, 153, 46, 72, 65, 140, 50, 103, 198, 133, 4, 216, 138, 105, 107, 148, 162, 8, 104, 201, 16, 2, 239, 91, 129, 254, 17, 93, 34, 119, 116, 217, 100, 45, 93, 55, 43, 117, 200, 212, 54, 44, 9, 159, 43, 33, 223, 32, 252, 66, 226, 179, 231, 216, 129, 136, 44, 239, 90, 129, 36, 144, 82, 202, 181, 244, 38, 212, 162, 19, 63, 69, 102, 197, 234, 197, 175, 61, 139, 182, 73, 89, 168, 191, 20, 75, 101, 141, 165, 25, 112, 145, 143, 149, 193, 147, 25, 118, 231, 25, 28, 42, 168, 57, 113, 162, 220, 98, 150, 172, 79, 215, 216, 207, 75, 16, 155, 64, 10, 134, 219, 18, 104, 73, 213, 30, 80, 177, 198, 33, 76, 211, 83, 133, 239, 125, 78, 83, 255, 139, 152, 100, 96, 110, 182, 156, 247, 16, 169, 120, 232, 222, 180, 208, 155, 94, 216, 120, 105, 152, 24, 79, 74, 106, 51, 37, 111, 181, 15, 84, 0, 56, 54, 92, 197, 6, 225, 66, 33, 69, 136, 105, 170, 115, 54, 250, 58, 249, 154, 94, 49, 56, 180, 51, 50, 173, 185, 215, 194, 105, 83, 127, 162, 247, 153, 156, 44, 17, 173, 195, 59, 44, 62, 158, 1, 197, 171, 50, 244, 126, 141, 169, 6, 122, 138, 37, 1, 205, 101, 28, 119, 119, 107, 11, 160, 18, 14, 96, 160, 22, 136, 0, 210, 126, 52, 1, 2, 240, 64, 30, 241, 117, 16, 58, 98, 45, 162, 84, 17, 162, 42, 16, 128, 36, 190, 45, 30, 217, 61, 121, 167, 213, 225, 85, 210, 10, 186, 196, 64, 231, 12, 235, 139, 90, 250, 213, 172, 1, 209, 65, 156, 93, 75, 214, 22, 246, 234, 129, 189, 215, 102, 203, 142, 55, 78, 3, 37, 193, 68, 192, 49, 97, 138, 148, 132, 149, 166, 72, 101, 163, 251, 91, 10, 239, 76, 174, 232, 105, 138, 49, 62, 42, 247, 106, 225, 169, 203, 67, 218, 92, 229, 0, 123, 250, 211, 38, 59, 226, 129, 43, 200, 138, 64, 230, 182, 47, 209, 52, 204, 158, 70, 149, 119, 139, 41, 130, 142, 15, 66, 18, 100, 193, 193, 129, 132, 71, 175, 191, 10, 43, 21, 60, 60, 229, 99, 175, 198, 56, 250, 23, 215, 166, 14, 248, 61, 2, 145, 81, 231, 61, 197, 179, 101, 3, 120, 113, 85, 168, 2, 70, 56, 48, 86, 107, 164, 188, 225, 181, 173, 107, 55, 137, 146, 69, 8, 0, 100, 64, 208, 56, 155, 5, 4, 48, 71, 57, 53, 142, 166, 187, 200, 40, 200, 165, 136, 34, 96, 130, 161, 80, 36, 119, 253, 118, 44, 139, 128, 231, 222, 35, 125, 251, 199, 13, 34, 115, 37, 72, 111, 170, 56, 13, 53, 11, 188, 29, 202, 222, 38, 183, 53, 71, 100, 144, 139, 210, 51, 113, 91, 132, 161, 133, 182, 4, 236, 156, 116, 232, 247, 188, 20, 122, 60, 253, 75, 43, 120, 169, 120, 162, 90, 48, 157, 237, 142, 218, 173, 167, 154, 78, 212, 27, 46, 132, 6, 146, 1, 6, 18, 44, 130, 192, 116, 129, 67, 14, 69, 10, 218, 168, 89, 59, 71, 69, 15, 96, 236, 81, 210, 68, 92, 225, 215, 171, 171, 2, 166, 248, 57, 128, 239, 128, 18, 10, 188, 230, 180, 27, 224, 100, 136, 166, 34, 56, 133, 162, 21, 63, 2, 142, 31, 207, 113, 193, 0, 13, 182, 104, 84, 192, 154, 137, 73, 180, 36, 193, 1, 36, 85, 109, 20, 214, 14, 145, 16, 163, 152, 18, 180, 69, 215, 151, 159, 168, 183, 67, 0, 107, 9, 1, 180, 81, 140, 249, 239, 4, 245, 55, 156, 225, 51, 33, 67, 22, 166, 170, 118, 183, 75, 25, 12, 77, 109, 205, 182, 226, 92, 224, 192, 177, 173, 97, 36, 68, 28, 251, 185, 59, 177, 45, 111, 1, 167, 115, 189, 64, 246, 226, 61, 216, 12, 136, 164, 170, 67, 124, 181, 52, 50, 32, 150, 139, 183, 142, 248, 252, 50, 224, 52, 203, 96, 183, 116, 60, 26, 52, 41, 130, 10, 81, 5, 230, 179, 179, 120, 2, 144, 43, 96, 60, 100, 151, 68, 217, 19, 100, 204, 144, 71, 118, 192, 119, 131, 96, 163, 68, 161, 166, 156, 166, 128, 58, 142, 169, 174, 134, 150, 28, 193, 36, 17, 47, 0, 144, 97, 207, 74, 156, 195, 187, 48, 162, 148, 0, 211, 128, 58, 70, 204, 122, 224, 188, 103, 40, 9, 221, 142, 30, 225, 67, 64, 155, 224, 111, 135, 77, 154, 223, 203, 160, 170, 44, 218, 0, 98, 66, 10, 70, 10, 75, 85, 64, 136, 96, 185, 30, 79, 26, 228, 130, 24, 132, 98, 180, 237, 0, 204, 85, 58, 117, 47, 147, 44, 146, 1, 132, 9, 21, 49, 9, 36, 114, 35, 203, 46, 115, 140, 2, 149, 10, 0, 128, 49, 80, 108, 43, 101, 41, 18, 70, 202, 36, 68, 168, 161, 74, 36, 106, 131, 22, 30, 80, 65, 188, 46, 239, 205, 128, 204, 13, 135, 131, 19, 182, 91, 129, 154, 83, 116, 0, 220, 65, 67, 113, 20, 246, 196, 7, 137, 0, 3, 4, 16, 36, 49, 21, 223, 3, 75, 59, 249, 92, 11, 17, 71, 1, 0, 114, 16, 19, 43, 117, 146, 178, 197, 5, 63, 252, 93, 201, 20, 225, 66, 66, 35, 112, 48, 164 };

constexpr std::array<u8, 1036> HG_HEADBUTT = { 14, 17, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 121, 161, 29, 221, 0, 5, 168, 127, 254, 127, 255, 255, 255, 209, 254, 68, 56, 12, 128, 2, 132, 253, 224, 255, 62, 232, 100, 28, 4, 140, 192, 32, 1, 0, 4, 1, 0, 80, 4, 207, 1, 82, 0, 0, 122, 6, 18, 166, 80, 73, 160, 122, 158, 154, 153, 26, 50, 61, 64, 0, 208, 3, 67, 210, 6, 154, 6, 38, 135, 168, 54, 213, 0, 112, 100, 26, 52, 1, 147, 76, 67, 77, 6, 65, 136, 97, 3, 64, 104, 196, 196, 104, 0, 0, 224, 200, 52, 104, 3, 38, 152, 134, 154, 12, 131, 16, 194, 6, 128, 209, 137, 136, 208, 0, 0, 202, 160, 0, 0, 17, 131, 67, 64, 0, 70, 0, 0, 0, 0, 0, 1, 18, 66, 66, 100, 155, 20, 193, 168, 104, 134, 128, 13, 13, 26, 0, 0, 0, 26, 52, 200, 201, 182, 169, 164, 243, 31, 156, 97, 212, 129, 194, 26, 8, 69, 78, 164, 247, 17, 220, 21, 162, 82, 140, 214, 116, 164, 60, 60, 85, 35, 68, 160, 143, 225, 65, 77, 203, 117, 56, 196, 71, 164, 233, 129, 242, 131, 70, 251, 15, 145, 107, 206, 176, 88, 152, 60, 178, 146, 201, 38, 153, 215, 206, 90, 168, 51, 152, 197, 25, 204, 206, 40, 161, 206, 25, 20, 134, 86, 8, 24, 49, 130, 198, 48, 66, 5, 48, 39, 151, 166, 193, 96, 185, 130, 5, 90, 18, 88, 134, 99, 182, 102, 206, 24, 184, 81, 88, 25, 152, 160, 149, 84, 202, 166, 168, 162, 72, 81, 41, 149, 78, 98, 180, 92, 105, 172, 88, 192, 194, 229, 101, 12, 175, 70, 88, 106, 245, 130, 248, 181, 25, 24, 201, 151, 197, 153, 87, 40, 176, 90, 208, 10, 44, 81, 149, 195, 23, 112, 133, 163, 108, 96, 190, 27, 56, 28, 25, 16, 177, 70, 11, 183, 196, 197, 75, 50, 12, 177, 221, 133, 22, 36, 9, 86, 148, 28, 35, 124, 130, 16, 148, 42, 87, 198, 111, 85, 238, 59, 62, 82, 88, 150, 38, 68, 65, 139, 8, 66, 32, 32, 243, 162, 48, 65, 232, 68, 116, 46, 136, 250, 42, 174, 84, 100, 98, 139, 151, 47, 121, 207, 204, 88, 229, 52, 12, 51, 54, 154, 33, 152, 132, 163, 3, 160, 46, 14, 79, 63, 129, 9, 194, 128, 160, 162, 40, 138, 160, 162, 218, 185, 91, 114, 54, 182, 244, 214, 246, 249, 43, 243, 122, 80, 165, 37, 223, 89, 107, 73, 106, 223, 229, 200, 253, 239, 203, 47, 203, 102, 109, 249, 155, 51, 106, 247, 12, 100, 150, 84, 21, 24, 10, 128, 197, 16, 15, 182, 34, 27, 218, 136, 254, 108, 85, 145, 50, 119, 180, 31, 99, 144, 55, 171, 216, 2, 236, 25, 18, 17, 239, 239, 223, 250, 120, 247, 240, 123, 138, 36, 249, 206, 240, 68, 8, 65, 15, 100, 30, 242, 194, 17, 36, 24, 72, 48, 72, 37, 236, 23, 2, 72, 48, 96, 150, 84, 63, 95, 9, 8, 247, 47, 130, 1, 34, 163, 113, 184, 60, 81, 166, 130, 168, 96, 157, 217, 11, 224, 98, 150, 27, 12, 18, 66, 12, 8, 89, 27, 36, 130, 72, 16, 32, 16, 131, 129, 207, 66, 31, 71, 236, 109, 30, 21, 117, 8, 105, 29, 53, 29, 3, 168, 125, 177, 216, 15, 112, 123, 143, 96, 105, 214, 7, 19, 212, 64, 225, 44, 54, 20, 239, 133, 199, 235, 118, 49, 181, 138, 45, 84, 20, 228, 118, 114, 12, 204, 79, 14, 24, 172, 32, 27, 79, 124, 198, 1, 224, 70, 154, 8, 132, 2, 128, 240, 4, 6, 17, 15, 8, 93, 46, 140, 139, 18, 0, 81, 118, 0, 200, 66, 6, 137, 37, 129, 129, 68, 6, 12, 240, 70, 134, 36, 8, 132, 76, 5, 192, 128, 68, 9, 16, 33, 21, 165, 47, 226, 38, 238, 19, 156, 182, 70, 98, 12, 8, 172, 96, 86, 81, 8, 50, 64, 134, 68, 189, 196, 44, 38, 146, 55, 96, 194, 5, 129, 187, 30, 89, 144, 68, 177, 35, 6, 44, 99, 16, 29, 221, 115, 128, 226, 11, 187, 117, 155, 13, 129, 114, 28, 1, 90, 124, 69, 78, 66, 167, 41, 197, 179, 3, 55, 74, 26, 75, 80, 228, 176, 119, 5, 27, 70, 12, 24, 20, 153, 66, 25, 242, 161, 161, 186, 148, 84, 32, 91, 252, 46, 100, 200, 48, 105, 235, 121, 49, 67, 76, 112, 224, 132, 36, 45, 100, 145, 15, 30, 35, 119, 1, 8, 200, 68, 41, 137, 168, 26, 120, 249, 232, 11, 131, 23, 13, 4, 88, 48, 143, 144, 232, 8, 37, 3, 102, 57, 246, 127, 192, 216, 30, 144, 119, 141, 8, 121, 7, 180, 80, 230, 7, 207, 133, 0, 11, 34, 128, 32, 51, 40, 2, 137, 104, 1, 128, 81, 6, 1, 2, 9, 2, 8, 32, 34, 89, 146, 97, 47, 83, 88, 157, 3, 235, 143, 69, 246, 167, 154, 219, 178, 121, 151, 0, 234, 132, 116, 6, 199, 96, 51, 82, 235, 7, 74, 26, 220, 144, 208, 240, 60, 199, 110, 29, 152, 115, 65, 149, 167, 156, 46, 66, 227, 206, 114, 23, 45, 232, 19, 112, 96, 190, 108, 171, 57, 138, 77, 102, 11, 203, 107, 29, 141, 24, 134, 55, 24, 182, 221, 208, 181, 77, 167, 87, 1, 204, 109, 39, 106, 201, 207, 110, 67, 148, 235, 19, 45, 220, 154, 67, 151, 148, 11, 139, 115, 140, 227, 13, 163, 172, 218, 60, 1, 176, 56, 142, 16, 235, 6, 159, 156, 124, 163, 189, 222, 244, 59, 71, 107, 180, 118, 59, 30, 39, 211, 30, 163, 168, 53, 6, 163, 81, 168, 29, 64, 234, 13, 67, 208, 116, 98, 15, 32, 246, 3, 89, 216, 29, 131, 204, 110, 12, 230, 160, 206, 102, 7, 194, 34, 34, 35, 85, 149, 74, 34, 99, 255, 139, 185, 34, 156, 40, 72, 60, 208, 142, 238, 128 };

constexpr std::array<u8, 147> HGSS_BUG = { 168, 0, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 142, 171, 119, 28, 0, 0, 79, 120, 224, 96, 191, 240, 125, 84, 1, 64, 48, 0, 8, 128, 1, 240, 0, 160, 0, 100, 37, 34, 79, 72, 255, 85, 25, 52, 245, 1, 154, 143, 19, 213, 4, 170, 159, 250, 169, 50, 49, 146, 105, 128, 2, 49, 107, 218, 246, 190, 90, 86, 189, 180, 156, 211, 38, 73, 36, 146, 220, 204, 140, 156, 240, 113, 233, 97, 223, 99, 209, 2, 5, 54, 165, 48, 174, 85, 195, 217, 40, 203, 201, 142, 40, 235, 40, 128, 227, 59, 64, 103, 9, 179, 141, 18, 67, 110, 64, 69, 34, 50, 34, 168, 136, 95, 212, 33, 18, 89, 60, 100, 130, 158, 68, 152, 236, 93, 201, 20, 225, 66, 66, 58, 173, 220, 112 };

constexpr std::array<u8, 1871> HGSS_SAFARI = { 120, 42, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 22, 76, 137, 85, 0, 12, 51, 127, 255, 255, 247, 255, 255, 111, 255, 255, 254, 159, 254, 254, 102, 253, 111, 253, 147, 124, 0, 143, 255, 248, 0, 46, 142, 187, 216, 2, 0, 6, 24, 1, 8, 96, 7, 95, 62, 205, 1, 52, 179, 183, 16, 128, 86, 230, 58, 0, 4, 148, 146, 1, 31, 160, 16, 200, 4, 198, 64, 3, 106, 155, 202, 52, 77, 61, 2, 52, 201, 163, 16, 104, 209, 163, 67, 70, 140, 128, 24, 131, 65, 160, 52, 0, 98, 27, 80, 101, 84, 211, 202, 61, 64, 0, 245, 26, 122, 154, 0, 1, 166, 76, 128, 26, 0, 0, 0, 12, 67, 77, 13, 0, 0, 0, 0, 122, 128, 13, 0, 245, 16, 50, 49, 26, 48, 38, 140, 131, 0, 154, 52, 208, 96, 140, 134, 2, 48, 9, 145, 166, 38, 38, 35, 70, 70, 16, 104, 200, 96, 19, 76, 0, 9, 137, 136, 64, 200, 196, 104, 192, 154, 50, 12, 2, 104, 211, 65, 130, 50, 24, 8, 192, 38, 70, 152, 152, 152, 141, 25, 24, 65, 163, 33, 128, 77, 48, 0, 38, 38, 32, 109, 68, 16, 154, 5, 54, 144, 158, 106, 152, 208, 39, 160, 13, 32, 49, 48, 2, 24, 77, 24, 140, 140, 76, 35, 2, 26, 96, 70, 19, 76, 0, 2, 96, 0, 17, 36, 130, 52, 200, 131, 64, 164, 244, 212, 245, 25, 61, 71, 169, 234, 100, 0, 104, 104, 109, 64, 0, 52, 105, 161, 160, 0, 208, 200, 13, 6, 128, 52, 52, 0, 102, 167, 164, 109, 78, 165, 219, 117, 227, 158, 203, 194, 253, 250, 76, 242, 156, 250, 103, 197, 171, 118, 254, 247, 61, 181, 195, 109, 108, 221, 150, 129, 219, 8, 49, 137, 23, 159, 61, 247, 245, 189, 14, 154, 129, 92, 224, 241, 65, 46, 128, 39, 87, 175, 233, 117, 117, 173, 222, 122, 147, 189, 181, 250, 129, 229, 57, 219, 19, 22, 138, 170, 118, 123, 88, 176, 148, 37, 6, 168, 51, 232, 117, 78, 38, 148, 75, 142, 128, 97, 47, 200, 226, 144, 4, 83, 56, 130, 113, 62, 83, 137, 130, 6, 220, 101, 11, 134, 25, 160, 69, 220, 86, 198, 97, 19, 47, 172, 52, 93, 70, 71, 116, 165, 142, 59, 178, 125, 254, 101, 243, 248, 244, 26, 88, 4, 253, 50, 10, 129, 46, 50, 101, 0, 236, 82, 188, 166, 54, 223, 46, 82, 111, 56, 208, 79, 148, 66, 17, 158, 168, 122, 60, 114, 255, 72, 248, 142, 59, 141, 253, 131, 152, 192, 121, 125, 217, 14, 81, 212, 82, 39, 144, 247, 199, 88, 243, 122, 93, 63, 245, 71, 248, 221, 215, 136, 57, 61, 142, 190, 106, 188, 82, 50, 10, 146, 64, 233, 40, 149, 41, 89, 146, 139, 171, 73, 69, 134, 160, 226, 112, 184, 112, 114, 170, 212, 167, 170, 124, 228, 25, 52, 54, 115, 196, 250, 253, 86, 43, 21, 100, 10, 168, 98, 98, 162, 45, 181, 75, 190, 169, 29, 63, 116, 119, 113, 225, 162, 144, 138, 60, 164, 213, 103, 147, 175, 42, 210, 17, 25, 226, 156, 132, 60, 172, 199, 135, 138, 132, 147, 30, 30, 30, 173, 117, 49, 230, 86, 167, 208, 5, 195, 98, 175, 100, 133, 169, 169, 86, 242, 192, 53, 180, 235, 13, 226, 110, 70, 197, 117, 220, 137, 62, 34, 68, 226, 213, 29, 29, 164, 253, 150, 131, 208, 59, 247, 145, 92, 45, 113, 107, 43, 138, 185, 92, 13, 26, 81, 162, 90, 150, 57, 40, 226, 203, 54, 8, 68, 178, 29, 234, 127, 166, 203, 236, 59, 101, 136, 79, 212, 148, 229, 90, 194, 45, 96, 195, 135, 99, 65, 119, 128, 161, 171, 35, 8, 140, 55, 209, 43, 140, 50, 223, 132, 156, 38, 4, 194, 243, 8, 193, 42, 103, 75, 242, 129, 73, 88, 133, 25, 130, 90, 67, 86, 196, 199, 26, 162, 183, 105, 146, 230, 38, 212, 236, 197, 67, 117, 143, 132, 98, 152, 238, 98, 19, 70, 99, 15, 136, 234, 52, 152, 41, 161, 163, 33, 102, 63, 9, 242, 190, 31, 116, 216, 133, 127, 121, 102, 206, 5, 139, 22, 37, 85, 85, 120, 53, 60, 12, 220, 197, 204, 205, 238, 129, 238, 0, 117, 100, 96, 38, 9, 123, 131, 131, 76, 67, 34, 55, 178, 48, 141, 232, 222, 217, 189, 197, 34, 146, 139, 178, 116, 157, 55, 56, 234, 141, 82, 176, 188, 78, 61, 100, 84, 202, 13, 201, 116, 182, 88, 168, 164, 168, 177, 225, 55, 181, 251, 252, 187, 241, 49, 46, 47, 48, 111, 190, 254, 38, 138, 44, 89, 181, 172, 106, 226, 7, 69, 14, 20, 54, 161, 96, 108, 137, 97, 176, 228, 248, 89, 190, 223, 252, 190, 141, 235, 186, 204, 114, 101, 1, 222, 31, 2, 218, 141, 101, 148, 89, 40, 178, 156, 143, 72, 138, 211, 158, 130, 70, 17, 73, 36, 176, 85, 229, 130, 56, 233, 211, 52, 140, 223, 222, 50, 117, 124, 162, 174, 34, 146, 88, 227, 171, 229, 154, 62, 109, 177, 182, 134, 52, 198, 100, 153, 24, 203, 150, 163, 223, 170, 212, 242, 247, 170, 124, 209, 182, 219, 61, 169, 229, 207, 245, 39, 86, 242, 231, 44, 165, 96, 182, 85, 146, 138, 109, 43, 133, 114, 172, 151, 177, 70, 32, 197, 137, 182, 166, 142, 43, 213, 174, 157, 209, 10, 36, 192, 214, 133, 202, 152, 21, 138, 116, 15, 137, 185, 25, 5, 2, 161, 68, 4, 69, 161, 64, 41, 24, 33, 132, 32, 135, 14, 186, 77, 41, 96, 37, 168, 45, 88, 95, 73, 163, 211, 69, 211, 58, 213, 155, 227, 16, 195, 28, 248, 76, 12, 0, 199, 22, 254, 165, 118, 10, 11, 92, 96, 140, 202, 186, 53, 185, 56, 185, 33, 227, 161, 249, 80, 214, 102, 194, 231, 239, 33, 16, 241, 137, 112, 63, 111, 243, 29, 217, 244, 24, 135, 140, 17, 141, 49, 187, 113, 55, 158, 188, 31, 206, 134, 179, 32, 142, 194, 169, 209, 203, 97, 29, 140, 51, 37, 66, 138, 164, 126, 161, 109, 54, 67, 99, 13, 44, 182, 34, 200, 66, 16, 177, 5, 100, 86, 86, 86, 58, 99, 4, 192, 60, 144, 138, 102, 36, 72, 153, 116, 200, 150, 9, 159, 253, 41, 202, 76, 44, 103, 81, 80, 48, 138, 139, 69, 4, 201, 150, 21, 153, 50, 128, 248, 106, 249, 23, 84, 148, 162, 148, 80, 84, 48, 73, 51, 82, 164, 164, 162, 171, 36, 173, 208, 70, 106, 106, 178, 74, 55, 149, 238, 145, 113, 111, 46, 19, 44, 13, 96, 107, 54, 213, 146, 81, 147, 56, 227, 142, 206, 214, 237, 145, 47, 140, 95, 38, 76, 190, 162, 230, 25, 124, 98, 249, 101, 28, 149, 122, 241, 144, 78, 215, 133, 143, 0, 113, 26, 184, 138, 120, 13, 161, 118, 33, 184, 184, 184, 185, 193, 185, 185, 185, 162, 138, 58, 80, 193, 233, 182, 232, 97, 217, 191, 3, 70, 247, 145, 229, 99, 123, 144, 194, 96, 239, 119, 188, 128, 211, 179, 184, 57, 202, 233, 33, 211, 27, 158, 62, 41, 155, 144, 254, 3, 163, 7, 137, 214, 134, 177, 179, 210, 53, 115, 60, 5, 29, 18, 116, 92, 88, 163, 140, 188, 177, 124, 150, 19, 168, 43, 202, 33, 202, 196, 32, 54, 24, 222, 103, 211, 163, 81, 120, 198, 33, 6, 152, 59, 141, 240, 144, 144, 156, 192, 60, 200, 113, 151, 119, 47, 114, 242, 60, 143, 57, 92, 156, 110, 254, 94, 124, 13, 175, 3, 194, 224, 112, 236, 212, 116, 178, 49, 57, 223, 64, 240, 56, 56, 182, 115, 45, 139, 185, 166, 206, 137, 175, 66, 67, 50, 66, 137, 155, 169, 192, 186, 195, 182, 198, 141, 52, 217, 198, 247, 16, 148, 209, 70, 44, 47, 113, 42, 206, 226, 176, 194, 176, 113, 110, 44, 92, 193, 129, 74, 85, 1, 118, 50, 172, 17, 116, 247, 11, 69, 5, 19, 145, 37, 81, 83, 170, 73, 206, 100, 71, 119, 129, 2, 5, 89, 33, 166, 212, 145, 79, 7, 33, 10, 163, 49, 124, 136, 36, 35, 6, 16, 31, 51, 179, 224, 15, 217, 126, 155, 221, 189, 167, 168, 250, 119, 246, 190, 108, 129, 122, 87, 20, 138, 198, 41, 20, 140, 185, 245, 55, 101, 0, 136, 84, 237, 28, 145, 252, 119, 10, 163, 242, 231, 225, 239, 137, 64, 36, 177, 76, 205, 100, 153, 38, 82, 223, 209, 105, 41, 167, 163, 89, 105, 70, 132, 81, 172, 225, 249, 52, 158, 32, 79, 144, 27, 150, 155, 164, 31, 159, 85, 112, 174, 87, 148, 220, 89, 114, 87, 64, 174, 145, 186, 110, 238, 168, 223, 37, 186, 191, 10, 155, 130, 191, 134, 210, 215, 63, 203, 250, 159, 145, 96, 196, 25, 14, 29, 228, 65, 152, 42, 225, 254, 158, 89, 99, 232, 158, 201, 183, 176, 246, 123, 232, 203, 190, 108, 92, 99, 231, 246, 251, 30, 103, 185, 144, 15, 56, 144, 140, 10, 72, 12, 44, 52, 158, 219, 179, 107, 3, 231, 3, 124, 6, 30, 31, 99, 118, 171, 131, 249, 78, 105, 225, 246, 188, 252, 246, 95, 68, 74, 140, 139, 73, 82, 168, 144, 133, 21, 2, 161, 80, 168, 74, 162, 154, 147, 171, 41, 15, 16, 161, 217, 229, 5, 70, 52, 234, 120, 209, 55, 78, 234, 183, 117, 113, 168, 146, 80, 157, 217, 33, 157, 201, 65, 167, 24, 123, 21, 169, 22, 154, 153, 37, 27, 42, 174, 217, 174, 216, 74, 84, 37, 165, 8, 152, 4, 81, 49, 172, 108, 160, 13, 86, 149, 137, 183, 31, 157, 138, 170, 167, 12, 87, 8, 14, 68, 6, 175, 227, 178, 8, 72, 168, 90, 8, 153, 86, 82, 202, 23, 48, 16, 227, 224, 171, 69, 33, 141, 14, 21, 166, 55, 32, 22, 173, 117, 100, 3, 6, 8, 87, 87, 110, 28, 62, 86, 253, 47, 199, 105, 135, 30, 72, 131, 177, 145, 132, 98, 70, 33, 24, 177, 140, 136, 17, 137, 24, 198, 34, 17, 138, 17, 219, 10, 18, 33, 17, 140, 66, 4, 82, 48, 27, 179, 133, 139, 18, 49, 33, 24, 194, 33, 24, 64, 131, 6, 49, 144, 8, 197, 145, 36, 132, 97, 8, 192, 99, 35, 2, 33, 21, 132, 82, 66, 33, 1, 35, 1, 35, 35, 22, 48, 32, 196, 36, 132, 97, 0, 140, 142, 56, 211, 191, 76, 53, 106, 225, 193, 68, 221, 109, 121, 220, 8, 120, 49, 36, 17, 71, 146, 234, 0, 67, 72, 128, 137, 199, 6, 48, 145, 81, 54, 193, 20, 62, 169, 23, 183, 247, 232, 168, 91, 181, 141, 148, 81, 255, 226, 238, 72, 167, 10, 18, 2, 201, 145, 42, 160 };

constexpr std::array<u8, 4205> PEARL = { 236, 82, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 43, 50, 205, 139, 0, 0, 185, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 215, 221, 255, 255, 254, 253, 255, 255, 255, 255, 255, 255, 172, 184, 125, 234, 253, 234, 157, 224, 0, 96, 18, 221, 245, 116, 130, 163, 59, 87, 45, 134, 199, 179, 171, 182, 213, 36, 171, 102, 61, 222, 120, 197, 61, 104, 79, 62, 156, 128, 15, 32, 0, 3, 64, 40, 20, 0, 18, 137, 38, 132, 211, 1, 10, 126, 169, 188, 133, 54, 83, 218, 52, 6, 77, 76, 5, 54, 41, 250, 161, 189, 72, 253, 79, 68, 26, 53, 61, 39, 169, 234, 105, 180, 109, 70, 147, 71, 145, 61, 70, 135, 162, 12, 135, 168, 0, 13, 0, 0, 6, 128, 0, 0, 0, 25, 60, 167, 180, 80, 73, 41, 161, 52, 201, 136, 98, 38, 76, 140, 37, 79, 211, 37, 60, 213, 55, 161, 60, 138, 61, 33, 250, 163, 218, 154, 143, 101, 54, 137, 30, 163, 61, 20, 245, 25, 48, 134, 158, 161, 145, 160, 50, 25, 0, 1, 234, 6, 64, 52, 0, 30, 144, 0, 61, 77, 1, 160, 218, 154, 13, 0, 138, 122, 38, 167, 169, 170, 105, 166, 9, 166, 4, 211, 35, 17, 137, 128, 154, 48, 154, 98, 100, 201, 137, 147, 38, 212, 194, 104, 192, 4, 194, 3, 76, 64, 193, 52, 97, 48, 33, 147, 35, 76, 67, 76, 76, 76, 19, 9, 166, 0, 0, 76, 76, 1, 10, 73, 18, 122, 167, 181, 33, 19, 76, 152, 3, 73, 166, 0, 17, 129, 161, 136, 0, 0, 19, 76, 33, 132, 209, 166, 1, 160, 1, 160, 8, 192, 208, 19, 0, 0, 2, 6, 1, 50, 102, 147, 0, 134, 140, 2, 170, 122, 154, 0, 0, 0, 104, 50, 98, 0, 0, 104, 200, 3, 77, 13, 50, 0, 0, 208, 0, 0, 208, 3, 38, 141, 0, 0, 0, 196, 100, 0, 1, 160, 0, 0, 6, 129, 160, 18, 34, 64, 147, 20, 211, 200, 212, 209, 130, 167, 148, 244, 158, 81, 167, 178, 166, 155, 77, 38, 154, 126, 164, 245, 61, 53, 61, 26, 53, 6, 245, 77, 31, 169, 181, 53, 54, 167, 148, 15, 80, 15, 83, 67, 32, 0, 0, 26, 54, 154, 131, 32, 1, 160, 0, 100, 218, 67, 64, 52, 0, 0, 235, 156, 249, 197, 162, 176, 179, 38, 197, 102, 201, 49, 131, 30, 193, 128, 105, 54, 80, 42, 64, 53, 215, 24, 171, 3, 235, 116, 0, 167, 253, 90, 130, 221, 31, 95, 204, 11, 180, 29, 103, 72, 171, 53, 250, 218, 144, 176, 137, 10, 120, 121, 17, 13, 252, 149, 223, 172, 46, 144, 214, 62, 2, 54, 10, 168, 115, 166, 68, 117, 164, 152, 130, 26, 206, 162, 16, 168, 171, 161, 14, 57, 68, 68, 194, 146, 220, 239, 206, 235, 172, 43, 44, 73, 36, 24, 47, 116, 186, 94, 28, 158, 206, 108, 83, 104, 245, 70, 114, 237, 65, 173, 148, 239, 109, 192, 3, 81, 127, 122, 121, 221, 163, 201, 75, 97, 67, 90, 42, 224, 207, 232, 1, 21, 95, 174, 107, 10, 68, 170, 128, 232, 111, 247, 101, 86, 53, 108, 234, 219, 117, 97, 20, 210, 117, 146, 118, 230, 80, 21, 170, 81, 86, 202, 1, 224, 123, 202, 197, 179, 122, 177, 89, 133, 179, 172, 234, 85, 249, 202, 3, 141, 228, 78, 164, 12, 99, 192, 39, 126, 248, 183, 244, 149, 192, 128, 242, 197, 97, 89, 220, 51, 79, 41, 110, 188, 136, 146, 195, 168, 180, 111, 232, 178, 6, 248, 16, 115, 59, 205, 36, 39, 46, 160, 30, 3, 200, 15, 195, 210, 252, 93, 129, 120, 11, 166, 2, 250, 40, 167, 196, 189, 152, 179, 14, 31, 76, 252, 229, 208, 48, 103, 157, 221, 153, 150, 46, 111, 57, 178, 100, 177, 168, 60, 82, 119, 197, 84, 184, 14, 253, 169, 116, 218, 36, 117, 202, 180, 76, 202, 229, 210, 232, 16, 92, 55, 57, 69, 251, 241, 230, 81, 32, 154, 237, 26, 214, 137, 97, 83, 147, 129, 250, 44, 83, 66, 81, 28, 164, 102, 70, 209, 132, 68, 36, 22, 74, 171, 89, 172, 18, 146, 129, 185, 193, 56, 31, 210, 153, 120, 72, 180, 87, 43, 129, 30, 158, 163, 9, 106, 50, 22, 162, 19, 36, 59, 80, 165, 16, 168, 164, 77, 3, 1, 129, 223, 115, 21, 243, 40, 218, 98, 192, 113, 77, 50, 108, 196, 102, 229, 156, 66, 173, 212, 57, 190, 130, 26, 202, 44, 174, 244, 36, 153, 87, 92, 63, 89, 28, 152, 198, 232, 136, 232, 2, 137, 84, 48, 192, 25, 166, 65, 84, 139, 145, 229, 177, 24, 76, 35, 12, 53, 38, 12, 131, 171, 199, 97, 225, 216, 84, 21, 150, 12, 42, 12, 69, 209, 40, 106, 200, 68, 31, 176, 147, 13, 9, 26, 169, 254, 158, 65, 124, 57, 39, 36, 229, 28, 183, 4, 114, 199, 144, 162, 130, 227, 106, 80, 202, 48, 141, 44, 45, 40, 143, 169, 140, 139, 10, 69, 68, 50, 111, 150, 149, 162, 70, 191, 29, 74, 104, 168, 26, 141, 54, 71, 112, 225, 210, 131, 202, 255, 34, 113, 78, 7, 66, 96, 4, 152, 73, 171, 52, 152, 189, 103, 167, 233, 191, 20, 102, 241, 220, 0, 117, 255, 251, 33, 125, 198, 24, 45, 61, 47, 185, 71, 29, 71, 18, 23, 157, 216, 37, 174, 82, 80, 21, 83, 124, 111, 204, 188, 128, 200, 200, 203, 9, 129, 208, 2, 240, 4, 216, 137, 181, 66, 122, 75, 182, 234, 35, 156, 233, 94, 49, 6, 237, 167, 90, 132, 242, 243, 101, 121, 61, 238, 234, 185, 161, 8, 24, 110, 0, 84, 41, 213, 94, 10, 204, 162, 180, 58, 91, 128, 184, 24, 66, 133, 102, 170, 67, 77, 113, 124, 12, 20, 81, 225, 36, 183, 150, 62, 74, 97, 250, 83, 8, 102, 25, 185, 167, 162, 146, 28, 245, 253, 136, 108, 42, 243, 137, 23, 156, 78, 86, 145, 210, 180, 66, 237, 103, 142, 79, 109, 154, 127, 34, 241, 143, 24, 177, 35, 10, 71, 171, 21, 64, 136, 98, 50, 88, 171, 16, 138, 168, 84, 18, 139, 57, 115, 14, 228, 211, 202, 254, 238, 235, 111, 164, 195, 108, 177, 112, 171, 217, 53, 199, 61, 103, 156, 234, 204, 51, 65, 211, 56, 131, 134, 24, 168, 173, 9, 89, 242, 38, 129, 208, 35, 182, 245, 231, 165, 166, 153, 233, 159, 43, 47, 10, 237, 164, 40, 117, 222, 81, 112, 78, 16, 147, 77, 4, 54, 68, 16, 44, 202, 214, 241, 117, 109, 142, 59, 205, 161, 47, 160, 83, 154, 216, 48, 212, 128, 241, 25, 10, 19, 88, 22, 70, 208, 98, 224, 235, 74, 238, 4, 116, 117, 141, 185, 25, 120, 94, 23, 184, 146, 68, 32, 28, 66, 93, 62, 45, 206, 167, 142, 249, 84, 133, 157, 142, 163, 93, 217, 86, 27, 30, 67, 58, 210, 195, 168, 153, 99, 114, 213, 178, 188, 79, 10, 42, 171, 214, 93, 196, 47, 167, 86, 224, 49, 124, 55, 64, 221, 54, 91, 101, 226, 2, 112, 136, 85, 146, 211, 54, 87, 88, 182, 120, 170, 149, 168, 176, 255, 107, 72, 149, 2, 189, 121, 95, 115, 75, 82, 143, 87, 50, 242, 161, 110, 109, 117, 239, 114, 217, 185, 71, 26, 201, 124, 225, 26, 232, 99, 132, 22, 117, 246, 204, 166, 169, 142, 46, 77, 1, 34, 160, 185, 2, 55, 172, 146, 153, 15, 230, 197, 5, 147, 141, 26, 205, 182, 232, 209, 109, 70, 48, 203, 199, 190, 109, 67, 203, 220, 232, 157, 207, 145, 120, 194, 96, 191, 132, 102, 103, 120, 112, 187, 38, 250, 193, 113, 6, 145, 196, 26, 65, 112, 170, 9, 130, 6, 199, 115, 112, 199, 134, 216, 81, 196, 110, 96, 199, 209, 34, 65, 33, 141, 150, 141, 188, 30, 74, 164, 113, 199, 28, 184, 144, 78, 44, 83, 6, 59, 105, 222, 211, 242, 27, 149, 143, 141, 99, 130, 86, 23, 179, 245, 241, 92, 140, 140, 49, 98, 183, 75, 142, 108, 106, 49, 230, 243, 114, 246, 154, 236, 109, 24, 28, 189, 42, 70, 160, 236, 144, 119, 14, 200, 136, 103, 15, 11, 209, 253, 83, 48, 205, 181, 253, 250, 5, 162, 34, 152, 4, 242, 121, 61, 54, 116, 225, 132, 86, 206, 45, 82, 217, 162, 98, 72, 65, 167, 133, 195, 152, 4, 82, 3, 152, 220, 148, 64, 233, 154, 7, 201, 60, 155, 152, 242, 78, 82, 10, 220, 183, 214, 214, 164, 5, 89, 248, 175, 229, 16, 141, 20, 27, 80, 41, 0, 129, 99, 106, 183, 84, 120, 222, 51, 93, 32, 222, 89, 212, 113, 122, 115, 81, 188, 13, 45, 150, 68, 10, 28, 102, 4, 204, 104, 107, 106, 108, 113, 237, 223, 35, 124, 111, 244, 1, 166, 52, 183, 103, 97, 210, 255, 152, 211, 43, 90, 90, 90, 115, 70, 149, 205, 33, 53, 139, 28, 133, 166, 73, 106, 206, 203, 142, 50, 52, 242, 175, 97, 10, 145, 219, 39, 172, 1, 250, 194, 193, 128, 150, 98, 245, 245, 125, 107, 15, 28, 229, 109, 80, 208, 57, 161, 82, 41, 48, 171, 37, 143, 128, 115, 120, 11, 33, 118, 215, 106, 117, 226, 160, 184, 126, 66, 164, 116, 203, 115, 197, 93, 17, 192, 82, 114, 77, 49, 233, 107, 178, 100, 48, 173, 19, 204, 156, 145, 216, 50, 79, 212, 62, 102, 153, 244, 144, 223, 189, 131, 46, 184, 79, 15, 112, 192, 9, 107, 111, 45, 101, 53, 110, 183, 176, 163, 192, 152, 83, 67, 214, 75, 118, 206, 74, 182, 98, 210, 130, 9, 223, 166, 157, 159, 133, 162, 147, 81, 23, 94, 158, 251, 157, 112, 47, 146, 153, 174, 110, 12, 241, 50, 14, 9, 160, 85, 5, 67, 215, 150, 104, 16, 214, 137, 13, 109, 161, 134, 176, 204, 103, 113, 68, 183, 140, 119, 100, 81, 16, 232, 190, 160, 68, 35, 48, 12, 74, 122, 161, 7, 47, 193, 129, 107, 237, 240, 203, 139, 155, 147, 54, 243, 159, 41, 64, 122, 244, 30, 163, 64, 212, 237, 148, 230, 86, 204, 38, 0, 193, 216, 74, 69, 0, 216, 97, 165, 69, 60, 61, 131, 113, 23, 21, 205, 185, 14, 53, 128, 214, 203, 223, 52, 3, 22, 126, 102, 206, 48, 177, 44, 59, 127, 63, 136, 181, 190, 150, 129, 69, 28, 242, 185, 176, 82, 142, 75, 91, 121, 38, 39, 120, 254, 109, 83, 70, 169, 202, 77, 121, 137, 224, 222, 40, 210, 42, 52, 130, 166, 225, 138, 107, 45, 109, 32, 21, 5, 65, 18, 54, 219, 212, 158, 46, 196, 145, 230, 90, 235, 47, 57, 233, 166, 230, 226, 57, 89, 198, 77, 200, 246, 180, 60, 140, 9, 96, 3, 2, 12, 20, 133, 43, 91, 119, 162, 113, 250, 222, 56, 205, 61, 203, 163, 24, 215, 120, 46, 231, 147, 14, 6, 194, 60, 220, 134, 43, 156, 136, 195, 125, 33, 159, 136, 102, 197, 158, 98, 108, 76, 106, 118, 215, 97, 119, 45, 211, 129, 48, 176, 175, 247, 53, 213, 203, 92, 97, 95, 5, 109, 73, 25, 106, 88, 198, 84, 198, 138, 234, 159, 83, 110, 197, 182, 178, 128, 144, 96, 220, 226, 98, 221, 57, 70, 210, 206, 209, 108, 228, 18, 10, 146, 65, 112, 143, 173, 145, 216, 244, 105, 169, 34, 210, 154, 142, 94, 197, 177, 197, 107, 84, 117, 71, 196, 196, 229, 134, 126, 50, 75, 214, 205, 251, 65, 215, 27, 253, 179, 73, 189, 33, 228, 109, 127, 221, 197, 200, 140, 44, 235, 176, 226, 72, 240, 172, 38, 115, 25, 134, 26, 139, 139, 29, 87, 89, 152, 186, 5, 165, 99, 59, 178, 71, 127, 206, 150, 92, 90, 24, 13, 22, 103, 145, 193, 31, 216, 121, 243, 171, 201, 208, 100, 54, 53, 77, 20, 251, 89, 235, 205, 86, 108, 252, 120, 190, 108, 32, 128, 61, 222, 190, 49, 201, 179, 102, 179, 140, 117, 138, 44, 37, 76, 187, 116, 130, 151, 241, 86, 2, 12, 90, 66, 160, 98, 177, 25, 84, 62, 111, 155, 151, 177, 213, 207, 236, 226, 144, 86, 16, 194, 182, 78, 53, 180, 211, 192, 63, 8, 197, 139, 26, 205, 44, 187, 76, 253, 254, 241, 94, 143, 159, 10, 169, 146, 158, 77, 48, 88, 206, 150, 199, 2, 75, 38, 19, 138, 243, 52, 146, 95, 28, 240, 56, 108, 145, 97, 107, 151, 153, 198, 166, 231, 38, 127, 81, 171, 194, 12, 237, 225, 96, 112, 105, 221, 173, 149, 157, 143, 27, 112, 225, 200, 6, 122, 222, 225, 71, 154, 209, 180, 168, 176, 178, 96, 31, 35, 31, 51, 76, 7, 196, 23, 168, 21, 180, 120, 0, 66, 5, 96, 34, 2, 184, 18, 1, 56, 24, 192, 152, 10, 128, 184, 7, 84, 7, 20, 11, 0, 8, 45, 1, 208, 5, 148, 142, 196, 211, 59, 171, 98, 232, 89, 108, 234, 68, 179, 208, 135, 94, 37, 95, 92, 91, 50, 195, 132, 18, 68, 58, 162, 228, 186, 193, 11, 4, 46, 201, 232, 163, 14, 8, 116, 232, 111, 43, 118, 253, 91, 248, 198, 10, 41, 134, 61, 146, 35, 212, 193, 7, 229, 48, 38, 74, 100, 110, 146, 36, 142, 140, 191, 140, 32, 224, 120, 243, 63, 127, 140, 104, 88, 114, 45, 52, 34, 60, 58, 17, 51, 250, 108, 244, 160, 153, 98, 96, 78, 203, 127, 187, 56, 193, 43, 177, 23, 132, 59, 163, 91, 28, 53, 90, 20, 103, 252, 245, 31, 187, 178, 237, 223, 118, 93, 203, 39, 225, 156, 95, 139, 96, 228, 88, 106, 95, 201, 91, 107, 99, 45, 141, 182, 217, 72, 73, 19, 66, 127, 215, 170, 238, 51, 236, 45, 36, 164, 212, 72, 75, 112, 75, 243, 252, 207, 81, 61, 213, 149, 185, 47, 68, 85, 81, 147, 128, 166, 48, 2, 50, 96, 136, 20, 21, 76, 80, 17, 237, 148, 68, 66, 72, 133, 85, 41, 80, 42, 132, 20, 40, 0, 49, 132, 226, 35, 165, 220, 39, 88, 229, 73, 73, 58, 225, 22, 73, 112, 65, 72, 186, 68, 34, 146, 72, 147, 69, 34, 156, 162, 40, 129, 213, 16, 232, 131, 97, 14, 97, 63, 9, 58, 40, 144, 133, 116, 240, 191, 11, 239, 64, 74, 99, 189, 204, 184, 209, 68, 64, 123, 193, 7, 162, 65, 247, 17, 20, 83, 86, 78, 236, 87, 105, 117, 104, 168, 14, 148, 61, 193, 100, 183, 27, 231, 1, 102, 150, 141, 228, 236, 208, 108, 74, 165, 59, 165, 94, 41, 199, 240, 194, 75, 57, 57, 49, 17, 144, 236, 194, 34, 41, 99, 35, 128, 186, 33, 93, 16, 74, 68, 72, 54, 78, 180, 166, 71, 127, 200, 10, 74, 7, 57, 221, 214, 23, 244, 222, 26, 28, 230, 250, 21, 23, 12, 37, 88, 220, 72, 244, 196, 90, 11, 226, 31, 148, 190, 106, 226, 128, 238, 54, 217, 115, 57, 209, 226, 35, 5, 8, 55, 139, 197, 155, 244, 88, 54, 11, 126, 73, 40, 182, 177, 219, 64, 160, 43, 74, 164, 43, 21, 115, 89, 38, 245, 144, 88, 13, 89, 202, 82, 20, 84, 32, 35, 150, 224, 156, 158, 199, 191, 149, 157, 209, 245, 160, 47, 197, 233, 69, 240, 18, 25, 233, 129, 187, 98, 15, 15, 94, 98, 114, 237, 213, 57, 164, 176, 98, 201, 76, 96, 245, 112, 62, 25, 32, 240, 174, 74, 64, 228, 164, 35, 17, 206, 147, 1, 103, 50, 72, 119, 120, 38, 97, 137, 82, 140, 103, 61, 30, 205, 19, 8, 107, 178, 183, 124, 187, 221, 174, 205, 55, 25, 237, 164, 152, 193, 166, 52, 25, 216, 61, 150, 173, 245, 100, 112, 243, 167, 109, 188, 243, 208, 26, 54, 90, 179, 251, 123, 15, 24, 93, 80, 198, 31, 72, 161, 33, 71, 13, 182, 247, 226, 160, 218, 62, 115, 29, 132, 167, 239, 176, 16, 116, 234, 2, 159, 34, 215, 16, 233, 220, 214, 110, 200, 200, 118, 169, 243, 11, 25, 231, 56, 63, 9, 26, 67, 118, 218, 206, 140, 223, 100, 165, 252, 188, 157, 62, 138, 49, 151, 182, 236, 111, 190, 33, 81, 153, 33, 2, 112, 190, 214, 214, 125, 113, 134, 109, 47, 8, 199, 31, 28, 2, 119, 137, 69, 168, 141, 23, 62, 22, 235, 57, 126, 105, 184, 46, 211, 87, 122, 125, 19, 32, 207, 0, 3, 158, 0, 192, 47, 229, 174, 171, 2, 207, 50, 232, 180, 142, 119, 65, 237, 252, 28, 136, 53, 197, 185, 212, 225, 134, 198, 106, 239, 238, 241, 93, 139, 109, 28, 157, 192, 118, 4, 208, 88, 209, 211, 68, 32, 206, 10, 108, 89, 167, 192, 77, 77, 19, 97, 70, 152, 200, 8, 42, 69, 108, 52, 66, 238, 69, 155, 19, 160, 138, 236, 132, 161, 134, 173, 197, 5, 102, 207, 105, 118, 206, 147, 209, 180, 48, 94, 242, 90, 169, 101, 11, 89, 4, 7, 103, 183, 214, 96, 241, 25, 185, 131, 44, 105, 48, 96, 252, 191, 14, 18, 120, 30, 7, 175, 222, 71, 152, 140, 11, 13, 124, 210, 64, 203, 136, 152, 76, 129, 193, 49, 200, 134, 141, 168, 111, 225, 89, 38, 188, 94, 231, 243, 247, 142, 58, 250, 140, 247, 163, 60, 189, 214, 171, 64, 157, 168, 27, 244, 246, 76, 132, 204, 32, 240, 81, 189, 0, 78, 113, 254, 20, 192, 148, 236, 0, 236, 154, 71, 67, 183, 189, 85, 67, 75, 169, 101, 164, 145, 30, 231, 35, 137, 20, 136, 228, 14, 9, 211, 230, 67, 9, 22, 188, 79, 125, 251, 146, 115, 205, 41, 246, 57, 106, 101, 93, 120, 246, 208, 115, 244, 116, 245, 98, 202, 21, 235, 244, 245, 246, 67, 238, 130, 105, 170, 178, 237, 151, 2, 154, 150, 188, 156, 147, 59, 64, 65, 0, 0, 8, 0, 0, 72, 202, 161, 216, 60, 7, 177, 233, 59, 79, 67, 189, 14, 119, 69, 69, 34, 81, 233, 209, 16, 209, 193, 8, 131, 132, 152, 178, 199, 107, 140, 42, 66, 40, 151, 35, 42, 42, 169, 41, 141, 3, 65, 204, 240, 249, 92, 223, 11, 181, 214, 214, 239, 121, 252, 126, 206, 249, 129, 141, 54, 147, 99, 77, 180, 12, 195, 225, 119, 122, 25, 134, 67, 158, 136, 51, 90, 24, 129, 137, 137, 0, 208, 197, 13, 6, 70, 5, 228, 175, 55, 85, 1, 17, 5, 69, 49, 80, 22, 251, 26, 130, 98, 146, 164, 36, 170, 231, 49, 113, 37, 153, 34, 10, 18, 43, 49, 19, 37, 136, 76, 149, 201, 165, 152, 166, 10, 72, 14, 9, 168, 196, 67, 72, 200, 16, 176, 18, 66, 28, 192, 120, 0, 227, 134, 210, 105, 195, 12, 72, 2, 76, 129, 44, 40, 25, 7, 21, 8, 83, 224, 203, 105, 77, 105, 96, 194, 193, 176, 216, 93, 196, 133, 12, 64, 201, 191, 3, 32, 152, 234, 149, 10, 98, 84, 48, 205, 4, 177, 16, 7, 0, 99, 152, 233, 221, 26, 41, 102, 8, 33, 13, 128, 122, 94, 46, 219, 92, 13, 105, 52, 18, 20, 177, 18, 67, 16, 196, 36, 60, 184, 24, 85, 81, 37, 35, 18, 178, 48, 137, 3, 32, 66, 67, 33, 8, 231, 87, 78, 66, 104, 165, 194, 200, 83, 19, 99, 101, 170, 136, 201, 114, 40, 35, 39, 40, 144, 243, 22, 0, 160, 138, 223, 43, 75, 254, 227, 242, 123, 141, 47, 87, 43, 239, 161, 204, 163, 163, 137, 149, 8, 8, 98, 162, 138, 138, 170, 10, 168, 170, 11, 85, 23, 251, 213, 211, 163, 242, 240, 119, 90, 58, 89, 84, 114, 119, 218, 148, 117, 51, 183, 180, 40, 103, 112, 245, 123, 12, 207, 35, 78, 173, 2, 173, 5, 84, 3, 137, 195, 98, 2, 52, 9, 41, 7, 111, 84, 59, 242, 74, 137, 208, 72, 236, 1, 177, 3, 68, 146, 37, 208, 97, 133, 74, 20, 196, 179, 65, 77, 158, 155, 64, 105, 6, 32, 33, 32, 98, 88, 26, 160, 79, 183, 221, 190, 207, 183, 248, 123, 250, 35, 156, 227, 132, 230, 24, 68, 17, 192, 77, 154, 34, 166, 38, 162, 8, 136, 146, 73, 169, 136, 106, 8, 146, 24, 162, 34, 104, 34, 46, 89, 28, 6, 5, 96, 101, 226, 66, 142, 82, 72, 20, 146, 144, 5, 52, 36, 144, 197, 98, 155, 128, 220, 102, 8, 80, 181, 147, 146, 108, 244, 114, 148, 162, 110, 168, 8, 232, 92, 68, 48, 134, 134, 96, 2, 72, 136, 40, 36, 151, 146, 4, 52, 116, 131, 56, 9, 180, 23, 71, 130, 92, 230, 173, 0, 96, 194, 228, 14, 20, 64, 12, 52, 140, 163, 73, 68, 6, 252, 92, 204, 92, 38, 42, 152, 162, 169, 121, 140, 24, 177, 130, 116, 114, 152, 26, 38, 42, 42, 18, 97, 147, 104, 232, 162, 133, 210, 20, 69, 115, 48, 198, 98, 41, 73, 26, 18, 106, 162, 98, 38, 88, 102, 6, 35, 159, 4, 127, 94, 26, 166, 11, 142, 25, 82, 213, 20, 9, 146, 166, 74, 84, 84, 150, 236, 65, 196, 146, 41, 36, 34, 65, 137, 86, 8, 134, 74, 65, 141, 248, 14, 20, 192, 89, 131, 180, 33, 70, 198, 206, 119, 124, 107, 42, 178, 77, 8, 202, 106, 164, 73, 36, 165, 42, 74, 101, 114, 200, 195, 154, 145, 40, 192, 24, 107, 110, 38, 150, 121, 225, 195, 104, 137, 14, 92, 28, 152, 136, 18, 98, 36, 98, 25, 33, 40, 105, 104, 104, 166, 128, 222, 212, 12, 152, 80, 40, 96, 160, 28, 112, 176, 150, 20, 186, 32, 123, 75, 75, 130, 164, 88, 21, 33, 214, 232, 221, 128, 112, 72, 98, 209, 101, 201, 188, 177, 57, 97, 218, 40, 106, 134, 146, 36, 18, 96, 167, 32, 44, 113, 144, 96, 12, 156, 25, 11, 142, 104, 184, 109, 156, 113, 170, 162, 142, 0, 242, 104, 230, 56, 111, 55, 27, 209, 0, 164, 80, 128, 36, 74, 231, 193, 149, 76, 36, 6, 74, 133, 8, 98, 150, 72, 30, 26, 1, 48, 212, 129, 66, 112, 135, 9, 162, 32, 130, 68, 104, 37, 136, 1, 154, 32, 128, 229, 16, 226, 35, 135, 21, 56, 167, 42, 144, 238, 77, 108, 13, 183, 47, 34, 108, 236, 194, 137, 146, 129, 48, 160, 255, 244, 56, 68, 68, 64, 81, 33, 60, 187, 206, 119, 70, 6, 24, 59, 204, 192, 220, 57, 96, 56, 128, 129, 177, 185, 150, 56, 83, 105, 120, 178, 187, 46, 155, 107, 66, 172, 66, 178, 219, 80, 175, 92, 133, 35, 135, 32, 238, 78, 110, 193, 72, 68, 187, 165, 204, 230, 230, 144, 215, 46, 25, 173, 107, 168, 0, 127, 2, 12, 144, 47, 157, 21, 3, 154, 200, 18, 175, 53, 146, 97, 73, 16, 226, 192, 27, 206, 13, 173, 146, 81, 163, 134, 215, 55, 139, 205, 57, 2, 214, 147, 159, 37, 106, 146, 136, 135, 2, 32, 170, 98, 136, 138, 135, 158, 193, 113, 168, 130, 32, 112, 176, 68, 160, 34, 164, 138, 34, 1, 221, 136, 155, 65, 65, 74, 105, 41, 10, 150, 157, 64, 97, 25, 3, 129, 84, 33, 166, 216, 69, 178, 130, 92, 219, 116, 218, 49, 5, 73, 21, 18, 139, 97, 197, 21, 24, 20, 183, 41, 167, 84, 70, 89, 18, 84, 144, 26, 131, 34, 2, 211, 137, 246, 33, 51, 64, 100, 133, 21, 27, 75, 132, 153, 187, 21, 212, 176, 38, 96, 6, 80, 132, 27, 246, 194, 225, 86, 59, 102, 41, 102, 33, 21, 13, 207, 107, 78, 160, 130, 194, 12, 11, 36, 93, 102, 58, 204, 114, 0, 137, 24, 26, 100, 8, 96, 121, 37, 76, 102, 102, 118, 197, 104, 29, 146, 87, 65, 36, 84, 196, 4, 73, 64, 182, 216, 212, 100, 96, 234, 93, 69, 3, 137, 184, 176, 29, 73, 193, 14, 34, 24, 0, 1, 185, 117, 110, 83, 150, 50, 216, 29, 228, 115, 13, 131, 20, 52, 53, 42, 49, 46, 89, 41, 75, 64, 20, 132, 77, 80, 142, 240, 57, 0, 54, 29, 227, 201, 17, 97, 184, 77, 228, 148, 208, 49, 9, 95, 188, 93, 201, 20, 225, 66, 64, 172, 203, 54, 44 };

constexpr std::array<u8, 4219> PLATINUM = { 236, 82, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 243, 234, 223, 7, 0, 0, 182, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 215, 223, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 236, 186, 125, 234, 255, 236, 157, 33, 0, 96, 18, 220, 251, 149, 69, 41, 110, 212, 225, 174, 198, 115, 45, 150, 217, 85, 38, 199, 110, 9, 21, 118, 177, 184, 250, 114, 10, 43, 208, 0, 1, 160, 18, 170, 82, 148, 161, 40, 146, 104, 105, 38, 211, 35, 84, 122, 158, 209, 146, 96, 52, 53, 39, 133, 61, 49, 79, 83, 217, 19, 105, 164, 98, 122, 33, 12, 158, 147, 106, 60, 167, 169, 145, 178, 122, 81, 234, 122, 19, 212, 120, 166, 128, 6, 212, 104, 0, 245, 13, 0, 0, 0, 0, 0, 0, 3, 39, 147, 80, 74, 33, 6, 154, 65, 54, 76, 136, 212, 218, 101, 24, 83, 50, 167, 158, 168, 211, 210, 159, 165, 61, 170, 122, 158, 53, 71, 148, 242, 106, 122, 101, 7, 169, 234, 26, 105, 228, 134, 128, 121, 53, 7, 168, 102, 160, 209, 250, 166, 129, 181, 13, 26, 0, 52, 0, 3, 64, 122, 153, 12, 77, 13, 0, 0, 13, 16, 0, 3, 64, 0, 100, 0, 26, 0, 6, 140, 154, 0, 0, 200, 13, 0, 0, 0, 13, 0, 13, 52, 211, 64, 105, 160, 13, 12, 134, 67, 38, 128, 0, 52, 13, 0, 26, 13, 24, 153, 1, 10, 81, 32, 84, 241, 9, 233, 6, 128, 52, 26, 26, 61, 77, 0, 12, 64, 52, 52, 3, 64, 7, 168, 208, 26, 0, 52, 12, 134, 141, 0, 0, 0, 0, 26, 1, 160, 0, 1, 163, 245, 32, 0, 52, 100, 208, 41, 72, 3, 64, 3, 32, 0, 0, 3, 32, 104, 104, 0, 0, 0, 1, 166, 131, 32, 0, 194, 0, 13, 26, 0, 0, 0, 0, 0, 0, 3, 64, 0, 104, 208, 0, 18, 34, 33, 1, 4, 158, 169, 226, 100, 155, 81, 230, 41, 180, 35, 50, 167, 169, 229, 15, 80, 244, 106, 63, 84, 208, 103, 168, 105, 60, 5, 52, 122, 128, 209, 234, 3, 64, 245, 6, 143, 72, 52, 0, 208, 3, 77, 164, 48, 131, 64, 0, 122, 141, 30, 167, 169, 234, 1, 166, 131, 64, 122, 141, 237, 161, 235, 206, 9, 198, 185, 97, 73, 17, 137, 38, 48, 152, 16, 106, 169, 177, 70, 230, 78, 59, 244, 1, 201, 249, 227, 206, 241, 7, 145, 62, 167, 133, 30, 41, 188, 73, 232, 123, 255, 7, 96, 50, 170, 156, 212, 8, 131, 9, 189, 126, 102, 244, 183, 33, 191, 149, 73, 138, 66, 33, 175, 56, 230, 78, 61, 158, 228, 72, 82, 84, 44, 178, 163, 71, 17, 174, 92, 130, 32, 142, 141, 200, 194, 72, 216, 53, 20, 115, 112, 103, 95, 199, 226, 35, 10, 137, 28, 64, 17, 4, 246, 18, 224, 251, 127, 115, 238, 253, 126, 254, 138, 179, 254, 245, 191, 26, 230, 158, 127, 27, 139, 216, 113, 234, 139, 109, 49, 186, 121, 223, 197, 169, 48, 242, 41, 67, 22, 38, 6, 33, 90, 116, 130, 66, 247, 211, 169, 78, 126, 109, 3, 115, 123, 105, 33, 15, 54, 221, 57, 37, 129, 132, 99, 63, 63, 193, 147, 65, 133, 202, 232, 193, 147, 203, 24, 213, 91, 154, 225, 40, 114, 129, 205, 238, 166, 27, 102, 50, 8, 91, 242, 12, 7, 69, 22, 105, 65, 44, 189, 57, 172, 218, 95, 96, 49, 159, 146, 111, 238, 192, 214, 2, 15, 119, 183, 73, 66, 254, 169, 49, 6, 137, 196, 223, 6, 5, 135, 43, 197, 107, 88, 45, 198, 151, 212, 82, 130, 229, 90, 212, 1, 190, 233, 64, 121, 96, 191, 128, 160, 220, 19, 150, 206, 230, 218, 89, 225, 154, 244, 113, 109, 69, 112, 11, 151, 175, 4, 103, 23, 205, 54, 155, 235, 116, 184, 89, 184, 4, 63, 199, 96, 210, 200, 28, 189, 164, 198, 243, 158, 29, 95, 61, 178, 36, 243, 33, 98, 193, 226, 93, 46, 137, 18, 90, 2, 74, 83, 147, 202, 229, 103, 165, 15, 205, 38, 54, 136, 97, 246, 109, 11, 0, 95, 221, 75, 214, 8, 27, 86, 131, 106, 129, 164, 52, 12, 218, 162, 90, 132, 12, 6, 131, 233, 65, 127, 246, 115, 141, 103, 56, 196, 7, 36, 235, 76, 169, 119, 12, 194, 60, 37, 37, 3, 12, 57, 159, 15, 216, 198, 111, 54, 177, 143, 9, 139, 99, 1, 132, 0, 244, 61, 11, 79, 38, 15, 133, 60, 118, 60, 57, 96, 64, 156, 81, 132, 224, 115, 140, 84, 18, 97, 41, 6, 90, 11, 86, 165, 113, 114, 4, 230, 33, 152, 128, 49, 219, 236, 209, 144, 183, 99, 77, 36, 198, 146, 132, 174, 5, 146, 178, 3, 37, 136, 214, 44, 163, 42, 22, 14, 39, 58, 68, 216, 38, 98, 40, 243, 198, 131, 144, 254, 105, 153, 217, 141, 79, 223, 34, 74, 141, 17, 164, 169, 35, 71, 3, 154, 53, 25, 213, 220, 212, 122, 132, 76, 194, 243, 208, 38, 73, 113, 204, 49, 13, 35, 226, 6, 144, 160, 207, 236, 171, 29, 40, 155, 173, 219, 97, 140, 193, 12, 14, 150, 5, 12, 8, 230, 100, 165, 235, 235, 76, 222, 230, 181, 171, 234, 121, 65, 120, 145, 137, 130, 8, 28, 228, 135, 67, 2, 87, 64, 232, 224, 212, 30, 72, 249, 43, 241, 184, 243, 5, 163, 171, 139, 24, 18, 36, 62, 6, 52, 220, 156, 135, 85, 110, 131, 45, 90, 25, 212, 13, 40, 193, 147, 70, 178, 54, 24, 241, 137, 107, 44, 190, 24, 48, 105, 141, 52, 44, 15, 205, 121, 45, 29, 82, 67, 216, 192, 136, 26, 108, 60, 88, 108, 55, 240, 91, 77, 133, 166, 94, 86, 84, 134, 219, 5, 167, 63, 67, 130, 139, 70, 201, 232, 207, 217, 171, 199, 66, 25, 67, 142, 184, 1, 48, 217, 153, 176, 206, 109, 46, 83, 130, 140, 56, 67, 244, 11, 94, 26, 155, 181, 234, 241, 24, 137, 90, 225, 110, 133, 177, 5, 114, 24, 37, 60, 14, 79, 19, 140, 121, 242, 52, 68, 228, 146, 47, 10, 69, 232, 5, 12, 145, 196, 10, 103, 58, 186, 23, 205, 61, 175, 246, 200, 89, 8, 102, 114, 207, 223, 3, 153, 217, 32, 79, 64, 188, 64, 203, 68, 208, 66, 238, 142, 201, 35, 227, 138, 195, 125, 78, 142, 212, 195, 133, 80, 205, 191, 151, 2, 218, 85, 124, 61, 184, 166, 145, 214, 164, 96, 149, 213, 119, 110, 181, 71, 26, 20, 162, 170, 25, 187, 113, 162, 60, 181, 176, 102, 29, 72, 132, 143, 85, 226, 247, 86, 38, 180, 170, 164, 130, 67, 165, 22, 141, 102, 84, 19, 119, 40, 138, 182, 203, 36, 1, 162, 72, 104, 120, 86, 199, 98, 121, 64, 216, 168, 51, 3, 130, 124, 238, 240, 254, 75, 226, 183, 140, 143, 21, 21, 114, 233, 46, 2, 250, 251, 149, 221, 59, 230, 208, 100, 225, 112, 151, 30, 60, 191, 37, 31, 57, 139, 173, 172, 47, 153, 57, 166, 50, 142, 0, 166, 36, 236, 8, 50, 130, 28, 37, 254, 135, 181, 77, 141, 146, 80, 45, 17, 46, 159, 162, 60, 64, 115, 144, 62, 30, 209, 141, 246, 151, 75, 161, 135, 132, 109, 184, 236, 94, 71, 152, 164, 215, 183, 149, 193, 55, 253, 5, 187, 84, 128, 74, 165, 55, 40, 105, 29, 110, 208, 147, 148, 2, 114, 248, 161, 239, 196, 200, 10, 95, 70, 142, 233, 157, 205, 219, 60, 92, 135, 140, 204, 22, 22, 8, 77, 10, 39, 77, 29, 22, 12, 211, 138, 23, 122, 68, 185, 152, 150, 212, 10, 177, 176, 51, 51, 22, 220, 220, 155, 156, 37, 127, 224, 102, 213, 134, 163, 155, 235, 89, 203, 27, 57, 252, 247, 25, 62, 49, 6, 239, 57, 169, 87, 43, 100, 200, 112, 197, 144, 111, 59, 11, 203, 83, 100, 26, 31, 222, 175, 120, 109, 74, 32, 39, 40, 148, 49, 76, 84, 73, 20, 227, 244, 11, 244, 158, 230, 39, 36, 24, 133, 93, 100, 119, 220, 94, 76, 119, 88, 49, 167, 49, 232, 200, 20, 117, 4, 29, 153, 85, 189, 107, 104, 219, 100, 117, 105, 122, 103, 143, 29, 86, 198, 140, 90, 42, 170, 174, 163, 13, 77, 202, 89, 175, 118, 208, 98, 185, 221, 54, 56, 28, 229, 114, 55, 147, 171, 22, 143, 58, 240, 171, 229, 239, 131, 10, 168, 96, 136, 56, 132, 26, 29, 170, 162, 38, 132, 234, 135, 31, 0, 122, 36, 34, 7, 33, 69, 207, 57, 64, 243, 175, 10, 77, 52, 186, 141, 40, 40, 26, 106, 169, 166, 138, 21, 235, 53, 0, 140, 58, 172, 156, 102, 66, 141, 96, 232, 248, 69, 166, 218, 212, 109, 141, 180, 154, 6, 207, 115, 99, 38, 111, 24, 133, 84, 106, 134, 141, 70, 146, 162, 26, 60, 126, 57, 210, 194, 113, 207, 243, 194, 227, 211, 73, 130, 208, 64, 220, 48, 65, 44, 11, 56, 205, 71, 169, 35, 234, 80, 134, 170, 230, 113, 123, 106, 250, 217, 196, 4, 56, 90, 105, 129, 114, 220, 162, 155, 137, 28, 114, 182, 147, 47, 144, 152, 111, 184, 222, 67, 208, 77, 122, 84, 214, 121, 73, 7, 55, 203, 84, 54, 239, 76, 146, 244, 24, 196, 220, 20, 229, 232, 201, 96, 160, 54, 103, 21, 32, 206, 154, 19, 97, 82, 128, 85, 68, 64, 247, 99, 32, 141, 198, 20, 128, 50, 80, 197, 120, 80, 24, 133, 144, 96, 143, 155, 131, 191, 102, 190, 188, 198, 60, 111, 67, 83, 133, 185, 101, 162, 224, 106, 111, 210, 193, 189, 73, 247, 169, 78, 122, 103, 18, 71, 2, 237, 30, 37, 218, 84, 95, 210, 121, 157, 212, 166, 136, 180, 243, 210, 225, 161, 95, 231, 69, 139, 183, 149, 77, 64, 37, 123, 176, 96, 174, 193, 181, 6, 145, 21, 154, 255, 74, 118, 54, 235, 129, 126, 42, 11, 49, 76, 13, 245, 244, 235, 185, 148, 83, 24, 103, 201, 192, 7, 197, 107, 212, 21, 180, 115, 127, 93, 181, 45, 22, 223, 46, 143, 150, 242, 55, 85, 88, 108, 137, 128, 55, 135, 48, 54, 161, 144, 136, 4, 226, 37, 167, 68, 187, 48, 54, 250, 176, 46, 160, 46, 185, 27, 155, 231, 79, 26, 226, 8, 24, 205, 126, 44, 158, 87, 201, 221, 116, 13, 51, 135, 235, 119, 140, 145, 141, 169, 7, 231, 97, 151, 123, 179, 165, 25, 224, 247, 251, 152, 31, 155, 133, 166, 30, 206, 44, 2, 205, 43, 44, 245, 45, 112, 107, 170, 110, 57, 197, 46, 28, 177, 189, 106, 34, 36, 64, 132, 168, 168, 27, 76, 195, 125, 217, 225, 92, 211, 145, 216, 151, 231, 236, 122, 153, 7, 25, 14, 26, 87, 120, 96, 192, 98, 94, 7, 154, 105, 95, 118, 117, 211, 176, 20, 43, 172, 174, 187, 180, 85, 205, 163, 21, 26, 219, 88, 78, 179, 144, 153, 112, 211, 28, 124, 156, 17, 244, 141, 166, 85, 191, 249, 127, 178, 220, 35, 199, 150, 152, 179, 48, 90, 168, 87, 194, 155, 174, 227, 79, 145, 176, 210, 73, 68, 162, 11, 86, 145, 165, 49, 85, 100, 11, 22, 178, 232, 217, 18, 22, 237, 136, 238, 57, 157, 143, 45, 222, 7, 13, 33, 240, 13, 74, 40, 44, 203, 157, 137, 83, 16, 103, 24, 115, 24, 43, 49, 45, 55, 131, 135, 238, 249, 123, 169, 30, 204, 154, 3, 80, 102, 157, 31, 21, 40, 166, 204, 134, 131, 122, 233, 9, 96, 229, 203, 9, 4, 237, 100, 101, 198, 59, 16, 174, 18, 79, 65, 112, 128, 193, 86, 4, 5, 81, 5, 4, 54, 202, 153, 19, 227, 38, 191, 109, 119, 5, 72, 165, 5, 24, 145, 178, 18, 33, 20, 119, 75, 135, 101, 221, 219, 37, 187, 50, 23, 29, 118, 148, 146, 124, 250, 93, 165, 49, 226, 33, 182, 193, 33, 236, 73, 219, 91, 103, 69, 21, 125, 51, 241, 105, 222, 241, 177, 174, 82, 37, 90, 171, 123, 219, 116, 50, 85, 71, 225, 148, 91, 137, 33, 6, 208, 109, 138, 8, 105, 163, 220, 34, 216, 128, 65, 20, 132, 48, 82, 64, 129, 120, 36, 65, 54, 68, 20, 161, 104, 212, 98, 140, 86, 128, 60, 129, 49, 48, 209, 69, 38, 18, 248, 209, 198, 67, 155, 215, 147, 207, 49, 49, 33, 200, 32, 108, 22, 100, 239, 64, 212, 3, 0, 26, 32, 105, 1, 96, 8, 192, 144, 10, 128, 178, 5, 144, 49, 129, 150, 6, 16, 4, 12, 15, 84, 131, 21, 45, 182, 173, 246, 89, 238, 206, 67, 228, 68, 110, 86, 144, 163, 68, 209, 210, 113, 28, 76, 230, 155, 120, 233, 6, 212, 102, 40, 150, 217, 153, 47, 182, 244, 152, 178, 117, 160, 65, 73, 244, 174, 37, 172, 27, 54, 139, 34, 97, 54, 202, 189, 223, 71, 117, 227, 197, 39, 81, 252, 54, 133, 88, 146, 4, 113, 15, 11, 91, 47, 56, 107, 89, 186, 145, 210, 77, 216, 205, 102, 146, 26, 90, 8, 46, 101, 40, 219, 197, 133, 8, 160, 132, 202, 232, 9, 163, 23, 150, 118, 248, 182, 181, 183, 178, 159, 13, 28, 173, 20, 141, 160, 38, 23, 17, 37, 210, 161, 10, 187, 13, 120, 237, 216, 76, 246, 119, 128, 162, 189, 72, 115, 24, 70, 255, 59, 190, 113, 76, 57, 77, 23, 245, 44, 116, 176, 224, 244, 86, 134, 131, 164, 90, 1, 165, 234, 31, 238, 165, 107, 4, 80, 167, 178, 82, 72, 222, 190, 201, 158, 93, 214, 197, 221, 161, 253, 237, 56, 54, 21, 155, 174, 165, 46, 180, 178, 29, 145, 127, 167, 35, 200, 195, 252, 244, 130, 57, 103, 232, 202, 198, 177, 57, 245, 67, 182, 138, 211, 250, 40, 139, 51, 33, 196, 142, 71, 214, 65, 206, 127, 25, 58, 30, 173, 82, 15, 124, 37, 109, 172, 50, 198, 58, 37, 237, 87, 33, 251, 103, 75, 38, 245, 153, 210, 220, 146, 100, 121, 22, 87, 236, 138, 111, 0, 181, 13, 84, 36, 146, 87, 171, 45, 76, 125, 242, 39, 50, 37, 136, 156, 97, 101, 221, 68, 3, 199, 64, 146, 37, 205, 214, 77, 14, 211, 172, 234, 200, 73, 150, 183, 226, 115, 197, 95, 179, 30, 13, 200, 84, 248, 15, 72, 222, 47, 143, 92, 113, 171, 166, 145, 41, 162, 91, 16, 82, 89, 94, 153, 116, 130, 20, 168, 130, 162, 16, 174, 4, 178, 204, 168, 218, 138, 24, 119, 10, 17, 211, 231, 99, 166, 108, 139, 33, 249, 143, 90, 196, 126, 226, 229, 117, 193, 75, 236, 157, 133, 144, 235, 51, 49, 131, 1, 151, 150, 13, 52, 199, 200, 42, 88, 48, 219, 236, 110, 48, 105, 44, 16, 102, 147, 140, 152, 42, 13, 103, 39, 208, 161, 8, 248, 1, 200, 21, 130, 213, 211, 77, 43, 233, 82, 225, 106, 227, 49, 163, 210, 188, 203, 198, 180, 186, 221, 105, 15, 163, 63, 133, 50, 51, 210, 36, 196, 238, 28, 175, 96, 142, 100, 174, 149, 205, 127, 60, 188, 196, 150, 193, 60, 147, 27, 121, 114, 197, 80, 84, 84, 45, 167, 128, 39, 231, 186, 29, 10, 196, 24, 12, 23, 184, 50, 82, 147, 240, 52, 179, 208, 138, 168, 141, 243, 5, 205, 37, 16, 83, 174, 165, 93, 50, 212, 142, 14, 240, 188, 141, 192, 241, 17, 192, 162, 168, 60, 137, 51, 30, 11, 219, 215, 201, 78, 34, 30, 10, 18, 84, 148, 116, 251, 194, 77, 155, 158, 150, 194, 79, 70, 190, 60, 217, 227, 62, 142, 50, 109, 27, 46, 209, 137, 161, 33, 201, 28, 20, 198, 39, 69, 100, 106, 162, 172, 125, 200, 50, 233, 147, 87, 195, 185, 64, 190, 13, 252, 27, 39, 105, 182, 224, 65, 24, 97, 135, 125, 211, 182, 148, 51, 45, 52, 234, 81, 248, 59, 116, 66, 98, 130, 4, 71, 54, 132, 141, 52, 232, 208, 114, 204, 101, 227, 168, 200, 57, 187, 10, 5, 103, 183, 146, 125, 36, 38, 32, 193, 60, 220, 23, 47, 104, 10, 97, 226, 92, 173, 240, 3, 69, 42, 34, 180, 94, 9, 96, 132, 19, 93, 63, 108, 149, 24, 77, 241, 123, 210, 161, 77, 84, 78, 152, 2, 160, 99, 65, 128, 26, 197, 241, 84, 85, 77, 135, 217, 200, 134, 4, 191, 79, 46, 235, 36, 42, 130, 187, 66, 152, 186, 66, 145, 249, 6, 121, 26, 84, 98, 63, 48, 73, 32, 232, 117, 30, 26, 41, 63, 104, 33, 99, 177, 137, 118, 24, 78, 145, 115, 46, 222, 241, 118, 136, 49, 140, 227, 61, 11, 205, 170, 51, 162, 92, 97, 121, 109, 156, 8, 45, 106, 98, 45, 175, 69, 6, 242, 46, 40, 12, 112, 89, 187, 24, 205, 197, 8, 150, 113, 65, 135, 14, 115, 97, 163, 130, 197, 188, 98, 198, 109, 3, 75, 52, 201, 68, 206, 163, 65, 167, 173, 204, 217, 28, 3, 2, 101, 173, 34, 26, 11, 172, 84, 104, 56, 90, 153, 235, 116, 168, 12, 22, 88, 172, 9, 86, 54, 143, 33, 30, 89, 137, 149, 141, 66, 222, 99, 11, 199, 49, 109, 186, 160, 66, 116, 216, 108, 170, 157, 159, 137, 200, 232, 26, 118, 14, 47, 15, 164, 230, 164, 110, 116, 197, 15, 144, 189, 153, 84, 205, 117, 12, 84, 213, 84, 213, 119, 247, 249, 158, 123, 158, 244, 91, 171, 187, 53, 12, 78, 247, 151, 5, 30, 64, 81, 213, 3, 80, 149, 30, 36, 174, 17, 66, 142, 64, 230, 203, 6, 66, 8, 52, 231, 250, 62, 59, 141, 242, 157, 195, 164, 251, 127, 139, 164, 197, 239, 81, 191, 51, 135, 61, 114, 186, 248, 28, 45, 228, 238, 165, 11, 224, 224, 89, 21, 87, 49, 84, 93, 164, 212, 252, 242, 234, 240, 0, 1, 1, 8, 4, 0, 33, 8, 2, 130, 255, 115, 251, 248, 251, 95, 166, 229, 55, 1, 225, 234, 201, 64, 147, 238, 7, 58, 21, 87, 126, 65, 13, 156, 17, 98, 8, 120, 56, 166, 30, 66, 12, 153, 8, 136, 44, 204, 18, 9, 164, 57, 254, 99, 190, 120, 175, 161, 234, 253, 175, 172, 224, 247, 55, 204, 9, 177, 141, 12, 24, 144, 176, 251, 254, 227, 48, 207, 64, 101, 177, 32, 27, 108, 65, 96, 90, 49, 54, 199, 152, 197, 12, 99, 72, 24, 155, 27, 185, 144, 134, 198, 194, 96, 138, 10, 162, 74, 179, 3, 0, 138, 2, 138, 40, 8, 136, 130, 44, 204, 2, 154, 86, 10, 97, 44, 192, 67, 16, 37, 9, 9, 71, 171, 7, 31, 65, 1, 9, 181, 136, 25, 52, 228, 134, 8, 27, 160, 98, 99, 12, 20, 245, 173, 48, 4, 231, 115, 53, 9, 101, 32, 97, 197, 141, 164, 219, 132, 160, 40, 88, 55, 44, 22, 154, 41, 106, 32, 78, 127, 117, 34, 42, 64, 171, 85, 2, 27, 77, 180, 49, 177, 21, 70, 84, 85, 15, 1, 88, 19, 7, 123, 48, 102, 74, 137, 166, 36, 34, 86, 102, 178, 194, 98, 128, 146, 134, 148, 130, 86, 86, 64, 36, 148, 160, 134, 154, 25, 134, 69, 206, 64, 17, 225, 27, 4, 117, 216, 76, 52, 66, 91, 49, 112, 154, 26, 24, 38, 18, 76, 75, 109, 182, 52, 12, 108, 108, 26, 96, 137, 38, 36, 97, 16, 21, 81, 8, 89, 211, 245, 30, 199, 156, 231, 58, 126, 139, 155, 251, 93, 55, 83, 205, 255, 190, 49, 30, 49, 130, 40, 137, 69, 84, 69, 20, 16, 195, 214, 155, 202, 246, 254, 204, 252, 140, 174, 87, 235, 193, 228, 242, 102, 234, 229, 234, 111, 249, 90, 221, 158, 86, 127, 141, 195, 208, 214, 164, 65, 16, 136, 12, 17, 43, 28, 155, 219, 215, 184, 129, 24, 70, 97, 18, 148, 180, 1, 129, 116, 210, 129, 166, 153, 129, 49, 25, 99, 14, 199, 97, 2, 84, 147, 84, 17, 32, 68, 199, 97, 177, 137, 138, 134, 32, 100, 134, 33, 154, 108, 132, 112, 37, 130, 190, 31, 194, 238, 191, 131, 161, 244, 251, 223, 250, 220, 55, 64, 137, 34, 32, 180, 116, 96, 130, 32, 105, 40, 12, 208, 101, 144, 130, 2, 38, 130, 169, 37, 138, 10, 36, 138, 8, 9, 42, 146, 2, 74, 152, 24, 130, 148, 179, 51, 19, 122, 51, 72, 17, 130, 85, 170, 168, 42, 38, 87, 22, 49, 150, 18, 64, 170, 33, 32, 9, 130, 153, 130, 49, 0, 58, 137, 5, 209, 238, 208, 52, 40, 107, 79, 42, 152, 168, 228, 146, 195, 9, 64, 209, 17, 85, 181, 128, 174, 136, 202, 163, 202, 178, 6, 172, 36, 132, 163, 80, 1, 40, 107, 6, 84, 81, 72, 230, 96, 18, 64, 66, 85, 72, 145, 9, 36, 153, 142, 41, 20, 65, 52, 67, 7, 45, 101, 37, 35, 69, 13, 33, 4, 102, 99, 74, 68, 213, 21, 1, 80, 51, 198, 195, 132, 75, 77, 5, 21, 60, 32, 71, 16, 205, 204, 28, 8, 161, 8, 130, 150, 173, 103, 20, 136, 16, 141, 152, 38, 18, 89, 136, 102, 230, 7, 47, 166, 82, 97, 129, 162, 186, 41, 202, 140, 155, 83, 161, 172, 8, 225, 169, 108, 181, 221, 196, 28, 33, 34, 8, 154, 41, 138, 38, 18, 32, 41, 100, 33, 128, 40, 90, 82, 34, 130, 98, 102, 41, 8, 93, 210, 13, 184, 208, 181, 195, 28, 183, 96, 40, 116, 204, 76, 40, 6, 41, 180, 132, 197, 124, 86, 34, 240, 157, 21, 142, 26, 10, 17, 65, 202, 65, 70, 13, 184, 160, 98, 0, 219, 33, 112, 99, 44, 25, 75, 123, 28, 183, 178, 182, 179, 11, 29, 51, 4, 54, 204, 131, 113, 117, 68, 13, 146, 84, 64, 80, 139, 73, 32, 72, 112, 193, 183, 32, 22, 147, 68, 36, 89, 160, 162, 16, 100, 162, 170, 74, 34, 3, 115, 80, 30, 1, 0, 104, 235, 2, 148, 108, 204, 85, 37, 134, 4, 32, 162, 5, 154, 57, 100, 14, 92, 87, 8, 225, 27, 192, 26, 240, 71, 131, 35, 180, 14, 164, 240, 45, 196, 42, 116, 96, 4, 201, 4, 104, 98, 4, 160, 26, 18, 18, 72, 134, 73, 88, 164, 137, 100, 146, 80, 152, 153, 135, 129, 194, 208, 211, 48, 10, 2, 204, 22, 66, 19, 51, 16, 54, 220, 52, 64, 50, 147, 2, 68, 140, 66, 146, 101, 77, 151, 95, 45, 182, 245, 102, 235, 18, 86, 2, 47, 151, 94, 144, 144, 188, 37, 114, 73, 50, 210, 197, 99, 134, 38, 208, 144, 240, 68, 204, 202, 239, 33, 213, 9, 34, 2, 135, 107, 12, 7, 50, 43, 125, 84, 233, 64, 166, 22, 144, 142, 208, 1, 6, 36, 196, 13, 32, 49, 13, 140, 64, 241, 24, 173, 189, 64, 163, 29, 4, 5, 26, 22, 16, 100, 185, 52, 52, 26, 154, 42, 68, 134, 235, 192, 36, 49, 225, 12, 67, 1, 176, 27, 67, 98, 198, 218, 27, 19, 6, 49, 147, 9, 25, 6, 144, 227, 77, 38, 132, 98, 44, 65, 164, 225, 75, 72, 20, 235, 138, 184, 148, 68, 68, 16, 76, 17, 152, 6, 52, 25, 129, 142, 109, 232, 130, 102, 249, 37, 163, 84, 98, 118, 65, 8, 99, 69, 74, 9, 218, 81, 81, 132, 180, 161, 166, 10, 98, 18, 156, 140, 66, 8, 217, 33, 67, 102, 6, 91, 122, 46, 4, 148, 5, 73, 172, 229, 19, 155, 88, 236, 169, 117, 48, 197, 199, 109, 37, 8, 105, 177, 219, 20, 148, 81, 33, 220, 168, 133, 91, 104, 59, 156, 20, 136, 72, 108, 99, 6, 152, 100, 17, 40, 133, 20, 74, 101, 141, 152, 228, 134, 220, 180, 169, 64, 104, 67, 162, 75, 50, 196, 164, 193, 72, 163, 16, 174, 129, 12, 98, 11, 68, 210, 37, 129, 2, 8, 128, 48, 32, 190, 10, 0, 0, 48, 40, 91, 136, 110, 33, 182, 147, 108, 67, 109, 213, 196, 202, 96, 77, 200, 201, 40, 166, 144, 34, 170, 34, 17, 129, 41, 157, 44, 132, 34, 72, 134, 165, 166, 52, 211, 4, 155, 6, 203, 146, 180, 1, 151, 69, 80, 92, 5, 195, 78, 192, 45, 130, 145, 164, 15, 254, 46, 228, 138, 112, 161, 33, 231, 213, 190, 14 };

constexpr std::array<u8, 4229> SOULSILVER = { 44, 94, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 247, 222, 173, 75, 0, 21, 123, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 255, 255, 255, 238, 173, 0, 63, 24, 44, 172, 185, 249, 106, 245, 172, 24, 33, 128, 96, 18, 93, 94, 251, 166, 238, 189, 183, 138, 38, 197, 80, 203, 203, 189, 179, 183, 150, 182, 198, 187, 5, 173, 221, 89, 173, 72, 69, 42, 185, 5, 52, 61, 0, 0, 26, 0, 15, 9, 68, 66, 100, 104, 154, 67, 244, 83, 197, 54, 138, 61, 165, 55, 168, 212, 246, 154, 154, 39, 141, 83, 208, 210, 104, 245, 61, 52, 245, 70, 143, 81, 234, 1, 147, 52, 143, 83, 104, 212, 200, 54, 163, 244, 167, 164, 61, 64, 6, 154, 15, 81, 233, 0, 52, 13, 52, 0, 61, 64, 241, 61, 65, 168, 161, 169, 147, 209, 26, 122, 128, 52, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 161, 163, 64, 48, 128, 208, 104, 24, 16, 0, 104, 13, 50, 3, 64, 96, 16, 25, 52, 208, 0, 0, 211, 4, 211, 76, 16, 25, 52, 100, 26, 48, 128, 3, 33, 132, 52, 200, 18, 34, 34, 26, 77, 79, 84, 204, 153, 20, 253, 12, 10, 159, 164, 143, 83, 39, 154, 76, 167, 234, 52, 159, 170, 30, 81, 167, 168, 245, 50, 30, 163, 212, 205, 77, 234, 70, 6, 132, 54, 83, 38, 65, 234, 30, 166, 128, 122, 105, 12, 70, 131, 212, 98, 0, 15, 80, 104, 104, 201, 182, 168, 36, 146, 53, 73, 176, 154, 79, 81, 166, 106, 121, 32, 26, 104, 52, 26, 104, 0, 244, 154, 12, 134, 128, 104, 0, 0, 0, 1, 160, 26, 0, 0, 6, 128, 0, 6, 128, 0, 52, 13, 4, 73, 4, 65, 3, 72, 2, 105, 169, 229, 51, 72, 212, 246, 152, 163, 16, 212, 209, 166, 140, 158, 163, 212, 105, 166, 79, 83, 19, 64, 244, 135, 164, 208, 208, 104, 13, 15, 73, 160, 209, 160, 0, 0, 245, 0, 0, 15, 80, 26, 6, 155, 189, 238, 223, 183, 205, 201, 114, 59, 140, 100, 146, 201, 164, 81, 208, 119, 226, 83, 169, 20, 80, 86, 164, 149, 43, 66, 161, 22, 92, 70, 135, 3, 233, 202, 186, 233, 124, 95, 166, 152, 238, 239, 34, 147, 130, 196, 252, 174, 25, 196, 251, 222, 172, 113, 227, 239, 112, 157, 138, 101, 161, 215, 53, 106, 75, 154, 63, 195, 205, 205, 30, 139, 79, 63, 220, 240, 204, 124, 61, 29, 19, 90, 235, 134, 123, 26, 196, 183, 45, 104, 60, 129, 206, 156, 88, 233, 137, 146, 228, 120, 70, 145, 18, 7, 147, 180, 170, 241, 134, 125, 68, 88, 94, 132, 137, 87, 98, 133, 36, 61, 232, 64, 142, 91, 8, 73, 60, 80, 34, 72, 36, 17, 8, 181, 83, 247, 138, 80, 124, 63, 240, 181, 116, 182, 157, 15, 39, 76, 69, 81, 234, 144, 52, 0, 21, 151, 174, 146, 134, 166, 251, 128, 104, 7, 103, 196, 167, 115, 26, 71, 37, 182, 216, 18, 162, 182, 37, 247, 245, 227, 212, 143, 201, 229, 119, 217, 31, 7, 64, 125, 255, 161, 63, 28, 45, 230, 246, 187, 61, 141, 14, 195, 148, 8, 33, 29, 66, 35, 232, 163, 4, 249, 225, 59, 33, 66, 144, 83, 112, 16, 164, 12, 197, 16, 47, 64, 24, 70, 144, 184, 145, 10, 58, 21, 131, 182, 247, 245, 61, 101, 197, 181, 214, 140, 132, 20, 173, 86, 197, 243, 194, 60, 41, 216, 170, 120, 57, 48, 228, 49, 217, 170, 92, 65, 39, 201, 51, 186, 207, 109, 250, 223, 236, 189, 194, 46, 12, 35, 90, 151, 68, 198, 18, 105, 42, 129, 35, 19, 30, 22, 169, 35, 156, 211, 172, 177, 208, 31, 72, 113, 106, 119, 153, 151, 53, 176, 183, 57, 217, 253, 126, 126, 108, 147, 119, 243, 95, 48, 187, 17, 162, 208, 170, 121, 147, 171, 185, 181, 161, 200, 223, 150, 133, 237, 46, 97, 171, 125, 92, 26, 100, 110, 164, 112, 161, 165, 4, 51, 210, 237, 125, 97, 239, 126, 25, 250, 81, 252, 45, 81, 36, 41, 17, 30, 33, 16, 218, 186, 57, 148, 167, 200, 10, 20, 72, 97, 18, 20, 20, 34, 52, 31, 124, 6, 132, 169, 213, 211, 165, 155, 157, 211, 108, 34, 32, 143, 184, 238, 4, 186, 173, 150, 82, 158, 12, 51, 74, 19, 133, 142, 70, 35, 40, 143, 234, 70, 254, 54, 14, 197, 204, 171, 200, 48, 237, 228, 165, 91, 113, 4, 78, 233, 165, 107, 3, 122, 207, 13, 174, 253, 134, 22, 189, 192, 202, 181, 209, 88, 83, 42, 161, 118, 203, 229, 21, 48, 50, 140, 215, 215, 224, 178, 108, 241, 248, 165, 197, 230, 53, 40, 226, 160, 155, 221, 99, 27, 68, 251, 242, 14, 235, 129, 156, 23, 106, 54, 121, 235, 204, 31, 160, 121, 44, 225, 243, 91, 161, 193, 229, 49, 238, 44, 247, 123, 76, 58, 189, 83, 149, 52, 132, 120, 71, 179, 174, 222, 46, 149, 75, 21, 137, 58, 53, 206, 117, 142, 219, 171, 127, 75, 38, 199, 48, 184, 91, 242, 9, 212, 29, 8, 58, 97, 81, 74, 169, 4, 249, 45, 176, 146, 76, 133, 236, 238, 193, 20, 13, 3, 147, 83, 242, 118, 58, 244, 31, 36, 53, 207, 49, 166, 157, 179, 68, 15, 184, 218, 166, 211, 3, 147, 251, 223, 164, 246, 253, 125, 16, 55, 171, 34, 4, 132, 138, 237, 96, 39, 204, 142, 183, 33, 34, 65, 33, 222, 154, 153, 250, 47, 235, 19, 40, 114, 159, 49, 125, 193, 207, 106, 80, 184, 14, 138, 172, 220, 210, 39, 25, 207, 87, 11, 211, 123, 7, 3, 206, 167, 17, 52, 197, 113, 136, 232, 136, 200, 17, 21, 74, 205, 175, 254, 222, 26, 65, 192, 130, 128, 104, 140, 161, 216, 18, 65, 32, 206, 161, 245, 21, 3, 72, 45, 42, 106, 23, 244, 47, 5, 10, 254, 131, 47, 176, 52, 138, 166, 105, 179, 118, 45, 242, 169, 8, 41, 200, 245, 96, 78, 199, 251, 193, 145, 9, 181, 74, 55, 178, 69, 54, 33, 56, 70, 97, 23, 106, 58, 51, 75, 87, 47, 228, 75, 88, 97, 132, 244, 137, 187, 129, 73, 193, 96, 246, 22, 185, 79, 139, 231, 246, 14, 135, 193, 244, 79, 114, 66, 190, 25, 229, 158, 164, 78, 251, 229, 251, 67, 188, 25, 25, 14, 250, 228, 94, 66, 7, 153, 14, 217, 250, 166, 45, 39, 168, 123, 48, 222, 60, 71, 88, 218, 204, 156, 2, 5, 141, 95, 108, 63, 18, 18, 49, 35, 33, 34, 65, 146, 17, 144, 244, 101, 65, 132, 30, 167, 116, 217, 92, 63, 230, 251, 60, 206, 151, 193, 196, 191, 227, 152, 141, 112, 33, 181, 149, 231, 8, 20, 38, 75, 96, 194, 109, 225, 208, 148, 65, 62, 134, 124, 121, 238, 138, 36, 175, 16, 184, 169, 230, 130, 119, 62, 7, 3, 119, 168, 245, 174, 60, 190, 1, 166, 186, 141, 245, 30, 207, 55, 48, 114, 251, 186, 203, 112, 224, 54, 70, 176, 94, 222, 22, 213, 80, 225, 209, 199, 54, 198, 158, 59, 146, 213, 157, 217, 222, 213, 190, 145, 10, 249, 233, 191, 70, 74, 81, 187, 204, 17, 47, 132, 209, 231, 222, 77, 187, 10, 179, 233, 79, 101, 237, 112, 135, 121, 38, 76, 248, 254, 30, 199, 97, 41, 60, 164, 164, 180, 74, 32, 123, 201, 218, 114, 56, 45, 2, 66, 44, 0, 128, 77, 8, 224, 177, 219, 125, 81, 61, 224, 154, 23, 77, 167, 131, 222, 9, 201, 224, 95, 170, 88, 114, 46, 14, 119, 80, 214, 231, 22, 50, 240, 68, 177, 148, 77, 156, 143, 161, 85, 99, 252, 233, 178, 203, 69, 111, 100, 170, 158, 250, 104, 137, 131, 67, 223, 92, 210, 73, 36, 121, 216, 85, 218, 193, 79, 65, 227, 144, 98, 24, 150, 36, 158, 183, 191, 141, 142, 210, 68, 254, 7, 199, 100, 33, 156, 47, 120, 62, 56, 180, 170, 173, 105, 164, 228, 165, 70, 199, 65, 115, 136, 132, 150, 178, 251, 237, 111, 1, 74, 194, 152, 175, 171, 147, 92, 169, 90, 39, 206, 14, 100, 176, 6, 140, 28, 236, 126, 73, 6, 228, 30, 49, 192, 237, 203, 10, 122, 0, 48, 123, 161, 242, 192, 96, 160, 39, 9, 3, 243, 101, 20, 72, 21, 156, 171, 57, 246, 200, 227, 88, 161, 82, 196, 226, 196, 136, 169, 197, 207, 20, 180, 228, 15, 81, 84, 224, 172, 227, 16, 173, 17, 163, 185, 32, 181, 18, 196, 245, 16, 5, 254, 45, 170, 34, 253, 169, 212, 19, 0, 77, 132, 226, 10, 40, 77, 4, 54, 78, 219, 218, 248, 175, 158, 122, 69, 117, 95, 110, 253, 123, 232, 215, 161, 221, 157, 228, 222, 29, 128, 222, 71, 53, 81, 137, 23, 96, 99, 9, 174, 111, 150, 138, 83, 55, 222, 49, 48, 181, 175, 19, 131, 204, 167, 175, 122, 55, 168, 207, 33, 44, 21, 208, 66, 39, 230, 77, 48, 128, 24, 67, 23, 66, 185, 194, 62, 212, 165, 111, 2, 88, 58, 28, 21, 0, 222, 0, 240, 52, 27, 133, 49, 38, 128, 4, 70, 159, 42, 233, 23, 197, 181, 186, 94, 196, 31, 42, 24, 103, 150, 67, 196, 104, 40, 46, 124, 46, 231, 192, 184, 104, 12, 53, 160, 125, 171, 177, 10, 74, 194, 84, 42, 169, 124, 42, 42, 165, 20, 213, 76, 162, 76, 138, 200, 160, 189, 44, 225, 144, 174, 202, 115, 24, 238, 48, 97, 235, 198, 64, 242, 177, 122, 214, 14, 40, 53, 236, 4, 64, 176, 94, 236, 88, 155, 65, 192, 46, 175, 221, 98, 173, 90, 116, 243, 224, 218, 64, 36, 115, 102, 108, 204, 70, 20, 104, 73, 38, 45, 82, 50, 150, 156, 76, 189, 38, 28, 170, 212, 41, 233, 194, 174, 84, 113, 166, 199, 114, 52, 140, 72, 32, 21, 141, 195, 242, 183, 176, 171, 158, 247, 147, 218, 245, 14, 186, 205, 115, 238, 139, 95, 175, 154, 11, 119, 14, 135, 177, 177, 173, 101, 214, 55, 76, 216, 204, 9, 140, 232, 140, 245, 25, 179, 72, 92, 225, 85, 99, 204, 239, 175, 66, 163, 220, 115, 99, 147, 218, 198, 221, 169, 54, 198, 237, 49, 55, 239, 76, 168, 27, 82, 179, 218, 102, 122, 236, 137, 41, 219, 46, 209, 74, 184, 95, 116, 191, 156, 57, 22, 122, 102, 1, 89, 87, 196, 118, 150, 100, 112, 252, 99, 80, 213, 209, 131, 151, 167, 241, 7, 134, 16, 203, 181, 162, 189, 145, 185, 167, 217, 174, 81, 212, 8, 35, 168, 84, 99, 38, 81, 20, 10, 189, 56, 242, 19, 5, 29, 238, 22, 173, 84, 226, 144, 228, 72, 204, 168, 234, 75, 54, 40, 141, 154, 99, 26, 3, 163, 229, 174, 208, 237, 120, 229, 26, 183, 76, 31, 37, 233, 143, 161, 224, 40, 208, 176, 227, 243, 205, 206, 166, 89, 97, 243, 104, 199, 153, 64, 220, 26, 101, 132, 109, 194, 161, 94, 38, 114, 18, 42, 164, 7, 27, 86, 40, 130, 106, 19, 6, 112, 19, 1, 76, 9, 128, 116, 9, 236, 86, 18, 50, 66, 135, 122, 45, 209, 72, 135, 71, 240, 161, 102, 202, 217, 8, 68, 40, 190, 245, 78, 248, 30, 31, 200, 36, 2, 23, 245, 134, 43, 183, 112, 240, 48, 141, 62, 79, 6, 147, 200, 124, 100, 48, 135, 117, 8, 134, 76, 190, 121, 207, 151, 110, 215, 242, 142, 209, 139, 62, 224, 126, 240, 166, 119, 27, 58, 104, 133, 53, 215, 3, 67, 148, 31, 8, 24, 15, 51, 139, 62, 180, 239, 65, 242, 41, 137, 3, 249, 27, 173, 118, 250, 78, 155, 224, 184, 92, 35, 238, 25, 180, 43, 43, 104, 163, 92, 236, 211, 56, 41, 155, 133, 208, 32, 247, 157, 27, 22, 97, 166, 217, 235, 4, 58, 15, 194, 63, 238, 19, 185, 185, 226, 58, 207, 124, 60, 145, 252, 59, 124, 233, 80, 65, 69, 77, 183, 68, 73, 87, 28, 168, 122, 183, 32, 201, 227, 77, 138, 145, 61, 177, 187, 165, 195, 201, 204, 5, 69, 26, 160, 227, 140, 55, 180, 5, 217, 99, 21, 166, 86, 221, 166, 56, 184, 53, 152, 27, 101, 7, 114, 188, 0, 128, 84, 13, 0, 235, 122, 10, 79, 9, 154, 93, 93, 49, 143, 183, 227, 18, 44, 94, 55, 21, 190, 128, 231, 48, 137, 164, 68, 185, 113, 58, 16, 66, 232, 231, 79, 53, 210, 28, 28, 232, 178, 92, 91, 122, 41, 22, 56, 100, 192, 250, 239, 131, 171, 67, 117, 102, 134, 18, 245, 65, 145, 139, 69, 172, 29, 192, 214, 231, 196, 214, 78, 36, 132, 18, 44, 149, 244, 171, 105, 115, 11, 203, 236, 151, 224, 135, 3, 67, 44, 92, 246, 40, 109, 79, 18, 92, 193, 220, 53, 35, 216, 29, 11, 56, 178, 137, 30, 233, 133, 230, 135, 245, 225, 27, 75, 74, 248, 165, 88, 174, 241, 110, 47, 125, 84, 117, 32, 112, 191, 20, 204, 201, 20, 145, 15, 52, 49, 79, 84, 127, 81, 4, 55, 35, 41, 225, 13, 101, 231, 134, 213, 112, 108, 147, 24, 221, 100, 52, 67, 25, 45, 103, 162, 236, 214, 222, 185, 239, 29, 115, 235, 157, 230, 226, 215, 14, 119, 113, 64, 236, 24, 121, 192, 166, 85, 18, 89, 113, 108, 210, 25, 16, 200, 216, 90, 20, 247, 70, 25, 194, 196, 197, 102, 45, 145, 208, 85, 59, 148, 206, 56, 66, 170, 110, 7, 189, 125, 229, 170, 255, 3, 148, 41, 65, 190, 87, 244, 48, 141, 144, 114, 206, 235, 199, 204, 175, 140, 158, 5, 110, 15, 56, 18, 14, 231, 192, 103, 136, 185, 129, 2, 97, 135, 41, 10, 152, 189, 166, 9, 229, 41, 69, 90, 21, 82, 177, 217, 168, 146, 70, 97, 196, 150, 214, 206, 171, 162, 129, 66, 181, 238, 143, 71, 37, 208, 50, 193, 35, 206, 248, 105, 16, 233, 33, 80, 206, 174, 71, 221, 158, 146, 19, 171, 67, 145, 92, 5, 112, 17, 65, 56, 45, 1, 86, 176, 40, 1, 79, 139, 96, 83, 213, 49, 70, 170, 6, 104, 38, 160, 239, 190, 107, 220, 247, 176, 147, 215, 81, 103, 166, 113, 0, 192, 135, 68, 137, 34, 71, 255, 63, 63, 134, 215, 208, 31, 76, 24, 64, 48, 109, 161, 166, 158, 203, 33, 176, 252, 31, 139, 167, 146, 2, 247, 218, 253, 151, 244, 72, 71, 19, 100, 58, 185, 15, 10, 201, 18, 32, 92, 83, 8, 82, 65, 181, 216, 194, 210, 238, 240, 205, 80, 198, 206, 150, 180, 35, 251, 253, 24, 42, 175, 221, 132, 33, 204, 71, 105, 66, 69, 144, 145, 94, 110, 0, 83, 82, 17, 218, 72, 71, 184, 35, 17, 109, 11, 21, 157, 182, 104, 126, 129, 12, 134, 122, 50, 229, 35, 44, 97, 167, 177, 203, 144, 56, 13, 1, 124, 6, 147, 97, 176, 118, 20, 74, 22, 82, 233, 15, 227, 218, 24, 44, 178, 2, 30, 52, 11, 100, 151, 101, 75, 12, 176, 116, 173, 140, 156, 183, 182, 193, 122, 106, 84, 191, 122, 219, 41, 22, 210, 137, 36, 176, 219, 240, 184, 95, 215, 163, 177, 215, 121, 93, 231, 83, 40, 201, 56, 186, 62, 69, 151, 163, 114, 152, 115, 67, 150, 205, 48, 136, 74, 72, 159, 213, 250, 63, 47, 227, 251, 237, 198, 119, 194, 16, 34, 26, 187, 29, 204, 173, 216, 10, 89, 110, 174, 39, 84, 150, 181, 94, 91, 24, 254, 154, 49, 88, 191, 149, 126, 246, 223, 15, 59, 203, 176, 75, 134, 67, 181, 93, 40, 156, 5, 160, 42, 88, 228, 166, 68, 18, 49, 201, 101, 234, 122, 76, 138, 140, 34, 94, 26, 80, 134, 240, 20, 181, 211, 22, 35, 208, 244, 127, 231, 75, 127, 255, 119, 251, 27, 91, 155, 67, 27, 97, 141, 40, 50, 167, 28, 65, 47, 154, 216, 232, 66, 150, 226, 72, 227, 122, 182, 130, 229, 84, 203, 50, 76, 163, 46, 17, 96, 21, 92, 30, 71, 87, 237, 235, 249, 61, 63, 47, 103, 103, 2, 185, 100, 103, 240, 115, 248, 213, 1, 36, 142, 165, 188, 119, 53, 118, 146, 200, 123, 137, 154, 193, 44, 105, 161, 72, 16, 70, 41, 1, 2, 11, 4, 137, 17, 80, 130, 65, 0, 136, 195, 197, 218, 46, 52, 232, 236, 186, 93, 59, 6, 215, 127, 197, 242, 92, 1, 120, 0, 123, 72, 146, 44, 138, 113, 177, 15, 109, 84, 36, 227, 32, 148, 248, 243, 111, 221, 81, 171, 106, 97, 137, 45, 97, 1, 182, 208, 231, 20, 147, 104, 99, 196, 65, 91, 85, 85, 141, 58, 90, 64, 212, 196, 65, 71, 17, 138, 109, 182, 210, 179, 243, 126, 103, 233, 99, 135, 112, 76, 201, 9, 189, 103, 203, 164, 124, 110, 152, 98, 98, 180, 170, 8, 91, 5, 65, 120, 253, 62, 23, 57, 131, 193, 194, 172, 233, 102, 53, 164, 11, 22, 170, 156, 241, 197, 203, 212, 45, 241, 245, 194, 154, 93, 162, 40, 28, 58, 86, 178, 240, 171, 212, 178, 65, 22, 48, 73, 167, 201, 236, 240, 48, 255, 52, 10, 140, 24, 48, 36, 79, 101, 216, 55, 11, 196, 68, 3, 177, 16, 236, 65, 168, 140, 136, 22, 9, 205, 173, 110, 184, 162, 97, 17, 145, 49, 0, 200, 137, 149, 207, 105, 18, 193, 39, 214, 84, 42, 216, 77, 27, 198, 232, 229, 235, 22, 132, 181, 189, 205, 250, 51, 136, 46, 169, 188, 138, 34, 113, 69, 86, 164, 129, 210, 128, 36, 120, 161, 100, 44, 25, 5, 136, 70, 204, 215, 65, 240, 123, 216, 254, 214, 86, 175, 183, 235, 116, 117, 185, 154, 218, 214, 114, 45, 133, 150, 128, 8, 197, 66, 207, 59, 71, 145, 169, 203, 120, 68, 68, 210, 209, 227, 105, 115, 250, 118, 241, 137, 66, 209, 187, 185, 168, 223, 169, 208, 16, 68, 29, 122, 147, 238, 60, 224, 227, 165, 208, 211, 215, 206, 255, 129, 61, 133, 148, 67, 173, 17, 33, 17, 67, 254, 160, 10, 211, 16, 88, 68, 55, 47, 147, 16, 30, 241, 23, 138, 251, 204, 28, 120, 47, 198, 78, 59, 103, 189, 223, 176, 134, 98, 26, 196, 162, 9, 13, 10, 134, 75, 9, 52, 46, 81, 86, 54, 60, 10, 205, 242, 150, 40, 181, 52, 230, 130, 247, 201, 72, 97, 32, 145, 137, 139, 146, 198, 47, 18, 128, 132, 2, 147, 5, 238, 92, 205, 95, 5, 13, 219, 5, 175, 108, 149, 239, 238, 3, 191, 21, 190, 104, 107, 26, 33, 116, 174, 133, 37, 215, 17, 249, 46, 13, 26, 165, 163, 186, 78, 166, 159, 146, 243, 112, 31, 254, 117, 122, 118, 97, 193, 120, 150, 7, 54, 199, 215, 103, 127, 246, 104, 70, 65, 34, 175, 203, 163, 59, 221, 101, 4, 56, 195, 179, 211, 174, 165, 198, 65, 47, 214, 237, 151, 184, 149, 3, 179, 84, 137, 231, 73, 3, 213, 136, 26, 65, 234, 105, 177, 100, 45, 91, 238, 86, 219, 145, 168, 108, 44, 103, 179, 144, 237, 144, 159, 12, 201, 137, 234, 178, 210, 215, 122, 218, 4, 146, 65, 75, 85, 107, 179, 54, 234, 87, 82, 192, 80, 122, 214, 205, 243, 5, 98, 254, 7, 189, 178, 30, 116, 217, 97, 180, 6, 114, 210, 156, 127, 75, 221, 177, 188, 207, 62, 242, 188, 156, 52, 112, 228, 162, 220, 145, 75, 86, 39, 166, 108, 51, 200, 196, 38, 200, 1, 80, 217, 176, 147, 66, 78, 104, 148, 177, 131, 140, 155, 111, 123, 228, 229, 159, 52, 185, 134, 70, 6, 182, 211, 127, 64, 194, 244, 33, 34, 222, 102, 59, 28, 214, 205, 132, 221, 123, 97, 223, 166, 96, 97, 59, 243, 81, 153, 43, 138, 212, 60, 240, 0, 227, 108, 185, 138, 18, 83, 73, 77, 33, 7, 138, 66, 145, 0, 33, 0, 142, 149, 163, 96, 57, 53, 120, 62, 164, 182, 114, 84, 42, 204, 137, 2, 100, 13, 171, 133, 102, 57, 193, 25, 230, 4, 225, 100, 194, 57, 24, 7, 22, 172, 203, 209, 251, 54, 164, 25, 236, 20, 74, 30, 43, 40, 227, 194, 219, 172, 46, 171, 32, 230, 34, 1, 104, 8, 13, 39, 202, 138, 128, 94, 34, 3, 218, 46, 0, 7, 44, 0, 45, 18, 160, 141, 17, 80, 132, 21, 151, 197, 163, 212, 39, 224, 77, 61, 44, 40, 58, 65, 87, 88, 128, 156, 97, 157, 113, 107, 95, 90, 181, 129, 228, 160, 206, 46, 165, 235, 15, 139, 156, 1, 226, 246, 231, 174, 149, 236, 254, 55, 102, 204, 200, 93, 128, 27, 165, 203, 82, 188, 85, 165, 234, 161, 165, 127, 141, 178, 174, 228, 202, 237, 134, 152, 163, 19, 205, 189, 218, 184, 106, 112, 208, 179, 220, 135, 8, 137, 219, 214, 153, 49, 219, 20, 9, 93, 120, 164, 14, 43, 98, 251, 24, 107, 20, 132, 36, 84, 229, 128, 236, 214, 78, 190, 202, 187, 204, 202, 96, 163, 131, 187, 9, 50, 96, 226, 96, 97, 17, 241, 59, 113, 158, 62, 121, 76, 81, 226, 103, 166, 114, 119, 115, 121, 203, 200, 41, 75, 198, 123, 123, 98, 202, 6, 208, 230, 85, 168, 2, 70, 56, 48, 86, 107, 148, 188, 221, 203, 107, 90, 205, 226, 100, 145, 66, 0, 25, 64, 56, 77, 67, 129, 180, 40, 33, 146, 58, 104, 108, 142, 195, 93, 228, 20, 100, 6, 196, 65, 48, 65, 80, 168, 18, 59, 254, 38, 44, 139, 128, 228, 220, 35, 125, 219, 151, 13, 34, 113, 141, 59, 170, 141, 227, 77, 66, 238, 247, 106, 183, 137, 173, 205, 85, 216, 50, 16, 121, 134, 109, 43, 104, 148, 48, 182, 192, 78, 67, 155, 78, 79, 127, 189, 80, 228, 242, 53, 47, 112, 2, 241, 68, 180, 97, 59, 91, 14, 162, 175, 140, 78, 148, 28, 46, 132, 6, 152, 4, 88, 50, 3, 1, 210, 45, 48, 136, 112, 32, 173, 170, 133, 147, 164, 114, 80, 244, 14, 133, 28, 164, 69, 206, 29, 121, 249, 240, 42, 110, 129, 152, 38, 232, 161, 34, 171, 198, 107, 65, 186, 6, 72, 138, 98, 35, 136, 90, 9, 248, 214, 55, 250, 183, 28, 16, 0, 217, 177, 161, 83, 2, 106, 37, 38, 200, 73, 130, 2, 72, 170, 218, 41, 172, 29, 34, 33, 71, 16, 37, 104, 139, 175, 15, 35, 81, 110, 134, 0, 214, 18, 3, 104, 163, 37, 184, 164, 20, 171, 186, 112, 38, 208, 169, 193, 204, 235, 240, 234, 239, 44, 41, 237, 117, 119, 123, 158, 93, 252, 33, 236, 177, 245, 187, 75, 106, 82, 39, 62, 220, 214, 139, 91, 214, 154, 117, 187, 84, 15, 82, 35, 225, 64, 100, 69, 37, 82, 27, 165, 169, 161, 145, 4, 180, 93, 157, 87, 171, 191, 46, 3, 76, 182, 11, 120, 65, 235, 116, 104, 83, 4, 20, 162, 11, 197, 103, 99, 120, 2, 144, 43, 96, 29, 52, 151, 68, 216, 137, 177, 51, 36, 17, 219, 176, 14, 208, 108, 10, 52, 74, 26, 105, 202, 104, 3, 168, 234, 154, 232, 105, 97, 204, 18, 65, 18, 240, 9, 6, 28, 116, 169, 196, 59, 115, 10, 41, 64, 13, 55, 131, 164, 108, 199, 196, 130, 243, 78, 16, 19, 194, 142, 30, 177, 67, 64, 155, 160, 110, 135, 45, 154, 221, 195, 144, 170, 44, 218, 0, 98, 66, 10, 70, 10, 75, 85, 64, 136, 96, 185, 30, 15, 53, 112, 20, 12, 66, 48, 66, 157, 144, 12, 197, 83, 151, 82, 249, 50, 201, 32, 24, 64, 145, 83, 16, 146, 71, 34, 60, 50, 231, 56, 192, 41, 80, 164, 8, 3, 16, 83, 16, 120, 17, 185, 2, 160, 224, 86, 202, 82, 36, 142, 20, 72, 13, 68, 100, 68, 165, 18, 53, 65, 139, 9, 136, 42, 94, 237, 27, 179, 64, 102, 27, 7, 123, 65, 73, 212, 43, 121, 154, 83, 108, 64, 218, 68, 3, 105, 20, 243, 72, 15, 49, 0, 3, 4, 16, 36, 49, 16, 221, 3, 75, 59, 184, 92, 11, 17, 17, 112, 16, 28, 132, 0, 50, 183, 89, 40, 4, 151, 252, 93, 201, 20, 225, 66, 67, 223, 122, 181, 44 };

constexpr std::array<u8, 1033> SS_HEADBUTT = { 14, 17, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 120, 99, 147, 173, 0, 5, 168, 127, 254, 127, 255, 255, 255, 209, 254, 68, 56, 12, 128, 2, 132, 253, 224, 255, 62, 232, 100, 28, 4, 143, 0, 32, 1, 0, 4, 1, 0, 80, 4, 207, 105, 45, 72, 0, 1, 233, 209, 194, 84, 202, 9, 52, 13, 60, 83, 106, 52, 100, 122, 128, 0, 208, 13, 12, 64, 52, 12, 77, 15, 80, 109, 170, 0, 74, 9, 165, 79, 80, 13, 52, 6, 128, 0, 0, 0, 0, 0, 0, 0, 0, 28, 25, 6, 141, 0, 100, 211, 16, 211, 65, 144, 98, 24, 64, 208, 26, 49, 49, 26, 0, 0, 25, 84, 0, 0, 2, 48, 104, 104, 0, 8, 192, 0, 0, 0, 0, 0, 34, 72, 137, 52, 218, 131, 210, 167, 131, 72, 209, 52, 0, 26, 26, 52, 3, 77, 0, 0, 104, 25, 27, 83, 205, 83, 73, 230, 63, 56, 195, 167, 65, 194, 8, 80, 138, 149, 57, 238, 35, 184, 43, 68, 142, 67, 89, 210, 49, 225, 226, 161, 34, 36, 40, 254, 21, 10, 78, 91, 127, 136, 68, 122, 206, 184, 30, 0, 104, 219, 97, 233, 90, 243, 172, 22, 38, 7, 84, 164, 178, 73, 178, 83, 160, 118, 96, 160, 136, 98, 130, 169, 33, 134, 18, 128, 152, 200, 19, 112, 80, 130, 32, 114, 32, 132, 10, 96, 117, 87, 93, 130, 130, 230, 4, 10, 180, 36, 177, 13, 6, 195, 70, 224, 97, 112, 162, 176, 25, 160, 160, 149, 84, 202, 166, 168, 162, 72, 81, 41, 149, 78, 130, 180, 220, 105, 172, 44, 64, 138, 72, 105, 169, 57, 49, 56, 70, 147, 65, 40, 118, 38, 68, 209, 101, 14, 138, 210, 24, 112, 119, 80, 24, 113, 137, 200, 34, 73, 8, 14, 168, 241, 4, 161, 29, 32, 72, 38, 40, 227, 16, 73, 37, 132, 194, 165, 153, 6, 88, 239, 66, 139, 18, 4, 171, 74, 13, 225, 190, 33, 8, 74, 21, 56, 241, 155, 211, 122, 183, 95, 149, 139, 50, 196, 200, 138, 24, 176, 4, 2, 2, 15, 58, 35, 4, 30, 128, 71, 66, 232, 143, 162, 170, 227, 70, 38, 20, 92, 185, 123, 206, 110, 82, 199, 33, 164, 97, 161, 180, 211, 13, 4, 37, 24, 14, 144, 184, 57, 60, 254, 4, 39, 10, 2, 130, 136, 162, 42, 130, 139, 106, 230, 213, 89, 26, 219, 211, 91, 171, 201, 90, 191, 164, 49, 216, 187, 235, 46, 223, 45, 171, 127, 151, 36, 247, 191, 44, 191, 45, 153, 183, 230, 108, 205, 169, 220, 49, 157, 150, 84, 21, 24, 10, 128, 197, 16, 15, 182, 34, 27, 90, 136, 254, 76, 85, 145, 49, 118, 180, 31, 91, 136, 55, 171, 216, 2, 236, 25, 18, 17, 241, 109, 219, 250, 121, 118, 238, 251, 170, 36, 240, 157, 240, 136, 16, 130, 30, 208, 61, 245, 144, 131, 32, 194, 65, 130, 65, 47, 96, 184, 16, 145, 32, 193, 44, 168, 126, 191, 217, 8, 247, 111, 129, 0, 145, 81, 184, 220, 30, 8, 211, 65, 84, 48, 78, 244, 133, 240, 24, 165, 134, 195, 4, 144, 131, 2, 22, 70, 195, 34, 18, 4, 8, 4, 32, 224, 59, 148, 33, 227, 241, 26, 199, 121, 92, 132, 53, 14, 170, 142, 145, 200, 125, 193, 204, 30, 232, 247, 94, 192, 211, 194, 7, 3, 190, 129, 67, 66, 159, 80, 88, 124, 110, 108, 109, 98, 139, 85, 5, 55, 12, 24, 159, 189, 152, 172, 32, 22, 176, 56, 163, 153, 102, 193, 16, 128, 88, 15, 176, 32, 48, 136, 120, 195, 3, 185, 138, 98, 140, 139, 18, 0, 92, 197, 128, 50, 16, 129, 121, 39, 17, 241, 24, 3, 96, 185, 1, 131, 63, 168, 208, 196, 129, 16, 137, 160, 46, 4, 2, 32, 72, 129, 8, 173, 41, 127, 33, 54, 110, 243, 91, 19, 65, 6, 4, 86, 48, 43, 24, 132, 25, 32, 67, 18, 94, 226, 22, 19, 73, 27, 176, 97, 2, 192, 221, 143, 36, 196, 34, 88, 145, 131, 22, 49, 136, 14, 206, 193, 186, 111, 5, 221, 124, 38, 102, 97, 114, 27, 161, 90, 188, 133, 78, 50, 167, 33, 193, 158, 3, 54, 74, 26, 75, 80, 226, 176, 118, 5, 26, 198, 12, 24, 20, 152, 194, 27, 152, 208, 208, 221, 74, 42, 16, 45, 254, 23, 49, 100, 24, 52, 243, 244, 225, 67, 76, 112, 112, 33, 9, 11, 89, 36, 67, 203, 132, 110, 224, 16, 140, 132, 66, 152, 153, 3, 79, 17, 204, 80, 23, 6, 46, 13, 4, 88, 48, 143, 73, 208, 16, 74, 6, 204, 119, 51, 255, 129, 176, 61, 96, 237, 26, 16, 233, 30, 217, 67, 160, 31, 66, 20, 0, 44, 138, 0, 128, 204, 160, 10, 37, 160, 6, 1, 68, 24, 4, 8, 36, 8, 32, 128, 137, 102, 73, 132, 189, 77, 97, 58, 7, 216, 30, 139, 235, 78, 227, 110, 209, 230, 220, 3, 204, 8, 233, 12, 220, 193, 153, 47, 8, 58, 144, 225, 113, 67, 75, 186, 242, 158, 124, 59, 83, 150, 44, 173, 92, 193, 114, 23, 30, 99, 140, 185, 111, 68, 155, 3, 2, 85, 83, 106, 8, 100, 41, 16, 73, 94, 144, 150, 72, 196, 41, 21, 8, 122, 117, 20, 118, 90, 101, 156, 5, 185, 76, 94, 221, 147, 154, 220, 103, 33, 206, 76, 118, 113, 234, 14, 78, 64, 46, 45, 206, 35, 136, 53, 143, 9, 172, 119, 67, 48, 224, 55, 131, 156, 53, 120, 71, 168, 118, 187, 94, 135, 88, 235, 117, 142, 110, 111, 3, 234, 14, 251, 144, 100, 25, 25, 25, 3, 144, 57, 6, 67, 208, 116, 97, 7, 140, 123, 33, 194, 118, 71, 49, 229, 54, 6, 225, 144, 110, 26, 3, 16, 136, 136, 136, 213, 101, 66, 136, 152, 255, 226, 238, 72, 167, 10, 18, 15, 12, 114, 117, 160 };

