#include <Core/Gen3/ShadowTemplate.hpp>
#include <Core/Gen3/StaticTemplate3.hpp>
#include <array>

constexpr std::array<StaticTemplate3, 9> STARTERS = { StaticTemplate3(Game::Emerald, 152, 0, Shiny::Random, 5), StaticTemplate3(Game::Emerald, 155, 0, Shiny::Random, 5), StaticTemplate3(Game::Emerald, 158, 0, Shiny::Random, 5), StaticTemplate3(Game::RSE, 252, 0, Shiny::Random, 5), StaticTemplate3(Game::RSE, 255, 0, Shiny::Random, 5), StaticTemplate3(Game::RSE, 258, 0, Shiny::Random, 5), StaticTemplate3(Game::FRLG, 1, 0, Shiny::Random, 5), StaticTemplate3(Game::FRLG, 4, 0, Shiny::Random, 5), StaticTemplate3(Game::FRLG, 7, 0, Shiny::Random, 5) };

constexpr std::array<StaticTemplate3, 5> FOSSILS = { StaticTemplate3(Game::RSE, 345, 0, Shiny::Random, 20), StaticTemplate3(Game::RSE, 347, 0, Shiny::Random, 20), StaticTemplate3(Game::FRLG, 138, 0, Shiny::Random, 5), StaticTemplate3(Game::FRLG, 140, 0, Shiny::Random, 5), StaticTemplate3(Game::FRLG, 142, 0, Shiny::Random, 5) };

constexpr std::array<StaticTemplate3, 9> GIFTS = { StaticTemplate3(Game::RSE, 351, 0, Shiny::Random, 25), StaticTemplate3(Game::RSE, 374, 0, Shiny::Random, 5), StaticTemplate3(Game::RSE, 360, 0, Shiny::Random, 5), StaticTemplate3(Game::FRLG, 106, 0, Shiny::Random, 25), StaticTemplate3(Game::FRLG, 107, 0, Shiny::Random, 25), StaticTemplate3(Game::FRLG, 129, 0, Shiny::Random, 5), StaticTemplate3(Game::FRLG, 131, 0, Shiny::Random, 25), StaticTemplate3(Game::FRLG, 133, 0, Shiny::Random, 25), StaticTemplate3(Game::FRLG, 175, 0, Shiny::Random, 5) };

constexpr std::array<StaticTemplate3, 10> GAMECORNER = { StaticTemplate3(Game::FireRed, 63, 0, Shiny::Random, 9), StaticTemplate3(Game::FireRed, 35, 0, Shiny::Random, 8), StaticTemplate3(Game::FireRed, 123, 0, Shiny::Random, 25), StaticTemplate3(Game::FireRed, 147, 0, Shiny::Random, 18), StaticTemplate3(Game::FireRed, 137, 0, Shiny::Random, 26), StaticTemplate3(Game::LeafGreen, 63, 0, Shiny::Random, 7), StaticTemplate3(Game::LeafGreen, 35, 0, Shiny::Random, 12), StaticTemplate3(Game::LeafGreen, 127, 0, Shiny::Random, 18), StaticTemplate3(Game::LeafGreen, 147, 0, Shiny::Random, 24), StaticTemplate3(Game::LeafGreen, 137, 0, Shiny::Random, 18) };

constexpr std::array<StaticTemplate3, 7> STATIONARY = { StaticTemplate3(Game::RSE, 352, 0, Shiny::Random, 30), StaticTemplate3(Game::RSE, 100, 0, Shiny::Random, 25), StaticTemplate3(Game::RSE, 101, 0, Shiny::Random, 30), StaticTemplate3(Game::Emerald, 185, 0, Shiny::Random, 40), StaticTemplate3(Game::FRLG, 143, 0, Shiny::Random, 30), StaticTemplate3(Game::FRLG, 101, 0, Shiny::Random, 34), StaticTemplate3(Game::FRLG, 97, 0, Shiny::Random, 30) };

constexpr std::array<StaticTemplate3, 14> LEGENDS = { StaticTemplate3(Game::RSE, 377, 0, Shiny::Random, 40), StaticTemplate3(Game::RSE, 378, 0, Shiny::Random, 40), StaticTemplate3(Game::RSE, 379, 0, Shiny::Random, 40), StaticTemplate3(Game::Emerald | Game::Ruby, 380, 0, Shiny::Random, 50), StaticTemplate3(Game::Emerald | Game::Sapphire, 381, 0, Shiny::Random, 50), StaticTemplate3(Game::Sapphire, 382, 0, Shiny::Random, 45), StaticTemplate3(Game::Emerald, 382, 0, Shiny::Random, 70), StaticTemplate3(Game::Ruby, 383, 0, Shiny::Random, 45), StaticTemplate3(Game::Emerald, 383, 0, Shiny::Random, 70), StaticTemplate3(Game::RSE, 384, 0, Shiny::Random, 70), StaticTemplate3(Game::FRLG, 144, 0, Shiny::Random, 50), StaticTemplate3(Game::FRLG, 145, 0, Shiny::Random, 50), StaticTemplate3(Game::FRLG, 146, 0, Shiny::Random, 50), StaticTemplate3(Game::FRLG, 150, 0, Shiny::Random, 70) };

constexpr std::array<StaticTemplate3, 6> EVENTS = { StaticTemplate3(Game::Emerald, 151, 0, Shiny::Random, 30), StaticTemplate3(Game::Emerald, 386, 3, Shiny::Random, 30), StaticTemplate3(Game::FireRed, 386, 1, Shiny::Random, 30), StaticTemplate3(Game::LeafGreen, 386, 2, Shiny::Random, 30), StaticTemplate3(Game::Emerald | Game::FRLG, 249, 0, Shiny::Random, 70), StaticTemplate3(Game::Emerald | Game::FRLG, 250, 0, Shiny::Random, 70) };

constexpr std::array<StaticTemplate3, 7> ROAMERS = { StaticTemplate3(Game::FRLG, 243, 0, Shiny::Random, 50), StaticTemplate3(Game::FRLG, 244, 0, Shiny::Random, 50), StaticTemplate3(Game::FRLG, 245, 0, Shiny::Random, 50), StaticTemplate3(Game::Sapphire, 380, 0, Shiny::Random, 40), StaticTemplate3(Game::Ruby, 381, 0, Shiny::Random, 40), StaticTemplate3(Game::Emerald, 380, 0, Shiny::Random, 40), StaticTemplate3(Game::Emerald, 381, 0, Shiny::Random, 40) };

constexpr std::array<StaticTemplate3, 69> GALESCOLO = { StaticTemplate3(Game::Colosseum, 197, 0, Shiny::Never, 26), StaticTemplate3(Game::Colosseum, 196, 0, Shiny::Never, 25), StaticTemplate3(Game::Colosseum, 250, 0, Shiny::Never, 70), StaticTemplate3(Game::Colosseum, 251, 0, Shiny::Never, 10), StaticTemplate3(Game::Colosseum, 25, 0, Shiny::Never, 10), StaticTemplate3(Game::Gales, 133, 0, Shiny::Random, 10), StaticTemplate3(Game::Gales, 152, 0, Shiny::Random, 5), StaticTemplate3(Game::Gales, 155, 0, Shiny::Random, 5), StaticTemplate3(Game::Gales, 158, 0, Shiny::Random, 5), StaticTemplate3(Game::Colosseum, 153, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 156, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 159, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 164, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 180, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 188, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 195, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 200, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 193, 0, Shiny::Random, 33), StaticTemplate3(Game::Colosseum, 162, 0, Shiny::Random, 33), StaticTemplate3(Game::Colosseum, 218, 0, Shiny::Random, 30), StaticTemplate3(Game::Colosseum, 223, 0, Shiny::Random, 20), StaticTemplate3(Game::Colosseum, 226, 0, Shiny::Random, 33), StaticTemplate3(Game::Colosseum, 211, 0, Shiny::Random, 33), StaticTemplate3(Game::Colosseum, 307, 0, Shiny::Random, 33), StaticTemplate3(Game::Colosseum, 206, 0, Shiny::Random, 33), StaticTemplate3(Game::Colosseum, 333, 0, Shiny::Random, 33), StaticTemplate3(Game::Colosseum, 185, 0, Shiny::Random, 35), StaticTemplate3(Game::Colosseum, 237, 0, Shiny::Random, 38), StaticTemplate3(Game::Colosseum, 244, 0, Shiny::Random, 40), StaticTemplate3(Game::Colosseum, 166, 0, Shiny::Random, 40), StaticTemplate3(Game::Colosseum, 245, 0, Shiny::Random, 40), StaticTemplate3(Game::Colosseum, 234, 0, Shiny::Random, 43), StaticTemplate3(Game::Colosseum, 221, 0, Shiny::Random, 43), StaticTemplate3(Game::Colosseum, 215, 0, Shiny::Random, 43), StaticTemplate3(Game::Colosseum, 190, 0, Shiny::Random, 43), StaticTemplate3(Game::Colosseum, 205, 0, Shiny::Random, 43), StaticTemplate3(Game::Colosseum, 210, 0, Shiny::Random, 43), StaticTemplate3(Game::Colosseum, 329, 0, Shiny::Random, 43), StaticTemplate3(Game::Colosseum, 168, 0, Shiny::Random, 43), StaticTemplate3(Game::Colosseum, 243, 0, Shiny::Random, 40), StaticTemplate3(Game::Colosseum, 192, 0, Shiny::Random, 45), StaticTemplate3(Game::Colosseum, 225, 0, Shiny::Random, 45), StaticTemplate3(Game::Colosseum, 227, 0, Shiny::Random, 47), StaticTemplate3(Game::Colosseum, 241, 0, Shiny::Random, 48), StaticTemplate3(Game::Colosseum, 359, 0, Shiny::Random, 48), StaticTemplate3(Game::Colosseum, 229, 0, Shiny::Random, 48), StaticTemplate3(Game::Colosseum, 357, 0, Shiny::Random, 49), StaticTemplate3(Game::Colosseum, 376, 0, Shiny::Random, 50), StaticTemplate3(Game::Colosseum, 248, 0, Shiny::Random, 55), StaticTemplate3(Game::Colosseum, 235, 0, Shiny::Random, 45), StaticTemplate3(Game::Colosseum, 213, 0, Shiny::Random, 45), StaticTemplate3(Game::Colosseum, 176, 0, Shiny::Random, 20), StaticTemplate3(Game::Gales, 216, 0, Shiny::Never, 11), StaticTemplate3(Game::Gales, 343, 0, Shiny::Never, 17), StaticTemplate3(Game::Gales, 179, 0, Shiny::Never, 17), StaticTemplate3(Game::Gales, 318, 0, Shiny::Never, 15), StaticTemplate3(Game::Gales, 228, 0, Shiny::Never, 17), StaticTemplate3(Game::Gales, 335, 0, Shiny::Never, 28), StaticTemplate3(Game::Gales, 175, 0, Shiny::Never, 25), StaticTemplate3(Game::Gales, 90, 0, Shiny::Never, 29), StaticTemplate3(Game::Gales, 15, 0, Shiny::Never, 30), StaticTemplate3(Game::Gales, 277, 0, Shiny::Never, 43), StaticTemplate3(Game::Gales, 249, 0, Shiny::Never, 50), StaticTemplate3(Game::Gales, 112, 0, Shiny::Never, 46), StaticTemplate3(Game::Gales, 146, 0, Shiny::Never, 50), StaticTemplate3(Game::Gales, 103, 0, Shiny::Never, 46), StaticTemplate3(Game::Gales, 128, 0, Shiny::Never, 46), StaticTemplate3(Game::Gales, 144, 0, Shiny::Never, 50), StaticTemplate3(Game::Gales, 145, 0, Shiny::Never, 50) };

constexpr std::array<ShadowTemplate, 77> GALESCOLOSHADOW = { ShadowTemplate(Game::Colosseum, 296, Shiny::Random, 30, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(0, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Colosseum, 207, Shiny::Random, 43, std::array<LockInfo, 5> { LockInfo(12, 0, 127), LockInfo(6, 1, 191), LockInfo(18, 0, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Colosseum, 198, Shiny::Random, 43, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(12, 1, 127), LockInfo(18, 0, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Colosseum, 214, Shiny::Random, 45, std::array<LockInfo, 5> { LockInfo(0, 0, 127), LockInfo(0, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Colosseum, 217, Shiny::Random, 45, std::array<LockInfo, 5> { LockInfo(20, 1, 63), LockInfo(16, 0, 31), LockInfo(21, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Colosseum, 175, Shiny::Random, 20, std::array<LockInfo, 5> { LockInfo(23, 0, 127), LockInfo(8, 0, 127), LockInfo(24, 0, 127), LockInfo(22, 1, 31) }, 4, ShadowType::EReader), ShadowTemplate(Game::Colosseum, 179, Shiny::Random, 37, std::array<LockInfo, 5> { LockInfo(4, 1, 191), LockInfo(10, 1, 127), LockInfo(12, 1, 127), LockInfo(16, 1, 127) }, 4, ShadowType::EReader), ShadowTemplate(Game::Colosseum, 212, Shiny::Random, 50, std::array<LockInfo, 5> { LockInfo(13, 1, 191), LockInfo(2, 2, 255), LockInfo(3, 0, 127), LockInfo(11, 0, 127) }, 4, ShadowType::EReader), ShadowTemplate(Game::Gales, 165, Shiny::Never, 10, std::array<LockInfo, 5> { LockInfo(0, 1, 127) }, 1, ShadowType::SingleLock), ShadowTemplate(Game::Gales, 261, Shiny::Never, 10, std::array<LockInfo, 5> { LockInfo(12, 1, 127) }, 1, ShadowType::SingleLock), ShadowTemplate(Game::Gales, 363, Shiny::Never, 17, std::array<LockInfo, 5> { LockInfo(24, 0, 63), LockInfo(12, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 363, Shiny::Never, 17, std::array<LockInfo, 5> { LockInfo(24, 0, 63), LockInfo(12, 1, 127), LockInfo(0, 2, 255) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 316, Shiny::Never, 17, std::array<LockInfo, 5> { LockInfo(12, 1, 127), LockInfo(6, 0, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 273, Shiny::Never, 17, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(24, 1, 127), LockInfo(18, 1, 127), LockInfo(0, 0, 127), LockInfo(12, 0, 127) }, 5, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 273, Shiny::Never, 17, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(24, 1, 127), LockInfo(0, 1, 127), LockInfo(0, 1, 127), LockInfo(6, 0, 127) }, 5, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 273, Shiny::Never, 17, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(24, 1, 127), LockInfo(0, 1, 127), LockInfo(0, 0, 127), LockInfo(12, 0, 127) }, 5, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 167, Shiny::Never, 14, std::array<LockInfo, 5> { LockInfo(12, 1, 127), LockInfo(6, 0, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 322, Shiny::Never, 14, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(0, 2, 255), LockInfo(24, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 285, Shiny::Never, 14, std::array<LockInfo, 5> { LockInfo(24, 1, 191), LockInfo(0, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 301, Shiny::Never, 18, std::array<LockInfo, 5> { LockInfo(6, 1, 191), LockInfo(0, 0, 127), LockInfo(24, 0, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 100, Shiny::Never, 19, std::array<LockInfo, 5> { LockInfo(0, 0, 127), LockInfo(18, 0, 127), LockInfo(12, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 296, Shiny::Never, 18, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(18, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 37, Shiny::Never, 18, std::array<LockInfo, 5> { LockInfo(0, 0, 127), LockInfo(6, 1, 127), LockInfo(18, 0, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 355, Shiny::Never, 19, std::array<LockInfo, 5> { LockInfo(12, 0, 127), LockInfo(18, 1, 127), LockInfo(24, 0, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 280, Shiny::Never, 20, std::array<LockInfo, 5> { LockInfo(0, 0, 63), LockInfo(6, 1, 127), LockInfo(18, 0, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 303, Shiny::Never, 22, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(18, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 361, Shiny::Never, 20, std::array<LockInfo, 5> { LockInfo(6, 1, 127) }, 1, ShadowType::SingleLock), ShadowTemplate(Game::Gales, 361, Shiny::Never, 20, std::array<LockInfo, 5> { LockInfo(6, 0, 127) }, 1, ShadowType::SingleLock), ShadowTemplate(Game::Gales, 177, Shiny::Never, 22, std::array<LockInfo, 5> { LockInfo(0, 0, 127), LockInfo(0, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 177, Shiny::Never, 22, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(18, 0, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 52, Shiny::Never, 22, std::array<LockInfo, 5> { LockInfo(6, 0, 63), LockInfo(0, 1, 127), LockInfo(18, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 220, Shiny::Never, 22, std::array<LockInfo, 5> { LockInfo(18, 1, 127), LockInfo(0, 0, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 21, Shiny::Never, 22, std::array<LockInfo, 5> { LockInfo(18, 0, 127), LockInfo(6, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 88, Shiny::Never, 23, std::array<LockInfo, 5> { LockInfo(12, 0, 127), LockInfo(18, 0, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 86, Shiny::Never, 23, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(18, 0, 127), LockInfo(18, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 337, Shiny::Never, 25, std::array<LockInfo, 5> { LockInfo(0, 1, 127), LockInfo(18, 0, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 299, Shiny::Never, 26, std::array<LockInfo, 5> { LockInfo(0, 0, 127), LockInfo(18, 0, 127), LockInfo(12, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 46, Shiny::Never, 28, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(6, 1, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 58, Shiny::Never, 28, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(6, 1, 127), LockInfo(0, 0, 0) }, 3, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 17, Shiny::Never, 30, std::array<LockInfo, 5> { LockInfo(0, 0, 0), LockInfo(12, 0, 127), LockInfo(18, 0, 31) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 114, Shiny::Never, 30, std::array<LockInfo, 5> { LockInfo(12, 1, 191), LockInfo(6, 0, 127), LockInfo(0, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 12, Shiny::Never, 30, std::array<LockInfo, 5> { LockInfo(12, 1, 191), LockInfo(6, 0, 127), LockInfo(0, 1, 127), LockInfo(0, 0, 0) }, 4, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 82, Shiny::Never, 30, std::array<LockInfo, 5> { LockInfo(18, 2, 255), LockInfo(0, 0, 127), LockInfo(12, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 49, Shiny::Never, 32, std::array<LockInfo, 5> { LockInfo(18, 1, 127), LockInfo(24, 0, 0), LockInfo(12, 0, 63) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 70, Shiny::Never, 32, std::array<LockInfo, 5> { LockInfo(18, 1, 127), LockInfo(24, 0, 0), LockInfo(12, 0, 63), LockInfo(0, 0, 0) }, 4, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 24, Shiny::Never, 33, std::array<LockInfo, 5> { LockInfo(6, 0, 127), LockInfo(0, 1, 127), LockInfo(12, 1, 127), LockInfo(18, 1, 127) }, 4, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 57, Shiny::Never, 34, std::array<LockInfo, 5> { LockInfo(18, 1, 127), LockInfo(12, 1, 127), LockInfo(6, 1, 127), LockInfo(24, 0, 127) }, 4, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 97, Shiny::Never, 34, std::array<LockInfo, 5> { LockInfo(18, 1, 127), LockInfo(12, 1, 127), LockInfo(6, 1, 127), LockInfo(24, 0, 127), LockInfo(0, 0, 0) }, 5, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 55, Shiny::Never, 33, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(6, 1, 127), LockInfo(18, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 302, Shiny::Never, 33, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(6, 1, 127), LockInfo(18, 1, 127), LockInfo(0, 0, 0) }, 4, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 85, Shiny::Never, 34, std::array<LockInfo, 5> { LockInfo(18, 1, 127) }, 1, ShadowType::SingleLock), ShadowTemplate(Game::Gales, 20, Shiny::Never, 34, std::array<LockInfo, 5> { LockInfo(18, 1, 127), LockInfo(0, 0, 0), LockInfo(18, 0, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 83, Shiny::Never, 36, std::array<LockInfo, 5> { LockInfo(12, 0, 127), LockInfo(0, 1, 127), LockInfo(24, 0, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 334, Shiny::Never, 36, std::array<LockInfo, 5> { LockInfo(12, 0, 127), LockInfo(0, 1, 127), LockInfo(24, 0, 127), LockInfo(0, 0, 0) }, 4, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 115, Shiny::Never, 35, std::array<LockInfo, 5> { LockInfo(0, 2, 255), LockInfo(18, 1, 127), LockInfo(12, 2, 255) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 354, Shiny::Never, 37, std::array<LockInfo, 5> { LockInfo(0, 2, 255), LockInfo(18, 1, 127), LockInfo(12, 2, 255), LockInfo(0, 0, 0) }, 4, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 126, Shiny::Never, 36, std::array<LockInfo, 5> { LockInfo(18, 0, 127), LockInfo(18, 0, 191), LockInfo(0, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 127, Shiny::Never, 35, std::array<LockInfo, 5> { LockInfo(18, 0, 127), LockInfo(18, 0, 191), LockInfo(0, 1, 127), LockInfo(0, 0, 0) }, 4, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 78, Shiny::Never, 40, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(6, 0, 127), LockInfo(12, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 219, Shiny::Never, 38, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(6, 0, 127), LockInfo(12, 1, 127), LockInfo(0, 0, 0) }, 4, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 107, Shiny::Never, 38, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(6, 1, 127), LockInfo(18, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 106, Shiny::Never, 38, std::array<LockInfo, 5> { LockInfo(18, 0, 127), LockInfo(12, 1, 127), LockInfo(6, 2, 255), LockInfo(24, 1, 63) }, 4, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 108, Shiny::Never, 38, std::array<LockInfo, 5> { LockInfo(24, 0, 127), LockInfo(6, 2, 255) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 123, Shiny::Never, 40, std::array<LockInfo, 5> { LockInfo(6, 1, 127), LockInfo(24, 0, 127) }, 2, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 113, Shiny::Never, 39, std::array<LockInfo, 5> { LockInfo(6, 1, 127), LockInfo(24, 0, 127), LockInfo(0, 0, 0) }, 3, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 338, Shiny::Never, 41, std::array<LockInfo, 5> { LockInfo(24, 2, 255), LockInfo(6, 0, 127), LockInfo(0, 1, 127) }, 3, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 121, Shiny::Never, 41, std::array<LockInfo, 5> { LockInfo(24, 2, 255), LockInfo(6, 0, 127), LockInfo(0, 1, 127), LockInfo(0, 0, 0), LockInfo(18, 0, 127) }, 5, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 125, Shiny::Never, 43, std::array<LockInfo, 5> { LockInfo(0, 0, 0), LockInfo(24, 0, 63), LockInfo(6, 1, 127), LockInfo(18, 1, 127) }, 4, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 143, Shiny::Never, 43, std::array<LockInfo, 5> { LockInfo(0, 0, 0), LockInfo(24, 0, 63), LockInfo(6, 1, 127), LockInfo(18, 1, 127), LockInfo(0, 0, 0) }, 5, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 62, Shiny::Never, 42, std::array<LockInfo, 5> { LockInfo(18, 0, 127), LockInfo(18, 0, 127), LockInfo(24, 0, 127), LockInfo(6, 1, 127) }, 4, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 122, Shiny::Never, 42, std::array<LockInfo, 5> { LockInfo(18, 0, 127), LockInfo(18, 0, 127), LockInfo(24, 0, 127), LockInfo(6, 1, 127), LockInfo(0, 0, 0) }, 5, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 51, Shiny::Never, 40, std::array<LockInfo, 5> { LockInfo(0, 0, 127), LockInfo(18, 0, 127), LockInfo(6, 1, 127), LockInfo(12, 0, 127) }, 4, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 310, Shiny::Never, 44, std::array<LockInfo, 5> { LockInfo(6, 1, 127) }, 1, ShadowType::SingleLock), ShadowTemplate(Game::Gales, 373, Shiny::Never, 50, std::array<LockInfo, 5> { LockInfo(6, 1, 127), LockInfo(0, 0, 0) }, 2, ShadowType::Salamence), ShadowTemplate(Game::Gales, 105, Shiny::Never, 44, std::array<LockInfo, 5> { LockInfo(6, 1, 127), LockInfo(0, 0, 0), LockInfo(0, 0, 0), LockInfo(24, 0, 127) }, 4, ShadowType::FirstShadow), ShadowTemplate(Game::Gales, 131, Shiny::Never, 44, std::array<LockInfo, 5> { LockInfo(6, 1, 127), LockInfo(0, 0, 0), LockInfo(0, 0, 0), LockInfo(24, 0, 127), LockInfo(0, 0, 0) }, 5, ShadowType::SecondShadow), ShadowTemplate(Game::Gales, 149, Shiny::Never, 55, std::array<LockInfo, 5> { LockInfo(0, 0, 127), LockInfo(18, 0, 127), LockInfo(12, 1, 127), LockInfo(12, 1, 127), LockInfo(0, 0, 127) }, 5, ShadowType::FirstShadow) };

constexpr std::array<StaticTemplate3, 1> CHANNEL = { StaticTemplate3(Game::GC, 385, 0, Shiny::Random, 5) };

constexpr std::array<u8, 2102> EMERALD = { 4, 45, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 42, 159, 199, 30, 0, 1, 144, 255, 223, 255, 255, 255, 255, 255, 255, 255, 245, 254, 255, 255, 255, 255, 235, 253, 200, 180, 0, 10, 144, 56, 129, 152, 28, 163, 81, 204, 152, 32, 0, 96, 8, 223, 108, 204, 203, 86, 49, 64, 58, 234, 40, 235, 212, 148, 81, 32, 0, 37, 77, 18, 12, 154, 163, 96, 167, 148, 253, 83, 209, 146, 120, 141, 35, 208, 143, 40, 245, 15, 80, 211, 16, 122, 134, 128, 245, 52, 105, 225, 64, 0, 6, 128, 1, 163, 64, 0, 6, 211, 213, 6, 66, 4, 4, 26, 79, 37, 60, 154, 101, 61, 35, 76, 20, 104, 3, 70, 134, 67, 64, 0, 1, 161, 160, 26, 3, 212, 13, 0, 0, 1, 145, 166, 212, 1, 85, 30, 9, 52, 211, 70, 128, 211, 70, 76, 19, 77, 26, 104, 196, 194, 96, 76, 16, 192, 134, 153, 25, 50, 50, 12, 16, 98, 12, 140, 65, 145, 128, 4, 208, 96, 73, 170, 72, 163, 67, 64, 52, 104, 0, 0, 6, 67, 16, 26, 0, 0, 0, 3, 212, 52, 0, 13, 0, 0, 0, 0, 0, 32, 196, 97, 25, 12, 4, 193, 50, 49, 48, 76, 2, 24, 0, 140, 1, 48, 152, 154, 24, 77, 12, 152, 33, 132, 97, 24, 33, 161, 147, 35, 38, 1, 18, 68, 209, 52, 137, 161, 77, 233, 39, 180, 141, 64, 195, 64, 140, 140, 19, 16, 50, 122, 158, 137, 128, 35, 0, 52, 128, 100, 209, 160, 211, 38, 152, 17, 234, 96, 141, 52, 196, 244, 157, 3, 181, 54, 76, 200, 113, 227, 121, 8, 134, 77, 144, 121, 48, 36, 100, 190, 167, 214, 133, 18, 214, 198, 125, 141, 153, 173, 140, 67, 18, 39, 6, 65, 0, 8, 81, 18, 117, 12, 104, 14, 10, 68, 175, 92, 48, 225, 75, 49, 107, 108, 97, 122, 110, 11, 39, 141, 193, 32, 95, 74, 49, 48, 226, 99, 85, 212, 73, 20, 41, 66, 165, 162, 132, 64, 82, 129, 225, 46, 218, 195, 183, 163, 106, 221, 171, 118, 238, 74, 167, 171, 175, 183, 220, 110, 178, 114, 178, 245, 251, 90, 20, 104, 101, 78, 150, 205, 145, 138, 11, 16, 154, 225, 81, 120, 149, 96, 146, 145, 89, 22, 104, 226, 137, 24, 238, 114, 50, 221, 225, 72, 112, 168, 144, 216, 117, 59, 51, 52, 35, 165, 181, 149, 123, 240, 181, 54, 26, 155, 196, 30, 196, 193, 70, 116, 117, 220, 95, 80, 64, 218, 17, 26, 73, 224, 160, 31, 201, 26, 171, 97, 215, 240, 218, 28, 171, 182, 248, 170, 206, 166, 190, 63, 26, 18, 222, 240, 231, 16, 128, 188, 6, 252, 132, 101, 39, 75, 80, 146, 68, 40, 203, 115, 128, 119, 37, 6, 158, 92, 121, 1, 194, 135, 156, 79, 199, 161, 149, 121, 84, 231, 192, 13, 132, 9, 231, 15, 230, 51, 122, 229, 133, 56, 194, 26, 180, 54, 46, 84, 245, 105, 84, 85, 225, 6, 116, 98, 193, 99, 104, 232, 233, 146, 198, 12, 38, 234, 97, 139, 131, 153, 8, 35, 180, 86, 108, 209, 28, 26, 226, 14, 31, 66, 145, 74, 235, 203, 252, 116, 155, 7, 78, 219, 166, 9, 150, 108, 55, 180, 144, 200, 161, 245, 7, 157, 241, 105, 60, 61, 39, 215, 50, 19, 199, 233, 115, 4, 85, 249, 36, 81, 37, 15, 174, 176, 194, 186, 228, 31, 76, 166, 175, 184, 91, 223, 158, 157, 221, 114, 65, 172, 160, 19, 14, 104, 81, 203, 112, 227, 2, 79, 213, 85, 135, 72, 165, 43, 8, 177, 251, 225, 15, 116, 224, 27, 235, 167, 178, 251, 123, 57, 94, 217, 153, 169, 36, 248, 103, 27, 110, 27, 247, 142, 12, 184, 210, 219, 109, 129, 134, 21, 64, 170, 84, 17, 250, 126, 189, 14, 131, 203, 193, 102, 233, 126, 253, 30, 149, 29, 164, 129, 152, 230, 208, 201, 173, 127, 195, 111, 32, 0, 193, 2, 113, 243, 228, 125, 58, 47, 26, 124, 15, 144, 203, 60, 97, 227, 240, 28, 147, 87, 1, 74, 192, 32, 16, 72, 73, 170, 149, 122, 246, 204, 51, 77, 202, 63, 123, 52, 153, 126, 144, 150, 180, 39, 171, 171, 204, 138, 145, 116, 144, 80, 190, 193, 82, 190, 254, 68, 136, 208, 219, 65, 68, 103, 248, 164, 130, 56, 129, 132, 203, 233, 244, 234, 185, 166, 201, 172, 22, 63, 60, 158, 255, 46, 105, 20, 236, 206, 227, 52, 49, 59, 145, 213, 37, 87, 51, 225, 102, 68, 180, 231, 11, 188, 56, 238, 121, 201, 57, 67, 26, 69, 142, 43, 190, 164, 240, 30, 28, 113, 181, 145, 41, 225, 81, 198, 24, 103, 154, 148, 21, 82, 121, 196, 208, 148, 149, 40, 80, 248, 69, 123, 121, 202, 154, 151, 136, 128, 114, 192, 174, 128, 132, 209, 90, 189, 69, 239, 48, 221, 214, 9, 95, 81, 212, 216, 49, 178, 48, 85, 22, 139, 243, 189, 240, 8, 30, 40, 126, 125, 50, 109, 113, 194, 168, 128, 91, 87, 66, 107, 162, 238, 168, 108, 215, 68, 173, 134, 219, 217, 104, 82, 176, 13, 127, 135, 128, 83, 77, 65, 87, 46, 73, 82, 66, 211, 74, 56, 95, 42, 61, 40, 70, 19, 8, 196, 197, 136, 140, 72, 209, 72, 173, 81, 53, 185, 197, 38, 220, 23, 1, 17, 76, 104, 107, 56, 106, 4, 9, 179, 161, 136, 7, 190, 42, 177, 26, 7, 129, 215, 223, 99, 192, 214, 217, 164, 222, 21, 121, 55, 103, 183, 58, 97, 179, 131, 145, 0, 218, 174, 161, 76, 118, 225, 168, 203, 90, 144, 78, 214, 206, 152, 228, 220, 156, 200, 88, 46, 26, 11, 245, 107, 216, 59, 102, 250, 21, 17, 64, 131, 22, 36, 207, 147, 40, 158, 124, 39, 112, 230, 80, 130, 208, 36, 114, 11, 5, 130, 144, 43, 193, 96, 16, 17, 126, 50, 174, 8, 85, 209, 136, 212, 104, 80, 104, 50, 114, 62, 49, 139, 32, 81, 32, 225, 64, 122, 185, 241, 162, 78, 210, 52, 115, 121, 219, 88, 228, 35, 173, 170, 195, 61, 66, 160, 193, 88, 184, 70, 172, 42, 49, 101, 196, 213, 90, 54, 179, 14, 0, 156, 77, 50, 43, 165, 136, 101, 21, 101, 197, 20, 230, 112, 242, 195, 6, 107, 212, 170, 225, 152, 9, 192, 64, 247, 233, 91, 248, 48, 53, 250, 69, 243, 78, 42, 234, 102, 106, 248, 251, 156, 123, 115, 111, 111, 111, 112, 125, 171, 174, 168, 113, 115, 110, 141, 85, 101, 101, 100, 68, 64, 164, 32, 185, 199, 113, 237, 196, 120, 104, 108, 50, 196, 34, 107, 55, 23, 101, 116, 70, 18, 92, 135, 162, 33, 4, 153, 240, 72, 57, 14, 93, 84, 101, 115, 139, 135, 2, 208, 140, 174, 80, 225, 7, 99, 70, 10, 133, 84, 4, 160, 42, 178, 173, 42, 31, 243, 50, 200, 227, 75, 20, 105, 98, 204, 0, 67, 179, 98, 140, 40, 59, 62, 39, 133, 131, 24, 176, 97, 209, 201, 12, 10, 4, 29, 134, 0, 9, 132, 124, 1, 0, 3, 196, 20, 49, 176, 7, 197, 35, 15, 19, 229, 67, 247, 73, 187, 170, 166, 221, 116, 97, 20, 85, 68, 81, 30, 120, 72, 191, 51, 138, 218, 217, 7, 13, 224, 106, 114, 57, 46, 231, 207, 166, 135, 224, 185, 80, 231, 234, 252, 95, 199, 227, 223, 228, 232, 0, 116, 33, 254, 14, 114, 63, 8, 126, 199, 105, 191, 205, 208, 126, 67, 160, 223, 193, 112, 184, 46, 28, 59, 243, 1, 40, 74, 200, 62, 68, 72, 46, 251, 10, 4, 243, 13, 120, 7, 129, 24, 162, 131, 8, 238, 198, 231, 195, 161, 198, 197, 93, 243, 124, 94, 121, 5, 227, 1, 198, 104, 249, 142, 248, 15, 245, 1, 28, 238, 131, 88, 3, 14, 196, 222, 145, 224, 96, 71, 123, 118, 190, 206, 84, 28, 243, 105, 206, 220, 1, 130, 239, 27, 128, 122, 129, 186, 230, 112, 204, 199, 111, 94, 78, 194, 115, 135, 117, 137, 255, 154, 229, 216, 238, 74, 255, 185, 55, 60, 28, 239, 152, 78, 101, 225, 164, 37, 214, 187, 80, 86, 9, 54, 1, 96, 22, 24, 204, 102, 188, 21, 166, 158, 19, 25, 130, 206, 211, 161, 10, 229, 4, 178, 160, 165, 190, 94, 240, 28, 72, 9, 58, 223, 143, 152, 90, 93, 32, 242, 252, 123, 22, 131, 0, 58, 228, 59, 60, 146, 139, 240, 173, 107, 133, 93, 92, 164, 1, 207, 192, 16, 46, 32, 64, 129, 222, 213, 32, 4, 142, 74, 101, 24, 185, 114, 108, 218, 48, 137, 0, 45, 64, 82, 194, 7, 97, 60, 38, 90, 69, 20, 12, 158, 227, 150, 107, 127, 159, 187, 94, 246, 157, 157, 142, 238, 196, 142, 29, 139, 159, 7, 229, 203, 2, 181, 134, 3, 1, 4, 69, 32, 130, 99, 240, 125, 127, 159, 163, 249, 254, 246, 106, 35, 195, 230, 170, 253, 40, 170, 157, 37, 52, 168, 102, 68, 44, 59, 137, 141, 180, 160, 128, 223, 70, 128, 168, 193, 6, 10, 32, 136, 82, 181, 69, 66, 196, 36, 8, 249, 116, 25, 88, 51, 0, 50, 24, 16, 151, 180, 97, 36, 96, 69, 189, 43, 10, 40, 202, 48, 160, 209, 148, 41, 186, 203, 214, 217, 94, 108, 236, 229, 105, 101, 17, 16, 98, 67, 233, 78, 94, 219, 157, 196, 208, 93, 216, 177, 254, 177, 127, 179, 146, 90, 90, 92, 152, 64, 170, 72, 136, 8, 160, 53, 87, 10, 234, 42, 249, 20, 84, 36, 140, 33, 32, 6, 248, 175, 4, 165, 120, 130, 183, 42, 66, 16, 204, 87, 37, 95, 163, 113, 188, 140, 8, 30, 109, 181, 65, 226, 65, 228, 67, 35, 1, 35, 33, 57, 126, 173, 5, 72, 48, 69, 16, 70, 42, 78, 29, 238, 243, 11, 88, 174, 16, 17, 146, 44, 137, 100, 32, 26, 132, 81, 171, 3, 2, 17, 128, 66, 66, 107, 149, 150, 193, 0, 140, 88, 36, 82, 22, 133, 4, 72, 196, 32, 74, 162, 162, 145, 32, 228, 192, 8, 85, 172, 38, 216, 22, 129, 8, 21, 41, 144, 140, 85, 132, 0, 128, 168, 3, 2, 8, 12, 98, 35, 0, 17, 34, 73, 21, 73, 34, 128, 192, 140, 8, 140, 22, 232, 45, 200, 0, 208, 149, 11, 50, 17, 42, 5, 48, 72, 192, 202, 169, 8, 192, 44, 144, 26, 8, 200, 66, 34, 149, 73, 76, 32, 145, 68, 128, 65, 72, 146, 3, 8, 82, 131, 246, 229, 172, 85, 74, 34, 145, 8, 132, 66, 20, 164, 164, 131, 32, 130, 140, 16, 85, 130, 130, 178, 50, 74, 137, 82, 20, 65, 24, 130, 149, 0, 8, 200, 48, 160, 140, 65, 120, 114, 49, 13, 32, 1, 36, 140, 98, 14, 103, 14, 140, 70, 36, 17, 226, 108, 160, 45, 35, 26, 149, 10, 148, 72, 130, 68, 26, 138, 155, 34, 200, 140, 138, 75, 85, 48, 36, 53, 52, 33, 86, 177, 72, 195, 12, 207, 35, 67, 24, 76, 43, 132, 96, 41, 20, 194, 48, 89, 9, 130, 65, 146, 53, 6, 137, 8, 86, 5, 107, 36, 76, 105, 64, 19, 96, 129, 162, 1, 103, 84, 145, 100, 8, 193, 132, 179, 139, 33, 149, 105, 121, 87, 12, 7, 103, 169, 56, 185, 176, 145, 201, 47, 159, 22, 201, 141, 194, 246, 118, 101, 72, 110, 65, 88, 64, 13, 2, 23, 8, 185, 4, 2, 244, 26, 128, 92, 13, 129, 160, 101, 128, 192, 22, 11, 88, 179, 129, 195, 135, 14, 12, 50, 32, 71, 232, 110, 27, 151, 74, 138, 4, 131, 148, 93, 176, 4, 190, 148, 19, 42, 57, 134, 194, 139, 27, 67, 104, 85, 155, 57, 163, 117, 98, 67, 59, 71, 97, 73, 140, 29, 160, 33, 186, 65, 52, 211, 20, 128, 208, 105, 121, 149, 183, 173, 88, 215, 90, 134, 193, 44, 65, 54, 92, 104, 44, 49, 115, 204, 204, 101, 151, 40, 45, 111, 98, 229, 192, 133, 216, 80, 167, 255, 23, 114, 69, 56, 80, 144, 42, 159, 199, 30 };

constexpr std::array<u8, 2584> FIRERED = { 246, 54, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 245, 110, 206, 21, 0, 1, 127, 127, 255, 255, 255, 255, 255, 255, 255, 255, 246, 249, 255, 255, 255, 255, 251, 255, 250, 124, 64, 76, 64, 98, 192, 96, 72, 113, 113, 73, 92, 40, 128, 1, 0, 96, 9, 191, 54, 229, 157, 247, 114, 37, 208, 214, 244, 195, 148, 34, 109, 20, 243, 96, 0, 0, 74, 34, 32, 155, 70, 131, 84, 217, 51, 83, 32, 212, 244, 198, 137, 160, 70, 83, 218, 2, 79, 67, 83, 212, 211, 39, 169, 145, 234, 100, 105, 132, 104, 194, 50, 109, 38, 129, 136, 52, 105, 160, 26, 1, 234, 13, 168, 53, 52, 64, 53, 50, 100, 242, 10, 120, 144, 200, 244, 76, 41, 230, 166, 154, 65, 26, 121, 61, 70, 163, 77, 52, 0, 1, 233, 0, 25, 13, 50, 61, 65, 163, 32, 100, 104, 0, 0, 0, 106, 154, 53, 54, 154, 77, 77, 60, 160, 0, 6, 128, 26, 52, 0, 26, 0, 0, 1, 160, 52, 0, 0, 0, 0, 0, 104, 0, 0, 2, 12, 2, 26, 49, 52, 6, 77, 48, 153, 52, 200, 0, 194, 52, 105, 128, 76, 1, 48, 131, 67, 32, 98, 100, 1, 128, 0, 76, 76, 152, 9, 128, 154, 6, 74, 40, 208, 0, 3, 64, 0, 50, 1, 234, 0, 26, 0, 0, 0, 208, 0, 0, 0, 6, 128, 0, 0, 49, 0, 0, 137, 34, 38, 74, 108, 37, 24, 210, 100, 155, 81, 141, 77, 136, 17, 128, 153, 161, 52, 61, 9, 145, 145, 143, 81, 24, 134, 65, 129, 50, 52, 201, 154, 65, 144, 104, 13, 24, 77, 3, 70, 53, 240, 132, 204, 202, 81, 68, 161, 199, 45, 59, 153, 232, 196, 154, 41, 109, 51, 11, 244, 156, 56, 156, 244, 87, 143, 20, 36, 225, 114, 249, 82, 252, 82, 117, 221, 183, 27, 113, 122, 188, 7, 229, 198, 195, 207, 46, 178, 17, 36, 41, 14, 30, 11, 181, 109, 81, 85, 121, 181, 196, 143, 153, 251, 186, 207, 205, 145, 13, 72, 24, 207, 167, 106, 154, 172, 77, 111, 2, 96, 216, 68, 230, 49, 129, 128, 22, 1, 3, 25, 20, 71, 24, 197, 17, 17, 21, 125, 254, 207, 110, 215, 111, 119, 119, 119, 185, 221, 168, 64, 118, 123, 94, 166, 231, 59, 159, 185, 185, 221, 243, 229, 104, 221, 166, 208, 152, 14, 205, 199, 148, 24, 24, 34, 19, 76, 141, 210, 81, 48, 84, 195, 40, 4, 202, 117, 14, 216, 34, 200, 121, 238, 0, 0, 65, 83, 81, 157, 178, 205, 106, 86, 29, 139, 186, 93, 21, 149, 93, 69, 136, 131, 165, 67, 70, 231, 114, 169, 94, 200, 154, 136, 16, 48, 195, 225, 67, 54, 16, 85, 218, 69, 4, 80, 24, 196, 35, 189, 97, 7, 51, 75, 153, 196, 124, 235, 250, 132, 207, 28, 249, 254, 88, 48, 169, 64, 71, 155, 2, 180, 193, 74, 195, 188, 206, 128, 137, 138, 113, 167, 236, 234, 80, 158, 88, 53, 193, 210, 139, 192, 145, 165, 169, 192, 204, 162, 70, 146, 66, 49, 12, 226, 145, 221, 114, 4, 13, 195, 16, 15, 132, 144, 233, 14, 136, 108, 55, 10, 67, 250, 156, 185, 106, 74, 195, 171, 224, 34, 34, 72, 102, 56, 12, 66, 168, 127, 118, 67, 166, 251, 127, 21, 73, 230, 74, 55, 136, 13, 115, 95, 255, 138, 204, 89, 108, 173, 211, 244, 144, 229, 6, 143, 241, 203, 54, 156, 145, 230, 169, 184, 148, 171, 206, 59, 152, 66, 44, 98, 68, 5, 9, 25, 32, 184, 130, 169, 36, 168, 72, 84, 174, 135, 140, 102, 139, 40, 163, 20, 144, 81, 136, 154, 153, 155, 43, 44, 34, 4, 160, 64, 112, 76, 105, 152, 234, 231, 38, 221, 190, 87, 161, 234, 196, 195, 109, 193, 188, 188, 254, 21, 172, 134, 100, 213, 111, 184, 238, 130, 196, 12, 130, 207, 0, 68, 66, 236, 200, 29, 18, 163, 64, 140, 31, 126, 37, 115, 162, 181, 168, 181, 121, 167, 12, 8, 218, 73, 150, 72, 60, 99, 100, 16, 34, 20, 40, 225, 30, 20, 166, 48, 254, 164, 177, 211, 152, 214, 117, 88, 101, 224, 3, 191, 163, 168, 193, 140, 177, 135, 202, 124, 103, 96, 153, 64, 193, 62, 230, 247, 144, 81, 31, 5, 250, 79, 204, 168, 176, 194, 207, 28, 57, 180, 229, 83, 187, 84, 164, 149, 48, 80, 62, 56, 204, 18, 178, 149, 148, 27, 60, 201, 40, 68, 58, 163, 227, 31, 92, 89, 186, 218, 170, 229, 116, 84, 52, 230, 176, 156, 186, 234, 106, 22, 54, 77, 145, 11, 160, 183, 218, 193, 17, 160, 216, 214, 109, 223, 179, 163, 143, 111, 70, 37, 209, 144, 235, 26, 173, 70, 244, 76, 254, 143, 33, 206, 151, 181, 211, 99, 79, 101, 100, 202, 198, 134, 26, 102, 25, 117, 34, 136, 51, 45, 10, 157, 47, 71, 205, 215, 157, 70, 227, 79, 163, 62, 131, 2, 200, 87, 104, 150, 86, 180, 20, 11, 144, 110, 228, 144, 132, 195, 217, 128, 73, 59, 199, 39, 158, 163, 252, 180, 54, 22, 21, 123, 182, 61, 241, 119, 184, 27, 173, 253, 108, 144, 145, 166, 216, 59, 154, 182, 173, 46, 20, 142, 207, 158, 175, 144, 155, 149, 208, 123, 226, 216, 8, 3, 13, 135, 249, 84, 1, 129, 139, 18, 161, 66, 93, 10, 220, 92, 58, 101, 183, 101, 43, 49, 31, 151, 226, 194, 126, 191, 81, 159, 108, 41, 189, 144, 243, 167, 3, 79, 121, 16, 212, 47, 254, 8, 137, 228, 13, 96, 124, 21, 60, 33, 75, 162, 239, 142, 251, 251, 110, 176, 143, 194, 132, 104, 52, 57, 182, 67, 163, 171, 2, 11, 120, 175, 105, 42, 100, 17, 172, 131, 177, 91, 116, 89, 6, 0, 54, 78, 13, 114, 64, 238, 20, 40, 184, 149, 6, 204, 175, 39, 134, 146, 143, 188, 246, 239, 99, 215, 156, 146, 31, 24, 79, 240, 141, 76, 185, 254, 155, 230, 190, 171, 161, 67, 187, 1, 180, 229, 25, 68, 196, 181, 71, 147, 69, 122, 147, 9, 156, 72, 111, 43, 116, 38, 231, 175, 9, 226, 124, 208, 116, 170, 147, 140, 216, 211, 178, 136, 254, 93, 252, 0, 123, 148, 34, 119, 187, 138, 2, 169, 146, 48, 28, 16, 97, 12, 13, 220, 22, 146, 195, 3, 148, 85, 199, 149, 125, 138, 158, 23, 35, 250, 92, 186, 193, 208, 112, 189, 205, 231, 230, 89, 242, 57, 141, 223, 79, 18, 196, 38, 235, 8, 154, 31, 124, 146, 66, 71, 186, 16, 208, 68, 8, 99, 52, 212, 168, 86, 29, 133, 228, 148, 142, 38, 57, 215, 151, 140, 164, 177, 2, 84, 66, 90, 41, 50, 49, 35, 173, 4, 24, 86, 106, 237, 237, 220, 167, 42, 252, 199, 202, 19, 109, 130, 162, 40, 134, 251, 63, 128, 94, 42, 41, 23, 125, 4, 137, 25, 33, 26, 76, 198, 9, 205, 128, 25, 144, 120, 48, 77, 34, 236, 56, 252, 99, 230, 28, 77, 43, 144, 17, 35, 139, 228, 16, 28, 66, 31, 180, 143, 221, 37, 56, 58, 45, 68, 115, 55, 158, 112, 99, 16, 21, 166, 89, 113, 162, 28, 188, 20, 234, 24, 17, 161, 54, 99, 179, 109, 244, 58, 139, 181, 180, 244, 55, 112, 11, 115, 131, 153, 27, 15, 64, 197, 156, 219, 107, 178, 113, 81, 163, 249, 163, 44, 150, 226, 150, 44, 93, 27, 139, 11, 245, 156, 51, 123, 139, 227, 244, 28, 156, 47, 61, 90, 194, 142, 81, 228, 57, 57, 227, 151, 26, 166, 113, 253, 218, 134, 195, 154, 109, 70, 232, 29, 12, 238, 169, 180, 118, 188, 236, 3, 1, 85, 140, 177, 93, 239, 23, 96, 38, 107, 170, 175, 89, 157, 118, 244, 220, 156, 89, 202, 216, 56, 183, 29, 116, 201, 56, 149, 33, 183, 198, 95, 175, 129, 5, 224, 44, 29, 82, 189, 166, 12, 58, 165, 138, 137, 10, 244, 159, 208, 90, 161, 63, 12, 228, 105, 23, 107, 231, 216, 30, 196, 169, 204, 69, 87, 187, 12, 122, 92, 122, 211, 254, 152, 122, 227, 249, 124, 148, 170, 35, 82, 2, 130, 254, 215, 196, 191, 26, 254, 201, 81, 16, 38, 104, 28, 226, 23, 52, 111, 154, 67, 7, 12, 174, 226, 154, 16, 214, 130, 145, 13, 58, 83, 152, 50, 12, 161, 218, 180, 204, 202, 249, 89, 123, 153, 146, 95, 85, 252, 17, 162, 59, 32, 29, 4, 44, 178, 188, 234, 2, 49, 29, 225, 194, 96, 54, 28, 195, 218, 120, 45, 180, 231, 32, 40, 215, 0, 24, 74, 198, 206, 251, 185, 111, 112, 101, 204, 243, 173, 130, 36, 130, 88, 202, 13, 185, 116, 133, 228, 16, 108, 68, 28, 125, 60, 49, 16, 17, 32, 132, 46, 4, 77, 124, 210, 142, 153, 22, 105, 240, 97, 169, 15, 175, 165, 67, 8, 173, 172, 162, 133, 19, 180, 63, 65, 70, 12, 26, 56, 86, 205, 175, 78, 222, 194, 101, 85, 182, 67, 29, 29, 157, 142, 73, 206, 198, 34, 116, 245, 175, 123, 202, 21, 202, 205, 109, 190, 29, 16, 131, 149, 233, 238, 106, 107, 116, 118, 181, 177, 229, 200, 114, 246, 183, 250, 119, 70, 223, 111, 185, 123, 49, 22, 28, 18, 142, 230, 203, 57, 200, 113, 15, 183, 110, 145, 83, 180, 126, 20, 209, 69, 26, 92, 88, 74, 138, 72, 157, 117, 215, 182, 158, 155, 118, 176, 115, 182, 211, 156, 89, 239, 30, 40, 108, 211, 138, 138, 165, 202, 121, 144, 142, 105, 208, 43, 183, 176, 17, 94, 177, 136, 16, 218, 215, 4, 92, 101, 76, 187, 209, 90, 215, 8, 198, 145, 144, 184, 135, 230, 106, 232, 32, 79, 93, 9, 57, 80, 37, 150, 141, 184, 101, 158, 150, 231, 66, 28, 20, 157, 161, 193, 109, 150, 5, 82, 58, 26, 68, 15, 20, 139, 164, 177, 163, 169, 37, 231, 37, 184, 8, 132, 152, 207, 44, 140, 237, 89, 246, 49, 117, 153, 24, 81, 69, 119, 204, 143, 30, 91, 164, 148, 101, 102, 13, 60, 104, 75, 159, 65, 140, 128, 124, 209, 6, 193, 9, 155, 84, 193, 49, 91, 88, 105, 88, 35, 13, 20, 116, 214, 52, 154, 56, 71, 218, 144, 56, 216, 202, 42, 194, 68, 61, 3, 228, 36, 169, 138, 148, 168, 98, 63, 69, 104, 114, 44, 148, 166, 200, 118, 130, 216, 58, 224, 197, 115, 69, 44, 105, 93, 211, 69, 193, 102, 106, 95, 28, 167, 109, 162, 123, 121, 5, 188, 107, 26, 111, 220, 16, 8, 95, 169, 108, 90, 89, 218, 106, 210, 148, 167, 234, 109, 178, 9, 7, 7, 195, 35, 0, 180, 171, 159, 103, 45, 52, 26, 113, 145, 114, 79, 157, 28, 220, 87, 49, 114, 239, 165, 182, 18, 51, 25, 214, 159, 232, 120, 55, 228, 81, 210, 155, 119, 65, 144, 70, 68, 144, 89, 0, 132, 7, 151, 189, 189, 189, 196, 207, 100, 202, 183, 92, 89, 38, 156, 20, 72, 50, 204, 56, 2, 190, 45, 179, 36, 81, 163, 237, 24, 98, 48, 44, 164, 114, 108, 218, 118, 170, 152, 25, 47, 71, 175, 127, 123, 143, 217, 117, 56, 242, 60, 142, 102, 224, 155, 251, 41, 30, 173, 3, 183, 8, 116, 48, 177, 48, 151, 44, 173, 190, 133, 3, 94, 103, 31, 151, 191, 214, 252, 221, 10, 11, 163, 131, 157, 248, 196, 30, 66, 145, 75, 139, 97, 41, 32, 94, 149, 110, 94, 2, 208, 137, 6, 12, 0, 106, 128, 26, 141, 139, 194, 170, 177, 7, 30, 167, 70, 117, 60, 28, 222, 20, 21, 47, 230, 61, 243, 241, 54, 40, 108, 94, 225, 199, 65, 45, 229, 220, 185, 110, 198, 68, 86, 164, 222, 213, 185, 199, 202, 203, 198, 211, 144, 34, 12, 221, 24, 131, 95, 70, 129, 90, 233, 129, 37, 42, 243, 241, 70, 186, 170, 5, 247, 237, 123, 42, 3, 4, 78, 148, 32, 42, 114, 130, 35, 100, 64, 190, 109, 8, 41, 86, 161, 73, 16, 121, 129, 1, 4, 170, 168, 4, 46, 92, 16, 18, 128, 132, 36, 5, 44, 60, 236, 153, 249, 90, 99, 54, 185, 212, 181, 104, 214, 185, 244, 146, 26, 160, 38, 169, 14, 203, 124, 8, 37, 248, 173, 52, 177, 27, 112, 101, 88, 183, 204, 214, 191, 97, 117, 143, 155, 206, 221, 130, 242, 0, 1, 16, 130, 66, 33, 33, 22, 36, 139, 126, 159, 15, 189, 249, 237, 239, 224, 8, 32, 202, 123, 73, 158, 72, 233, 234, 112, 69, 55, 157, 231, 142, 239, 103, 99, 191, 37, 191, 204, 191, 251, 49, 63, 199, 32, 62, 23, 79, 1, 199, 103, 197, 150, 207, 254, 252, 70, 228, 195, 227, 83, 136, 244, 95, 42, 145, 16, 223, 136, 148, 168, 119, 2, 68, 225, 4, 86, 136, 163, 97, 3, 204, 128, 227, 16, 122, 216, 33, 110, 251, 69, 136, 132, 5, 47, 4, 28, 68, 179, 5, 131, 113, 129, 97, 75, 196, 82, 116, 133, 3, 162, 2, 203, 160, 148, 13, 226, 160, 20, 32, 97, 58, 225, 162, 165, 132, 75, 197, 36, 25, 5, 102, 45, 0, 142, 0, 94, 132, 92, 162, 3, 132, 4, 10, 236, 169, 106, 43, 81, 88, 197, 2, 162, 50, 42, 204, 90, 70, 162, 175, 0, 170, 23, 156, 176, 52, 192, 66, 65, 76, 161, 225, 249, 42, 208, 88, 129, 213, 9, 7, 201, 161, 41, 76, 12, 2, 24, 211, 25, 0, 145, 145, 97, 36, 144, 144, 145, 77, 133, 240, 218, 36, 40, 114, 155, 117, 237, 182, 216, 166, 89, 17, 166, 177, 169, 133, 25, 196, 248, 200, 46, 141, 214, 133, 53, 2, 192, 53, 41, 1, 44, 64, 75, 193, 9, 142, 227, 97, 140, 132, 33, 33, 9, 136, 186, 197, 162, 197, 132, 214, 46, 224, 178, 161, 2, 46, 57, 26, 145, 107, 20, 127, 35, 108, 66, 198, 97, 17, 184, 193, 114, 28, 7, 93, 133, 188, 211, 174, 245, 91, 38, 157, 90, 194, 132, 210, 186, 52, 229, 90, 48, 204, 82, 64, 2, 58, 138, 42, 36, 34, 147, 61, 219, 42, 88, 215, 64, 84, 37, 240, 39, 1, 101, 174, 8, 84, 64, 170, 165, 36, 73, 114, 139, 96, 1, 10, 89, 27, 196, 33, 16, 151, 9, 73, 98, 7, 2, 168, 144, 133, 229, 18, 11, 33, 48, 4, 12, 81, 136, 66, 136, 132, 128, 152, 89, 82, 214, 25, 129, 12, 9, 2, 155, 170, 153, 242, 80, 211, 4, 50, 130, 23, 36, 4, 114, 118, 171, 0, 13, 89, 131, 154, 220, 46, 20, 22, 18, 12, 97, 17, 193, 37, 16, 173, 88, 218, 216, 19, 110, 139, 92, 116, 41, 1, 6, 82, 20, 21, 17, 219, 17, 45, 13, 27, 154, 172, 47, 200, 46, 228, 138, 112, 161, 33, 234, 221, 156, 42 };

constexpr std::array<u8, 2601> LEAFGREEN = { 246, 54, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 169, 185, 151, 78, 0, 1, 127, 127, 255, 255, 255, 255, 255, 255, 255, 255, 246, 251, 255, 255, 255, 255, 251, 255, 249, 252, 64, 76, 64, 98, 192, 96, 200, 96, 113, 65, 220, 144, 128, 1, 0, 96, 9, 191, 54, 230, 59, 239, 113, 38, 238, 229, 238, 109, 177, 212, 28, 135, 87, 175, 109, 125, 220, 0, 0, 13, 17, 9, 144, 141, 53, 60, 38, 154, 100, 154, 109, 24, 105, 53, 60, 38, 153, 6, 154, 158, 160, 52, 96, 67, 53, 50, 51, 66, 52, 104, 13, 61, 33, 136, 104, 13, 30, 132, 0, 0, 208, 104, 37, 77, 20, 100, 52, 48, 38, 38, 65, 61, 4, 98, 53, 39, 169, 228, 77, 61, 26, 158, 83, 211, 41, 234, 98, 105, 160, 52, 208, 13, 3, 64, 6, 38, 64, 0, 3, 212, 13, 0, 0, 13, 65, 164, 100, 1, 53, 61, 38, 166, 152, 16, 198, 147, 212, 50, 0, 208, 196, 97, 3, 16, 208, 1, 137, 136, 245, 0, 105, 160, 48, 128, 52, 194, 104, 3, 19, 70, 128, 68, 84, 104, 211, 16, 100, 104, 100, 26, 6, 131, 70, 141, 49, 1, 147, 35, 32, 97, 0, 200, 25, 24, 70, 35, 38, 64, 12, 134, 129, 137, 130, 96, 152, 152, 64, 8, 169, 169, 77, 168, 128, 26, 0, 3, 212, 7, 234, 128, 61, 64, 0, 0, 0, 209, 181, 0, 0, 0, 0, 0, 3, 70, 129, 144, 60, 161, 160, 104, 8, 146, 34, 52, 154, 104, 34, 97, 52, 52, 101, 30, 152, 35, 77, 39, 234, 71, 162, 103, 168, 128, 1, 160, 97, 24, 3, 68, 218, 16, 25, 48, 0, 152, 70, 134, 128, 200, 208, 204, 166, 174, 152, 76, 131, 57, 84, 66, 37, 99, 159, 70, 156, 176, 199, 52, 91, 76, 130, 252, 93, 244, 77, 184, 112, 224, 1, 39, 77, 201, 228, 75, 244, 228, 220, 221, 225, 105, 94, 102, 3, 213, 198, 193, 183, 168, 137, 2, 66, 50, 128, 223, 96, 175, 68, 212, 248, 245, 117, 177, 17, 216, 85, 140, 24, 108, 102, 225, 49, 168, 201, 184, 119, 225, 187, 163, 98, 221, 236, 206, 59, 149, 147, 138, 20, 160, 43, 136, 165, 2, 48, 74, 33, 6, 64, 0, 12, 234, 247, 163, 119, 53, 53, 117, 245, 117, 117, 160, 7, 98, 174, 166, 86, 94, 102, 118, 86, 94, 190, 27, 103, 210, 47, 210, 5, 120, 10, 221, 207, 32, 160, 208, 64, 105, 163, 206, 74, 218, 4, 91, 86, 195, 68, 197, 179, 104, 20, 19, 163, 231, 0, 0, 101, 183, 88, 199, 117, 220, 11, 167, 135, 206, 44, 8, 144, 243, 144, 173, 227, 155, 1, 193, 5, 139, 57, 174, 20, 135, 105, 102, 56, 138, 58, 66, 14, 198, 103, 51, 210, 64, 235, 13, 182, 19, 131, 112, 81, 75, 88, 212, 215, 27, 215, 217, 219, 44, 240, 65, 7, 251, 21, 185, 98, 30, 137, 42, 176, 141, 87, 198, 121, 2, 149, 146, 130, 51, 126, 214, 230, 212, 80, 150, 21, 65, 210, 131, 161, 35, 86, 162, 168, 70, 212, 163, 78, 33, 24, 244, 228, 7, 43, 104, 178, 219, 206, 3, 225, 210, 43, 250, 163, 99, 111, 88, 189, 204, 49, 185, 0, 220, 61, 84, 68, 74, 165, 56, 171, 169, 12, 110, 254, 212, 202, 170, 251, 250, 239, 197, 206, 221, 140, 49, 43, 75, 254, 71, 233, 25, 181, 91, 103, 104, 245, 136, 114, 3, 63, 197, 201, 54, 120, 227, 186, 166, 73, 107, 43, 245, 87, 211, 98, 201, 9, 16, 133, 30, 104, 206, 51, 42, 194, 147, 52, 177, 116, 247, 210, 169, 17, 68, 168, 138, 12, 246, 119, 62, 229, 113, 37, 67, 56, 64, 92, 11, 106, 248, 70, 166, 38, 44, 76, 188, 116, 9, 18, 57, 139, 5, 114, 39, 77, 141, 17, 28, 20, 117, 148, 158, 118, 177, 192, 75, 184, 175, 1, 17, 9, 14, 157, 42, 36, 127, 112, 140, 95, 136, 218, 162, 133, 184, 47, 69, 15, 65, 100, 69, 166, 162, 99, 148, 153, 104, 213, 16, 68, 38, 133, 99, 57, 146, 41, 71, 244, 243, 157, 57, 84, 182, 59, 126, 176, 21, 127, 90, 172, 201, 166, 154, 101, 132, 151, 77, 116, 146, 155, 12, 147, 109, 238, 243, 209, 213, 228, 210, 192, 190, 219, 26, 95, 123, 146, 11, 231, 203, 53, 125, 75, 196, 170, 158, 53, 7, 182, 218, 197, 95, 66, 250, 41, 243, 56, 186, 112, 102, 24, 131, 163, 172, 161, 237, 189, 164, 164, 91, 145, 144, 161, 96, 128, 228, 233, 24, 192, 16, 240, 65, 11, 144, 48, 69, 242, 65, 18, 64, 74, 86, 138, 205, 244, 91, 216, 76, 222, 71, 59, 213, 213, 66, 77, 36, 156, 241, 57, 26, 26, 58, 8, 72, 168, 109, 24, 181, 126, 253, 240, 179, 17, 202, 52, 96, 37, 68, 6, 89, 216, 180, 168, 185, 97, 151, 161, 153, 139, 109, 40, 89, 126, 104, 227, 167, 180, 150, 124, 238, 20, 135, 105, 158, 68, 45, 157, 78, 204, 150, 227, 139, 73, 43, 93, 255, 44, 125, 170, 162, 165, 74, 124, 13, 30, 77, 79, 141, 26, 175, 80, 94, 18, 208, 78, 232, 83, 12, 47, 214, 170, 250, 135, 30, 139, 145, 158, 35, 29, 55, 17, 113, 226, 195, 244, 91, 118, 247, 69, 127, 92, 234, 254, 52, 47, 116, 140, 30, 147, 242, 166, 148, 209, 90, 41, 241, 86, 176, 105, 129, 139, 85, 100, 11, 84, 97, 106, 189, 18, 22, 71, 162, 132, 104, 49, 114, 120, 151, 66, 172, 9, 58, 227, 141, 200, 120, 86, 59, 51, 30, 95, 32, 51, 104, 14, 86, 33, 219, 132, 53, 177, 88, 45, 101, 116, 34, 90, 9, 148, 49, 81, 128, 25, 166, 49, 218, 18, 143, 21, 89, 45, 151, 143, 50, 60, 48, 214, 201, 171, 173, 130, 120, 54, 70, 148, 174, 87, 110, 67, 139, 159, 132, 218, 143, 176, 141, 165, 67, 23, 109, 191, 1, 127, 154, 180, 235, 54, 18, 114, 229, 25, 53, 113, 213, 107, 77, 187, 50, 116, 121, 196, 59, 226, 108, 241, 178, 242, 180, 22, 225, 3, 161, 6, 218, 96, 84, 6, 227, 112, 113, 138, 159, 221, 96, 230, 138, 85, 111, 119, 166, 128, 34, 28, 81, 96, 72, 32, 129, 6, 193, 57, 32, 246, 95, 34, 11, 213, 82, 220, 84, 122, 164, 5, 88, 53, 51, 45, 0, 168, 144, 215, 54, 246, 190, 180, 26, 165, 88, 246, 6, 250, 99, 179, 196, 169, 42, 112, 169, 142, 3, 141, 138, 137, 91, 121, 176, 222, 29, 112, 45, 211, 210, 202, 180, 59, 36, 146, 80, 149, 134, 112, 199, 15, 91, 73, 2, 225, 188, 191, 230, 222, 241, 121, 187, 187, 188, 126, 14, 141, 91, 7, 209, 216, 217, 58, 212, 129, 0, 132, 58, 53, 254, 130, 125, 182, 46, 113, 129, 199, 254, 104, 196, 140, 147, 161, 166, 197, 199, 238, 71, 88, 138, 27, 221, 34, 208, 155, 39, 15, 129, 193, 59, 35, 86, 240, 193, 161, 129, 154, 68, 32, 232, 159, 148, 213, 74, 106, 67, 160, 47, 56, 222, 214, 55, 31, 56, 9, 112, 216, 69, 18, 118, 130, 202, 152, 176, 250, 29, 143, 94, 197, 106, 51, 249, 9, 137, 214, 195, 4, 37, 18, 84, 103, 196, 70, 68, 8, 142, 49, 221, 152, 181, 128, 89, 0, 113, 142, 100, 152, 26, 168, 14, 10, 95, 74, 123, 232, 241, 4, 177, 25, 100, 171, 35, 20, 233, 18, 142, 33, 129, 129, 93, 167, 0, 224, 241, 63, 15, 11, 155, 133, 230, 178, 21, 64, 152, 41, 146, 228, 194, 203, 193, 67, 122, 29, 183, 194, 225, 78, 34, 73, 52, 135, 82, 255, 208, 49, 5, 28, 70, 161, 169, 154, 17, 22, 43, 126, 208, 21, 219, 114, 144, 103, 49, 26, 105, 152, 163, 145, 27, 79, 104, 83, 144, 170, 162, 80, 201, 179, 129, 183, 184, 123, 111, 29, 75, 0, 81, 15, 230, 192, 22, 216, 199, 233, 98, 13, 80, 188, 92, 98, 110, 9, 36, 220, 55, 63, 180, 240, 83, 150, 157, 132, 30, 145, 0, 226, 72, 200, 18, 212, 186, 187, 19, 130, 2, 130, 23, 124, 196, 156, 218, 145, 74, 79, 60, 175, 172, 92, 88, 140, 248, 167, 50, 81, 139, 31, 131, 163, 86, 196, 90, 91, 209, 178, 55, 65, 108, 65, 218, 118, 183, 161, 8, 203, 81, 4, 245, 3, 64, 189, 59, 188, 150, 139, 47, 128, 29, 21, 176, 2, 57, 183, 209, 207, 99, 54, 38, 20, 172, 38, 172, 52, 6, 216, 32, 59, 7, 40, 21, 8, 107, 69, 238, 162, 219, 31, 42, 88, 115, 204, 31, 5, 190, 167, 170, 12, 151, 143, 178, 141, 171, 38, 89, 177, 220, 158, 231, 143, 177, 12, 197, 254, 213, 4, 9, 14, 168, 236, 40, 44, 88, 195, 21, 135, 29, 233, 105, 187, 114, 250, 37, 254, 183, 151, 235, 236, 25, 57, 60, 124, 184, 17, 34, 146, 131, 145, 196, 143, 175, 36, 113, 199, 14, 104, 228, 69, 200, 202, 181, 171, 86, 208, 173, 14, 206, 97, 107, 105, 186, 154, 49, 118, 75, 125, 231, 100, 162, 92, 188, 76, 235, 153, 140, 229, 45, 135, 111, 159, 32, 206, 13, 5, 32, 135, 38, 129, 19, 176, 134, 88, 187, 130, 225, 139, 152, 177, 101, 162, 215, 29, 92, 68, 234, 73, 117, 55, 2, 89, 147, 141, 187, 183, 178, 164, 70, 167, 91, 77, 242, 222, 117, 231, 6, 110, 206, 113, 83, 97, 113, 230, 125, 4, 173, 32, 226, 211, 17, 135, 11, 208, 61, 130, 25, 27, 194, 198, 84, 49, 45, 163, 219, 57, 68, 54, 83, 88, 18, 41, 128, 120, 78, 21, 65, 240, 144, 163, 49, 226, 124, 128, 49, 131, 9, 231, 77, 30, 226, 190, 109, 76, 38, 137, 219, 115, 136, 31, 126, 89, 80, 130, 152, 118, 34, 132, 238, 61, 17, 115, 86, 166, 158, 11, 16, 132, 30, 158, 150, 153, 133, 92, 117, 86, 208, 186, 67, 96, 224, 225, 26, 142, 163, 112, 83, 44, 41, 120, 214, 48, 224, 81, 101, 219, 43, 93, 225, 210, 32, 182, 56, 211, 70, 19, 118, 232, 209, 164, 201, 134, 20, 3, 67, 4, 41, 155, 198, 131, 10, 67, 125, 213, 66, 147, 26, 65, 18, 115, 1, 69, 167, 203, 131, 150, 81, 80, 69, 162, 236, 137, 14, 125, 50, 71, 170, 83, 133, 43, 174, 43, 58, 180, 111, 92, 165, 111, 5, 230, 80, 59, 45, 203, 6, 253, 91, 172, 154, 238, 185, 119, 70, 141, 10, 227, 174, 99, 134, 147, 240, 173, 166, 158, 125, 247, 232, 198, 219, 119, 51, 176, 96, 153, 101, 116, 73, 246, 174, 101, 215, 189, 113, 83, 154, 186, 27, 18, 204, 154, 250, 150, 221, 197, 169, 203, 203, 98, 173, 45, 115, 113, 214, 199, 98, 186, 221, 99, 140, 109, 108, 131, 32, 140, 137, 32, 178, 1, 8, 15, 47, 127, 191, 223, 240, 50, 178, 149, 22, 245, 36, 170, 107, 67, 33, 12, 252, 50, 236, 65, 163, 135, 1, 170, 32, 193, 230, 11, 40, 88, 102, 83, 99, 239, 223, 212, 190, 104, 236, 52, 230, 223, 117, 93, 167, 95, 195, 249, 158, 70, 238, 176, 157, 246, 170, 71, 152, 129, 244, 194, 29, 68, 44, 76, 37, 203, 43, 110, 117, 3, 24, 202, 42, 112, 114, 83, 168, 44, 240, 57, 21, 36, 166, 8, 92, 64, 144, 146, 8, 188, 205, 49, 16, 173, 209, 111, 40, 69, 131, 6, 0, 53, 64, 13, 64, 189, 199, 16, 113, 229, 102, 248, 183, 39, 57, 178, 137, 103, 54, 84, 218, 234, 220, 124, 23, 120, 50, 110, 218, 16, 38, 101, 220, 220, 179, 14, 44, 118, 88, 147, 194, 241, 82, 151, 50, 21, 21, 193, 16, 71, 128, 32, 129, 70, 170, 1, 88, 160, 18, 80, 128, 96, 100, 163, 25, 168, 17, 175, 53, 132, 202, 128, 201, 74, 97, 20, 87, 146, 17, 27, 34, 5, 242, 104, 65, 74, 181, 10, 72, 3, 185, 36, 144, 89, 167, 22, 112, 41, 2, 68, 18, 80, 136, 55, 21, 173, 56, 125, 61, 223, 66, 190, 255, 185, 94, 215, 203, 179, 179, 84, 248, 24, 0, 179, 134, 46, 233, 172, 108, 76, 53, 153, 213, 195, 49, 243, 133, 110, 102, 243, 174, 190, 90, 213, 207, 75, 115, 134, 0, 64, 0, 3, 24, 8, 64, 49, 128, 1, 28, 114, 103, 121, 252, 239, 38, 151, 55, 121, 168, 32, 65, 15, 240, 202, 120, 95, 165, 70, 224, 24, 221, 86, 160, 87, 118, 108, 39, 12, 38, 181, 119, 250, 97, 127, 20, 118, 124, 142, 141, 103, 29, 142, 150, 125, 142, 139, 210, 52, 204, 63, 170, 156, 7, 170, 234, 105, 17, 14, 238, 34, 82, 187, 208, 138, 135, 210, 18, 36, 34, 141, 132, 14, 132, 80, 49, 128, 191, 58, 34, 91, 185, 205, 98, 33, 20, 75, 193, 7, 17, 108, 55, 25, 66, 65, 178, 165, 226, 9, 56, 165, 9, 154, 34, 203, 160, 148, 165, 224, 8, 20, 11, 140, 220, 26, 161, 146, 88, 81, 188, 6, 65, 145, 86, 98, 208, 8, 224, 5, 232, 69, 207, 16, 28, 34, 13, 115, 169, 106, 40, 211, 25, 20, 10, 136, 200, 171, 49, 105, 26, 128, 6, 177, 84, 47, 235, 88, 26, 32, 33, 34, 166, 104, 53, 19, 164, 65, 109, 153, 161, 59, 208, 88, 7, 61, 72, 9, 98, 2, 94, 34, 179, 26, 29, 102, 64, 132, 99, 12, 69, 231, 139, 77, 139, 9, 216, 11, 180, 44, 105, 34, 99, 156, 218, 69, 172, 81, 253, 77, 177, 11, 25, 4, 70, 227, 5, 206, 56, 14, 221, 133, 188, 209, 183, 122, 173, 185, 163, 95, 80, 80, 154, 23, 54, 140, 245, 155, 12, 133, 36, 0, 33, 122, 52, 231, 86, 130, 196, 13, 66, 65, 215, 161, 41, 76, 12, 2, 24, 211, 25, 0, 145, 145, 97, 36, 144, 144, 145, 76, 139, 225, 160, 72, 80, 232, 202, 180, 105, 207, 100, 50, 134, 89, 17, 153, 204, 218, 140, 12, 209, 97, 20, 154, 251, 86, 84, 177, 175, 64, 84, 9, 124, 11, 20, 90, 129, 10, 136, 21, 84, 164, 137, 44, 81, 107, 130, 6, 132, 98, 16, 162, 1, 34, 132, 178, 200, 225, 16, 132, 66, 96, 18, 146, 196, 50, 162, 136, 94, 81, 32, 178, 19, 16, 12, 107, 11, 42, 85, 134, 69, 192, 167, 1, 166, 234, 166, 92, 116, 52, 103, 160, 66, 228, 128, 142, 119, 82, 176, 0, 211, 144, 57, 45, 194, 225, 65, 97, 32, 192, 195, 86, 54, 182, 4, 216, 205, 108, 198, 8, 224, 146, 136, 177, 72, 8, 50, 36, 136, 236, 196, 75, 195, 54, 157, 123, 13, 208, 206, 80, 255, 241, 119, 36, 83, 133, 9, 10, 155, 153, 116, 224 };

constexpr std::array<u8, 1845> RUBY = { 212, 40, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 147, 57, 225, 246, 0, 0, 143, 255, 223, 127, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 255, 239, 235, 189, 192, 176, 0, 0, 16, 48, 128, 0, 24, 1, 17, 8, 128, 96, 8, 31, 108, 69, 125, 219, 182, 212, 66, 171, 187, 35, 187, 0, 0, 3, 160, 74, 34, 105, 52, 100, 154, 100, 211, 209, 52, 100, 212, 244, 209, 60, 154, 158, 163, 77, 61, 38, 134, 141, 26, 0, 52, 105, 160, 54, 147, 71, 168, 208, 100, 200, 104, 104, 26, 105, 163, 65, 40, 32, 37, 61, 19, 201, 54, 148, 79, 106, 159, 148, 218, 160, 122, 152, 143, 213, 48, 8, 201, 163, 212, 122, 128, 208, 13, 26, 0, 200, 52, 211, 64, 26, 0, 209, 234, 104, 65, 128, 0, 0, 0, 0, 0, 0, 0, 4, 192, 0, 0, 0, 70, 0, 2, 96, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 19, 0, 0, 0, 1, 24, 0, 9, 128, 1, 181, 69, 38, 104, 128, 27, 72, 0, 0, 26, 0, 0, 104, 0, 0, 0, 0, 0, 0, 0, 3, 32, 66, 146, 77, 2, 154, 131, 80, 26, 7, 168, 208, 0, 26, 50, 1, 160, 0, 26, 105, 167, 164, 0, 54, 144, 0, 0, 3, 67, 212, 244, 111, 84, 220, 188, 73, 213, 16, 236, 233, 15, 95, 47, 114, 6, 155, 166, 243, 181, 134, 198, 253, 207, 101, 132, 227, 84, 9, 84, 69, 84, 85, 65, 81, 74, 48, 233, 97, 1, 130, 235, 242, 53, 244, 195, 70, 206, 225, 224, 166, 198, 157, 206, 77, 204, 234, 85, 9, 144, 206, 64, 64, 57, 138, 136, 34, 95, 168, 42, 130, 1, 30, 11, 47, 94, 149, 122, 165, 234, 181, 103, 105, 105, 248, 60, 62, 45, 75, 186, 190, 110, 206, 31, 107, 183, 220, 187, 171, 30, 5, 38, 48, 99, 1, 117, 52, 5, 200, 115, 149, 81, 139, 65, 140, 126, 154, 188, 202, 217, 111, 151, 21, 45, 41, 90, 34, 97, 45, 165, 132, 82, 208, 215, 157, 12, 201, 138, 179, 9, 136, 162, 113, 5, 36, 72, 45, 239, 9, 247, 64, 13, 128, 84, 68, 248, 16, 3, 243, 65, 26, 18, 177, 189, 19, 71, 87, 122, 78, 175, 247, 44, 56, 45, 11, 59, 179, 156, 199, 158, 81, 17, 8, 223, 181, 228, 243, 34, 145, 163, 140, 52, 231, 209, 32, 66, 23, 199, 46, 151, 102, 223, 207, 167, 48, 155, 72, 21, 135, 27, 180, 138, 100, 45, 75, 116, 62, 173, 234, 91, 169, 149, 155, 80, 246, 142, 192, 197, 109, 45, 58, 108, 49, 167, 29, 26, 61, 58, 5, 240, 62, 114, 167, 236, 148, 61, 164, 74, 56, 10, 229, 109, 122, 44, 227, 64, 16, 155, 112, 152, 167, 86, 190, 54, 141, 190, 151, 0, 81, 139, 119, 134, 141, 29, 250, 79, 209, 63, 205, 182, 42, 105, 240, 61, 136, 105, 51, 18, 20, 157, 215, 57, 117, 211, 35, 142, 151, 116, 154, 254, 239, 127, 226, 100, 68, 19, 18, 40, 158, 251, 28, 212, 5, 24, 3, 21, 48, 38, 128, 196, 192, 223, 74, 50, 156, 67, 202, 119, 241, 127, 72, 21, 81, 84, 130, 126, 164, 73, 151, 110, 223, 111, 183, 193, 236, 162, 96, 38, 115, 223, 98, 104, 243, 112, 174, 192, 3, 68, 23, 77, 118, 122, 44, 32, 168, 201, 216, 255, 136, 206, 82, 77, 146, 226, 169, 148, 72, 17, 95, 33, 58, 135, 35, 204, 46, 189, 98, 195, 41, 145, 58, 165, 0, 189, 145, 154, 212, 14, 129, 40, 146, 40, 80, 108, 17, 238, 84, 129, 138, 41, 60, 159, 195, 52, 136, 82, 236, 60, 173, 108, 187, 153, 89, 151, 60, 228, 29, 60, 227, 201, 62, 49, 173, 172, 58, 63, 137, 188, 227, 189, 226, 156, 240, 235, 220, 239, 17, 226, 113, 233, 28, 222, 240, 242, 167, 153, 240, 203, 93, 81, 145, 120, 138, 155, 233, 113, 136, 75, 49, 52, 88, 236, 29, 147, 144, 121, 103, 28, 173, 204, 113, 118, 142, 27, 171, 140, 198, 97, 199, 135, 134, 144, 216, 226, 86, 49, 161, 64, 76, 78, 186, 215, 86, 89, 96, 218, 116, 22, 56, 176, 228, 235, 46, 186, 235, 168, 235, 254, 68, 210, 92, 187, 225, 155, 78, 140, 104, 181, 198, 169, 134, 102, 34, 44, 23, 104, 215, 222, 112, 200, 52, 11, 223, 56, 222, 19, 10, 162, 193, 174, 46, 120, 100, 217, 76, 155, 35, 207, 18, 71, 49, 172, 71, 135, 172, 13, 115, 159, 30, 24, 209, 204, 113, 84, 206, 202, 150, 212, 161, 139, 20, 61, 106, 116, 233, 171, 93, 110, 181, 242, 232, 205, 64, 77, 154, 214, 36, 96, 145, 251, 18, 2, 161, 60, 166, 142, 194, 190, 178, 91, 47, 212, 98, 72, 74, 185, 75, 143, 63, 8, 153, 12, 54, 118, 20, 216, 45, 108, 168, 210, 137, 155, 18, 90, 21, 86, 24, 230, 199, 64, 105, 57, 229, 72, 220, 16, 16, 98, 57, 71, 135, 70, 121, 204, 172, 230, 202, 57, 34, 37, 78, 73, 201, 52, 20, 140, 233, 91, 109, 135, 20, 221, 191, 181, 175, 69, 9, 231, 220, 115, 119, 17, 136, 113, 157, 32, 79, 23, 49, 140, 219, 144, 25, 149, 184, 150, 178, 251, 92, 124, 44, 128, 68, 20, 157, 33, 168, 207, 44, 140, 96, 154, 248, 194, 236, 59, 170, 14, 50, 42, 155, 176, 73, 187, 237, 197, 209, 120, 83, 152, 162, 190, 40, 154, 243, 182, 205, 39, 54, 193, 59, 132, 101, 88, 201, 101, 5, 231, 169, 112, 239, 8, 4, 14, 86, 161, 213, 160, 228, 9, 71, 117, 92, 101, 70, 96, 88, 70, 49, 172, 100, 76, 29, 232, 110, 63, 21, 251, 206, 227, 217, 118, 209, 37, 176, 97, 125, 60, 143, 143, 234, 27, 142, 139, 234, 199, 133, 169, 177, 61, 232, 96, 132, 30, 146, 230, 214, 8, 86, 83, 129, 41, 175, 110, 116, 155, 58, 239, 250, 78, 170, 231, 100, 197, 212, 148, 161, 252, 139, 177, 161, 211, 51, 109, 147, 222, 12, 246, 10, 251, 156, 110, 103, 168, 197, 56, 119, 164, 165, 237, 249, 180, 160, 0, 48, 67, 104, 221, 65, 54, 195, 202, 152, 16, 155, 212, 19, 128, 195, 11, 164, 56, 227, 93, 193, 48, 140, 72, 223, 40, 204, 134, 250, 143, 192, 197, 133, 149, 30, 36, 217, 36, 214, 161, 199, 206, 67, 132, 245, 244, 39, 176, 0, 32, 168, 40, 63, 147, 16, 58, 146, 116, 106, 152, 20, 101, 142, 144, 14, 108, 131, 155, 129, 187, 205, 60, 11, 211, 153, 30, 15, 102, 109, 7, 124, 232, 127, 14, 160, 48, 190, 1, 212, 15, 198, 22, 164, 204, 100, 196, 229, 242, 142, 91, 90, 156, 47, 132, 86, 79, 91, 220, 245, 200, 152, 64, 203, 220, 202, 98, 17, 19, 32, 100, 12, 137, 74, 217, 98, 43, 181, 145, 160, 82, 136, 202, 174, 168, 142, 43, 84, 119, 0, 237, 148, 95, 189, 81, 153, 138, 59, 60, 230, 95, 219, 90, 141, 102, 142, 223, 243, 66, 148, 60, 175, 181, 244, 13, 182, 92, 31, 155, 246, 245, 168, 96, 15, 118, 63, 78, 120, 36, 109, 245, 181, 173, 131, 62, 151, 4, 13, 193, 243, 122, 138, 240, 72, 36, 2, 8, 41, 21, 163, 97, 118, 233, 139, 132, 144, 174, 96, 24, 17, 9, 151, 213, 45, 42, 162, 136, 53, 237, 61, 94, 244, 231, 97, 230, 102, 117, 52, 185, 186, 19, 44, 86, 155, 52, 13, 58, 237, 6, 138, 42, 162, 138, 46, 141, 222, 127, 59, 63, 106, 27, 136, 66, 33, 107, 0, 80, 176, 0, 84, 77, 26, 2, 82, 201, 131, 88, 135, 136, 146, 19, 236, 22, 161, 153, 129, 148, 67, 153, 139, 68, 222, 195, 108, 53, 84, 201, 71, 159, 6, 39, 14, 64, 7, 1, 130, 45, 182, 130, 138, 96, 147, 108, 21, 50, 136, 50, 12, 40, 140, 140, 42, 142, 94, 135, 151, 244, 126, 207, 161, 216, 242, 229, 20, 84, 83, 9, 221, 238, 247, 125, 239, 153, 229, 121, 254, 95, 135, 230, 124, 78, 239, 103, 98, 190, 65, 233, 124, 32, 149, 136, 8, 160, 54, 218, 185, 65, 140, 82, 190, 48, 175, 166, 177, 95, 28, 87, 99, 8, 142, 34, 188, 21, 116, 154, 162, 8, 55, 239, 242, 0, 241, 228, 125, 100, 240, 220, 40, 162, 255, 208, 97, 36, 145, 68, 17, 53, 15, 127, 191, 207, 70, 192, 132, 74, 210, 219, 128, 7, 32, 148, 51, 64, 193, 19, 1, 20, 80, 193, 12, 193, 82, 18, 189, 164, 192, 192, 146, 32, 38, 138, 18, 24, 118, 96, 8, 204, 19, 185, 6, 65, 102, 99, 68, 202, 177, 0, 64, 176, 4, 130, 64, 76, 196, 66, 147, 4, 68, 67, 10, 196, 43, 74, 208, 147, 17, 41, 17, 6, 144, 94, 132, 34, 98, 154, 104, 131, 140, 166, 48, 27, 48, 24, 197, 22, 96, 9, 137, 49, 9, 40, 144, 16, 164, 20, 132, 96, 131, 240, 109, 26, 104, 182, 135, 24, 2, 128, 153, 146, 74, 106, 29, 177, 25, 117, 99, 168, 200, 192, 2, 37, 32, 193, 2, 69, 56, 211, 14, 215, 40, 82, 169, 152, 19, 137, 224, 97, 198, 8, 137, 159, 22, 68, 240, 160, 53, 68, 116, 204, 33, 105, 22, 65, 136, 83, 35, 40, 129, 229, 152, 185, 150, 98, 209, 5, 7, 92, 201, 131, 81, 163, 153, 27, 106, 109, 182, 53, 163, 81, 140, 101, 151, 8, 34, 51, 48, 141, 141, 219, 151, 19, 153, 195, 112, 221, 93, 209, 129, 73, 77, 209, 133, 163, 124, 51, 12, 128, 168, 50, 28, 183, 21, 223, 45, 192, 110, 88, 208, 97, 46, 116, 64, 57, 32, 26, 58, 210, 82, 144, 73, 22, 157, 244, 239, 156, 246, 181, 176, 110, 30, 55, 66, 240, 248, 177, 78, 184, 241, 225, 212, 215, 35, 98, 6, 132, 41, 160, 137, 73, 73, 2, 149, 5, 66, 0, 162, 65, 130, 160, 16, 2, 129, 48, 144, 68, 6, 9, 26, 52, 238, 59, 187, 187, 187, 155, 133, 32, 91, 118, 93, 173, 30, 171, 128, 42, 118, 184, 96, 81, 228, 28, 204, 58, 135, 80, 199, 29, 209, 210, 6, 231, 83, 100, 224, 122, 208, 67, 176, 132, 226, 113, 225, 128, 14, 39, 30, 25, 224, 235, 56, 115, 231, 145, 135, 49, 229, 176, 230, 134, 94, 59, 142, 35, 177, 7, 255, 23, 114, 69, 56, 80, 144, 147, 57, 225, 246 };

constexpr std::array<u8, 1849> SAPPHIRE = { 212, 40, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 85, 191, 238, 156, 0, 0, 143, 255, 223, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 189, 192, 176, 0, 0, 16, 48, 128, 0, 24, 1, 17, 8, 128, 96, 8, 31, 108, 85, 95, 118, 237, 180, 160, 163, 187, 187, 27, 179, 64, 0, 7, 84, 37, 10, 77, 26, 155, 35, 77, 83, 96, 67, 106, 153, 164, 244, 158, 147, 77, 30, 166, 104, 131, 77, 0, 1, 147, 77, 166, 144, 244, 106, 30, 166, 64, 1, 160, 0, 52, 104, 37, 4, 5, 13, 26, 19, 42, 126, 167, 168, 245, 30, 138, 30, 147, 211, 83, 104, 105, 52, 245, 3, 79, 83, 77, 1, 160, 0, 104, 13, 13, 52, 218, 129, 136, 105, 166, 134, 79, 83, 106, 32, 192, 9, 128, 0, 0, 76, 0, 38, 0, 0, 1, 48, 2, 104, 96, 0, 0, 0, 0, 2, 12, 0, 152, 0, 0, 4, 192, 2, 96, 0, 0, 19, 0, 38, 134, 0, 0, 0, 0, 0, 13, 170, 73, 51, 68, 1, 232, 212, 0, 0, 0, 0, 3, 64, 0, 0, 0, 0, 0, 0, 0, 6, 64, 133, 36, 154, 5, 17, 164, 3, 208, 155, 81, 160, 104, 52, 52, 122, 154, 52, 0, 0, 0, 0, 3, 212, 208, 6, 64, 0, 1, 234, 122, 39, 170, 110, 93, 185, 213, 16, 236, 233, 3, 198, 129, 160, 185, 240, 159, 85, 97, 182, 253, 207, 91, 232, 248, 240, 170, 4, 170, 34, 170, 42, 160, 168, 165, 24, 116, 184, 64, 96, 183, 14, 38, 195, 195, 203, 162, 221, 39, 138, 151, 101, 167, 111, 157, 231, 97, 70, 77, 126, 36, 4, 3, 146, 168, 130, 37, 5, 5, 80, 64, 40, 208, 107, 247, 229, 223, 142, 254, 46, 46, 251, 183, 111, 90, 230, 189, 221, 141, 155, 221, 124, 62, 199, 103, 75, 99, 102, 142, 14, 19, 48, 204, 11, 119, 158, 46, 67, 174, 170, 163, 45, 38, 105, 53, 86, 67, 86, 204, 146, 90, 84, 202, 82, 180, 4, 36, 199, 11, 8, 166, 80, 228, 135, 95, 134, 21, 88, 72, 81, 68, 198, 20, 149, 40, 203, 252, 137, 245, 16, 7, 193, 68, 79, 153, 0, 59, 104, 35, 52, 37, 113, 189, 83, 177, 242, 116, 36, 246, 96, 243, 54, 227, 61, 101, 166, 252, 75, 67, 193, 57, 204, 121, 229, 17, 16, 117, 81, 81, 159, 208, 28, 36, 200, 156, 236, 248, 220, 102, 232, 225, 199, 64, 72, 80, 37, 203, 119, 132, 231, 165, 24, 160, 76, 73, 149, 95, 87, 208, 173, 154, 172, 172, 218, 163, 216, 59, 3, 21, 188, 94, 58, 76, 49, 162, 253, 26, 61, 42, 6, 40, 29, 90, 157, 226, 225, 35, 80, 150, 110, 149, 202, 251, 117, 27, 134, 240, 62, 123, 31, 55, 231, 75, 131, 145, 165, 151, 206, 221, 10, 112, 124, 247, 169, 148, 255, 120, 82, 105, 159, 230, 194, 21, 56, 190, 39, 185, 14, 41, 148, 144, 164, 237, 181, 203, 109, 153, 27, 244, 183, 158, 216, 124, 30, 31, 39, 18, 32, 150, 34, 137, 211, 99, 156, 34, 37, 0, 3, 21, 24, 38, 128, 98, 96, 111, 37, 21, 76, 161, 229, 35, 248, 159, 164, 10, 120, 138, 57, 63, 81, 228, 180, 38, 56, 227, 156, 30, 205, 19, 1, 51, 157, 220, 77, 31, 87, 10, 236, 128, 26, 32, 186, 107, 179, 232, 112, 218, 113, 58, 220, 4, 103, 41, 38, 2, 210, 169, 168, 36, 8, 175, 150, 158, 249, 203, 232, 22, 225, 88, 176, 202, 98, 79, 136, 160, 29, 77, 125, 199, 64, 209, 37, 152, 2, 133, 39, 30, 163, 185, 27, 204, 162, 147, 201, 251, 209, 16, 10, 93, 127, 54, 246, 101, 171, 57, 214, 187, 227, 210, 239, 154, 39, 191, 53, 181, 135, 71, 240, 55, 225, 59, 222, 57, 207, 14, 189, 206, 241, 29, 190, 61, 35, 155, 222, 30, 84, 243, 61, 217, 123, 62, 110, 34, 241, 149, 58, 41, 105, 96, 151, 44, 104, 177, 214, 58, 231, 44, 221, 54, 74, 218, 198, 198, 51, 51, 171, 140, 198, 81, 222, 2, 142, 15, 216, 198, 172, 99, 190, 128, 152, 157, 69, 224, 43, 100, 176, 229, 90, 75, 70, 12, 60, 11, 203, 180, 187, 74, 59, 59, 139, 17, 50, 100, 209, 154, 61, 23, 209, 107, 125, 83, 38, 86, 34, 44, 23, 25, 181, 194, 204, 65, 184, 102, 39, 144, 206, 154, 226, 171, 181, 165, 175, 14, 70, 194, 107, 250, 100, 32, 84, 139, 59, 36, 8, 117, 71, 140, 100, 64, 103, 34, 209, 52, 156, 253, 187, 29, 60, 46, 55, 143, 122, 205, 26, 52, 43, 199, 147, 173, 53, 123, 81, 32, 39, 162, 181, 137, 84, 11, 52, 145, 226, 50, 121, 84, 118, 164, 220, 147, 44, 156, 163, 36, 169, 74, 98, 217, 90, 243, 234, 16, 206, 54, 55, 148, 222, 54, 127, 5, 28, 204, 110, 93, 77, 147, 49, 152, 192, 24, 114, 99, 9, 19, 226, 73, 72, 14, 140, 243, 153, 134, 115, 230, 28, 195, 65, 114, 43, 42, 82, 142, 163, 23, 8, 23, 136, 180, 35, 59, 212, 134, 193, 199, 195, 189, 181, 196, 161, 60, 249, 220, 227, 216, 88, 56, 206, 154, 116, 215, 7, 144, 198, 109, 48, 25, 149, 165, 99, 47, 189, 179, 151, 4, 2, 32, 164, 233, 11, 166, 105, 98, 99, 34, 109, 114, 5, 186, 238, 168, 56, 200, 170, 95, 130, 77, 223, 133, 23, 69, 203, 57, 138, 43, 217, 19, 107, 59, 96, 164, 230, 218, 137, 222, 35, 42, 198, 75, 40, 46, 226, 150, 142, 240, 128, 64, 219, 213, 29, 90, 14, 64, 148, 127, 21, 113, 149, 25, 129, 110, 140, 206, 51, 64, 195, 190, 23, 43, 228, 73, 190, 239, 170, 195, 182, 76, 7, 30, 169, 240, 185, 36, 147, 116, 220, 118, 15, 139, 72, 22, 63, 51, 147, 223, 121, 240, 145, 73, 107, 86, 8, 86, 83, 129, 41, 172, 227, 209, 245, 143, 218, 231, 92, 179, 224, 148, 34, 178, 97, 137, 119, 69, 187, 161, 211, 43, 103, 53, 32, 27, 172, 44, 163, 19, 181, 186, 163, 41, 193, 68, 255, 58, 157, 252, 121, 232, 0, 100, 15, 200, 237, 160, 159, 152, 116, 211, 29, 227, 118, 130, 111, 153, 50, 68, 97, 134, 182, 221, 249, 132, 164, 75, 12, 162, 254, 138, 148, 31, 125, 203, 133, 202, 143, 17, 82, 82, 86, 6, 223, 55, 84, 235, 215, 206, 189, 128, 1, 5, 65, 65, 252, 152, 130, 18, 74, 16, 210, 149, 20, 85, 134, 37, 240, 192, 73, 229, 193, 7, 56, 129, 197, 232, 158, 13, 219, 50, 59, 94, 6, 109, 7, 124, 232, 126, 254, 160, 48, 190, 9, 212, 15, 32, 64, 146, 136, 73, 66, 90, 205, 45, 52, 9, 78, 240, 172, 154, 125, 205, 49, 210, 132, 130, 126, 9, 0, 136, 145, 4, 65, 18, 78, 149, 170, 43, 181, 99, 64, 165, 17, 149, 93, 81, 28, 86, 168, 238, 1, 218, 40, 188, 10, 140, 204, 81, 219, 83, 153, 127, 93, 106, 53, 154, 60, 47, 228, 133, 40, 124, 207, 179, 242, 77, 182, 92, 31, 141, 246, 181, 168, 96, 15, 104, 62, 230, 120, 36, 109, 243, 245, 173, 131, 62, 87, 4, 13, 193, 250, 125, 69, 120, 36, 16, 129, 4, 20, 10, 211, 176, 187, 116, 197, 194, 72, 87, 48, 12, 8, 132, 203, 231, 19, 138, 168, 162, 14, 72, 230, 236, 233, 107, 187, 137, 159, 159, 119, 82, 238, 132, 54, 49, 226, 136, 11, 117, 220, 7, 5, 21, 81, 69, 23, 79, 99, 70, 235, 59, 102, 217, 176, 66, 29, 213, 0, 158, 96, 0, 167, 218, 26, 1, 41, 68, 193, 39, 136, 144, 19, 236, 6, 128, 204, 192, 202, 33, 204, 197, 162, 104, 61, 94, 218, 53, 84, 193, 76, 121, 184, 24, 28, 56, 128, 28, 6, 8, 182, 218, 10, 41, 130, 77, 176, 84, 202, 51, 1, 134, 100, 97, 239, 230, 175, 87, 187, 252, 152, 143, 35, 202, 40, 162, 162, 136, 91, 214, 185, 155, 111, 83, 111, 86, 45, 94, 93, 201, 147, 17, 19, 56, 244, 157, 160, 149, 136, 8, 160, 54, 118, 170, 229, 153, 81, 51, 20, 175, 148, 43, 233, 108, 87, 186, 43, 177, 132, 71, 17, 94, 10, 186, 77, 81, 4, 27, 247, 249, 32, 119, 97, 124, 104, 225, 184, 81, 69, 255, 160, 194, 9, 34, 136, 34, 106, 30, 255, 127, 158, 141, 129, 8, 149, 165, 183, 0, 14, 65, 40, 102, 129, 130, 38, 2, 40, 161, 130, 25, 146, 164, 37, 123, 9, 129, 129, 36, 64, 77, 20, 36, 48, 236, 192, 17, 152, 39, 114, 12, 130, 204, 198, 137, 149, 98, 0, 129, 96, 9, 4, 128, 153, 136, 133, 38, 8, 136, 134, 21, 170, 21, 165, 104, 73, 136, 148, 136, 131, 72, 47, 66, 17, 49, 77, 52, 65, 198, 83, 24, 13, 136, 12, 98, 139, 48, 4, 196, 152, 132, 148, 72, 8, 82, 10, 66, 48, 65, 247, 86, 141, 52, 91, 67, 140, 1, 64, 76, 201, 37, 53, 14, 216, 140, 186, 177, 40, 208, 1, 18, 144, 96, 129, 34, 156, 105, 135, 107, 148, 41, 84, 204, 9, 196, 240, 48, 227, 4, 68, 207, 143, 34, 118, 160, 53, 68, 116, 204, 33, 105, 22, 85, 35, 48, 202, 32, 121, 102, 46, 101, 152, 180, 65, 65, 215, 50, 96, 212, 104, 230, 70, 218, 155, 109, 141, 104, 212, 99, 25, 100, 28, 40, 140, 204, 35, 99, 118, 229, 196, 230, 112, 220, 55, 87, 116, 96, 82, 83, 116, 97, 104, 223, 12, 195, 32, 42, 12, 135, 45, 197, 119, 203, 112, 27, 150, 52, 24, 75, 157, 4, 14, 72, 6, 142, 180, 148, 164, 18, 69, 167, 125, 59, 231, 61, 173, 108, 27, 135, 149, 208, 188, 46, 44, 83, 174, 60, 120, 117, 53, 200, 216, 129, 161, 10, 98, 10, 7, 112, 142, 97, 36, 1, 68, 130, 171, 5, 64, 32, 5, 2, 97, 32, 136, 12, 18, 28, 116, 144, 146, 73, 59, 187, 155, 133, 32, 91, 118, 110, 198, 143, 23, 128, 42, 118, 56, 96, 81, 238, 14, 102, 29, 67, 168, 98, 50, 73, 4, 116, 2, 69, 210, 8, 68, 210, 130, 5, 130, 160, 78, 113, 100, 1, 24, 39, 22, 192, 249, 195, 159, 60, 140, 57, 143, 45, 135, 52, 50, 241, 220, 113, 29, 136, 63, 248, 187, 146, 41, 194, 132, 130, 173, 255, 116, 224 };

constexpr std::array<u8, 78> XD = { 42, 0, 0, 0, 66, 90, 104, 57, 49, 65, 89, 38, 83, 89, 86, 129, 93, 150, 0, 0, 0, 124, 13, 112, 16, 6, 136, 0, 32, 64, 0, 0, 64, 0, 8, 16, 0, 128, 128, 32, 0, 34, 30, 168, 6, 140, 212, 41, 128, 0, 186, 84, 166, 119, 17, 11, 42, 245, 78, 2, 182, 218, 29, 129, 178, 12, 15, 241, 119, 36, 83, 133, 9, 5, 104, 21, 217, 96 };

