/*
 * This file is part of PokéFinder
 * Copyright (C) 2017-2024 by Admiral_Fish, bumba, and EzPzStreamz
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "HiddenGrottoFilter.hpp"
#include <Core/Gen5/States/HiddenGrottoState.hpp>

HiddenGrottoFilter::HiddenGrottoFilter(const std::array<bool, 11> &encounterSlots, const std::array<bool, 2> &genders,
                                       const std::array<bool, 4> &groups) :
    encounterSlots(encounterSlots), genders(genders), groups(groups)
{
}

bool HiddenGrottoFilter::compareState(const HiddenGrottoState &state) const
{
    if (!encounterSlots[state.getSlot()])
    {
        return false;
    }

    // Only check gender filter if not an item
    if (!state.getItem() && !genders[state.getGender()])
    {
        return false;
    }

    if (!groups[state.getGroup()])
    {
        return false;
    }

    return true;
}
