package noria.ui.examples

import androidx.compose.foundation.layout.*
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.UiText
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.text.NoriaParagraphStyle
import noria.NoriaContext
import noria.ui.components.Toast
import noria.ui.components.ToastStyle

internal fun toastExamples(): Gallery = gallery("Toasts", NoriaExamples.sourceCodeForFile("Toasts.kt")) {
  example("Toast") {
    Toasts()
  }
  example("Toast Above Content") {
    Box {
      UiText(
        modifier = Modifier.width(240.dp).height(160.dp),
        paragraphStyle = NoriaParagraphStyle.multiline,
        text = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed vestibulum purus a nisi rutrum, non efficitur est accumsan. Sed ut felis nec libero dignissim tempor eu ut quam. Phasellus varius vulputate quam in hendrerit. Quisque consequat nec nulla eget lobortis. Sed vel risus dolor. Nullam tempor vel odio quis lobortis. Ut eget ante ac massa ultrices hendrerit. Quisque et imperdiet nisl. Praesent tincidunt sit amet justo at rutrum. Sed efficitur tortor lectus, sit amet condimentum dolor posuere eu. Curabitur eu orci vestibulum nulla pretium faucibus. Duis non erat at nibh suscipit pulvinar. Vestibulum nec tristique sem, at volutpat velit. Morbi sit amet ullamcorper nulla. Maecenas dignissim fermentum justo vitae facilisis.")
      Toasts()
    }
  }
}

@Composable
private fun NoriaContext.Toasts() {
  Column(modifier = Modifier.padding(start = 16.dp, top = 16.dp)) {
    Toast(text = "Copy ⌘C")
    Spacer(Modifier.height(8.dp))
    Toast(text = "Hold ⌘Q to Quit", style = ToastStyle.BIG)
  }
}
