package noria.ui.examples

import androidx.compose.foundation.layout.*
import androidx.compose.runtime.*
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import fleet.compose.theme.LocalContentColor
import fleet.compose.theme.components.*
import fleet.compose.theme.components.segmented.SegmentedButton
import fleet.compose.theme.components.segmented.SingleChoiceSegmentedButtonRow
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.model.IconKey
import kotlin.random.Random

internal fun segmentedControlExamples(): Gallery = gallery("Segmented Control", NoriaExamples.sourceCodeForFile("SegmentedControl.kt")) {
  example("Compose Segmented Control") {
    Row {
      var selectedIndex by remember { mutableStateOf(-1) }
      val options = listOf("Day", "Week", "Month", "Year", "Decade")
      Column(verticalArrangement = Arrangement.spacedBy(10.dp)) {
        Row(horizontalArrangement = Arrangement.spacedBy(10.dp)) {
          LargePrimaryButton(text = "Reset", onClick = { selectedIndex = -1 })
          LargePrimaryButton(text = "Set Random", onClick = { selectedIndex = Random.nextInt(options.size) })
        }
        SingleChoiceSegmentedButtonRow {
          options.forEachIndexed { index, label ->
            SegmentedButton(
              onClick = { selectedIndex = index },
              selected = index == selectedIndex
            ) {
              UiText(label, LocalContentColor.current)
            }
          }
        }
      }
    }
  }
}
