package noria.ui.examples

import androidx.compose.foundation.layout.*
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.MenuItem
import fleet.compose.theme.components.UiText
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.scope
import noria.ui.text.DropdownLink
import noria.ui.text.Link

internal fun linksExamples(): Gallery = gallery("Links", NoriaExamples.sourceCodeForFile("Links.kt")) {
  example("Link") {
    Row(verticalAlignment = Alignment.CenterVertically) {
      for (external in listOf(false, true)) {
        scope(external) {
          Column(horizontalAlignment = Alignment.CenterHorizontally, modifier = Modifier.padding(4.dp)) {
            Row {
              UiText("Some text with a\u00A0")
              Link("link", external = external) {}
              UiText("\u00A0included in it")
            }
            Spacer(Modifier.height(4.dp))
            Row {
              Spacer(Modifier.height(4.dp))
              UiText("Some text with a\u00A0")
              Link("link", external = external, enabled = false) {}
              UiText("\u00A0included in it")
            }
          }
        }
      }
    }
  }

  example("Dropdown Link") {
    Row {
      DropdownLink(
        text = "Link with menu",
        menuItems = listOf(MenuItem.Text("Text"), MenuItem.Text("Text"))
      )
      Spacer(Modifier.width(8.dp))
      DropdownLink(
        text = "Link with menu",
        enabled = false,
        menuItems = listOf(MenuItem.Text("Text"), MenuItem.Text("Text"))
      )
    }
  }
}
