package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.*
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.DpOffset
import androidx.compose.ui.unit.dp
import fleet.compose.theme.Edge
import fleet.compose.theme.components.Switch
import fleet.compose.theme.layout.ProposedSize
import fleet.compose.theme.layout.Resizable
import fleet.compose.theme.components.Thickness
import fleet.util.enumSetOf
import noria.state
import noria.ui.components.*
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.theme
import fleet.compose.theme.components.UiText
import fleet.compose.theme.components.RadioGroup
import fleet.compose.theme.keys.ThemeKeys
import noria.ui.withModifier

internal fun componentsExamples(): Gallery = gallery("Components", NoriaExamples.sourceCodeForFile("Components.kt")) {
  example("DropDownList") {
    val items = listOf("foo", "bar", "baz", "qux")
    dropDownList(items, state { items.first() })
  }

  example("DropDownList + Popup") {
    withModifier(Modifier.height(height = 80.dp)) {
    withPopup(
    popupBuilder = {
      withPopup(
        popupBuilder = {
          withPopup(
            popupBuilder = {
              UiText("Fourth Popup", modifier = Modifier.background(Color.Gray))
            },
            position = PopupPosition(DpOffset(0.dp, 20.dp)),
            anchorBuilder = {
              UiText("Third Popup", modifier = Modifier.background(Color.Blue))
            }
          )
        },
        position = PopupPosition(DpOffset(0.dp, 20.dp)),
        anchorBuilder = {
          UiText("Second Popup", modifier = Modifier.background(Color.Green))
        }
      )
    },
    position = PopupPosition(DpOffset(0.dp, 20.dp)),
    anchorBuilder = {
      UiText("First Popup", modifier = Modifier.background(Color.Red))
    }
  )
    }
  }

  example("RadioGroup") {
    RadioGroup(listOf("foo", "bar", "baz"),
               selectedOption = "bar",
               onSelectedChange = { println("selected: $it") })
  }

  example("Toggle") {
    Row(
      verticalAlignment = Alignment.CenterVertically,
      horizontalArrangement = Arrangement.spacedBy(20.dp)
    ) {
      var isToggled1 by remember { mutableStateOf(false) }
      Switch(checked = isToggled1, onCheckedChange = {
        isToggled1 = it
      })

      var isToggled2 by remember { mutableStateOf(false) }
      Switch(checked = isToggled2, label = "Toggle with label", onCheckedChange = { isToggled2 = it })
    }
  }

  example("Resizable Popup") {
    Column {
      val modifier = Modifier
        .border(
          width = Thickness.Regular,
          theme[ThemeKeys.Border]
        )
        .background(color = theme[ThemeKeys.PopupBackground])
      withModifier(modifier) {
        Resizable(size = state { ProposedSize(400.dp, 200.dp) },
                  borders = enumSetOf<Edge>(Edge.Bottom, Edge.End)) {
          Box(contentAlignment = Alignment.Center) {
            UiText("Hello!")
          }
        }
      }
    }
  }
}
