package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import fleet.compose.theme.Edge
import fleet.compose.theme.graphics.css
import fleet.compose.theme.surface
import fleet.util.enumSetOf
import fleet.compose.theme.components.Thickness
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.UiText

internal fun borderExamples(): Gallery = gallery("Borders", NoriaExamples.sourceCodeForFile("Borders.kt")) {
  example("Simple Border") {
    Spacer(Modifier.border(width = Thickness.Thick, Color.Green)
             .size(width = 320.dp, height = 160.dp))
  }

  example("Round Border") {
    Spacer(Modifier.border(Thickness.Thick, Color.Green, shape = RoundedCornerShape(4.dp))
             .size(width = 320.dp, height = 160.dp))
  }

  example("Partial Border") {
    Spacer(Modifier.surface(Thickness.Thick, Color.Green, enumSetOf(Edge.Start, Edge.Bottom), RoundedCornerShape(4.dp))
             .background(color = Color.Gray)
             .size(width = 320.dp, height = 160.dp))
  }

  example("Partial Round Border") {
    Spacer(
      Modifier.border(Thickness.Thick, Color.Green, shape = RoundedCornerShape(10.dp, 0.dp, 10.dp, 0.dp))
        .size(width = 320.dp, height = 160.dp))
  }


  example("Circle") {
    Box(contentAlignment = Alignment.Center) {
      UiText(
        "M",
        color = Color.White,
        modifier = Modifier.background(Color.css("25a0f6"), CircleShape)
      )
    }
  }
}
