package noria.ui.examples

import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.Icon
import fleet.compose.theme.components.GhostButton
import fleet.compose.theme.components.Thickness
import fleet.compose.theme.keys.ThemeKeys
import fleet.compose.theme.surface
import fleet.compose.theme.theme
import noria.state
import noria.ui.components.*
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.ui.withModifier

private val exampleInputDefaultWidth = 256.dp
private const val loremIpsum = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."

internal fun textInputExamples(): Gallery = gallery("TextInput", NoriaExamples.sourceCodeForFile("TextInput.kt")) {
  example("One-Line TextInput") {
    Column {
      Row {
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(loremIpsum)
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(), placeholderText = "Some placeholder")
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(state { createTextInputData(enabled = false) }),
              placeholderText = "Disabled input with placeholder")
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(state { createTextInputData("Disabled input with text", enabled = false) }))
        }
      }
      Spacer(Modifier.height(8.dp))
      Row {
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(), ThemeKeys.SearchIcon, placeholderText = "Input with icon")
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(password = true), placeholderText = "Password input")
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(),
              style = defaultTextInputStyle().copy(textStyle = TextInputTextStyle.Code),
              placeholderText = "Code input")
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(state { createTextInputData(enabled = false) }), ThemeKeys.SearchIcon,
              placeholderText = "Disabled input with icon")
        }
      }
    }
  }

  example("Large TextInput") {
    Column {
      Row {
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(loremIpsum, style = extraLargeTextInputStyle())
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(), style = extraLargeTextInputStyle(), placeholderText = "Large input with placeholder")
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(state { createTextInputData(enabled = false) }),
              placeholderText = "Disabled large input with placeholder",
              style = extraLargeTextInputStyle())
        }
      }
      Spacer(Modifier.height(8.dp))
      Row {
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(), ThemeKeys.SearchIcon, placeholderText = "Input with icon",
              style = extraLargeTextInputStyle())
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(password = true), style = extraLargeTextInputStyle(), placeholderText = "Password input")
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(state { createTextInputData(enabled = false) }),
              ThemeKeys.SearchIcon,
              placeholderText = "Disabled large input with icon",
              style = extraLargeTextInputStyle())
        }
      }
    }
  }

  example("TextInput with Error") {
    Column {
      Row {
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(loremIpsum, style = errorTextInputStyle())
        }
        Spacer(Modifier.width(16.dp))
        withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(loremIpsum, style = extraLargeErrorTextInputStyle())
        }
      }
    }
  }

  example("Inner TextInput") {
    Column {
      Row {
        Row(
          Modifier.width(exampleInputDefaultWidth).padding(4.dp, 1.dp),
          verticalAlignment = Alignment.CenterVertically,
        ) {
          Icon(ThemeKeys.ChevronRightIcon)
          Spacer(Modifier.width(4.dp))
          textInput(loremIpsum, Modifier.weight(1f), style = innerTextInputStyle())
        }

        Spacer(Modifier.width(16.dp))

        Row(
          Modifier.width(exampleInputDefaultWidth).padding(4.dp, 1.dp),
          verticalAlignment = Alignment.CenterVertically,
        ) {
          Icon(ThemeKeys.ChevronRightIcon)
          Spacer(Modifier.width(4.dp))
          textInput(
            textInputModel(state { createTextInputData(enabled = false) }),
            Modifier.weight(1f),
            style = innerTextInputStyle(),
            placeholderText = "Disabled inner input",
          )
        }
      }
    }
  }

  example("Borderless TextInput") {
    Row(
      Modifier.width(exampleInputDefaultWidth)
        .padding(0.dp, 0.dp, 0.dp, 2.dp)
        .surface(
          theme[ThemeKeys.ToolBackground],
          Thickness.Regular,
          theme[ThemeKeys.Border],
          shape = RoundedCornerShape(4.dp)
        ),
      verticalAlignment = Alignment.CenterVertically,
    ) {
      GhostButton(ThemeKeys.LeftIcon) {}
      Spacer(Modifier.width(4.dp))
      textInput(loremIpsum, Modifier.weight(1f), style = borderlessTextInputStyle())
    }
  }

  example("Multiline TextInput with Scroll") {
    Row {
      withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(loremIpsum, textInputMode = TextInputMode.MultiLine(minLines = 3)))
      }
      Spacer(Modifier.width(16.dp))
      withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(
      textInputModel(textInputMode = TextInputMode.MultiLine(minLines = 3)),
      placeholderText = "MultiLine\nPlaceholder",
  )
      }
    }
  }


  example("Multiline TextInput with Wrap") {
    Row {
      withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(
    textInputModel(loremIpsum,
                        softWrapEnabled = true,
                        textInputMode = TextInputMode.MultiLine(minLines = 3))
  )
      }
      Spacer(Modifier.width(16.dp))
      withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(
      textInputModel(softWrapEnabled = true,
                        textInputMode = TextInputMode.MultiLine(minLines = 3)),
      placeholderText = "Placeholder that wraps! ".repeat(20),
  )
      }
    }
  }

  example("TextInput with Fixed Number of Lines") {
    Row {
      withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(loremIpsum,
                             softWrapEnabled = true,
                             textInputMode = TextInputMode.MultiLine(minLines = 3, maxLines = 3)))
      }
      Spacer(Modifier.width(16.dp))
      withModifier(Modifier.width(width = exampleInputDefaultWidth)) {
    textInput(textInputModel(softWrapEnabled = true,
                             textInputMode = TextInputMode.MultiLine(minLines = 3, maxLines = 3)),
              placeholderText = "Placeholder that wraps and scrolls! ".repeat(20))
      }
    }
  }

  example("Growing TextInput") {
    // we need to relax width constraints
    Box(contentAlignment = Alignment.TopStart) {
      textInput(textInputModel("Type here…", textInputMode = TextInputMode.OneLine))
    }
  }
}
