package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Constraints
import androidx.compose.ui.unit.dp
import fleet.compose.theme.LocalResourceReader
import fleet.compose.theme.components.Image
import fleet.compose.theme.components.PrimaryButton
import fleet.compose.theme.graphics.applyAlpha
import fleet.compose.theme.keys.ThemeKeys
import fleet.compose.theme.theme
import noria.scope
import noria.state
import fleet.compose.theme.components.Thickness
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.ui.components.scroll
import noria.ui.components.table.flexibleApproximationStrategyFactory
import noria.ui.components.table.lazyApproximationStrategyFactory
import noria.ui.components.table.lazyTable
import noria.ui.components.table.table
import fleet.compose.theme.components.UiText
import noria.ui.withModifier

internal fun tableViewExamples(): Gallery = gallery("TableView", NoriaExamples.sourceCodeForFile("TableView.kt")) {

  example("Table") {
    table(20) {
      for (y in 0..19) {
        scope("$y") {
          row {
            for (x in 0..19) {
              scope("$y $x") {
                if (y != 5 || x != 5) {
                  UiText((x * y).toString())
                }
                else {
                  Image(LocalResourceReader.current.read("gallery/kitty.jpg")!!.readBytes(), "jpg", modifier = Modifier.size(80.dp, 80.dp))
                }
              }
            }
          }
        }
      }
    }
  }

  example("Lazy Table") {
    withModifier(Modifier.size(width = 1200.dp, height = 1000.dp)) {
    scroll {
    lazyTable(height = 100, width = 100, stickyRows = 3,
                   rowStrategyFactory = lazyApproximationStrategyFactory(50),
                   columnStrategyFactory = lazyApproximationStrategyFactory(50),
                   getRowConstraints = { _ -> 25 to 25 },
                   getColumnConstraints = { _ -> 15 to Constraints.Infinity }) { y, x ->
      {
        UiText(
          (x * y).toString(),
          modifier = Modifier.background(theme[ThemeKeys.BackgroundPrimary]).border(Thickness.Regular, Color.Gray),
        )
      }
    }
  }
    }
  }

  example("Lazy Table") {
    withModifier(Modifier.size(width = 1200.dp, height = 1000.dp)) {
    scroll {
    lazyTable(height = 100, width = 100, stickyRows = 3,
                   rowStrategyFactory = lazyApproximationStrategyFactory(50),
                   columnStrategyFactory = lazyApproximationStrategyFactory(50),
                   getRowConstraints = { _ -> 25 to Constraints.Infinity },
                   getColumnConstraints = { _ -> 15 to Constraints.Infinity }) { y, x ->
      {
        withModifier(Modifier.background(theme[ThemeKeys.BackgroundPrimary]).border(Thickness.Regular, Color.Gray)) {
          val s = state { 0 }
          PrimaryButton(text = s.read().toString()) {
            s.update { x -> x + 1 }
          }
        }
      }
    }
  }
    }
  }

  example("Lazy Table With Big Items") {
    val sizeCell = state { 100.dp }
    Column {
      PrimaryButton(text = "Increase Size") {
        sizeCell.update { x ->
          (x * 3) / 2
        }
      }
      Box(
        Modifier
          .background(Color.Red.applyAlpha(.5f))
          .size(sizeCell.read())
      )
      withModifier(Modifier.size(width = 1200.dp, height = 1000.dp)) {
    scroll {
    lazyTable(height = 1000,
                   width = 100,
                   rowStrategyFactory = flexibleApproximationStrategyFactory(10),
                   columnStrategyFactory = flexibleApproximationStrategyFactory(10),
                   2,
                   3) { y, x ->
      {
        val color = when {
          y < 2 && x < 3 -> Color.Green
          y < 2 -> Color.Blue
          x < 3 -> Color.Cyan
          else -> Color.Red
        }
        Box(
          Modifier
            .background(theme[ThemeKeys.BackgroundPrimary])
            .padding(4.dp)
            .background(color.applyAlpha(.5f))
            .size(if (x == 5 && y == 6) sizeCell.read() else 100.dp)
        )
      }
    }
  }
      }
    }
  }
}
