package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.layout.LayoutCoordinates
import androidx.compose.ui.layout.onGloballyPositioned
import androidx.compose.ui.layout.positionInParent
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.Button
import fleet.compose.theme.density
import fleet.util.AtomicRef
import fleet.util.UID
import fleet.util.letIf
import noria.scope
import noria.state
import noria.ui.components.ScrollBarVisibility
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.modifiers.clickable
import noria.ui.components.scroll
import noria.ui.core.LocalScrollPreserverAnchor
import noria.ui.core.ScrollAnchor
import noria.ui.core.ScrollState
import noria.ui.core.scrollAnchorPreserver
import fleet.compose.theme.components.UiText
import noria.ui.withModifier

internal fun scrollPreserverExamples(): Gallery = gallery("Scroll Preserver", NoriaExamples.sourceCodeForFile("ScrollPreserver.kt")) {
  example("Sample") {
    val initialSequence = generateSequence { UID.random() }.take(10).toList()
    val items = state { initialSequence }
    val selectedItem = state<UID?> { null }

    Column {
      Button(text = "Add Item Above") {
        items.update {
          listOf(UID.random()) + it
        }
      }
      withModifier(Modifier.height(height = 600.dp)) {
    val scrollState = state { ScrollState.empty() }
 scroll(scrollState = scrollState, verticalScrollBarVisibility = ScrollBarVisibility.ALWAYS_VISIBLE) {
    scrollAnchorPreserver(scrollState) {
      Column {
        items.read().forEach { item ->
          scope(item) {

            val fillColor = Color.Blue.copy(alpha = 0.3f)
            val selected = selectedItem.read()
            withModifier(
              Modifier
                .clickable(onClick = { selectedItem.update { item } })
                .padding(horizontal = 8.dp, vertical = 4.dp)
                .letIf(
                  selectedItem.read() != null && selectedItem.read() == item) {
                  it.background(color = fillColor)
                }
                .size(width = 200.dp, height = 100.dp)
            ) {
              val coordinates = remember { AtomicRef<LayoutCoordinates?>(null) }
              withModifier(modifier = Modifier.onGloballyPositioned {
                coordinates.set(it)
              }) {
                if (selected != null && selected == item) {
                  LocalScrollPreserverAnchor.current?.set(
                    ScrollAnchor(selected, with(
                      density) { coordinates.get()!!.positionInParent().toDpOffset() }, coordinates))
                }

                Box(contentAlignment = Alignment.Center) {
                  UiText(item.id)
                }
              }
            }
          }
        }
      }
    }
  }
      }
    }
  }
}