package noria.ui.examples

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.sizeIn
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.LottieAnimation
import noria.ui.withModifier


internal fun lottieExample(): Gallery = gallery("Lottie Example", NoriaExamples.sourceCodeForFile("Lottie.kt")) {
  example("Particles") {
    val animationContent = """
        {"assets":[{"id":"comp_1","layers":[{"ao":0,"bm":0,"ddd":0,"ind":1,"ip":4.00000016292334,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":4},{"t":43.0000017514259}]},"p":{"a":1,"ix":2,"k":[{"e":[71,152,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":4,"ti":[85.1666641235352,-23.3333339691162,0],"to":[1.83333337306976,-220.66667175293,0]},{"t":43.0000017514259}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p20","op":364.000014826024,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0.901960790157,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":4.00000016292334,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":2,"ip":3.00000012219251,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":3},{"t":42.0000017106951}]},"p":{"a":1,"ix":2,"k":[{"e":[579,746,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":3,"ti":[27.1666660308838,-153.33332824707,0],"to":[101.833335876465,91.3333358764648,0]},{"t":42.0000017106951}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p19","op":363.000014785293,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":3.00000012219251,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":3,"ip":2.00000008146167,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":2},{"t":41.0000016699642}]},"p":{"a":1,"ix":2,"k":[{"e":[503,238,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":2,"ti":[-88.8333358764648,-45.3333320617676,0],"to":[-84.1666641235352,-74.6666641235352,0]},{"t":41.0000016699642}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p18","op":362.000014744562,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[0.074509806931,0.737254917622,0.172549024224,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":2.00000008146167,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":4,"ip":1.00000004073083,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":1},{"t":40.0000016292334}]},"p":{"a":1,"ix":2,"k":[{"e":[91,556,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":1,"ti":[73.1666641235352,-199.33332824707,0],"to":[-82.1666641235352,-112.666664123535,0]},{"t":40.0000016292334}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p17","op":361.000014703831,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":1.00000004073083,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":5,"ip":0,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":0},{"t":39.0000015885026}]},"p":{"a":1,"ix":2,"k":[{"e":[511,308,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":0,"ti":[51.1666679382324,60.6666679382324,0],"to":[77.8333358764648,91.3333358764648,0]},{"t":39.0000015885026}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p16","op":360.000014663101,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[0.270588248968,0.529411792755,0.952941179276,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":0,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":6,"ip":1.00000004073083,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":1},{"t":40.0000016292334}]},"p":{"a":1,"ix":2,"k":[{"e":[155,280,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":1,"ti":[95.1666641235352,-53.3333320617676,0],"to":[-30.1666660308838,-122.666664123535,0]},{"t":40.0000016292334}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p15","op":361.000014703831,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0.901960790157,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":1.00000004073083,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":7,"ip":2.00000008146167,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":2},{"t":41.0000016699642}]},"p":{"a":1,"ix":2,"k":[{"e":[681,388.872,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":2,"ti":[-58.8333320617676,48.6666679382324,0],"to":[143.83332824707,49.3333320617676,0]},{"t":41.0000016699642}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p14","op":362.000014744562,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":2.00000008146167,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":8,"ip":3.00000012219251,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":3},{"t":42.0000017106951}]},"p":{"a":1,"ix":2,"k":[{"e":[257,284,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":3,"ti":[75.1666641235352,-5.33333349227905,0],"to":[-24.1666660308838,-72.6666641235352,0]},{"t":42.0000017106951}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p13","op":363.000014785293,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[0.074509806931,0.737254917622,0.172549024224,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":3.00000012219251,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":9,"ip":4.00000016292334,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":4},{"t":43.0000017514259}]},"p":{"a":1,"ix":2,"k":[{"e":[301,474,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":4,"ti":[65.1666641235352,-13.3333330154419,0],"to":[-14.1666669845581,31.3333339691162,0]},{"t":43.0000017514259}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p12","op":364.000014826024,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":4.00000016292334,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":10,"ip":0,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":0},{"t":39.0000015885026}]},"p":{"a":1,"ix":2,"k":[{"e":[499,570,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":0,"ti":[-62.8333320617676,-29.3333339691162,0],"to":[-8.16666698455811,63.3333320617676,0]},{"t":39.0000015885026}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p11","op":360.000014663101,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[0.270588248968,0.529411792755,0.952941179276,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":0,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":11,"ip":1.00000004073083,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":1},{"t":40.0000016292334}]},"p":{"a":1,"ix":2,"k":[{"e":[557,68,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":1,"ti":[-58.8333320617676,104.666664123535,0],"to":[81.8333358764648,-104.666664123535,0]},{"t":40.0000016292334}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p10","op":361.000014703831,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0.901960790157,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":1.00000004073083,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":12,"ip":2.00000008146167,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":2},{"t":41.0000016699642}]},"p":{"a":1,"ix":2,"k":[{"e":[715,138,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":2,"ti":[-26.8333339691162,72.6666641235352,0],"to":[151.83332824707,-46.6666679382324,0]},{"t":41.0000016699642}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p9","op":362.000014744562,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":2.00000008146167,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":13,"ip":3.00000012219251,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":3},{"t":42.0000017106951}]},"p":{"a":1,"ix":2,"k":[{"e":[679,664,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":3,"ti":[-92.8333358764648,-103.333335876465,0],"to":[107.833335876465,89.3333358764648,0]},{"t":42.0000017106951}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p8","op":363.000014785293,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[0.074509806931,0.737254917622,0.172549024224,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":3.00000012219251,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":14,"ip":4.00000016292334,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":4},{"t":43.0000017514259}]},"p":{"a":1,"ix":2,"k":[{"e":[97,686,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":4,"ti":[75.1666641235352,-39.3333320617676,0],"to":[-36.1666679382324,53.3333320617676,0]},{"t":43.0000017514259}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p7","op":364.000014826024,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":4.00000016292334,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":15,"ip":5.00000020365417,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":5},{"t":44.0000017921567}]},"p":{"a":1,"ix":2,"k":[{"e":[65,340,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":5,"ti":[61.1666679382324,-65.3333358764648,0],"to":[-148.16667175293,-132.66667175293,0]},{"t":44.0000017921567}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p6","op":365.000014866755,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[0.270588248968,0.529411792755,0.952941179276,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":5.00000020365417,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":16,"ip":6.00000024438501,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":6},{"t":45.0000018328876}]},"p":{"a":1,"ix":2,"k":[{"e":[400,23.613,0],"i":{"x":0.004,"y":0.691},"n":"0p004_0p691_0p014_0","o":{"x":0.014,"y":0},"s":[400,400,0],"t":6,"ti":[27.0301876068115,124.269813537598,0],"to":[-55.3803939819336,-168.204071044922,0]},{"t":45.0000018328876}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p5","op":366.000014907486,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0.901960790157,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":6.00000024438501,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":17,"ip":7.00000028511585,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":7},{"t":46.0000018736184}]},"p":{"a":1,"ix":2,"k":[{"e":[303,660,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":7,"ti":[97.1666641235352,0.66666668653488,0],"to":[109.833335876465,69.3333358764648,0]},{"t":46.0000018736184}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p4","op":367.000014948216,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":7.00000028511585,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":18,"ip":8.00000032584668,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":8},{"t":47.0000019143492}]},"p":{"a":1,"ix":2,"k":[{"e":[663,498,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":8,"ti":[-71.8333358764648,39.6666679382324,0],"to":[41.8333320617676,109.333335876465,0]},{"t":47.0000019143492}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p3","op":368.000014988947,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[0.076272718608,0.735462605953,0.171031266451,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":8.00000032584668,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":19,"ip":9.00000036657752,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":9},{"t":48.0000019550801}]},"p":{"a":1,"ix":2,"k":[{"e":[187,88,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":9,"ti":[89.1666641235352,6.66666650772095,0],"to":[-0.16666667163372,-158.66667175293,0]},{"t":48.0000019550801}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p2","op":369.000015029678,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[0.271778345108,0.528400123119,0.952267169952,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":9.00000036657752,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":20,"ip":0,"ks":{"a":{"a":0,"ix":1,"k":[0,0,0]},"o":{"a":1,"ix":11,"k":[{"e":[0],"i":{"x":[1],"y":[1]},"n":["1_1_0p01_0"],"o":{"x":[0.01],"y":[0]},"s":[100],"t":0},{"t":39.0000015885026}]},"p":{"a":1,"ix":2,"k":[{"e":[621,234,0],"i":{"x":0,"y":1},"n":"0_1_0p01_0","o":{"x":0.01,"y":0},"s":[400,400,0],"t":0,"ti":[-92.8333358764648,-103.333335876465,0],"to":[-0.16666667163372,-158.66667175293,0]},{"t":39.0000015885026}]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[100,100,100]}},"nm":"p1","op":360.000014663101,"shapes":[{"cix":2,"hd":false,"it":[{"hd":false,"ind":0,"ix":1,"ks":{"a":0,"ix":2,"k":{"c":true,"i":[[7.855,0],[0,-7.855],[-7.855,0],[0,7.855]],"o":[[-7.855,0],[0,7.855],[7.855,0],[0,-7.855]],"v":[[0,-14.223],[-14.223,0],[0,14.223],[14.223,0]]}},"mn":"ADBE Vector Shape - Group","nm":"Tracé 1","ty":"sh"},{"c":{"a":0,"ix":4,"k":[1,0.903676450253,0,1]},"hd":false,"mn":"ADBE Vector Graphic - Fill","nm":"Fond 1","o":{"a":0,"ix":5,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transformer ","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[0,0]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[80,80]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":0,"ty":4}]}],"ddd":0,"fr":29.9700012207031,"h":800,"ip":0,"layers":[{"ao":0,"bm":0,"ddd":0,"h":800,"ind":1,"ip":9.00000036657752,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[396,400,0]},"r":{"a":0,"ix":10,"k":42},"s":{"a":0,"ix":6,"k":[91.5,91.5,100]}},"nm":"confettis1","op":369.000015029678,"refId":"comp_1","sr":1,"st":9.00000036657752,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":2,"ip":7.00000028511585,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[416,420,0]},"r":{"a":0,"ix":10,"k":267},"s":{"a":0,"ix":6,"k":[64.5,64.5,100]}},"nm":"confettis1","op":367.000014948216,"refId":"comp_1","sr":1,"st":7.00000028511585,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":3,"ip":5.00000020365417,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[436,400,0]},"r":{"a":0,"ix":10,"k":358},"s":{"a":0,"ix":6,"k":[64.5,64.5,100]}},"nm":"confettis1","op":365.000014866755,"refId":"comp_1","sr":1,"st":5.00000020365417,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":4,"ip":3.00000012219251,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[416,380,0]},"r":{"a":0,"ix":10,"k":177},"s":{"a":0,"ix":6,"k":[64.5,64.5,100]}},"nm":"confettis1","op":363.000014785293,"refId":"comp_1","sr":1,"st":3.00000012219251,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":5,"ip":1.00000004073083,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[416,400,0]},"r":{"a":0,"ix":10,"k":132},"s":{"a":0,"ix":6,"k":[91.5,91.5,100]}},"nm":"confettis1","op":361.000014703831,"refId":"comp_1","sr":1,"st":1.00000004073083,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":6,"ip":8.00000032584668,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[396,400,0]},"r":{"a":0,"ix":10,"k":-90},"s":{"a":0,"ix":6,"k":[91.5,91.5,100]}},"nm":"confettis1","op":368.000014988947,"refId":"comp_1","sr":1,"st":8.00000032584668,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":7,"ip":6.00000024438501,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[416,420,0]},"r":{"a":0,"ix":10,"k":135},"s":{"a":0,"ix":6,"k":[64.5,64.5,100]}},"nm":"confettis1","op":366.000014907486,"refId":"comp_1","sr":1,"st":6.00000024438501,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":8,"ip":4.00000016292334,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[436,400,0]},"r":{"a":0,"ix":10,"k":226},"s":{"a":0,"ix":6,"k":[64.5,64.5,100]}},"nm":"confettis1","op":364.000014826024,"refId":"comp_1","sr":1,"st":4.00000016292334,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":9,"ip":2.00000008146167,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[416,380,0]},"r":{"a":0,"ix":10,"k":45},"s":{"a":0,"ix":6,"k":[64.5,64.5,100]}},"nm":"confettis1","op":362.000014744562,"refId":"comp_1","sr":1,"st":2.00000008146167,"ty":0,"w":800},{"ao":0,"bm":0,"ddd":0,"h":800,"ind":10,"ip":0,"ks":{"a":{"a":0,"ix":1,"k":[400,400,0]},"o":{"a":0,"ix":11,"k":100},"p":{"a":0,"ix":2,"k":[416,400,0]},"r":{"a":0,"ix":10,"k":0},"s":{"a":0,"ix":6,"k":[91.5,91.5,100]}},"nm":"confettis1","op":360.000014663101,"refId":"comp_1","sr":1,"st":0,"ty":0,"w":800}],"nm":"confettis2","op":59.0000024031193,"v":"4.12.0","w":800}
        """.trimIndent()
    Column {
      withModifier(Modifier.sizeIn(maxWidth = 400.dp, maxHeight = 400.dp)) {
    LottieAnimation(animationContent)
      }
    }
  }

  example("Dots") {
    val animationContent = """
        {"assets":[],"ddd":0,"fr":29.9700012207031,"h":256,"ip":0,"layers":[{"ao":0,"bm":0,"ddd":0,"ind":1,"ip":0,"ks":{"a":{"a":0,"k":[-70,-0.5,0]},"o":{"a":0,"k":100},"p":{"a":1,"k":[{"e":[208.6,88,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[208.6,127.969,0],"t":20,"ti":[0,-0.00520833348855,0],"to":[0,-6.66145849227905,0]},{"e":[208.6,128,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[208.6,88,0],"t":30,"ti":[0,-6.66666650772095,0],"to":[0,0.00520833348855,0]},{"t":40.0000016292334}]},"r":{"a":0,"k":0},"s":{"a":0,"k":[75,75,100]}},"nm":"Shape Layer 3","op":300.00001221925,"shapes":[{"cix":2,"it":[{"d":1,"mn":"ADBE Vector Shape - Ellipse","nm":"Ellipse Path 1","p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[33.75,34.5]},"ty":"el"},{"c":{"a":0,"k":[0.9843137,0.5490196,0,1]},"mn":"ADBE Vector Graphic - Fill","nm":"Fill 1","o":{"a":0,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transform","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[-70.125,-0.5]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[100,100]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":0,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":2,"ip":0,"ks":{"a":{"a":0,"k":[-70,-0.5,0]},"o":{"a":0,"k":100},"p":{"a":1,"k":[{"e":[168.6,88,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[168.6,128,0],"t":15,"ti":[0,0,0],"to":[0,-6.66666650772095,0]},{"e":[168.6,128,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[168.6,88,0],"t":25,"ti":[0,-6.66666650772095,0],"to":[0,0,0]},{"t":35.0000014255792}]},"r":{"a":0,"k":0},"s":{"a":0,"k":[75,75,100]}},"nm":"Shape Layer 2","op":300.00001221925,"shapes":[{"cix":2,"it":[{"d":1,"mn":"ADBE Vector Shape - Ellipse","nm":"Ellipse Path 1","p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[33.75,34.5]},"ty":"el"},{"c":{"a":0,"k":[0.9921569,0.8470588,0.2078431,1]},"mn":"ADBE Vector Graphic - Fill","nm":"Fill 1","o":{"a":0,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transform","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[-70.125,-0.5]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[100,100]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":0,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":3,"ip":0,"ks":{"a":{"a":0,"k":[-70,-0.5,0]},"o":{"a":0,"k":100},"p":{"a":1,"k":[{"e":[128.594,88,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[128.594,127.969,0],"t":10,"ti":[0,-0.00520833348855,0],"to":[0,-6.66145849227905,0]},{"e":[128.594,128,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[128.594,88,0],"t":20,"ti":[0,-6.66666650772095,0],"to":[0,0.00520833348855,0]},{"t":30.0000012219251}]},"r":{"a":0,"k":0},"s":{"a":0,"k":[75,75,100]}},"nm":"Shape Layer 1","op":300.00001221925,"shapes":[{"cix":2,"it":[{"d":1,"mn":"ADBE Vector Shape - Ellipse","nm":"Ellipse Path 1","p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[33.75,34.5]},"ty":"el"},{"c":{"a":0,"k":[0.2627451,0.627451,0.2784314,1]},"mn":"ADBE Vector Graphic - Fill","nm":"Fill 1","o":{"a":0,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transform","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[-70.125,-0.5]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[100,100]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":0,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":4,"ip":0,"ks":{"a":{"a":0,"k":[-70,-0.5,0]},"o":{"a":0,"k":100},"p":{"a":1,"k":[{"e":[88.6,88,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[88.6,127.969,0],"t":5,"ti":[0,-0.00520833348855,0],"to":[0,-6.66145849227905,0]},{"e":[88.6,128,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[88.6,88,0],"t":15,"ti":[0,-6.66666650772095,0],"to":[0,0.00520833348855,0]},{"t":25.0000010182709}]},"r":{"a":0,"k":0},"s":{"a":0,"k":[75,75,100]}},"nm":"Shape Layer 4","op":300.00001221925,"shapes":[{"cix":2,"it":[{"d":1,"mn":"ADBE Vector Shape - Ellipse","nm":"Ellipse Path 1","p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[33.75,34.5]},"ty":"el"},{"c":{"a":0,"k":[0.1176471,0.5333334,0.8980392,1]},"mn":"ADBE Vector Graphic - Fill","nm":"Fill 1","o":{"a":0,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transform","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[-70.125,-0.5]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[100,100]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":0,"ty":4},{"ao":0,"bm":0,"ddd":0,"ind":5,"ip":0,"ks":{"a":{"a":0,"k":[-70,-0.5,0]},"o":{"a":0,"k":100},"p":{"a":1,"k":[{"e":[48.6,88,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[48.6,127.969,0],"t":0,"ti":[0,-0.00520833348855,0],"to":[0,-6.66145849227905,0]},{"e":[48.6,128,0],"i":{"x":0.667,"y":1},"n":"0p667_1_0p333_0","o":{"x":0.333,"y":0},"s":[48.6,88,0],"t":10,"ti":[0,-6.66666650772095,0],"to":[0,0.00520833348855,0]},{"t":20.0000008146167}]},"r":{"a":0,"k":0},"s":{"a":0,"k":[75,75,100]}},"nm":"Shape Layer 5","op":300.00001221925,"shapes":[{"cix":2,"it":[{"d":1,"mn":"ADBE Vector Shape - Ellipse","nm":"Ellipse Path 1","p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[33.75,34.5]},"ty":"el"},{"c":{"a":0,"k":[0.8980392,0.2235294,0.2078431,1]},"mn":"ADBE Vector Graphic - Fill","nm":"Fill 1","o":{"a":0,"k":100},"r":1,"ty":"fl"},{"a":{"a":0,"ix":1,"k":[0,0]},"nm":"Transform","o":{"a":0,"ix":7,"k":100},"p":{"a":0,"ix":2,"k":[-70.125,-0.5]},"r":{"a":0,"ix":6,"k":0},"s":{"a":0,"ix":3,"k":[100,100]},"sa":{"a":0,"ix":5,"k":0},"sk":{"a":0,"ix":4,"k":0},"ty":"tr"}],"ix":1,"mn":"ADBE Vector Group","nm":"Ellipse 1","np":3,"ty":"gr"}],"sr":1,"st":0,"ty":4}],"nm":"Comp 1","op":40.0000016292334,"v":"4.6.8","w":256}
        """.trimIndent()
    Column {
      withModifier(Modifier.sizeIn(maxWidth = 400.dp, maxHeight = 400.dp)) {
    LottieAnimation(animationContent)
      }
    }
  }
}