package noria.ui.examples

import noria.ui.components.awt.html
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.theme
import fleet.compose.theme.graphics.toStringNoAlpha
import fleet.compose.theme.text.textSpec
import fleet.compose.theme.keys.TextStyleKeys
import fleet.compose.theme.keys.ThemeKeys
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp

internal fun htmlExample(): Gallery = gallery("HTML", NoriaExamples.sourceCodeForFile("HtmlExample.kt")) {
  example("HTML") {
    html("""<html>
              <body>
                <h1>Header</h1>
                <p>
                Some text, <code>some code Wi123!=abc</code>, <strong>some strong</strong>,  <b>some bold</b>, <i>some italics</i>, FL-21756
                </p>
                <p>
                <s>s tag</s>
                <p>
                <strike>strike tag</strike>
                <p>
                <a href="some://url">Some link</a>
              </body>
            </html>""".trimMargin()
    ) {
      println("Link clicked: $it")
    }
  }

  example("HTML with Style Sheet") {
    val textColor = theme[ThemeKeys.TextPrimary].toStringNoAlpha()
    val textSpec = textSpec(TextStyleKeys.Code)
    val codeFontStyles = """
      font-family: ${textSpec.fontSpec.family};
      font-size: ${textSpec.fontSpec.size.value}px;
      font-style: ${if (textSpec.fontSpec.italic) "italic" else "normal"};
      font-weight: ${textSpec.fontSpec.weight};
      line-height: ${textSpec.lineHeight ?: "normal"}
      letter-spacing: ${if (textSpec.letterSpacing == 0.sp) "normal" else "${textSpec.letterSpacing.value}px"}
      word-spacing: ${if (textSpec.wordSpacing == 0.sp) "normal" else "${textSpec.wordSpacing.value}px"};
    """.trimIndent()
    val linkTextColor = theme[ThemeKeys.LinkTextDefault].toStringNoAlpha()
    val separatorColor = theme[ThemeKeys.SeparatorDefault].toStringNoAlpha()
    val separatorStyle = "border-top: ${1.dp.value}px solid $separatorColor;"
    html("""<html>
              <body>
                <h1>Header</h1>
                <p>
                Some text, <code>some code Wi123!=abc</code>, <strong>some strong</strong>,  <b>some bold</b>, <i>some italics</i>
                </p>
                <p>
                <s>s tag</s>
                <p>
                <strike>strike tag</strike>
                <p>
                <a href="some://url">Some link</a>
              </body>
            </html>""".trimMargin(),
         styleSheet = """
              body {
                color: $textColor;
                overflow-wrap: anywhere;
                white-space: pre-wrap;
              }
              h1,
              h2,
              h3,
              h4,
              h5,
              section {
                margin-left: ${20.dp.value}px;
              }
              pre,
              p,
                  code {
                $codeFontStyles
              }
              pre,
              table {
                margin-top: ${12.dp.value}px;
              }
              td p {
                margin-top: 0;
                overflow-wrap: normal;
              }
              a {
                color: $linkTextColor;
              }
              .definition pre {
                margin: 0;
              }
              .bottom {
                margin-top: ${16.dp.value}px;
              }
              hr {
                border: none;
                margin: none;
                padding: none;
                margin-top: ${8.dp.value}px;
                margin-bottom: ${8.dp.value}px;
                $separatorStyle
              }
              s {
                text-decoration: line-through
              }
              strong {
                font-weight: bold;
              }
            """.trimIndent()

    ) {
      println("Link clicked: $it")
    }
  }
}
