package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.*
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import noria.NoriaContext
import noria.model.ActionContext
import fleet.compose.theme.components.MenuItem
import fleet.compose.theme.components.Thickness
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.withMenu
import fleet.compose.theme.theme
import fleet.compose.theme.components.UiText
import fleet.compose.theme.keys.TextStyleKeys
import fleet.compose.theme.keys.ThemeKeys

internal fun contextMenuTestExamples(): Gallery = gallery("Context Menus", NoriaExamples.sourceCodeForFile("ContextMenus.kt")) {
  example("Submenu Delay Comparison") {

    val itemsBuilder: @Composable NoriaContext.(ActionContext) -> List<MenuItem> = {
      listOf(
        MenuItem.Header("Menu"),
        MenuItem.Action("New File") { },
        MenuItem.Action("New Folder") { },
        MenuItem.Separator,
        MenuItem.Group(
          "Refactor",
          MenuItem.Action("Rename") { },
          MenuItem.Action("Delete") { },
          MenuItem.Action("Move to Folder…") { },
          MenuItem.Action("Move to Package…") { },
        ),
        MenuItem.Group(
          "Open In",
          MenuItem.Action("Finder") { },
          MenuItem.Action("Terminal") { },
          MenuItem.Action("Tabs") { },
        ),
        MenuItem.Group(
          "Git",
          MenuItem.Action("Add") { },
          MenuItem.Action("Remove") { },
          MenuItem.Action("Add to .gitigonre") { },
        ),
        MenuItem.Action("Copy") { },
        MenuItem.Action("Copy Path") { },
        MenuItem.Action("Copy Relative Path") { }
      )
    }

    Column {
      UiText("Right click:", textStyleKey = TextStyleKeys.Header3)
      Spacer(Modifier.height(8.dp))
      Row {
        withMenu(itemsBuilder, 133) {
          UiText(
            "133 ms (current)",
            modifier = Modifier
              .background(theme[ThemeKeys.SecondaryButtonBackgroundDefault])
              .border(Thickness.Regular, theme[ThemeKeys.SecondaryButtonBorderDefault]),
          )
        }
        Spacer(Modifier.width(16.dp))
        withMenu(itemsBuilder, 250) {
          UiText(
            "250 ms",
            modifier = Modifier
              .background(theme[ThemeKeys.SecondaryButtonBackgroundDefault])
              .border(Thickness.Regular, theme[ThemeKeys.SecondaryButtonBorderDefault])
          )
        }
        Spacer(Modifier.width(16.dp))
        withMenu(itemsBuilder, 60) {
          UiText(
            "60 ms",
            modifier = Modifier
              .background(theme[ThemeKeys.SecondaryButtonBackgroundDefault])
              .border(Thickness.Regular, theme[ThemeKeys.SecondaryButtonBorderDefault])
          )
        }
        Spacer(Modifier.width(16.dp))
        withMenu(itemsBuilder, 33) {
          UiText(
            "30 ms (~2 frames)",
            modifier = Modifier
              .background(theme[ThemeKeys.SecondaryButtonBackgroundDefault])
              .border(Thickness.Regular, theme[ThemeKeys.SecondaryButtonBorderDefault])
          )
        }
        Spacer(Modifier.width(16.dp))
        withMenu(itemsBuilder, 17) {
          UiText(
            "17 ms (~1 frame)",
            modifier = Modifier
              .background(theme[ThemeKeys.SecondaryButtonBackgroundDefault])
              .border(Thickness.Regular, theme[ThemeKeys.SecondaryButtonBorderDefault])
          )
        }
        Spacer(Modifier.width(16.dp))
        withMenu(itemsBuilder, 6) {
          UiText(
            "6 ms",
            modifier = Modifier
              .background(theme[ThemeKeys.SecondaryButtonBackgroundDefault])
              .border(Thickness.Regular, theme[ThemeKeys.SecondaryButtonBorderDefault])
          )
        }
        Spacer(Modifier.width(16.dp))
        withMenu(itemsBuilder, 0) {
          UiText(
            "0 ms",
            modifier = Modifier
              .background(theme[ThemeKeys.SecondaryButtonBackgroundDefault])
              .border(Thickness.Regular, theme[ThemeKeys.SecondaryButtonBorderDefault])
          )
        }
        Spacer(Modifier.width(16.dp))
      }
    }
  }
}
