package noria.ui.examples

import androidx.compose.foundation.layout.Arrangement.spacedBy
import androidx.compose.foundation.layout.Column
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.UiText
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.state
import noria.ui.core.AlertDialogAction
import noria.ui.core.DoNotAsk
import noria.ui.core.alertDialog

internal fun alertsExamples(): Gallery = gallery("Alerts", NoriaExamples.sourceCodeForFile("Alerts.kt")) {
  example("Alerts") {
    Column(verticalArrangement = spacedBy(4.dp)) {
      alertDialog(
        title = "Select Home Directory for JDK",
        message = "The selected directory is not a valid home for JDK",
        actions = arrayOf(AlertDialogAction.Confirm("OK")),
        doNotAskCell = null,
        onAction = { }
      )
      UiText("One button")

      alertDialog(
        title = "Install Required Plugins",
        message = "The ‘PHP Support’ plugin requires the ‘PHP‘ and ‘Ini‘ plugins to be installed",
        actions = arrayOf(AlertDialogAction.Cancel("Cancel"), AlertDialogAction.Confirm("Install")),
        doNotAskCell = null,
        onAction = { }
      )
      UiText("Two buttons")

      alertDialog(
        title = "Copy Files",
        message = "File ‘readme.md’ already exists in directory ‘/Users/username/IdeaProjects/ProjectName/src’",
        actions = arrayOf(
          AlertDialogAction.Custom("Skip for All"),
          AlertDialogAction.Cancel("Overwrite for All"),
          AlertDialogAction.Cancel("Skip"),
          AlertDialogAction.Confirm("Overwrite")
        ),
        doNotAskCell = null,
        onAction = { }
      )
      UiText("Four buttons")

      alertDialog(
        title = "Open Workspace",
        message = "Where would you like to open the worksapce ‘demontrationProject1’?",
        doNotAskCell = state { DoNotAsk(true) },
        actions = arrayOf(AlertDialogAction.Custom("New Wnidow"), AlertDialogAction.Confirm("This Window")),
        onAction = { }
      )
      UiText("With checkbox")

      alertDialog(
        title = "Remove Folder from Workspace",
        message = "Do you want to remove `folder-name` from the workspace?",
        actions = arrayOf(AlertDialogAction.Cancel("Cancel"), AlertDialogAction.Confirm("Remove", dangerous = true)),
        doNotAskCell = null,
        onAction = { }
      )
      UiText("Dangerous")

      alertDialog(
        title = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mollis tortor ut risus tristique, in hendrerit nisl elementum. In consequat vehicula nibh, eu ullamcorper ante placerat a. Praesent at felis congue nibh viverra facilisis. Integer condimentum ac risus eget lobortis. Integer dapibus consectetur eros ullamcorper aliquet. ",
        message = "The selected directory is not a valid home for JDK",
        actions = arrayOf(AlertDialogAction.Confirm("OK")),
        doNotAskCell = null,
        onAction = { }
      )
      UiText("Long title")

      alertDialog(
        title = "Select Home Directory for JDK",
        message = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mollis tortor ut risus tristique, in hendrerit nisl elementum. In consequat vehicula nibh, eu ullamcorper ante placerat a. Praesent at felis congue nibh viverra facilisis. Integer condimentum ac risus eget lobortis. Integer dapibus consectetur eros ullamcorper aliquet. Etiam maximus at mauris ac consectetur. Suspendisse potenti. Suspendisse potenti. Ut ut ornare leo, vel fermentum eros. Nulla non dignissim sem. Suspendisse id augue posuere, tincidunt justo non, tempus quam. Curabitur arcu eros, auctor non lorem non, cursus feugiat leo. Nulla nec tortor lectus. Ut venenatis luctus mauris. Nulla ut auctor justo. Curabitur sit amet neque risus.",
        actions = arrayOf(AlertDialogAction.Confirm("OK")),
        doNotAskCell = null,
        onAction = { }
      )
      UiText("Long text")
    }
  }
}