package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.Button
import noria.StateCell
import noria.state
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import noria.ui.components.split.*
import fleet.compose.theme.components.UiText
import noria.ui.withModifier

internal fun splitExamples(): Gallery = gallery("Split", NoriaExamples.sourceCodeForFile("Split.kt")) {
  example("Part Preserving Split. Second") {
    Column {
      val firstVisibility = state { true }
      val secondVisibility = state { true }
      Row {
        fun action(flag: StateCell<Boolean>) = if (flag.read()) "Hide" else "Show"
        Button(text = "${action(firstVisibility)} first") { firstVisibility.update { !it } }
        Spacer(Modifier.width(16.dp))
        Button(text = "${action(secondVisibility)} second") { secondVisibility.update { !it } }
      }
      Spacer(Modifier.height(16.dp))
      withModifier(Modifier.height(height = 400.dp)) {
    splitView(SplitDirection.HORIZONTAL,
                 stretchPolicy = StretchPolicy.PartPreserve(
                   SplitPart.SECOND,
                   initialPartLength = 200.dp,
                   minPartLength = 200.dp)) {
    first(firstVisibility) {
      Column(modifier = Modifier.background(Color.Blue)) {
        UiText("${"Long ".repeat(10)}Text")
        Spacer(Modifier.size(width = Dp.Infinity, height = Dp.Infinity))
      }
    }
    second(secondVisibility) {
      Column(modifier = Modifier.background(Color.Red)) {
        UiText("${"Long ".repeat(10)}Text")
        Spacer(Modifier.size(width = Dp.Infinity, height = Dp.Infinity))
      }
    }
  }
      }
    }
  }
  example("Animated Part Preserving Split. First") {
    Column {
      val firstVisibility = state { true }
      val secondVisibility = state { true }
      Row {
        fun action(flag: StateCell<Boolean>) = if (flag.read()) "Hide" else "Show"
        Button(text = "${action(firstVisibility)} first") { firstVisibility.update { !it } }
        Spacer(Modifier.width(16.dp))
        Button(text = "${action(secondVisibility)} second") { secondVisibility.update { !it } }
      }
      Spacer(Modifier.height(16.dp))
      withModifier(Modifier.height(height = 400.dp)) {
    splitView(SplitDirection.HORIZONTAL,
                 stretchPolicy = StretchPolicy.PartPreserve(
                   SplitPart.FIRST,
                   initialPartLength = 200.dp,
                   minPartLength = 200.dp,
                   animation = SplitAnimation()
                 )) {
    first(firstVisibility) {
      Column(modifier = Modifier.background(Color.Gray)) {
        UiText("${"Long ".repeat(10)}Text")
        Spacer(Modifier.size(width = Dp.Infinity, height = Dp.Infinity))
      }
    }
    second(secondVisibility) {
      Spacer(Modifier.background(Color.Red)
                    .size(width = Dp.Infinity, height = Dp.Infinity))
    }
  }
      }
    }
  }
  example("Ratio Split") {
    Column {
      val preferredWidth = state { 200.dp }
      val isFirstVisible = state { true }
      val isSecondVisible = state { true }
      val difference = 40.dp
      Row {
        fun action(flag: StateCell<Boolean>) = if (flag.read()) "Hide" else "Show"
        Button(text = "${action(isFirstVisible)} first") { isFirstVisible.update { !it } }
        Spacer(Modifier.width(16.dp))
        Button(text = "${action(isSecondVisible)} second") { isSecondVisible.update { !it } }
      }
      Spacer(Modifier.height(16.dp))
      Row {
        Button(text = "width - ${difference}") { preferredWidth.update { it - difference } }
        Spacer(Modifier.width(16.dp))
        Button(text = "width + ${difference}") { preferredWidth.update { it + difference } }
      }
      Spacer(Modifier.height(16.dp))
      withModifier(Modifier.size(width = preferredWidth.read(), height = 200.dp)) {
    splitView(SplitDirection.HORIZONTAL,
                 stretchPolicy = StretchPolicy.Ratio(initialRatio = 0.5f)) {
    first(isFirstVisible) {
      Spacer(Modifier.background(Color.Blue).size(width = Dp.Infinity, height = Dp.Infinity))
    }
    second(isSecondVisible) {
      Spacer(Modifier.background(Color.Red).size(width = Dp.Infinity, height = Dp.Infinity))
    }
  }
      }
    }
  }
  example("Ratio Split Snapping") {
    Column {
      val preferredWidth = state { 800.dp }
      val isFirstVisible = state { true }
      val isSecondVisible = state { true }
      val difference = 40.dp
      Row {
        fun action(flag: StateCell<Boolean>) = if (flag.read()) "Hide" else "Show"
        Button(text = "${action(isFirstVisible)} first") { isFirstVisible.update { !it } }
        Spacer(Modifier.width(16.dp))
        Button(text = "${action(isSecondVisible)} second") { isSecondVisible.update { !it } }
      }
      Spacer(Modifier.height(16.dp))
      Row {
        Button(text = "width - ${difference}") { preferredWidth.update { it - difference } }
        Spacer(Modifier.width(16.dp))
        Button(text = "width + ${difference}") { preferredWidth.update { it + difference } }
      }
      Spacer(Modifier.height(16.dp))
      withModifier(Modifier.size(width = preferredWidth.read(), height = 200.dp)) {
    splitView(SplitDirection.HORIZONTAL,
                 stretchPolicy = StretchPolicy.Ratio(initialRatio = 0.5f, minRatio = 0.33f, snap = StretchPolicy.Snap.Active(0.5f),
                                                     animation = SplitAnimation())) {
    first(isFirstVisible) {
      Spacer(Modifier.background(Color.Blue).size(width = Dp.Infinity, height = Dp.Infinity))
    }
    second(isSecondVisible) {
      Spacer(Modifier.background(Color.Red).size(width = Dp.Infinity, height = Dp.Infinity))
    }
  }
      }
    }
  }
  example("Part Preserving Split") {
    Column {
      UiText("First Preserve Part")
      withModifier(Modifier.height(height = 400.dp)) {
    splitView(SplitDirection.HORIZONTAL,
                 stretchPolicy = StretchPolicy.PartPreserve(SplitPart.FIRST, initialPartLength = 80.dp,
                                                            minPartLength = 80.dp)) {
    first {
      Spacer(Modifier.background(Color.Blue).size(width = Dp.Infinity, height = Dp.Infinity))
    }
    second {
      Spacer(Modifier.background(Color.Red).size(width = Dp.Infinity, height = Dp.Infinity))
    }
  }
      }
      UiText("Second Preserve Part")
      withModifier(Modifier.height(height = 400.dp)) {
    splitView(SplitDirection.HORIZONTAL,
                 stretchPolicy = StretchPolicy.PartPreserve(SplitPart.SECOND, initialPartLength = 80.dp,
                                                            minPartLength = 80.dp)) {
    first {
      Spacer(Modifier.background(Color.Blue).size(width = Dp.Infinity, height = Dp.Infinity))
    }
    second {
      Spacer(Modifier.background(Color.Red).size(width = Dp.Infinity, height = Dp.Infinity))
    }
  }
      }
      UiText("First Preserve Part")
      withModifier(Modifier.height(height = 400.dp)) {
    splitView(SplitDirection.VERTICAL,
                 stretchPolicy = StretchPolicy.PartPreserve(SplitPart.FIRST, initialPartLength = 80.dp,
                                                            minPartLength = 80.dp)) {
    first {
      Spacer(Modifier.background(Color.Blue).size(width = Dp.Infinity, height = Dp.Infinity))
    }
    second {
      Spacer(Modifier.background(Color.Red).size(width = Dp.Infinity, height = Dp.Infinity))
    }
  }
      }
      UiText("Second Preserve Part")
      withModifier(Modifier.height(height = 400.dp)) {
    splitView(SplitDirection.VERTICAL,
                 stretchPolicy = StretchPolicy.PartPreserve(SplitPart.SECOND, initialPartLength = 80.dp,
                                                            minPartLength = 80.dp)) {
    first {
      Spacer(Modifier.background(Color.Blue).size(width = Dp.Infinity, height = Dp.Infinity))
    }
    second {
      Spacer(Modifier.background(Color.Red).size(width = Dp.Infinity, height = Dp.Infinity))
    }
  }
      }
    }
  }
}
