package noria.ui.examples

import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.flow
import androidx.compose.foundation.text.BasicText
import androidx.compose.runtime.noriaCollectAsState
import androidx.compose.runtime.getValue
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import kotlin.time.Duration.Companion.seconds

fun composeRuntimeExamples(): Gallery = gallery("Compose Runtime", NoriaExamples.sourceCodeForFile("ComposeRuntime.kt")) {
    val numbersFlow = flow {
        var i = 1
        while(true) {
            emit(i)
            delay(1.seconds)
            i++
        }
    }
    
    example("collectAsState") {
        val state by numbersFlow.noriaCollectAsState(this, 0)
        BasicText("Counter: ${state}")
    }
}