package noria.ui.examples

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawWithContent
import androidx.compose.ui.graphics.BlendMode
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.unit.dp
import noria.NoriaContext
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.horizontalSeparator
import fleet.compose.theme.components.UiText
import fleet.compose.theme.keys.TextStyleKeys
import noria.ui.withModifier

internal fun composeBlendModesGallery(): Gallery = gallery(name = "Compose Blend Modes Gallery",
                                                           sourceCodeFn = NoriaExamples.sourceCodeForFile("ComposeBlendModesGallery.kt")) {
  example("Compose Blend Modes Gallery") {
    Column(Modifier.width(300.dp).padding(vertical = 50.dp).padding(start = 50.dp, end = 50.dp), propagateMinWidth = true) {
      UiText("Draw blue rectangle on top of red circle using different blend modes", textStyleKey = TextStyleKeys.Header3)
      Spacer(Modifier.height(16.dp))

      blendModes.forEachIndexed { index, blendMode ->
        if (index != 0) {
          horizontalSeparator(color = Color.White, modifier = Modifier.padding(vertical = 24.dp))
        }
        Spacer(Modifier.height(16.dp))
        Row(verticalAlignment = Alignment.CenterVertically) {
          withModifier(Modifier.weight(1f)) {
            Box(contentAlignment = Alignment.Center) {
              UiText("$index: $blendMode", textStyleKey = TextStyleKeys.Header3)
            }
          }

          circleLayout(Modifier.greyRectangleBlending(blendMode))

          Spacer(Modifier.width(200.dp))
        }
      }
    }
  }
}

private val blendModes = listOf(
  BlendMode.Clear,
  BlendMode.Src,
  BlendMode.Dst,
  BlendMode.SrcOver,
  BlendMode.DstOver,
  BlendMode.SrcIn,
  BlendMode.DstIn,
  BlendMode.SrcOut,
  BlendMode.DstOut,
  BlendMode.SrcAtop,
  BlendMode.DstAtop,
  BlendMode.Xor,
  BlendMode.Plus,
  BlendMode.Modulate,
  BlendMode.Screen,
  BlendMode.Overlay,
  BlendMode.Darken,
  BlendMode.Lighten,
  BlendMode.ColorDodge,
  BlendMode.ColorBurn,
  BlendMode.Hardlight,
  BlendMode.Softlight,
  BlendMode.Difference,
  BlendMode.Exclusion,
  BlendMode.Multiply,
  BlendMode.Hue,
  BlendMode.Saturation,
  BlendMode.Color,
  BlendMode.Luminosity,
)

@Composable
private fun NoriaContext.circleLayout(modifier: Modifier = Modifier) {
  Box(
    modifier
      .size(60.dp)
      .background(Color.Red, CircleShape)
  )
}

private fun Modifier.greyRectangleBlending(blendMode: BlendMode) = drawWithContent {
  drawContent()
  drawRect(SolidColor(Color.Blue), blendMode = blendMode)
}
