package noria.ui.examples

import androidx.compose.foundation.layout.*
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import fleet.compose.theme.ai.aiButtonStyle
import fleet.compose.theme.components.*
import fleet.compose.theme.components.BannerStyle.*
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.ui.largeShadow
import noria.NoriaContext
import noria.model.IconKey
import noria.ui.text.Link

internal fun bannersExamples(): Gallery = gallery("Banners", NoriaExamples.sourceCodeForFile("Banners.kt")) {
  example("Embedded Banners") {
    Column {
      BannerStyle.entries.forEach {
        Banner(
          text = "File has been changed on disk",
          icon = IconKey("icons.link"),
          style = it,
          actions = {
            Button(text = "Cancel") {}
            when (it) {
              PRIMARY -> PrimaryButton(text = "Reload") {}
              DANGEROUS -> DangerousButton(text = "Reload") {}
              WARNING -> WarningButton(text = "Reload") {}
              POSITIVE -> AcceptButton(text = "Reload") {}
              AI -> Button(style = aiButtonStyle(), text = "Reload") {}
            }
          }
        )
        Spacer(Modifier.height(20.dp))
      }
    }
  }
  example("Floating Style") {
    Column {
      BannerStyle.entries.forEach {
        Banner(
          modifier = Modifier.largeShadow(BannerShape),
          text = "File has been changed on disk",
          icon = IconKey("icons.link"),
          showCloseButton = true,
          style = it,
          actions = {
            Button(text = "Cancel") {}
            when (it) {
              PRIMARY -> PrimaryButton(text = "Reload") {}
              DANGEROUS -> DangerousButton(text = "Reload") {}
              WARNING -> WarningButton(text = "Reload") {}
              POSITIVE -> AcceptButton(text = "Reload") {}
              AI -> Button(style = aiButtonStyle(), text = "Reload") {}
            }
          }
        )
        Spacer(Modifier.height(20.dp))
      }
    }
  }
  example("Variations") {
    Column {
      BannerVariation("Just text") {
        Banner(
          text = "File has been changed on disk",
          style = PRIMARY
        )
      }
      BannerVariation("Close button") {
        Banner(
          text = "File has been changed on disk",
          style = PRIMARY,
          showCloseButton = true
        )
      }
      BannerVariation("With icon") {
        Banner(
          text = "File has been changed on disk",
          icon = IconKey("icons.link"),
          style = PRIMARY
        )
      }
      BannerVariation("With buttons") {
        Banner(
          text = "File has been changed on disk",
          icon = IconKey("icons.link"),
          style = PRIMARY,
          actions = {
            Button(text = "Cancel") {}
            PrimaryButton(text = "Reload") {}
          }
        )
      }
      BannerVariation("With links") {
        Banner(
          text = "File has been changed on disk",
          icon = IconKey("icons.link"),
          style = PRIMARY,
          actions = {
            Link("link") {}
            Link("link") {}
          }
        )
      }
      BannerVariation("Min width") {
        Banner(
          text = "Min width",
          style = PRIMARY,
        )
      }
      BannerVariation("Max width") {
        Banner(
          text = "Max width max width max width max width max width max width max width max width max width max width max width link max width max width max width max width max width max width max width max width max width max width link",
          style = PRIMARY,
        )
      }
    }
  }
}

@Composable
fun NoriaContext.BannerVariation(title: String, banner: @Composable NoriaContext.() -> Unit) {
  Column {
    Row(verticalAlignment = Alignment.CenterVertically) {
      UiText(modifier = Modifier.width(76.dp), text = title)
      Spacer(Modifier.width(24.dp))
      banner()
    }
    Spacer(Modifier.height(20.dp))
  }
}