/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.bootstrap;

import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public final class FleetBootstrapProperties {
    public static boolean isFleetDistributionMode() {
        return FleetBootstrapProperties.fleetFlag("fleet.distribution.mode");
    }

    public static boolean fleetFlag(String name) {
        return FleetBootstrapProperties.fleetFlag(name, false);
    }

    public static boolean fleetFlag(String name, boolean defaultValue) {
        String value = FleetBootstrapProperties.fleetProperty(name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @Nullable
    public static String fleetProperty(String name) {
        return FleetBootstrapProperties.fleetProperty(name, null);
    }

    @Nullable
    public static String fleetProperty(String name, String defaultValue) {
        String property = System.getProperty(name);
        if (property != null) {
            return property;
        }
        String environment = System.getenv(name.replace('.', '_').toUpperCase(Locale.ROOT));
        if (environment != null) {
            return environment;
        }
        return defaultValue;
    }
}

