/*
 * Decompiled with CFR 0.152.
 */
package fleet.cpp.workspace;

import com.jetbrains.rhizomedb.Entity;
import fleet.api.FileAddress;
import fleet.api.HostId;
import fleet.cpp.workspace.ClangLanguageClientBase;
import fleet.cpp.workspace.ClangdConfiguration;
import fleet.kernel.plugins.PluginScope;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lfleet/cpp/workspace/ClangdLanguageClient;", "Lfleet/cpp/workspace/ClangLanguageClientBase;", "lifetime", "Lcom/jetbrains/rhizomedb/Entity;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "config", "Lfleet/cpp/workspace/ClangdConfiguration;", "hostId", "Lfleet/api/HostId;", "(Lcom/jetbrains/rhizomedb/Entity;Lfleet/kernel/plugins/PluginScope;Lfleet/cpp/workspace/ClangdConfiguration;Lfleet/api/HostId;)V", "logger", "Lfleet/util/logging/KLogger;", "createProgress", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "params", "Lorg/eclipse/lsp4j/WorkDoneProgressCreateParams;", "notifyProgress", "", "Lorg/eclipse/lsp4j/ProgressParams;", "onCompilationDatabaseChanged", "newCDBs", "", "Lfleet/api/FileAddress;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.plugins.cpp.workspace"})
@SourceDebugExtension(value={"SMAP\nClangdLanguageClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdLanguageClient.kt\nfleet/cpp/workspace/ClangdLanguageClient\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,178:1\n22#2:179\n9#3,2:180\n*S KotlinDebug\n*F\n+ 1 ClangdLanguageClient.kt\nfleet/cpp/workspace/ClangdLanguageClient\n*L\n53#1:179\n74#1:180,2\n*E\n"})
public final class ClangdLanguageClient
extends ClangLanguageClientBase {
    @NotNull
    private final KLogger logger;

    public ClangdLanguageClient(@NotNull Entity lifetime, @NotNull PluginScope pluginScope, @NotNull ClangdConfiguration config, @NotNull HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        super(lifetime, pluginScope, config, hostId, null);
        boolean $i$f$logger = false;
        this.logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ClangdLanguageClient.class));
    }

    @NotNull
    public CompletableFuture<Void> createProgress(@NotNull WorkDoneProgressCreateParams params) {
        CompletableFuture<Object> completableFuture;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.getClangdConfig().isJetBrainsClangd() && this.getClangdConfig().useJetBrainsIndexer()) {
            CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(null);
            completableFuture = completableFuture2;
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
        } else {
            completableFuture = super.createProgress(params);
        }
        return completableFuture;
    }

    public void notifyProgress(@NotNull ProgressParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.getClangdConfig().isJetBrainsClangd() && this.getClangdConfig().useJetBrainsIndexer()) {
            return;
        }
        super.notifyProgress(params);
    }

    @Override
    @Nullable
    public Object onCompilationDatabaseChanged(@NotNull List<FileAddress> newCDBs, @NotNull Continuation<? super Unit> $completion) {
        if (Intrinsics.areEqual(newCDBs, this.getClangdConfig().getCompilationDatabases())) {
            return Unit.INSTANCE;
        }
        KLogger this_$iv = this.logger;
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("Compilation database changed from '" + this.getClangdConfig().getCompilationDatabases() + "' to '" + newCDBs + "'"));
        }
        this.getClangdConfig().setCompilationDatabases(newCDBs);
        Object object = this.forceReconfigureRoots($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

