/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff.common;

import andel.text.LineEnding;
import fleet.diff.common.FileTextKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lfleet/diff/common/LineTokenizer;", "", "text", "", "<init>", "(Ljava/lang/CharSequence;)V", "getText", "()Ljava/lang/CharSequence;", "offset", "", "getOffset", "()I", "setOffset", "(I)V", "length", "getLength", "setLength", "lineSeparator", "Landel/text/LineEnding;", "getLineSeparator", "()Landel/text/LineEnding;", "setLineSeparator", "(Landel/text/LineEnding;)V", "atEnd", "", "getAtEnd", "()Z", "setAtEnd", "(Z)V", "advance", "", "fleet.diff.common"})
final class LineTokenizer {
    @NotNull
    private final CharSequence text;
    private int offset;
    private int length;
    @Nullable
    private LineEnding lineSeparator;
    private boolean atEnd;

    public LineTokenizer(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.offset = 0;
        this.advance();
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    @Nullable
    public final LineEnding getLineSeparator() {
        return this.lineSeparator;
    }

    public final void setLineSeparator(@Nullable LineEnding lineEnding) {
        this.lineSeparator = lineEnding;
    }

    public final boolean getAtEnd() {
        return this.atEnd;
    }

    public final void setAtEnd(boolean bl) {
        this.atEnd = bl;
    }

    public final void advance() {
        int textLength;
        int i = this.offset + this.length + FileTextKt.access$getLength(this.lineSeparator);
        if (i >= (textLength = this.text.length())) {
            this.atEnd = true;
            return;
        }
        block3: while (i < textLength) {
            char c = this.text.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    break block3;
                }
                default: {
                    ++i;
                    continue block3;
                }
            }
        }
        this.offset += this.length + FileTextKt.access$getLength(this.lineSeparator);
        this.length = i - this.offset;
        this.lineSeparator = i < textLength && this.text.charAt(i) == '\r' ? (i < textLength - 1 && this.text.charAt(i + 1) == '\n' ? LineEnding.CRLF : LineEnding.CR) : (i < textLength && this.text.charAt(i) == '\n' ? LineEnding.LF : null);
    }
}

