/*
 * Decompiled with CFR 0.152.
 */
package boringFormatter.indenter;

import boringFormatter.FormatterUtils;
import boringFormatter.FormatterUtilsKt;
import boringFormatter.TextContent;
import boringFormatter.TextContentLine;
import boringFormatter.indenter.ActiveIndentRegion;
import boringFormatter.indenter.CustomContextRuleConditionArguments;
import boringFormatter.indenter.CustomIndenterArguments;
import boringFormatter.indenter.IndentParserSpecific;
import boringFormatter.indenter.IndentResults;
import boringFormatter.indenter.IndentType;
import boringFormatter.indenter.IndenterRulesSet;
import boringFormatter.indenter.IndentingEditorSettings;
import boringFormatter.indenter.IndentingEditorSettingsKt;
import boringFormatter.indenter.IndentingLogger;
import boringFormatter.indenter.IndentingRule;
import boringFormatter.indenter.IndentingSessionKt;
import boringFormatter.indenter.IndentingSessionUtilsKt;
import boringFormatter.indenter.RegionIndents;
import fleet.ast.NodeAspectProvider;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020\u0013H\u0002J\b\u00104\u001a\u00020,H\u0002J\b\u00105\u001a\u00020,H\u0002J\u0010\u00106\u001a\u00020,2\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0018\u00107\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u0010&\u001a\u00020\u0005H\u0002J\u001a\u00108\u001a\u0004\u0018\u00010\u00052\u0006\u00100\u001a\u0002012\u0006\u0010&\u001a\u00020\u0005H\u0002J\"\u00109\u001a\u0004\u0018\u00010\u001b2\u0006\u00100\u001a\u0002012\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0017H\u0002J*\u0010:\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u0010&\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00172\b\u0010;\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010:\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0010\u0010<\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u0017H\u0002J\u0018\u0010>\u001a\u00020,2\u0006\u00100\u001a\u0002012\u0006\u0010?\u001a\u00020\u0005H\u0002J\u0018\u0010@\u001a\u00020,2\u0006\u00100\u001a\u0002012\u0006\u0010A\u001a\u00020\tH\u0002J \u0010B\u001a\u00020,2\u0006\u00100\u001a\u0002012\u0006\u0010A\u001a\u00020\t2\u0006\u0010C\u001a\u00020!H\u0002J*\u0010D\u001a\u00020,2\u0006\u00100\u001a\u0002012\u0006\u0010E\u001a\u00020\t2\u0006\u0010?\u001a\u00020\u00052\b\u0010F\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010G\u001a\u00020,2\u0006\u0010H\u001a\u00020\u0017H\u0002J\u0010\u0010I\u001a\u00020!2\u0006\u0010=\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010%R\u000e\u0010&\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"LboringFormatter/indenter/IndentingSession;", "", "rules", "LboringFormatter/indenter/IndenterRulesSet;", "root", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "text", "LboringFormatter/TextContent;", "offsetRange", "Lkotlin/ranges/LongRange;", "settings", "LboringFormatter/indenter/IndentingEditorSettings;", "parserSpecific", "LboringFormatter/indenter/IndentParserSpecific;", "logger", "LboringFormatter/indenter/IndentingLogger;", "aspectProvider", "Lfleet/ast/NodeAspectProvider;", "leftRootAlign", "", "<init>", "(LboringFormatter/indenter/IndenterRulesSet;Lfleet/com/jetbrains/lang/syntax/SyntaxNode;LboringFormatter/TextContent;Lkotlin/ranges/LongRange;LboringFormatter/indenter/IndentingEditorSettings;LboringFormatter/indenter/IndentParserSpecific;LboringFormatter/indenter/IndentingLogger;Lfleet/ast/NodeAspectProvider;Z)V", "lineFrom", "", "lineTo", "activeRegions", "Ljava/util/Stack;", "LboringFormatter/indenter/ActiveIndentRegion;", "result", "LboringFormatter/indenter/IndentResults;", "baseNode", "baseIndent", "regionId", "", "currentNodeStartLine", "currentIndent", "defferedGreedyIndent", "Ljava/lang/Long;", "currentNode", "calculate", "", "", "finalize", "openRegions", "", "openBeforeToken", "trySkipRuleRegionThatEndsBeforeRange", "node", "rule", "LboringFormatter/indenter/IndentingRule;", "tryCloseRegions", "inclusive", "tryApplyIndents", "activeRegionsAdjustment", "closeRegion", "openRegion", "getRuleExitNode", "tryCollapse", "calculateRegionIndent", "currentRegion", "getCalculatedIndent", "lineNumber", "applyBlockRule", "openNode", "applyBlockSaveOriginRule", "lines", "applyBlockSaveRelativeRule", "relativeOffset", "applyBlockCustomRule", "ruleLines", "exitNode", "setCurrentIndent", "indent", "getOriginLineIndent", "fleet.boringFormatter"})
@SourceDebugExtension(value={"SMAP\nIndentingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndentingSession.kt\nboringFormatter/indenter/IndentingSession\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,613:1\n1104#2,3:614\n295#3,2:617\n*S KotlinDebug\n*F\n+ 1 IndentingSession.kt\nboringFormatter/indenter/IndentingSession\n*L\n268#1:614,3\n148#1:617,2\n*E\n"})
public final class IndentingSession {
    @NotNull
    private final IndenterRulesSet rules;
    @NotNull
    private final SyntaxNode root;
    @NotNull
    private final TextContent text;
    @NotNull
    private final LongRange offsetRange;
    @NotNull
    private final IndentingEditorSettings settings;
    @NotNull
    private final IndentParserSpecific parserSpecific;
    @NotNull
    private final IndentingLogger logger;
    @NotNull
    private final NodeAspectProvider aspectProvider;
    private final long lineFrom;
    private final long lineTo;
    @NotNull
    private final Stack<ActiveIndentRegion> activeRegions;
    @NotNull
    private final IndentResults result;
    @NotNull
    private final SyntaxNode baseNode;
    private final long baseIndent;
    private int regionId;
    private long currentNodeStartLine;
    private long currentIndent;
    @Nullable
    private Long defferedGreedyIndent;
    @NotNull
    private SyntaxNode currentNode;

    public IndentingSession(@NotNull IndenterRulesSet rules, @NotNull SyntaxNode root, @NotNull TextContent text, @NotNull LongRange offsetRange, @NotNull IndentingEditorSettings settings, @NotNull IndentParserSpecific parserSpecific, @NotNull IndentingLogger logger, @NotNull NodeAspectProvider aspectProvider, boolean leftRootAlign) {
        Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)offsetRange, (String)"offsetRange");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parserSpecific, (String)"parserSpecific");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)aspectProvider, (String)"aspectProvider");
        this.rules = rules;
        this.root = root;
        this.text = text;
        this.offsetRange = offsetRange;
        this.settings = settings;
        this.parserSpecific = parserSpecific;
        this.logger = logger;
        this.aspectProvider = aspectProvider;
        this.lineFrom = this.text.lineNumber(this.offsetRange.getStart());
        this.lineTo = this.text.lineNumber(this.offsetRange.getEndInclusive());
        this.activeRegions = new Stack();
        this.baseNode = this.parserSpecific.getBaseNode(this.root, this.offsetRange);
        this.currentNodeStartLine = -1L;
        this.baseIndent = leftRootAlign && this.baseNode.getStartOffset() == 0L ? 0L : (long)FormatterUtilsKt.getAbsoluteIndentSize(this.baseNode, this.text, this.settings);
        this.setCurrentIndent(this.baseIndent);
        this.result = new IndentResults(this.settings, this.lineFrom, this.lineTo, this.text.lineNumber(this.baseNode.getStartOffset()) - 1L);
        this.currentNode = this.baseNode;
        this.openRegion(new IndentingRule("root", true, (Function1<? super SyntaxNode, Boolean>)((Function1)IndentingSession::_init_$lambda$0), true, (Function1<? super SyntaxNode, ? extends SyntaxNode>)((Function1)IndentingSession::_init_$lambda$1), false, IndentType.ABSOLUTE_ZERO, null, null, CollectionsKt.emptyList(), null), this.currentNode);
        this.logger.baseInfo(this.baseNode, this.lineFrom, this.lineTo);
    }

    public /* synthetic */ IndentingSession(IndenterRulesSet indenterRulesSet, SyntaxNode syntaxNode, TextContent textContent, LongRange longRange, IndentingEditorSettings indentingEditorSettings, IndentParserSpecific indentParserSpecific, IndentingLogger indentingLogger, NodeAspectProvider nodeAspectProvider, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            indentingLogger = IndentingLogger.Companion.getNoLog();
        }
        if ((n & 0x80) != 0) {
            nodeAspectProvider = NodeAspectProvider.Companion.getEmpty();
        }
        if ((n & 0x100) != 0) {
            bl = true;
        }
        this(indenterRulesSet, syntaxNode, textContent, longRange, indentingEditorSettings, indentParserSpecific, indentingLogger, nodeAspectProvider, bl);
    }

    @NotNull
    public final List<String> calculate() {
        this.logger.start();
        SyntaxNode syntaxNode = IndentingSessionUtilsKt.nextToken(this.baseNode);
        if (syntaxNode == null) {
            return this.finalize();
        }
        this.currentNode = syntaxNode;
        while (true) {
            this.currentNodeStartLine = this.text.lineNumber(this.currentNode.getStartOffset());
            this.tryCloseRegions(false);
            this.openRegions(true);
            this.tryCloseRegions(false);
            this.logger.changeNode(this.currentNode, this.currentIndent, this.result.getLastIndentedLine(), this.activeRegions.size());
            if (this.currentNodeStartLine > this.lineTo) break;
            this.tryApplyIndents();
            this.tryCloseRegions(true);
            this.openRegions(false);
            this.tryCloseRegions(true);
            if (IndentingSessionUtilsKt.nextToken(this.currentNode) == null) break;
            this.currentNode = this.currentNode;
        }
        return this.finalize();
    }

    private final List<String> finalize() {
        while (this.lineTo - this.lineFrom + 1L > (long)this.result.getCollectedSize()) {
            Long l = this.defferedGreedyIndent;
            this.result.addNext(l != null ? l : this.currentIndent);
            Long l2 = this.defferedGreedyIndent;
            this.logger.fillUndone(l2 != null ? l2 : this.currentIndent, this.result.getLastIndentedLine(), this.activeRegions.size());
            this.defferedGreedyIndent = null;
        }
        this.logger.finish();
        return this.result.build();
    }

    private final void openRegions(boolean openBeforeToken) {
        if (FormatterUtilsKt.isToken(this.currentNode)) {
            IndentingSession.openRegions$openRegionsInAncestorNodesReq(this, openBeforeToken, this.currentNode, this.currentNode);
        }
    }

    private final boolean trySkipRuleRegionThatEndsBeforeRange(SyntaxNode node, IndentingRule rule) {
        SyntaxNode newCurrentNode;
        SyntaxNode syntaxNode;
        SyntaxNode syntaxNode2;
        SyntaxNode syntaxNode3;
        if (node.getStartOffset() >= this.offsetRange.getStart()) {
            return false;
        }
        SyntaxNode syntaxNode4 = (SyntaxNode)rule.getEndLocator().invoke((Object)node);
        if (syntaxNode4 == null) {
            return false;
        }
        SyntaxNode endNode = syntaxNode4;
        if (endNode.getEndOffset() >= this.offsetRange.getStart()) {
            return false;
        }
        if (FormatterUtilsKt.isToken(endNode)) {
            syntaxNode3 = endNode;
        } else {
            syntaxNode3 = SyntaxNodeExtKt.leafRight((SyntaxNode)endNode);
            if (syntaxNode3 == null) {
                return false;
            }
        }
        SyntaxNode lastToken = syntaxNode3;
        if (rule.getEndsInclusive()) {
            syntaxNode2 = lastToken;
        } else {
            syntaxNode2 = IndentingSessionUtilsKt.prevToken(lastToken);
            if (syntaxNode2 == null) {
                return false;
            }
        }
        SyntaxNode nextAfterRuleNode = syntaxNode2;
        if (Intrinsics.areEqual((Object)nextAfterRuleNode, (Object)this.currentNode) || nextAfterRuleNode.getEndOffset() == this.currentNode.getStartOffset()) {
            return false;
        }
        if (this.parserSpecific.isNewLine(nextAfterRuleNode)) {
            syntaxNode = IndentingSessionUtilsKt.prevToken(nextAfterRuleNode);
            if (syntaxNode == null) {
                return false;
            }
        } else {
            syntaxNode = nextAfterRuleNode;
        }
        if (Intrinsics.areEqual((Object)(newCurrentNode = syntaxNode), (Object)this.currentNode)) {
            return false;
        }
        if (newCurrentNode.getEndOffset() == this.currentNode.getStartOffset()) {
            return false;
        }
        if (newCurrentNode.getStartOffset() < this.currentNode.getStartOffset()) {
            throw new AssertionError((Object)("Rule `" + rule.getName() + "` returned end node " + newCurrentNode.getType() + "(`" + newCurrentNode.getText() + "`, " + newCurrentNode.getStartOffset() + "-" + newCurrentNode.getEndOffset() + ") that starts before its region " + this.currentNode.getType() + "(`" + this.currentNode.getText() + "`, " + this.currentNode.getStartOffset() + "-" + this.currentNode.getEndOffset() + ")"));
        }
        if (rule.getStartsInclusive()) {
            return false;
        }
        Function1<SyntaxNode, Boolean> function1 = rule.getGreedyCondition();
        boolean bl = function1 != null ? ((Boolean)function1.invoke((Object)node)).booleanValue() : false;
        if (bl) {
            return false;
        }
        long newNodeLine = this.text.lineNumber(nextAfterRuleNode.getStartOffset());
        if (newNodeLine >= this.lineFrom - 1L) {
            return false;
        }
        this.logger.skipRuleBeforeRange(this.currentIndent, this.result.getLastIndentedLine(), this.activeRegions.size(), rule, this.currentNode, newCurrentNode);
        this.currentNodeStartLine = this.text.lineNumber(this.currentNode.getStartOffset());
        this.currentNode = newCurrentNode;
        return true;
    }

    private final void tryCloseRegions(boolean inclusive) {
        ActiveIndentRegion region;
        while (IndentingSessionUtilsKt.peekOrNull(this.activeRegions) != null && region.getEndNode() != null && region.getRule().getEndsInclusive() == inclusive && !(inclusive ? this.currentNode.getEndOffset() < region.getEndNode().getEndOffset() : this.currentNode.getStartOffset() < region.getEndNode().getStartOffset())) {
            this.closeRegion(this.currentNode);
        }
    }

    private final void tryApplyIndents() {
        if (this.parserSpecific.isSpace(this.currentNode)) {
            return;
        }
        boolean isNewLine = this.parserSpecific.isNewLine(this.currentNode);
        if (isNewLine) {
            int newLinesCount;
            if (SyntaxNodeExtKt.getLength((SyntaxNode)this.currentNode) == 1L) {
                v0 = 1;
            } else {
                CharSequence $this$count$iv = this.currentNode.getText();
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                v0 = newLinesCount = count$iv;
            }
            if (newLinesCount > 1) {
                long currentline = this.currentNodeStartLine;
                for (int line = 1; line < newLinesCount; ++line) {
                    long l = currentline;
                    currentline = l + 1L;
                    Long l2 = this.defferedGreedyIndent;
                    this.result.add(currentline, l2 != null ? l2 : this.currentIndent);
                    Long l3 = this.defferedGreedyIndent;
                    this.logger.multilineIndent(currentline, l3 != null ? l3 : this.currentIndent, this.activeRegions.size());
                    this.defferedGreedyIndent = null;
                }
                return;
            }
        }
        if (this.currentNodeStartLine <= this.result.getLastIndentedLine()) {
            return;
        }
        if (isNewLine || FormatterUtilsKt.isToken(this.currentNode)) {
            Long indent;
            this.activeRegionsAdjustment();
            Long l = indent = this.defferedGreedyIndent != null && TextContent.line$default(this.text, this.currentNodeStartLine, false, 2, null).getContent().length() == 0 ? this.defferedGreedyIndent : Long.valueOf(this.currentIndent);
            Intrinsics.checkNotNull((Object)l);
            this.result.add(this.currentNodeStartLine, l);
            this.defferedGreedyIndent = null;
        }
    }

    private final void activeRegionsAdjustment() {
        long currentLine = this.currentNodeStartLine;
        ActiveIndentRegion activeIndentRegion = IndentingSessionUtilsKt.peekOrNull(this.activeRegions);
        if (activeIndentRegion == null) {
            return;
        }
        ActiveIndentRegion activeRule = activeIndentRegion;
        if (currentLine < 0L || currentLine >= this.lineFrom) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)TextContent.line$default(this.text, currentLine, false, 2, null).getContent())) {
            return;
        }
        if (!IndentingSessionKt.access$startsFromNewLine(this.currentNode, this.parserSpecific)) {
            return;
        }
        if (activeRule.getRule().getIndentType() == IndentType.STANDARD || ((Collection)this.activeRegions).size() == 1) {
            boolean isSingleLineRule = activeRule.getStartLineNumber() == FormatterUtils.INSTANCE.lastApplyingLineOfRegion(activeRule.getRule().getEndsInclusive(), this.text, activeRule.getEnterNode(), activeRule.getEndNode());
            int originIndent = this.getOriginLineIndent(currentLine);
            long delta = (long)originIndent - this.currentIndent;
            if (delta != 0L && !isSingleLineRule) {
                activeRule.adjustDelta(activeRule.getAdjustedIndent().getDelta() + delta);
                this.setCurrentIndent(originIndent);
                this.logger.adjustIndent(activeRule, this.currentIndent, currentLine, delta);
            }
        }
        if (activeRule.getRule().getStartsInclusive() && activeRule.getStartLineNumber() == currentLine && this.activeRegions.size() > 1) {
            ActiveIndentRegion parentRegion = (ActiveIndentRegion)this.activeRegions.get(this.activeRegions.size() - 2);
            long theoreticalIndent = this.calculateRegionIndent(activeRule.getRule(), activeRule.getEnterNode(), parentRegion.getAdjustedIndent().getIndent(), parentRegion);
            int originIndent = this.getOriginLineIndent(currentLine);
            long delta = (long)originIndent - theoreticalIndent;
            if (delta != 0L || parentRegion.getAdjustedIndent().getDelta() != parentRegion.getOriginIndent().getDelta()) {
                switch (WhenMappings.$EnumSwitchMapping$0[activeRule.getRule().getIndentType().ordinal()]) {
                    case 4: {
                        parentRegion.setAdjustedIndent(new RegionIndents((long)originIndent + parentRegion.getOriginIndent().getDelta(), originIndent));
                        activeRule.setAdjustedIndent(new RegionIndents(-parentRegion.getAdjustedIndent().getDelta(), parentRegion.getAdjustedIndent().getIndent()));
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        parentRegion.adjustDelta(parentRegion.getOriginIndent().getDelta() + delta);
                        activeRule.adjustDelta(theoreticalIndent - parentRegion.getOriginIndent().getIndent());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.setCurrentIndent(originIndent);
                Intrinsics.checkNotNull((Object)parentRegion);
                this.logger.adjustIndent(parentRegion, this.currentIndent, currentLine, delta);
            }
        }
    }

    private final void closeRegion(SyntaxNode currentNode) {
        ActiveIndentRegion region = this.activeRegions.pop();
        long resultIndent = region.getAdjustedIndent().getIndentBefore();
        this.defferedGreedyIndent = region.isGreedy() ? Long.valueOf(region.getAdjustedIndent().getIndent()) : null;
        long l = this.result.getLastIndentedLine();
        Intrinsics.checkNotNull((Object)region);
        this.logger.closeRegion(this.currentIndent, l, region, currentNode, this.activeRegions.size());
        this.setCurrentIndent(resultIndent);
    }

    private final long openRegion(IndentingRule rule, SyntaxNode currentNode) {
        Boolean bl;
        ActiveIndentRegion collapsedRegion = this.tryCollapse(rule, currentNode, this.currentNodeStartLine);
        long newIndent = this.calculateRegionIndent(rule, currentNode);
        ActiveIndentRegion activeIndentRegion = collapsedRegion;
        if (activeIndentRegion != null) {
            bl = activeIndentRegion.isGreedy();
        } else {
            Function1<SyntaxNode, Boolean> function1 = rule.getGreedyCondition();
            bl = function1 != null ? (Boolean)function1.invoke((Object)currentNode) : null;
        }
        boolean isGreedy = Intrinsics.areEqual((Object)bl, (Object)true);
        ActiveIndentRegion newActiveRegion = new ActiveIndentRegion(rule, this.currentNodeStartLine, newIndent, this.currentIndent, this.regionId, currentNode, this.getRuleExitNode(rule, currentNode), isGreedy);
        if (Intrinsics.areEqual((Object)newActiveRegion.getEndNode(), (Object)newActiveRegion.getEnterNode()) && (!newActiveRegion.getRule().getStartsInclusive() && FormatterUtilsKt.isToken(newActiveRegion.getEnterNode()) || !newActiveRegion.getRule().getEndsInclusive())) {
            return this.currentIndent;
        }
        int n = this.regionId;
        this.regionId = n + 1;
        this.logger.openRegion(newIndent, newActiveRegion, currentNode, this.activeRegions.size());
        this.activeRegions.add(newActiveRegion);
        return newIndent;
    }

    private final SyntaxNode getRuleExitNode(IndentingRule rule, SyntaxNode currentNode) {
        SyntaxNode exitNode = (SyntaxNode)rule.getEndLocator().invoke((Object)currentNode);
        ActiveIndentRegion activeIndentRegion = IndentingSessionUtilsKt.peekOrNull(this.activeRegions);
        if (activeIndentRegion == null) {
            return exitNode;
        }
        ActiveIndentRegion lastActiveRegion = activeIndentRegion;
        if (lastActiveRegion.getEndNode() == null) {
            return exitNode;
        }
        return exitNode;
    }

    private final ActiveIndentRegion tryCollapse(IndentingRule rule, SyntaxNode currentNode, long currentNodeStartLine) {
        ActiveIndentRegion lastActiveRegion;
        if (!rule.getCollapsable()) {
            return null;
        }
        ActiveIndentRegion result = null;
        while (IndentingSessionUtilsKt.peekOrNull(this.activeRegions) != null && lastActiveRegion.isCollapsesWith(currentNode, currentNodeStartLine, rule, this.text)) {
            this.closeRegion(currentNode);
            this.logger.collapseRegion(this.currentIndent, currentNodeStartLine, rule, lastActiveRegion, currentNode, this.activeRegions.size());
            result = lastActiveRegion;
        }
        return result;
    }

    private final long calculateRegionIndent(IndentingRule rule, SyntaxNode currentNode, long currentIndent, ActiveIndentRegion currentRegion) {
        return switch (WhenMappings.$EnumSwitchMapping$0[rule.getIndentType().ordinal()]) {
            case 6 -> 0L;
            case 9 -> currentIndent;
            case 8 -> currentIndent + 1L;
            case 5 -> currentIndent + (long)IndentingEditorSettingsKt.getAbsoluteIndentSize(this.settings);
            case 7 -> RangesKt.coerceAtLeast((long)(currentIndent - (long)IndentingEditorSettingsKt.getAbsoluteIndentSize(this.settings)), (long)0L);
            case 10 -> {
                long offset = rule.getStartsInclusive() ? currentNode.getStartOffset() : currentNode.getEndOffset();
                long currentNodeStartLine = this.text.lineNumber(offset);
                long lineStartOffset = this.text.lineStartOffset(currentNodeStartLine);
                long beforePositionAtLine = offset - lineStartOffset;
                TextContentLine line = TextContent.line$default(this.text, currentNodeStartLine, false, 2, null);
                long columnBefore = IndentingEditorSettingsKt.getColumnNumber(this.settings, line.getContent(), beforePositionAtLine);
                int indentBefore = IndentingEditorSettingsKt.getAbsoluteIndentSizeForLine(this.settings, line);
                if (columnBefore == (long)indentBefore) {
                    yield currentIndent;
                }
                Integer v1 = this.result.getLastIndentSize();
                int indentAfter = v1 != null ? v1 : indentBefore;
                yield columnBefore - (long)indentBefore + (long)indentAfter;
            }
            case 11 -> {
                if (currentRegion == null || currentRegion.getRule().getIndentType() == IndentType.CANCEL) {
                    yield currentIndent;
                }
                long offset = rule.getStartsInclusive() ? currentNode.getStartOffset() : currentNode.getEndOffset();
                long currentNodeStartLine = this.text.lineNumber(offset);
                if (currentRegion.getStartLineNumber() < currentNodeStartLine) {
                    yield this.getCalculatedIndent(currentNodeStartLine - 1L);
                }
                yield currentRegion.getAdjustedIndent().getIndentBefore();
            }
            case 4 -> {
                if (currentRegion == null || currentRegion.getRule().getIndentType() == IndentType.CANCEL) {
                    yield currentIndent;
                }
                yield currentRegion.getAdjustedIndent().getIndentBefore();
            }
            default -> throw new Exception("Rule type " + rule.getIndentType() + " is not supported for region indent calculation");
        };
    }

    private final long calculateRegionIndent(IndentingRule rule, SyntaxNode currentNode) {
        return this.calculateRegionIndent(rule, currentNode, this.currentIndent, IndentingSessionUtilsKt.peekOrNull(this.activeRegions));
    }

    private final long getCalculatedIndent(long lineNumber) {
        ActiveIndentRegion region;
        long indent = this.currentIndent;
        for (int i = this.activeRegions.size() - 1; -1 < i && (region = (ActiveIndentRegion)this.activeRegions.get(i)).getStartLineNumber() >= lineNumber; --i) {
            indent -= region.getAdjustedIndent().getDelta();
        }
        return indent;
    }

    private final void applyBlockRule(IndentingRule rule, SyntaxNode openNode) {
        SyntaxNode exitNode = this.getRuleExitNode(rule, openNode);
        LongRange lines = IndentingSessionUtilsKt.getRegionLineRange(rule, this.text, openNode, exitNode, this.result.getLastIndentedLine());
        if (lines.getFirst() >= lines.getLast() + 1L) {
            return;
        }
        if (lines.getFirst() > lines.getLast()) {
            throw new Exception("Invalid rule '" + rule.getName() + "'. It starts after its end. It starts at line " + lines.getFirst() + " but ends at line " + lines.getLast());
        }
        if (lines.getStart() <= this.result.getLastIndentedLine()) {
            throw new Exception("IndentingSession error. Custom region [" + lines + "] starts before last indented line [" + this.result.getLastIndentedLine() + "]  ");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[rule.getIndentType().ordinal()]) {
            case 1: {
                this.applyBlockCustomRule(rule, lines, openNode, exitNode);
                break;
            }
            case 2: 
            case 3: {
                this.applyBlockSaveOriginRule(rule, lines);
                break;
            }
            default: {
                throw new Exception("Unsupported rule block type");
            }
        }
    }

    private final void applyBlockSaveOriginRule(IndentingRule rule, LongRange lines) {
        int n;
        if (rule.getIndentType() == IndentType.LEAVE_AS_IS) {
            n = 0;
        } else if (this.result.isEmpty()) {
            n = 0;
        } else if (this.currentNodeStartLine < this.lineFrom) {
            n = 0;
        } else {
            int originFirstLineIndent = this.getOriginLineIndent(this.currentNodeStartLine);
            Integer n2 = this.result.getLastIndentSize();
            Intrinsics.checkNotNull((Object)n2);
            n = n2 - originFirstLineIndent;
        }
        int relativeOffset = n;
        this.applyBlockSaveRelativeRule(rule, lines, relativeOffset);
    }

    private final void applyBlockSaveRelativeRule(IndentingRule rule, LongRange lines, int relativeOffset) {
        long l;
        long lineNumber = lines.getFirst();
        if (lineNumber <= (l = lines.getLast())) {
            while (true) {
                if (lineNumber >= this.lineFrom && lineNumber <= this.lineTo) {
                    int n;
                    TextContentLine line = TextContent.line$default(this.text, lineNumber, false, 2, null);
                    if (line.getContent().length() == 0) {
                        if (!this.result.isEmpty()) {
                            Integer n2 = this.result.getLastIndentSize();
                            Intrinsics.checkNotNull((Object)n2);
                            n = n2;
                        } else {
                            n = lineNumber > 0L ? this.getOriginLineIndent(lineNumber - 1L) : 0;
                        }
                    } else {
                        n = IndentingEditorSettingsKt.getAbsoluteIndentSizeForLine(this.settings, line) + relativeOffset;
                    }
                    int originLineIndent = n;
                    this.result.add(lineNumber, originLineIndent);
                    this.logger.blockIndent(rule, lineNumber, originLineIndent);
                }
                if (lineNumber == l) break;
                ++lineNumber;
            }
        }
    }

    private final void applyBlockCustomRule(IndentingRule rule, LongRange ruleLines, SyntaxNode openNode, SyntaxNode exitNode) {
        int baseIndent = ruleLines.getFirst() < this.lineFrom ? this.getOriginLineIndent(ruleLines.getFirst()) : (int)this.currentIndent;
        String string = IndentingEditorSettingsKt.getIndentString(this.settings, baseIndent);
        SyntaxNode syntaxNode = exitNode;
        if (syntaxNode == null) {
            SyntaxNode syntaxNode2 = SyntaxNodeExtKt.lastLeaf((SyntaxNode)IndentingSessionUtilsKt.root(openNode));
            syntaxNode = syntaxNode2;
            Intrinsics.checkNotNull((Object)syntaxNode2);
        }
        CustomIndenterArguments arguments = new CustomIndenterArguments(this.text, string, ruleLines, this.settings, this.rules, openNode, syntaxNode, this.aspectProvider);
        Function1<CustomIndenterArguments, List<String>> function1 = rule.getCalculate();
        if (function1 == null) {
            throw new Exception("custom calculator is null for custom indent rule '" + rule.getName() + "'");
        }
        Function1<CustomIndenterArguments, List<String>> calculator = function1;
        List calculatedIndents = (List)calculator.invoke((Object)arguments);
        int count = (int)(ruleLines.getLast() - ruleLines.getFirst() + 1L);
        if (calculatedIndents.size() != count) {
            throw new Exception("Invalid custom rule output. Expected: " + count + " but was " + calculatedIndents.size() + " lines");
        }
        for (int i = 0; i < count; ++i) {
            String indent = (String)calculatedIndents.get(i);
            this.result.add(ruleLines.getStart() + (long)i, indent);
            this.logger.blockIndent(rule, this.result.getLastIndentedLine(), indent.length());
        }
        if (exitNode == null) {
            this.currentNodeStartLine = this.text.linesCount();
        } else {
            this.currentNode = exitNode;
            this.currentNodeStartLine = this.text.lineNumber(this.currentNode.getStartOffset());
        }
    }

    private final void setCurrentIndent(long indent) {
        this.currentIndent = indent;
    }

    private final int getOriginLineIndent(long lineNumber) {
        return IndentingEditorSettingsKt.getAbsoluteIndentSizeForLine(this.settings, TextContent.line$default(this.text, lineNumber, false, 2, null));
    }

    private static final boolean _init_$lambda$0(SyntaxNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final SyntaxNode _init_$lambda$1(SyntaxNode $this$IndentingRule) {
        Intrinsics.checkNotNullParameter((Object)$this$IndentingRule, (String)"$this$IndentingRule");
        return null;
    }

    private static final boolean openRegions$openRegionsInAncestorNodesReq(IndentingSession this$0, boolean $openBeforeToken, SyntaxNode currentToken, SyntaxNode node) {
        Object v1;
        block9: {
            if (node == null) {
                return true;
            }
            if (node.getStartOffset() != currentToken.getStartOffset()) {
                return true;
            }
            if (!IndentingSession.openRegions$openRegionsInAncestorNodesReq(this$0, $openBeforeToken, currentToken, node.parent())) {
                return false;
            }
            Iterable $this$firstOrNull$iv = this$0.rules.getRules();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IndentingRule it = (IndentingRule)element$iv;
                boolean bl = false;
                boolean bl2 = it.getStartsInclusive() == $openBeforeToken && ((Boolean)it.getRegionStart().invoke((Object)node)).booleanValue() && (it.getContextualCondition() == null || Intrinsics.areEqual((Object)it.getContextualCondition().invoke((Object)new CustomContextRuleConditionArguments(this$0.text, this$0.settings, this$0.aspectProvider, node)), (Object)true));
                if (!bl2) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        IndentingRule indentingRule = v1;
        if (indentingRule == null) {
            return true;
        }
        IndentingRule rule = indentingRule;
        if (this$0.trySkipRuleRegionThatEndsBeforeRange(node, rule)) {
            this$0.logger.skipRule(this$0.currentIndent, this$0.result.getLastIndentedLine(), this$0.activeRegions.size(), node, rule);
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[rule.getIndentType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this$0.applyBlockRule(rule, node);
                break;
            }
            default: {
                this$0.setCurrentIndent(this$0.openRegion(rule, node));
            }
        }
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IndentType.values().length];
            try {
                nArray[IndentType.CUSTOM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.LEAVE_AS_IS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.SAVE_RELATIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.CANCEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.STANDARD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.ABSOLUTE_ZERO.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.NEGATIVE_STANDARD.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.SINGLE_SPACE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.SKIP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.ALIGNMENT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentType.RESET.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

