/*
 * Decompiled with CFR 0.152.
 */
package boringFormatter.indenter;

import boringFormatter.indenter.IndentingEditorSettings;
import boringFormatter.indenter.IndentingEditorSettingsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0005J\u0016\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\fJ\u0016\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"LboringFormatter/indenter/IndentResults;", "", "settings", "LboringFormatter/indenter/IndentingEditorSettings;", "lineFrom", "", "lineTo", "lastIndentLine", "<init>", "(LboringFormatter/indenter/IndentingEditorSettings;JJJ)V", "result", "", "", "[Ljava/lang/String;", "actualSize", "", "collectedSize", "getCollectedSize", "()I", "isEmpty", "", "()Z", "lastIndentSize", "getLastIndentSize", "()Ljava/lang/Integer;", "value", "lastIndentedLine", "getLastIndentedLine", "()J", "build", "", "addNext", "", "indent", "size", "add", "line", "fleet.boringFormatter"})
@SourceDebugExtension(value={"SMAP\nIndentResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndentResults.kt\nboringFormatter/indenter/IndentResults\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class IndentResults {
    @NotNull
    private final IndentingEditorSettings settings;
    private final long lineFrom;
    private final long lineTo;
    @NotNull
    private final String[] result;
    private int actualSize;
    private long lastIndentedLine;

    public IndentResults(@NotNull IndentingEditorSettings settings, long lineFrom, long lineTo, long lastIndentLine) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.lineFrom = lineFrom;
        this.lineTo = lineTo;
        int n = 0;
        int n2 = (int)(this.lineTo - this.lineFrom) + 1;
        String[] stringArray = new String[n2];
        IndentResults indentResults = this;
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = "";
        }
        indentResults.result = stringArray;
        this.lastIndentedLine = lastIndentLine;
    }

    public /* synthetic */ IndentResults(IndentingEditorSettings indentingEditorSettings, long l, long l2, long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l3 = -1L;
        }
        this(indentingEditorSettings, l, l2, l3);
    }

    public final int getCollectedSize() {
        return this.actualSize;
    }

    public final boolean isEmpty() {
        return this.actualSize <= 0;
    }

    @Nullable
    public final Integer getLastIndentSize() {
        if (this.actualSize == 0) {
            return null;
        }
        String it = this.result[this.actualSize - 1];
        boolean bl = false;
        return IndentingEditorSettingsKt.getAbsoluteIndentSize(this.settings, it);
    }

    public final long getLastIndentedLine() {
        return this.lastIndentedLine;
    }

    @NotNull
    public final List<String> build() {
        boolean bl;
        boolean bl2 = bl = this.getCollectedSize() == this.result.length;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Not all indents were collected. Expected size " + this.result.length + ", Actual: " + this.getCollectedSize();
            throw new AssertionError((Object)string);
        }
        return ArraysKt.toList((Object[])this.result);
    }

    public final void addNext(@NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this.result[this.actualSize] = indent;
        int n = this.actualSize;
        this.actualSize = n + 1;
        long l = this.lastIndentedLine;
        this.lastIndentedLine = l + 1L;
    }

    public final void addNext(long size) {
        int s = size > 0L ? (int)size : 0;
        this.addNext(IndentingEditorSettingsKt.getIndentString(this.settings, s));
    }

    public final void add(long line, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        if (line > this.lastIndentedLine) {
            this.lastIndentedLine = line;
        }
        long l = this.lineFrom;
        if (!(line <= this.lineTo ? l <= line : false)) {
            return;
        }
        int index = (int)(line - this.lineFrom);
        if (index >= this.actualSize) {
            this.actualSize = index + 1;
        }
        this.result[index] = indent;
    }

    public final void add(long line, long size) {
        this.add(line, IndentingEditorSettingsKt.getIndentString(this.settings, size));
    }
}

