/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\b2\u0006\u0010\r\u001a\u00020\u000e\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0006\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"TIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "Ljava/time/format/DateTimeFormatter;", "DATE_FORMATTER", "DATE_WITH_YEAR_FORMATTER", "FULL_FORMATTER", "utcSeconds", "Ljava/time/LocalDateTime;", "timestamp", "", "formatTimestamp", "", "shorten", "", "fleet.util.core"})
public final class DateUtilKt {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("MMM d");
    private static final DateTimeFormatter DATE_WITH_YEAR_FORMATTER = DateTimeFormatter.ofPattern("MMM d, yyyy");
    private static final DateTimeFormatter FULL_FORMATTER = DateTimeFormatter.ofPattern("HH:mm MMM d, yyyy");

    @NotNull
    public static final LocalDateTime utcSeconds(long timestamp) {
        LocalDateTime localDateTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestamp * (long)1000), ZoneOffset.UTC).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        return localDateTime;
    }

    @NotNull
    public static final String formatTimestamp(@NotNull LocalDateTime $this$formatTimestamp, boolean shorten) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTimestamp, (String)"<this>");
        LocalDateTime ldt = $this$formatTimestamp;
        if (shorten) {
            OffsetDateTime now = OffsetDateTime.now();
            if (ldt.getYear() == now.getYear() && ldt.getDayOfYear() == now.getDayOfYear()) {
                String string = TIME_FORMATTER.format(ldt);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                return string;
            }
            OffsetDateTime yesterday = now.minusDays(1L);
            if (ldt.getYear() == yesterday.getYear() && ldt.getDayOfYear() == yesterday.getDayOfYear()) {
                return "Yesterday";
            }
            if (ldt.getYear() == now.getYear()) {
                String string = DATE_FORMATTER.format(ldt);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                return string;
            }
            String string = DATE_WITH_YEAR_FORMATTER.format(ldt);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }
        String string = FULL_FORMATTER.format(ldt);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

